!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE READ_DEFAULT_ISBA_n (CHI, DE, DGO, DMI, DUI, IO, HPROGRAM)
!     #######################################################
!
!!****  *READ_ISBA_CONF* - routine to read the configuration for ISBA
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003 
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
!
!
USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_t
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
USE MODD_DIAG_UTCI_n, ONLY : DIAG_UTCI_t


!
USE MODE_MODELN_SURFEX_HANDLER
!
USE MODE_POS_SURF
!
USE MODI_GET_LUOUT
USE MODI_GET_DEFAULT_NAM_n
!
USE MODN_ISBA_n
!
USE MODD_READ_NAMELIST, ONLY : LNAM_READ
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DE
TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DMI
TYPE(DIAG_UTCI_t), INTENT(INOUT) :: DUI
TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling ISBA

!
!*       0.2   Declarations of local variables
!              -------------------------------
!
!
LOGICAL           :: GFOUND         ! Return code when searching namelist
INTEGER           :: ILUOUT         ! output listing logical unit
INTEGER           :: ILUDES         ! .des file logical unit
INTEGER           :: IMI
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('READ_DEFAULT_ISBA_N',0,ZHOOK_HANDLE)
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
 CALL GET_DEFAULT_NAM_n(HPROGRAM,'READ ',ILUDES)
!
IF (ILUDES==0 .AND. LHOOK) CALL DR_HOOK('READ_DEFAULT_ISBA_N',1,ZHOOK_HANDLE)
IF (ILUDES==0) RETURN
!
IMI=GET_CURRENT_MODEL_INDEX_SURFEX()
!
IF (IMI.NE.-1 .AND. LNAM_READ) THEN
 CALL INIT_NAM_ISBAn(IO)
 CALL INIT_NAM_ISBA_AGSn(IO)
 CALL INIT_NAM_SGH_ISBAn(IO)
 CALL INIT_NAM_DIAG_SURFn(DGO)
 CALL INIT_NAM_DIAG_ISBAn(DE, DGO, DMI, DUI)
 CALL INIT_NAM_CH_CONTROLn(CHI)
 CALL INIT_NAM_CH_ISBAn(CHI)
 CALL INIT_NAM_SPINUP_CARB_ISBAn(IO)
 CALL INIT_NAM_ISBA_SNOWn(IO)
ENDIF
!
IF (LNAM_READ) THEN
 !
 !* reading of new defaults in file
 !  -------------------------------
 !
 CALL POSNAM(ILUDES,'NAM_ISBAN',GFOUND,ILUOUT)
 IF (GFOUND) READ(UNIT=ILUDES,NML=NAM_ISBAn)
 CALL POSNAM(ILUDES,'NAM_ISBA_AGSN',GFOUND,ILUOUT)
 IF (GFOUND) READ(UNIT=ILUDES,NML=NAM_ISBA_AGSn) 
 CALL POSNAM(ILUDES,'NAM_SGH_ISBAN',GFOUND,ILUOUT)
 IF (GFOUND) READ(UNIT=ILUDES,NML=NAM_SGH_ISBAn)
 CALL POSNAM(ILUDES,'NAM_DIAG_SURFN',GFOUND,ILUOUT)
 IF (GFOUND) READ(UNIT=ILUDES,NML=NAM_DIAG_SURFn)
 CALL POSNAM(ILUDES,'NAM_DIAG_ISBAN',GFOUND,ILUOUT)
 IF (GFOUND) READ(UNIT=ILUDES,NML=NAM_DIAG_ISBAn)
 CALL POSNAM(ILUDES,'NAM_CH_CONTROLN',GFOUND,ILUOUT)
 IF (GFOUND) READ(UNIT=ILUDES,NML=NAM_CH_CONTROLn)
 CALL POSNAM(ILUDES,'NAM_CH_ISBAN',GFOUND,ILUOUT)
 IF (GFOUND) READ(UNIT=ILUDES,NML=NAM_CH_ISBAn)
 CALL POSNAM(ILUDES,'NAM_SPINUP_CARBN',GFOUND,ILUOUT)
 IF (GFOUND) READ(UNIT=ILUDES,NML=NAM_SPINUP_CARBn)
 CALL POSNAM(ILUDES,'NAM_ISBA_SNOWN',GFOUND,ILUOUT)
 IF (GFOUND) READ(UNIT=ILUDES,NML=NAM_ISBA_SNOWn) 
ENDIF

IF (IMI.NE.-1) THEN
 CALL UPDATE_NAM_ISBAn(IO)
 CALL UPDATE_NAM_ISBA_AGSn(IO)
 CALL UPDATE_NAM_SGH_ISBAn(IO)
 CALL UPDATE_NAM_DIAG_SURFn(DGO)
 CALL UPDATE_NAM_DIAG_ISBAn(DE, DGO, DMI, DUI)
 CALL UPDATE_NAM_CH_CONTROLn(CHI)
 CALL UPDATE_NAM_CH_ISBAn(CHI)
 CALL UPDATE_NAM_SPINUP_CARB_ISBAn(IO)
 CALL UPDATE_NAM_ISBA_SNOWn(IO) 
ENDIF
IF (LHOOK) CALL DR_HOOK('READ_DEFAULT_ISBA_N',1,ZHOOK_HANDLE)

!
!-------------------------------------------------------------------------------
!
END SUBROUTINE READ_DEFAULT_ISBA_n
