!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     ##################
      MODULE MODN_TEB_n
!     ##################
!
!!****  *MODN_TEB_n* - declaration of namelist NAM_TEBn
!!
!!    PURPOSE
!!    -------
!       The purpose of this module is to specify  the namelist NAM_TEBn
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!       
!!    AUTHOR
!!    ------
!!      V. Masson    *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004                   
!!      Modified    10/2004 by P. Le Moigne: miscellaneous switch
!!      Modified    07/2007 by P. Le Moigne: minimum wind speed and/or shear
!!      Modified    08/2009 by B. Decharme : LSURF_BUDGETC for all tiles
!!      Modified    08/2012 by G. Pigeon : CH_BEM for conv. coef option
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
LOGICAL           :: LPGD
LOGICAL           :: L2M_MIN_ZS         
LOGICAL           :: LSURF_BUDGET
LOGICAL           :: LRAD_BUDGET
LOGICAL           :: LCOEF
LOGICAL           :: LSURF_VARS
LOGICAL           :: LSURF_MISC_BUDGET
LOGICAL           :: LSURF_DIAG_ALBEDO
LOGICAL           :: LUTCI
LOGICAL           :: LSURF_BUDGETC
LOGICAL           :: LRESET_BUDGETC
!
 CHARACTER(LEN=6)  :: CCH_DRY_DEP
 CHARACTER(LEN=6)  :: CZ0H
 CHARACTER(LEN=5)  :: CCH_BEM
!
REAL              :: XTSTEP
REAL              :: XOUT_TSTEP
REAL              :: XDIAG_TSTEP
!
INTEGER           :: N2M
!
NAMELIST/NAM_DIAG_SURFn/N2M,L2M_MIN_ZS,LSURF_BUDGET,LRAD_BUDGET, &
                        LCOEF,LSURF_VARS, LSURF_BUDGETC, LRESET_BUDGETC
!
NAMELIST/NAM_CH_TEBn/CCH_DRY_DEP
NAMELIST/NAM_DIAG_TEBn/LPGD,LSURF_MISC_BUDGET,LSURF_DIAG_ALBEDO,LUTCI
NAMELIST/NAM_TEBn/CZ0H,CCH_BEM
!
CONTAINS
!
SUBROUTINE INIT_NAM_DIAG_SURFn (DGO, TOP)
!
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
  USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:INIT_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  XTSTEP = TOP%XTSTEP
  XOUT_TSTEP = TOP%XOUT_TSTEP  
  XDIAG_TSTEP = DGO%XDIAG_TSTEP  
  N2M = DGO%N2M
  L2M_MIN_ZS = DGO%L2M_MIN_ZS
  LSURF_BUDGET = DGO%LSURF_BUDGET
  LRAD_BUDGET = DGO%LRAD_BUDGET
  LCOEF = DGO%LCOEF
  LSURF_VARS = DGO%LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:INIT_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_SURFn

SUBROUTINE UPDATE_NAM_DIAG_SURFn (DGO)
!
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:UPDATE_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  DGO%XDIAG_TSTEP = XDIAG_TSTEP  
  DGO%N2M = N2M
  DGO%L2M_MIN_ZS = L2M_MIN_ZS
  DGO%LSURF_BUDGET = LSURF_BUDGET
  DGO%LRAD_BUDGET = LRAD_BUDGET 
  DGO%LCOEF = LCOEF
  DGO%LSURF_VARS = LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:UPDATE_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_SURFn
!
SUBROUTINE INIT_NAM_TEBn (T, TOP)
!
  USE MODD_TEB_n, ONLY : TEB_t
  USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(TEB_t), INTENT(INOUT) :: T
  TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:INIT_NAM_TEBN',0,ZHOOK_HANDLE)
  CZ0H = TOP%CZ0H
  CCH_BEM = TOP%CCH_BEM
IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:INIT_NAM_TEBN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_TEBn

SUBROUTINE UPDATE_NAM_TEBn (T, TOP)
!
  USE MODD_TEB_n, ONLY : TEB_t
  USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(TEB_t), INTENT(INOUT) :: T
  TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:UPDATE_NAM_TEBN',0,ZHOOK_HANDLE)
  TOP%XTSTEP = XTSTEP
  TOP%XOUT_TSTEP = XOUT_TSTEP    
  TOP%CZ0H = CZ0H
  TOP%CCH_BEM = CCH_BEM
IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:UPDATE_NAM_TEBN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_TEBn

SUBROUTINE INIT_NAM_CH_TEBn (CHT)
!
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!
  IMPLICIT NONE

!
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:INIT_NAM_CH_TEBN',0,ZHOOK_HANDLE)
  CCH_DRY_DEP = CHT%CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:INIT_NAM_CH_TEBN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_TEBn

SUBROUTINE UPDATE_NAM_CH_TEBn (CHT)
!
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!
  IMPLICIT NONE

!
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:UPDATE_NAM_CH_TEBN',0,ZHOOK_HANDLE)
  CHT%CCH_DRY_DEP = CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:UPDATE_NAM_CH_TEBN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_TEBn

SUBROUTINE INIT_NAM_DIAG_TEBn (DMTO, DGO, DUT)
!
  USE MODD_DIAG_MISC_TEB_OPTIONS_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
  USE MODD_DIAG_UTCI_n, ONLY : DIAG_UTCI_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DMTO
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  TYPE(DIAG_UTCI_t), INTENT(INOUT) :: DUT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:INIT_NAM_DIAG_TEBN',0,ZHOOK_HANDLE)
  LPGD = DGO%LPGD
  LSURF_MISC_BUDGET = DMTO%LSURF_MISC_BUDGET
  LSURF_DIAG_ALBEDO = DMTO%LSURF_DIAG_ALBEDO
  LUTCI = DUT%LUTCI
IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:INIT_NAM_DIAG_TEBN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_TEBn

SUBROUTINE UPDATE_NAM_DIAG_TEBn (DMTO, DGO, DUT)
!
  USE MODD_DIAG_MISC_TEB_OPTIONS_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
  USE MODD_DIAG_UTCI_n, ONLY : DIAG_UTCI_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DMTO
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  TYPE(DIAG_UTCI_t), INTENT(INOUT) :: DUT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:UPDATE_NAM_DIAG_TEBN',0,ZHOOK_HANDLE)
  DGO%LPGD = LPGD
  DMTO%LSURF_MISC_BUDGET = LSURF_MISC_BUDGET
  DMTO%LSURF_DIAG_ALBEDO = LSURF_DIAG_ALBEDO
  DUT%LUTCI = LUTCI
IF (LHOOK) CALL DR_HOOK('MODN_TEB_N:UPDATE_NAM_DIAG_TEBN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_TEBn

END MODULE MODN_TEB_n
