!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     ###############################################################################
SUBROUTINE COUPLING_TEB_n (DTCO, DST, SLT, TOP, SB, G, CHT, NT, TPN, TIR, BOP, NB, TD, GDM, GRM, HM, &
     HPROGRAM, HCOUPLING, PTSTEP, KYEAR, KMONTH, KDAY, PTIME, KI, KSV,&
     KSW, PTSUN, PZENITH, PAZIM, PZREF, PUREF, PZS, PU, PV, PQA, PTA, &
     PRHOA, PSV, PCO2, HSV, PRAIN, PSN, PLW, PDIR_SW, PSCA_SW,        &
     PSW_BANDS, PPS, PPA, PSFTQ, PSFTH, PSFTS, PSFCO2, PSFU, PSFV,    &
     PTRAD, PDIR_ALB, PSCA_ALB, PEMIS, PTSURF, PZ0, PZ0H, PQSURF,     &
     PPEW_A_COEF, PPEW_B_COEF, PPET_A_COEF, PPEQ_A_COEF, PPET_B_COEF, &
     PPEQ_B_COEF, HTEST     )
  !     ###############################################################################
  !
  !!****  *COUPLING_TEB_n * - Driver for TEB 
  !!
  !!    PURPOSE
  !!    -------
  !
  !!**  METHOD
  !!    ------
  !!
  !!    REFERENCE
  !!    ---------
  !!      
  !!
  !!    AUTHOR
  !!    ------
  !!     V. Masson 
  !!
  !!    MODIFICATIONS
  !!    -------------
  !!      Original    01/2004
  !!                  10/2005 (G.Pigeon) transfer of domestic heating
  !!      S. Riette   06/2009 Initialisation of XT, XQ, XU and XTKE on canopy levels
  !!      S. Riette   01/2010 Use of interpol_sbl to compute 10m wind diagnostic
  !!      G. Pigeon   09/2012 CCH_BEM, ROUGH_WALL, ROUGH_ROOF for building conv. coef
  !!      G. Pigeon   10/2012 XF_WIN_WIN as arg. of TEB_GARDEN
  !!      B. Decharme 09/2012 New wind implicitation
  !!      J. Escobar  09/2012 KI not allowed without-interface , replace by KI
  !!      V. Masson   08/2013 adds solar panels & occupation calendar
  !!      B. Decharme 04/2013 new coupling variables
  !!      M. Goret    02/2017 add heating fractions and CO2 conversion factors as arg. of TEB_GARDEN
  !!      M. Goret    03/2017 add traffic flux modulation
  !!      A. Lemonsu  06/2017 utci calculations with urban trees
  !!      M. Goret    04/2017 suppress PEFF_HEAT as arg. of TEB_GARDEN
  !!      M. Goret    07/2017 move CO2 flux diagnostics from DGT to DGMT
  !!      M. Goret    07/2017 add heating energy consumption by source
  !!      M. Goret    07/2017 add anthropogenic flux diagnostics
  !!      M. Goret    09/2017 add diagnostic of heat storage link to snow
  !!      M. Goret    10/2017 add hot water 
  !!---------------------------------------------------------------
  !
  USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
  USE MODD_DST_n, ONLY : DST_t
  USE MODD_SLT_n, ONLY : SLT_t
  !
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
  USE MODD_CANOPY_n, ONLY: CANOPY_t
  USE MODD_SFX_GRID_n, ONLY : GRID_t
  USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
  USE MODD_TEB_PANEL_n, ONLY : TEB_PANEL_t
  USE MODD_TEB_IRRIG_n, ONLY : TEB_IRRIG_t
  USE MODD_TEB_n, ONLY : TEB_NP_t
  USE MODD_SURFEX_n, ONLY : TEB_DIAG_t
  USE MODD_BEM_OPTION_n, ONLY : BEM_OPTIONS_t
  USE MODD_BEM_n, ONLY : BEM_NP_t
  USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
  !
  USE MODD_SURFEX_n, ONLY : TEB_GARDEN_MODEL_t
  USE MODD_SURFEX_n, ONLY : TEB_GREENROOF_MODEL_t
  USE MODD_SURFEX_n, ONLY : TEB_HYDRO_MODEL_t
  !
  USE MODD_REPROD_OPER, ONLY : CIMPLICIT_WIND
  !
  USE MODD_CSTS,         ONLY : XRD, XCPD, XP00, XLVTT, XLSTT, XSURF_EPSILON, &
       XPI, XKARMAN, XG, XRV, XSTEFAN, XTT, XBOLTZ
  USE MODD_SURF_PAR,     ONLY : XUNDEF
  !
  !                              
  USE MODD_DST_SURF
  USE MODD_SLT_SURF
  !
  USE MODE_DSLT_SURF
  USE MODE_THERMOS
  USE MODE_SBLS
  !
  USE MODI_AVERAGE_RAD
  USE MODI_SM10
  USE MODI_ADD_FORECAST_TO_DATE_SURF
  USE MODI_DIAG_INLINE_TEB_n
  USE MODI_CH_AER_DEP
  USE MODI_CH_DEP_TOWN
  USE MODI_DSLT_DEP
  USE MODI_TEB_GARDEN
  USE MODI_TEB_CANOPY
  USE MODI_TRAFFIC_FLUX_MODULATION
  ! 
  USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
  USE PARKIND1  ,ONLY : JPRB
  !
  USE MODI_ABOR1_SFX
  USE MODI_CANOPY_EVOL
  USE MODI_CANOPY_GRID_UPDATE
  USE MODI_UTCI_TEB
  USE MODI_UTCIC_STRESS
  USE MODI_CIRCUMSOLAR_RAD
  USE MODI_CUMUL_DIAG_TEB_n
  !
  IMPLICIT NONE
  !
  !*      0.1    declarations of arguments
  !
  !
  !
  TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
  TYPE(DST_t), INTENT(INOUT) :: DST
  TYPE(SLT_t), INTENT(INOUT) :: SLT
  !
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT 
  TYPE(CANOPY_t), INTENT(INOUT) :: SB
  TYPE(GRID_t), INTENT(INOUT) :: G
  TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
  TYPE(TEB_PANEL_t), INTENT(INOUT) :: TPN
  TYPE(TEB_IRRIG_t), INTENT(INOUT) :: TIR
  TYPE(TEB_NP_t), INTENT(INOUT) :: NT
  !
  TYPE(TEB_DIAG_t), INTENT(INOUT) :: TD
  !
  TYPE(BEM_OPTIONS_t), INTENT(INOUT) :: BOP 
  TYPE(BEM_NP_t), INTENT(INOUT) :: NB
  !
  TYPE(TEB_GARDEN_MODEL_t), INTENT(INOUT) :: GDM
  TYPE(TEB_GREENROOF_MODEL_t), INTENT(INOUT) :: GRM
  TYPE(TEB_HYDRO_MODEL_t), INTENT(INOUT) :: HM
  !
  CHARACTER(LEN=6),    INTENT(IN)  :: HPROGRAM  ! program calling surf. schemes
  CHARACTER(LEN=1),    INTENT(IN)  :: HCOUPLING ! type of coupling
  ! 'E' : explicit
  ! 'I' : implicit
  INTEGER,             INTENT(IN)  :: KYEAR     ! current year (UTC)
  INTEGER,             INTENT(IN)  :: KMONTH    ! current month (UTC)
  INTEGER,             INTENT(IN)  :: KDAY      ! current day (UTC)
  REAL,                INTENT(IN)  :: PTIME     ! current time since midnight (UTC, s)
  INTEGER,             INTENT(IN)  :: KI        ! number of points
  INTEGER,             INTENT(IN)  :: KSV       ! number of scalars
  INTEGER,             INTENT(IN)  :: KSW       ! number of short-wave spectral bands
  REAL, DIMENSION(KI), INTENT(IN)  :: PTSUN     ! solar time                    (s from midnight)
  REAL,                INTENT(IN)  :: PTSTEP    ! atmospheric time-step                 (s)
  REAL, DIMENSION(KI), INTENT(IN)  :: PZREF     ! height of T,q forcing                 (m)
  REAL, DIMENSION(KI), INTENT(IN)  :: PUREF     ! height of wind forcing                (m)
  !
  REAL, DIMENSION(KI), INTENT(IN)  :: PTA       ! air temperature forcing               (K)
  REAL, DIMENSION(KI), INTENT(IN)  :: PQA       ! air humidity forcing                  (kg/m3)
  REAL, DIMENSION(KI), INTENT(IN)  :: PRHOA     ! air density                           (kg/m3)
  REAL, DIMENSION(KI,KSV),INTENT(IN) :: PSV     ! scalar variables
  !                                             ! chemistry:   first char. in HSV: '#'  (molecule/m3)
  !                                             !
  CHARACTER(LEN=6), DIMENSION(KSV),INTENT(IN):: HSV  ! name of all scalar variables
  REAL, DIMENSION(KI), INTENT(IN)  :: PU        ! zonal wind                            (m/s)
  REAL, DIMENSION(KI), INTENT(IN)  :: PV        ! meridian wind                         (m/s)
  REAL, DIMENSION(KI,KSW),INTENT(IN) :: PDIR_SW ! direct  solar radiation (on horizontal surf.)
  !                                             !                                       (W/m2)
  REAL, DIMENSION(KI,KSW),INTENT(IN) :: PSCA_SW ! diffuse solar radiation (on horizontal surf.)
  !                                             !                                       (W/m2)
  REAL, DIMENSION(KSW),INTENT(IN)  :: PSW_BANDS ! mean wavelength of each shortwave band (m)
  REAL, DIMENSION(KI), INTENT(IN)  :: PZENITH   ! zenithal angle       (radian from the vertical)
  REAL, DIMENSION(KI), INTENT(IN)  :: PAZIM     ! azimuthal angle      (radian from North, clockwise)
  REAL, DIMENSION(KI), INTENT(IN)  :: PLW       ! longwave radiation (on horizontal surf.)
  !                                             !                                       (W/m2)
  REAL, DIMENSION(KI), INTENT(IN)  :: PPS       ! pressure at atmospheric model surface (Pa)
  REAL, DIMENSION(KI), INTENT(IN)  :: PPA       ! pressure at forcing level             (Pa)
  REAL, DIMENSION(KI), INTENT(IN)  :: PZS       ! atmospheric model orography           (m)
  REAL, DIMENSION(KI), INTENT(IN)  :: PCO2      ! CO2 concentration in the air          (kg/m3)
  REAL, DIMENSION(KI), INTENT(IN)  :: PSN     ! snow precipitation                    (kg/m2/s)
  REAL, DIMENSION(KI), INTENT(IN)  :: PRAIN     ! liquid precipitation                  (kg/m2/s)
  !
  REAL, DIMENSION(KI), INTENT(OUT) :: PSFTH     ! flux of heat                          (W/m2)
  REAL, DIMENSION(KI), INTENT(OUT) :: PSFTQ     ! flux of water vapor                   (kg/m2/s)
  REAL, DIMENSION(KI), INTENT(OUT) :: PSFU      ! zonal momentum flux                   (Pa)
  REAL, DIMENSION(KI), INTENT(OUT) :: PSFV      ! meridian momentum flux                (Pa)
  REAL, DIMENSION(KI), INTENT(OUT) :: PSFCO2    ! flux of CO2                           (m/s*kg_CO2/kg_air)
  REAL, DIMENSION(KI,KSV),INTENT(OUT):: PSFTS   ! flux of scalar var.                   (kg/m2/s)
  !
  REAL, DIMENSION(KI), INTENT(OUT) :: PTRAD     ! radiative temperature                 (K)
  REAL, DIMENSION(KI,KSW),INTENT(OUT):: PDIR_ALB! direct albedo for each spectral band  (-)
  REAL, DIMENSION(KI,KSW),INTENT(OUT):: PSCA_ALB! diffuse albedo for each spectral band (-)
  REAL, DIMENSION(KI), INTENT(OUT) :: PEMIS     ! emissivity                            (-)
  !
  REAL, DIMENSION(KI), INTENT(OUT) :: PTSURF    ! surface effective temperature         (K)
  REAL, DIMENSION(KI), INTENT(OUT) :: PZ0       ! roughness length for momentum         (m)
  REAL, DIMENSION(KI), INTENT(OUT) :: PZ0H      ! roughness length for heat             (m)
  REAL, DIMENSION(KI), INTENT(OUT) :: PQSURF    ! specific humidity at surface          (kg/kg)
  !
  REAL, DIMENSION(KI), INTENT(IN) :: PPEW_A_COEF! implicit coefficients
  REAL, DIMENSION(KI), INTENT(IN) :: PPEW_B_COEF! needed if HCOUPLING='I'
  REAL, DIMENSION(KI), INTENT(IN) :: PPET_A_COEF
  REAL, DIMENSION(KI), INTENT(IN) :: PPEQ_A_COEF
  REAL, DIMENSION(KI), INTENT(IN) :: PPET_B_COEF
  REAL, DIMENSION(KI), INTENT(IN) :: PPEQ_B_COEF
  CHARACTER(LEN=2),    INTENT(IN) :: HTEST ! must be equal to 'OK'
  !
  !
  !*      0.2    declarations of local variables
  !
  INTEGER              :: JSWB                ! loop counter on shortwave spectral bands
  !         
  REAL, DIMENSION(KI)  :: ZQA                 ! specific humidity                 (kg/kg)
  REAL, DIMENSION(KI)  :: ZEXNA               ! Exner function at forcing level
  REAL, DIMENSION(KI)  :: ZEXNS               ! Exner function at surface level
  REAL, DIMENSION(KI)  :: ZWIND               ! wind
  !
  ! Ouput Diagnostics:
  !
  REAL, DIMENSION(KI)  :: ZU_CANYON           ! wind in canyon
  REAL, DIMENSION(KI)  :: ZT_CANYON           ! temperature in canyon
  REAL, DIMENSION(KI)  :: ZQ_CANYON           ! specific humidity in canyon
  REAL, DIMENSION(KI)  :: ZT_CAN              ! temperature in canyon       (evolving in TEB)
  REAL, DIMENSION(KI)  :: ZQ_CAN              ! specific humidity in canyon (evolving in TEB)
  REAL, DIMENSION(KI)  :: ZTS_HVEG            ! temperature of high vegetation
  !
  REAL, DIMENSION(KI)  :: ZPEW_A_COEF   ! implicit coefficients
  REAL, DIMENSION(KI)  :: ZPEW_B_COEF   ! needed if HCOUPLING='I'
  REAL, DIMENSION(KI) :: ZU_LOWCAN  ! wind speed at lowest canyon level (m/s)
  REAL, DIMENSION(KI) :: ZT_LOWCAN  ! temperature at lowest canyon level (K)
  REAL, DIMENSION(KI) :: ZQ_LOWCAN  ! humidity    at lowest canyon level (kg/kg)
  REAL, DIMENSION(KI) :: ZZ_LOWCAN  ! height      of lowest canyon level (m)
  !
  REAL, DIMENSION(KI) :: ZPEW_A_COEF_LOWCAN  ! implicit coefficients for wind coupling
  REAL, DIMENSION(KI) :: ZPEW_B_COEF_LOWCAN  ! between first canopy level and road
  !
  REAL, DIMENSION(KI) :: ZTA        ! temperature at canyon level just above roof (K)
  REAL, DIMENSION(KI) :: ZPA        ! pressure    at canyon level just above roof (K)
  REAL, DIMENSION(KI) :: ZUA        ! wind        at canyon level just above roof (m/s)
  REAL, DIMENSION(KI) :: ZUREF      ! height      of canyon level just above roof (m)
  REAL, DIMENSION(KI) :: ZZREF      ! height      of canyon level just above roof (m)
  !
  REAL, DIMENSION(KI)  :: ZDIR_SW       ! total direct SW
  REAL, DIMENSION(KI)  :: ZSCA_SW       ! total diffuse SW
  REAL, DIMENSION(KI) :: ZAVG_SCA_SW
  REAL, DIMENSION(KI) :: ZAVG_DIR_SW 
  REAL, DIMENSION(KI) :: ZAVG_DIR_SW_ROAD
  REAL, DIMENSION(KI,SIZE(PDIR_SW,2))  :: ZDIR_SWB ! total direct SW per band
  REAL, DIMENSION(KI,SIZE(PSCA_SW,2))  :: ZSCA_SWB ! total diffuse SW per band
  !
  REAL, DIMENSION(KI)  :: ZAVG_H_WL
  REAL, DIMENSION(KI)  :: ZAVG_E_WL
  !
  REAL, DIMENSION(KI,BOP%NBEMCOMP)  :: ZAVG_TI_BLD
  REAL, DIMENSION(KI,BOP%NBEMCOMP)  :: ZAVG_QI_BLD
  !
  REAL, DIMENSION(KI)  :: ZRN_GRND    ! net radiation on ground built surf
  REAL, DIMENSION(KI)  :: ZH_GRND     ! sensible heat flux on ground built surf
  REAL, DIMENSION(KI)  :: ZLE_GRND    ! latent heat flux on ground built surf
  REAL, DIMENSION(KI)  :: ZGFLX_GRND ! storage flux in ground built surf
  REAL, DIMENSION(KI)  :: ZUW_GRND      ! momentum flux for ground built surf
  REAL, DIMENSION(KI)  :: ZDUWDU_GRND   !
  REAL, DIMENSION(KI) :: ZEMIT_LW_GRND
  REAL, DIMENSION(KI) :: ZEMIT_LW_FAC
  REAL, DIMENSION(KI) :: ZEMIT_LW_HVEG
  REAL, DIMENSION(KI)  :: ZAVG_UW_GRND
  REAL, DIMENSION(KI)  :: ZAVG_DUWDU_GRND
  REAL, DIMENSION(KI)  :: ZAVG_UW_ROOF
  REAL, DIMENSION(KI)  :: ZAVG_DUWDU_ROOF
  REAL, DIMENSION(KI)  :: ZAVG_H_GRND
  REAL, DIMENSION(KI)  :: ZAVG_E_GRND
  REAL, DIMENSION(KI)  :: ZAVG_H_WALL
  REAL, DIMENSION(KI)  :: ZAVG_E_WALL
  REAL, DIMENSION(KI)  :: ZAVG_H_ROOF
  REAL, DIMENSION(KI)  :: ZAVG_E_ROOF
  REAL, DIMENSION(KI,SB%NLVL) :: ZAVG_DH_HVEG
  REAL, DIMENSION(KI,SB%NLVL) :: ZAVG_DE_HVEG
  REAL, DIMENSION(KI)  :: ZAVG_AC_GRND
  REAL, DIMENSION(KI)  :: ZAVG_AC_GRND_WAT
  REAL, DIMENSION(KI) :: ZSCA_SW_SKY  ! diff solar rad from the sky received by people (incl attenuation by trees)
  REAL, DIMENSION(KI) :: ZLW_RAD_SKY  ! IR rad from the sky received by people (incl attenuation by trees)
  !
  REAL, DIMENSION(KI)  :: ZRESA_TOWN          ! aerodynamical resistance
  REAL, DIMENSION(KI)  :: ZAC_GRND            ! ground built surf aerodynamical conductance
  REAL, DIMENSION(KI)  :: ZAC_GRND_WAT        ! ground built surf water aerodynamical conductance
  !
  REAL, DIMENSION(KI)  :: ZLEW_RF   ! latent heat flux on snowfree roof
  REAL, DIMENSION(KI)  :: ZRNSN_RF  ! net radiation over snow
  REAL, DIMENSION(KI)  :: ZHSN_RF   ! sensible heat flux over snow
  REAL, DIMENSION(KI)  :: ZLESN_RF  ! latent heat flux over snow
  REAL, DIMENSION(KI)  :: ZGSN_RF   ! flux under the snow
  REAL, DIMENSION(KI)  :: ZMELT_RF    ! snow melt
  REAL, DIMENSION(KI)  :: ZUW_RF      ! momentum flux for roofs
  REAL, DIMENSION(KI)  :: ZDUWDU_RF   !
  REAL, DIMENSION(KI)  :: ZAVG_UW_RF
  REAL, DIMENSION(KI)  :: ZAVG_DUWDU_RF
  REAL, DIMENSION(KI)  :: ZAVG_H_RF
  REAL, DIMENSION(KI)  :: ZAVG_E_RF
  !
  REAL, DIMENSION(KI)  :: ZLEW_RD   ! latent heat flux on snowfree road
  REAL, DIMENSION(KI)  :: ZRNSN_RD  ! net radiation over snow
  REAL, DIMENSION(KI)  :: ZHSN_RD   ! sensible heat flux over snow
  REAL, DIMENSION(KI)  :: ZLESN_RD  ! latent heat flux over snow
  REAL, DIMENSION(KI)  :: ZGSN_RD   ! flux under the snow
  REAL, DIMENSION(KI)  :: ZMELT_RD    ! snow melt
  REAL, DIMENSION(KI)  :: ZAC_RD      ! road aerodynamical conductance
  REAL, DIMENSION(KI)  :: ZAC_RD_WAT  ! road water aerodynamical conductance
  !
  REAL, DIMENSION(KI)  :: ZAC_GD    ! green area aerodynamical conductance
  REAL, DIMENSION(KI)  :: ZAC_GD_WAT! green area water aerodynamical conductance
  !
  REAL, DIMENSION(KI)  :: ZAC_GRF ! green roof aerodynamical conductance
  REAL, DIMENSION(KI)  :: ZAC_GRF_WAT! green roof water aerodynamical conductance
  !
  REAL, DIMENSION(KI)  :: ZTRAD         ! radiative temperature for current patch
  REAL, DIMENSION(KI)  :: ZEMIS         ! emissivity for current patch
  REAL, DIMENSION(KI,TOP%NTEB_PATCH) :: ZTRAD_PATCH ! radiative temperature for each patch
  REAL, DIMENSION(KI,TOP%NTEB_PATCH) :: ZEMIS_PATCH ! emissivity for each patch
  REAL, DIMENSION(KI)  :: ZNET_LW_HVEG 

  REAL, DIMENSION(KI)  :: ZFLUXFLOOR          ! Heat flux into the ground floor
  REAL, DIMENSION(KI)  :: ZFLX_BLD_ROOF       ! Heat exchange between roof and indoor air
  REAL, DIMENSION(KI)  :: ZFLX_BLD_WALL_A     ! Heat exchange between wall A and indoor air
  REAL, DIMENSION(KI)  :: ZFLX_BLD_WALL_B     ! Heat exchange between wall B and indoor air
  !
  REAL, DIMENSION(KI,SB%NLVL) :: ZLAD_CAN  ! vertical profile of Leaf Area Density on canopy grid
  REAL, DIMENSION(KI,SB%NLVL) :: ZDH_HVEG ! sensible heat flux from trees discretized on caopy grid
  REAL, DIMENSION(KI,SB%NLVL) :: ZDLE_HVEG! latent heat flux from trees discretized on caopy grid
  !
  REAL, DIMENSION(KI)  :: ZHEAT_RR_ROAD
  REAL, DIMENSION(KI)  :: ZHEAT_RR_ROOF
  !
  REAL, DIMENSION(KI)  :: ZDIR_ALB      ! direct albedo of town
  REAL, DIMENSION(KI)  :: ZSCA_ALB      ! diffuse albedo of town
  REAL, DIMENSION(KI,KSW,TOP%NTEB_PATCH) :: ZDIR_ALB_PATCH ! direct albedo per wavelength and patch
  REAL, DIMENSION(KI,KSW,TOP%NTEB_PATCH) :: ZSCA_ALB_PATCH ! diffuse albedo per wavelength and patch
  !
  REAL, DIMENSION(KI) :: ZSEN_SNOW_DIF_ROAD ! Sensible heat due to snowfall on road
  REAL, DIMENSION(KI) :: ZSEN_SNOW_DIF_ROOF ! Sensible heat due to snowfall on roof
  !
  REAL, DIMENSION(KI)  :: ZRI           ! Richardson number
  REAL, DIMENSION(KI)  :: ZCD           ! drag coefficient
  REAL, DIMENSION(KI)  :: ZCDN          ! neutral drag coefficient
  REAL, DIMENSION(KI)  :: ZCH           ! heat drag
  REAL, DIMENSION(KI)  :: ZRN           ! net radiation over town
  REAL, DIMENSION(KI)  :: ZH            ! sensible heat flux over town
  REAL, DIMENSION(KI)  :: ZLE           ! latent heat flux over town
  REAL, DIMENSION(KI)  :: ZGFLX        ! flux through the ground
  REAL, DIMENSION(KI)  :: ZQF           ! anthropogenic flux over town
  REAL, DIMENSION(KI)  :: ZEVAP         ! evaporation (km/m2/s)
  !
  REAL, DIMENSION(KI) :: ZSEN_GREENROOF
  REAL, DIMENSION(KI) :: ZLAT_GREENROOF
  !
  REAL, DIMENSION(KI)  :: ZAVG_T_CANYON       ! temperature in canyon for town 
  REAL, DIMENSION(KI)  :: ZAVG_Q_CANYON       ! specific humidity in canyon for town
  REAL, DIMENSION(KI)  :: ZAVG_CD       ! aggregated drag coefficient
  REAL, DIMENSION(KI)  :: ZAVG_CDN      ! aggregated neutral drag coefficient
  REAL, DIMENSION(KI)  :: ZAVG_RI       ! aggregated Richardson number
  REAL, DIMENSION(KI)  :: ZAVG_CH       ! aggregated Heat transfer coefficient
  !
  ! new local variables after BEM
  !
  REAL, DIMENSION(KI)  :: ZUSTAR        ! friction velocity
  REAL, DIMENSION(KI)  :: ZSFU          ! momentum flux for patch (U direction)
  REAL, DIMENSION(KI)  :: ZSFV          ! momentum flux for patch (V direction)
  !
  REAL, DIMENSION(KI)  :: ZH_TRAFFIC    ! anthropogenic sensible
  !                                     ! heat fluxes due to traffic
  REAL, DIMENSION(KI)  :: ZLE_TRAFFIC   ! anthropogenic latent
  !                                     ! heat fluxes due to traffic
  REAL, DIMENSION(KI)  :: ZTRAF_MODULATION    ! coefficients that have to been applicate to the mean
  ! value to modulate flux link to traffic
  !
  REAL, DIMENSION(KI) :: ZREF_SW_HVEG        ! total solar rad reflected from high veg
  !
  REAL, DIMENSION(KI,BOP%NBEMCOMP) :: ZRHOI
  !
  REAL, DIMENSION(KI) :: ZAVG_Z0_TOWN
  REAL, DIMENSION(KI) :: ZAVG_RESA_TOWN
  REAL, DIMENSION(KI) :: ZAVG_USTAR        ! town avegared Ustar
  REAL, DIMENSION(KI) :: ZAVG_BLD          ! town averaged building fraction
  REAL, DIMENSION(KI) :: ZAVG_BLD_HEIGHT   ! town averaged building height
  REAL, DIMENSION(KI) :: ZAVG_WL_O_HOR     ! town averaged Wall/hor ratio
  REAL, DIMENSION(KI) :: ZAVG_CAN_HW_RATIO ! town averaged road aspect ratio
  REAL, DIMENSION(KI) :: ZAVG_H_LAI_MAX
  REAL, DIMENSION(KI) :: ZAVG_H
  REAL, DIMENSION(KI) :: ZAVG_LE
  REAL, DIMENSION(KI) :: ZAVG_RN
  REAL, DIMENSION(KI) :: ZAVG_GFLX
  REAL, DIMENSION(KI) :: ZAVG_QF
  REAL, DIMENSION(KI) :: ZAVG_REF_SW_GRND
  REAL, DIMENSION(KI) :: ZAVG_REF_SW_FAC
  REAL, DIMENSION(KI) :: ZAVG_REF_SW_HVEG
  REAL, DIMENSION(KI) :: ZAVG_EMIT_LW_FAC
  REAL, DIMENSION(KI) :: ZAVG_EMIT_LW_GRND
  REAL, DIMENSION(KI) :: ZAVG_EMIT_LW_HVEG
  REAL, DIMENSION(KI) :: ZAVG_LW_RAD_SKY
  REAL, DIMENSION(KI) :: ZAVG_SCA_SW_SKY
  REAL, DIMENSION(KI,BOP%NBEMCOMP) :: ZAVG_T_RAD_IND
  REAL, DIMENSION(KI)  :: ZAVG_URBTREE
  REAL, DIMENSION(KI,SB%NLVL) :: ZAVG_LAD_CAN
  !
  REAL, DIMENSION(KI) :: ZLW_WALA_TO_ROAD
  REAL, DIMENSION(KI) :: ZLW_WALB_TO_ROAD
  REAL, DIMENSION(KI) :: ZLW_WIND_TO_ROAD
  REAL, DIMENSION(KI) :: ZLW_WALA_TO_GARD
  REAL, DIMENSION(KI) :: ZLW_WALB_TO_GARD
  REAL, DIMENSION(KI) :: ZLW_WIND_TO_GARD
  REAL, DIMENSION(KI) :: ZLW_ROAD_TO_WIND
  REAL, DIMENSION(KI) :: ZLW_WALL_TO_WIND
  REAL, DIMENSION(KI) :: ZLW_SNOW_TO_WIND
  REAL, DIMENSION(KI) :: ZLW_GARD_TO_WIND
  REAL, DIMENSION(KI) :: ZLW_ROAD_TO_WALA
  REAL, DIMENSION(KI) :: ZLW_GARD_TO_WALA
  REAL, DIMENSION(KI) :: ZLW_SNOW_TO_WALA
  REAL, DIMENSION(KI) :: ZLW_WALB_TO_WALA
  REAL, DIMENSION(KI) :: ZLW_WIND_TO_WALA
  REAL, DIMENSION(KI) :: ZLW_ROAD_TO_WALB
  REAL, DIMENSION(KI) :: ZLW_GARD_TO_WALB
  REAL, DIMENSION(KI) :: ZLW_SNOW_TO_WALB
  REAL, DIMENSION(KI) :: ZLW_WALA_TO_WALB
  REAL, DIMENSION(KI) :: ZLW_WIND_TO_WALB
  REAL, DIMENSION(KI) :: ZLW_WALA_TO_SNOW
  REAL, DIMENSION(KI) :: ZLW_WALB_TO_SNOW
  REAL, DIMENSION(KI) :: ZLW_WIND_TO_SNOW
  !
  REAL, DIMENSION(KI) :: ZTHEWALL
  REAL, DIMENSION(KI) :: ZTHEROOF
  REAL, DIMENSION(KI) :: ZTHEFLOOR
  REAL, DIMENSION(KI) :: ZTHESOILBLD
  REAL, DIMENSION(KI) :: ZTHEMASS
  REAL, DIMENSION(KI) :: ZTHEROAD
  REAL, DIMENSION(KI) :: ZTHEAIRIN
  REAL, DIMENSION(KI) :: ZTHETOTAL
  REAL, DIMENSION(KI) :: ZLATWATROOF
  REAL, DIMENSION(KI) :: ZLATWATROAD
  REAL, DIMENSION(KI) :: ZLATICEROOF
  REAL, DIMENSION(KI) :: ZLATICEROAD
  REAL, DIMENSION(KI) :: ZLATAIRIN
  REAL, DIMENSION(KI) :: ZLATTOTAL
  REAL, DIMENSION(KI) :: ZENETOTAL
  !
  REAL, DIMENSION(KI) :: ZWATER_ROAD
  REAL, DIMENSION(KI) :: ZWATER_BLD
  REAL, DIMENSION(KI) :: ZWATER_GARDEN
  REAL, DIMENSION(KI) :: ZDIFFWATER_ROAD
  REAL, DIMENSION(KI) :: ZDIFFWATER_BLD
  REAL, DIMENSION(KI) :: ZDIFFWATER_GARDEN
  REAL, DIMENSION(KI) :: ZDIFFWATER_TOTAL
  !
  REAL, DIMENSION(KI) :: ZLW_UP
  REAL, DIMENSION(KI) :: ZSW_UP
  REAL, DIMENSION(KI) :: ZSW_DO
  REAL, DIMENSION(KI) :: ZNET_DIAG
  !
  REAL, DIMENSION(KI) :: ZU_UTCI ! wind speed for the UTCI calculation (m/s)
  REAL, DIMENSION(KI) :: ZF1_o_B
  !
  REAL, DIMENSION(KI) :: ZALFAU   ! V+(1) = alfa u'w'(1) + beta
  REAL, DIMENSION(KI) :: ZBETAU   ! V+(1) = alfa u'w'(1) + beta
  REAL, DIMENSION(KI) :: ZALFAT   ! Th+(1) = alfa w'th'(1) + beta
  REAL, DIMENSION(KI) :: ZBETAT   ! Th+(1) = alfa w'th'(1) + beta
  REAL, DIMENSION(KI) :: ZALFAQ   ! Q+(1) = alfa w'q'(1) + beta
  REAL, DIMENSION(KI) :: ZBETAQ   ! Q+(1) = alfa w'q'(1) + beta
  !***** CANOPY  *****
  REAL, DIMENSION(KI) :: ZWAKE      ! reduction of average wind speed
  !                                              ! in canyon due to direction average.
  REAL, DIMENSION(KI) :: ZSFLUX_U  ! Surface flux u'w' (m2/s2)
  REAL, DIMENSION(KI) :: ZSFLUX_T  ! Surface flux w'T' (mK/s)
  REAL, DIMENSION(KI) :: ZSFLUX_Q  ! Surface flux w'q' (kgm2/s)
  REAL, DIMENSION(KI,SB%NLVL)   :: ZFORC_U   ! tendency due to drag force for wind
  REAL, DIMENSION(KI,SB%NLVL)   :: ZDFORC_UDU! formal derivative of
  !                                              ! tendency due to drag force for wind
  REAL, DIMENSION(KI,SB%NLVL)   :: ZFORC_E   ! tendency due to drag force for TKE
  REAL, DIMENSION(KI,SB%NLVL)   :: ZDFORC_EDE! formal derivative of
  !                                              ! tendency due to drag force for TKE
  REAL, DIMENSION(KI,SB%NLVL)   :: ZFORC_T   ! tendency due to drag force for Temp
  REAL, DIMENSION(KI,SB%NLVL)   :: ZDFORC_TDT! formal derivative of
  !                                              ! tendency due to drag force for Temp
  REAL, DIMENSION(KI,SB%NLVL)   :: ZFORC_Q   ! tendency due to drag force for hum
  REAL, DIMENSION(KI,SB%NLVL)   :: ZDFORC_QDQ! formal derivative of
  !                                           ! tendency due to drag force for hum.
  REAL, DIMENSION(KI) :: ZSEN_MELT_ROAD
  REAL, DIMENSION(KI) :: ZSEN_MELT_ROOF
  REAL, DIMENSION(KI) :: ZDIFF_SNOW_WAT_ROAD
  REAL, DIMENSION(KI) :: ZDIFF_SNOW_WAT_ROOF
  !
  REAL, DIMENSION(KI) :: ZLAMBDA_F  ! frontal density (-)
  REAL, DIMENSION(KI) :: ZLMO       ! Monin-Obukhov length at canopy height (m)
  REAL, DIMENSION(KI,SB%NLVL)   :: ZL         ! Mixing length generic profile at mid levels
  REAL, DIMENSION(KI,SB%NLVL)   :: ZLTREE     ! Mixing length generic profile at mid levels
  !
  !
  ! Difference to previous time step
  !
  REAL, DIMENSION(KI) :: ZDIFFTHEWALL
  REAL, DIMENSION(KI) :: ZDIFFTHEROOF
  REAL, DIMENSION(KI) :: ZDIFFTHEFLOOR
  REAL, DIMENSION(KI) :: ZDIFFTHESOILBLD
  REAL, DIMENSION(KI) :: ZDIFFTHEMASS
  REAL, DIMENSION(KI) :: ZDIFFTHEROAD
  REAL, DIMENSION(KI) :: ZDIFFTHESNOWROAD
  REAL, DIMENSION(KI) :: ZDIFFTHESNOWROOF
  REAL, DIMENSION(KI) :: ZDIFFTHEAIRIN
  REAL, DIMENSION(KI) :: ZDIFFTHETOTAL
  REAL, DIMENSION(KI) :: ZDIFFLATWATROOF
  REAL, DIMENSION(KI) :: ZDIFFLATWATROAD
  REAL, DIMENSION(KI) :: ZDIFFLATICEROOF
  REAL, DIMENSION(KI) :: ZDIFFLATICEROAD
  REAL, DIMENSION(KI) :: ZDIFFLATAIRIN
  REAL, DIMENSION(KI) :: ZDIFFLATTOTAL
  REAL, DIMENSION(KI) :: ZDIFFENETOTAL
  !
  REAL, DIMENSION(KI) :: ZSRCSENFLX
  REAL, DIMENSION(KI) :: ZSRCLATFLX
  REAL, DIMENSION(KI) :: ZSRCNETRAD
  REAL, DIMENSION(KI) :: ZSRCPROPAN
  REAL, DIMENSION(KI) :: ZSRCSTOGAR
  REAL, DIMENSION(KI) :: ZSRCSENINT
  REAL, DIMENSION(KI) :: ZSRCLATINT
  REAL, DIMENSION(KI) :: ZSRCHVACCL
  REAL, DIMENSION(KI) :: ZSRCHVACHT
  REAL, DIMENSION(KI) :: ZSRCFLXFLO
  REAL, DIMENSION(KI) :: ZSRCFLXROF
  REAL, DIMENSION(KI) :: ZSRCFLXWAL
  REAL, DIMENSION(KI) :: ZSRCHTRAFF
  REAL, DIMENSION(KI) :: ZSRCLTRAFF
  REAL, DIMENSION(KI) :: ZSRCHINDUS
  REAL, DIMENSION(KI) :: ZSRCLINDUS
  REAL, DIMENSION(KI) :: ZSRCLATRAI
  REAL, DIMENSION(KI) :: ZSRCLATSNO
  REAL, DIMENSION(KI) :: ZSRCLATROI
  REAL, DIMENSION(KI) :: ZSRCLATGRI
  REAL, DIMENSION(KI) :: ZSRCRUNROF
  REAL, DIMENSION(KI) :: ZSRCRUNROD
  REAL, DIMENSION(KI) :: ZSRCNOCROF
  REAL, DIMENSION(KI) :: ZSRCNOCROD
  REAL, DIMENSION(KI) :: ZSRCSENSUM
  REAL, DIMENSION(KI) :: ZSRCLATSUM
  REAL, DIMENSION(KI) :: ZSRCALLSUM
  !
  REAL, DIMENSION(KI) :: ZCONV_LAT_SEN_ROAD
  REAL, DIMENSION(KI) :: ZCONV_LAT_SEN_ROOF
  !
  REAL, DIMENSION(KI) :: ZDQS_SNOW_ROOF
  REAL, DIMENSION(KI) :: ZDQS_SNOW_ROAD
  !
  REAL, DIMENSION(KI) :: AUXRHOO
  REAL, DIMENSION(KI) :: ZCOEF
  !
  REAL, DIMENSION(KI) :: ZSNOW_HEAT_ROAD  !heat storage link to snow on road (W/m2 (road))
  REAL, DIMENSION(KI) :: ZSNOW_HEAT_ROOF  !heat storage link to snow on roof (W/m2 (roof))
  !
  LOGICAL, DIMENSION(KI) :: GCHECK_BUDGET
  !
  REAL                 :: ZCONVERTFACM0_SLT, ZCONVERTFACM0_DST
  REAL                 :: ZCONVERTFACM3_SLT, ZCONVERTFACM3_DST
  REAL                 :: ZCONVERTFACM6_SLT, ZCONVERTFACM6_DST
  !
  INTEGER              :: JI
  INTEGER              :: JLAYER
  INTEGER              :: JCOMP
  INTEGER              :: JJ
  !
  ! number of TEB patches
  !
  INTEGER                    :: JP, IBEG, IEND ! loop counter
  INTEGER              :: ILUOUT     ! Unit number
  !
  REAL(KIND=JPRB) :: ZHOOK_HANDLE
  !
  !-------------------------------------------------------------------------------------
  ! Preliminaries:
  !-------------------------------------------------------------------------------------
  IF (LHOOK) CALL DR_HOOK('COUPLING_TEB_N',0,ZHOOK_HANDLE)
  CALL GET_LUOUT(HPROGRAM,ILUOUT)
  !
  IF (HTEST/='OK') THEN
     CALL ABOR1_SFX('COUPLING_TEBN: FATAL ERROR DURING ARGUMENT TRANSFER')
  END IF
  !-------------------------------------------------------------------------------------
  !
  ! scalar fluxes
  !
  PSFTS(:,:) = 0.
  !
  ! broadband radiative fluxes
  !
  ZDIR_SW(:) = 0.
  ZSCA_SW(:) = 0.
  !
  DO JSWB=1,KSW
     !
     ! Add directional contrib from scattered radiation
     !
     ! FIXME : CIRCUMSOLAR_RAD commented since converts all radiation to direct
     !
     CALL CIRCUMSOLAR_RAD(PDIR_SW(:,JSWB), PSCA_SW(:,JSWB), PZENITH, ZF1_o_B)
     !
     !ZF1_o_B = 0.0
     !
     ZDIR_SWB(:,JSWB) = PDIR_SW(:,JSWB) + PSCA_SW(:,JSWB) * ZF1_o_B
     ZSCA_SWB(:,JSWB) = PSCA_SW(:,JSWB) * (1. - ZF1_o_B)
     !
     !add directionnal contrib from scattered radiation
     !
     ZDIR_SW(:) = ZDIR_SW(:) + ZDIR_SWB(:,JSWB)
     ZSCA_SW(:) = ZSCA_SW(:) + ZSCA_SWB(:,JSWB)
     !
  ENDDO
  !
  DO JJ=1,KI
     !
     ! specific humidity (conversion from kg/m3 to kg/kg)
     !
     ZQA(JJ) = PQA(JJ) / PRHOA(JJ)
     !
     ! wind
     !
     ZWIND(JJ) = SQRT(PU(JJ)**2+PV(JJ)**2)
     !
  ENDDO
  ! method of wind coupling
  !
  IF (HCOUPLING=='I') THEN
     ZPEW_A_COEF = PPEW_A_COEF
     ZPEW_B_COEF = PPEW_B_COEF
  ELSE
     ZPEW_A_COEF =  0.
     ZPEW_B_COEF =  ZWIND
  END IF
  !
  ! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  ! Time evolution
  ! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  !
  DO JP=1,TOP%NTEB_PATCH
     CALL TRAFFIC_FLUX_MODULATION (TOP, PTSUN, &
          NT%AL(JP)%XDELTA_LEGAL_TIME,NT%AL(JP)%NDELTA_LEGAL_TIME, &
          NT%AL(JP)%XTIME_OF_CHANGE, NT%AL(JP)%LTIME_OF_CHANGE, &
          G%XLON, HPROGRAM,ZTRAF_MODULATION)
     !
     ZH_TRAFFIC(:)  = NT%AL(JP)%XH_TRAFFIC  * ZTRAF_MODULATION
     ZLE_TRAFFIC(:) = NT%AL(JP)%XLE_TRAFFIC * ZTRAF_MODULATION
     !
  END DO
  !,' (K)'
  TOP%TTIME%TIME = TOP%TTIME%TIME + PTSTEP
  CALL ADD_FORECAST_TO_DATE_SURF(TOP%TTIME%TDATE%YEAR, TOP%TTIME%TDATE%MONTH,&
       TOP%TTIME%TDATE%DAY, TOP%TTIME%TIME)
  !
  !--------------------------------------------------------------------------------------
  !  Canyon forcing for TEB
  !--------------------------------------------------------------------------------------
  !-------------------------------------------------------------------------------------
  ! Town averaged quantities to force canopy atmospheric layers
  !-------------------------------------------------------------------------------------

  DO JP=1,TOP%NTEB_PATCH
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_BLD,         NT%AL(JP)%XBLD         )
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_BLD_HEIGHT,  NT%AL(JP)%XBLD_HEIGHT  )
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_WL_O_HOR,    NT%AL(JP)%XWALL_O_HOR  )
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_CAN_HW_RATIO,NT%AL(JP)%XCAN_HW_RATIO)
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_Z0_TOWN     ,NT%AL(JP)%XZ0_TOWN     )
  END DO
  !
  IF (TOP%LCANOPY) THEN
     !-------------------------------------------------------------------------------------
     ! Updates canopy vertical grid as a function of forcing height
     !-------------------------------------------------------------------------------------
     !
     !* determines where is the forcing level and modifies the upper levels of the canopy grid
     !
     CALL CANOPY_GRID_UPDATE(KI, ZAVG_BLD_HEIGHT, ZAVG_BLD_HEIGHT+PUREF, SB)
     !
     !* Initialisations of T, Q, TKE and wind at first time step
     !
     IF(ANY(SB%XT(:,:) == XUNDEF)) THEN
        DO JLAYER=1,SB%NLVL
           SB%XT(:,JLAYER) = PTA(:)
           SB%XQ(:,JLAYER) = PQA(:)
           SB%XU(:,JLAYER) = 2./XPI * ZWIND(:)                                  &
                * LOG( (          2.* NT%AL(1)%XBLD_HEIGHT(:)/3.) / NT%AL(1)%XZ0_TOWN(:))   &
                / LOG( (PUREF(:)+ 2.* NT%AL(1)%XBLD_HEIGHT(:)/3.) / NT%AL(1)%XZ0_TOWN(:))
        END  DO
        SB%XTKE(:,:) = 1.
     ENDIF
     !
     !* default forcing above roof: forcing level
     ZUREF(:) = PUREF(:)
     ZZREF(:) = PZREF(:)
     ZUA(:)   = SB%XU(:,SB%NLVL)
     ZTA(:)   = SB%XT(:,SB%NLVL)
     ZQA(:)   = SB%XQ(:,SB%NLVL)/PRHOA(:)
     ZPA(:)   = SB%XP(:,SB%NLVL)
     !* for the time being, only one value is kept for wall in-canyon forcing, in the middle of the canyon
     ZU_CANYON(:) = ZUA(:)
     ZT_CANYON(:) = ZTA(:)
     ZQ_CANYON(:) = ZQA(:)
     DO JLAYER=1,SB%NLVL-1
        DO JI=1,KI
           !* finds middle canyon layer
           IF (SB%XZ(JI,JLAYER)<ZAVG_BLD_HEIGHT(JI)/2. .AND. SB%XZ(JI,JLAYER+1)>=ZAVG_BLD_HEIGHT(JI)/2.) THEN
              ZCOEF(JI) = (ZAVG_BLD_HEIGHT(JI)/2.-SB%XZ(JI,JLAYER))/(SB%XZ(JI,JLAYER+1)-SB%XZ(JI,JLAYER))
              ZU_CANYON(JI) = SB%XU(JI,JLAYER) + ZCOEF(JI) * (SB%XU(JI,JLAYER+1)-SB%XU(JI,JLAYER))
              ZT_CANYON(JI) = SB%XT(JI,JLAYER) + ZCOEF(JI) * (SB%XT(JI,JLAYER+1)-SB%XT(JI,JLAYER))
              ZQ_CANYON(JI) =(SB%XQ(JI,JLAYER) + ZCOEF(JI) * (SB%XQ(JI,JLAYER+1)-SB%XQ(JI,JLAYER)))/PRHOA(JI)
           END IF
           !* finds layer just above roof (at least 1m above roof)
           IF (SB%XZ(JI,JLAYER)<ZAVG_BLD_HEIGHT(JI)+1. .AND. SB%XZ(JI,JLAYER+1)>=ZAVG_BLD_HEIGHT(JI)+1.) THEN
              ZUREF(JI) = SB%XZ(JI,JLAYER+1) - ZAVG_BLD_HEIGHT(JI)
              ZZREF(JI) = SB%XZ(JI,JLAYER+1) - ZAVG_BLD_HEIGHT(JI)
              ZTA  (JI) = SB%XT(JI,JLAYER+1)
              ZQA  (JI) = SB%XQ(JI,JLAYER+1)/PRHOA(JI)
              !ZUA  (JI) = XU(JI,JLAYER+1)
              ZUA  (JI) = MAX(SB%XU(JI,JLAYER+1) - 2.*SQRT(SB%XTKE(JI,JLAYER+1)) , SB%XU(JI,JLAYER+1)/3.)
              ZPA  (JI) = SB%XP(JI,JLAYER+1)
              ZLMO (JI) = SB%XLMO(JI,JLAYER+1)
           END IF
        END DO
     END DO


     !
     ! Robert: 
     ! Since not all calculations related to the canopy are implicit it is possible
     ! that unrealistic (even negative) values of humidity in the canopy occur. 
     ! For this reason, a pragmatic correction is implemented here in the case
     ! where the absolute humidity of the canopy deviates strongly from the 
     ! absolute humidity of the forcing.
     ! In the long term all computations related to the canopy should be implicited.
     !
     DO JLAYER=1,SB%NLVL
        !
        WHERE ( SB%XQ(:,JLAYER).LT.(0.3*PQA(:)) )
           SB%XQ(:,JLAYER) = 0.3 * PQA(:)
        ELSEWHERE ( SB%XQ(:,JLAYER).GT.(3.0*PQA(:)) )
           SB%XQ(:,JLAYER) = 3.0 * PQA(:)
        ENDWHERE
        !
     ENDDO
     !
     ZU_CANYON= MAX(ZU_CANYON,0.2)
     ZU_LOWCAN=SB%XU(:,1)
     ZT_LOWCAN=SB%XT(:,1)
     ZQ_LOWCAN=SB%XQ(:,1) / PRHOA(:)
     ZZ_LOWCAN=SB%XZ(:,1)
     WHERE(ZPA==XUNDEF) ZPA = PPA   ! security for first time step
     !

     !-------------------------------------------------------------------------------------
     ! determine the vertical profile for mixing and dissipative lengths (at full levels)
     !-------------------------------------------------------------------------------------
     !
     ! frontal density
     ZLAMBDA_F(:) = ZAVG_WL_O_HOR(:)/XPI
     !
     !
     CALL SM10(SB%XZ, ZAVG_BLD_HEIGHT, ZLAMBDA_F, ZL, ZLTREE)
     !
     !-------------------------------------------------------------------------------------
     ! computes coefficients for implicitation
     !-------------------------------------------------------------------------------------
     !
     ZAVG_UW_GRND(:)    = 0.
     ZAVG_DUWDU_GRND(:) = 0.
     ZAVG_UW_RF(:)      = 0.
     ZAVG_DUWDU_RF(:)   = 0.
     ZAVG_H_GRND(:)     = 0.
     ZAVG_H_WL(:)       = 0.
     ZAVG_H_RF(:)       = 0.
     ZAVG_E_WL(:)       = 0.
     ZAVG_E_GRND(:)     = 0.
     ZAVG_E_RF(:)       = 0.
     ZAVG_DH_HVEG(:,:)  = 0.
     ZAVG_DE_HVEG(:,:)  = 0.
     ZAVG_URBTREE(:)    = 0.
     ZAVG_LAD_CAN(:,:)  = 0.
     ZAVG_AC_GRND(:)    = 0.
     ZAVG_AC_GRND_WAT(:)= 0.
     ZSFLUX_U(:)        = 0.
     ZSFLUX_T(:)        = 0.
     ZSFLUX_Q(:)        = 0.
     !
     DO JLAYER=1,SB%NLVL-1
        !* Monin-Obuhkov theory not used inside the urban canopy
        ! => neutral mixing  if layer is below : (roof level +1 meter)
        WHERE (SB%XZ(:,JLAYER)<=ZAVG_BLD_HEIGHT(:)+1.) SB%XLMO(:,JLAYER) = XUNDEF
     ENDDO
     !
     !* computes tendencies on wind and Tke due to canopy
     CALL TEB_CANOPY(KI,SB, ZAVG_BLD,ZAVG_BLD_HEIGHT,ZAVG_WL_O_HOR, PPA, PRHOA, &
          ZAVG_DUWDU_GRND, ZAVG_UW_RF, ZAVG_DUWDU_RF, ZAVG_H_WL, ZAVG_E_WALL, &
          ZAVG_H_RF, ZAVG_E_RF, ZAVG_DH_HVEG, ZAVG_DE_HVEG,                  &
          ZAVG_AC_GRND,ZAVG_AC_GRND_WAT,                                            &
          ZAVG_URBTREE,ZAVG_LAD_CAN, ZFORC_U,                         &
          ZDFORC_UDU, ZFORC_E, ZDFORC_EDE, ZFORC_T, ZDFORC_TDT, ZFORC_Q, &
          ZDFORC_QDQ )
     !
     !* computes coefficients for implicitation
     CALL CANOPY_EVOL(SB, KI, PTSTEP, 1, ZL, ZWIND, PTA, PQA, PPA, PRHOA, &
          ZSFLUX_U, ZSFLUX_T, ZSFLUX_Q, ZFORC_U, ZDFORC_UDU,   &
          ZFORC_E, ZDFORC_EDE, ZFORC_T, ZDFORC_TDT, ZFORC_Q,   &
          ZDFORC_QDQ, SB%XLM, SB%XLEPS, ZAVG_USTAR, ZALFAU,  &
          ZBETAU, ZALFAT, ZBETAT, ZALFAQ, ZBETAQ)
     !
     ZPEW_A_COEF_LOWCAN = - ZALFAU / PRHOA
     ZPEW_B_COEF_LOWCAN = ZBETAU  
     !
     !- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
  ELSE              ! no canopy case
     !- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
     DO JI=1,KI
        !* skimming flow for h/w>1 (maximum effect of direction on wind in the canyon);
        !* isolated flow for h/w<0.5 (wind is the same in large streets for all dir.)
        !* wake flow between.
        !
        ZWAKE(JI)= 1. + (2./XPI-1.) * 2. * (ZAVG_CAN_HW_RATIO(JI)-0.5)
        ZWAKE(JI)= MAX(MIN(ZWAKE(JI),1.),2./XPI)
        !
        !* Estimation of canyon wind speed from wind just above roof level
        !  (at 1.33h). Wind at 1.33h is estimated using the log law.
        !
        IF (ZAVG_BLD_HEIGHT(JI) .GT. 0.) THEN
           ZU_CANYON(JI) = ZWAKE(JI) * EXP(-ZAVG_CAN_HW_RATIO(JI)/4.) * ZWIND(JI)     &
                * LOG( (           2.* ZAVG_BLD_HEIGHT(JI)/3.) / ZAVG_Z0_TOWN(JI))   &
                / LOG( (PUREF(JI)+ 2.* ZAVG_BLD_HEIGHT(JI)/3.) / ZAVG_Z0_TOWN(JI))
           ZZ_LOWCAN(JI) = ZAVG_BLD_HEIGHT(JI) / 2.
        ELSE
           ZU_CANYON(JI) = ZWIND(JI)
           ZZ_LOWCAN(JI) = PZREF(JI)
        ENDIF
     END DO
     !
     !* Without SBL scheme, canyon air is assumed at mid height
     !
     ! Check for negative humidity
     !
     IF (MINVAL(NT%AL(1)%XQ_CANYON).LT.-XSURF_EPSILON) THEN
        CALL GET_LUOUT(HPROGRAM,ILUOUT)
        WRITE(ILUOUT,*) "NT%AL(1)%Q_CANYON : ",NT%AL(1)%XQ_CANYON
        CALL FLUSH(ILUOUT)
        CALL ABOR1_SFX("Negative humidity in canyon")
     ENDIF
     !
     !* Without SBL scheme, canyon air is assumed at mid height
     ZU_LOWCAN = ZU_CANYON
     ZT_LOWCAN = NT%AL(1)%XT_CANYON
     ZQ_LOWCAN = NT%AL(1)%XQ_CANYON
     ZT_CANYON = NT%AL(1)%XT_CANYON
     ZQ_CANYON = NT%AL(1)%XQ_CANYON
     ZUREF     = PUREF
     ZZREF     = PZREF
     ZTA       = PTA
     ZUA       = ZWIND
     ZPA       = PPA
     ZPEW_A_COEF_LOWCAN =  0.
     ZPEW_B_COEF_LOWCAN =  ZU_CANYON
  END IF
  !
  ! Exner functions
  !
  ZEXNS     (:) = (PPS(:)/XP00)**(XRD/XCPD)
  ZEXNA     (:) = (ZPA(:)/XP00)**(XRD/XCPD)

  !--------------------------------------------------------------------------------------
  ! Over Urban surfaces/towns:
  !--------------------------------------------------------------------------------------
  !
  !--------------------------------------------------------------------------------------
  ! LOOP on TEB PATCHES
  !--------------------------------------------------------------------------------------
  DO JP = 1,TOP%NTEB_PATCH
     !--------------------------------------------------------------------------------------
     ! LOOP on TEB PATCHES
     !--------------------------------------------------------------------------------------
     !
     ZT_CAN = ZT_CANYON
     ZQ_CAN = ZQ_CANYON
     !
     IF (TOP%LCANOPY) THEN
        NT%AL(JP)%XT_CANYON(:) = ZT_CANYON(:)
        NT%AL(JP)%XQ_CANYON(:) = ZQ_CANYON(:)
     END IF
     !
     ZLESN_RF(:) = 0.
     ZLESN_RD(:) = 0.
     TD%NDMT%AL(JP)%XG_GREENROOF_ROOF(:) = 0.
     !
     ! Compute TS_HVEG according to air temperature inside the canyon
     IF (TOP%LGARDEN .AND. TOP%CURBTREE/='NONE') THEN  
        IF (TOP%LCANOPY) THEN  
           DO JLAYER=1,SB%NLVL-1
              DO JI=1,SIZE(GDM%K%XH_LAI_MAX)
                 !* finds middle of tree crown
                 IF (SB%XZ(JI,JLAYER)<GDM%K%XH_LAI_MAX(JI) .AND. &
                     SB%XZ(JI,JLAYER+1)>=GDM%K%XH_LAI_MAX(JI)) THEN
                    ZCOEF(JI)    = (GDM%K%XH_LAI_MAX(JI)-SB%XZ(JI,JLAYER))/ (SB%XZ(JI,JLAYER+1)-SB%XZ(JI,JLAYER))
                   TD%NDMT%AL(JP)%XTS_HVEG(JI) = SB%XT(JI,JLAYER) + ZCOEF(JI)*(SB%XT(JI,JLAYER+1)-SB%XT(JI,JLAYER))
                   ZTS_HVEG(JI) = SB%XT(JI,JLAYER) + ZCOEF(JI)*(SB%XT(JI,JLAYER+1)-SB%XT(JI,JLAYER))
                 ENDIF
              ENDDO
           ENDDO
                    ZTS_HVEG = SB%XT(:,2)
        ELSE
           TD%NDMT%AL(JP)%XTS_HVEG = ZT_CAN
           ZTS_HVEG = ZT_CAN
        ENDIF
     ELSE
        ZTS_HVEG(:) = XUNDEF
     ENDIF
     !
     ! Storage of soil water depths in urban soils
     !
     IF (TOP%LURBHYDRO) THEN
       ZWATER_ROAD  (:)=0.0
       ZWATER_BLD   (:)=0.0
       ZWATER_GARDEN(:)=0.0
       DO JLAYER=1,SIZE(NT%AL(JP)%XT_ROAD,2)
          ZWATER_ROAD(:)   = ZWATER_ROAD(:)   +  NT%AL(JP)%XROAD(:)     * &
                             NT%AL(JP)%XD_ROAD(:,JLAYER) * HM%NTH%AL(JP)%XWG_ROAD(:,JLAYER)
          ZWATER_BLD (:)   = ZWATER_BLD (:)   +  NT%AL(JP)%XBLD (:)     * &
                             NT%AL(JP)%XD_ROAD(:,JLAYER) * HM%NTH%AL(JP)%XWG_BLD (:,JLAYER)
          ZWATER_GARDEN(:) = ZWATER_GARDEN(:) +  NT%AL(JP)%XGARDEN(:)   * &
                             NT%AL(JP)%XD_ROAD(:,JLAYER) * GDM%NPE%AL(JP)%XWG(:,JLAYER)
       ENDDO
     ENDIF
     !
     ! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     ! Call the physical routines of TEB (including gardens and greenroofs)
     ! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     !
     CALL TEB_GARDEN(DTCO, G, TOP, NT%AL(JP), BOP, NB%AL(JP), TPN, TIR, TD%NDMT%AL(JP), GDM, GRM, &
          HM%NTH%AL(JP), HM%THP, SB, JP, &
          HPROGRAM, CIMPLICIT_WIND, PTSUN, ZT_CAN, ZQ_CAN, ZU_CANYON, ZT_LOWCAN, ZQ_LOWCAN, &
          ZU_LOWCAN, ZZ_LOWCAN, ZPEW_A_COEF, ZPEW_B_COEF, ZPEW_A_COEF_LOWCAN,     &
          ZPEW_B_COEF_LOWCAN, PPS, NB%AL(JP)%XPSOLD, ZPA, ZEXNS, ZEXNA, ZTA, ZQA, PRHOA, PCO2, PLW, &
          ZDIR_SWB, ZSCA_SWB, PSW_BANDS, KSW, PZENITH, PAZIM, PRAIN, PSN, ZZREF,  &
          ZUREF, ZUA, ZH_TRAFFIC, ZLE_TRAFFIC, PTSTEP, ZLEW_RF, ZLEW_RD,          &
          ZRNSN_RF, ZHSN_RF, ZLESN_RF, ZGSN_RF, ZMELT_RF, ZRNSN_RD,               &
          ZHSN_RD, ZLESN_RD, ZGSN_RD, ZMELT_RD, ZRN_GRND, ZH_GRND, ZLE_GRND,      &
          ZGFLX_GRND, ZRN, ZH, ZLE, ZGFLX, ZQF, ZEVAP, ZUW_GRND,          &
          ZUW_RF, ZDUWDU_GRND, ZDUWDU_RF, ZUSTAR, ZCD, ZCDN, ZCH, ZRI, ZTRAD,     &
          ZEMIS, ZDIR_ALB, ZSCA_ALB, ZRESA_TOWN, ZAC_RD, ZAC_GD, ZAC_GRF, ZAC_RD_WAT,  &
          ZAC_GD_WAT, ZAC_GRF_WAT, KDAY, ZEMIT_LW_HVEG,                          &
          TD%NDMT%AL(JP)%XREF_SW_GRND, TD%NDMT%AL(JP)%XREF_SW_FAC, ZREF_SW_HVEG, PTIME, &
          ZCONV_LAT_SEN_ROAD, ZCONV_LAT_SEN_ROOF,                                &
          ZHEAT_RR_ROAD,ZHEAT_RR_ROOF,ZSEN_SNOW_DIF_ROAD,ZSEN_SNOW_DIF_ROOF,     &
          TD%NDMT%AL(JP)%XDN_ROOF,TD%NDMT%AL(JP)%XDN_ROAD,ZDQS_SNOW_ROOF,ZDQS_SNOW_ROAD,ZSEN_MELT_ROAD,        &
          ZSEN_MELT_ROOF,ZDIFF_SNOW_WAT_ROAD,ZDIFF_SNOW_WAT_ROOF,ZRHOI,          &
          ZLW_WALA_TO_ROAD,ZLW_WALB_TO_ROAD,                                     &
          ZLW_WIND_TO_ROAD,ZLW_WALA_TO_GARD,ZLW_WALB_TO_GARD,                    &
          ZLW_WIND_TO_GARD,ZLW_ROAD_TO_WIND,ZLW_WALL_TO_WIND,                    &
          ZLW_SNOW_TO_WIND,ZLW_GARD_TO_WIND,ZLW_ROAD_TO_WALA,                    &
          ZLW_GARD_TO_WALA,ZLW_SNOW_TO_WALA,ZLW_WALB_TO_WALA,                    &
          ZLW_WIND_TO_WALA,ZLW_ROAD_TO_WALB,ZLW_GARD_TO_WALB,                    &
          ZLW_SNOW_TO_WALB,ZLW_WALA_TO_WALB,ZLW_WIND_TO_WALB,                    &
          ZLW_WALA_TO_SNOW,ZLW_WALB_TO_SNOW,ZLW_WIND_TO_SNOW,                    &
          ZSEN_GREENROOF,ZLAT_GREENROOF,                                         &
          ZFLUXFLOOR,                                      &
          ZFLX_BLD_ROOF, ZFLX_BLD_WALL_A, ZFLX_BLD_WALL_B,                       &
          ZSNOW_HEAT_ROAD, ZSNOW_HEAT_ROOF,                                      &
          ZNET_LW_HVEG, ZTS_HVEG, ZLAD_CAN,                                      &
          ZTRAF_MODULATION, ZDH_HVEG, ZDLE_HVEG, ZSCA_SW_SKY, ZLW_RAD_SKY,  "OK")
     !
     TD%NDMT%AL(JP)%XU_LOWCAN=ZU_LOWCAN
     !
     IF (TOP%CBEM=='BEM') THEN
        !
        ! The internal heat release as well as the heating and cooling
        ! energy demand are converted from W/m²(bld) to W/m²(urb).
        !
        TD%NDMT%AL(JP)%XQINOUT(:)    = NT%AL(JP)%XBLD(:) * TD%NDMT%AL(JP)%XQINOUT(:)
        TD%NDMT%AL(JP)%XHVAC_COOL(:) = NT%AL(JP)%XBLD(:) * TD%NDMT%AL(JP)%XHVAC_COOL(:)
        TD%NDMT%AL(JP)%XHVAC_HEAT(:) = NT%AL(JP)%XBLD(:) * TD%NDMT%AL(JP)%XHVAC_HEAT(:)
        !
        TD%NDMT%AL(JP)%XHVAC_HEAT_ELEC   = NT%AL(JP)%XBLD(:) * TD%NDMT%AL(JP)%XHVAC_HEAT_ELEC
        TD%NDMT%AL(JP)%XHVAC_HEAT_GAS    = NT%AL(JP)%XBLD(:) * TD%NDMT%AL(JP)%XHVAC_HEAT_GAS
        TD%NDMT%AL(JP)%XHVAC_HEAT_FUEL   = NT%AL(JP)%XBLD(:) * TD%NDMT%AL(JP)%XHVAC_HEAT_FUEL
        TD%NDMT%AL(JP)%XHVAC_HEAT_OTHER  = NT%AL(JP)%XBLD(:) * TD%NDMT%AL(JP)%XHVAC_HEAT_OTHER
        !
        DO JCOMP=1,BOP%NBEMCOMP
           TD%NDMT%AL(JP)%XCOMP_QINOUT   (:,JCOMP) = NT%AL(JP)%XBLD(:) * TD%NDMT%AL(JP)%XCOMP_QINOUT(:,JCOMP)
           TD%NDMT%AL(JP)%XCOMP_HVAC_COOL(:,JCOMP) = NT%AL(JP)%XBLD(:) * TD%NDMT%AL(JP)%XCOMP_HVAC_COOL(:,JCOMP)
           TD%NDMT%AL(JP)%XCOMP_HVAC_HEAT(:,JCOMP) = NT%AL(JP)%XBLD(:) * TD%NDMT%AL(JP)%XCOMP_HVAC_HEAT(:,JCOMP)
        ENDDO
        !
     ENDIF
     !
     IF (.NOT. TOP%LCANOPY) THEN
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_T_CANYON,ZT_CAN)
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_Q_CANYON,ZQ_CAN)
        !
        ! Momentum fluxes
        !
        ZSFU = 0.
        ZSFV = 0.
        DO JJ=1,SIZE(PU)
           IF (ZWIND(JJ)>0.) THEN
              ZCOEF(JJ) = - PRHOA(JJ) * ZUSTAR(JJ)**2 / ZWIND(JJ)
              ZSFU(JJ) = ZCOEF(JJ) * PU(JJ)
              ZSFV(JJ) = ZCOEF(JJ) * PV(JJ)
           ENDIF
        ENDDO
        CALL ADD_PATCH_CONTRIB(JP,PSFU,ZSFU)
        CALL ADD_PATCH_CONTRIB(JP,PSFV,ZSFV)
        !
     ENDIF
     !
     !-------------------------------------------------------------------------------------
     ! Outputs:
     !-------------------------------------------------------------------------------------
     !
     ! Grid box average fluxes/properties: Arguments and standard diagnostics
     !
     CALL ADD_PATCH_CONTRIB(JP,PSFTH,ZH)
     CALL ADD_PATCH_CONTRIB(JP,PSFTQ,ZEVAP)
     CALL ADD_PATCH_CONTRIB(JP,PSFCO2,TD%NDMT%AL(JP)%XSFCO2)
     !
     ! Albedo for each wavelength and patch
     !
     DO JSWB=1,SIZE(PSW_BANDS)
        DO JJ=1,SIZE(ZDIR_ALB)
           ZDIR_ALB_PATCH(JJ,JSWB,JP) = ZDIR_ALB(JJ)
           ZSCA_ALB_PATCH(JJ,JSWB,JP) = ZSCA_ALB(JJ)
        ENDDO
     END DO
     !
     ! emissivity and radiative temperature
     !
     ZEMIS_PATCH(:,JP) = ZEMIS
     ZTRAD_PATCH(:,JP) = ZTRAD
     !
     ! computes some aggregated diagnostics
     !
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_CD ,ZCD )
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_CDN,ZCDN)
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_RI ,ZRI )
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_CH ,ZCH )
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_RN ,ZRN )
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_H  ,ZH  )
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_LE ,ZLE )
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_GFLX ,ZGFLX )
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_QF ,ZQF )
     !
     !* warning: aerodynamical resistance does not yet take into account gardens
     CALL ADD_PATCH_CONTRIB(JP,ZAVG_RESA_TOWN,1./ZRESA_TOWN)
     IF (JP==TOP%NTEB_PATCH) ZAVG_RESA_TOWN = 1./ZAVG_RESA_TOWN
     !
     ! ###############################################################
     ! ###############################################################
     ! Robert: Verification of energy conservation
     ! ###############################################################
     ! ###############################################################
     !
     ! ############################################################
     ! A: Sensible heat stored
     ! ############################################################
     !
     ! Sensible heat stored in the wall [J/m²(urb)]
     !
     ZTHEWALL(:)=0.0
     DO JLAYER=1,SIZE(NT%AL(JP)%XD_WALL,2)
        ZTHEWALL(:) = ZTHEWALL(:) + NT%AL(JP)%XWALL_O_BLD(:)*NT%AL(JP)%XBLD(:) * &
             NT%AL(JP)%XD_WALL(:,JLAYER)*NT%AL(JP)%XHC_WALL(:,JLAYER)          * &
             0.5*(NT%AL(JP)%XT_WALL_A(:,JLAYER)+NT%AL(JP)%XT_WALL_B(:,JLAYER))
     ENDDO
     !
     ! Sensible heat stored in the roof [J/m²(urb)]
     !
     ZTHEROOF(:)=0.0
     DO JLAYER=1,SIZE(NT%AL(JP)%XD_ROOF,2)
        ZTHEROOF(:) = ZTHEROOF(:) +       NT%AL(JP)%XBLD(:) * &
             NT%AL(JP)%XD_ROOF(:,JLAYER)*NT%AL(JP)%XHC_ROOF(:,JLAYER)*NT%AL(JP)%XT_ROOF(:,JLAYER)
     ENDDO
     !
     ! Sensible heat stored in the ground floor and the soil below [J/m²(urb)]
     !
     ZTHEFLOOR(:)=0.0
     IF (TOP%CBEM=='BEM') THEN
     DO JLAYER=1,SIZE(NB%AL(JP)%XT_FLOOR,2)
        DO JCOMP=1,BOP%NBEMCOMP
           ZTHEFLOOR(:) = ZTHEFLOOR(:) + NB%AL(JP)%XFRACOMP(:,JCOMP) * &
                NT%AL(JP)%XBLD(:) * NB%AL(JP)%XD_FLOOR(:,JLAYER) *         &
                NB%AL(JP)%XHC_FLOOR(:,JLAYER)*NB%AL(JP)%XT_FLOOR(:,JLAYER,JCOMP)
        ENDDO
     ENDDO
     END IF
     !
     ZTHESOILBLD(:)=0.0
     DO JLAYER=1,SIZE(NT%AL(JP)%XT_BLD,2)
         ZTHESOILBLD(:) = ZTHESOILBLD(:) + &
              NT%AL(JP)%XBLD(:) * NT%AL(JP)%XD_BLD(:,JLAYER) *         &
              NT%AL(JP)%XHC_BLD(:,JLAYER)*NT%AL(JP)%XT_BLD(:,JLAYER)
     ENDDO
     !
     !
     ! Sensible heat stored in the mass [J/m²(urb)]
     ! The mass temperature can be averaged over the compartments
     !
     ZTHEMASS(:) = 0.0
     IF (TOP%CBEM=='BEM') THEN
     DO JJ=1,SIZE(NB%AL(JP)%XN_FLOOR)
        IF (NB%AL(JP)%XN_FLOOR(JJ).GT.1.5) THEN
           DO JLAYER=1,SIZE(NB%AL(JP)%XT_MASS,2)
              DO JCOMP=1,BOP%NBEMCOMP
                 ZTHEMASS(JJ) = ZTHEMASS(JJ) + NB%AL(JP)%XFRACOMP(JJ,JCOMP) * &
                      NT%AL(JP)%XBLD(JJ) * NB%AL(JP)%XMASS_O_BLD(JJ) *            &
                      NB%AL(JP)%XD_MASS(JJ,JLAYER)*NB%AL(JP)%XHC_MASS(JJ,JLAYER)* &
                      NB%AL(JP)%XT_MASS(JJ,JLAYER,JCOMP)
              ENDDO
           ENDDO
        ELSE
           ZTHEMASS(JJ)=0.0
        ENDIF
     ENDDO
     END IF
     !
     ! Sensible heat stored in the road [J/m²(urb)]
     !
     ZTHEROAD(:)=0.0
     DO JLAYER=1,SIZE(NT%AL(JP)%XT_ROAD,2)
        ZTHEROAD(:) = ZTHEROAD(:) +  NT%AL(JP)%XROAD(:)           * &
             NT%AL(JP)%XD_ROAD(:,JLAYER)*NT%AL(JP)%XHC_ROAD(:,JLAYER) * &
             NT%AL(JP)%XT_ROAD(:,JLAYER)
     ENDDO
     !
     ! Sensible heat stored in the indoor air [J/m²(urb)]
     !
     ZTHEAIRIN(:)=0.0
     IF (TOP%CBEM=='BEM') THEN
     IF (TOP%CBEM.EQ."BEM") THEN
        DO JCOMP=1,BOP%NBEMCOMP
           ZTHEAIRIN(:) =  ZTHEAIRIN(:) + NB%AL(JP)%XFRACOMP(:,JCOMP) * & 
                NT%AL(JP)%XBLD(:)*XCPD*NT%AL(JP)%XBLD_HEIGHT(:)*ZRHOI(:,JCOMP)*NB%AL(JP)%XTI_BLD(:,JCOMP)
        ENDDO
     ENDIF
     END IF
     !
     ! Total sensible heat stored [J/m²(urb)]
     !
     ZTHETOTAL(:)=ZTHEWALL(:)+ZTHEROOF(:)+ZTHEFLOOR(:)+ZTHESOILBLD(:)+ZTHEMASS(:)+ &
          ZTHEROAD(:)+ZTHEAIRIN(:)
     !
     ! ####################################################
     ! B: Latent heat stored
     ! ####################################################
     !
     ! Latent heat stored in the roof water and ice reservoir [J/m²(urb)]
     !
     ZLATWATROOF(:)=(1.0-NT%AL(JP)%XGREENROOF(:))*NT%AL(JP)%XBLD(:)*XLVTT*NT%AL(JP)%XWS_ROOF(:)
     ZLATICEROOF(:)=(1.0-NT%AL(JP)%XGREENROOF(:))*NT%AL(JP)%XBLD(:)*XLSTT*NT%AL(JP)%TSNOW_ROOF%WSNOW(:,1)
     !
     ! Latent heat stored in the road water and ice reservoir [J/m²(urb)]
     !
     ZLATWATROAD(:)=NT%AL(JP)%XROAD(:)*XLVTT*NT%AL(JP)%XWS_ROAD(:)
     ZLATICEROAD(:)=NT%AL(JP)%XROAD(:)*XLSTT*NT%AL(JP)%TSNOW_ROAD%WSNOW(:,1)
     !
     ! Latent heat stored in the indoor air humidity [J/m²(urb)]
     !
     ZLATAIRIN(:)=0.0
     IF (TOP%CBEM.EQ."BEM") THEN
        DO JCOMP=1,BOP%NBEMCOMP
           ZLATAIRIN(:) = ZLATAIRIN(:) + NB%AL(JP)%XFRACOMP(:,JCOMP) * NT%AL(JP)%XBLD(:)* &
                XLVTT*NT%AL(JP)%XBLD_HEIGHT(:)*ZRHOI(:,JCOMP)*NB%AL(JP)%XQI_BLD(:,JCOMP)
        ENDDO
     ENDIF
     !
     ! Total latent heat stored [J/m²(urb)]
     !
     ZLATTOTAL(:)=ZLATWATROOF(:)+ZLATICEROOF(:)+ZLATWATROAD(:)+ZLATICEROAD(:)+ZLATAIRIN(:)
     !
     ! Total energy stored in TEB-BEM [J/m²(urb)]
     !
     ZENETOTAL(:)=ZLATTOTAL(:)+ZTHETOTAL(:)
     !
     ! #######################################################
     ! C: Differences of storage terms to previous time step
     ! #######################################################
     !
     ZDIFFTHEAIRIN(:)   = (ZTHEAIRIN(:)   - NT%AL(JP)%XTHEAIRIN(:))/PTSTEP
     ZDIFFTHEWALL(:)    = (ZTHEWALL(:)    - NT%AL(JP)%XTHEWALL(:))/PTSTEP
     ZDIFFTHEROOF(:)    = (ZTHEROOF(:)    - NT%AL(JP)%XTHEROOF(:))/PTSTEP
     ZDIFFTHEFLOOR(:)   = (ZTHEFLOOR(:)   - NT%AL(JP)%XTHEFLOOR(:))/PTSTEP
     ZDIFFTHESOILBLD(:) = (ZTHESOILBLD(:) - NT%AL(JP)%XTHESOILBLD(:))/PTSTEP
     ZDIFFTHEMASS(:)    = (ZTHEMASS(:)    - NT%AL(JP)%XTHEMASS(:))/PTSTEP
     ZDIFFTHEROAD(:)    = (ZTHEROAD(:)    - NT%AL(JP)%XTHEROAD(:))/PTSTEP
     ZDIFFTHESNOWROAD(:)= NT%AL(JP)%XROAD(:)*TD%NDMT%AL(JP)%XDN_ROAD(:)*ZDQS_SNOW_ROAD(:)
     ZDIFFTHESNOWROOF(:)= (1.0-NT%AL(JP)%XGREENROOF(:))*NT%AL(JP)%XBLD(:)*TD%NDMT%AL(JP)%XDN_ROOF(:)*ZDQS_SNOW_ROOF(:)
     ZDIFFTHETOTAL(:)   = (ZTHETOTAL(:)   - NT%AL(JP)%XTHETOTAL(:))/PTSTEP
     ZDIFFLATWATROOF(:) = (ZLATWATROOF(:) - NT%AL(JP)%XLATWATROOF(:))/PTSTEP
     ZDIFFLATWATROAD(:) = (ZLATWATROAD(:) - NT%AL(JP)%XLATWATROAD(:))/PTSTEP
     ZDIFFLATICEROOF(:) = (ZLATICEROOF(:) - NT%AL(JP)%XLATICEROOF(:))/PTSTEP
     ZDIFFLATICEROAD(:) = (ZLATICEROAD(:) - NT%AL(JP)%XLATICEROAD(:))/PTSTEP
     ZDIFFLATAIRIN(:)   = (ZLATAIRIN(:)   - NT%AL(JP)%XLATAIRIN(:))/PTSTEP
     ZDIFFLATTOTAL(:)   = (ZLATTOTAL(:)   - NT%AL(JP)%XLATTOTAL(:))/PTSTEP
     ZDIFFENETOTAL(:)   = (ZENETOTAL(:)   - NT%AL(JP)%XENETOTAL(:))/PTSTEP
     !
     ! #######################################################
     ! D: Sources of sensible and latent heat
     ! #######################################################
     !
     ! Sensible and latent heat flux (W/m²(urb))
     !
     ZSRCSENFLX(:) = -ZH(:)
     ZSRCLATFLX(:) = -ZLE(:)
     !
     ! Net radiation (W/m²(urb))
     !
     ZSRCNETRAD(:) = ZRN(:)
     !
     ! Production by solar panels (W/m²(urb))
     !
     IF (TOP%LSOLAR_PANEL) THEN
        ZSRCPROPAN(:)=NT%AL(JP)%XBLD(:)*(TD%NDMT%AL(JP)%XTHER_PROD_BLD  (:) + TD%NDMT%AL(JP)%XPHOT_PROD_BLD(:))
     ELSE
        ZSRCPROPAN(:)=0.0
     ENDIF
     !
     ! Storage flux in garden (W/m²(urb))
     !
     IF (TOP%LGARDEN) THEN
        !ZSRCSTOGAR(:) = -NT%AL(JP)%XGARDEN(:)*GDM%VD%ND%AL(JP)%XGFLUX
        !ZSRCSTOGAR(:) = -(NT%AL(JP)%XGARDEN(:)+NT%AL(JP)%XFRAC_HVEG(:))/NT%AL(JP)%XTOTS_O_HORS(:)*GDM%VD%ND%AL(JP)%XGFLUX
        ZSRCSTOGAR(:) = -(NT%AL(JP)%XGARDEN(:)+NT%AL(JP)%XFRAC_HVEG(:))*GDM%VD%ND%AL(JP)%XGFLUX

     ELSE
        ZSRCSTOGAR(:) = 0.0
     ENDIF
     !
     ! Anthropogenic sources (W/m²(urb))
     !
     IF (TOP%CBEM.EQ."BEM") THEN
        !
        ZSRCSENINT(:) = TD%NDMT%AL(JP)%XQINOUT(:)*(1.0-NB%AL(JP)%XQIN_FLAT(:))
        ZSRCLATINT(:) = TD%NDMT%AL(JP)%XQINOUT(:)*(    NB%AL(JP)%XQIN_FLAT(:))
        !
        ZSRCHVACCL(:) = TD%NDMT%AL(JP)%XHVAC_COOL(:)
        ZSRCHVACHT(:) = TD%NDMT%AL(JP)%XHVAC_HEAT(:)
        !
     ELSE
        ZSRCSENINT(:) = 0.0
        ZSRCLATINT(:) = 0.0
        ZSRCHVACCL(:) = 0.0
        ZSRCHVACHT(:) = 0.0
     ENDIF
     !
     ! For CBEM=DEF the heat flux into the ground floor and convective 
     ! air exchange between indoor air and the roof and walls become
     ! source terms
     !
     IF (TOP%CBEM.EQ."DEF") THEN
        ZSRCFLXFLO(:) = ZFLUXFLOOR(:)
        ZSRCFLXROF(:) = NT%AL(JP)%XBLD(:)*ZFLX_BLD_ROOF(:)
        ZSRCFLXWAL(:) = NT%AL(JP)%XBLD(:)*NT%AL(JP)%XWALL_O_BLD(:)*0.5*(ZFLX_BLD_WALL_A(:)+ZFLX_BLD_WALL_B(:))
     ELSE
        ZSRCFLXFLO(:) = 0.0
        ZSRCFLXROF(:) = 0.0
        ZSRCFLXWAL(:) = 0.0
     ENDIF
     !
     ZSRCHTRAFF(:) = ZH_TRAFFIC(:)
     ZSRCLTRAFF(:) = ZLE_TRAFFIC(:)
     ZSRCHINDUS(:) = NT%AL(JP)%XH_INDUSTRY(:)
     ZSRCLINDUS(:) = NT%AL(JP)%XLE_INDUSTRY(:)
     !
     ! Use the modulated fields of traffic and industry releases for the output
     !
     TD%NDMT%AL(JP)%XH_TRAFFIC_OUT(:)   = ZH_TRAFFIC(:)
     TD%NDMT%AL(JP)%XLE_TRAFFIC_OUT(:)  = ZLE_TRAFFIC(:)
     TD%NDMT%AL(JP)%XH_INDUSTRY_OUT (:) = NT%AL(JP)%XH_INDUSTRY(:)
     TD%NDMT%AL(JP)%XLE_INDUSTRY_OUT(:) = NT%AL(JP)%XLE_INDUSTRY(:)
     !
     ! Latent heat increase due to rain and snow
     ! on non-garden surfaces (W/m²(urb))
     !
     ZSRCLATRAI(:) = (1.0-NT%AL(JP)%XGARDEN(:))*XLVTT*PRAIN(:)
     ZSRCLATSNO(:) = (1.0-NT%AL(JP)%XGARDEN(:))*XLSTT*PSN(:)
     !
     ! Latent heat increase due to road and garden irrigation (W/m²(urb))
     !
     ZSRCLATROI(:) = NT%AL(JP)%XROAD(:)*XLVTT*TD%NDMT%AL(JP)%XIRRIG_ROAD(:)
     ZSRCLATGRI(:) = XLVTT*NT%AL(JP)%XBLD(:)*NT%AL(JP)%XGREENROOF(:)*TD%NDMT%AL(JP)%XIRRIG_GREENROOF(:)
     !
     ! Latent heat decrease due to run-off (W/m²(urb))
     !
     ZSRCRUNROF(:) = -NT%AL(JP)%XBLD(:) *XLVTT*TD%NDMT%AL(JP)%XRUNOFF_ROOF(:)
     ZSRCRUNROD(:) = -NT%AL(JP)%XROAD(:)*XLVTT*TD%NDMT%AL(JP)%XRUNOFF_ROAD(:)
     !
     ! Latent heat decrease to to run-off not going to sewer (W/m²(urb))
     !
     ZSRCNOCROF(:) = -NT%AL(JP)%XBLD(:) *XLVTT*TD%NDMT%AL(JP)%XNOC_ROOF(:)
     ZSRCNOCROD(:) = -NT%AL(JP)%XROAD(:)*XLVTT*TD%NDMT%AL(JP)%XNOC_ROAD(:)
     !
     !
     ! Conversion from latent to sensible heat during
     ! condensation on roofs and roads (W/m²(urb))
     !
     ZCONV_LAT_SEN_ROAD(:) = NT%AL(JP)%XROAD(:)*ZCONV_LAT_SEN_ROAD(:)
     ZCONV_LAT_SEN_ROOF(:) = NT%AL(JP)%XBLD (:)*ZCONV_LAT_SEN_ROOF(:)
     !
     ! Heating/cooling of rain water falling on roofs and roads (W/m²(urb))
     !
     ZHEAT_RR_ROAD(:) = -NT%AL(JP)%XROAD(:)*ZHEAT_RR_ROAD(:)
     ZHEAT_RR_ROOF(:) = -NT%AL(JP)%XBLD (:)*ZHEAT_RR_ROOF(:)
     !
     ! Heating/cooling due to snow falling on roofs and road (W/m²(urb))
     !
     ZSEN_SNOW_DIF_ROAD(:)=NT%AL(JP)%XROAD(:)*ZSEN_SNOW_DIF_ROAD(:)
     ZSEN_SNOW_DIF_ROOF(:)=(1.0-NT%AL(JP)%XGREENROOF(:))*NT%AL(JP)%XBLD (:)*ZSEN_SNOW_DIF_ROOF(:)
     !
     ! Sum of sources and sinks separed for latent and sensible heat (W/m²(urb))
     !
     ZSRCSENSUM(:) = ZSRCSENFLX(:) + ZSRCNETRAD(:) - ZSRCPROPAN(:) + &
          ZSRCSENINT(:)+ZSRCFLXFLO + ZSRCFLXROF +  ZSRCFLXWAL       + &
          ZSRCHVACCL(:)+ZSRCHVACHT(:)+ZSRCHTRAFF(:)+ZSRCHINDUS(:)   + &
          ZHEAT_RR_ROAD(:)+ZHEAT_RR_ROOF(:)+ZSEN_SNOW_DIF_ROAD(:)   + &
          ZSEN_SNOW_DIF_ROOF(:)-ZSEN_MELT_ROAD(:)-ZSEN_MELT_ROOF(:) - &
          ZDIFFTHESNOWROAD(:)-ZDIFFTHESNOWROOF(:)+ZSRCSTOGAR(:) - ZSEN_GREENROOF(:)
     !
     ZSRCLATSUM(:) = ZSRCLATFLX(:) + ZSRCLATINT(:)      + &
          ZSRCLTRAFF(:) + ZSRCLINDUS(:)+ZSRCLATRAI(:)+ZSRCLATSNO(:)  + &
          ZSRCLATROI(:)+ZSRCLATGRI(:)+ZSRCRUNROF(:) + ZSRCRUNROD(:)  + &
          ZSRCNOCROF(:) + ZSRCNOCROD(:) - ZDIFF_SNOW_WAT_ROAD(:)     - &
          ZDIFF_SNOW_WAT_ROOF(:) - ZLAT_GREENROOF(:)                 
     !
     ! Total sum with conversion terms
     !
     ZSRCALLSUM(:) = ZSRCSENSUM(:)+ZSRCLATSUM(:)+ZCONV_LAT_SEN_ROAD(:)+ZCONV_LAT_SEN_ROOF(:)
     !
     ! ####################################################
     ! E: Water budget
     ! ####################################################
     !
     ! Variation in soil water contents
     !
     IF (TOP%LURBHYDRO) THEN
        ZDIFFWATER_ROAD  (:)=0.0
        ZDIFFWATER_BLD   (:)=0.0
        ZDIFFWATER_GARDEN(:)=0.0
        DO JLAYER=1,SIZE(NT%AL(JP)%XT_ROAD,2)
           ZDIFFWATER_ROAD(:)  = NT%AL(JP)%XROAD(:)   * NT%AL(JP)%XD_ROAD(:,JLAYER) * &
                                 HM%NTH%AL(JP)%XWG_ROAD(:,JLAYER)
           ZDIFFWATER_BLD (:)  = NT%AL(JP)%XBLD (:)   * NT%AL(JP)%XD_ROAD(:,JLAYER) * &
                                 HM%NTH%AL(JP)%XWG_BLD (:,JLAYER)
           ZDIFFWATER_GARDEN(:)= NT%AL(JP)%XGARDEN(:) * NT%AL(JP)%XD_ROAD(:,JLAYER) * &
                                 GDM%NPE%AL(JP)%XWG(:,JLAYER)
        ENDDO
        ZDIFFWATER_ROAD  (:) = (ZDIFFWATER_ROAD  (:) - ZWATER_ROAD  (:))/PTSTEP
        ZDIFFWATER_BLD   (:) = (ZDIFFWATER_BLD   (:) - ZWATER_BLD   (:))/PTSTEP
        ZDIFFWATER_GARDEN(:) = (ZDIFFWATER_GARDEN(:) - ZWATER_GARDEN(:))/PTSTEP
        ZDIFFWATER_TOTAL (:) = ZDIFFWATER_ROAD(:)+ZDIFFWATER_BLD(:)+ZDIFFWATER_GARDEN(:)
     ENDIF
     !
     !
     ! #######################################################
     ! Save results of current time step 
     ! #######################################################
     !
     GCHECK_BUDGET(:) = .TRUE.
     WHERE (NT%AL(JP)%XENETOTAL.EQ.XUNDEF) GCHECK_BUDGET = .FALSE.
     !
     NT%AL(JP)%XENETOTAL(:)   = ZENETOTAL(:)
     NT%AL(JP)%XTHEWALL(:)    = ZTHEWALL(:)
     NT%AL(JP)%XTHEROOF(:)    = ZTHEROOF(:)
     NT%AL(JP)%XTHEFLOOR(:)   = ZTHEFLOOR(:)
     NT%AL(JP)%XTHESOILBLD(:) = ZTHESOILBLD(:)
     NT%AL(JP)%XTHEMASS(:)    = ZTHEMASS(:)
     NT%AL(JP)%XTHEROAD(:)    = ZTHEROAD(:)
     NT%AL(JP)%XTHEAIRIN(:)   = ZTHEAIRIN(:)
     NT%AL(JP)%XTHETOTAL(:)   = ZTHETOTAL(:)
     NT%AL(JP)%XLATWATROOF(:) = ZLATWATROOF(:)
     NT%AL(JP)%XLATWATROAD(:) = ZLATWATROAD(:)
     NT%AL(JP)%XLATICEROOF(:) = ZLATICEROOF(:)
     NT%AL(JP)%XLATICEROAD(:) = ZLATICEROAD(:)
     NT%AL(JP)%XLATAIRIN(:)   = ZLATAIRIN(:)
     NT%AL(JP)%XLATTOTAL(:)   = ZLATTOTAL(:)
     !
     ! The model is halted when there is a violation of 
     ! energy conservation of more than 1.0E-6 W/m²(urb)
     !
     DO JJ=1,SIZE(ZDIFFENETOTAL)
        !
        IF (GCHECK_BUDGET(JJ)) THEN
           !
           IF ( ISNAN(ZDIFFENETOTAL(JJ)) .OR. ISNAN(ZSRCALLSUM(JJ)) .OR. &
                (ABS(ZDIFFENETOTAL(JJ)-ZSRCALLSUM(JJ)).GT.1.0E-3) ) THEN
              !
              CALL GET_LUOUT(HPROGRAM,ILUOUT)
              !
              WRITE(ILUOUT,*) "                                                                      "
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) "NAN or violation of energy conservation, JJ= ",JJ
              WRITE(ILUOUT,*) "Solar time [s] :                             ",PTSUN(JJ)
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) "Difference of energy stored ------------------------------------------"
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Floor sensible heat     (W/m²(urb)): ",ZDIFFTHEFLOOR(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "bld soil sensible heat  (W/m²(urb)): ",ZDIFFTHESOILBLD(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Roof sensible heat      (W/m²(urb)): ",ZDIFFTHEROOF(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Wall sensible heat      (W/m²(urb)): ",ZDIFFTHEWALL(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Mass sensible heat      (W/m²(urb)): ",ZDIFFTHEMASS(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Road sensible heat      (W/m²(urb)): ",ZDIFFTHEROAD(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Road snow sen heat      (W/m²(urb)): ",ZDIFFTHESNOWROAD(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Roof snow sen heat      (W/m²(urb)): ",ZDIFFTHESNOWROOF(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "In air sensible heat    (W/m²(urb)): ",ZDIFFTHEAIRIN(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Roof wat latent heat    (W/m²(urb)): ",ZDIFFLATWATROOF(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Roof ice latent heat    (W/m²(urb)): ",ZDIFFLATICEROOF(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Road wat latent heat    (W/m²(urb)): ",ZDIFFLATWATROAD(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Road ice latent heat    (W/m²(urb)): ",ZDIFFLATICEROAD(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Indo air latent heat    (W/m²(urb)): ",ZDIFFLATAIRIN(JJ)
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Total sensible heat     (W/m²(urb)): ",ZDIFFTHETOTAL(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Total    latent heat    (W/m²(urb)): ",ZDIFFLATTOTAL(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Total           heat    (W/m²(urb)): ",ZDIFFENETOTAL(JJ)
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) "Sources and sinks ----------------------------------------------------"
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Sensible heat flux   (W/m²(Urb)): ",ZSRCSENFLX(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Latent   heat flux   (W/m²(Urb)): ",ZSRCLATFLX(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Net radiation        (W/m²(Urb)): ",ZSRCNETRAD(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Solar panel prod.    (W/m²(Urb)): ",ZSRCPROPAN(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Internal heat, sen   (W/m²(Urb)): ",ZSRCSENINT(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Internal heat, lat   (W/m²(Urb)): ",ZSRCLATINT(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Cooling demand       (W/m²(Urb)): ",ZSRCHVACCL(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Heating demand       (W/m²(Urb)): ",ZSRCHVACHT(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Flux to ground floor (W/m²(Urb)): ",ZSRCFLXFLO(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Flux roof to indoor  (W/m²(Urb)): ",ZSRCFLXROF(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Flux wall to indoor  (W/m²(Urb)): ",ZSRCFLXWAL(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Traffic sensible     (W/m²(Urb)): ",ZSRCHTRAFF(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Traffic latent       (W/m²(Urb)): ",ZSRCLTRAFF(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Industry sensible    (W/m²(Urb)): ",ZSRCHINDUS(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Industry latent      (W/m²(Urb)): ",ZSRCLINDUS(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Rain latent          (W/m²(Urb)): ",ZSRCLATRAI(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Snow latent          (W/m²(Urb)): ",ZSRCLATSNO(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Road irrig. latent   (W/m²(Urb)): ",ZSRCLATROI(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Green roof ir. lat.  (W/m²(Urb)): ",ZSRCLATGRI(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Rain h/c road        (W/m²(Urb)): ",ZHEAT_RR_ROAD(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Rain h/c roof        (W/m²(Urb)): ",ZHEAT_RR_ROOF(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Snow h/c road        (W/m²(Urb)): ",ZSEN_SNOW_DIF_ROAD(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Snow h/c roof        (W/m²(Urb)): ",ZSEN_SNOW_DIF_ROOF(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Garden sensible heat (W/m²(urb)): ",ZSRCSTOGAR(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Green roof sen. heat (W/m²(urb)): ",ZSEN_GREENROOF(JJ)
              WRITE(ILUOUT,'(A34,1X,F10.4)') "Green roof lat. heat (W/m²(urb)): ",ZLAT_GREENROOF(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Roof runoff          (W/m²(Urb)): ",ZSRCRUNROF(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Road runoff          (W/m²(Urb)): ",ZSRCRUNROD(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Roof runoff no sewer (W/m²(Urb)): ",ZSRCNOCROF(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Road runoff no sewer (W/m²(Urb)): ",ZSRCNOCROD(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Sen heat melt road   (W/m²(Urb)): ",ZSEN_MELT_ROAD(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Sen heat melt roof   (W/m²(Urb)): ",ZSEN_MELT_ROOF(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Snow water conv road (W/m²(Urb)): ",ZDIFF_SNOW_WAT_ROAD(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Snow water conv roof (W/m²(Urb)): ",ZDIFF_SNOW_WAT_ROOF(JJ)
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Sensible sum         (W/m²(Urb)): ",ZSRCSENSUM(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Latent sum           (W/m²(Urb)): ",ZSRCLATSUM(JJ)
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) " Conversion between latent and sensible heat                          "
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Roof                 (W/m²(Urb)): ",ZCONV_LAT_SEN_ROOF(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Road                 (W/m²(Urb)): ",ZCONV_LAT_SEN_ROAD(JJ)
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Total sum            (W/m²(Urb)): ",ZSRCALLSUM(JJ)
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) " Storage difference - sources and sinks (must be zero)                "
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,'(A35,1X,F10.4)') "Energy budget imb.   (W/m²(Urb)): ",ZDIFFENETOTAL(JJ)-ZSRCALLSUM(JJ)
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) "Diagnostics of outdoor longwave radiation imbalance not               "
              WRITE(ILUOUT,*) "detectable by the energy budget based on net radiation                "
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Garden <--> Wall A  (W/m²(Urb)): ",ZLW_WALA_TO_GARD(JJ)+ZLW_GARD_TO_WALA(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Garden <--> Wall B  (W/m²(Urb)): ",ZLW_WALB_TO_GARD(JJ)+ZLW_GARD_TO_WALB(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Road   <--> Wall A  (W/m²(Urb)): ",ZLW_WALA_TO_ROAD(JJ)+ZLW_ROAD_TO_WALA(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Road   <--> Wall B  (W/m²(Urb)): ",ZLW_WALB_TO_ROAD(JJ)+ZLW_ROAD_TO_WALB(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Snow   <--> Wall A  (W/m²(Urb)): ",ZLW_WALA_TO_SNOW(JJ)+ZLW_SNOW_TO_WALA(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Snow   <--> Wall B  (W/m²(Urb)): ",ZLW_WALB_TO_SNOW(JJ)+ZLW_SNOW_TO_WALB(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Window <--> Walls   (W/m²(Urb)): ", & 
                   ZLW_WALL_TO_WIND(JJ)+(ZLW_WIND_TO_WALA(JJ)+ZLW_WIND_TO_WALB(JJ))
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Window <--> Road    (W/m²(Urb)): ",ZLW_ROAD_TO_WIND(JJ)+ZLW_WIND_TO_ROAD(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Window <--> Garden  (W/m²(Urb)): ",ZLW_GARD_TO_WIND(JJ)+ZLW_WIND_TO_GARD(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Window <--> Snow    (W/m²(Urb)): ",ZLW_SNOW_TO_WIND(JJ)+ZLW_WIND_TO_SNOW(JJ)
              WRITE(ILUOUT,'(A35,1X,F10.4)') " Wall A <--> Wall B  (W/m²(Urb)): ",ZLW_WALB_TO_WALA(JJ)+ZLW_WALA_TO_WALB(JJ)
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) "Model halt due to violation of energy conservation "
              WRITE(ILUOUT,*) "This can be due to coding errors or missing        "
              WRITE(ILUOUT,*) "reservoirs and processes, please check             "
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              WRITE(ILUOUT,*) "----------------------------------------------------------------------"
              CALL FLUSH(ILUOUT)
              !

 !          IF ( ISNAN(ZDIFFENETOTAL(JJ)) .OR. ISNAN(ZSRCALLSUM(JJ)) .OR. &
 !               (ABS(ZDIFFENETOTAL(JJ)-ZSRCALLSUM(JJ)).GT.1.0E-3) ) &
              !CALL ABOR1_SFX("NAN or violation of energy conservation, check report") !cecile 
              ! cecile :  deconnection bilan d'energie pour tester autres combinaisons d'options
              !
           ENDIF
        ENDIF
     ENDDO
     !
     ! Robert: Calculation of new output diagnostics
     !
     ! Sensible and latent heat storage in urban fabric (W/m²(urb))
     !
     TD%NDMT%AL(JP)%XSENFABSTOR(:)=ZDIFFTHEFLOOR(:)+ZDIFFTHESOILBLD(:)+ZDIFFTHEROOF(:)+ZDIFFTHEWALL(:)  + &
          ZDIFFTHEMASS(:) +ZDIFFTHEROAD(:)+ZDIFFTHEAIRIN(:)
     !
     TD%NDMT%AL(JP)%XLATFABSTOR(:)=ZDIFFLATWATROOF(:)+ZDIFFLATICEROOF(:)+ZDIFFLATWATROAD(:) + &
          ZDIFFLATICEROAD(:)+ZDIFFLATAIRIN(:)
     !
     ! Total thickness of roof, wall and mass
     !
     TD%NDMT%AL(JP)%XROOFTK(:)=0.0
     DO JLAYER=1,SIZE(NT%AL(JP)%XT_ROOF,2)
        TD%NDMT%AL(JP)%XROOFTK(:)=TD%NDMT%AL(JP)%XROOFTK(:)+NT%AL(JP)%XD_ROOF(:,JLAYER)
     ENDDO
     !
     TD%NDMT%AL(JP)%XWALLTK(:)=0.0
     DO JLAYER=1,SIZE(NT%AL(JP)%XT_WALL_A,2)
        TD%NDMT%AL(JP)%XWALLTK(:)=TD%NDMT%AL(JP)%XWALLTK(:)+NT%AL(JP)%XD_WALL(:,JLAYER)
     ENDDO
     !
     IF (TOP%CBEM.EQ."BEM") THEN
        TD%NDMT%AL(JP)%XMASSTK(:)=0.0
        DO JJ=1,SIZE(NB%AL(JP)%XN_FLOOR)
           IF (NB%AL(JP)%XN_FLOOR(JJ).GT.1.5) THEN
              DO JLAYER=1,SIZE(NB%AL(JP)%XD_MASS,2)
                 TD%NDMT%AL(JP)%XMASSTK(JJ)=TD%NDMT%AL(JP)%XMASSTK(JJ)+NB%AL(JP)%XD_MASS(JJ,JLAYER)
              ENDDO
           ENDIF
        ENDDO
     END IF
     !
     ! Conversion of internal heat release as well 
     ! as heating and cooling from W/m²(urb) into kWh/m²(floor)/a
     !
     IF (TOP%CBEM.EQ."BEM") THEN
        TD%NDMT%AL(JP)%XQIN_KWH     (:) = ( 0.365 * 24.0 * TD%NDMT%AL(JP)%XQINOUT(:)   ) / &
             ( NT%AL(JP)%XBLD(:) * NB%AL(JP)%XN_FLOOR(:) )
        TD%NDMT%AL(JP)%XHVAC_HT_KWH (:) = ( 0.365 * 24.0 * TD%NDMT%AL(JP)%XHVAC_HEAT(:)) / &
             ( NT%AL(JP)%XBLD(:) * NB%AL(JP)%XN_FLOOR(:) )
        TD%NDMT%AL(JP)%XHVAC_CL_KWH (:) = ( 0.365 * 24.0 * TD%NDMT%AL(JP)%XHVAC_COOL(:)) / &
             ( NT%AL(JP)%XBLD(:) * NB%AL(JP)%XN_FLOOR(:) )
     ENDIF
     !
     ! End verification of energy conservation
     ! ################################################################
     !
     !-------------------------------------------------------------------------------------
     ! Diagnostics on each patch
     !-------------------------------------------------------------------------------------
     !
     IF (TD%MTO%LSURF_MISC_BUDGET) THEN
        !
        ! cumulated diagnostics 
        ! ---------------------
        !
        CALL CUMUL_DIAG_TEB_n(TD%NDMTC%AL(JP),  TD%NDMT%AL(JP),  &
                              GDM%VD%ND%AL(JP), GDM%VD%NDC%AL(JP), GDM%VD%NDEC%AL(JP), GDM%VD%NDE%AL(JP), &
                              GRM%VD%ND%AL(JP), GRM%VD%NDC%AL(JP), GRM%VD%NDEC%AL(JP), GRM%VD%NDE%AL(JP), TOP, PTSTEP, PRAIN, PSN)
        !
     ENDIF
     !
     !-------------------------------------------------------------------------------------
     ! Computes averaged parameters necessary for UTCI
     !-------------------------------------------------------------------------------------
     IF (TD%O%N2M >0 .AND. TD%DU%LUTCI) THEN
        !      
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_REF_SW_GRND ,TD%NDMT%AL(JP)%XREF_SW_GRND )
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_REF_SW_FAC  ,TD%NDMT%AL(JP)%XREF_SW_FAC )
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_REF_SW_HVEG ,ZREF_SW_HVEG )
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_SCA_SW      ,ZSCA_SW      )
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_DIR_SW      ,ZDIR_SW      )
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_DIR_SW_ROAD ,TD%NDMT%AL(JP)%XDIR_SW_ROAD )
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_EMIT_LW_FAC ,TD%NDMT%AL(JP)%XEMIT_LW_FAC )
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_EMIT_LW_GRND,TD%NDMT%AL(JP)%XEMIT_LW_GRND)
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_EMIT_LW_HVEG,ZEMIT_LW_HVEG)
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_SCA_SW_SKY  ,ZSCA_SW_SKY  )
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_LW_RAD_SKY  ,ZLW_RAD_SKY  )
        !
        IF (TOP%LGARDEN .AND. TOP%CURBTREE/='NONE') THEN                 !cecile
           CALL ADD_PATCH_CONTRIB(JP,ZAVG_H_LAI_MAX   ,GDM%K%XH_LAI_MAX) !cecile
        ELSE                                                             !cecile
           ZAVG_H_LAI_MAX(:)   = 0.                                      !cecile
        ENDIF                                                            !cecile
        !
        DO JCOMP=1,BOP%NBEMCOMP
           CALL ADD_PATCH_CONTRIB(JP, ZAVG_T_RAD_IND(:,JCOMP), TD%NDMT%AL(JP)%XT_RAD_IND(:,JCOMP) )
           CALL ADD_PATCH_CONTRIB(JP, ZAVG_TI_BLD(:,JCOMP)   , NB%AL(JP)%XTI_BLD(:,JCOMP) )
           CALL ADD_PATCH_CONTRIB(JP, ZAVG_QI_BLD(:,JCOMP)   , NB%AL(JP)%XQI_BLD(:,JCOMP) )
        ENDDO
        !
     ENDIF
     !
     !-------------------------------------------------------------------------------------
     ! Use of the canopy version of TEB
     !-------------------------------------------------------------------------------------
     !
     IF (TOP%LCANOPY) THEN
        !
        !-------------------------------------------------------------------------------------
        ! Town averaged quantities to force canopy atmospheric layers
        !-------------------------------------------------------------------------------------
        !
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_DUWDU_GRND ,ZDUWDU_GRND )
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_UW_ROOF ,ZUW_RF)
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_DUWDU_ROOF ,ZDUWDU_RF)
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_H_WALL ,0.5*(TD%NDMT%AL(JP)%XH_WALL_A+TD%NDMT%AL(JP)%XH_WALL_B))
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_E_WALL ,(0.5*(TD%NDMT%AL(JP)%XLE_WALL_A + TD%NDMT%AL(JP)%XLE_WALL_B))/XLVTT)
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_H_ROOF ,(TD%NDMT%AL(JP)%XH_ROOF+NT%AL(JP)%XH_INDUSTRY))
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_E_ROOF ,(TD%NDMT%AL(JP)%XLE_ROOF+NT%AL(JP)%XLE_INDUSTRY)/XLVTT)
        IF (TOP%LGARDEN .AND. TOP%CURBTREE/='NONE') THEN
           CALL ADD_PATCH_CONTRIB(JP,ZAVG_URBTREE,NT%AL(JP)%XURBTREE   )
           !   Average of turbulent fluxes and LAD profile on TEB patchs and CANOPY layers
           !
           DO JLAYER=1,SB%NLVL
              CALL ADD_PATCH_CONTRIB(JP,ZAVG_DH_HVEG(:,JLAYER),ZDH_HVEG (:,JLAYER))
              CALL ADD_PATCH_CONTRIB(JP,ZAVG_DE_HVEG(:,JLAYER),ZDLE_HVEG(:,JLAYER)/XLVTT)
              CALL ADD_PATCH_CONTRIB(JP,ZAVG_LAD_CAN(:,JLAYER),ZLAD_CAN(:,JLAYER))
           ENDDO
        ELSE
           ZAVG_URBTREE(:)   = 0.
           ZAVG_DH_HVEG(:,:) = 0.
           ZAVG_DE_HVEG(:,:) = 0.
           ZAVG_LAD_CAN(:,:) = 0.
        ENDIF
        !
        !-------------------------------------------------------------------------------------
        ! Computes the impact of canopy and surfaces on air
        !-------------------------------------------------------------------------------------
        !
        ZAC_GRND    (:) = (NT%AL(JP)%XROAD(:)*ZAC_RD    (:) + &
             NT%AL(JP)%XGARDEN(:)*ZAC_GD    (:)) / (NT%AL(JP)%XROAD(:)+NT%AL(JP)%XGARDEN(:))
        ZAC_GRND_WAT(:) = (NT%AL(JP)%XROAD(:)*ZAC_RD_WAT(:) + &
             NT%AL(JP)%XGARDEN(:)*ZAC_GD_WAT(:)) / (NT%AL(JP)%XROAD(:)+NT%AL(JP)%XGARDEN(:))
        !
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_AC_GRND     ,ZAC_GRND    )
        CALL ADD_PATCH_CONTRIB(JP,ZAVG_AC_GRND_WAT ,ZAC_GRND_WAT)
        CALL ADD_PATCH_CONTRIB(JP,ZSFLUX_U ,ZUW_GRND * (1.-NT%AL(JP)%XBLD))
        CALL ADD_PATCH_CONTRIB(JP,ZSFLUX_T ,ZH_GRND  * (1.-NT%AL(JP)%XBLD)/XCPD/PRHOA)
        CALL ADD_PATCH_CONTRIB(JP,ZSFLUX_Q ,ZLE_GRND * (1.-NT%AL(JP)%XBLD)/XLVTT)
        !
     END IF
     !
     !-------------------------------------------------------------------------------------
     ! end of loop on TEB patches
  END DO
  !-------------------------------------------------------------------------------------
  !
  !-------------------------------------------------------------------------------------
  !* Evolution of canopy air if canopy option is active
  !-------------------------------------------------------------------------------------
  !
  IF (TOP%LCANOPY) THEN
     !
     ! Test POUR sde-boqer
     CALL SM10(SB%XZ, ZAVG_BLD_HEIGHT, ZLAMBDA_F, ZL, ZLTREE)
     !
     !-------------------------------------------------------------------------------------
     !* Impact of TEB fluxes on the air
     !-------------------------------------------------------------------------------------
     !
     CALL TEB_CANOPY(KI, SB, ZAVG_BLD, ZAVG_BLD_HEIGHT, ZAVG_WL_O_HOR, PPA, PRHOA, &
          ZAVG_DUWDU_GRND, ZAVG_UW_RF, ZAVG_DUWDU_RF, ZAVG_H_WL,         &
          ZAVG_E_WL, ZAVG_H_RF, ZAVG_E_RF, ZAVG_DH_HVEG, ZAVG_DE_HVEG,   &
          ZAVG_AC_GRND,ZAVG_AC_GRND_WAT, ZAVG_URBTREE, ZAVG_LAD_CAN, ZFORC_U, &
          ZDFORC_UDU, ZFORC_E, ZDFORC_EDE, ZFORC_T, ZDFORC_TDT, ZFORC_Q, &
          ZDFORC_QDQ )
     !
     !-------------------------------------------------------------------------------------
     !* Evolution of canopy air due to these impacts
     !-------------------------------------------------------------------------------------
     !
     CALL CANOPY_EVOL(SB, KI, PTSTEP, 2, ZL, ZWIND, PTA, PQA, PPA, PRHOA,  &
          ZSFLUX_U, ZSFLUX_T, ZSFLUX_Q, ZFORC_U, ZDFORC_UDU,    &
          ZFORC_E, ZDFORC_EDE, ZFORC_T, ZDFORC_TDT, ZFORC_Q,    &
          ZDFORC_QDQ, SB%XLM, SB%XLEPS, ZAVG_USTAR, ZALFAU,   &
          ZBETAU, ZALFAT, ZBETAT, ZALFAQ, ZBETAQ      )
     !
     !-------------------------------------------------------------------------------------
     ! Momentum fluxes in the case canopy is active
     !-------------------------------------------------------------------------------------
     !
     PSFU=0.
     PSFV=0.
     ZAVG_Z0_TOWN(:) = MIN(ZAVG_Z0_TOWN(:),PUREF(:)*0.5)
     ZAVG_CDN=(XKARMAN/LOG(PUREF(:)/ZAVG_Z0_TOWN(:)))**2
     ZAVG_CD = ZAVG_CDN
     ZAVG_RI = 0.
     DO JJ=1,SIZE(PU)
        IF (ZWIND(JJ)>0.) THEN
           ZCOEF(JJ) = - PRHOA(JJ) * ZAVG_USTAR(JJ)**2 / ZWIND(JJ)
           PSFU(JJ) = ZCOEF(JJ) * PU(JJ)
           PSFV(JJ) = ZCOEF(JJ) * PV(JJ)
           ZAVG_CD(JJ) = ZAVG_USTAR(JJ)**2 / ZWIND(JJ)**2
           ZAVG_RI(JJ) = -XG/PTA(JJ)*ZSFLUX_T(JJ)/ZAVG_USTAR(JJ)**4
        ENDIF
     ENDDO
     !
     !-------------------------------------------------------------------------------------
     !* Update of canyon parameters at the end of the time step for the consistance of diagnostics
     !-------------------------------------------------------------------------------------
     !
     DO JLAYER=1,SB%NLVL-1
        DO JI=1,KI
           !* finds middle canyon layer
           IF (SB%XZ(JI,JLAYER)<ZAVG_BLD_HEIGHT(JI)/2. .AND. &
                SB%XZ(JI,JLAYER+1)>=ZAVG_BLD_HEIGHT(JI)/2.) THEN
              ZCOEF(JI) = (ZAVG_BLD_HEIGHT(JI)/2.-SB%XZ(JI,JLAYER))/(SB%XZ(JI,JLAYER+1)-SB%XZ(JI,JLAYER))
              ZU_CANYON(JI) = SB%XU(JI,JLAYER) + ZCOEF(JI) * (SB%XU(JI,JLAYER+1)-SB%XU(JI,JLAYER))
              ZT_CANYON(JI) = SB%XT(JI,JLAYER) + ZCOEF(JI) * (SB%XT(JI,JLAYER+1)-SB%XT(JI,JLAYER))
              ZQ_CANYON(JI) =(SB%XQ(JI,JLAYER) + ZCOEF(JI) * &
                   (SB%XQ(JI,JLAYER+1)-SB%XQ(JI,JLAYER)))/PRHOA(JI)
           END IF
        END DO
     END DO
     ZU_CANYON= MAX(ZU_CANYON,0.2)
     !
     DO JP=1,TOP%NTEB_PATCH
        NT%AL(JP)%XT_CANYON(:) = ZT_CANYON(:)
        NT%AL(JP)%XQ_CANYON(:) = ZQ_CANYON(:)
     ENDDO
     !
     !-------------------------------------------------------------------------------------
     ! End of specific case with canopy option
     !-------------------------------------------------------------------------------------
     !
  END IF
  !
  !-------------------------------------------------------------------------------------
  ! Outputs:
  !-------------------------------------------------------------------------------------
  !
  !-------------------------------------------------------------------------------------
  !Radiative properties should be at time t+1 (see by the atmosphere) in order to close
  !the energy budget between surfex and the atmosphere. It is not the case here
  !for ALB and EMIS
  !-------------------------------------------------------------------------------------
  !
  CALL AVERAGE_RAD(TOP%XTEB_PATCH, ZDIR_ALB_PATCH, ZSCA_ALB_PATCH, ZEMIS_PATCH, &
       ZTRAD_PATCH, PDIR_ALB, PSCA_ALB, PEMIS, PTRAD )
  !
  !-------------------------------------------------------------------------------
  !Physical properties see by the atmosphere in order to close the energy budget 
  !between surfex and the atmosphere. All variables should be at t+1 but very 
  !difficult to do. Maybe it will be done later. However, Ts can be at time t+1
  !-------------------------------------------------------------------------------
  !
  PTSURF (:) = PTRAD         (:) ! Should be the surface effective temperature; not radative
  PZ0    (:) = ZAVG_Z0_TOWN  (:) ! Should account for ISBA (greenroof and garden) Z0
  PZ0H   (:) = PZ0 (:) / 200.    ! Should account for ISBA (greenroof and garden) Z0
  PQSURF (:) = NT%AL(1)%XQ_CANYON(:) ! Should account for ISBA (greenroof and garden) Qs
  !
  !-------------------------------------------------------------------------------------
  ! Scalar fluxes:
  !-------------------------------------------------------------------------------------
  !
  ZAVG_USTAR    (:) = SQRT(SQRT(PSFU**2+PSFV**2))
  !
  !
  IF (CHT%SVT%NBEQ>0) THEN
     IBEG = CHT%SVT%NSV_CHSBEG
     IEND = CHT%SVT%NSV_CHSEND
     IF (CHT%CCH_DRY_DEP == "WES89") THEN
        CALL CH_DEP_TOWN(ZAVG_RESA_TOWN,  ZAVG_USTAR, PTA, PTRAD, ZAVG_WL_O_HOR,&
             PSV(:,IBEG:IEND), CHT%SVT%CSV(IBEG:IEND), CHT%XDEP(:,1:CHT%SVT%NBEQ)  )

        DO JI=IBEG,IEND
           DO JJ=1,SIZE(PSFTS,1)
              PSFTS(JJ,JI) = - PSV(JJ,JI) * CHT%XDEP(JJ,JI-IBEG+1)
           ENDDO
        ENDDO

        IF (CHT%SVT%NAEREQ > 0 ) THEN
           IBEG = CHT%SVT%NSV_AERBEG
           IEND = CHT%SVT%NSV_AEREND
           CALL CH_AER_DEP(PSV(:,IBEG:IEND), PSFTS(:,IBEG:IEND), &
                ZAVG_USTAR, ZAVG_RESA_TOWN, PTA, PRHOA)   
        END IF

     ELSE
        IBEG = CHT%SVT%NSV_CHSBEG
        IEND = CHT%SVT%NSV_CHSEND
        DO JI=IBEG,IEND
           PSFTS(:,JI) =0.
        ENDDO
        IBEG = CHT%SVT%NSV_AERBEG
        IEND = CHT%SVT%NSV_AEREND
        IF(IBEG.LT.IEND) THEN
           DO JI=IBEG,IEND
              PSFTS(:,JI) =0.
           ENDDO
        ENDIF
     ENDIF
  ENDIF

  IF (CHT%SVT%NDSTEQ>0) THEN
     ! Blindage à enlever lorsque que TEB aura été corrigé
     ZUSTAR(:)     = MIN(ZUSTAR(:), 10.)
     ZRESA_TOWN(:) = MAX(ZRESA_TOWN(:), 10.)
     !
     IBEG = CHT%SVT%NSV_DSTBEG
     IEND = CHT%SVT%NSV_DSTEND
     !
     CALL DSLT_DEP(PSV(:,IBEG:IEND), PSFTS(:,IBEG:IEND), ZUSTAR, ZRESA_TOWN, PTA, PRHOA, &
          DST%XEMISSIG_DST, DST%XEMISRADIUS_DST, JPMODE_DST, XDENSITY_DST, &
          XMOLARWEIGHT_DST, ZCONVERTFACM0_DST, ZCONVERTFACM6_DST,          &
          ZCONVERTFACM3_DST, LVARSIG_DST, LRGFIX_DST, CVERMOD  )  

     CALL MASSFLUX2MOMENTFLUX(         &
          PSFTS(:,IBEG:IEND),             & !I/O ![kg/m2/sec] In: flux of only mass, out: flux of moments
          PRHOA,                          & !I [kg/m3] air density
          DST%XEMISRADIUS_DST,                &!I [um] emitted radius for the modes (max 3)
          DST%XEMISSIG_DST,                   &!I [-] emitted sigma for the different modes (max 3)
          NDSTMDE,                        &
          ZCONVERTFACM0_DST,              &
          ZCONVERTFACM6_DST,              &
          ZCONVERTFACM3_DST,              &
          LVARSIG_DST, LRGFIX_DST         )  
  ENDIF
  IF (CHT%SVT%NSLTEQ>0) THEN
     !
     IBEG = CHT%SVT%NSV_SLTBEG
     IEND = CHT%SVT%NSV_SLTEND
     !
     CALL DSLT_DEP(PSV(:,IBEG:IEND), PSFTS(:,IBEG:IEND), ZUSTAR, ZRESA_TOWN, PTA, PRHOA, &
          SLT%XEMISSIG_SLT, SLT%XEMISRADIUS_SLT, JPMODE_SLT, XDENSITY_SLT, &
          XMOLARWEIGHT_SLT, ZCONVERTFACM0_SLT, ZCONVERTFACM6_SLT,          &
          ZCONVERTFACM3_SLT, LVARSIG_SLT, LRGFIX_SLT, CVERMOD  )  

     CALL MASSFLUX2MOMENTFLUX(         &
          PSFTS(:,IBEG:IEND),             & !I/O ![kg/m2/sec] In: flux of only mass, out: flux of moments
          PRHOA,                          & !I [kg/m3] air density
          SLT%XEMISRADIUS_SLT,                &!I [um] emitted radius for the modes (max 3)
          SLT%XEMISSIG_SLT,                   &!I [-] emitted sigma for the different modes (max 3)
          NSLTMDE,                        &
          ZCONVERTFACM0_SLT,              &
          ZCONVERTFACM6_SLT,              &
          ZCONVERTFACM3_SLT,              &
          LVARSIG_SLT, LRGFIX_SLT         ) 
  ENDIF
  !
  ! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  ! Inline diagnostics
  ! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  !
  CALL DIAG_INLINE_TEB_n(TD%O, TD%D, SB, NT%AL(1), TOP%LCANOPY, &
       PTA, PTRAD, ZQA, PPA, PPS, PRHOA, PU, PV, ZWIND, PZREF, PUREF, &
       ZAVG_CD, ZAVG_CDN, ZAVG_RI, ZAVG_CH, ZAVG_Z0_TOWN, PTRAD, PEMIS,    &
       PDIR_ALB, PSCA_ALB, PLW, ZDIR_SWB, ZSCA_SWB,  PSFTH, PSFTQ,    &
       PSFU, PSFV, PSFCO2, ZAVG_RN, ZAVG_H, ZAVG_LE, ZAVG_GFLX, ZAVG_QF )
  !
  !-------------------------------------------------------------------------------------
  ! Stores Canyon air and humidity if historical option of TEB is active
  !-------------------------------------------------------------------------------------
  !
  IF (.NOT. TOP%LCANOPY) THEN
     DO JP=1,TOP%NTEB_PATCH
        NT%AL(JP)%XT_CANYON(:) = ZAVG_T_CANYON(:)
        NT%AL(JP)%XQ_CANYON(:) = ZAVG_Q_CANYON(:)
     END DO
  END IF
  !          
  !-------------------------------------------------------------------------------------
  ! Thermal confort index
  !-------------------------------------------------------------------------------------
  !
  !
  !
  IF (TD%DU%LUTCI .AND. TD%O%N2M >0) THEN
     DO JJ=1,KI
        IF (TD%D%XZON10M(JJ)/=XUNDEF) THEN
           ZU_UTCI(JJ) = SQRT(TD%D%XZON10M(JJ)**2+TD%D%XMER10M(JJ)**2)
        ELSE
           ZU_UTCI(JJ) = ZWIND(JJ)
        ENDIF
     ENDDO
     !
     DO JCOMP=1,BOP%NBEMCOMP
        !
        CALL UTCI_TEB(NT%AL(1), TD%DU, JCOMP, HPROGRAM, ZAVG_TI_BLD(:,JCOMP), ZAVG_QI_BLD(:,JCOMP), &
             ZU_UTCI, PPS, ZAVG_REF_SW_GRND, ZAVG_REF_SW_FAC, ZAVG_SCA_SW, ZAVG_DIR_SW,             &
             PZENITH, ZAVG_EMIT_LW_FAC, ZAVG_EMIT_LW_GRND, ZAVG_EMIT_LW_HVEG, ZAVG_SCA_SW_SKY,      &
             ZAVG_LW_RAD_SKY, PLW, ZAVG_T_RAD_IND(:,JCOMP), ZAVG_H_LAI_MAX)
        !
        CALL UTCIC_STRESS(PTSTEP, TD%DU%XUTCI_IN(:,JCOMP), TD%DU%XUTCIC_IN(:,:,JCOMP) )
        !
     ENDDO
     !
     ! Aggregated outdoor UTCI according to sun and shade fractions
     DO JJ=1,KI
       IF (ZAVG_DIR_SW(JJ).GT.0.) THEN
         TD%DU%XUTCI_OUTAGG(JJ) = TD%DU%XUTCI_OUTSUN  (JJ)*(   ZAVG_DIR_SW_ROAD(JJ)/ZAVG_DIR_SW(JJ)) &
                                + TD%DU%XUTCI_OUTSHADE(JJ)*(1.-ZAVG_DIR_SW_ROAD(JJ)/ZAVG_DIR_SW(JJ))
       ELSE
         TD%DU%XUTCI_OUTAGG(JJ) = TD%DU%XUTCI_OUTSHADE(JJ)
       ENDIF
     ENDDO
     !
     ! Mean UTCI and TRAD
     !
     TD%DU%NCOUNT_UTCI_STEP    = TD%DU%NCOUNT_UTCI_STEP    + 1
     TD%DU%XUTCI_OUTSUN_MEAN   = TD%DU%XUTCI_OUTSUN_MEAN   + TD%DU%XUTCI_OUTSUN
     TD%DU%XUTCI_OUTSHADE_MEAN = TD%DU%XUTCI_OUTSHADE_MEAN + TD%DU%XUTCI_OUTSHADE
     TD%DU%XTRAD_SUN_MEAN      = TD%DU%XTRAD_SUN_MEAN      + TD%DU%XTRAD_SUN
     TD%DU%XTRAD_SHADE_MEAN    = TD%DU%XTRAD_SHADE_MEAN    + TD%DU%XTRAD_SHADE
     !
     CALL UTCIC_STRESS(PTSTEP,TD%DU%XUTCI_OUTSUN  ,TD%DU%XUTCIC_OUTSUN  )
     CALL UTCIC_STRESS(PTSTEP,TD%DU%XUTCI_OUTSHADE,TD%DU%XUTCIC_OUTSHADE)
     !
  ELSE IF (TD%DU%LUTCI) THEN
     TD%DU%XUTCI_IN(:,:) = XUNDEF
     TD%DU%XUTCI_OUTSUN(:) = XUNDEF
     TD%DU%XUTCI_OUTSHADE(:) = XUNDEF
     TD%DU%XUTCI_OUTSUN_MEAN(:) = XUNDEF
     TD%DU%XUTCI_OUTSHADE_MEAN(:) = XUNDEF
     TD%DU%XTRAD_SUN(:) = XUNDEF
     TD%DU%XTRAD_SHADE(:) = XUNDEF
     TD%DU%XTRAD_SUN_MEAN(:) = XUNDEF
     TD%DU%XTRAD_SHADE_MEAN(:) = XUNDEF
     TD%DU%XUTCIC_IN(:,:,:) = XUNDEF
     TD%DU%XUTCIC_OUTSUN(:,:) = XUNDEF
     TD%DU%XUTCIC_OUTSHADE(:,:) = XUNDEF
  ENDIF
  !
  IF (TOP%CBEM.EQ."BEM") THEN
     !
     DO JP=1,TOP%NTEB_PATCH
        !
        ! Update auxiliairy variable for pressure at previous time step.
        !
        NB%AL(JP)%XPSOLD(:)=PPS(:)
        !
        ! Determine the switch for shading status
        ! during vacancy at 7:00 solar time. 
        !
        DO JJ=1,SIZE(NB%AL(JP)%XSHADVACSW,1)
           DO JCOMP=1,BOP%NBEMCOMP
              IF ( (PTSUN(JJ).GE.7.0*3600.0).AND.(PTSUN(JJ).LT.(7.0*3600.0+PTSTEP) ) ) THEN
                 IF ((NB%AL(JP)%XTI_BLD(JJ,JCOMP).GT.NB%AL(JP)%XTDESV(JJ)).AND. &
                      (NB%AL(JP)%XTI_BLD(JJ,JCOMP).GT.NB%AL(JP)%XTHEAT_OCCD(JJ,JCOMP))) THEN
                    NB%AL(JP)%XSHADVACSW(JJ,JCOMP)=1.0
                 ELSE
                    NB%AL(JP)%XSHADVACSW(JJ,JCOMP)=0.0
                 ENDIF
              ENDIF
           ENDDO
        ENDDO
        !
        ! Determine the switch for ventilation status
        ! during night at 22:00 solar time.
        ! This status change might not be reasonable for all building uses
        !
        DO JJ=1,SIZE(NB%AL(JP)%XVENTNIGSW,1)
           DO JCOMP=1,BOP%NBEMCOMP
              IF ( (PTSUN(JJ).GE.22.0*3600.0).AND.(PTSUN(JJ).LT.(22.0*3600.0+PTSTEP) ) ) THEN
                 IF ((NB%AL(JP)%XTI_BLD(JJ,JCOMP).GT.NB%AL(JP)%XTDESV(JJ)).AND. &
                      (NB%AL(JP)%XTI_BLD(JJ,JCOMP).GT.NB%AL(JP)%XTHEAT_OCCD(JJ,JCOMP))) THEN
                    NB%AL(JP)%XVENTNIGSW(JJ,JCOMP) = 1.0
                 ELSE
                    NB%AL(JP)%XVENTNIGSW(JJ,JCOMP) = 0.0
                 ENDIF
              ENDIF
           ENDDO
        ENDDO
        !
     ENDDO
     !
  ENDIF
  !
  ! FIXME: This will have to be implemented.
  !        First tests are not at all promising.
  !
  ! Robert: Verification of the radiation budget at the end
  !
  ! ZLW_UP(:) = XSTEFAN * PEMIS(:) * PTRAD(:)**4
  !
  !ZSW_UP(:) = 0.0
  !ZSW_DO(:) = 0.0
  !DO JSWB=1,KSW
  !   ZSW_UP(:) = ZSW_UP(:) + PDIR_SW(:,JSWB) * PDIR_ALB(:,JSWB) + PSCA_SW(:,JSWB) * PSCA_ALB(:,JSWB)
  !   ZSW_DO(:) = ZSW_DO(:) + PDIR_SW(:,JSWB) + PSCA_SW (:,JSWB)
  !ENDDO
  !
  !ZNET_DIAG(:) = ZSW_DO(:) - ZSW_UP(:) + PLW(:) - ZLW_UP(:)
  !
  ! stop ("Check radiation diagnostics")
  !
  IF (LHOOK) CALL DR_HOOK('COUPLING_TEB_N',1,ZHOOK_HANDLE)
  !
  !-------------------------------------------------------------------------------------
CONTAINS
  SUBROUTINE ADD_PATCH_CONTRIB(JP,PAVG,PFIELD)
    INTEGER, INTENT(IN) :: JP
    REAL, DIMENSION(:), INTENT(INOUT) :: PAVG
    REAL, DIMENSION(:), INTENT(IN)    :: PFIELD
    !
    IF (JP==1) PAVG = 0.
    PAVG = PAVG + TOP%XTEB_PATCH(:,JP) * PFIELD(:)
    !
  END SUBROUTINE ADD_PATCH_CONTRIB
  !-------------------------------------------------------------------------------------
  !
END SUBROUTINE COUPLING_TEB_n


