!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE CONVERT_PATCH_TEB (HPROGRAM, BDD, DTB, DTCO, DTT, TOP, &
                                   PDEF_ROAD_DIR, T, B, TPN, DTH, THP, KTEB_ROAD )
!     ##############################################################
!
!!**** *CONVERT_PATCH_TEB* compilation of conver_cover_isba, pgd_isba_par and
!!      init_from_data_isba_parn
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    S. Faroux        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original             16/11/2010
!!    G. Pigeon               09/2012: add ROUGH_ROOF and ROUGH_WALL coef for outdoor conv. coef
!!    V. Masson               08/2013: adds solar panels
!!    E. Redon/A. Lemonsu     01/2016: add street trees
!!    K.Chancibault/A.Lemonsu 01/2016: add urban hydrology
!!    M. Goret                02/2017: add CO2 fluxes
!!    M. Goret                04/2017: suppress PEFF_HEAT
!!    M. Goret                10/2017: add hot water
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_DATA_TEB_HYDRO_n, ONLY : DATA_TEB_HYDRO_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
USE MODD_TYPE_DATE_SURF
!
USE MODD_TEB_n, ONLY : TEB_t
USE MODD_BEM_n, ONLY : BEM_t
USE MODD_TEB_PANEL_n, ONLY : TEB_PANEL_t
USE MODD_TEB_HYDRO_PGD_n, ONLY : TEB_HYDRO_PGD_t
!
USE MODD_SURF_PAR,       ONLY : XUNDEF, NUNDEF
!
USE MODD_DATA_COVER_PAR, ONLY : NDATA_ROAD_LAYER, NDATA_WALL_LAYER,               &
                                NDATA_ROOF_LAYER, NDATA_FLOOR_LAYER, NDATA_MASS_LAYER
USE MODD_DATA_COVER
!
USE MODI_THERMAL_LAYERS_CONF
USE MODI_THERMAL_LAYERS_CONF_ROAD
USE MODI_INI_DATA_PARAM_TEB
USE MODI_AV_PGD
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_ABOR1_SFX
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
CHARACTER(LEN=6), INTENT(IN)          :: HPROGRAM    ! program calling surf. schemes
REAL,                   INTENT(IN)    :: PDEF_ROAD_DIR ! default road direction
!
TYPE(DATA_TEB_HYDRO_t), INTENT(INOUT), OPTIONAL :: DTH
TYPE(TEB_t), INTENT(INOUT), OPTIONAL :: T
TYPE(BEM_t), INTENT(INOUT), OPTIONAL :: B
TYPE(TEB_PANEL_t), INTENT(INOUT), OPTIONAL :: TPN
TYPE(TEB_HYDRO_PGD_t), INTENT(INOUT), OPTIONAL :: THP
!
INTEGER, DIMENSION (:), INTENT(OUT), OPTIONAL   :: KTEB_ROAD
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
REAL, DIMENSION(:,:), ALLOCATABLE :: ZTC, ZHC, ZD
INTEGER, DIMENSION(SIZE(TOP%XCOVER,1)) :: ZISOWALLPOS
INTEGER, DIMENSION(SIZE(TOP%XCOVER,1)) :: ZISOROOFPOS
!
INTEGER               :: JLAYER    ! loop counter on layers
INTEGER               :: IL        ! number of points
INTEGER               :: JJ        ! loop counter
INTEGER               :: JCOMP     ! loop counter
REAL                  :: ZFRAC_VEG ! vegetation fraction (relative to town area)
!
 CHARACTER(LEN=3)      :: YAVG      ! Type of averaging for buildings
 CHARACTER(LEN=4)      :: YAREA     ! Area where parameter is averaged
!
!*    0.3    Declaration of namelists
!            ------------------------
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*    1.      Initializations
!             ---------------
!
IF (LHOOK) CALL DR_HOOK('CONVERT_PATCH_TEB',0,ZHOOK_HANDLE)
!
IF (TOP%CBLD_ATYPE=='ARI') THEN
  YAVG=TOP%CBLD_ATYPE
  YAREA='BLD'
ELSE
  YAVG=TOP%CBLD_ATYPE
  YAREA='BLV'
END IF
!
IL = SIZE(TOP%XCOVER,1)
!-------------------------------------------------------------------------------
!
!----------------------------------------------------------------------------------!
IF (PRESENT(T)) THEN
!----------------------------------------------------------------------------------!
   !
   !       ROAD DIRECTION 
   !       --------------
   IF (DTT%LDATA_ROAD_DIR) THEN
      T%XROAD_DIR=DTT%XPAR_ROAD_DIR
   ELSE
      T%XROAD_DIR=PDEF_ROAD_DIR
   ENDIF
!
!     GREENROOF FRACTION
!     ------------------
  IF (DTT%LDATA_GREENROOF) THEN
    T%XGREENROOF=DTT%XPAR_GREENROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PGREENROOF=T%XGREENROOF)
  ELSE
    CALL AV_PGD(DTCO, T%XGREENROOF,TOP%XCOVER ,XDATA_FRAC_GR(:),'BLD','ARI',TOP%LCOVER)
  ENDIF
  !
  !-----------------------------------------------------------------------------
!
!     Coverage fractions
!     ------------------
!
!
!       BLD fraction
!       -------------
  IF (DTT%LDATA_BLD) THEN
    T%XBLD=DTT%XPAR_BLD  
  ELSE
    CALL AV_PGD(DTCO, T%XBLD, TOP%XCOVER, DTCO%XDATA_BLD(:),'TWN','ARI',TOP%LCOVER)
  ENDIF
!
!       ROAD fraction
!       -------------
  IF (DTT%LDATA_BLD) THEN
    T%XROAD=DTT%XPAR_ROAD 
  ELSE
    CALL AV_PGD(DTCO, T%XROAD, TOP%XCOVER, 1.-DTCO%XDATA_BLD(:)-DTCO%XDATA_GARDEN(:),'TWN','ARI',TOP%LCOVER)
  ENDIF
!
  IF (TOP%LGARDEN) THEN
!
!     HIGH VEG FRACTION
!     -----------------
!
    IF (DTT%LDATA_BLD) THEN
      T%XFRAC_HVEG=DTT%XPAR_FRAC_HVEG
    ELSE
      CALL AV_PGD(DTCO, &
                   T%XFRAC_HVEG,TOP%XCOVER ,XDATA_FRAC_HVEG(:),'STR','ARI',TOP%LCOVER)
    ENDIF  
!
!     LOW VEG FRACTION
!     ----------------
    IF (DTT%LDATA_BLD) THEN
      T%XFRAC_LVEG=DTT%XPAR_FRAC_LVEG
    ELSE
      CALL AV_PGD(DTCO, &
                   T%XFRAC_LVEG,TOP%XCOVER ,XDATA_FRAC_LVEG(:),'STR','ARI',TOP%LCOVER)
    ENDIF  
!
!     NO VEG FRACTION
!     ---------------
    IF (DTT%LDATA_BLD) THEN
      T%XFRAC_NVEG=DTT%XPAR_FRAC_NVEG
    ELSE
      CALL AV_PGD(DTCO, &
                   T%XFRAC_NVEG,TOP%XCOVER ,XDATA_FRAC_NVEG(:),'STR','ARI',TOP%LCOVER)
    ENDIF  
!
  ELSE
    T%XFRAC_HVEG = 0.
    T%XFRAC_LVEG = 0.
    T%XFRAC_NVEG = 0.
  END IF
!
!----------------------------------------------------------------------------------!
!
!      Z0_TOWN
!      ----------
  IF (DTT%LDATA_Z0_TOWN) THEN
    T%XZ0_TOWN=DTT%XPAR_Z0_TOWN  
  ELSE
    CALL AV_PGD(DTCO, T%XZ0_TOWN ,TOP%XCOVER ,XDATA_Z0_TOWN (:),'TWN','CDN',TOP%LCOVER)  
  ENDIF  
!
!      BLD Height
!      ----------
  IF (DTT%LDATA_BLD_HEIGHT) THEN
    T%XBLD_HEIGHT=DTT%XPAR_BLD_HEIGHT
  ELSE
    CALL AV_PGD(DTCO, T%XBLD_HEIGHT ,TOP%XCOVER ,XDATA_BLD_HEIGHT (:),'BLD','ARI',TOP%LCOVER)  
  ENDIF  
!
!      WALL O HOR
!      ----------
  IF (DTT%LDATA_WALL_O_HOR) THEN
    T%XWALL_O_HOR=DTT%XPAR_WALL_O_HOR 
  ELSE
    CALL AV_PGD(DTCO, T%XWALL_O_HOR ,TOP%XCOVER ,DTCO%XDATA_WALL_O_HOR (:),'BLD','ARI',TOP%LCOVER)  
  ENDIF  
!
!      ALB_ROOF
!      ----------
  IF (DTT%LDATA_ALB_ROOF) THEN
    T%XALB_ROOF=DTT%XPAR_ALB_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PALB_ROOF=T%XALB_ROOF)
  ELSE
    CALL AV_PGD(DTCO, T%XALB_ROOF ,TOP%XCOVER ,XDATA_ALB_ROOF (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      EMIS_ROOF
!      ----------
  IF (DTT%LDATA_EMIS_ROOF) THEN
    T%XEMIS_ROOF=DTT%XPAR_EMIS_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PEMIS_ROOF=T%XEMIS_ROOF)
  ELSE
    CALL AV_PGD(DTCO, T%XEMIS_ROOF ,TOP%XCOVER ,XDATA_EMIS_ROOF (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      HC_ROOF, TC_ROOF, D_ROOF
!      ------------------------
!
  IF (DTT%LDATA_HC_ROOF) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_ROOF_LAYER)
    ZHC=DTT%XPAR_HC_ROOF
    ZTC=DTT%XPAR_TC_ROOF
    ZD =DTT%XPAR_D_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_ROOF_LAYER)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PHC_ROOF=ZHC)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PTC_ROOF=ZTC)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PD_ROOF =ZD )
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,NISOROOFPOS=ZISOROOFPOS)
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_ROOF_LAYER)
    DO JLAYER=1,NDATA_ROOF_LAYER
      CALL AV_PGD(DTCO, ZHC(:,JLAYER), TOP%XCOVER, XDATA_HC_ROOF (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZTC(:,JLAYER), TOP%XCOVER ,XDATA_TC_ROOF (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZD (:,JLAYER), TOP%XCOVER ,XDATA_D_ROOF  (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
    ENDDO
  ENDIF 
  CALL THERMAL_LAYERS_CONF('ROOF ',ZD,T%XD_ROOF,ZHC,T%XHC_ROOF,ZTC,T%XTC_ROOF) 
  CALL DEALLOCATE_THERMAL_WORK
!
!      ALB_ROAD
!      ----------
  IF (DTT%LDATA_ALB_ROAD) THEN
    T%XALB_ROAD=DTT%XPAR_ALB_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,  DTT%NPAR_BLDCODE,PALB_ROAD=T%XALB_ROAD)
  ELSE
    CALL AV_PGD(DTCO, &
                 T%XALB_ROAD ,TOP%XCOVER ,XDATA_ALB_ROAD (:),'STR','ARI',TOP%LCOVER)  
  ENDIF  
!
!      EMIS_ROAD
!      ----------
  IF (DTT%LDATA_EMIS_ROAD) THEN
    T%XEMIS_ROAD=DTT%XPAR_EMIS_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PEMIS_ROAD=T%XEMIS_ROAD)
  ELSE
    CALL AV_PGD(DTCO, &
                 T%XEMIS_ROAD ,TOP%XCOVER ,XDATA_EMIS_ROAD (:),'STR','ARI',TOP%LCOVER)  
  ENDIF  
!
!      HC_ROAD, TC_ROAD, D_ROAD
!      ------------------------
!
 IF (PRESENT(KTEB_ROAD)) THEN
  IF (DTT%LDATA_HC_ROAD) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_ROAD_LAYER)
    ZHC=DTT%XPAR_HC_ROAD
    ZTC=DTT%XPAR_TC_ROAD
    ZD =DTT%XPAR_D_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_ROAD_LAYER)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PHC_ROAD=ZHC)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PTC_ROAD=ZTC)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PD_ROAD =ZD )
    !
    !
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_ROAD_LAYER)
    DO JLAYER=1,NDATA_ROAD_LAYER
      CALL AV_PGD(DTCO, ZHC(:,JLAYER), TOP%XCOVER, XDATA_HC_ROAD (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZTC(:,JLAYER), TOP%XCOVER ,XDATA_TC_ROAD (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZD (:,JLAYER), TOP%XCOVER ,XDATA_D_ROAD  (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
    ENDDO
  ENDIF 
  CALL THERMAL_LAYERS_CONF_ROAD('ROAD ', T%NTEB_SOIL, T%XTEB_SOILGRID, ZHC, ZTC, ZD, &
                                T%XCONDDRY_ROAD, T%XHCAPSOIL_ROAD,                   &
                                T%XHC_ROAD,T%XTC_ROAD, T%XD_ROAD, KTEB_ROAD)
  !
  CALL DEALLOCATE_THERMAL_WORK
 END IF
!
!      ALB_WALL
!      ----------
  IF (DTT%LDATA_ALB_WALL) THEN
    T%XALB_WALL=DTT%XPAR_ALB_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PALB_WALL=T%XALB_WALL)
  ELSE
    CALL AV_PGD(DTCO, T%XALB_WALL ,TOP%XCOVER ,XDATA_ALB_WALL (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      EMIS_WALL
!      ----------
  IF (DTT%LDATA_EMIS_WALL) THEN
    T%XEMIS_WALL=DTT%XPAR_EMIS_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PEMIS_WALL=T%XEMIS_WALL)
  ELSE
    CALL AV_PGD(DTCO, T%XEMIS_WALL ,TOP%XCOVER ,XDATA_EMIS_WALL (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      HC_WALL, TC_WALL, D_WALL
!      ------------------------
!
  IF (DTT%LDATA_HC_WALL) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_WALL_LAYER)
    ZHC=DTT%XPAR_HC_WALL
    ZTC=DTT%XPAR_TC_WALL
    ZD =DTT%XPAR_D_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_WALL_LAYER)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PHC_WALL=ZHC)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PTC_WALL=ZTC)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PD_WALL =ZD )
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,NISOWALLPOS=ZISOWALLPOS)
    !
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_WALL_LAYER)
    DO JLAYER=1,NDATA_WALL_LAYER
      CALL AV_PGD(DTCO, ZHC(:,JLAYER), TOP%XCOVER, XDATA_HC_WALL (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZTC(:,JLAYER), TOP%XCOVER ,XDATA_TC_WALL (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZD (:,JLAYER), TOP%XCOVER ,XDATA_D_WALL  (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
    ENDDO
  ENDIF 
  CALL THERMAL_LAYERS_CONF('WALL ',ZD,T%XD_WALL,ZHC,T%XHC_WALL,ZTC,T%XTC_WALL) 
  CALL DEALLOCATE_THERMAL_WORK
!
!     H_TRAFFIC
!     ---------
  IF (DTT%LDATA_H_TRAFFIC) THEN
    T%XH_TRAFFIC=DTT%XPAR_H_TRAFFIC
  ELSE
    CALL AV_PGD(DTCO, T%XH_TRAFFIC ,TOP%XCOVER ,XDATA_H_TRAFFIC(:),'TWN','ARI',TOP%LCOVER)
  ENDIF 
!
!     LE_TRAFFIC
!     ----------
  IF (DTT%LDATA_LE_TRAFFIC) THEN
    T%XLE_TRAFFIC=DTT%XPAR_LE_TRAFFIC
  ELSE
    CALL AV_PGD(DTCO, T%XLE_TRAFFIC ,TOP%XCOVER ,XDATA_LE_TRAFFIC(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     H_INDUSTRY
!     ----------
  IF (DTT%LDATA_H_INDUSTRY) THEN
    T%XH_INDUSTRY=DTT%XPAR_H_INDUSTRY
  ELSE
    CALL AV_PGD(DTCO, T%XH_INDUSTRY ,TOP%XCOVER ,XDATA_H_INDUSTRY(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     LE_INDUSTRY
!     -----------
  IF (DTT%LDATA_LE_INDUSTRY) THEN
    T%XLE_INDUSTRY=DTT%XPAR_LE_INDUSTRY
  ELSE
    CALL AV_PGD(DTCO, T%XLE_INDUSTRY ,TOP%XCOVER ,XDATA_LE_INDUSTRY(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!
!      ROUGH_ROOF
!      ----------
  IF (DTT%LDATA_ROUGH_ROOF) THEN
    T%XROUGH_ROOF=DTT%XPAR_ROUGH_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM,BDD, DTT, DTT%NPAR_BLDCODE,PROUGH_ROOF=T%XROUGH_ROOF)
  ELSE
    CALL AV_PGD(DTCO, T%XROUGH_ROOF ,TOP%XCOVER ,XDATA_ROUGH_ROOF (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      ROUGH_WALL
!      ----------
  IF (DTT%LDATA_ROUGH_WALL) THEN
    T%XROUGH_WALL=DTT%XPAR_ROUGH_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PROUGH_WALL=T%XROUGH_WALL)
  ELSE
    CALL AV_PGD(DTCO, T%XROUGH_WALL ,TOP%XCOVER ,XDATA_ROUGH_WALL (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!       SFCO2_RD
!       --------
  IF (DTT%LDATA_SFCO2_RD) THEN
    T%XSFCO2_RD=DTT%XPAR_SFCO2_RD  
  ELSE
    CALL AV_PGD(DTCO, T%XSFCO2_RD, TOP%XCOVER, XDATA_SFCO2_RD,'TWN','ARI',TOP%LCOVER)
  ENDIF
!
!       NB_POP
!       ------
  IF (DTT%LDATA_NB_POP) THEN
    T%XNB_POP=DTT%XPAR_NB_POP  
  ELSE
    CALL AV_PGD(DTCO, T%XNB_POP, TOP%XCOVER, XDATA_NB_POP,'TWN','ARI',TOP%LCOVER)
  ENDIF
END IF
!----------------------------------------------------------------------------------!
IF (PRESENT(TPN)) THEN
!----------------------------------------------------------------------------------!
!
!     SOLAR PANELS
!     ------------
  IF (DTT%LDATA_EMIS_PANEL) THEN
    TPN%XEMIS_PANEL=DTT%XPAR_EMIS_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PEMIS_PANEL=TPN%XEMIS_PANEL)
  ELSE
    CALL AV_PGD(DTCO, TPN%XEMIS_PANEL ,TOP%XCOVER ,XDATA_EMIS_PANEL(:),'BLD','ARI',TOP%LCOVER)
  ENDIF
!
  IF (DTT%LDATA_ALB_PANEL) THEN
    TPN%XALB_PANEL=DTT%XPAR_ALB_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PALB_PANEL=TPN%XALB_PANEL)
  ELSE
    CALL AV_PGD(DTCO, TPN%XALB_PANEL, TOP%XCOVER ,XDATA_ALB_PANEL(:),'BLD','ARI',TOP%LCOVER)
  ENDIF  
!
  IF (DTT%LDATA_EFF_PANEL) THEN
    TPN%XEFF_PANEL=DTT%XPAR_EFF_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PEFF_PANEL=TPN%XEFF_PANEL)
  ELSE
    CALL AV_PGD(DTCO, TPN%XEFF_PANEL ,TOP%XCOVER ,XDATA_EFF_PANEL(:),'BLD','ARI',TOP%LCOVER)
  ENDIF  
!
  IF (DTT%LDATA_FRAC_PANEL) THEN
    TPN%XFRAC_PANEL=DTT%XPAR_FRAC_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PFRAC_PANEL=TPN%XFRAC_PANEL)
  ELSE
    CALL AV_PGD(DTCO, TPN%XFRAC_PANEL ,TOP%XCOVER ,XDATA_FRAC_PANEL(:),'BLD','ARI',TOP%LCOVER)
  ENDIF  
!
END IF
!----------------------------------------------------------------------------------!
IF (PRESENT(B)) THEN
!----------------------------------------------------------------------------------!
!
!      HC_FLOOR, TC_FLOOR, D_FLOOR
!      ------------------------
!

  IF (DTB%LDATA_HC_FLOOR) THEN
    CALL ALLOCATE_THERMAL_WORK(DTB%NPAR_FLOOR_LAYER)
    ZHC=DTB%XPAR_HC_FLOOR
    ZTC=DTB%XPAR_TC_FLOOR
    ZD =DTB%XPAR_D_FLOOR
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_FLOOR_LAYER)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PHC_FLOOR=ZHC)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PTC_FLOOR=ZTC)
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PD_FLOOR =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_FLOOR_LAYER)
    DO JLAYER=1,NDATA_FLOOR_LAYER
      CALL AV_PGD(DTCO, ZHC(:,JLAYER), TOP%XCOVER, XDATA_HC_FLOOR (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZTC(:,JLAYER), TOP%XCOVER ,XDATA_TC_FLOOR (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZD (:,JLAYER), TOP%XCOVER ,XDATA_D_FLOOR  (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
    ENDDO
  ENDIF
  CALL THERMAL_LAYERS_CONF('FLOOR',ZD,B%XD_FLOOR,ZHC,B%XHC_FLOOR,ZTC,B%XTC_FLOOR)
  CALL DEALLOCATE_THERMAL_WORK
!
!     SHGC
!     -----------
  IF (DTB%LDATA_SHGC) THEN
    B%XSHGC=DTB%XPAR_SHGC
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PSHGC=B%XSHGC)
  ELSE
    CALL AV_PGD(DTCO, B%XSHGC ,TOP%XCOVER ,XDATA_SHGC(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     U_WIN
!     -----------
  IF (DTB%LDATA_U_WIN) THEN
    B%XU_WIN=DTB%XPAR_U_WIN
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
     CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PU_WIN=B%XU_WIN)
  ELSE
    CALL AV_PGD(DTCO, B%XU_WIN ,TOP%XCOVER ,XDATA_U_WIN(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     GR
!     -----------
  IF (DTB%LDATA_GR) THEN
    B%XGR=DTB%XPAR_GR
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PGR=B%XGR)
  ELSE
    CALL AV_PGD(DTCO, B%XGR ,TOP%XCOVER ,XDATA_GR(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     SHGC_SH
!     -----------
  IF (DTB%LDATA_SHGC_SH) THEN
    B%XSHGC_SH=DTB%XPAR_SHGC_SH
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PSHGC_SH=B%XSHGC_SH)
  ELSE
    CALL AV_PGD(DTCO, B%XSHGC_SH ,TOP%XCOVER ,XDATA_SHGC_SH(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     FLOOR_HEIGHT
!     -----------
  IF (DTB%LDATA_FLOOR_HEIGHT) THEN
    B%XFLOOR_HEIGHT=DTB%XPAR_FLOOR_HEIGHT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PFLOOR_HEIGHT=B%XFLOOR_HEIGHT)
  ELSE
    CALL AV_PGD(DTCO, B%XFLOOR_HEIGHT ,TOP%XCOVER ,XDATA_FLOOR_HEIGHT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     ISMASS
!     -----------
  IF (DTB%LDATA_ISMASS) THEN
    B%XISMASS=DTB%XPAR_ISMASS
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PISMASS=B%XISMASS)
  ELSE
    CALL AV_PGD(DTCO, B%XISMASS ,TOP%XCOVER ,XDATA_ISMASS(:),'TWN','MAJ',TOP%LCOVER)
  ENDIF  
!
!      HC_MASS, TC_MASS, D_MASS
!      ------------------------
!
   IF (DTB%LDATA_HC_MASS) THEN
      !
      CALL ALLOCATE_THERMAL_WORK(DTB%NPAR_MASS_LAYER)
      ZHC=DTB%XPAR_HC_MASS
      ZTC=DTB%XPAR_TC_MASS
      ZD =DTB%XPAR_D_MASS 
      !
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      !
      CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_MASS_LAYER)
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PHC_MASS=ZHC)
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTC_MASS=ZTC)
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PD_MASS =ZD )
      !
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PISMASS=B%XISMASS)
      !
   ELSE
      !
      CALL ALLOCATE_THERMAL_WORK(NDATA_MASS_LAYER)
      !
      DO JLAYER=1,NDATA_MASS_LAYER
         CALL AV_PGD (DTCO, ZHC(:,JLAYER), TOP%XCOVER, XDATA_HC_MASS (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
         CALL AV_PGD (DTCO, ZTC(:,JLAYER), TOP%XCOVER ,XDATA_TC_MASS (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
         CALL AV_PGD (DTCO, ZD (:,JLAYER), TOP%XCOVER ,XDATA_D_MASS  (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      ENDDO
      !
  ENDIF
  !
  CALL THERMAL_LAYERS_CONF('MASS ',ZD,B%XD_MASS ,ZHC,B%XHC_MASS ,ZTC,B%XTC_MASS)
  CALL DEALLOCATE_THERMAL_WORK
  !
!
!     N50
!     -----------
  IF (DTB%LDATA_N50) THEN
    B%XN50=DTB%XPAR_N50
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PN50=B%XN50)
  ELSE
    CALL AV_PGD(DTCO, B%XN50 ,TOP%XCOVER ,XDATA_N50(:),'TWN','MAJ',TOP%LCOVER)
  ENDIF  
!
!     F_WATER_COND
!     -----------
  IF (DTB%LDATA_F_WATER_COND) THEN
    B%XF_WATER_COND=DTB%XPAR_F_WATER_COND
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PF_WATER_COND=B%XF_WATER_COND)
  ELSE
    CALL AV_PGD(DTCO, B%XF_WATER_COND ,TOP%XCOVER ,XDATA_F_WATER_COND(:),'TWN','MAJ',TOP%LCOVER)
  ENDIF  
!
!     HR_TARGET
!     -----------
  IF (DTB%LDATA_HR_TARGET) THEN
    B%XHR_TARGET=DTB%XPAR_HR_TARGET
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PHR_TARGET=B%XHR_TARGET)
  ELSE
    CALL AV_PGD(DTCO, B%XHR_TARGET ,TOP%XCOVER ,XDATA_HR_TARGET(:),'TWN','MAJ',TOP%LCOVER)
  ENDIF  
!
!     CAP_SYS_HEAT
!     -----------
  IF (DTB%LDATA_CAP_SYS_HEAT) THEN
    B%XCAP_SYS_HEAT=DTB%XPAR_CAP_SYS_HEAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PCAP_SYS_HEAT=B%XCAP_SYS_HEAT)
  ELSE
    CALL AV_PGD(DTCO, B%XCAP_SYS_HEAT ,TOP%XCOVER ,XDATA_CAP_SYS_HEAT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     CAP_SYS_RAT
!     -----------
  IF (DTB%LDATA_CAP_SYS_RAT) THEN
    B%XCAP_SYS_RAT=DTB%XPAR_CAP_SYS_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PCAP_SYS_RAT=B%XCAP_SYS_RAT)
  ELSE
    CALL AV_PGD(DTCO, B%XCAP_SYS_RAT ,TOP%XCOVER ,XDATA_CAP_SYS_RAT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     T_ADP
!     -----------
  IF (DTB%LDATA_T_ADP) THEN
    B%XT_ADP=DTB%XPAR_T_ADP
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PT_ADP=B%XT_ADP)
  ELSE
    CALL AV_PGD(DTCO, B%XT_ADP ,TOP%XCOVER ,XDATA_T_ADP(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     M_SYS_RAT
!     -----------
  IF (DTB%LDATA_M_SYS_RAT) THEN
    B%XM_SYS_RAT=DTB%XPAR_M_SYS_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PM_SYS_RAT=B%XM_SYS_RAT)
  ELSE
    CALL AV_PGD(DTCO, B%XM_SYS_RAT ,TOP%XCOVER ,XDATA_M_SYS_RAT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     COP_RAT
!     -----------
  IF (DTB%LDATA_COP_RAT) THEN
    B%XCOP_RAT=DTB%XPAR_COP_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PCOP_RAT=B%XCOP_RAT)
  ELSE
    CALL AV_PGD(DTCO, B%XCOP_RAT ,TOP%XCOVER ,XDATA_COP_RAT(:),'TWN','MAJ',TOP%LCOVER)
  ENDIF  
!
END IF
!
!---------------------------------------------------------------------------
IF (PRESENT(B)) THEN
!---------------------------------------------------------------------------
!
!     T_SIZE_MAX
!     -----------
  IF (DTB%LDATA_T_SIZE_MAX) THEN
    B%XT_SIZE_MAX=DTB%XPAR_T_SIZE_MAX
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PT_SIZE_MAX=B%XT_SIZE_MAX)
  ELSE
    CALL AV_PGD(DTCO, B%XT_SIZE_MAX ,TOP%XCOVER ,XDATA_T_SIZE_MAX(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     T_SIZE_MIN
!     -----------
  IF (DTB%LDATA_T_SIZE_MIN) THEN
    B%XT_SIZE_MIN=DTB%XPAR_T_SIZE_MIN
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PT_SIZE_MIN=B%XT_SIZE_MIN)
  ELSE
    CALL AV_PGD(DTCO, B%XT_SIZE_MIN ,TOP%XCOVER ,XDATA_T_SIZE_MIN(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     SHADEARCHI
!     -----
  IF (DTB%LDATA_SHADEARCHI) THEN
    B%XSHADEARCHI(:) = DTB%XPAR_SHADEARCHI(:)
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PSHADEARCHI=B%XSHADEARCHI)
  ELSE
    CALL AV_PGD(DTCO, B%XSHADEARCHI,TOP%XCOVER ,XDATA_SHADEARCHI(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     ISMECH
!     -----
   IF (DTB%LDATA_ISMECH) THEN
      B%XISMECH(:) = DTB%XPAR_ISMECH(:)
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PISMECH=B%XISMECH)
   ELSE
      CALL AV_PGD (DTCO,B%XISMECH,TOP%XCOVER ,XDATA_ISMECH(:),'TWN','MAJ',TOP%LCOVER)
   ENDIF
!
!     MECHRATE
!     -----
   IF (DTB%LDATA_MECHRATE) THEN
      B%XMECHRATE(:) = DTB%XPAR_MECHRATE(:)
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PMECHRATE=B%XMECHRATE)
   ELSE
      CALL AV_PGD (DTCO,B%XMECHRATE,TOP%XCOVER ,XDATA_MECHRATE(:),'TWN','MAJ',TOP%LCOVER)
   ENDIF
!
! B: Occupant behavioural characteristics
!
! Fraction of compartments in bem
!
   !
   IF (DTB%LDATA_FRACOMP) THEN
      B%XFRACOMP=DTB%XPAR_FRACOMP
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PFRACOMP=B%XFRACOMP)
   ELSE
      DO JCOMP=1,SIZE(B%XFRACOMP,2)
         CALL AV_PGD (DTCO,B%XFRACOMP(:,JCOMP),TOP%XCOVER,XDATA_FRACOMP(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
!
! Residential fraction (required for solar panels)
!
   !
   IF (DTB%LDATA_RESIDENTIAL) THEN
      B%XRESIDENTIAL=DTB%XPAR_RESIDENTIAL
!   ELSEIF (DTT%LDATA_BLDTYPE) THEN
!      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE, PRESIDENTIAL=B%XRESIDENTIAL)
   ELSEIF (DTT%LDATA_FRACIHS.AND.DTT%LDATA_FRACCHS) THEN
      B%XRESIDENTIAL=DTT%XPAR_FRACIHS+DTT%XPAR_FRACCHS
   ELSE
      CALL AV_PGD (DTCO,B%XRESIDENTIAL(:),TOP%XCOVER,XDATA_RESIDENTIAL(:),'BLD','MAJ',TOP%LCOVER)
   ENDIF
!
! Heating design temperature when occupied during the day
!
   IF (DTB%LDATA_THEAT_OCCD) THEN
      B%XTHEAT_OCCD=DTB%XPAR_THEAT_OCCD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTHEAT_OCCD=B%XTHEAT_OCCD)
   ELSE
      DO JCOMP=1,SIZE(B%XTHEAT_OCCD,2)
         CALL AV_PGD (DTCO,B%XTHEAT_OCCD(:,JCOMP),TOP%XCOVER,XDATA_THEAT_OCCD(:),'BLD','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
!
! Heating design temperature when occupied during night
!
   IF (DTB%LDATA_THEAT_OCCN) THEN
      B%XTHEAT_OCCN=DTB%XPAR_THEAT_OCCN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTHEAT_OCCN=B%XTHEAT_OCCN)
   ELSE
      DO JCOMP=1,SIZE(B%XTHEAT_OCCN,2)
         CALL AV_PGD (DTCO,B%XTHEAT_OCCN(:,JCOMP),TOP%XCOVER,XDATA_THEAT_OCCN(:),'BLD','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
!
! Heating design temperature when vacant during the day
!
   IF (DTB%LDATA_THEAT_VCDD) THEN
      B%XTHEAT_VCDD=DTB%XPAR_THEAT_VCDD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTHEAT_VCDD=B%XTHEAT_VCDD)
   ELSE
      DO JCOMP=1,SIZE(B%XTHEAT_VCDD,2)
         CALL AV_PGD (DTCO,B%XTHEAT_VCDD(:,JCOMP),TOP%XCOVER,XDATA_THEAT_VCDD(:),'BLD','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
!
! Heating design temperature when vacant during the night
!
   IF (DTB%LDATA_THEAT_VCDN) THEN
      B%XTHEAT_VCDN=DTB%XPAR_THEAT_VCDN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTHEAT_VCDN=B%XTHEAT_VCDN)
   ELSE
      DO JCOMP=1,SIZE(B%XTHEAT_VCDN,2)      
          CALL AV_PGD (DTCO,B%XTHEAT_VCDN(:,JCOMP),TOP%XCOVER,XDATA_THEAT_VCDN(:),'BLD','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
!
! Heating design temperature when vacant for long-term
!
   IF (DTB%LDATA_THEAT_VCLD) THEN
      B%XTHEAT_VCLD=DTB%XPAR_THEAT_VCLD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTHEAT_VCLD=B%XTHEAT_VCLD)
   ELSE
      DO JCOMP=1,SIZE(B%XTHEAT_VCLD,2)
         CALL AV_PGD (DTCO,B%XTHEAT_VCLD(:,JCOMP),TOP%XCOVER,XDATA_THEAT_VCLD(:),'BLD','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
!
! Cooling design temperature when occupied during the day
!
   IF (DTB%LDATA_TCOOL_OCCD) THEN
      B%XTCOOL_OCCD=DTB%XPAR_TCOOL_OCCD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTCOOL_OCCD=B%XTCOOL_OCCD)
   ELSE
      DO JCOMP=1,SIZE(B%XTCOOL_OCCD,2)
          CALL AV_PGD (DTCO,B%XTCOOL_OCCD(:,JCOMP),TOP%XCOVER,XDATA_TCOOL_OCCD(:),'BLD','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
!
! Cooling design temperature when occupied during night
!
   IF (DTB%LDATA_TCOOL_OCCN) THEN
      B%XTCOOL_OCCN=DTB%XPAR_TCOOL_OCCN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTCOOL_OCCN=B%XTCOOL_OCCN)
   ELSE
      DO JCOMP=1,SIZE(B%XTCOOL_OCCN,2)      
         CALL AV_PGD (DTCO,B%XTCOOL_OCCN(:,JCOMP),TOP%XCOVER,XDATA_TCOOL_OCCN(:),'BLD','MAJ',TOP%LCOVER)
      ENDDO      
   ENDIF
   !
   ! Cooling design temperature when vacant during the day
   !
   IF (DTB%LDATA_TCOOL_VCDD) THEN
      B%XTCOOL_VCDD=DTB%XPAR_TCOOL_VCDD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTCOOL_VCDD=B%XTCOOL_VCDD)
   ELSE
      DO JCOMP=1,SIZE(B%XTCOOL_VCDD,2)
         CALL AV_PGD (DTCO,B%XTCOOL_VCDD(:,JCOMP),TOP%XCOVER,XDATA_TCOOL_VCDD(:),'BLD','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
   !
   ! Cooling design temperature when vacant during the night
   !
   IF (DTB%LDATA_TCOOL_VCDN) THEN
      B%XTCOOL_VCDN=DTB%XPAR_TCOOL_VCDN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTCOOL_VCDN=B%XTCOOL_VCDN)
   ELSE
      DO JCOMP=1,SIZE(B%XTCOOL_VCDN,2)
         CALL AV_PGD (DTCO,B%XTCOOL_VCDN(:,JCOMP),TOP%XCOVER,XDATA_TCOOL_VCDN(:),'BLD','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
   !
   ! Cooling design temperature when vacant for long-term
   !
   IF (DTB%LDATA_TCOOL_VCLD) THEN
      B%XTCOOL_VCLD=DTB%XPAR_TCOOL_VCLD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTCOOL_VCLD=B%XTCOOL_VCLD)
   ELSE
      DO JCOMP=1,SIZE(B%XTCOOL_VCLD,2)      
         CALL AV_PGD (DTCO,B%XTCOOL_VCLD(:,JCOMP),TOP%XCOVER,XDATA_TCOOL_VCLD(:),'BLD','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
   !
   !     QIN
   !     -----------
   IF (DTB%LDATA_QIN) THEN
      B%XQIN=DTB%XPAR_QIN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PQIN=B%XQIN)
   ELSE
      DO JCOMP=1,SIZE(B%XQIN,2)
         CALL AV_PGD (DTCO,B%XQIN(:,JCOMP) ,TOP%XCOVER ,XDATA_QIN(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
   !
   !     QIN_FRAD
   !     -----------
   IF (DTB%LDATA_QIN_FRAD) THEN
      B%XQIN_FRAD=DTB%XPAR_QIN_FRAD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PQIN_FRAD=B%XQIN_FRAD)
   ELSE
      CALL AV_PGD (DTCO,B%XQIN_FRAD ,TOP%XCOVER ,XDATA_QIN_FRAD(:),'TWN','MAJ',TOP%LCOVER)
   ENDIF
   !
   !     QIN_FLAT
   !     -----------
   IF (DTB%LDATA_QIN_FLAT) THEN
      B%XQIN_FLAT=DTB%XPAR_QIN_FLAT
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PQIN_FLAT=B%XQIN_FLAT)
   ELSE
      CALL AV_PGD (DTCO,B%XQIN_FLAT ,TOP%XCOVER ,XDATA_QIN_FLAT(:),'TWN','MAJ',TOP%LCOVER)
   ENDIF
   !
   ! Modulation of qin for short term vacancy
   !
   IF (DTB%LDATA_MODQIN_VCD) THEN
      B%XMODQIN_VCD=DTB%XPAR_MODQIN_VCD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PMODQIN_VCD=B%XMODQIN_VCD)
   ELSE
      DO JCOMP=1,SIZE(B%XMODQIN_VCD,2)
         CALL AV_PGD(DTCO,B%XMODQIN_VCD(:,JCOMP), TOP%XCOVER, XDATA_MODQIN_VCD(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
!
! Modulation of qin for long-term vacancy
!
   IF (DTB%LDATA_MODQIN_VLD) THEN
      B%XMODQIN_VLD=DTB%XPAR_MODQIN_VLD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PMODQIN_VLD=B%XMODQIN_VLD)
   ELSE
      DO JCOMP=1,SIZE(B%XMODQIN_VLD,2)
         CALL AV_PGD(DTCO,B%XMODQIN_VLD(:,JCOMP), TOP%XCOVER, XDATA_MODQIN_VLD(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
   !
   ! Modulation of qin during the night
   !
   IF (DTB%LDATA_MODQIN_NIG) THEN
      B%XMODQIN_NIG=DTB%XPAR_MODQIN_NIG
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PMODQIN_NIG=B%XMODQIN_NIG)
   ELSE
      DO JCOMP=1,SIZE(B%XMODQIN_NIG,2)
         CALL AV_PGD(DTCO,B%XMODQIN_NIG(:,JCOMP), TOP%XCOVER, XDATA_MODQIN_NIG(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
   !
   !     NATVENT
   !     -------
   IF (DTB%LDATA_NATVENT) THEN
      B%XNATVENT(:,:) = DTB%XPAR_NATVENT(:,:)
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE,PNATVENT=B%XNATVENT)
   ELSE
      DO JCOMP=1,SIZE(B%XNATVENT,2)
         CALL AV_PGD(DTCO, B%XNATVENT(:,JCOMP),TOP%XCOVER,XDATA_NATVENT(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO     
   ENDIF
   !
   ! Design temperature for ventilation
   !
   IF (DTB%LDATA_TDESV) THEN
      B%XTDESV=DTB%XPAR_TDESV
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PTDESV=B%XTDESV)
   ELSE
      CALL AV_PGD(DTCO,B%XTDESV,TOP%XCOVER ,XDATA_TDESV(:),'TWN','MAJ',TOP%LCOVER)
   ENDIF
   !
   ! Ventilation during warm conditions
   !
   IF (DTB%LDATA_FVSUM) THEN
      B%XFVSUM=DTB%XPAR_FVSUM
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PFVSUM=B%XFVSUM)
   ELSE
      DO JCOMP=1,SIZE(B%XFVSUM,2)
         CALL AV_PGD(DTCO,B%XFVSUM(:,JCOMP), TOP%XCOVER, XDATA_FVSUM(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO  
   ENDIF
   !
   ! Ventilation during night
   !
   IF (DTB%LDATA_FVNIG) THEN
      B%XFVNIG=DTB%XPAR_FVNIG
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PFVNIG=B%XFVNIG)
   ELSE
      DO JCOMP=1,SIZE(B%XFVNIG,2)
         CALL AV_PGD(DTCO,B%XFVNIG(:,JCOMP), TOP%XCOVER, XDATA_FVNIG(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO        
   ENDIF
   !
   ! Ventilation when vacant
   !
   IF (DTB%LDATA_FVVAC) THEN
      B%XFVVAC=DTB%XPAR_FVVAC
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PFVVAC=B%XFVVAC)
   ELSE
      DO JCOMP=1,SIZE(B%XFVVAC,2)
         CALL AV_PGD(DTCO,B%XFVVAC(:,JCOMP),TOP%XCOVER,XDATA_FVVAC(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
   !
   !  Fraction of windows to be opened
   !
   IF (DTB%LDATA_FOPEN) THEN
      B%XFOPEN=DTB%XPAR_FOPEN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PFOPEN=B%XFOPEN)
   ELSE
      CALL AV_PGD(DTCO,B%XFOPEN,TOP%XCOVER ,XDATA_FOPEN(:),'TWN','MAJ',TOP%LCOVER)
   ENDIF
   !
   ! Shading during warm conditions
   !
   IF (DTB%LDATA_FSSUM) THEN
      B%XFSSUM=DTB%XPAR_FSSUM
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PFSSUM=B%XFSSUM)
   ELSE
      DO JCOMP=1,SIZE(B%XFSSUM,2)
         CALL AV_PGD(DTCO,B%XFSSUM(:,JCOMP),TOP%XCOVER,XDATA_FSSUM(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
   !
   ! Shading during night
   !
   IF (DTB%LDATA_FSNIG) THEN
      B%XFSNIG=DTB%XPAR_FSNIG
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PFSNIG=B%XFSNIG)
   ELSE
      DO JCOMP=1,SIZE(B%XFSNIG,2)
         CALL AV_PGD(DTCO,B%XFSNIG(:,JCOMP),TOP%XCOVER,XDATA_FSNIG(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
   !
   ! Shading when building vacant
   !
   IF (DTB%LDATA_FSVAC) THEN
      B%XFSVAC=DTB%XPAR_FSVAC
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PFSVAC=B%XFSVAC)
   ELSE
      DO JCOMP=1,SIZE(B%XFSVAC,2)
         CALL AV_PGD(DTCO,B%XFSVAC(:,JCOMP),TOP%XCOVER,XDATA_FSVAC(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO      
   ENDIF
!
! Wall insulation threshold for shading
! 
   IF (DTB%LDATA_WIN_SW_MAX) THEN
      B%XWIN_SW_MAX=DTB%XPAR_WIN_SW_MAX
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PWIN_SW_MAX=B%XWIN_SW_MAX)
   ELSE
      CALL AV_PGD(DTCO,B%XWIN_SW_MAX,TOP%XCOVER,XDATA_WIN_SW_MAX(:),'TWN','MAJ',TOP%LCOVER)
   ENDIF
!
! Start day of week for schedules
!
   IF (DTB%LDATA_DAYWBEG_SCHED) THEN
      B%XDAYWBEG_SCHED=DTB%XPAR_DAYWBEG_SCHED
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PDAYWBEG_SCHED=B%XDAYWBEG_SCHED)
   ELSE
      DO JCOMP=1,SIZE(B%XDAYWBEG_SCHED,3)
         DO JLAYER=1,SIZE(B%XDAYWBEG_SCHED,2)
            CALL AV_PGD (DTCO,B%XDAYWBEG_SCHED(:,JLAYER,JCOMP), TOP%XCOVER, XDATA_DAYWBEG_SCHED(:,JLAYER),'TWN','MAJ',TOP%LCOVER)
         ENDDO
      ENDDO
   ENDIF
!
! Start hour for schedules
!
   IF (DTB%LDATA_HOURBEG_SCHED) THEN
      B%XHOURBEG_SCHED=DTB%XPAR_HOURBEG_SCHED
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PHOURBEG_SCHED=B%XHOURBEG_SCHED)
   ELSE
      DO JCOMP=1,SIZE(B%XHOURBEG_SCHED,3)
         DO JLAYER=1,SIZE(B%XHOURBEG_SCHED,2)
            CALL AV_PGD (DTCO,B%XHOURBEG_SCHED(:,JLAYER,JCOMP), TOP%XCOVER, XDATA_HOURBEG_SCHED(:,JLAYER),'TWN','MAJ',TOP%LCOVER)
         ENDDO
      ENDDO
   ENDIF
!
! Julian day of holiday beginning (only one holiday period is considered)
!
   IF (DTB%LDATA_BEG_HOLIDAY) THEN
      B%XBEG_HOLIDAY=DTB%XPAR_BEG_HOLIDAY
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PBEG_HOLIDAY=B%XBEG_HOLIDAY)
   ELSE
      DO JCOMP=1,SIZE(B%XBEG_HOLIDAY,3)
         DO JLAYER=1,SIZE(B%XBEG_HOLIDAY,2)
            CALL AV_PGD (DTCO,B%XBEG_HOLIDAY(:,JLAYER,JCOMP), TOP%XCOVER, XDATA_BEG_HOLIDAY(:,JLAYER),'TWN','MAJ',TOP%LCOVER)
         ENDDO
      ENDDO
   ENDIF
!
! Julian day of holiday end
!
   IF (DTB%LDATA_END_HOLIDAY) THEN
      B%XEND_HOLIDAY=DTB%XPAR_END_HOLIDAY
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PEND_HOLIDAY=B%XEND_HOLIDAY)
   ELSE
      DO JCOMP=1,SIZE(B%XEND_HOLIDAY,3)
         DO JLAYER=1,SIZE(B%XEND_HOLIDAY,2)
            CALL AV_PGD (DTCO,B%XEND_HOLIDAY(:,JLAYER,JCOMP), TOP%XCOVER, XDATA_END_HOLIDAY(:,JLAYER),'TWN','MAJ',TOP%LCOVER)
         ENDDO
      ENDDO
   ENDIF
!
! Modulation factor during holidays
!
   IF (DTB%LDATA_MOD_HOLIDAY) THEN
      B%XMOD_HOLIDAY=DTB%XPAR_MOD_HOLIDAY
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PMOD_HOLIDAY=B%XMOD_HOLIDAY)
   ELSE
      DO JCOMP=1,SIZE(B%XMOD_HOLIDAY,2)
         CALL AV_PGD (DTCO,B%XMOD_HOLIDAY(:,JCOMP), TOP%XCOVER, XDATA_MOD_HOLIDAY(:),'TWN','MAJ',TOP%LCOVER)
      ENDDO
   ENDIF
!
! Probability of building occupation (12 schedules are considered)
!
   IF (DTB%LDATA_PROBOCC) THEN
      B%XPROBOCC=DTB%XPAR_PROBOCC
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PPROBOCC=B%XPROBOCC)
   ELSE
      DO JCOMP=1,SIZE(B%XPROBOCC,3)
         DO JLAYER=1,SIZE(B%XPROBOCC,2)
            CALL AV_PGD (DTCO,B%XPROBOCC(:,JLAYER,JCOMP),TOP%XCOVER ,XDATA_PROBOCC(:,JLAYER),'TWN','MAJ',TOP%LCOVER)
         ENDDO
      ENDDO
   ENDIF
!
! Fraction of waste heat released into the canyon
!
   IF (DTB%LDATA_F_WASTE_CAN) THEN
      B%XF_WASTE_CAN=DTB%XPAR_F_WASTE_CAN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT,DTT%NPAR_BLDCODE,PF_WASTE_CAN=B%XF_WASTE_CAN)
   ELSE
      CALL AV_PGD (DTCO,B%XF_WASTE_CAN ,TOP%XCOVER ,XDATA_F_WASTE_CAN(:),'TWN','MAJ',TOP%LCOVER)
   ENDIF
!
! --------------------------------------------------------------------------! 
!
!      * New fields for CO2 fluxes from buildings
!
!       FRAC_HEAT_ELEC
!       -------------
!
  IF (DTB%LDATA_FRAC_HEAT_ELEC) THEN
    B%XFRAC_HEAT_ELEC=DTB%XPAR_FRAC_HEAT_ELEC  
  ELSE
    CALL AV_PGD(DTCO, B%XFRAC_HEAT_ELEC, TOP%XCOVER, XDATA_FRAC_HEAT_ELEC,'TWN','ARI',TOP%LCOVER)
  ENDIF
!
!       FRAC_HEAT_GAS
!       -------------
  IF (DTB%LDATA_FRAC_HEAT_GAS) THEN
    B%XFRAC_HEAT_GAS=DTB%XPAR_FRAC_HEAT_GAS  
  ELSE
    CALL AV_PGD(DTCO, B%XFRAC_HEAT_GAS, TOP%XCOVER, XDATA_FRAC_HEAT_GAS,'TWN','ARI',TOP%LCOVER)
  ENDIF
!
!       FRAC_HEAT_FUEL
!       -------------
  IF (DTB%LDATA_FRAC_HEAT_FUEL) THEN
    B%XFRAC_HEAT_FUEL=DTB%XPAR_FRAC_HEAT_FUEL  
  ELSE
    CALL AV_PGD(DTCO, B%XFRAC_HEAT_FUEL, TOP%XCOVER, XDATA_FRAC_HEAT_FUEL,'TWN','ARI',TOP%LCOVER)
  ENDIF
!
!       FRAC_HEAT_OTHER
!       -------------
  IF (DTB%LDATA_FRAC_HEAT_OTHER) THEN
    B%XFRAC_HEAT_OTHER=DTB%XPAR_FRAC_HEAT_OTHER  
  ELSE
    CALL AV_PGD(DTCO, B%XFRAC_HEAT_OTHER, TOP%XCOVER, XDATA_FRAC_HEAT_OTHER,'TWN','ARI',TOP%LCOVER)
  ENDIF

!
!     PHOTWAT
!     -----------
   IF (DTB%LDATA_HOTWAT) THEN
      B%XHOTWAT=DTB%XPAR_HOTWAT
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(HPROGRAM, BDD, DTT, DTT%NPAR_BLDCODE, PHOTWAT=B%XHOTWAT)
   ELSE
     DO JCOMP=1,SIZE(B%XHOTWAT,2)
        CALL AV_PGD (DTCO,B%XHOTWAT(:,JCOMP),TOP%XCOVER,XDATA_HOTWAT(:),'TWN','MAJ',TOP%LCOVER)
     ENDDO
  ENDIF
!
!     PF_HW_GAS
!     -----------
   IF (DTB%LDATA_F_HW_GAS) THEN
      B%XF_HW_GAS=DTB%XPAR_F_HW_GAS
   ELSE
      CALL AV_PGD (DTCO,B%XF_HW_GAS ,TOP%XCOVER ,XDATA_F_HW_GAS(:),'TWN','MAJ',TOP%LCOVER)
   ENDIF
END IF

!
! --------------------------------------------------------------------------! 
!
!      * New fields for case of urban hydrology
!
IF (PRESENT(THP)) THEN
!
!      LSEWER
!      ------
  THP%XLSEWER=DTH%XPAR_LSEWER
!
!      LSTORM
!      ------
  THP%XLSTORM=DTH%XPAR_LSTORM
!
!      DSEWER
!      ------
  THP%XDSEWER=DTH%XPAR_DSEWER
!
END IF
! 
! --------------------------------------------------------------------------! 
!
!      * Legal Time changes
!
IF (PRESENT(T)) THEN
!
!       DELTA_LEGAL_TIME
!       ----------------
  IF (DTT%LDATA_DELTA_LEGAL_TIME) THEN
    T%XDELTA_LEGAL_TIME=DTT%XPAR_DELTA_LEGAL_TIME  
  ELSE
    T%XDELTA_LEGAL_TIME=XUNDEF
  ENDIF
!
!       TIME_OF_CHANGE
!       ----------------

  T%LTIME_OF_CHANGE = DTT%LDATA_TIME_OF_CHANGE

  IF (DTT%LDATA_TIME_OF_CHANGE) THEN
    T%XTIME_OF_CHANGE=DTT%XPAR_TIME_OF_CHANGE    
  ELSE
    T%XTIME_OF_CHANGE(:)%TDATE%YEAR=NUNDEF
    T%XTIME_OF_CHANGE(:)%TDATE%MONTH=NUNDEF
    T%XTIME_OF_CHANGE(:)%TDATE%DAY=NUNDEF
    T%XTIME_OF_CHANGE(:)%TIME=XUNDEF
  ENDIF
!
END IF
!
IF (LHOOK) CALL DR_HOOK('CONVERT_PATCH_TEB',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
CONTAINS
!
SUBROUTINE ALLOCATE_THERMAL_WORK(KPAR)
INTEGER, INTENT(IN) :: KPAR
ALLOCATE(ZD(IL,KPAR))
ALLOCATE(ZHC(IL,KPAR))
ALLOCATE(ZTC(IL,KPAR))
END SUBROUTINE ALLOCATE_THERMAL_WORK
SUBROUTINE DEALLOCATE_THERMAL_WORK
DEALLOCATE(ZD)
DEALLOCATE(ZHC)
DEALLOCATE(ZTC)
END SUBROUTINE DEALLOCATE_THERMAL_WORK
!-------------------------------------------------------------------------------
!
END SUBROUTINE CONVERT_PATCH_TEB
