!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #############################################################
      SUBROUTINE ALLOC_DIAG_SURF_ATM_n (DGO, D, DC, ND, NDC, &
                       KSIZE_FULL, TPTIME, HPROGRAM,KSW)
!     #############################################################
!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      Modified    01/2006 : sea flux parameterization.
!!                  08/2009 : TIME_BUDGETC for all Tile
!       B. decharme 09/2012 : XQS_TILE not initialize
!       B. decharme 04/2013 : Add EVAP and SUBL diag
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_DIAG_n, ONLY : DIAG_t, DIAG_NP_t, DIAG_OPTIONS_t
!
USE MODD_DATA_COVER_PAR, ONLY : NTILESFC
USE MODD_SURF_PAR,       ONLY : XUNDEF
!
USE MODD_TYPE_DATE_SURF, ONLY : DATE_TIME
!
USE MODI_READ_SURF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
TYPE(DIAG_t), INTENT(INOUT) :: D
TYPE(DIAG_t), INTENT(INOUT) :: DC
TYPE(DIAG_NP_t), INTENT(INOUT) :: ND
TYPE(DIAG_NP_t), INTENT(INOUT) :: NDC
!
INTEGER, INTENT(IN) :: KSIZE_FULL
TYPE(DATE_TIME), INTENT(IN) :: TPTIME
!
 CHARACTER(LEN=6),        INTENT(IN) :: HPROGRAM  ! program calling surf. schemes
INTEGER,                 INTENT(IN) :: KSW       ! number of short-wave spectral bands
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER :: JTILE
INTEGER           :: IVERSION
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YREC           ! Name of the article to be read
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('ALLOC_DIAG_SURF_ATM_N',0,ZHOOK_HANDLE)
!
! Initialization: Outputs to atmosphere over each tile:
!
DO JTILE = 1,NTILESFC
  !
  CALL ALLOC_DIAG(ND%AL(JTILE),.FALSE.,KSIZE_FULL,KSW)
  CALL INIT_DIAG(ND%AL(JTILE),.FALSE.,XUNDEF)
  !
ENDDO
!
! Initialization: aggregated fields
!
CALL ALLOC_DIAG(D,.FALSE.,KSIZE_FULL,KSW)
CALL INIT_DIAG(D,.FALSE.,XUNDEF)
!
ALLOCATE(D%XSFCO2  (KSIZE_FULL))
!
ALLOCATE(D%XT2M_MIN_ZS    (KSIZE_FULL))
ALLOCATE(D%XQ2M_MIN_ZS    (KSIZE_FULL))
ALLOCATE(D%XHU2M_MIN_ZS   (KSIZE_FULL))
!
ALLOCATE(D%XPS            (KSIZE_FULL))
ALLOCATE(D%XRHOA          (KSIZE_FULL))
!
ALLOCATE(D%XSSO_FMU    (KSIZE_FULL))
ALLOCATE(D%XSSO_FMV    (KSIZE_FULL))
!
ALLOCATE(D%XUREF  (KSIZE_FULL))
ALLOCATE(D%XZREF  (KSIZE_FULL))
ALLOCATE(D%XTRAD  (KSIZE_FULL))
ALLOCATE(D%XEMIS  (KSIZE_FULL))
!
D%XSFCO2   = XUNDEF
!
D%XT2M_MIN_ZS     = XUNDEF
D%XQ2M_MIN_ZS     = XUNDEF
D%XHU2M_MIN_ZS    = XUNDEF
!
D%XPS                 = XUNDEF
D%XRHOA               = XUNDEF
!
D%XSSO_FMU     = XUNDEF
D%XSSO_FMV     = XUNDEF
!
D%XUREF   = XUNDEF
D%XZREF   = XUNDEF
D%XTRAD   = XUNDEF
D%XEMIS   = XUNDEF
!
IF (DGO%LSURF_BUDGETC) THEN
  !
  DO JTILE = 1,NTILESFC
    !
    CALL ALLOC_DIAG(NDC%AL(JTILE),.TRUE.,KSIZE_FULL,0)
    CALL INIT_DIAG(NDC%AL(JTILE),.TRUE.,XUNDEF)
    !
  ENDDO
  !
  CALL ALLOC_DIAG(DC,.TRUE.,KSIZE_FULL,0)
  !
  YREC='BUDC'
  CALL READ_SURF(HPROGRAM,YREC,DGO%LREAD_BUDGETC,IRESP)
  !
  IF (.NOT. DGO%LREAD_BUDGETC .OR. (DGO%LREAD_BUDGETC.AND.DGO%LRESET_BUDGETC)) THEN
    !
    DGO%TIME_BUDGETC = TPTIME
    CALL INIT_DIAG(DC,.TRUE.,0.0)  
    !
  ELSE
    !
    YREC='TBUDC'
    CALL READ_SURF(HPROGRAM,YREC,DGO%TIME_BUDGETC,IRESP)
    !
    YREC='RNC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XRN,IRESP)
    YREC='HC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XH ,IRESP)
    YREC='LEC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XLE,IRESP)
    YREC='LEIC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XLEI,IRESP)     
    YREC='GFLUXC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XGFLUX ,IRESP)
    YREC='QFC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XQF ,IRESP)
    !
    YREC='SWDC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XSWD,IRESP)
    YREC='SWUC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XSWU,IRESP)
    YREC='LWDC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XLWD,IRESP)
    YREC='LWUC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XLWU,IRESP)
    !
    YREC='FMUC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XFMU,IRESP)
    YREC='FMVC'
    CALL READ_SURF(HPROGRAM,YREC,DC%XFMV,IRESP)   
    !
    CALL READ_SURF(HPROGRAM,'VERSION',IVERSION,IRESP)
    IF (IVERSION<8)THEN
      DC%XEVAP  = 0.0
      DC%XSUBL  = 0.0              
    ELSE
      YREC='EVAPC'
      CALL READ_SURF(HPROGRAM,YREC,DC%XEVAP,IRESP)
      YREC='SUBLC'
      CALL READ_SURF(HPROGRAM,YREC,DC%XSUBL,IRESP)              
    ENDIF
    !     
  ENDIF
  !
ELSE
  !
  DO JTILE=1,NTILESFC
    CALL ALLOC_DIAG(NDC%AL(JTILE),.TRUE.,0,0)
  ENDDO
  !
  CALL ALLOC_DIAG(DC,.TRUE.,0,0)
  !
ENDIF
IF (LHOOK) CALL DR_HOOK('ALLOC_DIAG_SURF_ATM_N',1,ZHOOK_HANDLE)
!
CONTAINS
!
SUBROUTINE ALLOC_DIAG(DA,OCUM,KSIZE1,KSIZE2)
!
TYPE(DIAG_t), INTENT(INOUT) :: DA
LOGICAL, INTENT(IN) :: OCUM
INTEGER, INTENT(IN) :: KSIZE1
INTEGER, INTENT(IN) :: KSIZE2
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('ALLOC_DIAG_SURF_ATM_N:ALLOC_DIAG',0,ZHOOK_HANDLE)
!
IF (.NOT.OCUM) THEN
  !
  ALLOCATE(DA%XRI     (KSIZE1))
  ALLOCATE(DA%XCD     (KSIZE1))
  ALLOCATE(DA%XCH     (KSIZE1))
  ALLOCATE(DA%XCE     (KSIZE1))
  !
  ALLOCATE(DA%XT2M    (KSIZE1))
  ALLOCATE(DA%XTS     (KSIZE1))
  ALLOCATE(DA%XT2M_MIN(KSIZE1))
  ALLOCATE(DA%XT2M_MAX(KSIZE1))
  ALLOCATE(DA%XQ2M    (KSIZE1))
  ALLOCATE(DA%XHU2M   (KSIZE1))
  ALLOCATE(DA%XHU2M_MIN(KSIZE1))
  ALLOCATE(DA%XHU2M_MAX(KSIZE1))
  ALLOCATE(DA%XZON10M (KSIZE1))
  ALLOCATE(DA%XMER10M (KSIZE1))
    
  ALLOCATE(DA%XT2M_MEAN    (KSIZE1))
  ALLOCATE(DA%XQ2M_MEAN    (KSIZE1))
  ALLOCATE(DA%XHU2M_MEAN   (KSIZE1))
  ALLOCATE(DA%XZON10M_MEAN (KSIZE1))
  ALLOCATE(DA%XMER10M_MEAN (KSIZE1))
  ALLOCATE(DA%XWIND10M_MEAN(KSIZE1))
  !
  ALLOCATE(DA%XSWBD   (KSIZE1,KSIZE2))
  ALLOCATE(DA%XSWBU   (KSIZE1,KSIZE2))
  !
  ALLOCATE(DA%XQS     (KSIZE1))
  ALLOCATE(DA%XZ0     (KSIZE1))
  ALLOCATE(DA%XZ0H    (KSIZE1))
  !
  ALLOCATE(DA%XWIND10M(KSIZE1))
  ALLOCATE(DA%XWIND10M_MAX(KSIZE1))
  !  
ELSE
  !
  ALLOCATE(DA%XSWBD   (0,0))
  ALLOCATE(DA%XSWBU   (0,0))
  !
ENDIF
!
ALLOCATE(DA%XRN     (KSIZE1))
ALLOCATE(DA%XH      (KSIZE1))
ALLOCATE(DA%XLE     (KSIZE1))
ALLOCATE(DA%XLEI    (KSIZE1))
ALLOCATE(DA%XGFLUX  (KSIZE1))
ALLOCATE(DA%XQF     (KSIZE1))
ALLOCATE(DA%XEVAP   (KSIZE1))
ALLOCATE(DA%XSUBL   (KSIZE1))
!
ALLOCATE(DA%XSWD    (KSIZE1))
ALLOCATE(DA%XSWU    (KSIZE1))
!
ALLOCATE(DA%XLWD    (KSIZE1))
ALLOCATE(DA%XLWU    (KSIZE1))
ALLOCATE(DA%XFMU    (KSIZE1))
ALLOCATE(DA%XFMV    (KSIZE1))
!
IF (LHOOK) CALL DR_HOOK('ALLOC_DIAG_SURF_ATM_N:ALLOC_DIAG',1,ZHOOK_HANDLE)
!
END SUBROUTINE ALLOC_DIAG
!
SUBROUTINE INIT_DIAG(DA,OCUM,PVAL)
!
TYPE(DIAG_t), INTENT(INOUT) :: DA
LOGICAL, INTENT(IN) :: OCUM
REAL, INTENT(IN) :: PVAL
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('ALLOC_DIAG_SURF_ATM_N:INIT_DIAG',0,ZHOOK_HANDLE)
!
IF (.NOT.OCUM) THEN
  !
  DA%XRI      = PVAL
  DA%XCD      = PVAL
  DA%XCH      = PVAL
  DA%XCE      = PVAL
  !
  DA%XT2M     = PVAL
  DA%XTS      = PVAL
  DA%XT2M_MIN = PVAL
  DA%XT2M_MAX = PVAL
  DA%XQ2M     = PVAL
  DA%XHU2M    = PVAL
  DA%XHU2M_MIN= PVAL
  DA%XHU2M_MAX= PVAL
  DA%XZON10M  = PVAL
  DA%XMER10M  = PVAL
  
  DA%NCOUNT_STEP  = 0
  DA%XT2M_MEAN    = 0.
  DA%XQ2M_MEAN    = 0.
  DA%XHU2M_MEAN   = 0.
  DA%XZON10M_MEAN = 0.
  DA%XMER10M_MEAN = 0.
  DA%XWIND10M_MEAN= 0.
  !
  DA%XSWBD    = PVAL
  DA%XSWBU    = PVAL
  !
  DA%XQS      = PVAL
  DA%XZ0      = PVAL
  DA%XZ0H     = PVAL
  !
  DA%XWIND10M = PVAL
  DA%XWIND10M_MAX = PVAL
  !  
ENDIF

!
DA%XRN      = PVAL
DA%XH       = PVAL
DA%XLE      = PVAL
DA%XLEI     = PVAL
DA%XGFLUX   = PVAL
DA%XQF      = PVAL
DA%XEVAP    = PVAL
DA%XSUBL    = PVAL
!
DA%XSWD     = PVAL
DA%XSWU     = PVAL
DA%XLWD     = PVAL
DA%XLWU     = PVAL
DA%XFMU     = PVAL
DA%XFMV     = PVAL
!
IF (LHOOK) CALL DR_HOOK('ALLOC_DIAG_SURF_ATM_N:INIT_DIAG',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_DIAG
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE ALLOC_DIAG_SURF_ATM_n
