!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITESURF_TEB_n (HSELECT, OSNOWDIMNC, DTCO, U, TOP, BOP, T, B, ODATA_ROAD_DIR, TPN, &
                                  GDO, GDS, GDPEK, GRO, GRS, GRPEK, HPROGRAM,KPATCH,HWRITE)
!     ####################################
!
!!****  *WRITE_TEB_n* - writes TEB fields
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERGREENROOFE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003 
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
USE MODD_BEM_OPTION_n, ONLY : BEM_OPTIONS_t
USE MODD_TEB_n, ONLY : TEB_t
USE MODD_BEM_n, ONLY : BEM_t
USE MODD_TEB_PANEL_n, ONLY : TEB_PANEL_t
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
USE MODD_ISBA_n, ONLY : ISBA_PE_t, ISBA_S_t
!
USE MODN_PREP_SURF_ATM, ONLY : LWRITE_EXTERN
!
USE MODI_END_IO_SURF_n
USE MODI_INIT_IO_SURF_n
!
USE MODI_WRITE_SURF
USE MODI_WRITESURF_GR_SNOW
USE MODI_WRITESURF_TEB_GARDEN_n
USE MODI_WRITESURF_TEB_GREENROOF_n
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!RJ #ifdef SFX_MPI
!RJ INCLUDE "mpif.h"
!RJ #endif
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
 CHARACTER(LEN=*), DIMENSION(:), INTENT(IN) :: HSELECT 
LOGICAL, INTENT(IN) :: OSNOWDIMNC
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(TEB_OPTIONS_t), INTENT(IN) :: TOP
TYPE(BEM_OPTIONS_t), INTENT(IN) :: BOP
TYPE(TEB_t), INTENT(IN) :: T
TYPE(BEM_t), INTENT(IN) :: B
LOGICAL, INTENT(IN) :: ODATA_ROAD_DIR
TYPE(TEB_PANEL_t), INTENT(INOUT) :: TPN
TYPE(ISBA_OPTIONS_t), INTENT(IN) :: GDO
TYPE(ISBA_S_t), INTENT(INOUT) :: GDS
TYPE(ISBA_PE_t), INTENT(IN) :: GDPEK
TYPE(ISBA_OPTIONS_t), INTENT(IN) :: GRO
TYPE(ISBA_S_t), INTENT(INOUT) :: GRS
TYPE(ISBA_PE_t), INTENT(IN) :: GRPEK
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
INTEGER,           INTENT(IN)  :: KPATCH   ! current TEB patch
 CHARACTER(LEN=3),    INTENT(IN)  :: HWRITE    ! 'PREP' : does not write SBL XUNDEF fields
!                                             ! 'ALL' : all fields are written
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
REAL, DIMENSION(0,0,1) :: ZWSN_WR, ZRHO_WR, ZHEA_WR, ZAGE_WR, ZSG1_WR, ZSG2_WR, ZHIS_WR
REAL, DIMENSION(0,1) :: ZALB_WR
!
INTEGER, DIMENSION(SIZE(T%XT_ROOF,1)) :: IMASK
INTEGER           :: IRESP           ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
 CHARACTER(LEN=3)  :: YPATCH         ! Patch identificator
 CHARACTER(LEN=7)  :: YDIR           ! Direction identificator
 CHARACTER(LEN=100):: YSTRING        ! Comment string
!
INTEGER :: JLAYER, JI ! loop on surface layers
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_TEB_N',0,ZHOOK_HANDLE)
!
YPATCH='   '
IF (TOP%NTEB_PATCH>1) WRITE(YPATCH,FMT='(A,I1,A)') 'T',KPATCH,'_'
!
!
!*       2.     Option for road orientation:
!               ---------------------------
!
YCOMMENT='Option for Road orientation in TEB scheme'
 CALL WRITE_SURF(HSELECT,HPROGRAM,'ROAD_DIR',TOP%CROAD_DIR,IRESP,YCOMMENT)
YCOMMENT='Option for Wall representation in TEB scheme'
 CALL WRITE_SURF(HSELECT,HPROGRAM,'WALL_OPT',TOP%CWALL_OPT,IRESP,YCOMMENT)
!
!*       3.     Prognostic fields:
!               -----------------
!
!* roof temperatures
!

DO JLAYER=1,TOP%NROOF_LAYER
  WRITE(YRECFM,'(A3,A5,I1.1,A1)') YPATCH,'TROOF',JLAYER,' '
  WRITE(YCOMMENT,'(A9,I1.1,A4)') 'X_Y_TROOF',JLAYER,' (K)'
  YRECFM=ADJUSTL(YRECFM)
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XT_ROOF(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
END DO

!
!* roof water content
!

YRECFM=YPATCH//'WS_ROOF'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='WS_ROOF (kg/m2)'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XWS_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
!* road temperatures
!

DO JLAYER=1,TOP%NROAD_LAYER
  WRITE(YRECFM,'(A3,A5,I1.1,A1)') YPATCH,'TROAD',JLAYER,' '
  YRECFM=ADJUSTL(YRECFM)
  IF (TOP%CROAD_DIR=='UNIF' .OR. ODATA_ROAD_DIR) THEN
    YSTRING = 'X_Y_TROAD'
  ELSEIF (SIZE(T%XROAD_DIR)>0) THEN
    !* road direction is uniform spatially, one can then indicate it in the comment
    CALL ROAD_DIR(T%XROAD_DIR(1),YDIR)
    YSTRING=TRIM(YDIR)//' ROAD TEMP. LAYER '
  ELSE
    YSTRING='? ROAD TEMP. LAYER '
  ENDIF
  WRITE(YCOMMENT,'(A,I1.1,A4)') TRIM(YSTRING), JLAYER,' (K)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XT_ROAD(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
END DO
!
!* road water content
!

YRECFM=YPATCH//'WS_ROAD'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='WS_ROAD (kg/m2)'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XWS_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
!* wall temperatures
!

DO JLAYER=1,TOP%NWALL_LAYER
 IF (TOP%CWALL_OPT=='UNIF') THEN
  WRITE(YRECFM,'(A3,A5,I1.1,A1)') YPATCH,'TWALL',JLAYER,' '
  YRECFM=ADJUSTL(YRECFM)
  WRITE(YCOMMENT,'(A9,I1.1,A4)') 'X_Y_TWALL',JLAYER,' (K)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XT_WALL_A(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
 ELSE
  !* Wall A
  WRITE(YRECFM,'(A3,A6,I1.1)') YPATCH,'TWALLA',JLAYER
  YRECFM=ADJUSTL(YRECFM)
  IF (ODATA_ROAD_DIR) THEN
    YSTRING = 'X_Y_TWALL_A'
  ELSEIF (SIZE(T%XROAD_DIR)>0) THEN
    !* wall direction is uniform spatially, one can then indicate it in the comment
    CALL WALLA_DIR(T%XROAD_DIR(1),YDIR)
    YSTRING=TRIM(YDIR)//'-FACING WALL TEMP. LAYER '
  ELSE
    YSTRING='?-FACING WALL TEMP. LAYER '
  ENDIF
  WRITE(YCOMMENT,'(A,I1.1,A4)') TRIM(YSTRING), JLAYER,' (K)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XT_WALL_A(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
  !
  !* Wall B
  WRITE(YRECFM,'(A3,A6,I1.1)') YPATCH,'TWALLB',JLAYER
  YRECFM=ADJUSTL(YRECFM)
  IF (ODATA_ROAD_DIR) THEN
    YSTRING = 'X_Y_TWALL_B'
  ELSEIF (SIZE(T%XROAD_DIR)>0) THEN
    !* wall direction is uniform spatially, one can then indicate it in the comment
    CALL WALLB_DIR(T%XROAD_DIR(1),YDIR)
    YSTRING=TRIM(YDIR)//'-FACING WALL TEMP. LAYER '
  ELSE
    YSTRING='?-FACING WALL TEMP. LAYER '
  ENDIF
  WRITE(YCOMMENT,'(A,I1.1,A4)') TRIM(YSTRING), JLAYER,' (K)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XT_WALL_B(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
 END IF
END DO
!
IF (LWRITE_EXTERN) THEN
  !
  DO JLAYER=1,TOP%NROOF_LAYER
    WRITE(YRECFM,FMT='(A,I1.1)') 'D_ROOF',JLAYER
    YCOMMENT='Roof layer thickness'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,T%XD_ROOF(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
  END DO
  DO JLAYER=1,TOP%NWALL_LAYER
    WRITE(YRECFM,FMT='(A,I1.1)') 'D_WALL',JLAYER
    YCOMMENT='WALL layer thickness'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XD_WALL(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
  END DO
  DO JLAYER=1,TOP%NROAD_LAYER
    WRITE(YRECFM,FMT='(A,I1.1)') 'D_ROAD',JLAYER
    YCOMMENT='ROAD layer thickness'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XD_ROAD(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
  END DO
  IF (TOP%CBEM=='BEM') THEN
    DO JLAYER=1,BOP%NFLOOR_LAYER
      WRITE(YRECFM,FMT='(A,I1.1)') 'D_FLOOR',JLAYER
      YCOMMENT='FLOOR layer thickness'
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,B%XD_FLOOR(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
    END DO
  ENDIF
  !
ENDIF
!
!* internal building temperature
!
YRECFM=YPATCH//'TI_BLD'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='TI_BLD (K)'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,B%XTI_BLD(:),IRESP,HCOMMENT=YCOMMENT)
!
!
!* outdoor window temperature
!
YRECFM=YPATCH//'T_WIN1'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='T_WIN1 (K)'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,B%XT_WIN1(:),IRESP,HCOMMENT=YCOMMENT)
!
IF (TOP%CBEM=='BEM') THEN
!* internal building specific humidity
!
YRECFM=YPATCH//'QI_BLD'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='QI_BLD (kg/kg)'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,B%XQI_BLD(:),IRESP,HCOMMENT=YCOMMENT)
!
  !
  !* indoor window temperature
  !
  YRECFM=YPATCH//'T_WIN2'
  YRECFM=ADJUSTL(YRECFM)
  YCOMMENT='T_WIN2 (K)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,B%XT_WIN2(:),IRESP,HCOMMENT=YCOMMENT)
  !
  !* floor temperatures
  !
  DO JLAYER=1,BOP%NFLOOR_LAYER
    WRITE(YRECFM,'(A3,A5,I1.1,A1)') YPATCH,'TFLOO',JLAYER,' '
    WRITE(YCOMMENT,'(A9,I1.1,A4)') 'X_Y_TFLOO',JLAYER,' (K)'
    YRECFM=ADJUSTL(YRECFM)
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,B%XT_FLOOR(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
  END DO
  !
  !* internal th. mass temperature
  !
  DO JLAYER=1,BOP%NFLOOR_LAYER
    WRITE(YRECFM,'(A3,A5,I1.1,A1)') YPATCH,'TMASS',JLAYER,' '
    WRITE(YCOMMENT,'(A9,I1.1,A4)') 'X_Y_TMASS',JLAYER,' (K)'
    YRECFM=ADJUSTL(YRECFM)
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,B%XT_MASS(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
  END DO        
  !
ENDIF
!
!* deep road temperature
!
YRECFM=YPATCH//'TI_ROAD'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='TI_ROAD (K)'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XTI_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
!* snow mantel
!*  
DO JI = 1,SIZE(T%XT_ROOF,1)
 IMASK(JI) = JI
ENDDO 
!
YRECFM='RF'
 CALL WRITESURF_GR_SNOW(OSNOWDIMNC,HSELECT,HPROGRAM,YRECFM,YPATCH,&
                        SIZE(T%XT_ROOF,1),IMASK,0,T%TSNOW_ROOF, &
                        ZWSN_WR,ZRHO_WR,ZHEA_WR,ZAGE_WR,ZSG1_WR, &
                        ZSG2_WR,ZHIS_WR,ZALB_WR)
!
YRECFM='RD'
 CALL WRITESURF_GR_SNOW(OSNOWDIMNC,HSELECT,HPROGRAM,YRECFM,YPATCH,&
                        SIZE(T%XT_ROOF,1),IMASK,0,T%TSNOW_ROAD, &
                        ZWSN_WR,ZRHO_WR,ZHEA_WR,ZAGE_WR,ZSG1_WR, &
                        ZSG2_WR,ZHIS_WR,ZALB_WR)
!
!-------------------------------------------------------------------------------
!
!*       4.     Semi-prognostic fields:
!               ----------------------
!
!* temperature of canyon air
!
YRECFM=YPATCH//'TCANYON'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='T_CANYON (K)'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XT_CANYON(:),IRESP,HCOMMENT=YCOMMENT)
!
!* humidity of canyon air
!
YRECFM=YPATCH//'QCANYON'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='Q_CANYON (kg/kg)'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XQ_CANYON(:),IRESP,HCOMMENT=YCOMMENT)
!
!
!* Thermal solar panels present day production
!
IF (TOP%LSOLAR_PANEL) THEN
  YRECFM=YPATCH//'THER_PDAY'
  YRECFM=ADJUSTL(YRECFM)
  YCOMMENT='Thermal Solar Panels present day production (J/m2)'
  IF (.NOT. ASSOCIATED(TPN%XTHER_PRODC_DAY)) THEN
    ! for PREP cases
    ALLOCATE(TPN%XTHER_PRODC_DAY(SIZE(B%XTI_BLD)))
    TPN%XTHER_PRODC_DAY=0.
  END IF
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,TPN%XTHER_PRODC_DAY(:),IRESP,HCOMMENT=YCOMMENT)
END IF
!-------------------------------------------------------------------------------
!
!*       5.  Time
!            ----
!
IF (KPATCH==1) THEN
  YRECFM='DTCUR'
  YCOMMENT='s'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,TOP%TTIME,IRESP,HCOMMENT=YCOMMENT)
END IF
!
!
!-------------------------------------------------------------------------------
!
!*       6.  Urban green areas
!            ------------------
!
! Gardens
IF (TOP%LGARDEN) THEN
  CALL END_IO_SURF_n(HPROGRAM)
  CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'TOWN  ','TEB   ','WRITE','GARDEN_PROGNOSTIC.OUT.nc')
  CALL WRITESURF_TEB_GARDEN_n(HSELECT, OSNOWDIMNC, GDO, GDS, GDPEK, HPROGRAM,YPATCH)
ENDIF
!
! Grenn roofs
IF (TOP%LGREENROOF) THEN
  CALL END_IO_SURF_n(HPROGRAM)
  CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'TOWN  ','TEB   ','WRITE','GREENROOF_PROGNOSTIC.OUT.nc')
  CALL WRITESURF_TEB_GREENROOF_n(HSELECT, OSNOWDIMNC, GRO, GRS, GRPEK, HPROGRAM,YPATCH)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_TEB_N',1,ZHOOK_HANDLE)
!
!
!-------------------------------------------------------------------------------
CONTAINS
SUBROUTINE ROAD_DIR(PDIR,HDIR)
REAL,             INTENT(IN)  :: PDIR
 CHARACTER(LEN=7), INTENT(OUT) :: HDIR
REAL :: ZDIR
ZDIR=PDIR
IF (PDIR<0) ZDIR = PDIR +360.
IF (ZDIR>=  0.   .AND. ZDIR< 11.25) HDIR='N-S    '
IF (ZDIR>= 11.25 .AND. ZDIR< 33.75) HDIR='NNE-SSW'
IF (ZDIR>= 33.75 .AND. ZDIR< 56.25) HDIR='NE-SW'
IF (ZDIR>= 56.25 .AND. ZDIR< 78.75) HDIR='ENE-WSW'
IF (ZDIR>= 78.75 .AND. ZDIR<101.25) HDIR='E-W    '
IF (ZDIR>=101.25 .AND. ZDIR<123.75) HDIR='ESE-WNW'
IF (ZDIR>=123.75 .AND. ZDIR<146.25) HDIR='SE-NW  '
IF (ZDIR>=146.25 .AND. ZDIR<168.75) HDIR='SSE-NNW'
IF (ZDIR>=168.75 .AND. ZDIR<180.00) HDIR='N-S    '
END SUBROUTINE ROAD_DIR
SUBROUTINE WALLA_DIR(PDIR,HDIR)
REAL,             INTENT(IN)  :: PDIR
 CHARACTER(LEN=7), INTENT(OUT) :: HDIR
REAL :: ZDIR
ZDIR=PDIR
IF (PDIR<0) ZDIR = PDIR +360.
IF (ZDIR>=  0.   .AND. ZDIR< 11.25) HDIR='E      '
IF (ZDIR>= 11.25 .AND. ZDIR< 33.75) HDIR='ESE    '
IF (ZDIR>= 33.75 .AND. ZDIR< 56.25) HDIR='SE     ' 
IF (ZDIR>= 56.25 .AND. ZDIR< 78.75) HDIR='SSE    '
IF (ZDIR>= 78.75 .AND. ZDIR<101.25) HDIR='S      '
IF (ZDIR>=101.25 .AND. ZDIR<123.75) HDIR='SSW    '
IF (ZDIR>=123.75 .AND. ZDIR<146.25) HDIR='SW     '
IF (ZDIR>=146.25 .AND. ZDIR<168.75) HDIR='WSW    '
IF (ZDIR>=168.75 .AND. ZDIR<180.00) HDIR='W      '
END SUBROUTINE WALLA_DIR
SUBROUTINE WALLB_DIR(PDIR,HDIR)
REAL,             INTENT(IN)  :: PDIR
 CHARACTER(LEN=7), INTENT(OUT) :: HDIR
REAL :: ZDIR
ZDIR=PDIR
IF (PDIR<0) ZDIR = PDIR +360.
IF (ZDIR>=  0.   .AND. ZDIR< 11.25) HDIR='W      '
IF (ZDIR>= 11.25 .AND. ZDIR< 33.75) HDIR='WNW    '
IF (ZDIR>= 33.75 .AND. ZDIR< 56.25) HDIR='NW     ' 
IF (ZDIR>= 56.25 .AND. ZDIR< 78.75) HDIR='NNW    '
IF (ZDIR>= 78.75 .AND. ZDIR<101.25) HDIR='N      '
IF (ZDIR>=101.25 .AND. ZDIR<123.75) HDIR='NNE    '
IF (ZDIR>=123.75 .AND. ZDIR<146.25) HDIR='NE     '
IF (ZDIR>=146.25 .AND. ZDIR<168.75) HDIR='ENE    '
IF (ZDIR>=168.75 .AND. ZDIR<180.00) HDIR='E      '
END SUBROUTINE WALLB_DIR
!-------------------------------------------------------------------------------
!
END SUBROUTINE WRITESURF_TEB_n
