!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITESURF_PGD_ISBA_PAR_n (HSELECT, DTV, HPROGRAM)
!     ################################################
!
!!****  *WRITESURF_PGD_ISBA_PAR_n* - writes ISBA physiographic fields
!!                        
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003 
!!      P. Le Moigne 12/2004 : add type of photosynthesis 
!!      P. Samuelsson 10/2014: MEB
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
!
USE MODN_WRITE_SURF_ATM
!
USE MODI_WRITE_SURF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
 CHARACTER(LEN=*), DIMENSION(:), INTENT(IN) :: HSELECT
!
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTV
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
LOGICAL           :: GFOUND         ! Return code when searching namelist
INTEGER           :: ILUOUT         ! logical unit of output file
INTEGER           :: INAM           ! logical unit of namelist file
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=2)  :: YPAT
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
INTEGER           :: JTIME          ! loop index
INTEGER           :: JL         ! loop index
INTEGER           :: JV         ! loop index
REAL,    DIMENSION(:), ALLOCATABLE :: ZWORK
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_PGD_ISBA_PAR_N',0,ZHOOK_HANDLE)
!
YRECFM='L_VEGTYPE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%LDATA_VEGTYPE,IRESP,HCOMMENT=YCOMMENT)
IF (DTV%LDATA_VEGTYPE) THEN
  YCOMMENT='X_Y_DATA_ISBATYPE'
  IF (LSPLIT_PATCH) THEN
    DO JV=1,DTV%NVEGTYPE
      WRITE(YPAT,'(I2)') JV
      YRECFM = 'D_VEGTY_P'//ADJUSTL(YPAT)
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_VEGTYPE(:,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
  ELSE
    YRECFM='D_VEGTYPE'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_VEGTYPE(:,:),IRESP,HCOMMENT=YCOMMENT,HNAM_DIM="Number_of_covers")
  ENDIF
ENDIF
!
YRECFM='NDATA_TIME'
YCOMMENT='(-)'
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%NTIME,IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='L_VEG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_VEG,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME
  YCOMMENT='X_Y_D_VEG'
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_VEG((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_VEG_T',JTIME,'V',JV
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_VEG(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
END DO
!
YRECFM='L_LAI'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%LDATA_LAI,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
!for each defined time
DO JTIME=1,DTV%NTIME
  YCOMMENT='X_Y_D_LAI'
  !for each vegtype for this time
  DO JV=1,DTV%NVEGTYPE
    ! we write the field only if the data exists
    IF (DTV%LDATA_LAI((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_LAI_T',JTIME,'V',JV    
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_LAI(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
END DO
!
YRECFM='L_Z0'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%LDATA_Z0,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME
  YCOMMENT='X_Y_D_Z0'
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_Z0((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A6,I2.2,A1,I2.2)') 'D_Z0_T',JTIME,'V',JV       
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_Z0(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
END DO
!
YRECFM='L_EMIS'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_EMIS,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME
  YCOMMENT='X_Y_D_EMIS'
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_EMIS((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_EMI_T',JTIME,'V',JV       
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_EMIS(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  END DO
ENDDO
!
YRECFM='L_H_VEG'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%LDATA_H_VEG,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME
  YCOMMENT='X_Y_D_H_VEG'
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_H_VEG((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_HVG_T',JTIME,'V',JV       
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_H_VEG(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
END DO
!
YRECFM='L_GNDLITTER'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%LDATA_GNDLITTER,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME
  YCOMMENT='X_Y_D_GNDLITTER'
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_GNDLITTER((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_GLI_T',JTIME,'V',JV       
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_GNDLITTER(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
END DO
!
YRECFM='L_Z0LITTER'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%LDATA_Z0LITTER,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME
  YCOMMENT='X_Y_D_Z0LITTER'
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_Z0LITTER((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_Z0L_T',JTIME,'V',JV       
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_Z0LITTER(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
END DO
!
YRECFM='L_ALBNIR_VEG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_ALBNIR_VEG,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_ALBNIR_VEG((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_ANV_T',JTIME,'V',JV   
      YCOMMENT='X_Y_'//YRECFM  
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_ALBNIR_VEG(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
ENDDO
!
YRECFM='L_ALBVIS_VEG'
YCOMMENT=YRECFM
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_ALBVIS_VEG,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME 
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_ALBVIS_VEG((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_AVV_T',JTIME,'V',JV
      YCOMMENT='X_Y_'//YRECFM
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_ALBVIS_VEG(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
ENDDO
!
YRECFM='L_ALBUV_VEG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_ALBUV_VEG,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME 
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_ALBUV_VEG((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_AUV_T',JTIME,'V',JV
      YCOMMENT='X_Y_'//YRECFM
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_ALBUV_VEG(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
ENDDO
!
YRECFM='L_ALBNIR_SOI'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_ALBNIR_SOIL,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME   
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_ALBNIR_SOIL((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_ANS_T',JTIME,'V',JV 
      YCOMMENT='X_Y_'//YRECFM     
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_ALBNIR_SOIL(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
ENDDO
!
YRECFM='L_ALBVIS_SOI'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_ALBVIS_SOIL,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME  
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_ALBVIS_SOIL((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_AVS_T',JTIME,'V',JV
      YCOMMENT='X_Y_'//YRECFM     
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_ALBVIS_SOIL(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
ENDDO
!
YRECFM='L_ALBUV_SOI'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_ALBUV_SOIL,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JTIME=1,DTV%NTIME   
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_ALBUV_SOIL((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_AUS_T',JTIME,'V',JV
      YCOMMENT='X_Y_'//YRECFM       
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_ALBUV_SOIL(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
ENDDO
!
!
YRECFM='L_RSMIN'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%LDATA_RSMIN,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_D_RSMIN'
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_RSMIN(JV)) THEN
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_RSMIN_V',JV
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_RSMIN(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_GAMMA'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_GAMMA,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_D_GAMMA'
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_GAMMA(JV)) THEN
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_GAMMA_V',JV       
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_GAMMA(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_WRMAX_CF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_WRMAX_CF,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_D_WRMAX_CF'
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_WRMAX_CF(JV)) THEN
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_WRMAX_V',JV       
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_WRMAX_CF(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_RGL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_RGL,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_D_RGL'
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_RGL(JV)) THEN
    WRITE(YRECFM,FMT='(A7,I2.2)') 'D_RGL_V',JV       
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_RGL(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_CV'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_CV,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_D_CV'
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_CV(JV)) THEN
    WRITE(YRECFM,FMT='(A6,I2.2)') 'D_CV_V',JV       
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_CV(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_Z0_O_Z0H'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_Z0_O_Z0H,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_D_Z0_O_Z0H'
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_Z0_O_Z0H(JV)) THEN
    WRITE(YRECFM,FMT='(A7,I2.2)') 'D_Z0H_V',JV       
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_Z0_O_Z0H(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_DG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_DG,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_DG(JV)) THEN
    DO JL=1,SIZE(DTV%XPAR_DG,2)
      WRITE(YRECFM,FMT='(A6,I2.2,A1,I2.2)') 'D_DG_L',JL,'V',JV  
      YCOMMENT='X_Y_'//YRECFM     
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_DG(:,JL,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
  ENDIF
ENDDO
!
YRECFM='L_ROOTFRAC'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_ROOTFRAC,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_ROOTFRAC(JV)) THEN
    DO JL=1,SIZE(DTV%XPAR_ROOTFRAC,2)
      WRITE(YRECFM,FMT='(A6,I2.2,A1,I2.2)') 'D_RTF_L',JL,'V',JV
      YCOMMENT='X_Y_'//YRECFM
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_ROOTFRAC(:,JL,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
  ENDIF
ENDDO
!
YRECFM='L_GROUND_DPT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_GROUND_DEPTH,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_GROUND_DEPTH(JV)) THEN
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_GRDPT_V',JV  
    YCOMMENT='X_Y_'//YRECFM    
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_GROUND_DEPTH(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_ROOT_DEPTH'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_ROOT_DEPTH,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_ROOT_DEPTH(JV)) THEN
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_RTDPT_V',JV      
    YCOMMENT='X_Y_'//YRECFM 
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_ROOT_DEPTH(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_ROOT_EXT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_ROOT_EXTINCTION,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_ROOT_EXTINCTION(JV)) THEN
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_RTEXT_V',JV 
    YCOMMENT='X_Y_'//YRECFM    
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_ROOT_EXTINCTION(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_ROOT_LIN'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_ROOT_LIN,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_ROOT_LIN(JV)) THEN
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_RTLIN_V',JV       
    YCOMMENT='X_Y_'//YRECFM
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_ROOT_LIN(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_DICE'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_DICE,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_DICE(JV)) THEN
    WRITE(YRECFM,FMT='(A8,I2.2)') 'D_DICE_V',JV
    YCOMMENT='X_Y_'//YRECFM    
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_DICE(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_GMES'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_GMES,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_GMES(JV)) THEN
    WRITE(YRECFM,FMT='(A8,I2.2)') 'D_GMES_V',JV   
    YCOMMENT='X_Y_'//YRECFM    
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_GMES(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_BSLAI'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_BSLAI,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_BSLAI(JV)) THEN
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_BSLAI_V',JV   
    YCOMMENT='X_Y_'//YRECFM   
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_BSLAI(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_LAIMIN'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_LAIMIN,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_LAIMIN(JV)) THEN 
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_LAIMIN_V',JV     
    YCOMMENT='X_Y_'//YRECFM
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_LAIMIN(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_SEFOLD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_SEFOLD,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_SEFOLD(JV)) THEN
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_SEFOLD_V',JV               
    YCOMMENT='X_Y_'//YRECFM
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_SEFOLD(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_GC'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_GC,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_GC(JV)) THEN
    WRITE(YRECFM,FMT='(A6,I2.2)') 'D_GC_V',JV  
    YCOMMENT='X_Y_'//YRECFM   
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_GC(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_DMAX'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_DMAX,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_DMAX(JV)) THEN
    WRITE(YRECFM,FMT='(A8,I2.2)') 'D_DMAX_V',JV      
    YCOMMENT='X_Y_'//YRECFM
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_DMAX(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_F2I'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_F2I,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_F2I(JV)) THEN
    WRITE(YRECFM,FMT='(A7,I2.2)') 'D_F2I_V',JV   
    YCOMMENT='X_Y_'//YRECFM
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_F2I(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_STRESS'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_STRESS,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
ALLOCATE(ZWORK(SIZE(DTV%LPAR_STRESS,1)))
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_STRESS(JV)) THEN
    ZWORK=0.
    WHERE(DTV%LPAR_STRESS(:,JV)) ZWORK=1.
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_STRESS_V',JV             
    YCOMMENT='X_Y_'//YRECFM   
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK(:),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
DEALLOCATE(ZWORK)
!
YRECFM='L_H_TREE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_H_TREE,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_H_TREE(JV)) THEN
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_H_TREE_V',JV       
    YCOMMENT='X_Y_'//YRECFM
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_H_TREE(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_RE25'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_RE25,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_RE25(JV)) THEN
    WRITE(YRECFM,FMT='(A8,I2.2)') 'D_RE25_V',JV       
    YCOMMENT='X_Y_'//YRECFM
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_RE25(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_CE_NITRO'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_CE_NITRO,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_CE_NITRO(JV)) THEN
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_CENITR_V',JV   
    YCOMMENT='X_Y_'//YRECFM 
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_CE_NITRO(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_CF_NITRO'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_CF_NITRO,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_CF_NITRO(JV)) THEN
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_CFNITR_V',JV  
    YCOMMENT='X_Y_'//YRECFM    
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_CF_NITRO(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_CNA_NITRO'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_CNA_NITRO,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_CNA_NITRO(JV)) THEN
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_CNANIT_V',JV 
    YCOMMENT='X_Y_'//YRECFM 
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_CNA_NITRO(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_IRRIG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_IRRIG,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_IRRIG' 
DO JTIME=1,DTV%NTIME
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_IRRIG((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_IRR_T',JTIME,'V',JV       
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_IRRIG(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
ENDDO
!
YRECFM='L_WATSUP'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_WATSUP,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_WATSUP'   
DO JTIME=1,DTV%NTIME
  DO JV=1,DTV%NVEGTYPE
    IF (DTV%LDATA_WATSUP((JTIME-1)*DTV%NVEGTYPE+JV)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2,A1,I2.2)') 'D_WAT_T',JTIME,'V',JV  
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_WATSUP(:,JTIME,JV),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  ENDDO
ENDDO
!
YRECFM='L_SEED_M'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_SEED_M,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_SEED_M' 
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_SEED_M(JV)) THEN
    WRITE(YRECFM,FMT='(A10,I2.2,A1)') 'D_SEED_M_V',JV  
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_SEED_M(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_SEED_D'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_SEED_D,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_SEED_D'
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_SEED_D(JV)) THEN
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_SEED_D_V',JV     
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_SEED_D(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_REAP_M'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_REAP_M,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_REAP_M'
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_REAP_M(JV)) THEN
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_REAP_M_V',JV      
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_REAP_M(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
YRECFM='L_REAP_D'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_REAP_D,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
YCOMMENT='X_Y_REAP_D'
DO JV=1,DTV%NVEGTYPE
  IF (DTV%LDATA_REAP_D(JV)) THEN
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_REAP_D_V',JV     
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%XPAR_REAP_D(:,JV),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
ENDDO
!
!
YRECFM='L_CONDSAT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_CONDSAT,IRESP,HCOMMENT=YCOMMENT)
IF (DTV%LDATA_CONDSAT) THEN
  DO JL=1,SIZE(DTV%XPAR_CONDSAT,2)
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_CNDSAT_L',JL
    YCOMMENT='X_Y_'//YRECFM     
    CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_CONDSAT(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_MPOTSAT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_MPOTSAT,IRESP,HCOMMENT=YCOMMENT)
IF (DTV%LDATA_MPOTSAT) THEN
  DO JL=1,SIZE(DTV%XPAR_MPOTSAT,2)
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_MPTSAT_L',JL
    YCOMMENT='X_Y_'//YRECFM     
    CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_MPOTSAT(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_BCOEF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_BCOEF,IRESP,HCOMMENT=YCOMMENT)
IF (DTV%LDATA_BCOEF) THEN
  DO JL=1,SIZE(DTV%XPAR_BCOEF,2)
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_BCOEF_L',JL
    YCOMMENT='X_Y_'//YRECFM     
    CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_BCOEF(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_WWILT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_WWILT,IRESP,HCOMMENT=YCOMMENT)
IF (DTV%LDATA_WWILT) THEN
  DO JL=1,SIZE(DTV%XPAR_WWILT,2)
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_WWILT_L',JL
    YCOMMENT='X_Y_'//YRECFM     
    CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_WWILT(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_WFC'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_WFC,IRESP,HCOMMENT=YCOMMENT)
IF (DTV%LDATA_WFC) THEN
  DO JL=1,SIZE(DTV%XPAR_WFC,2)
    WRITE(YRECFM,FMT='(A7,I2.2)') 'D_WFC_L',JL
    YCOMMENT='X_Y_'//YRECFM     
    CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_WFC(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_WSAT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DTV%LDATA_WSAT,IRESP,HCOMMENT=YCOMMENT)
IF (DTV%LDATA_WSAT) THEN
  DO JL=1,SIZE(DTV%XPAR_WSAT,2)
    WRITE(YRECFM,FMT='(A8,I2.2)') 'D_WSAT_L',JL
    YCOMMENT='X_Y_'//YRECFM     
    CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTV%XPAR_WSAT(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_PGD_ISBA_PAR_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE WRITESURF_PGD_ISBA_PAR_n
