!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITE_DIAG_SEB_TEB_n (DTCO, HSELECT, U, CHT, DGO, D, DUT, HPROGRAM)
!     #################################
!
!!****  *WRITE_DIAG_SEB_TEB_n* - writes TEB diagnostics
!!
!!    PURPOSE
!!    -------
!!
!!
!!**  METHOD
!!    ------
!!          
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      Modified    01/2006 : TEB flux parameterization.
!!       V. Masson  10/2013 : Adds heat/cold stress ranges diagnostics
!!      B. Decharme 02/2016 : NBLOCK instead of LCOUNTW for compilation in AAA
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t, DIAG_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_CH_TEB_n, ONLY : CH_TEB_t
USE MODD_DIAG_UTCI_TEB_n, ONLY : DIAG_UTCI_TEB_t
!
USE MODD_XIOS, ONLY : LALLOW_ADD_DIM, YSWBAND_DIM_NAME
!
USE MODD_SURF_PAR,  ONLY : XUNDEF
USE MODD_UTCI
!
#ifdef SFX_ARO
USE MODD_IO_SURF_ARO,   ONLY : NBLOCK
#endif
!
#ifdef SFX_OL
USE MODD_IO_SURF_OL, ONLY : LDEF
#endif
!
USE MODI_INIT_IO_SURF_n
USE MODI_WRITE_SURF
USE MODI_END_IO_SURF_n
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
 CHARACTER(LEN=*), DIMENSION(:), INTENT(IN) :: HSELECT
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
TYPE(DIAG_t), INTENT(INOUT) :: D
TYPE(DIAG_UTCI_TEB_t), INTENT(INOUT) :: DUT
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
 CHARACTER(LEN=2)  :: YNUM
!
LOGICAL           :: GRESET
INTEGER           :: JSV, JSW
INTEGER           :: JSTRESS         ! loop on heat stress ranges
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
!         Initialisation for IO
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_TEB_N',0,ZHOOK_HANDLE)
!
GRESET=.TRUE.
#ifdef SFX_ARO
GRESET=(NBLOCK>0)
#endif
#ifdef SFX_OL
IF (LDEF) GRESET = .FALSE.
#endif
!
CALL INIT_IO_SURF_n(DTCO, U,   HPROGRAM,'TOWN  ','TEB   ','WRITE','TEB_DIAGNOSTICS.OUT.nc')
!
!
!
!*       2.     Richardson number :
!               -----------------
!
IF (DGO%N2M>=1) THEN

  YRECFM='RI_TEB'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XRI(:),IRESP,HCOMMENT=YCOMMENT)
  !
END IF
!
!*       3.     Energy fluxes :
!               -------------
!
IF (DGO%LSURF_BUDGET) THEN

  YRECFM='RN_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XRN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XLE(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (DGO%LRAD_BUDGET) THEN
    !        
    YRECFM='SWD_TEB'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XSWD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWU_TEB'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XSWU(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWD_TEB'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XLWD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWU_TEB'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XLWU(:),IRESP,HCOMMENT=YCOMMENT)
    !
    IF (LALLOW_ADD_DIM)  THEN
      !
      YRECFM='SWD_TEB'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
      CALL WRITE_SURF(HSELECT,&
           HPROGRAM,YRECFM,D%XSWBD(:,:),IRESP,HCOMMENT=YCOMMENT, HNAM_DIM=YSWBAND_DIM_NAME)
      !
      YRECFM='SWU_TEB'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
      CALL WRITE_SURF(HSELECT,&
           HPROGRAM,YRECFM,D%XSWBD(:,:),IRESP,HCOMMENT=YCOMMENT, HNAM_DIM=YSWBAND_DIM_NAME)  
      !
    ELSE
      !    
      DO JSW=1, SIZE(D%XSWBD,2)
        YNUM=ACHAR(48+JSW)
        !
        YRECFM='SWD_TEB_'//YNUM
        YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
        CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XSWBD(:,JSW),IRESP,HCOMMENT=YCOMMENT)
        !
        YRECFM='SWU_TEB_'//YNUM
        YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
        CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XSWBU(:,JSW),IRESP,HCOMMENT=YCOMMENT)
        !
      ENDDO
      !
    ENDIF
    !
  ENDIF
  !
  YRECFM='FMU_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XFMU(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FMV_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XFMV(:),IRESP,HCOMMENT=YCOMMENT)
  !
END IF
!
!
!
!*       4.     Transfer coefficients
!               ---------------------
!
IF (DGO%LCOEF) THEN

  YRECFM='CD_TEB'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XCD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='CH_TEB'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XCH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='CE_TEB'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XCE(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='Z0_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (M)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XZ0(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='Z0H_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (M)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XZ0H(:),IRESP,HCOMMENT=YCOMMENT)
  !
ENDIF
!
!
!*       5.     Surface humidity
!               ----------------
!
IF (DGO%LSURF_VARS) THEN

  YRECFM='QS_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XQS(:),IRESP,HCOMMENT=YCOMMENT)
  !
ENDIF

!
!*       5.     parameters at 2 and 10 meters :
!               -----------------------------
!
IF (DGO%N2M>=1) THEN

  YRECFM='T2M_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XT2M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='T2MMIN_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XT2M_MIN(:),IRESP,HCOMMENT=YCOMMENT)
  IF(GRESET)D%XT2M_MIN(:)=XUNDEF
  !
  YRECFM='T2MMAX_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XT2M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
  IF(GRESET)D%XT2M_MAX(:)=-XUNDEF
  !
  YRECFM='Q2M_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XQ2M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='HU2M_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XHU2M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='HU2MMIN_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XHU2M_MIN(:),IRESP,HCOMMENT=YCOMMENT)
  IF(GRESET)D%XHU2M_MIN(:)=XUNDEF
  !
  YRECFM='HU2MMAX_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XHU2M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
  IF(GRESET)D%XHU2M_MAX(:)=-XUNDEF
  !
  YRECFM='ZON10M_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (M/S)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XZON10M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='MER10M_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (M/S)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XMER10M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='W10M_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (M/S)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XWIND10M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='W10MMAX_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (M/S)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XWIND10M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
  IF(GRESET)D%XWIND10M_MAX(:)=0.0
  !
  YRECFM='SFCO2_TEB'
  YCOMMENT='X_Y_'//YRECFM//' (M.kgCO2.S-1.kgAIR-1)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,D%XSFCO2(:),IRESP,HCOMMENT=YCOMMENT)
  !
END IF
!
IF (DUT%LUTCI .AND. DGO%N2M >0) THEN
  YRECFM='UTCI_IN'
!RJ: extended ascii should be avoided in I/O
  YCOMMENT='UTCI for person indoor'//' (°C)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DUT%XUTCI_IN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='UTCI_OUTSUN'
!RJ: extended ascii should be avoided in I/O
  YCOMMENT='UTCI for person at sun'//' (°C)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DUT%XUTCI_OUTSUN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='UTCI_OUTSHAD'
!RJ: extended ascii should be avoided in I/O
  YCOMMENT='UTCI for person in shade'//' (°C)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DUT%XUTCI_OUTSHADE(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='TRAD_SUN'
  YCOMMENT='Mean radiant temperature seen by person at sun'//' (K)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DUT%XTRAD_SUN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='TRAD_SHADE'
  YCOMMENT='Mean radiant temperature seen by person in shade'//' (K)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DUT%XTRAD_SHADE(:),IRESP,HCOMMENT=YCOMMENT)
  !
  DO JSTRESS=1,NUTCI_STRESS
    YRECFM='UTCIC_IN_'//CUTCI_STRESS_NAMES(JSTRESS)
    YCOMMENT='Cumulated time spent in '//CUTCI_STRESS_NAMES(JSTRESS)//' stress range for person indoor'//' (s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DUT%XUTCIC_IN(:,JSTRESS),IRESP,HCOMMENT=YCOMMENT)
  END DO
  !
  DO JSTRESS=1,NUTCI_STRESS
    YRECFM='UTCIC_SU_'//CUTCI_STRESS_NAMES(JSTRESS)
    YCOMMENT='Cumulated time spent in '//CUTCI_STRESS_NAMES(JSTRESS)//' stress range for person at sun'//' (s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DUT%XUTCIC_OUTSUN(:,JSTRESS),IRESP,HCOMMENT=YCOMMENT)
  END DO
  !
  DO JSTRESS=1,NUTCI_STRESS
    YRECFM='UTCIC_SH_'//CUTCI_STRESS_NAMES(JSTRESS)
    YCOMMENT='Cumulated time spent in '//CUTCI_STRESS_NAMES(JSTRESS)//' stress range for person in shade'//' (s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DUT%XUTCIC_OUTSHADE(:,JSTRESS),IRESP,HCOMMENT=YCOMMENT)
  END DO
END IF
!
!
!*       6.     chemical diagnostics:
!               --------------------
!
IF (CHT%SVT%NBEQ>0 .AND. CHT%CCH_DRY_DEP=="WES89 ") THEN
  DO JSV = 1,SIZE(CHT%CCH_NAMES,1)
    YRECFM='DVTN'//TRIM(CHT%CCH_NAMES(JSV))
    WRITE(YCOMMENT,'(A13,I3.3)')'(m/s) DV_TWN_',JSV
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,CHT%XDEP(:,JSV),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!-------------------------------------------------------------------------------
!
!         End of IO
!
 CALL END_IO_SURF_n(HPROGRAM)
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_TEB_N',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE WRITE_DIAG_SEB_TEB_n
