!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITE_DIAG_SEB_SEAICE_n (DTCO, DUO, U, DSO, DI, DIC, HPROGRAM)
!     #################################
!
!!****  *WRITE_DIAG_SEB_SEAICE_n* - write the seaice diagnostic fields
!!
!!    PURPOSE
!!    -------
!!
!!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      S.Senesi                *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2014
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t, DIAG_t
!
USE MODD_SFX_OASIS,      ONLY : LCPL_SEAICE
!
USE MODI_INIT_IO_SURF_n
USE MODI_WRITE_SURF
USE MODI_END_IO_SURF_n
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DUO
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DSO
TYPE(DIAG_t), INTENT(INOUT) :: DI
TYPE(DIAG_t), INTENT(INOUT) :: DIC
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
CHARACTER(LEN=100):: YCOMMENT       ! Comment string
CHARACTER(LEN=2)  :: YNUM
INTEGER           :: JSV, JSW
!
REAL(KIND=JPRB)   :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!         Initialisation for IO
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_SEAICE_N',0,ZHOOK_HANDLE)
!
CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'SEA   ','SEAFLX','WRITE','SEAFLUX_DIAGNOSTICS.OUT.nc')
!
!
!*       8.2.     Richardson number :
!               -----------------
IF (DSO%N2M>=1) THEN
   !
   YRECFM='RI_SEAICE'
   YCOMMENT='X_Y_'//YRECFM
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XRI(:),IRESP,HCOMMENT=YCOMMENT)
   !
END IF
!
!*       8.3     Energy fluxes :
!               -------------
!
IF (DSO%LSURF_BUDGET) THEN

   YRECFM='RN_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XRN(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='H_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XH(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='LE_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XLE(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='GFLX_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
   !
   IF (DSO%LRAD_BUDGET) THEN
      !
      YRECFM='SWU_SEAICE'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
      !
      CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XSWU(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='LWU_SEAICE'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
      !
      CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XLWU(:),IRESP,HCOMMENT=YCOMMENT)
      !
      DO JSW=1, SIZE(DI%XSWBU,2)
         YNUM=ACHAR(48+JSW)
         !
         YRECFM='SWU_SEAICE_'//YNUM
         YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
         !
         CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XSWBU(:,JSW),IRESP,HCOMMENT=YCOMMENT)
         !
      ENDDO
      !
   ENDIF
   !
   YRECFM='FMU_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XFMU(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='FMV_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XFMV(:),IRESP,HCOMMENT=YCOMMENT)
   !
END IF
!
IF (DSO%LSURF_BUDGETC) THEN
   !
   YRECFM='RNC_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DIC%XRN(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='HC_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DIC%XH(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='LEC_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DIC%XLE(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='GFLXC_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DIC%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
   IF (DSO%LRAD_BUDGET .OR. (DSO%LSURF_BUDGETC .AND. .NOT.DUO%LRESET_BUDGETC)) THEN
      !
      YRECFM='SWUC_SEAICE'
      YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
      !
      CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DIC%XSWU(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='LWUC_SEAICE'
      YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
      !
      CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DIC%XLWU(:),IRESP,HCOMMENT=YCOMMENT)
      !
   ENDIF
   !
   YRECFM='FMUC_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (kg/ms)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DIC%XFMU(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='FMVC_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (kg/ms)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DIC%XFMV(:),IRESP,HCOMMENT=YCOMMENT)
   !
END IF
!
!*       8.4     transfer coefficients
!               ---------------------
!
IF (DSO%LCOEF) THEN
   !
   YRECFM='CD_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (W/s2)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XCD(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='CH_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (W/s)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XCH(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='Z0_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (M)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XZ0(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='Z0H_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (M)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XZ0H(:),IRESP,HCOMMENT=YCOMMENT)
   !
END IF
!
!
!*       8.5     Surface humidity
!               ----------------
!
IF (DSO%LSURF_VARS) THEN
   YRECFM='QS_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XQS(:),IRESP,HCOMMENT=YCOMMENT)
   !
ENDIF
!

!
!*       8.6.     parameters at 2 and 10 meters :
!               -----------------------------
!
IF (DSO%N2M>=1) THEN
   !
   YRECFM='T2M_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (K)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XT2M(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='Q2M_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XQ2M(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='HU2M_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (-)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XHU2M(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='ZON10M_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (M/S)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XZON10M(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='MER10M_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (M/S)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XMER10M(:),IRESP,HCOMMENT=YCOMMENT)
   !
   YRECFM='W10M_SEAICE'
   YCOMMENT='X_Y_'//YRECFM//' (M/S)'
   !
   CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,DI%XWIND10M(:),IRESP,HCOMMENT=YCOMMENT)
   !
END IF
!
!         End of IO
!
 CALL END_IO_SURF_n(HPROGRAM)

IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_SEAICE_N',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE WRITE_DIAG_SEB_SEAICE_n
