!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITE_DIAG_SEB_ISBA_n ( DTCO, DUO, U, NCHI, CHI, ID, NDST, GB, &
                                         IO, S, NP, NPE, HPROGRAM)
!     #################################
!
!!****  *WRITE_DIAG_SEB_ISBA* - writes the ISBA diagnostic fields
!!
!!    PURPOSE
!!    -------
!!
!!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      B. Decharme 06/2009  key to write (or not) patch result
!!      B. Decharme 08/2009  cumulative radiative budget
!!      B. Decharme  09/2012 : Bug in local variables declaration in PROVAR_TO_DIAG
!!      B. Decharme 09/2012  New diag :
!!                           carbon fluxes and reservoirs
!!                           soil liquid and ice water content in kg/m2 and m3/m3
!!      B. Decharme  06/13   Add diags (sublimation, lateral drainage)
!!                           All snow outputs noted SN
!!                           delete NWG_SIZE
!!      S. Belamari 06/2014 : Introduce GRESET to avoid errors due to NBLOCK=0
!!                            when coupled with ARPEGE/ALADIN/AROME
!!      P. Samuelsson 10/2014 MEB
!!      B. Decharme 02/2016 : NBLOCK instead of LCOUNTW for compilation in AAA
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_SURFEX_MPI, ONLY : NRANK, NPIO
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t, CH_ISBA_NP_t
USE MODD_SURFEX_n, ONLY : ISBA_DIAG_t
USE MODD_DST_n, ONLY : DST_NP_t
USE MODD_GR_BIOG_n, ONLY : GR_BIOG_t
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
USE MODD_ISBA_n, ONLY : ISBA_NP_t, ISBA_P_t, ISBA_NPE_t, ISBA_PE_t, ISBA_S_t
!
#ifdef SFX_ARO
USE MODD_IO_SURF_ARO,   ONLY : NBLOCK
#endif
!
USE MODD_XIOS, ONLY : LALLOW_ADD_DIM, YGROUND_LAYER_DIM_NAME, &
                      YWGROUND_LAYER_DIM_NAME, YWIGROUND_LAYER_DIM_NAME, &
                      YSWBAND_DIM_NAME
!
USE MODD_SURF_PAR,   ONLY : XUNDEF, NUNDEF
!
USE MODD_CSTS,       ONLY : XRHOLW, XTT, XLMTT
!
USE MODD_DST_SURF
!
USE MODD_AGRI,     ONLY : LAGRIP
!
USE MODE_DIAG
!
USE MODI_INIT_IO_SURF_n
USE MODI_WRITE_SURF
USE MODI_END_IO_SURF_n
USE MODI_WRITE_FIELD_1D_PATCH
!
#ifdef SFX_OL
USE MODD_IO_SURF_OL, ONLY : LDEF
USE MODN_IO_OFFLINE, ONLY : XTSTEP_OUTPUT
#endif
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DUO
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(CH_ISBA_NP_t), INTENT(INOUT) :: NCHI
TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
TYPE(ISBA_DIAG_t), INTENT(INOUT) :: ID
TYPE(DST_NP_t), INTENT(INOUT) :: NDST
TYPE(GR_BIOG_t), INTENT(INOUT) :: GB
TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
TYPE(ISBA_S_t), INTENT(INOUT) :: S
TYPE(ISBA_NP_t), INTENT(INOUT) :: NP
TYPE(ISBA_NPE_t), INTENT(INOUT) :: NPE
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
TYPE(ISBA_P_t), POINTER :: PK
TYPE(ISBA_PE_t), POINTER :: PEK
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be write
CHARACTER(LEN=100):: YCOMMENT       ! Comment string
CHARACTER(LEN=2)  :: YNUM
!
LOGICAL           :: GRESET
INTEGER           :: JSV, JSW, JP, ISIZE
INTEGER           :: ISIZE_LMEB_PATCH   ! Number of patches where multi-energy balance should be applied
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!         Initialisation for IO
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_ISBA_N',0,ZHOOK_HANDLE)
!
ISIZE_LMEB_PATCH=COUNT(IO%LMEB_PATCH(:))
!
GRESET=.TRUE.
#ifdef SFX_ARO
GRESET=(NBLOCK>0)
#endif
#ifdef SFX_OL
IF (LDEF) GRESET = .FALSE.
#endif
!
#ifdef SFX_OL
IF (ID%O%LSURF_BUDGET .AND. DUO%LRESETCUMUL .AND. ID%O%LSURF_BUDGETC .AND. .NOT.LDEF) THEN
  !
  ! Output variables are not instantaneous but averaged over the output time step
  ! Fluxes by patch
  DO JP = 1,IO%NPATCH
    CALL AVG_DIAG_TSTEP_SURF(XTSTEP_OUTPUT, ID%NDC%AL(JP), ID%ND%AL(JP))
  ENDDO
  CALL AVG_DIAG_TSTEP_SURF(XTSTEP_OUTPUT, ID%DC, ID%D)
  !  
  IF (ID%DE%LSURF_EVAP_BUDGET) THEN
    DO JP = 1,IO%NPATCH
      CALL AVG_DIAG_TSTEP_EVAP(XTSTEP_OUTPUT, ID%NDEC%AL(JP), ID%NDE%AL(JP))
    ENDDO
    CALL AVG_DIAG_TSTEP_EVAP(XTSTEP_OUTPUT, ID%DEC, ID%DE)
    !
    IF (ID%DE%LWATER_BUDGET) THEN
      DO JP = 1,IO%NPATCH
        CALL AVG_DIAG_TSTEP_WATER(XTSTEP_OUTPUT, ID%NDEC%AL(JP), ID%NDE%AL(JP))
      ENDDO
      CALL AVG_DIAG_TSTEP_WATER(XTSTEP_OUTPUT, ID%DEC, ID%DE)
    ENDIF
  ENDIF
  !
END IF
#endif
!
IF ( ID%DM%LPROSNOW ) THEN
  CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'NATURE','ISBA  ','WRITE','ISBA_PROGNOSTIC.OUT.nc')
ELSE
  CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'NATURE','ISBA  ','WRITE','ISBA_DIAGNOSTICS.OUT.nc')
ENDIF
!
!-------------------------------------------------------------------------------
!
!*       2.     Richardson number :
!               -----------------
!
IF (ID%O%N2M>=1) THEN
  !
  YRECFM='RI_ISBA'
  YCOMMENT='Richardson number over tile nature'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XRI(:),IRESP,HCOMMENT=YCOMMENT)
  !
END IF
!
!*       3.     Energy fluxes :
!               -------------
!
IF (ID%O%LSURF_BUDGET) THEN
  !
  YRECFM='TALB_ISBA'
  YCOMMENT='total albedo over tile nature (-)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,ID%D%XALBT(:),IRESP,HCOMMENT=YCOMMENT)
  !  
  YRECFM='RN_ISBA'
  YCOMMENT='Net radiation over tile nature'//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XRN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_ISBA'
  YCOMMENT='Sensible heat flux over tile nature'//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_ISBA'
  YCOMMENT='total latent heat flux over tile nature'//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XLE(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LEI_ISBA'
  YCOMMENT='sublimation latent heat flux over tile nature'//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XLEI(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_ISBA'
  YCOMMENT='Ground flux over tile nature'//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='EVAP_ISBA'
  YCOMMENT='total evaporative flux for tile nature'//' (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,ID%D%XEVAP(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SUBL_ISBA'
  YCOMMENT='sublimation flux for tile nature'//' (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,ID%D%XSUBL(:),IRESP,HCOMMENT=YCOMMENT)
  ! 
  IF (ID%O%LRAD_BUDGET  .OR. (ID%O%LSURF_BUDGETC .AND. .NOT.DUO%LRESET_BUDGETC)) THEN
    !
    YRECFM='SWD_ISBA'
    YCOMMENT='short wave downward radiation over tile nature'//' (W/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XSWD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWU_ISBA'
    YCOMMENT='short wave upward radiation over tile nature'//' (W/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XSWU(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWD_ISBA'
    YCOMMENT='long wave downward radiation over tile nature'//' (W/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XLWD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWU_ISBA'
    YCOMMENT='long wave upward radiation over tile nature'//' (W/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XLWU(:),IRESP,HCOMMENT=YCOMMENT)
    !    
    IF (LALLOW_ADD_DIM)  THEN
      !
      YRECFM='SWD_ISBA_'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
      CALL WRITE_SURF(DUO%CSELECT,&
           HPROGRAM,YRECFM,ID%D%XSWBD(:,:),IRESP,HCOMMENT=YCOMMENT, HNAM_DIM=YSWBAND_DIM_NAME)
      !
      YRECFM='SWU_ISBA_'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
      CALL WRITE_SURF(DUO%CSELECT,&
           HPROGRAM,YRECFM,ID%D%XSWBU(:,:),IRESP,HCOMMENT=YCOMMENT, HNAM_DIM=YSWBAND_DIM_NAME)
      !
    ELSE
      !
      DO JSW=1, SIZE(ID%D%XSWBD,2)
        YNUM=ACHAR(48+JSW)
        !
        YRECFM='SWD_ISBA_'//YNUM
        YCOMMENT='short wave downward radiation over tile nature for spectral band'//YNUM//' (W/m2)'
        CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XSWBD(:,JSW),IRESP,HCOMMENT=YCOMMENT)
        !
        YRECFM='SWU_ISBA_'//YNUM
        YCOMMENT='short wave upward radiation over tile nature for spectral band'//YNUM//' (W/m2)'
        CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XSWBU(:,JSW),IRESP,HCOMMENT=YCOMMENT)
        !
      ENDDO
      !
    ENDIF
    !
  ENDIF
  !
  YRECFM='FMU_ISBA'
  YCOMMENT='u component of wind stress'//' (Pa)'  
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XFMU(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FMV_ISBA'
  YCOMMENT='v component of wind stress'//' (Pa)'  
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XFMV(:),IRESP,HCOMMENT=YCOMMENT)
  !
END IF
!
!*       4.    Specific Energy fluxes :(for each patch)
!              ----------------------------------------
!
IF (ID%DE%LSURF_EVAP_BUDGET) CALL WRITE_EVAP_BUD(ID%DE,"_ISBA ",.FALSE.)
!
!*       6.     parameters at 2 and 10 meters :
!               -------------------------------
!
IF (ID%O%N2M>=1) THEN
  !
  YRECFM='T2M_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XT2M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='T2MMIN_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XT2M_MIN(:),IRESP,HCOMMENT=YCOMMENT)
  IF(GRESET)ID%D%XT2M_MIN(:)=XUNDEF
  !
  YRECFM='T2MMAX_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XT2M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
  IF(GRESET)ID%D%XT2M_MAX(:)=-XUNDEF
  !
  YRECFM='Q2M_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XQ2M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='HU2M_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XHU2M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='HU2MMIN_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XHU2M_MIN(:),IRESP,HCOMMENT=YCOMMENT)
  IF(GRESET)ID%D%XHU2M_MIN(:)=XUNDEF
  !
  YRECFM='HU2MMAX_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XHU2M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
  IF(GRESET)ID%D%XHU2M_MAX(:)=-XUNDEF
  !
  YRECFM='ZON10M_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (M/S)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XZON10M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='MER10M_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (M/S)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XMER10M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='W10M_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (M/S)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XWIND10M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='W10MMAX_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (M/S)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XWIND10M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
  IF(GRESET)ID%D%XWIND10M_MAX(:)=0.0
  !
  YRECFM='SFCO2_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (M.kgCO2.S-1.kgAIR-1)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XSFCO2(:),IRESP,HCOMMENT=YCOMMENT)
  !  
END IF
!----------------------------------------------------------------------------
!
!*       7.     Transfer coefficients
!               ---------------------
!
IF (ID%O%LCOEF) THEN
  !
  YRECFM='CD_ISBA'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XCD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='CH_ISBA'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XCH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='CE_ISBA'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XCE(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='Z0_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (M)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XZ0(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='Z0H_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (M)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XZ0H(:),IRESP,HCOMMENT=YCOMMENT)
  !
ENDIF
!
!----------------------------------------------------------------------------
!
!*       8.     Surface humidity
!               ----------------
IF (ID%O%LSURF_VARS) THEN
  !
  YRECFM='QS_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%D%XQS(:),IRESP,HCOMMENT=YCOMMENT)
  !
ENDIF
!
!----------------------------------------------------------------------------
!
ISIZE = U%NSIZE_NATURE
!
!User want (or not) patch output
IF (ID%O%LPATCH_BUDGET.AND.(IO%NPATCH >1)) THEN
  !
  !*      10.     Richardson number (for each patch)
  !               -----------------
  !
  IF (ID%O%N2M>=1) THEN
    !  
    YRECFM='RI_'
    YCOMMENT='X_Y_'//YRECFM      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XRI(:),ISIZE,S%XWORK_WR)
    ENDDO
    !
  END IF
  !
  !*       11.     Energy fluxes :(for each patch)
  !                -------------
  !
  IF (ID%O%LSURF_BUDGET) THEN
    !
    YRECFM='TALB_'
    YCOMMENT='total albedo per patch'
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XALBT(:),ISIZE,S%XWORK_WR)
    ENDDO      
    !
    YRECFM='RN_'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XRN(:),ISIZE,S%XWORK_WR)
    ENDDO      
    !
    YRECFM='H_'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
            NP%AL(JP)%NR_P,ID%ND%AL(JP)%XH(:),ISIZE,S%XWORK_WR)
    ENDDO      
    !
    YRECFM='LE_'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    DO JP = 1,IO%NPATCH
      CALL  WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,NPE%AL(JP)%XLE(:),ISIZE,S%XWORK_WR)  
    ENDDO      
    !
    YRECFM='LEI_'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XLEI(:),ISIZE,S%XWORK_WR)
    ENDDO  
    !
    YRECFM='GFLUX_'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XGFLUX(:),ISIZE,S%XWORK_WR)
    ENDDO   
    !
    YRECFM='EVAP_'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XEVAP(:),ISIZE,S%XWORK_WR)
    ENDDO    
    !
    YRECFM='SUBL_'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XSUBL(:),ISIZE,S%XWORK_WR)
    ENDDO   
    !     
    IF (ID%O%LRAD_BUDGET .OR. (ID%O%LSURF_BUDGETC .AND. .NOT.DUO%LRESET_BUDGETC)) THEN
      !
      YRECFM='SWD_'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'        
      DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%ND%AL(JP)%XSWD(:),ISIZE,S%XWORK_WR)
      ENDDO       
      !
      YRECFM='SWU_'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'        
      DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%ND%AL(JP)%XSWU(:),ISIZE,S%XWORK_WR)
      ENDDO
      !
      YRECFM='LWD_'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'        
      DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%ND%AL(JP)%XLWD(:),ISIZE,S%XWORK_WR)
      ENDDO  
      !
      YRECFM='LWU_'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'        
      DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%ND%AL(JP)%XLWU(:),ISIZE,S%XWORK_WR)
      ENDDO
      !
      DO JSW=1, SIZE(ID%D%XSWBD,2)
        YNUM=ACHAR(48+JSW)
        !
        YRECFM='SWD_'//YNUM
        YCOMMENT='X_Y_'//YRECFM//' (W/m2)'          
        DO JP=1,IO%NPATCH
          CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XSWD(:),ISIZE,S%XWORK_WR)
        ENDDO
        !
        YRECFM='SWU_'//YNUM
        YCOMMENT='X_Y_'//YRECFM//' (W/m2)'          
        DO JP=1,IO%NPATCH
          CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XSWU(:),ISIZE,S%XWORK_WR)
        ENDDO
        !
      ENDDO
      !
    ENDIF
    !
    YRECFM='FMU_'
    YCOMMENT='X_Y_'//YRECFM//' (Pa)'      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XFMU(:),ISIZE,S%XWORK_WR)
    ENDDO
    !
    YRECFM='FMV_'
    YCOMMENT='X_Y_'//YRECFM//' (Pa)'      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XFMV(:),ISIZE,S%XWORK_WR)
    ENDDO
    !
  END IF
  !
  !*       12.    Specific Energy fluxes :(for each patch)
  !               ----------------------------------------
  !
  IF (ID%DE%LSURF_EVAP_BUDGET) CALL WRITE_EVAP_BUD_PATCH(ID%NDE,'_ ',.FALSE.)
  !
  !*       13.    surface temperature parameters at 2 and 10 meters (for each patch):
  !               -------------------------------------------------------------------
  !
  IF (ID%O%N2M>=1.AND..NOT.IO%LCANOPY) THEN
    !
    YRECFM='T2M_'
    YCOMMENT='X_Y_'//YRECFM//' (K)'      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XT2M(:),ISIZE,S%XWORK_WR)
    ENDDO
    !
    YRECFM='T2MMIN_'
    YCOMMENT='X_Y_'//YRECFM//' (K)' 
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XT2M_MIN(:),ISIZE,S%XWORK_WR)
      IF (GRESET) ID%ND%AL(JP)%XT2M_MIN(:)=XUNDEF        
    ENDDO        
    !      
    YRECFM='T2MMAX_'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XT2M_MAX(:),ISIZE,S%XWORK_WR)
      IF (GRESET) ID%ND%AL(JP)%XT2M_MAX(:)=-XUNDEF        
    ENDDO
    ! 
    YRECFM='Q2M_'
    YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XQ2M(:),ISIZE,S%XWORK_WR)
    ENDDO
    !
    YRECFM='HU2M_'
    YCOMMENT='X_Y_'//YRECFM//' (PERCENT)'      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XHU2M(:),ISIZE,S%XWORK_WR)
    ENDDO
    !
    YRECFM='ZON10M_'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'      
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XZON10M(:),ISIZE,S%XWORK_WR)
    ENDDO
    !
    YRECFM='MER10M_'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XMER10M(:),ISIZE,S%XWORK_WR)
    ENDDO
    !    
    YRECFM='W10M_'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'
    DO JP=1,IO%NPATCH
      CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
              NP%AL(JP)%NR_P,ID%ND%AL(JP)%XWIND10M(:),ISIZE,S%XWORK_WR)
    ENDDO
    !
  END IF
  !
ENDIF
!
!----------------------------------------------------------------------------
!
!*       9.     Diag of prognostic fields
!               -------------------------
!
IF (DUO%LPROVAR_TO_DIAG) CALL PROVAR_TO_DIAG
!
!----------------------------------------------------------------------------
!
!*       15.     chemical diagnostics:
!               --------------------
!
IF (CHI%SVI%NBEQ>0 .AND. CHI%CCH_DRY_DEP=="WES89 ") THEN
  !
  DO JSV = 1,SIZE(CHI%CCH_NAMES,1)
    YRECFM='DVNT'//TRIM(CHI%CCH_NAMES(JSV))
    WRITE(YCOMMENT,'(A13,I3.3)')'(m/s) DV_NAT_',JSV
    DO JP = 1,IO%NPATCH
      CALL  WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                                 NP%AL(JP)%NR_P,NCHI%AL(JP)%XDEP(:,JSV),ISIZE,S%XWORK_WR)
    ENDDO
  END DO
  !
ENDIF
!
IF (CHI%SVI%NBEQ>0 .AND. CHI%LCH_BIO_FLUX) THEN
  !
  IF (ASSOCIATED(GB%XFISO)) THEN
    YRECFM='FISO'
    WRITE(YCOMMENT,'(A21)')'FISO (molecules/m2/s)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,GB%XFISO(:),IRESP,HCOMMENT=YCOMMENT)
  END IF
  !
  IF (ASSOCIATED(GB%XFISO)) THEN
    YRECFM='FMONO'
    WRITE(YCOMMENT,'(A22)')'FMONO (molecules/m2/s)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,GB%XFMONO(:),IRESP,HCOMMENT=YCOMMENT)
  END IF
  !
ENDIF
!
IF (CHI%LCH_NO_FLUX) THEN
  IF (ASSOCIATED(GB%XNOFLUX)) THEN
    YRECFM='NOFLUX'
    WRITE(YCOMMENT,'(A21)')'NOFLUX (molecules/m2/s)'
    CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,GB%XNOFLUX(:),IRESP,HCOMMENT=YCOMMENT)
  END IF
END IF
!
IF (CHI%SVI%NDSTEQ > 0)THEN
  !
  DO JSV = 1,NDSTMDE ! for all dust modes
    WRITE(YRECFM,'(A5,I3.3)')'F_DST',JSV
    YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
    DO JP = 1,IO%NPATCH
      CALL  WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                                 NP%AL(JP)%NR_P,NDST%AL(JP)%XSFDST(:,JSV),ISIZE,S%XWORK_WR)
    ENDDO    
  END DO
  !
ENDIF
!
!----------------------------------------------------------------------------
!
!*       5.    Cumulated Energy fluxes
!              -----------------------
!
 CALL END_IO_SURF_n(HPROGRAM)
 CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'NATURE','ISBA  ','WRITE','ISBA_DIAG_CUMUL.OUT.nc')
!
IF (ID%O%LSURF_BUDGETC) THEN
  !
  CALL WRITE_EVAP_BUD(ID%DEC,"C_ISBA",(ID%O%LSURF_BUDGETC .AND. .NOT.DUO%LRESET_BUDGETC))
  !
  IF(IO%LGLACIER)THEN
    YRECFM='ICE_FC_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (Kg/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DEC%XICEFLUX(:),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
  !  
  YRECFM='RNC_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XRN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='HC_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LEC_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XLE(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LEIC_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XLEI(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUXC_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='EVAPC_ISBA'
  YCOMMENT='total evaporative flux for tile nature'//' (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,ID%DC%XEVAP(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SUBLC_ISBA'
  YCOMMENT='sublimation flux for tile nature'//' (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,ID%DC%XSUBL(:),IRESP,HCOMMENT=YCOMMENT)
  !  
  IF (ID%O%LRAD_BUDGET .OR. (ID%O%LSURF_BUDGETC .AND. .NOT.DUO%LRESET_BUDGETC)) THEN
    !
    YRECFM='SWDC_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XSWD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWUC_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XSWU(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWDC_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XLWD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWUC_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XLWU(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  YRECFM='FMUC_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (Pa.s)'  
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XFMU(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FMVC_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (Pa.s)'  
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ID%DC%XFMV(:),IRESP,HCOMMENT=YCOMMENT)
  !
ENDIF
!
!----------------------------------------------------------------------------
!
!User want (or not) patch output
IF (ID%O%LPATCH_BUDGET.AND.(IO%NPATCH >1)) THEN
    !
    !*       14.    Cumulated Energy fluxes :(for each patch)
    !               -----------------------------------------
    !
    IF (ID%O%LSURF_BUDGETC) THEN
      !
      CALL WRITE_EVAP_BUD_PATCH(ID%NDEC,'C_',(ID%O%LSURF_BUDGETC .AND. .NOT.DUO%LRESET_BUDGETC))
      !  
      IF(IO%LGLACIER)THEN              
        YRECFM='ICE_FC_'
        YCOMMENT='X_Y_'//YRECFM//' (Kg/m2)'
        DO JP=1,IO%NPATCH
          CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDEC%AL(JP)%XICEFLUX(:),ISIZE,S%XWORK_WR)
        ENDDO
      ENDIF
      !      
      YRECFM='RNC_'
      YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
      DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XRN(:),ISIZE,S%XWORK_WR)
      ENDDO
      !     
      YRECFM='HC_'
      YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
      DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XH(:),ISIZE,S%XWORK_WR)
      ENDDO
      ! 
      YRECFM='LEC_'
      YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
      DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XLE(:),ISIZE,S%XWORK_WR)
      ENDDO
      !   
      YRECFM='LEIC_'
      YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
      DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XLEI(:),ISIZE,S%XWORK_WR)
      ENDDO
      !
      YRECFM='GFLUXC_'
      YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
      DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XGFLUX(:),ISIZE,S%XWORK_WR)
      ENDDO
      !     
      YRECFM='EVAPC_'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
      DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XEVAP(:),ISIZE,S%XWORK_WR)
      ENDDO
      !    
      YRECFM='SUBLC_'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
      DO JP=1,IO%NPATCH
        CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XSUBL(:),ISIZE,S%XWORK_WR)
      ENDDO      
      !    
      IF (ID%O%LRAD_BUDGET .OR. (ID%O%LSURF_BUDGETC .AND. .NOT.DUO%LRESET_BUDGETC)) THEN
        !
        YRECFM='SWDC_'
        YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
        DO JP=1,IO%NPATCH
          CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XSWD(:),ISIZE,S%XWORK_WR)
        ENDDO
        !      
        YRECFM='SWUC_'
        YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
        DO JP=1,IO%NPATCH
          CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XSWU(:),ISIZE,S%XWORK_WR)
        ENDDO
        !     
        YRECFM='LWDC_'
        YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
        DO JP=1,IO%NPATCH
          CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XLWD(:),ISIZE,S%XWORK_WR)
        ENDDO
        !     
        YRECFM='LWUC_'
        YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
        DO JP=1,IO%NPATCH
          CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XLWU(:),ISIZE,S%XWORK_WR)
        ENDDO
        !
      ENDIF
      ! 
      YRECFM='FMUC_'
      YCOMMENT='X_Y_'//YRECFM//' (Pa.s)'   
      DO JP=1,IO%NPATCH
          CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XFMU(:),ISIZE,S%XWORK_WR)
      ENDDO
      ! 
      YRECFM='FMVC_'
      YCOMMENT='X_Y_'//YRECFM//' (Pa.s)'
       DO JP=1,IO%NPATCH
          CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
                NP%AL(JP)%NR_P,ID%NDC%AL(JP)%XFMV(:),ISIZE,S%XWORK_WR)
      ENDDO
      !
    ENDIF
    !
    !-------------------------------------------------------------------------------
ENDIF
!
!         End of IO
!
 CALL END_IO_SURF_n(HPROGRAM)
!
!-------------------------------------------------------------------------------
!
!User want (or not) patch output
!-------------------------------------------------------------------------------
!
IF ( DUO%LRESETCUMUL .AND. ID%O%LSURF_BUDGETC ) THEN
  !
  DO JP = 1,IO%NPATCH
    CALL INIT_SURF_BUD(ID%NDC%AL(JP),0.)
  ENDDO
  !  
  IF (ID%DE%LSURF_EVAP_BUDGET) THEN
    DO JP = 1,IO%NPATCH
      CALL INIT_EVAP_BUD(ID%NDEC%AL(JP))
    ENDDO
    !
    IF (ID%DE%LWATER_BUDGET) THEN
      DO JP = 1,IO%NPATCH
        CALL INIT_WATER_BUD(ID%NDEC%AL(JP))
      ENDDO
    ENDIF
  ENDIF
  !
END IF
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_ISBA_N',1,ZHOOK_HANDLE)
!
CONTAINS
!
!-------------------------------------------------------------------------------
!
SUBROUTINE WRITE_EVAP_BUD(DEA,HTERM,OFLAG)
!
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
!
TYPE(DIAG_EVAP_ISBA_t) :: DEA
 CHARACTER(LEN=6), INTENT(IN) :: HTERM
LOGICAL, INTENT(IN) :: OFLAG
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_ISBA_N:WRITE_EVAP_BUD',0,ZHOOK_HANDLE)
!
YRECFM='LEG'//TRIM(HTERM)
YCOMMENT='bare ground evaporation for tile nature'//' (W/m2)'
CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLEG(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LEGI'//TRIM(HTERM)
YCOMMENT='bare ground sublimation for tile nature'//' (W/m2)'
CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLEGI(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LEV'//TRIM(HTERM)
YCOMMENT='total vegetation evaporation for tile nature'//' (W/m2)'
CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLEV(:),IRESP,HCOMMENT=YCOMMENT)
  !
YRECFM='LES'//TRIM(HTERM)
YCOMMENT='snow sublimation for tile nature'//' (W/m2)'  
CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLES(:),IRESP,HCOMMENT=YCOMMENT)
  !
IF(NPE%AL(1)%TSNOW%SCHEME=='3-L' .OR. NPE%AL(1)%TSNOW%SCHEME=='CRO')THEN  
  YRECFM='LESL'//TRIM(HTERM)
  YCOMMENT='liquid water evaporation over snow for tile nature'//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLESL(:),IRESP,HCOMMENT=YCOMMENT)
  YRECFM='SNDRIF'//TRIM(HTERM)
  YCOMMENT='blowing snow sublimation for tile nature'//' (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XSNDRIFT(:),IRESP,HCOMMENT=YCOMMENT)    
ENDIF
  !  
YRECFM='LER'//TRIM(HTERM)
YCOMMENT='canopy direct evaporation for tile nature'//' (W/m2)'
CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLER(:),IRESP,HCOMMENT=YCOMMENT)
  !
YRECFM='LETR'//TRIM(HTERM)
YCOMMENT='vegetation transpiration for tile nature'//' (W/m2)'
CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLETR(:),IRESP,HCOMMENT=YCOMMENT)
  !
YRECFM='DRAIN'//TRIM(HTERM)
YCOMMENT='drainage for tile nature'//' (Kg/m2/s)'
CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XDRAIN(:),IRESP,HCOMMENT=YCOMMENT)
  !
IF(IO%CRUNOFF=='SGH'.AND.IO%CISBA=='DIF')THEN
  YRECFM='QSB'//TRIM(HTERM)
  YCOMMENT='lateral subsurface flow for tile nature'//' (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XQSB(:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
  !
YRECFM='RUNOFF'//TRIM(HTERM)
YCOMMENT='runoff for tile nature'//' (Kg/m2/s)'
CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XRUNOFF(:),IRESP,HCOMMENT=YCOMMENT)
  !
IF(IO%CHORT=='SGH'.OR.IO%CISBA=='DIF')THEN
  YRECFM='HORTON'//TRIM(HTERM)
  YCOMMENT='horton runoff for tile nature'//' (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XHORT(:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
  !
YRECFM='DRIVEG'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XDRIP(:),IRESP,HCOMMENT=YCOMMENT)
  !
YRECFM='RRVEG'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
CALL WRITE_SURF(DUO%CSELECT, &
                  HPROGRAM,YRECFM,DEA%XRRVEG(:),IRESP,HCOMMENT=YCOMMENT)
  !
YRECFM='SNOMLT'//TRIM(HTERM)
YCOMMENT='snow melting rate'//' (Kg/m2/s)'
CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XMELT(:),IRESP,HCOMMENT=YCOMMENT)
  !
IF(LAGRIP)THEN
  YRECFM='IRRIG'//TRIM(HTERM)
  YCOMMENT='irrigation rate'//' (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XIRRIG_FLUX(:),IRESP,HCOMMENT=YCOMMENT)
ENDIF  
! MEB STUFF
IF (ISIZE_LMEB_PATCH>0) THEN
  YRECFM='LELIT'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLELITTER(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LELITI'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLELITTERI(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='DRIPLIT'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XDRIPLIT(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='RRLIT'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XRRLIT(:),IRESP,HCOMMENT=YCOMMENT)
    !        
  YRECFM='LEV_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLEV_CV(:),IRESP,HCOMMENT=YCOMMENT)  
    !
  YRECFM='LES_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLES_CV(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LETR_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLETR_CV(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LER_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLER_CV(:),IRESP,HCOMMENT=YCOMMENT)
    !    
   YRECFM='LE_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLE_CV(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='H_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XH_CV(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='MELT_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XMELT_CV(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='FRZ_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XFRZ_CV(:),IRESP,HCOMMENT=YCOMMENT)
    !  
  YRECFM='LETR_GV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLETR_GV(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LER_GV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLER_GV(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LE_GV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLE_GV(:),IRESP,HCOMMENT=YCOMMENT)  
    !
  YRECFM='H_GV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XH_GV(:),IRESP,HCOMMENT=YCOMMENT)  
    !
  YRECFM='LE_GN'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLE_GN(:),IRESP,HCOMMENT=YCOMMENT)  
    !
  YRECFM='H_GN'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XH_GN(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='SR_GN'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XSR_GN(:),IRESP,HCOMMENT=YCOMMENT)  
    !
  YRECFM='SWDN_GN'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XSWDOWN_GN(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LWDN_GN'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLWDOWN_GN(:),IRESP,HCOMMENT=YCOMMENT)  
    !
  YRECFM='LE_CA'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLE_CA(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='H_CA'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XH_CA(:),IRESP,HCOMMENT=YCOMMENT)  
    !
  YRECFM='SWNT_V'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XSWNET_V(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='SWNT_G'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XSWNET_G(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='SWNT_N'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XSWNET_N(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='SWNT_NS'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XSWNET_NS(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LWNT_V'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLWNET_V(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LWNT_G'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLWNET_G(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LWNT_N'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLWNET_N(:),IRESP,HCOMMENT=YCOMMENT)
    !
ENDIF
  ! END MEB STUFF
  !
IF(IO%LFLOOD)THEN
  !        
  YRECFM='IFLOOD'//TRIM(HTERM)
  YCOMMENT='flood soil infiltration (Kg/m2/s)'    
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XIFLOOD(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='PFLOOD'//TRIM(HTERM)
  YCOMMENT='intercepted precipitation by floodplains (Kg/m2/s)'    
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XPFLOOD(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LEF'//TRIM(HTERM)
  YCOMMENT='total floodplains evaporation (W/m2)'   
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLE_FLOOD(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='LEIF'//TRIM(HTERM)
  YCOMMENT='solid floodplains evaporation (W/m2)'    
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XLEI_FLOOD(:),IRESP,HCOMMENT=YCOMMENT)
    !
ENDIF
  !
IF(IO%CPHOTO/='NON')THEN
    !
  YRECFM='GPP'//TRIM(HTERM)
  YCOMMENT='gross primary production over tile nature (kgCO2/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XGPP(:),IRESP,HCOMMENT=YCOMMENT)
    !
  IF (HTERM(1:1)=="C") THEN
    YRECFM='RC_AUTO'//TRIM(HTERM(2:))
  ELSE
    YRECFM='R_AUTO'//TRIM(HTERM)
  ENDIF      
  YCOMMENT='autotrophic respiration over tile nature (kgCO2/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XRESP_AUTO(:),IRESP,HCOMMENT=YCOMMENT)
    !
  IF (HTERM(1:1)=="C") THEN
    YRECFM='RC_ECO'//TRIM(HTERM(2:))
  ELSE
    YRECFM='R_ECO'//TRIM(HTERM)
  ENDIF      
  YCOMMENT='ecosystem respiration over tile nature (kgCO2/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XRESP_ECO(:),IRESP,HCOMMENT=YCOMMENT)
    !
ENDIF
!  
IF(ID%DE%LWATER_BUDGET .OR. OFLAG)THEN 
    !
  YRECFM='RAINF'//TRIM(HTERM)
  YCOMMENT='input rainfall rate (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XRAINFALL(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='SNOWF'//TRIM(HTERM)
  YCOMMENT='input snowfall rate (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XSNOWFALL(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='DWG'//TRIM(HTERM)
  YCOMMENT='change in liquid soil moisture (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XDWG(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='DWGI'//TRIM(HTERM)
  YCOMMENT='change in solid soil moisture (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XDWGI(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='DWR'//TRIM(HTERM)
  YCOMMENT='change in water on canopy (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XDWR(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='DSWE'//TRIM(HTERM)
  YCOMMENT='change in snow water equivalent (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XDSWE(:),IRESP,HCOMMENT=YCOMMENT)
    !
  YRECFM='WATBUD'//TRIM(HTERM)
  YCOMMENT='isba water budget as residue (Kg/m2/s)'
  CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,DEA%XWATBUD(:),IRESP,HCOMMENT=YCOMMENT)
    !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_ISBA_N:WRITE_EVAP_BUD',1,ZHOOK_HANDLE)

!
END SUBROUTINE WRITE_EVAP_BUD
!
SUBROUTINE WRITE_EVAP_BUD_PATCH(NDEA,HTERM,OFLAG)
!
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_NP_t
!
TYPE(DIAG_EVAP_ISBA_NP_t) :: NDEA
 CHARACTER(LEN=2), INTENT(IN) :: HTERM
LOGICAL, INTENT(IN) :: OFLAG
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_ISBA_N:WRITE_EVAP_BUD_PATCH',0,ZHOOK_HANDLE)
!
YRECFM='LEG'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLEG(:),ISIZE,S%XWORK_WR)
ENDDO
!
YRECFM='LEGI'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLEGI(:),ISIZE,S%XWORK_WR)
ENDDO
!
YRECFM='LEV'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLEV(:),ISIZE,S%XWORK_WR)
ENDDO
!
 
YRECFM='LES'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLES(:),ISIZE,S%XWORK_WR)
ENDDO
!
IF(NPE%AL(1)%TSNOW%SCHEME=='3-L' .OR. NPE%AL(1)%TSNOW%SCHEME=='CRO')THEN 
  YRECFM='LESL'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLESL(:),ISIZE,S%XWORK_WR)
ENDDO
  YRECFM='SNDRIF'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
  DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XSNDRIFT(:),ISIZE,S%XWORK_WR)
ENDDO
ENDIF
! 
YRECFM='LER'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLER(:),ISIZE,S%XWORK_WR)
ENDDO
!
YRECFM='LETR'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLETR(:),ISIZE,S%XWORK_WR)
ENDDO
!
YRECFM='DRAIN'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XDRAIN(:),ISIZE,S%XWORK_WR)
ENDDO
!
IF(IO%CRUNOFF=='SGH'.AND.IO%CISBA=='DIF')THEN
  YRECFM='QSB'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
          NP%AL(JP)%NR_P,NDEA%AL(JP)%XQSB(:),ISIZE,S%XWORK_WR)
  ENDDO  
ENDIF
!
YRECFM='RUNOFF'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XRUNOFF(:),ISIZE,S%XWORK_WR)
ENDDO
!
IF(IO%CHORT=='SGH'.OR.IO%CISBA=='DIF')THEN
 
  YRECFM='HORTON'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
  DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XHORT(:),ISIZE,S%XWORK_WR)
  ENDDO

ENDIF
!
YRECFM='DRIVEG'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XDRIP(:),ISIZE,S%XWORK_WR)
ENDDO
!
YRECFM='RRVEG'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XRRVEG(:),ISIZE,S%XWORK_WR)
ENDDO
!
YRECFM='SNOMLT'//TRIM(HTERM)
YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XMELT(:),ISIZE,S%XWORK_WR)
ENDDO
!
! MEB STUFF
IF (ISIZE_LMEB_PATCH>0) THEN
  !
  YRECFM='LELIT'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLELITTER(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='LELITI'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLELITTERI(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='DRIPLIT'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XDRIPLIT(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='RRLIT'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XRRLIT(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='LEV_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLEV_CV(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='LES_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLES_CV(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='LETR_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLETR_CV(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='LER_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLER_CV(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='LE_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLE_CV(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='H_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XH_CV(:),ISIZE,S%XWORK_WR)
  ENDDO  
  !
  YRECFM='MELT_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XMELT_CV(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='FRZ_CV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XFRZ_CV(:),ISIZE,S%XWORK_WR)
  ENDDO  
  !
  YRECFM='LE_GV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLE_GV(:),ISIZE,S%XWORK_WR)
  ENDDO  
  !
  YRECFM='H_GV'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XH_GV(:),ISIZE,S%XWORK_WR)
  ENDDO  
  !
  YRECFM='LE_GN'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLE_GN(:),ISIZE,S%XWORK_WR)
  ENDDO 
  !
  YRECFM='H_GN'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XH_GN(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='SR_GN'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XSR_GN(:),ISIZE,S%XWORK_WR)
  ENDDO  
  !
  YRECFM='SWDN_GN'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XSWDOWN_GN(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='LWDN_GN'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLWDOWN_GN(:),ISIZE,S%XWORK_WR)
  ENDDO  
  !
  YRECFM='LE_CA'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLE_CA(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='H_CA'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XH_CA(:),ISIZE,S%XWORK_WR)
  ENDDO  
  !
  YRECFM='SWNT_V'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XSWNET_V(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='SWNT_G'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XSWNET_G(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='SWNT_N'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XSWNET_N(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='SWNT_NS'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XSWNET_NS(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='LWNT_V'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLWNET_V(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='LWNT_G'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLWNET_G(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='LWNT_N'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLWNET_N(:),ISIZE,S%XWORK_WR)
  ENDDO

ENDIF
! END MEB STUFF
!
IF(LAGRIP)THEN
  YRECFM='IRRIG'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XIRRIG_FLUX(:),ISIZE,S%XWORK_WR)
  ENDDO
ENDIF
!
IF(IO%LFLOOD)THEN
  !
  YRECFM='IFLOOD'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XIFLOOD(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='PFLOOD'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (Kg/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XPFLOOD(:),ISIZE,S%XWORK_WR)
  ENDDO
  !

  YRECFM='LEF'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
  CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLE_FLOOD(:),ISIZE,S%XWORK_WR)
ENDDO
  !

  YRECFM='LEIF'//TRIM(HTERM)
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XLEI_FLOOD(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
ENDIF
!
IF(IO%CPHOTO/='NON')THEN
  !
 
  YRECFM='GPP'//TRIM(HTERM)
  YCOMMENT='gross primary production per patch (kgCO2/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XGPP(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  IF (HTERM(1:1)=="C") THEN
    YRECFM='RC_AUTO'//TRIM(HTERM(2:))
  ELSE
    YRECFM='R_AUTO'//TRIM(HTERM)
  ENDIF
  YCOMMENT='autotrophic respiration per patch (kgCO2/m2/s)'
    DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XRESP_AUTO(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  IF (HTERM(1:1)=="C") THEN
    YRECFM='RC_ECO'//TRIM(HTERM(2:))
  ELSE
    YRECFM='R_ECO'//TRIM(HTERM)
  ENDIF  
  YCOMMENT='ecosystem respiration per patch (kgCO2/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XRESP_ECO(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
ENDIF
!
IF(ID%DE%LWATER_BUDGET .OR. OFLAG)THEN 
  !
  YRECFM='DWG'//TRIM(HTERM)
  YCOMMENT='change in liquid soil moisture per patch (Kg/m2/s)'
    DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XDWG(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='DWGI'//TRIM(HTERM)
  YCOMMENT='change in solid soil moisture per patch (Kg/m2/s)'
    DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XDWGI(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='DWR'//TRIM(HTERM)
  YCOMMENT='change in water on canopy per patch (Kg/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XDWR(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='DSWE'//TRIM(HTERM)
  YCOMMENT='change in snow water equivalent per patch (Kg/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XDSWE(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
  YRECFM='WATBUD'//TRIM(HTERM)
  YCOMMENT='isba water budget as residue per patch (Kg/m2/s)'
  DO JP=1,IO%NPATCH
    CALL WRITE_FIELD_1D_PATCH(DUO%CSELECT,HPROGRAM,YRECFM,YCOMMENT,JP,&
        NP%AL(JP)%NR_P,NDEA%AL(JP)%XWATBUD(:),ISIZE,S%XWORK_WR)
  ENDDO
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_ISBA_N:WRITE_EVAP_BUD_PATCH',1,ZHOOK_HANDLE)
!
END SUBROUTINE WRITE_EVAP_BUD_PATCH
!
!
SUBROUTINE PROVAR_TO_DIAG
!
REAL, DIMENSION(U%NSIZE_NATURE)             :: ZPATCH, ZWORK
REAL, DIMENSION(U%NSIZE_NATURE,SIZE(NPE%AL(1)%XWG,2)) :: ZWG
REAL, DIMENSION(U%NSIZE_NATURE,SIZE(NPE%AL(1)%XWG,2)) :: ZWGI
REAL, DIMENSION(U%NSIZE_NATURE,SIZE(NPE%AL(1)%XTG,2)) :: ZTG
REAL, DIMENSION(U%NSIZE_NATURE,SIZE(NP%AL(1)%XDG,2)) :: ZDG_TOT
REAL, DIMENSION(U%NSIZE_NATURE,SIZE(NP%AL(1)%XDG,2)) :: ZDG
!
REAL, DIMENSION(U%NSIZE_NATURE,IO%NNBIOMASS)   :: ZBIOMASS
REAL, DIMENSION(U%NSIZE_NATURE,IO%NNSOILCARB)  :: ZSOILCARB
REAL, DIMENSION(U%NSIZE_NATURE,IO%NNLITTLEVS)  :: ZLIGNIN_STRUC
REAL, DIMENSION(U%NSIZE_NATURE,IO%NNLITTER,IO%NNLITTLEVS)  :: ZLITTER
!
CHARACTER(LEN=4 ) :: YLVL
REAL              :: ZMISS
INTEGER           :: JL, JP, JJ, INI, IWORK, IDEPTH, IMASK
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_ISBA_N:PROVAR_TO_DIAG',0,ZHOOK_HANDLE)
!
INI=U%NSIZE_NATURE
!
! * soil temperatures (K)
!
IF(IO%LTEMP_ARP)THEN
  IWORK=IO%NTEMPLAYER_ARP
ELSEIF(IO%CISBA/='DIF')THEN
  IWORK=2
ELSE
  IWORK=IO%NGROUND_LAYER
ENDIF
!
ZTG(:,:)=0.0
DO JP=1,IO%NPATCH
  PK => NP%AL(JP)
  PEK => NPE%AL(JP)
  DO JL=1,IWORK
    DO JJ=1,PK%NSIZE_P
      IMASK = PK%NR_P(JJ)
      ZTG(IMASK,JL) = ZTG(IMASK,JL) + PK%XPATCH(JJ) * PEK%XTG(JJ,JL)
      ENDDO
   ENDDO
ENDDO
!
IF (LALLOW_ADD_DIM)  THEN 
  YRECFM='TG_ISBA' ; 
  YCOMMENT='Soil temperature (K)'
  CALL WRITE_SURF(DUO%CSELECT, &
                  HPROGRAM,YRECFM,ZTG(:,:),IRESP,YCOMMENT,HNAM_DIM=YGROUND_LAYER_DIM_NAME)
ELSE
  DO JL=1,IWORK
    WRITE(YLVL,'(I4)') JL
    YRECFM='TG'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
    YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZTG(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
! * Compute soil liquid and ice water content (kg/m2 and m3/m3) 
!
ZWG (:,:)=0.0
ZWGI(:,:)=0.0
ZDG_TOT(:,:)=0.0
!
IF(IO%CISBA=='DIF')THEN
  !
  DO JP=1,IO%NPATCH
    PK => NP%AL(JP)
    PEK => NPE%AL(JP)

    DO JJ=1,PK%NSIZE_P
      IMASK = PK%NR_P(JJ)
      DO JL=1,IO%NGROUND_LAYER
!
!       liquid and ice water content
        IDEPTH= PK%NWG_LAYER(JJ)
        IF(JL<=IDEPTH)THEN    
          ZWG(IMASK,JL) = ZWG (IMASK,JL)+ PK%XPATCH(JJ) * PEK%XWG (JJ,JL) * PK%XDZG(JJ,JL)
          ZWGI(IMASK,JL)= ZWGI(IMASK,JL)+ PK%XPATCH(JJ) * PEK%XWGI(JJ,JL) * PK%XDZG(JJ,JL)
          ZDG_TOT(IMASK,JL)= ZDG_TOT(IMASK,JL)+ PK%XPATCH(JJ)* PK%XDZG(JJ,JL)
        ENDIF
!                      
      ENDDO
    ENDDO
  ENDDO
!  
ELSE
  !
  DO JP=1,IO%NPATCH
    PK => NP%AL(JP)
    PEK => NPE%AL(JP)

    ZDG(1:PK%NSIZE_P,1) = PK%XDG(:,1)
    ZDG(1:PK%NSIZE_P,2) = PK%XDG(:,2)
    IF(IO%CISBA=='3-L')THEN
      ZDG(1:PK%NSIZE_P,3) = PK%XDG(:,3)-PK%XDG(:,2)
    ENDIF

    DO JJ=1,PK%NSIZE_P
      IMASK = PK%NR_P(JJ)
      DO JL=1,IO%NGROUND_LAYER
        
        ZWG(IMASK,JL) = ZWG (IMASK,JL)+ PK%XPATCH(JJ) *PEK%XWG(JJ,JL)*  ZDG(JJ,JL)
        ZWGI(IMASK,JL)= ZWGI(IMASK,JL)+ PK%XPATCH(JJ) *PEK%XWGI(JJ,JL)* ZDG(JJ,JL)
        ZDG_TOT(IMASK,JL)=ZDG_TOT(IMASK,JL)+PK%XPATCH(JJ)*ZDG(JJ,JL)
      ENDDO
    ENDDO
  ENDDO
!  
ENDIF
!
IF(HPROGRAM=='AROME '.OR.HPROGRAM=='FA    ')THEN
  ZMISS=0.0
ELSE
  ZMISS=XUNDEF
ENDIF
!
WHERE(ZDG_TOT(:,:)>0.0)
      ZWG   (:,:)=ZWG (:,:)/ZDG_TOT(:,:)
      ZWGI  (:,:)=ZWGI(:,:)/ZDG_TOT(:,:)
ELSEWHERE
      ZWG   (:,:)=ZMISS
      ZWGI  (:,:)=ZMISS    
ENDWHERE
!
! * soil liquid water content (m3/m3) and soil moisture (kg/m2)
!
IF (LALLOW_ADD_DIM)  THEN 
  YRECFM='WG_ISBA' ; 
  YCOMMENT='Soil liquid water content (m3/m3)' 
  CALL WRITE_SURF(DUO%CSELECT, &
                  HPROGRAM,YRECFM,ZWG(:,:),IRESP,YCOMMENT,HNAM_DIM=YWGROUND_LAYER_DIM_NAME)
ELSE
  DO JL=1,IO%NGROUND_LAYER
    WRITE(YLVL,'(I4)') JL
    YRECFM='WG'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
    YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
    YCOMMENT='Soil liquid water content (m3/m3)' 
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZWG(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
! * soil ice water content (m3/m3) and soil ice mass (kg/m2)
!
IWORK=IO%NGROUND_LAYER
IF(IO%CISBA/='DIF')THEN
  IWORK=2 ! No ice in the FR 3-layers
ENDIF
!
IF (LALLOW_ADD_DIM)  THEN 
  YRECFM='WGI_ISBA' ; 
  YCOMMENT='Soil solid water content (m3/m3)' 
  CALL WRITE_SURF(DUO%CSELECT, &
                  HPROGRAM,YRECFM,ZWGI(:,:),IRESP,YCOMMENT,HNAM_DIM=YWIGROUND_LAYER_DIM_NAME)
ELSE
  DO JL=1,IWORK
    WRITE(YLVL,'(I4)') JL
    YRECFM='WGI'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
    YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
    YCOMMENT='Soil solid water content (m3/m3)' 
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZWGI(:,JL),IRESP,HCOMMENT=YCOMMENT) 
  END DO
ENDIF
!
! * water intercepted on leaves (kg/m2)
!
ZWORK(:)=0.0
DO JP=1,IO%NPATCH
  DO JJ=1,NP%AL(JP)%NSIZE_P
    IMASK = NP%AL(JP)%NR_P(JJ)
    ZWORK(IMASK) = ZWORK(IMASK) + NP%AL(JP)%XPATCH(JJ) * NPE%AL(JP)%XWR(JJ)
  ENDDO
ENDDO
!
YRECFM='WR_ISBA'
YCOMMENT='X_Y_'//YRECFM//' (kg/m2)'
CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZWORK(:),IRESP,HCOMMENT=YCOMMENT)
!
! * Glacier ice storage (semi-prognostic) (kg/m2)
!
IF(IO%LGLACIER)THEN
  !
  ZWORK(:)=0.0
  DO JP=1,IO%NPATCH
    DO JJ=1,NP%AL(JP)%NSIZE_P
      IMASK = NP%AL(JP)%NR_P(JJ)
      ZWORK(IMASK) = ZWORK(IMASK) + NP%AL(JP)%XPATCH(JJ) * NPE%AL(JP)%XICE_STO(JJ)
    ENDDO    
  ENDDO    
  !
  YRECFM='ICE_STO_ISBA'
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2)'
  CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZWORK(:),IRESP,HCOMMENT=YCOMMENT)
  !
ENDIF
!
! * Snow albedo (-) 
!
ZPATCH(:) = 0.0
ZWORK (:) = 0.0
DO JP=1,IO%NPATCH
  PK => NP%AL(JP)
  PEK => NPE%AL(JP)

  DO JJ=1,PK%NSIZE_P
    IMASK = PK%NR_P(JJ)

    IF(PEK%TSNOW%ALB(JJ)/=XUNDEF)THEN
      ZWORK (IMASK) = ZWORK (IMASK) + PK%XPATCH(JJ) * PEK%TSNOW%ALB(JJ)
      ZPATCH(IMASK) = ZPATCH(IMASK) + PK%XPATCH(JJ)
    ENDIF
  ENDDO
ENDDO
!
WHERE(ZPATCH(:)>0.0)
  ZWORK(:) = ZWORK(:) / ZPATCH(:)
ELSEWHERE
  ZWORK(:) = XUNDEF
ENDWHERE
!
YRECFM='ASN_ISBA'
YCOMMENT='X_Y_'//YRECFM//' (-)'
CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZWORK(:),IRESP,HCOMMENT=YCOMMENT)
!  
IF(NPE%AL(1)%TSNOW%SCHEME=='3-L' .OR. NPE%AL(1)%TSNOW%SCHEME=='CRO')THEN
  !
  ! * Snow reservoir (kg/m2) by layer
  !
  DO JL = 1,NPE%AL(1)%TSNOW%NLAYER
    !
    ZWORK(:)=0.0
    DO JP=1,IO%NPATCH
      PK => NP%AL(JP)
      PEK => NPE%AL(JP)    
      DO JJ=1,PK%NSIZE_P
        IMASK = PK%NR_P(JJ)
        ZWORK(IMASK) = ZWORK(IMASK) + PK%XPATCH(JJ) * PEK%TSNOW%WSNOW(JJ,JL)
      ENDDO
    ENDDO
    !
    WRITE(YLVL,'(I4)') JL
    YRECFM='WSN_'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
    YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (kg/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZWORK(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDDO
  !
  ! * Snow depth (m)
  !
  DO JL = 1,NPE%AL(1)%TSNOW%NLAYER
    !
    ZWORK(:)=0.0
    DO JP=1,IO%NPATCH
      PK => NP%AL(JP)
      PEK => NPE%AL(JP)
      DO JJ=1,PK%NSIZE_P
        IMASK = PK%NR_P(JJ)
        ZWORK(IMASK) = ZWORK(IMASK) + PK%XPATCH(JJ) * &
                PEK%TSNOW%WSNOW(JJ,JL)/PEK%TSNOW%RHO(JJ,JL)
      ENDDO
    ENDDO
    !
    WRITE(YLVL,'(I4)') JL
    YRECFM='DSN_'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
    YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (kg/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZWORK(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDDO
  !
  ! * Snow temperature (k)
  !  
  IF(HPROGRAM=='AROME '.OR.HPROGRAM=='FA    ')THEN
    ZMISS=XTT
  ELSE
    ZMISS=XUNDEF
  ENDIF
  !  
  DO JL = 1,NPE%AL(1)%TSNOW%NLAYER
    !
    ZWORK (:) = 0.0
    ZPATCH(:) = 0.0
    DO JP=1,IO%NPATCH
      PK => NP%AL(JP)
      PEK => NPE%AL(JP)    
      DO JJ=1,PK%NSIZE_P
        IMASK = PK%NR_P(JJ)
        IF(PEK%TSNOW%WSNOW(JJ,JL)>0.)THEN
          ZWORK (IMASK) = ZWORK (IMASK) + PK%XPATCH(JJ) * PEK%TSNOW%TEMP(JJ,JL) 
          ZPATCH(IMASK) = ZPATCH(IMASK) + PK%XPATCH(JJ)
        ENDIF
      ENDDO
    ENDDO
    !
    WHERE(ZPATCH(:)>0.0)
      ZWORK(:) = ZWORK(:) / ZPATCH(:)
    ELSEWHERE
      ZWORK(:) = ZMISS
    ENDWHERE
    !
    WRITE(YLVL,'(I4)') JL
    YRECFM='TSN_'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
    YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZWORK(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDDO
  !
  ! * Snow age (day)
  !    
  DO JL = 1,NPE%AL(1)%TSNOW%NLAYER
    !
    ZWORK (:) = 0.0
    ZPATCH(:) = 0.0
    DO JP=1,IO%NPATCH
      PK => NP%AL(JP)
      PEK => NPE%AL(JP)    
      DO JJ=1,PK%NSIZE_P
        IMASK = PK%NR_P(JJ)    
        IF(PEK%TSNOW%WSNOW(JJ,JL)>0.)THEN    
          ZWORK (IMASK) = ZWORK (IMASK) + PK%XPATCH(JJ) * PEK%TSNOW%AGE(JJ,JL) 
          ZPATCH(IMASK) = ZPATCH(IMASK) + PK%XPATCH(JJ)
          ENDIF
       ENDDO
    ENDDO
    !
    WHERE(ZPATCH(:)>0.0)
      ZWORK(:) = ZWORK(:) / ZPATCH(:)
    ENDWHERE
    !
    WRITE(YLVL,'(I4)') JL
    YRECFM='AGSN_'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
    YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (day_since_snowfall)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZWORK(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDDO
  !
ENDIF
!
! * Isba-Ags biomass reservoir
!
IF(IO%CPHOTO=='NIT'.OR.IO%CPHOTO=='NCB')THEN
!
  ZBIOMASS(:,:)=0.0
  DO JP=1,IO%NPATCH
    PK => NP%AL(JP)
    PEK => NPE%AL(JP)    
    DO JJ=1,PK%NSIZE_P
      IMASK = PK%NR_P(JJ)      
      DO JL=1,IO%NNBIOMASS
        ZBIOMASS(IMASK,JL) = ZBIOMASS(IMASK,JL) + PK%XPATCH(JJ) * PEK%XBIOMASS(JJ,JL)
      ENDDO
    ENDDO
  ENDDO
!
  DO JL = 1,IO%NNBIOMASS
    WRITE(YLVL,'(I4)') JL
    YRECFM='BIOM'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
    YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (kgDM/m2)'
    CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZBIOMASS(:,JL),IRESP,HCOMMENT=YCOMMENT)  
  ENDDO
!
ENDIF
!
! * Isba-CC carbon reservoir
!
IF(IO%CRESPSL=='CNT')THEN
!
  ZLITTER(:,:,:)=0.0
  ZLIGNIN_STRUC(:,:)=0.0
  DO JP=1,IO%NPATCH
    PK => NP%AL(JP)
    PEK => NPE%AL(JP)    
    DO JJ=1,PK%NSIZE_P
      IMASK = PK%NR_P(JJ) 
      DO JL=1,IO%NNLITTLEVS
        ZLITTER(IMASK,1,JL) = ZLITTER(IMASK,1,JL) + PK%XPATCH(JJ) * PEK%XLITTER(JJ,1,JL)
        ZLITTER(IMASK,2,JL) = ZLITTER(IMASK,2,JL) + PK%XPATCH(JJ) * PEK%XLITTER(JJ,2,JL)
        ZLIGNIN_STRUC(IMASK,JL) = ZLIGNIN_STRUC(IMASK,JL) + PK%XPATCH(JJ) * PEK%XLIGNIN_STRUC(JJ,JL)
      ENDDO
    ENDDO
  ENDDO
!       
  DO JL=1,IO%NNLITTLEVS
     WRITE(YLVL,'(I4)') JL
     YRECFM='LIT1_'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
     YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
     YCOMMENT='X_Y_'//YRECFM//' (gC/m2)'
     CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZLITTER(:,1,JL),IRESP,HCOMMENT=YCOMMENT)  
     WRITE(YLVL,'(I4)') JL
     YRECFM='LIT2_'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
     YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
     YCOMMENT='X_Y_'//YRECFM//' (gC/m2)'
     CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,ZLITTER(:,2,JL),IRESP,HCOMMENT=YCOMMENT)
     WRITE(YLVL,'(I4)') JL
     YRECFM='LIGSTR'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
     YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     CALL WRITE_SURF(DUO%CSELECT,HPROGRAM,YRECFM,ZLIGNIN_STRUC(:,JL),IRESP,HCOMMENT=YCOMMENT)      
  END DO
!
  ZSOILCARB(:,:)=0.0
  DO JP=1,IO%NPATCH
    PK => NP%AL(JP)
    PEK => NPE%AL(JP)    
    DO JJ=1,PK%NSIZE_P
      IMASK = PK%NR_P(JJ)   
      DO JL=1,IO%NNSOILCARB
        ZSOILCARB(IMASK,JL) = ZSOILCARB(IMASK,JL) + PK%XPATCH(JJ) * PEK%XSOILCARB(JJ,JL)
      ENDDO
    ENDDO
  ENDDO
!
  DO JL = 1,IO%NNSOILCARB
    WRITE(YLVL,'(I4)') JL
    YRECFM='SCARB'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
    YRECFM=YRECFM(:LEN_TRIM(YRECFM))//'_ISBA'
    YCOMMENT='X_Y_'//YRECFM//' (gC/m2)'
    CALL WRITE_SURF(DUO%CSELECT, HPROGRAM,YRECFM,ZSOILCARB(:,JL),IRESP,HCOMMENT=YCOMMENT)  
  ENDDO
!
ENDIF
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_ISBA_N:PROVAR_TO_DIAG',1,ZHOOK_HANDLE)
!
END SUBROUTINE PROVAR_TO_DIAG
!
END SUBROUTINE WRITE_DIAG_SEB_ISBA_n
