!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
FUNCTION TEMPORAL_LTS(TPT1, TPT2) RESULT (OLT)
USE MODD_TYPE_DATE_SURF, ONLY: DATE_TIME
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
LOGICAL :: OLT
TYPE(DATE_TIME), INTENT(IN) :: TPT1, TPT2
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
! TRUE if TPT1 .LT. TPT2
!
!
IF (LHOOK) CALL DR_HOOK('TEMPORAL_LTS',0,ZHOOK_HANDLE)
IF ( TPT1%TDATE%YEAR .EQ. TPT2%TDATE%YEAR ) THEN
  IF ( TPT1%TDATE%MONTH .EQ. TPT2%TDATE%MONTH ) THEN
    IF ( TPT1%TDATE%DAY .EQ. TPT2%TDATE%DAY ) THEN
      OLT = TPT1%TIME .LT. TPT2%TIME
    ELSE
      OLT = TPT1%TDATE%DAY .LT. TPT2%TDATE%DAY
    END IF
  ELSE
   OLT = TPT1%TDATE%MONTH .LT. TPT2%TDATE%MONTH
  END IF
ELSE
  OLT = TPT1%TDATE%YEAR .LT. TPT2%TDATE%YEAR
ENDIF
IF (LHOOK) CALL DR_HOOK('TEMPORAL_LTS',1,ZHOOK_HANDLE)
!
END FUNCTION TEMPORAL_LTS
