!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
SUBROUTINE READ_ALL_NAMELISTS (YSC, HPROGRAM,HINIT,ONAM_READ)
!
!
!
USE MODD_SURFEX_n, ONLY : SURFEX_t
!
USE MODD_READ_NAMELIST, ONLY : LNAM_READ
!
USE MODI_INIT_READ_DATA_COVER
!
USE MODI_READ_NAMELISTS_SURF_n
USE MODI_READ_NAMELISTS_SURF
USE MODI_READ_NAMELISTS_FLAKE_n
USE MODI_READ_NAMELISTS_WATFLUX_n
USE MODI_READ_NAMELISTS_SEAFLUX_n
USE MODI_READ_NAMELISTS_ISBA_n
USE MODI_READ_NAMELISTS_ISBA
USE MODI_READ_NAMELISTS_TEB_n
USE MODI_READ_NAMELISTS_IDEAL_n
USE MODI_READ_NAMELISTS_IDEAL
USE MODI_READ_NAMELISTS_SLT
USE MODI_READ_NAMELISTS_DST
USE MODI_READ_NAMELISTS_ASSIM
USE MODI_READ_NAMELISTS_TOPD
#ifdef SFX_ARO
USE MODI_READ_NAMELISTS_IO
#endif
!
USE MODI_READ_NAM_PREP_FLAKE_n
USE MODI_READ_NAM_PREP_GARDEN_n
USE MODI_READ_NAM_PREP_GREENROOF_n
USE MODI_READ_NAM_PREP_ISBA_n
USE MODI_READ_NAM_PREP_SEAFLUX_n
USE MODI_READ_NAM_PREP_SURF_n
USE MODI_READ_NAM_PREP_TEB_n
USE MODI_READ_NAM_PREP_WATFLUX_n
!
!--------------------------------------------------
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
TYPE(SURFEX_t), INTENT(INOUT) :: YSC
!
 CHARACTER(LEN=6),  INTENT(IN)   :: HPROGRAM  ! program calling surf. schemes
 CHARACTER(LEN=3),   INTENT(IN)  :: HINIT     ! choice of fields to initialize
LOGICAL,INTENT(IN)              :: ONAM_READ
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!----------------------------------------
!namelists always read here
!
IF (LHOOK) CALL DR_HOOK('READ_ALL_NAMELISTS',0,ZHOOK_HANDLE)
LNAM_READ=.TRUE.
!
 CALL INIT_READ_DATA_COVER(HPROGRAM)
!
 CALL READ_NAMELISTS_SURF(HPROGRAM)
 CALL READ_NAMELISTS_ISBA(HPROGRAM)
 CALL READ_NAMELISTS_SLT(HPROGRAM)
 CALL READ_NAMELISTS_DST(HPROGRAM)
 CALL READ_NAMELISTS_IDEAL(HPROGRAM)
 CALL READ_NAMELISTS_ASSIM(HPROGRAM)
 CALL READ_NAMELISTS_TOPD(HPROGRAM)
!
IF (HPROGRAM=='AROME ') THEN
#ifdef SFX_ARO
  CALL READ_NAMELISTS_IO(HPROGRAM)
#endif
ENDIF
!
LNAM_READ = ONAM_READ
!
!namelists that can be reread in surfex code
!
IF (.NOT.LNAM_READ) THEN
! 
  LNAM_READ=.TRUE.
  !
  CALL READ_NAMELISTS_SURF_n(YSC%CHU, YSC%DUO, YSC%USS, HPROGRAM,HINIT)
  !
  CALL READ_NAMELISTS_FLAKE_n(YSC%FM, HPROGRAM,HINIT)
  CALL READ_NAMELISTS_WATFLUX_n(YSC%WM, HPROGRAM,HINIT)
  CALL READ_NAMELISTS_SEAFLUX_n(YSC%SM, HPROGRAM,HINIT)
  CALL READ_NAMELISTS_ISBA_n(YSC%IM, HPROGRAM,HINIT)
  CALL READ_NAMELISTS_TEB_n(YSC%TM, YSC%GRM%O, YSC%GDM%O, HPROGRAM, HINIT)
  CALL READ_NAMELISTS_IDEAL_n(YSC%DLO, HPROGRAM)
  !
  LNAM_READ=.FALSE.
  !
  !prep namelists, to be read even if reread in surfex code, 
  !because only partially reread
  !
ELSEIF (HINIT=='PRE') THEN
  !
  CALL READ_NAM_PREP_SURF_n(HPROGRAM)
  CALL READ_NAM_PREP_FLAKE_n(HPROGRAM)
  CALL READ_NAM_PREP_WATFLUX_n(HPROGRAM)
  CALL READ_NAM_PREP_SEAFLUX_n(HPROGRAM) 
  CALL READ_NAM_PREP_ISBA_n(HPROGRAM)
  CALL READ_NAM_PREP_GARDEN_n(HPROGRAM)
  CALL READ_NAM_PREP_GREENROOF_n(HPROGRAM)
  CALL READ_NAM_PREP_TEB_n(HPROGRAM)
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_ALL_NAMELISTS',1,ZHOOK_HANDLE)
!-------------------------------------------
END SUBROUTINE READ_ALL_NAMELISTS
