!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     ##################
      MODULE MODN_SEAFLUX_n
!     ##################
!
!!****  *MODN_SEAFLUX_n* - declaration of namelist NAM_SEAFLUXn
!!
!!    PURPOSE
!!    -------
!       The purpose of this module is to specify  the namelist NAM_SEAFLUX_n
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!       
!!    AUTHOR
!!    ------
!!      V. Masson    *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004                    
!!      Modified    01/2006 : sea flux parameterization.
!!      Modified    08/2009 : LSURF_BUDGETC
!!      Modified    01/2014 : S. Senesi : introduce sea-ice model
!!      Modified    03/2014 : S. Belamari - add NZ0 (to choose PZ0SEA formulation)
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!

!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
 CHARACTER(LEN=6)  :: CSEA_FLUX
 CHARACTER(LEN=4)  :: CSEA_ALB
REAL     :: XTSTEP
REAL     :: XOUT_TSTEP
REAL     :: XDIAG_TSTEP
INTEGER  :: N2M
LOGICAL  :: L2M_MIN_ZS         
LOGICAL  :: LSURF_BUDGET
LOGICAL  :: LRAD_BUDGET
LOGICAL  :: LSURF_BUDGETC
LOGICAL  :: LRESET_BUDGETC
LOGICAL  :: LCOEF
LOGICAL  :: LSURF_VARS
LOGICAL  :: LPWG
LOGICAL  :: LPRECIP
LOGICAL  :: LPWEBB
LOGICAL  :: LDIAG_OCEAN
LOGICAL  :: LDIAG_MISC_SEAICE
INTEGER  :: NZ0
INTEGER  :: NGRVWAVES
REAL     :: XICHCE
CHARACTER(LEN=6)  :: CCH_DRY_DEP
LOGICAL  :: LPROGSST
LOGICAL  :: LPERTFLUX              ! True = stochastic flux perturbation (default:False)
INTEGER  :: NTIME_COUPLING
REAL :: XOCEAN_TSTEP
CHARACTER(LEN=6)  :: CINTERPOL_SST
CHARACTER(LEN=6)  :: CINTERPOL_SSS
CHARACTER(LEN=6)  :: CINTERPOL_SIC
CHARACTER(LEN=6)  :: CINTERPOL_SIT
REAL     :: XFREEZING_SST
REAL     :: XSIC_EFOLDING_TIME
REAL     :: XSIT_EFOLDING_TIME
REAL     :: XSEAICE_TSTEP
REAL     :: XCD_ICE_CST
REAL     :: XSI_FLX_DRV
!
NAMELIST/NAM_SEAFLUXn/CSEA_FLUX,CSEA_ALB, LPWG, LPRECIP, LPWEBB, NGRVWAVES, &
                      NZ0, LPROGSST, NTIME_COUPLING, XOCEAN_TSTEP, XICHCE, &
                      CINTERPOL_SST, CINTERPOL_SSS, LPERTFLUX
NAMELIST/NAM_DIAG_SURFn/N2M,L2M_MIN_ZS,LSURF_BUDGET,LRAD_BUDGET, &
                          LSURF_BUDGETC,LRESET_BUDGETC,LCOEF,LSURF_VARS  
NAMELIST/NAM_CH_SEAFLUXn/CCH_DRY_DEP
NAMELIST/NAM_DIAG_OCEANn/LDIAG_OCEAN
NAMELIST/NAM_SEAICEn/LDIAG_MISC_SEAICE, CINTERPOL_SIC, CINTERPOL_SIT,           &
                     XFREEZING_SST, XSIC_EFOLDING_TIME, XSIT_EFOLDING_TIME,&
                     XSEAICE_TSTEP, XCD_ICE_CST, XSI_FLX_DRV
!
CONTAINS
!
SUBROUTINE INIT_NAM_SEAFLUXn (O, S)
!
  USE MODD_OCEAN_n, ONLY : OCEAN_t
  USE MODD_SEAFLUX_n, ONLY : SEAFLUX_t
!
  IMPLICIT NONE

!
  TYPE(OCEAN_t), INTENT(INOUT) :: O
  TYPE(SEAFLUX_t), INTENT(INOUT) :: S
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_SEAFLUXN',0,ZHOOK_HANDLE)
  XTSTEP = S%XTSTEP
  XOUT_TSTEP = S%XOUT_TSTEP
  CSEA_FLUX = S%CSEA_FLUX
  CSEA_ALB = S%CSEA_ALB
  LPWG = S%LPWG
  LPRECIP = S%LPRECIP
  CINTERPOL_SST = S%CINTERPOL_SST
  CINTERPOL_SSS = S%CINTERPOL_SSS
  LPWEBB = S%LPWEBB
  NZ0 = S%NZ0
  NGRVWAVES = S%NGRVWAVES
  LPROGSST = O%LPROGSST
  NTIME_COUPLING = O%NTIME_COUPLING
  XOCEAN_TSTEP = O%XOCEAN_TSTEP
  XICHCE = S%XICHCE
  LPERTFLUX = S%LPERTFLUX
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_SEAFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_SEAFLUXn

SUBROUTINE UPDATE_NAM_SEAFLUXn (O, S)
!
  USE MODD_OCEAN_n, ONLY : OCEAN_t
  USE MODD_SEAFLUX_n, ONLY : SEAFLUX_t
!
  IMPLICIT NONE

!
  TYPE(OCEAN_t), INTENT(INOUT) :: O
  TYPE(SEAFLUX_t), INTENT(INOUT) :: S
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_SEAFLUXN',0,ZHOOK_HANDLE)
  S%XTSTEP = XTSTEP
  S%XOUT_TSTEP = XOUT_TSTEP  
  S%CSEA_FLUX = CSEA_FLUX
  S%CSEA_ALB = CSEA_ALB
  S%LPWG = LPWG
  S%LPRECIP = LPRECIP
  S%CINTERPOL_SST = CINTERPOL_SST
  S%CINTERPOL_SSS = CINTERPOL_SSS
  S%LPWEBB = LPWEBB
  S%NZ0 = NZ0
  S%NGRVWAVES = NGRVWAVES
  O%LPROGSST = LPROGSST
  O%NTIME_COUPLING = NTIME_COUPLING
  O%XOCEAN_TSTEP = XOCEAN_TSTEP
  S%XICHCE = XICHCE
  S%LPERTFLUX = LPERTFLUX
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_SEAFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_SEAFLUXn
!
SUBROUTINE INIT_NAM_DIAG_SURFn (DGO)
!
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  XDIAG_TSTEP = DGO%XDIAG_TSTEP  
  N2M = DGO%N2M
  L2M_MIN_ZS = DGO%L2M_MIN_ZS
  LSURF_BUDGET = DGO%LSURF_BUDGET
  LRAD_BUDGET = DGO%LRAD_BUDGET
  LSURF_BUDGETC = DGO%LSURF_BUDGETC
  LRESET_BUDGETC = DGO%LRESET_BUDGETC  
  LCOEF = DGO%LCOEF
  LSURF_VARS = DGO%LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_SURFn

SUBROUTINE UPDATE_NAM_DIAG_SURFn (DGO)
!
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  DGO%XDIAG_TSTEP = XDIAG_TSTEP  
  DGO%N2M = N2M
  DGO%L2M_MIN_ZS = L2M_MIN_ZS
  DGO%LSURF_BUDGET = LSURF_BUDGET
  DGO%LRAD_BUDGET = LRAD_BUDGET 
  DGO%LSURF_BUDGETC = LSURF_BUDGETC
  DGO%LRESET_BUDGETC = LRESET_BUDGETC  
  DGO%LCOEF = LCOEF
  DGO%LSURF_VARS = LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_SURFn
!
SUBROUTINE INIT_NAM_CH_SEAFLUXn (CHS)
!
  USE MODD_CH_SEAFLUX_n, ONLY : CH_SEAFLUX_t
!
  IMPLICIT NONE

!
  TYPE(CH_SEAFLUX_t), INTENT(INOUT) :: CHS
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_CH_SEAFLUXN',0,ZHOOK_HANDLE)
  CCH_DRY_DEP = CHS%CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_CH_SEAFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_SEAFLUXn

SUBROUTINE UPDATE_NAM_CH_SEAFLUXn (CHS)
!
  USE MODD_CH_SEAFLUX_n, ONLY : CH_SEAFLUX_t
!
  IMPLICIT NONE

!
  TYPE(CH_SEAFLUX_t), INTENT(INOUT) :: CHS
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_CH_SEAFLUXN',0,ZHOOK_HANDLE)
  CHS%CCH_DRY_DEP = CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_CH_SEAFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_SEAFLUXn

SUBROUTINE INIT_NAM_DIAG_OCEANn (DGO)
!
  USE MODD_DIAG_OCEAN_n, ONLY : DIAG_OCEAN_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_OCEAN_t), INTENT(INOUT) :: DGO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_DIAG_OCEANN',0,ZHOOK_HANDLE)
  LDIAG_OCEAN = DGO%LDIAG_OCEAN
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_DIAG_OCEANN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_OCEANn

SUBROUTINE UPDATE_NAM_DIAG_OCEANn (DGO)
!
  USE MODD_DIAG_OCEAN_n, ONLY : DIAG_OCEAN_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_OCEAN_t), INTENT(INOUT) :: DGO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_DIAG_OCEANN',0,ZHOOK_HANDLE)
  DGO%LDIAG_OCEAN = LDIAG_OCEAN
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_DIAG_OCEANN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_OCEANn

SUBROUTINE INIT_NAM_SEAICEn (DGMSI, S)
!
  USE MODD_DIAG_MISC_SEAICE_n, ONLY : DIAG_MISC_SEAICE_t
  USE MODD_SEAFLUX_n, ONLY : SEAFLUX_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_MISC_SEAICE_t), INTENT(INOUT) :: DGMSI
  TYPE(SEAFLUX_t), INTENT(INOUT) :: S
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_SEAICEN',0,ZHOOK_HANDLE)
  LDIAG_MISC_SEAICE = DGMSI%LDIAG_MISC_SEAICE
  CINTERPOL_SIC = S%CINTERPOL_SIC
  CINTERPOL_SIT = S%CINTERPOL_SIT
  XSIC_EFOLDING_TIME=S%XSIC_EFOLDING_TIME
  XSIT_EFOLDING_TIME=S%XSIT_EFOLDING_TIME
  XSEAICE_TSTEP=S%XSEAICE_TSTEP
  XFREEZING_SST = S%XFREEZING_SST
  XCD_ICE_CST = S%XCD_ICE_CST
  XSI_FLX_DRV = S%XSI_FLX_DRV
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_SEAICEN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_SEAICEn

SUBROUTINE UPDATE_NAM_SEAICEn (DGMSI, S)
!
  USE MODD_DIAG_MISC_SEAICE_n, ONLY : DIAG_MISC_SEAICE_t
  USE MODD_SEAFLUX_n, ONLY : SEAFLUX_t
!
  IMPLICIT NONE
!
  TYPE(DIAG_MISC_SEAICE_t), INTENT(INOUT) :: DGMSI
  TYPE(SEAFLUX_t), INTENT(INOUT) :: S
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_SEAICEN',0,ZHOOK_HANDLE)
  DGMSI%LDIAG_MISC_SEAICE = LDIAG_MISC_SEAICE
  S%CINTERPOL_SIC = CINTERPOL_SIC
  S%CINTERPOL_SIT = CINTERPOL_SIT
  S%XSIC_EFOLDING_TIME = XSIC_EFOLDING_TIME
  S%XSIT_EFOLDING_TIME = XSIT_EFOLDING_TIME
  S%XSEAICE_TSTEP = XSEAICE_TSTEP
  S%XFREEZING_SST = XFREEZING_SST
  S%XCD_ICE_CST = XCD_ICE_CST
  S%XSI_FLX_DRV = XSI_FLX_DRV
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_SEAICEN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_SEAICEn

END MODULE MODN_SEAFLUX_n
