!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!##################
MODULE MODN_ISBA_n
!##################
!
!!****  *MODN_ISBA_n* - declaration of namelist NAM_ISBA_n
!!
!!    PURPOSE
!!    -------
!       The purpose of this module is to specify  the namelist NAM_ISBA_n
!     which concern the surface configuration of one nested  model.
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!       
!!    AUTHOR
!!    ------
!!      V. Masson    *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004                    
!!      Modified    08/2009 by B. Decharme : LSURF_BUDGETC for all tiles
!!      Modified by A.L. Gibelin, 04/2009: add carbon spinup
!!
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
CHARACTER(LEN=4)  :: CC1DRY
CHARACTER(LEN=4)  :: CSCOND
CHARACTER(LEN=3)  :: CSOILFRZ
CHARACTER(LEN=4)  :: CDIFSFCOND
CHARACTER(LEN=3)  :: CSNOWRES
CHARACTER(LEN=3)  :: CCPSURF
CHARACTER(LEN=4)  :: CRUNOFF
CHARACTER(LEN=3)  :: CKSAT
LOGICAL           :: LSOC
CHARACTER(LEN=3)  :: CRAIN
CHARACTER(LEN=3)  :: CHORT         
REAL  :: XTSTEP
REAL  :: XOUT_TSTEP
REAL  :: XCGMAX
REAL  :: XCDRAG
REAL  :: XSPINMAXS
REAL  :: XSPINMAXW
REAL  :: XCO2_START
REAL  :: XCO2_END
INTEGER  :: NNBYEARSPINS
INTEGER  :: NNBYEARSPINW
LOGICAL  :: LPGD
LOGICAL  :: LSURF_EVAP_BUDGET
LOGICAL  :: LSURF_BUDGET
LOGICAL  :: LRAD_BUDGET
LOGICAL  :: LSURF_BUDGETC
LOGICAL  :: LRESET_BUDGETC
LOGICAL  :: LPATCH_BUDGET
LOGICAL  :: LSURF_MISC_BUDGET
LOGICAL  :: LSURF_DIAG_ALBEDO
LOGICAL  :: LSURF_MISC_DIF
LOGICAL  :: LWATER_BUDGET
LOGICAL  :: LPROSNOW
LOGICAL  :: LVOLUMETRIC_SNOWLIQ
REAL     :: XDIAG_TSTEP
REAL     :: XALBICE1, XALBICE2,XALBICE3
REAL     :: XRHOTHRESHOLD_ICE
REAL     :: XZ0ICEZ0SNOW
REAL     :: XVAGING_NOGLACIER,XVAGING_GLACIER
REAL     :: XPERCENTAGEPORE
INTEGER  :: N2M
LOGICAL  :: L2M_MIN_ZS
LOGICAL  :: LCOEF
LOGICAL  :: LSURF_VARS
LOGICAL  :: LCH_BIO_FLUX
LOGICAL  :: LCH_NO_FLUX
LOGICAL  :: LGLACIER
LOGICAL  :: LVEGUPD
LOGICAL  :: LNITRO_DILU
LOGICAL  :: LSPINUPCARBS
LOGICAL  :: LSPINUPCARBW
LOGICAL  :: LCANOPY_DRAG
LOGICAL  :: LPERTSURF
LOGICAL  :: LSNOWDRIFT
LOGICAL  :: LSNOWDRIFT_SUBLIM
LOGICAL  :: LSNOW_ABS_ZENITH
 CHARACTER(3) :: CSNOWMETAMO
 CHARACTER(3) :: CSNOWRAD
 CHARACTER(LEN=6)  :: CCH_DRY_DEP
 CHARACTER(LEN=28) :: CCHEM_SURF_FILE
!
NAMELIST/NAM_ISBAn/CC1DRY,CSCOND,CSOILFRZ,CDIFSFCOND,CSNOWRES,CCPSURF, &
                     XTSTEP,XCGMAX,XCDRAG,LGLACIER,LCANOPY_DRAG,LVEGUPD,LPERTSURF
NAMELIST/NAM_ISBA_AGSn/LNITRO_DILU
NAMELIST/NAM_SGH_ISBAn/CRUNOFF,CKSAT,LSOC,CRAIN,CHORT
NAMELIST/NAM_DIAG_ISBAn/LPGD,LSURF_EVAP_BUDGET,LSURF_MISC_BUDGET,LSURF_DIAG_ALBEDO,LPATCH_BUDGET, &
                        LSURF_MISC_DIF, LWATER_BUDGET, LPROSNOW, LVOLUMETRIC_SNOWLIQ
NAMELIST/NAM_DIAG_SURFn/N2M,L2M_MIN_ZS,LSURF_BUDGET,LRAD_BUDGET, &
                        LSURF_BUDGETC,LRESET_BUDGETC,LCOEF,LSURF_VARS
NAMELIST/NAM_CH_CONTROLn/CCHEM_SURF_FILE
NAMELIST/NAM_CH_ISBAn/LCH_BIO_FLUX,CCH_DRY_DEP,LCH_NO_FLUX
NAMELIST/NAM_SPINUP_CARBn/LSPINUPCARBS,LSPINUPCARBW,XSPINMAXS,XSPINMAXW,NNBYEARSPINS,&
        NNBYEARSPINW, XCO2_START, XCO2_END
NAMELIST/NAM_ISBA_SNOWn/LSNOWDRIFT,LSNOWDRIFT_SUBLIM, LSNOW_ABS_ZENITH, CSNOWMETAMO, CSNOWRAD
!
CONTAINS
!
SUBROUTINE INIT_NAM_ISBAn (IO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBAN',0,ZHOOK_HANDLE)
  CC1DRY = IO%CC1DRY
  CSCOND = IO%CSCOND
  CSOILFRZ = IO%CSOILFRZ
  CDIFSFCOND = IO%CDIFSFCOND
  CSNOWRES = IO%CSNOWRES
  CCPSURF = IO%CCPSURF
  XTSTEP = IO%XTSTEP
  XOUT_TSTEP = IO%XOUT_TSTEP
  XCGMAX = IO%XCGMAX
  XCDRAG = IO%XCDRAG
  LGLACIER = IO%LGLACIER
  LVEGUPD = IO%LVEGUPD  
  LCANOPY_DRAG = IO%LCANOPY_DRAG
  LPERTSURF = IO%LPERTSURF
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_ISBAn

SUBROUTINE INIT_NAM_ISBA_AGSn (IO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_AGSN',0,ZHOOK_HANDLE)
  LNITRO_DILU = IO%LNITRO_DILU
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_AGSN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_ISBA_AGSn

SUBROUTINE INIT_NAM_SGH_ISBAn (IO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_SGH_ISBAN',0,ZHOOK_HANDLE)
  CRUNOFF = IO%CRUNOFF
  CKSAT=IO%CKSAT
  LSOC=IO%LSOC
  CRAIN=IO%CRAIN
  CHORT=IO%CHORT
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_SGH_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_SGH_ISBAn

SUBROUTINE UPDATE_NAM_ISBAn (IO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_ISBAN',0,ZHOOK_HANDLE)
  IO%CC1DRY = CC1DRY
  IO%CSCOND = CSCOND
  IO%CSOILFRZ = CSOILFRZ
  IO%CDIFSFCOND = CDIFSFCOND
  IO%CSNOWRES = CSNOWRES
  IO%CCPSURF = CCPSURF
  IO%XTSTEP = XTSTEP
  IO%XOUT_TSTEP = XOUT_TSTEP
  IO%XCGMAX = XCGMAX
  IO%XCDRAG = XCDRAG
  IO%LGLACIER = LGLACIER
  IO%LVEGUPD = LVEGUPD  
  IO%LCANOPY_DRAG = LCANOPY_DRAG
  IO%LPERTSURF = LPERTSURF
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_ISBAn

SUBROUTINE UPDATE_NAM_ISBA_AGSn (IO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_ISBA_AGSN',0,ZHOOK_HANDLE)
  IO%LNITRO_DILU = LNITRO_DILU
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_ISBA_AGSN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_ISBA_AGSn

SUBROUTINE UPDATE_NAM_SGH_ISBAn (IO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_SGH_ISBAN',0,ZHOOK_HANDLE)
  IO%CRUNOFF=CRUNOFF
  IO%CKSAT=CKSAT
  IO%LSOC=LSOC
  IO%CRAIN=CRAIN
  IO%CHORT=CHORT
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_SGH_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_SGH_ISBAn

SUBROUTINE INIT_NAM_DIAG_ISBAn (DE, DGO, DMI)
!
  USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
  USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DE
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DMI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_DIAG_ISBAN',0,ZHOOK_HANDLE)
  LPGD = DGO%LPGD
  LSURF_EVAP_BUDGET = DE%LSURF_EVAP_BUDGET
  LWATER_BUDGET = DE%LWATER_BUDGET
  LSURF_MISC_BUDGET = DMI%LSURF_MISC_BUDGET
  LSURF_DIAG_ALBEDO = DMI%LSURF_DIAG_ALBEDO
  LSURF_MISC_DIF = DMI%LSURF_MISC_DIF
  LPATCH_BUDGET = DGO%LPATCH_BUDGET
  LPROSNOW = DMI%LPROSNOW
  LVOLUMETRIC_SNOWLIQ = DMI%LPROSNOW
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_DIAG_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_ISBAn

SUBROUTINE UPDATE_NAM_DIAG_ISBAn (DE, DGO, DMI)
!
  USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
  USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DE
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DMI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_DIAG_ISBAN',0,ZHOOK_HANDLE)
  DGO%LPGD = LPGD
  DE%LSURF_EVAP_BUDGET = LSURF_EVAP_BUDGET
  DE%LWATER_BUDGET = LWATER_BUDGET
  DMI%LSURF_MISC_BUDGET = LSURF_MISC_BUDGET
  DMI%LSURF_DIAG_ALBEDO = LSURF_DIAG_ALBEDO
  DMI%LSURF_MISC_DIF = LSURF_MISC_DIF
  DGO%LPATCH_BUDGET = LPATCH_BUDGET
  DMI%LPROSNOW = LPROSNOW
  DMI%LVOLUMETRIC_SNOWLIQ = LVOLUMETRIC_SNOWLIQ  
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_DIAG_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_ISBAn

SUBROUTINE INIT_NAM_DIAG_SURFn (DGO)
!
  USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  XDIAG_TSTEP = DGO%XDIAG_TSTEP  
  N2M = DGO%N2M
  L2M_MIN_ZS = DGO%L2M_MIN_ZS
  LSURF_BUDGET = DGO%LSURF_BUDGET
  LRAD_BUDGET = DGO%LRAD_BUDGET
  LSURF_BUDGETC = DGO%LSURF_BUDGETC
  LRESET_BUDGETC = DGO%LRESET_BUDGETC  
  LCOEF = DGO%LCOEF
  LSURF_VARS = DGO%LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_SURFn

SUBROUTINE UPDATE_NAM_DIAG_SURFn (DGO)
!
  USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  DGO%XDIAG_TSTEP = XDIAG_TSTEP  
  DGO%N2M = N2M
  DGO%L2M_MIN_ZS = L2M_MIN_ZS
  DGO%LSURF_BUDGET = LSURF_BUDGET
  DGO%LRAD_BUDGET = LRAD_BUDGET 
  DGO%LSURF_BUDGETC = LSURF_BUDGETC
  DGO%LRESET_BUDGETC = LRESET_BUDGETC  
  DGO%LCOEF = LCOEF
  DGO%LSURF_VARS = LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_SURFn

SUBROUTINE INIT_NAM_CH_CONTROLn (CHI)
!
  USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_CH_CONTROLN',0,ZHOOK_HANDLE)
  CCHEM_SURF_FILE = CHI%CCHEM_SURF_FILE
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_CH_CONTROLN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_CONTROLn

SUBROUTINE UPDATE_NAM_CH_CONTROLn (CHI)
!
  USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_CH_CONTROLN',0,ZHOOK_HANDLE)
  CHI%CCHEM_SURF_FILE = CCHEM_SURF_FILE
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_CH_CONTROLN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_CONTROLn

SUBROUTINE INIT_NAM_CH_ISBAn (CHI)
!
  USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_CH_ISBAN',0,ZHOOK_HANDLE)
  LCH_BIO_FLUX = CHI%LCH_BIO_FLUX
  LCH_NO_FLUX = CHI%LCH_NO_FLUX
  CCH_DRY_DEP = CHI%CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_CH_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_ISBAn

SUBROUTINE UPDATE_NAM_CH_ISBAn (CHI)
!
  USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_CH_ISBAN',0,ZHOOK_HANDLE)
  CHI%LCH_BIO_FLUX = LCH_BIO_FLUX
  CHI%LCH_NO_FLUX = LCH_NO_FLUX
  CHI%CCH_DRY_DEP = CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_CH_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_ISBAn

SUBROUTINE INIT_NAM_SPINUP_CARB_ISBAn (IO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_SPINUP_CARB_ISBAN',0,ZHOOK_HANDLE)
  LSPINUPCARBS = IO%LSPINUPCARBS
  LSPINUPCARBW = IO%LSPINUPCARBW  
  XSPINMAXS   = IO%XSPINMAXS
  XSPINMAXW   = IO%XSPINMAXW  
  NNBYEARSPINS = IO%NNBYEARSPINS
  NNBYEARSPINW = IO%NNBYEARSPINW
  XCO2_START = IO%XCO2_START
  XCO2_END = IO%XCO2_END
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_SPINUP_CARB_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_SPINUP_CARB_ISBAn

SUBROUTINE UPDATE_NAM_SPINUP_CARB_ISBAn (IO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_SPINUP_CARB_ISBAN',0,ZHOOK_HANDLE)
  IO%LSPINUPCARBS = LSPINUPCARBS
  IO%LSPINUPCARBW = LSPINUPCARBW  
  IO%XSPINMAXS   = XSPINMAXS
  IO%XSPINMAXW   = XSPINMAXW  
  IO%NNBYEARSPINS = NNBYEARSPINS
  IO%NNBYEARSPINW = NNBYEARSPINW
  IO%XCO2_START = XCO2_START
  IO%XCO2_END = XCO2_END
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_SPINUP_CARB_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_SPINUP_CARB_ISBAn

SUBROUTINE INIT_NAM_ISBA_SNOWn (IO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_SNOWn',0,ZHOOK_HANDLE)
  LSNOWDRIFT = IO%LSNOWDRIFT
  LSNOWDRIFT_SUBLIM =  IO%LSNOWDRIFT_SUBLIM
  LSNOW_ABS_ZENITH = IO%LSNOW_ABS_ZENITH
  CSNOWMETAMO = IO%CSNOWMETAMO
  CSNOWRAD = IO%CSNOWRAD  
  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_SNOWn',1,ZHOOK_HANDLE)

END SUBROUTINE INIT_NAM_ISBA_SNOWn

SUBROUTINE UPDATE_NAM_ISBA_SNOWn (IO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_SNOWn',0,ZHOOK_HANDLE)
  IO%LSNOWDRIFT = LSNOWDRIFT
  IO%LSNOWDRIFT_SUBLIM = LSNOWDRIFT_SUBLIM
  IO%LSNOW_ABS_ZENITH = LSNOW_ABS_ZENITH
  IO%CSNOWMETAMO = CSNOWMETAMO
  IO%CSNOWRAD=CSNOWRAD  
  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_SNOWn',1,ZHOOK_HANDLE)

END SUBROUTINE UPDATE_NAM_ISBA_SNOWn

END MODULE MODN_ISBA_n
