!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
MODULE MODE_TEB_VEG
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
USE MODD_ISBA_n, ONLY : ISBA_P_t, ISBA_PE_t, ISBA_S_t
!
IMPLICIT NONE
!
CONTAINS
!
SUBROUTINE INIT_IF_DIF(KGROUND_LAYER, PMASK, P)
!
INTEGER, INTENT(IN) :: KGROUND_LAYER
REAL, DIMENSION(:), INTENT(IN) :: PMASK
TYPE(ISBA_P_t), INTENT(INOUT) :: P
!
INTEGER :: JI, JL
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_TEB_VEG:INIT_IF_DIF',0,ZHOOK_HANDLE)
!
WHERE(PMASK(:)/=0.)
  P%NWG_LAYER(:)=KGROUND_LAYER 
  P%XDG2  (:)=0.0
  P%XDROOT(:)=0.0
ENDWHERE
DO JL=KGROUND_LAYER,1,-1
  DO JI=1,SIZE(PMASK)
    IF(PMASK(JI)/=0..AND.P%XROOTFRAC(JI,JL)>=1.0)THEN
      P%XDG2  (JI)=P%XDG(JI,JL)
      P%XDROOT(JI)=P%XDG(JI,JL)
    ENDIF
  ENDDO
ENDDO
!
IF (LHOOK) CALL DR_HOOK('MODE_TEB_VEG:INIT_IF_DIF',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_IF_DIF
!
SUBROUTINE INIT_IF_NOVEG(PMASK, IO, S, P, PEK)
!
REAL, DIMENSION(:), INTENT(IN) :: PMASK
TYPE(ISBA_OPTIONS_t), INTENT(IN) :: IO
TYPE(ISBA_S_t), INTENT(INOUT) :: S
TYPE(ISBA_P_t), INTENT(INOUT) :: P
TYPE(ISBA_PE_t), INTENT(INOUT) :: PEK
!
INTEGER :: JL, JV
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_TEB_VEG:INIT_IF_NOVEG',0,ZHOOK_HANDLE)
!
WHERE (PMASK(:)==0.)
  PEK%XVEG(:)=0.
  PEK%XLAI(:)=0.
  PEK%XRSMIN(:)=40.
  PEK%XGAMMA(:)=0.
  PEK%XWRMAX_CF(:)=0.2
  PEK%XRGL(:)=100.
  PEK%XCV(:)=2.E-5
  PEK%XZ0(:)=0.013
  P%XZ0_O_Z0H(:)=10.
  PEK%XALBNIR_VEG(:)=0.30
  PEK%XALBVIS_VEG(:)=0.30
  PEK%XALBUV_VEG(:)=0.06
  PEK%XEMIS(:)=0.94
ENDWHERE  
IF (IO%CPHOTO/='NON') THEN
  WHERE (PMASK(:)==0.)
    PEK%XGMES(:)=0.020
    PEK%XBSLAI(:)=0.36
    PEK%XLAIMIN(:)=0.3
    PEK%XSEFOLD(:)=90*86400.
    P%XH_TREE(:)=0.
    P%XRE25(:)=3.6E-7
    PEK%XGC(:)=0.00025
  END WHERE
  WHERE (PMASK(:)==0.) 
    P%XDMAX(:)=0.1
    PEK%XF2I(:)=0.3
  END WHERE
  IF (IO%CPHOTO=='NIT' .OR. IO%CPHOTO=='NCB') THEN
    WHERE (PMASK(:)==0.)      
      PEK%XCE_NITRO(:)=7.68
      PEK%XCF_NITRO(:)=-4.33
      PEK%XCNA_NITRO(:)=1.3
    END WHERE
  ENDIF
ENDIF
IF(IO%CISBA/='DIF')THEN
  DO JL=1,IO%NGROUND_LAYER
    WHERE (PMASK(:)==0.)
      P%XDG(:,JL)=0.2*JL
    END WHERE
  ENDDO
ELSE
  WHERE (PMASK(:)==0.) 
    P%XDG(:,1)=0.01
    P%XDG(:,2)=0.04
    P%XROOTFRAC(:,1)=0.
    P%XROOTFRAC(:,2)=0.
  END WHERE
  DO JL=3,IO%NGROUND_LAYER
    WHERE (PMASK(:)==0.)
      P%XDG(:,JL)=0.1*(JL-2)
      P%XROOTFRAC(:,JL)=0.
    END WHERE
  ENDDO       
  WHERE (PMASK(:)==0.) 
    P%NWG_LAYER(:)=IO%NGROUND_LAYER
    P%XDROOT   (:)=0.0
    P%XDG2     (:)=P%XDG(:,IO%NGROUND_LAYER-1)
  ENDWHERE    
ENDIF  
WHERE (PMASK(:)==0.) 
  P%XD_ICE(:)=0.8*P%XDG(:,2)
END WHERE  
!
IF (LHOOK) CALL DR_HOOK('MODE_TEB_VEG:INIT_IF_NOVEG',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_IF_NOVEG
!
END MODULE MODE_TEB_VEG
