!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     ######################
      MODULE MODD_SURFEX_MPI
!     ######################
!
!!****  *MODD_SURFEX_MPI
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      S. Faroux   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       04/06/12
!!      B. Decharme    04/2013  Delete NWG_LAYER_TOT, NWG_SIZE
!!      J.Escobar      10/06/2013: replace DOUBLE PRECISION by REAL to handle problem for promotion of real on IBM SP
!
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
USE MODD_SURFEX_OMP, ONLY : NBLOCK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!-------------------------------------------------------------------------------
!
REAL, DIMENSION(:,:), ALLOCATABLE :: XWORKS
REAL, DIMENSION(:,:,:), ALLOCATABLE :: XWORK2S
!
INTEGER, DIMENSION(:), ALLOCATABLE :: NREQ
INTEGER, DIMENSION(:), ALLOCATABLE :: NINDEX
INTEGER, DIMENSION(:), ALLOCATABLE :: NNUM
INTEGER, DIMENSION(:), ALLOCATABLE :: NINDEX_MNH
INTEGER, DIMENSION(:), ALLOCATABLE :: NNUM_MNH
INTEGER, DIMENSION(:), ALLOCATABLE :: NSIZE_TASK
!
INTEGER :: NDIM_FULL_INIT
!
INTEGER :: NPROC = 1
INTEGER :: NRANK = 0
INTEGER :: NCOMM = -1
INTEGER :: NPIO  = 0
INTEGER :: NSIZE = 0
INTEGER :: MYPROC = 0
!
INTEGER :: IDX_R = 0
INTEGER :: IDX_W = 0
INTEGER :: IDX_I = 0
!
REAL, DIMENSION(5) :: XTIME_WRITE
REAL, DIMENSION(6) :: XTIME_CALC
!
REAL :: XTIME_NPIO_READ=0
REAL :: XTIME_NPIO_WRITE=0
REAL :: XTIME_COMM_READ=0
REAL :: XTIME_CALC_READ=0
REAL :: XTIME_COMM_WRITE=0
REAL :: XTIME_CALC_WRITE=0
!
REAL :: XTIME_INIT_SEA=0
REAL :: XTIME_INIT_WATER=0
REAL :: XTIME_INIT_NATURE=0
REAL :: XTIME_INIT_TOWN=0
!
REAL :: XTIME_SEA=0
REAL :: XTIME_WATER=0
REAL :: XTIME_NATURE=0
REAL :: XTIME_TOWN=0
!
CONTAINS
!
SUBROUTINE WLOG_MPI(HLOG,PLOG,KLOG,KLOG2,OLOG)
!
IMPLICIT NONE
!
 CHARACTER(LEN=*), INTENT(IN) :: HLOG
REAL, INTENT(IN),OPTIONAL :: PLOG
INTEGER, INTENT(IN), OPTIONAL :: KLOG
INTEGER, INTENT(IN), OPTIONAL :: KLOG2
LOGICAL, INTENT(IN), OPTIONAL :: OLOG
!
INTEGER :: IUNIT
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:WLOG_MPI',0,ZHOOK_HANDLE)
!
IUNIT=100000+NRANK
!
IF (PRESENT(OLOG)) THEN
  IF (PRESENT(PLOG)) THEN
    IF (PRESENT(KLOG)) THEN
      IF (PRESENT(KLOG2)) THEN
        WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, KLOG2, PLOG, OLOG
      ELSE
        WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, PLOG, OLOG
      ENDIF
    ELSE
      WRITE(IUNIT,*) NBLOCK, HLOG, PLOG, OLOG
    ENDIF
  ELSEIF (PRESENT(KLOG)) THEN
    IF (PRESENT(KLOG2)) THEN
      WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, KLOG2, OLOG
    ELSE
      WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, OLOG
    ENDIF
  ELSE
    WRITE(IUNIT,*) NBLOCK, HLOG, OLOG
  ENDIF
ELSEIF (PRESENT(PLOG)) THEN
  IF (PRESENT(KLOG)) THEN
    IF (PRESENT(KLOG2)) THEN
      WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, KLOG2, PLOG
    ELSE
      WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, PLOG
    ENDIF
  ELSE
    WRITE(IUNIT,*) NBLOCK, HLOG, PLOG
  ENDIF
ELSEIF (PRESENT(KLOG)) THEN
  IF (PRESENT(KLOG2)) THEN
    WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, KLOG2
  ELSE
    WRITE(IUNIT,*) NBLOCK, HLOG, KLOG
  ENDIF
ELSE
  WRITE(IUNIT,*) NBLOCK, HLOG
ENDIF
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:WLOG_MPI',1,ZHOOK_HANDLE)
!
END SUBROUTINE WLOG_MPI
!
SUBROUTINE PREP_LOG_MPI
!
CHARACTER(LEN=100) :: YNAME
CHARACTER(LEN=10)  :: YRANK
INTEGER :: IUNIT
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:PREP_LOG_MPI',0,ZHOOK_HANDLE)
!
WRITE(YRANK,FMT='(I10)') NRANK
YNAME='log'//ADJUSTL(YRANK)
!
IUNIT=100000+NRANK
!
OPEN(UNIT=IUNIT,FILE=TRIM(YNAME),FORM='FORMATTED')
WRITE(IUNIT,*) "Log offline pour proc ",NRANK
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:PREP_LOG_MPI',1,ZHOOK_HANDLE)
!
END SUBROUTINE PREP_LOG_MPI
!
SUBROUTINE END_LOG_MPI
!
INTEGER :: IUNIT
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:END_LOG_MPI',0,ZHOOK_HANDLE)
!
IUNIT=100000+NRANK
!
WRITE(IUNIT,*) "End log offline pour proc ",NRANK
CLOSE(UNIT=IUNIT)
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:END_LOG_MPI',1,ZHOOK_HANDLE)
!
END SUBROUTINE END_LOG_MPI
!-------------------------------------------------------------------------------
!
END MODULE MODD_SURFEX_MPI

