!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
SUBROUTINE MAKE_CHOICE_ARRAY(HPROGRAM, KNPATCH, ODIM, HRECFM, PWORK, HDIR, KPATCH)
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_READ_SURF
!
IMPLICIT NONE
!
 CHARACTER(LEN=*), INTENT(IN) :: HPROGRAM
INTEGER, INTENT(IN) :: KNPATCH
LOGICAL, INTENT(IN) :: ODIM
 CHARACTER(LEN=*), INTENT(IN) :: HRECFM
REAL, DIMENSION(:,:), INTENT(INOUT) :: PWORK
!
 CHARACTER(LEN=*), INTENT(IN), OPTIONAL :: HDIR
INTEGER, INTENT(IN), OPTIONAL :: KPATCH
!
 CHARACTER(LEN=12) :: YRECFM
INTEGER :: JP, IRESP, IPATCH
 CHARACTER(LEN=1) :: YDIR
 CHARACTER(LEN=2) :: YPAT
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MAKE_CHOICE_ARRAY',0,ZHOOK_HANDLE)
!
YDIR = 'H'
IF (PRESENT(HDIR)) YDIR = HDIR
!
IPATCH = -1
IF (KNPATCH==1.AND.PRESENT(KPATCH)) IPATCH = KPATCH
!
IF (ODIM) THEN
  DO JP=1,KNPATCH
    IF (IPATCH==-1) THEN
      WRITE(YPAT,'(I2)') JP
    ELSEIF (IPATCH/=0) THEN
      WRITE(YPAT,'(I2)') IPATCH
    ENDIF
    YRECFM=ADJUSTL(HRECFM(:LEN_TRIM(HRECFM)))
    IF (IPATCH/=0) YRECFM=TRIM(YRECFM)//'P'//ADJUSTL(YPAT(:LEN_TRIM(YPAT)))
    CALL READ_SURF(HPROGRAM,YRECFM,PWORK(:,JP),IRESP,HDIR=YDIR)
  ENDDO
ELSE
  CALL READ_SURF(HPROGRAM,HRECFM,PWORK(:,:),IRESP,HDIR=YDIR)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('MAKE_CHOICE_ARRAY',1,ZHOOK_HANDLE)
!
END SUBROUTINE MAKE_CHOICE_ARRAY

