!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE INIT_ISBA_MIXPAR (DTCO, DTV, KDIM, IO, &
                                   KDECADE,KDECADE2,PCOVER,OCOVER,HSFTYPE)
!     ##############################################################
!
!!**** *INIT_ISBA_MIXPAR* 
!!
!!    PURPOSE
!!    -------
!!   This routine makes pre-calculations relative to dependances between
!!    parameters. 
!! 
!!    METHOD
!!    ------
!!   First are treated parameters varying in time. Then, other ones. 
!!   * XPAR_VEGTYPE is needed as soon as 1 LDATA_ is true to use av_pgd_param. 
!!   * XPAR_LAI is needed as soon as av_pgd_param is called with YLAI
!!   * XPAR_VEG is needed as soon as av_pgd_param is called with YVEG
!!   * XPAR_H_TREE is needed as soon as Z0 is calculated by ini_data_param by point
!!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    S. Faroux        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    16/11/10
!!    P. Samuelsson  10/2014  MEB
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
USE MODD_TYPE_DATE_SURF
USE MODD_SURF_PAR,       ONLY : XUNDEF
USE MODD_DATA_COVER_PAR, ONLY : NVEGTYPE, NVEGTYPE_OLD, NVEGTYPE_ECOSG
!
!
USE MODD_DATA_COVER,     ONLY : XDATA_LAI, XDATA_H_TREE, XDATA_VEG,         &
                                XDATA_IRRIG, XDATA_WATSUP, TDATA_SEED,      &
                                TDATA_REAP
!     
USE MODI_INI_DATA_PARAM
USE MODI_AV_PGD
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTV
INTEGER, INTENT(IN) :: KDIM
TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
!
INTEGER,                INTENT(IN)    :: KDECADE
INTEGER,                INTENT(OUT)   :: KDECADE2
REAL, DIMENSION(:,:),   INTENT(IN)    :: PCOVER
LOGICAL, DIMENSION(:),  INTENT(IN)    :: OCOVER
CHARACTER(LEN=*),       INTENT(IN)    :: HSFTYPE ! nature / garden
!
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
TYPE(DATE_TIME), DIMENSION(:,:), ALLOCATABLE :: TPWORK
REAL, DIMENSION(NVEGTYPE)   :: XSTRESS   ! 1. if defensive /0. if offensive
REAL, DIMENSION(NVEGTYPE)   :: XSTRESS_NOAGRI   ! 1. if defensive /0. if offensive
!
CHARACTER(LEN=3)  :: YTREE, YNAT, YVEG
!
INTEGER               :: JVEG, JT, ji
!
INTEGER               :: ISIZE_LMEB_PATCH  ! Number of patches with MEB=true
!
!*    0.3    Declaration of namelists
!            ------------------------
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*    1.      Initializations
!             ---------------
!
IF (LHOOK) CALL DR_HOOK('INIT_ISBA_MIXPAR',0,ZHOOK_HANDLE)
!
IF (NVEGTYPE==NVEGTYPE_ECOSG) THEN
  XSTRESS        = (/1.,1.,1.,0.,0.,0.,0.,0.,1.,1.,1.,0.,0.,0.,0.,1.,1.,0.,0.,0./)
  XSTRESS_NOAGRI = (/1.,1.,1.,0.,0.,0.,0.,0.,1.,1.,1.,0.,0.,0.,0.,0.,0.,0.,0.,0./)
ELSE
  XSTRESS =        (/1.,1.,1.,0.,1.,0.,1.,0.,1.,0.,0.,0.,0.,0.,1.,0.,1.,0.,0./)
  XSTRESS_NOAGRI = (/1.,1.,1.,0.,1.,0.,0.,0.,0.,0.,0.,0.,0.,0.,1.,0.,1.,0.,0./)
ENDIF
!
ISIZE_LMEB_PATCH=COUNT(IO%LMEB_PATCH(:))
!
IF (.NOT.DTV%LDATA_MIXPAR) THEN
  IF (LHOOK) CALL DR_HOOK('INIT_ISBA_MIXPAR',1,ZHOOK_HANDLE)
  RETURN
ENDIF
!
IF (HSFTYPE=='NAT') THEN
  YNAT='NAT'
  YTREE='TRE'
  YVEG='VEG'
ELSEIF (HSFTYPE=='GRD') THEN
  YNAT='GRD'
  YTREE='GRT'
  YVEG='GRV'
ENDIF
!
KDECADE2 = KDECADE
IF (DTV%NTIME==2) KDECADE2 = KDECADE2 + 10 
KDECADE2 = (KDECADE2-1) * DTV%NTIME / 36 + 1
IF (DTV%NTIME==2 .AND. KDECADE2==3) KDECADE2 = 1
!
!          1. Arrays needed further
!          ------------------------
!
!XPAR_VEGTYPE will be needed to use ini_data_param by point
IF (.NOT.DTV%LDATA_VEGTYPE) THEN
  ALLOCATE(DTV%XPAR_VEGTYPE   (KDIM,NVEGTYPE))
  DO JVEG=1,NVEGTYPE
    CALL AV_PGD(DTCO,DTV%XPAR_VEGTYPE(:,JVEG),PCOVER ,DTCO%XDATA_VEGTYPE(:,JVEG),YNAT,'ARI',OCOVER)
  END DO
  !DTV%XPAR_VEGTYPE(:,:)=DTV%XPAR_VEGTYPE(:,:)/SPREAD(SUM(DTV%XPAR_VEGTYPE(:,:),2),2,NVEGTYPE)
ENDIF
!
!xpar_lai: needed for av_pgd_param with YLAI
IF (.NOT.ANY(DTV%LDATA_LAI)) THEN
  ALLOCATE(DTV%XPAR_LAI(KDIM,DTV%NTIME,NVEGTYPE))
  CALL AV_PGD(DTCO,DTV%XPAR_LAI(:,KDECADE2,:),PCOVER,XDATA_LAI(:,KDECADE,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)
ENDIF
!
!veg
IF (.NOT.ANY(DTV%LDATA_VEG)) THEN
  ALLOCATE(DTV%XPAR_VEG(KDIM,DTV%NTIME,NVEGTYPE))
  IF (ANY(DTV%LDATA_LAI)) THEN
    CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PLAI=DTV%XPAR_LAI,PVEG_OUT=DTV%XPAR_VEG)
    DTV%LDATA_VEG(:)=.TRUE.
  ELSE
    CALL AV_PGD(DTCO,DTV%XPAR_VEG(:,KDECADE2,:),PCOVER,XDATA_VEG(:,KDECADE,:),YNAT,'ARI',OCOVER,KDECADE=KDECADE)
  ENDIF
ENDIF
!
!ht: needed to calculate z0, if not calculated yet during extrapolation 
IF (.NOT.ANY(DTV%LDATA_H_TREE) .AND. .NOT.ANY(DTV%LDATA_Z0) .AND. ANY(DTV%LDATA_LAI)) THEN
  ALLOCATE(DTV%XPAR_H_TREE(KDIM,NVEGTYPE))
  CALL AV_PGD(DTCO,DTV%XPAR_H_TREE,PCOVER,XDATA_H_TREE,YTREE,'ARI',OCOVER,KDECADE=KDECADE)
  DTV%LDATA_H_TREE(:) = .TRUE.
ENDIF
!
!dg: initialization for ROOTFRAC
!ROOTFRAC depends on ROOT_DEPTH, DG, ROOT_EXT, ROOT_LIN
IF (.NOT.ANY(DTV%LDATA_ROOTFRAC) .AND. IO%CISBA=='DIF' .AND. ANY(DTV%LDATA_ROOT_DEPTH)) THEN
  !
  IF (.NOT.ANY(DTV%LDATA_ROOT_EXTINCTION)) THEN
    ALLOCATE(DTV%XPAR_ROOT_EXTINCTION(KDIM,NVEGTYPE))
    CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PROOT_EXTINCTION=DTV%XPAR_ROOT_EXTINCTION)
    DTV%LDATA_ROOT_EXTINCTION(:) = .TRUE.
  ENDIF
  !
  IF (.NOT.ANY(DTV%LDATA_ROOT_LIN)) THEN
    ALLOCATE(DTV%XPAR_ROOT_LIN(KDIM,NVEGTYPE))
    CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PROOT_LIN=DTV%XPAR_ROOT_LIN)
    DTV%LDATA_ROOT_LIN(:) = .TRUE.
  ENDIF
  !
ENDIF
!
!dice: depth of the soil column for the calculation of the frozen soil fraction (m)
IF (ANY(DTV%LDATA_DG) .AND. .NOT.ANY(DTV%LDATA_DICE)) THEN
  !
  ALLOCATE(DTV%XPAR_DICE(KDIM,NVEGTYPE))
  !
  IF(IO%CISBA/='DIF')THEN
    DTV%XPAR_DICE(:,:)=MAX(0.2,0.8*DTV%XPAR_DG(:,2,:))
    DTV%LDATA_DICE(:)=.TRUE.
  ENDIF
!
ENDIF
!
!          2. Calculations of parameters dependant on others
!          -------------------------------------------------
!
!emis
IF (.NOT.ANY(DTV%LDATA_EMIS) .AND. ANY(DTV%LDATA_VEG)) THEN
  ALLOCATE(DTV%XPAR_EMIS(KDIM,DTV%NTIME,NVEGTYPE))
  CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PVEG_IN=DTV%XPAR_VEG,PEMIS_ECO=DTV%XPAR_EMIS)
  DTV%LDATA_EMIS(:)=.TRUE.
ENDIF
!z0
IF (.NOT.ANY(DTV%LDATA_Z0) .AND. (ANY(DTV%LDATA_LAI) .OR.ANY(DTV%LDATA_H_TREE))) THEN
  ALLOCATE(DTV%XPAR_Z0(KDIM,DTV%NTIME,NVEGTYPE))
  CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PLAI=DTV%XPAR_LAI,PH_TREE=DTV%XPAR_H_TREE,PZ0=DTV%XPAR_Z0)
  DTV%LDATA_Z0(:)=.TRUE.
ENDIF

!RSMIN
IF (ANY(DTV%LDATA_LAI)) THEN
  IF (.NOT.ANY(DTV%LDATA_RSMIN)) THEN
    ALLOCATE(DTV%XPAR_RSMIN(KDIM,NVEGTYPE))
    CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PRSMIN=DTV%XPAR_RSMIN)
  ENDIF
  DTV%LDATA_RSMIN(:)=.TRUE.
ENDIF

!parameters calculated on veg fraction
IF (ANY(DTV%LDATA_VEG)) THEN
  !
  IF (.NOT.ANY(DTV%LDATA_GAMMA))      ALLOCATE(DTV%XPAR_GAMMA     (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_WRMAX_CF))   ALLOCATE(DTV%XPAR_WRMAX_CF  (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_RGL))        ALLOCATE(DTV%XPAR_RGL       (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_CV))         ALLOCATE(DTV%XPAR_CV        (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_ALBNIR_VEG)) ALLOCATE(DTV%XPAR_ALBNIR_VEG(KDIM,DTV%NTIME,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_ALBVIS_VEG)) ALLOCATE(DTV%XPAR_ALBVIS_VEG(KDIM,DTV%NTIME,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_ALBUV_VEG))  ALLOCATE(DTV%XPAR_ALBUV_VEG (KDIM,DTV%NTIME,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_GMES))       ALLOCATE(DTV%XPAR_GMES      (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_BSLAI))      ALLOCATE(DTV%XPAR_BSLAI     (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_SEFOLD))     ALLOCATE(DTV%XPAR_SEFOLD    (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_GC))         ALLOCATE(DTV%XPAR_GC        (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_LAIMIN))     ALLOCATE(DTV%XPAR_LAIMIN    (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_F2I))        ALLOCATE(DTV%XPAR_F2I       (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_CE_NITRO))   ALLOCATE(DTV%XPAR_CE_NITRO  (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_CF_NITRO))   ALLOCATE(DTV%XPAR_CF_NITRO  (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_CNA_NITRO))  ALLOCATE(DTV%XPAR_CNA_NITRO (KDIM,NVEGTYPE))
  !
  IF (.NOT.ANY(DTV%LDATA_GAMMA)) &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PGAMMA=DTV%XPAR_GAMMA)
  IF (.NOT.ANY(DTV%LDATA_WRMAX_CF)) &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PWRMAX_CF=DTV%XPAR_WRMAX_CF)
  IF (.NOT.ANY(DTV%LDATA_RGL))      &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PRGL=DTV%XPAR_RGL)
  IF (.NOT.ANY(DTV%LDATA_CV))       &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PCV=DTV%XPAR_CV)
  IF (.NOT.ANY(DTV%LDATA_ALBNIR_VEG)) THEN
    CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PALBNIR_VEG=DTV%XPAR_ALBNIR_VEG(:,1,:))
    DO JT = 2,DTV%NTIME 
      DTV%XPAR_ALBNIR_VEG(:,JT,:) = DTV%XPAR_ALBNIR_VEG(:,1,:)
    ENDDO
  ENDIF
  IF (.NOT.ANY(DTV%LDATA_ALBVIS_VEG)) THEN
    CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PALBVIS_VEG=DTV%XPAR_ALBVIS_VEG(:,1,:))
    DO JT = 2,DTV%NTIME 
      DTV%XPAR_ALBVIS_VEG(:,JT,:) = DTV%XPAR_ALBVIS_VEG(:,1,:)
    ENDDO
  ENDIF    
  IF (.NOT.ANY(DTV%LDATA_ALBUV_VEG)) THEN
    CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PALBUV_VEG=DTV%XPAR_ALBUV_VEG(:,1,:))
    DO JT = 2,DTV%NTIME 
      DTV%XPAR_ALBUV_VEG(:,JT,:) = DTV%XPAR_ALBUV_VEG(:,1,:)
    ENDDO
  ENDIF      
  IF (ISIZE_LMEB_PATCH>0)  THEN
    IF (.NOT.ANY(DTV%LDATA_BSLAI)) CALL INI_DATA_PARAM(PBSLAI=DTV%XPAR_BSLAI)
  ENDIF
  IF (IO%CPHOTO /= 'NON')  THEN
    IF (.NOT.ANY(DTV%LDATA_GMES))   &
            CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PGMES_ST=DTV%XPAR_GMES)
    IF (.NOT.ANY(DTV%LDATA_BSLAI))  &
            CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PBSLAI_ST=DTV%XPAR_BSLAI)
    IF (.NOT.ANY(DTV%LDATA_SEFOLD)) &
            CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PSEFOLD_ST=DTV%XPAR_SEFOLD)
    IF (.NOT.ANY(DTV%LDATA_GC))     &
            CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PGC_ST=DTV%XPAR_GC)
  ELSE
    IF (.NOT.ANY(DTV%LDATA_GMES))   &
            CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PGMES=DTV%XPAR_GMES)
    IF (.NOT.ANY(DTV%LDATA_BSLAI))  &
            CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PBSLAI=DTV%XPAR_BSLAI)
    IF (.NOT.ANY(DTV%LDATA_SEFOLD)) &
            CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PSEFOLD=DTV%XPAR_SEFOLD)
    IF (.NOT.ANY(DTV%LDATA_GC))     &
            CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PGC=DTV%XPAR_GC)
  ENDIF
  IF (.NOT.ANY(DTV%LDATA_LAIMIN))    &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PLAIMIN_OUT=DTV%XPAR_LAIMIN)
  IF (.NOT.ANY(DTV%LDATA_F2I))       &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PF2I=DTV%XPAR_F2I)
  IF (.NOT.ANY(DTV%LDATA_CE_NITRO))  &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PCE_NITRO=DTV%XPAR_CE_NITRO)
  IF (.NOT.ANY(DTV%LDATA_CF_NITRO))  &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PCF_NITRO=DTV%XPAR_CF_NITRO)
  IF (.NOT.ANY(DTV%LDATA_CNA_NITRO)) &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PCNA_NITRO=DTV%XPAR_CNA_NITRO)
  !
  DTV%LDATA_GAMMA(:)     =.TRUE.
  DTV%LDATA_WRMAX_CF(:)  =.TRUE.
  DTV%LDATA_RGL(:)       =.TRUE.
  DTV%LDATA_CV(:)        =.TRUE.
  DTV%LDATA_ALBNIR_VEG(:)=.TRUE.
  DTV%LDATA_ALBVIS_VEG(:)=.TRUE.
  DTV%LDATA_ALBUV_VEG(:) =.TRUE.
  DTV%LDATA_GMES(:)      =.TRUE.
  DTV%LDATA_BSLAI(:)     =.TRUE.
  DTV%LDATA_SEFOLD(:)    =.TRUE.
  DTV%LDATA_GC(:)        =.TRUE.
  DTV%LDATA_LAIMIN(:)    =.TRUE.
  DTV%LDATA_F2I(:)       =.TRUE.
  DTV%LDATA_CE_NITRO(:)  =.TRUE.
  DTV%LDATA_CF_NITRO(:)  =.TRUE.
  DTV%LDATA_CNA_NITRO(:) =.TRUE.
  !
  DTV%LDATA_STRESS(:)    =.TRUE.
  !
  ALLOCATE(DTV%LPAR_STRESS(KDIM,NVEGTYPE))  
  DTV%LPAR_STRESS(:,:) = .TRUE.
  IF(IO%LAGRI_TO_GRASS)THEN
    DO JVEG=1,NVEGTYPE
      IF(XSTRESS_NOAGRI(JVEG)<1.) DTV%LPAR_STRESS(:,JVEG) = .FALSE.
    ENDDO 
  ELSE
    DO JVEG=1,NVEGTYPE
      IF(XSTRESS(JVEG)<1.) DTV%LPAR_STRESS(:,JVEG) = .FALSE.
    ENDDO
  ENDIF
  !
  !
  IF (.NOT.ANY(DTV%LDATA_IRRIG)) THEN
    ALLOCATE(DTV%XPAR_IRRIG     (KDIM,DTV%NTIME,NVEGTYPE))
    CALL AV_PGD(DTCO, DTV%XPAR_IRRIG(:,KDECADE2,:),PCOVER,XDATA_IRRIG(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)
    DTV%LDATA_IRRIG(:)=.TRUE.
  ENDIF
  !
  IF (.NOT.ANY(DTV%LDATA_WATSUP)) THEN
    ALLOCATE(DTV%XPAR_WATSUP     (KDIM,DTV%NTIME,NVEGTYPE))
    CALL AV_PGD(DTCO, DTV%XPAR_WATSUP(:,KDECADE2,:),PCOVER,XDATA_WATSUP(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)
    DTV%LDATA_WATSUP(:)=.TRUE.
  ENDIF
  !
  ALLOCATE(TPWORK(KDIM,NVEGTYPE))
  !
  IF (.NOT.ANY(DTV%LDATA_SEED_M).OR..NOT.ANY(DTV%LDATA_SEED_D)) THEN
    ALLOCATE(DTV%XPAR_SEED_M(KDIM,NVEGTYPE))
    ALLOCATE(DTV%XPAR_SEED_D(KDIM,NVEGTYPE))
    CALL AV_PGD(TPWORK(:,:),PCOVER,TDATA_SEED(:,:),YVEG,'MAJ',OCOVER,KDECADE=KDECADE)
    DTV%XPAR_SEED_M(:,:) = FLOAT(TPWORK(:,:)%TDATE%MONTH)
    DTV%XPAR_SEED_D(:,:) = FLOAT(TPWORK(:,:)%TDATE%DAY)
    DTV%LDATA_SEED_M(:)=.TRUE.
    DTV%LDATA_SEED_D(:)=.TRUE.
  ENDIF
  !
  IF (.NOT.ANY(DTV%LDATA_REAP_M).OR..NOT.ANY(DTV%LDATA_REAP_D)) THEN
    ALLOCATE(DTV%XPAR_REAP_M(KDIM,NVEGTYPE))
    ALLOCATE(DTV%XPAR_REAP_D(KDIM,NVEGTYPE))
    CALL AV_PGD(TPWORK(:,:),PCOVER,TDATA_REAP(:,:),YVEG,'MAJ',OCOVER,KDECADE=KDECADE)
    DTV%XPAR_REAP_M(:,:) = FLOAT(TPWORK(:,:)%TDATE%MONTH)
    DTV%XPAR_REAP_D(:,:) = FLOAT(TPWORK(:,:)%TDATE%DAY)
    DTV%LDATA_REAP_M(:)=.TRUE.
    DTV%LDATA_REAP_D(:)=.TRUE.
  ENDIF
  !
  DEALLOCATE(TPWORK)  
!
! MEB stuff
!
  IF (ISIZE_LMEB_PATCH>0)  THEN

!Z0LITTER
    IF (.NOT.ANY(DTV%LDATA_Z0LITTER)) THEN
      ALLOCATE(DTV%XPAR_Z0LITTER(KDIM,DTV%NTIME,NVEGTYPE))
      CALL INI_DATA_PARAM( PZ0LITTER=DTV%XPAR_Z0LITTER)
      DTV%LDATA_Z0LITTER(:)=.TRUE.
    ENDIF
!
!H_VEG
    IF (.NOT.ANY(DTV%LDATA_H_VEG) .AND. ANY(DTV%LDATA_LAI) .AND. ANY(DTV%LDATA_H_TREE)) THEN
      ALLOCATE(DTV%XPAR_H_VEG(KDIM,DTV%NTIME,NVEGTYPE))
      CALL INI_DATA_PARAM(PH_VEG=DTV%XPAR_H_VEG,PLAI=DTV%XPAR_LAI,  &
                          PH_TREE=DTV%XPAR_H_TREE)
      DTV%LDATA_H_VEG(:)=.TRUE.
    ENDIF
!
!GNDLITTER
    IF (.NOT.ANY(DTV%LDATA_GNDLITTER) ) THEN
      ALLOCATE(DTV%XPAR_GNDLITTER(KDIM,DTV%NTIME,NVEGTYPE))
      CALL INI_DATA_PARAM(PGNDLITTER=DTV%XPAR_GNDLITTER)
      DTV%LDATA_GNDLITTER(:)=.TRUE.
    ENDIF
    !
  ENDIF
  !
ENDIF
!
!
IF (DTV%LDATA_VEGTYPE) THEN
  IF (.NOT.ANY(DTV%LDATA_Z0_O_Z0H)) ALLOCATE(DTV%XPAR_Z0_O_Z0H  (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_DMAX)) ALLOCATE(DTV%XPAR_DMAX      (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_RE25)) ALLOCATE(DTV%XPAR_RE25      (KDIM,NVEGTYPE))
  IF (.NOT.ANY(DTV%LDATA_Z0_O_Z0H)) &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PZ0_O_Z0H=DTV%XPAR_Z0_O_Z0H)
  IF (IO%CPHOTO /= 'NON')  THEN
    IF (.NOT.ANY(DTV%LDATA_DMAX)) &
            CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PDMAX_ST=DTV%XPAR_DMAX)
  ELSE
    IF (.NOT.ANY(DTV%LDATA_DMAX)) &
            CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PDMAX=DTV%XPAR_DMAX)
  ENDIF
  IF (.NOT.ANY(DTV%LDATA_RE25)) &
          CALL INI_DATA_PARAM(OAGRI_TO_GRASS=IO%LAGRI_TO_GRASS,PRE25=DTV%XPAR_RE25)
  !
  DTV%LDATA_Z0_O_Z0H(:)=.TRUE.
  DTV%LDATA_DMAX(:)    =.TRUE.
  DTV%LDATA_RE25(:)    =.TRUE.
ENDIF
!
IF (LHOOK) CALL DR_HOOK('INIT_ISBA_MIXPAR',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE INIT_ISBA_MIXPAR
