!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
MODULE MODI_INI_VAR_FROM_DATA_0D
!
INTERFACE INI_VAR_FROM_DATA_0D
!
!     #########
      SUBROUTINE INI_VAR_FROM_DATA_0D_1D (DTCO, UG, U, USS, &
                                          HPROGRAM, HATYPE,  HNAME, HTYPE, HFNAM, &
                                          HFTYP, PUNIF, PFIELD, OPRESENT,  &
                                          PMASK)
!     ##############################################################
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_SSO_n, ONLY : SSO_t
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(SSO_t), INTENT(INOUT) :: USS
!
!
 CHARACTER(LEN=6), INTENT(IN) :: HPROGRAM
 CHARACTER(LEN=3), INTENT(IN) :: HATYPE
 CHARACTER(LEN=*), INTENT(IN) :: HNAME
 CHARACTER(LEN=3), INTENT(IN) :: HTYPE
 CHARACTER(LEN=28), INTENT(IN) :: HFNAM
 CHARACTER(LEN=6), INTENT(INOUT) :: HFTYP
REAL, INTENT(IN) :: PUNIF
REAL, DIMENSION(:), INTENT(OUT) :: PFIELD
LOGICAL, INTENT(OUT) :: OPRESENT
REAL, DIMENSION(:), OPTIONAL, INTENT(IN) :: PMASK
!
!
END SUBROUTINE INI_VAR_FROM_DATA_0D_1D
!
!     #########
      SUBROUTINE INI_VAR_FROM_DATA_0D_2D (DTCO, UG, U, USS, &
                                          HPROGRAM, HATYPE,  HNAME, HTYPE, HFNAM, &
                                          HFTYP, PUNIF, PFIELD, OPRESENT,  &
                                          PMASK)
!     ##############################################################
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_SSO_n, ONLY : SSO_t
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(SSO_t), INTENT(INOUT) :: USS
!
!
 CHARACTER(LEN=6), INTENT(IN) :: HPROGRAM
 CHARACTER(LEN=3), INTENT(IN) :: HATYPE
 CHARACTER(LEN=*), INTENT(IN) :: HNAME
 CHARACTER(LEN=3), INTENT(IN) :: HTYPE
 CHARACTER(LEN=28), INTENT(IN) :: HFNAM
 CHARACTER(LEN=6), INTENT(INOUT) :: HFTYP
REAL, INTENT(IN) :: PUNIF
REAL, DIMENSION(:,:), INTENT(OUT) :: PFIELD
LOGICAL, INTENT(OUT) :: OPRESENT
REAL, DIMENSION(:,:), OPTIONAL, INTENT(IN) :: PMASK
!
!
END SUBROUTINE INI_VAR_FROM_DATA_0D_2D
!
END INTERFACE INI_VAR_FROM_DATA_0D
!
END MODULE MODI_INI_VAR_FROM_DATA_0D
!
!     #########
      SUBROUTINE INI_VAR_FROM_DATA_0D_1D (DTCO, UG, U, USS, &
                                          HPROGRAM, HATYPE,  HNAME, HTYPE, HFNAM, &
                                          HFTYP, PUNIF, PFIELD, OPRESENT, PMASK)
!     ##############################################################
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_SSO_n, ONLY : SSO_t
!
USE MODD_SURF_PAR, ONLY : XUNDEF
!
USE MODI_INI_VAR_FROM_DATA_0D_IN
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(SSO_t), INTENT(INOUT) :: USS
!
!
 CHARACTER(LEN=6), INTENT(IN) :: HPROGRAM
 CHARACTER(LEN=3), INTENT(IN) :: HATYPE
 CHARACTER(LEN=*), INTENT(IN) :: HNAME
 CHARACTER(LEN=3), INTENT(IN) :: HTYPE
 CHARACTER(LEN=28), INTENT(IN) :: HFNAM
 CHARACTER(LEN=6), INTENT(INOUT) :: HFTYP
REAL, INTENT(IN) :: PUNIF
REAL, DIMENSION(:), INTENT(OUT) :: PFIELD
LOGICAL, INTENT(OUT) :: OPRESENT
REAL, DIMENSION(:), OPTIONAL, INTENT(IN) :: PMASK
!
REAL, DIMENSION(SIZE(PFIELD),1) :: ZFIELD
REAL, DIMENSION(:,:), ALLOCATABLE :: ZMASK
!
IF (PRESENT(PMASK)) THEN
  ALLOCATE(ZMASK(SIZE(PMASK),1))
  ZMASK(:,1) = PMASK
  CALL INI_VAR_FROM_DATA_0D_IN(DTCO, UG, U, USS, &
                   HPROGRAM, HATYPE, HNAME, HTYPE, HFNAM, &
                   HFTYP, PUNIF, ZFIELD, OPRESENT, ZMASK)
  DEALLOCATE(ZMASK)
ELSE
  CALL INI_VAR_FROM_DATA_0D_IN(DTCO, UG, U, USS, &
                   HPROGRAM, HATYPE, HNAME, HTYPE, HFNAM, &
                   HFTYP, PUNIF, ZFIELD, OPRESENT)
ENDIF
!
IF (ANY(ZFIELD(:,1)/=XUNDEF)) PFIELD(:) = ZFIELD(:,1)
!
!
END SUBROUTINE INI_VAR_FROM_DATA_0D_1D
!
!     #########
      SUBROUTINE INI_VAR_FROM_DATA_0D_2D (DTCO, UG, U, USS, &
                                          HPROGRAM, HATYPE,  HNAME, HTYPE, HFNAM, &
                                          HFTYP, PUNIF, PFIELD, OPRESENT, PMASK)
!     ##############################################################
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_SSO_n, ONLY : SSO_t
!
USE MODI_INI_VAR_FROM_DATA_0D_IN
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(SSO_t), INTENT(INOUT) :: USS
!
!
 CHARACTER(LEN=6), INTENT(IN) :: HPROGRAM
 CHARACTER(LEN=3), INTENT(IN) :: HATYPE
 CHARACTER(LEN=*), INTENT(IN) :: HNAME
 CHARACTER(LEN=3), INTENT(IN) :: HTYPE
 CHARACTER(LEN=28), INTENT(IN) :: HFNAM
 CHARACTER(LEN=6), INTENT(INOUT) :: HFTYP
REAL, INTENT(IN) :: PUNIF
REAL, DIMENSION(:,:), INTENT(OUT) :: PFIELD
LOGICAL, INTENT(OUT) :: OPRESENT
REAL, DIMENSION(:,:), OPTIONAL, INTENT(IN) :: PMASK
!
IF (PRESENT(PMASK)) THEN
  CALL INI_VAR_FROM_DATA_0D_IN(DTCO, UG, U, USS, &
                   HPROGRAM, HATYPE, HNAME, HTYPE, HFNAM, &
                   HFTYP, PUNIF, PFIELD, OPRESENT, PMASK)
ELSE
  CALL INI_VAR_FROM_DATA_0D_IN(DTCO, UG, U, USS, &
                   HPROGRAM, HATYPE, HNAME, HTYPE, HFNAM, &
                   HFTYP, PUNIF, PFIELD, OPRESENT)        
ENDIF
!
END SUBROUTINE INI_VAR_FROM_DATA_0D_2D
!
