!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
SUBROUTINE FLAG_DIAG_UPDATE (FM, IM, SM, TM, WM, DGO, U, SV, &
                             OFRAC, ODIAG_GRID, K2M, OSURF_BUDGET, ORAD_BUDGET, OCOEF,  &
                             OSURF_VARS, KBEQ, KDSTEQ, ODIAG_OCEAN, ODIAG_MISC_SEAICE,  &
                             OWATER_PROFILE, OSURF_EVAP_BUDGET, OFLOOD,  OPGD_ISBA,     &
                             OCH_NO_FLUX_ISBA, OSURF_MISC_BUDGET_ISBA, OPGD_TEB,        &
                             OSURF_MISC_BUDGET_TEB    )
!     ############################################################
!
!!****  *FLAG_DIAG_UPDATE* - routine to modify selection of output fields
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!	P. Le Moigne   *Meteo France*	
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2008 
!
!       B.Decharme  10/2009 flag to desactivate writing of pgd 
!!      Modified    04/2013, P. Le Moigne: FLake chemistry
!!      Modified    01/2014, S. Senesi   : introduce sea-ice model
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_SURFEX_n, ONLY : FLAKE_MODEL_t, ISBA_MODEL_t, SEAFLUX_MODEL_t, &
                          TEB_MODEL_t, WATFLUX_MODEL_t
USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_SV_n, ONLY : SV_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
TYPE(FLAKE_MODEL_t), INTENT(INOUT) :: FM
TYPE(ISBA_MODEL_t), INTENT(INOUT) :: IM
TYPE(SEAFLUX_MODEL_t), INTENT(INOUT) :: SM
TYPE(TEB_MODEL_t), INTENT(INOUT) :: TM
TYPE(WATFLUX_MODEL_t), INTENT(INOUT) :: WM
!
TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(SV_t), INTENT(INOUT) :: SV
!
LOGICAL, INTENT(IN) :: OFRAC
LOGICAL, INTENT(IN) :: ODIAG_GRID
INTEGER, INTENT(IN) :: K2M
LOGICAL, INTENT(IN) :: OSURF_BUDGET
LOGICAL, INTENT(IN) :: ORAD_BUDGET
LOGICAL, INTENT(IN) :: OCOEF
LOGICAL, INTENT(IN) :: OSURF_VARS
!
INTEGER, INTENT(IN) :: KBEQ
INTEGER, INTENT(IN) :: KDSTEQ
!
LOGICAL, INTENT(IN) :: ODIAG_OCEAN
LOGICAL, INTENT(IN) :: ODIAG_MISC_SEAICE
LOGICAL, INTENT(IN) :: OWATER_PROFILE
LOGICAL, INTENT(IN) :: OSURF_EVAP_BUDGET
LOGICAL, INTENT(IN) :: OFLOOD
LOGICAL, INTENT(IN) :: OSURF_MISC_BUDGET_ISBA
LOGICAL, INTENT(IN) :: OCH_NO_FLUX_ISBA
LOGICAL, INTENT(IN) :: OPGD_ISBA
LOGICAL, INTENT(IN) :: OSURF_MISC_BUDGET_TEB
LOGICAL, INTENT(IN) :: OPGD_TEB
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE',0,ZHOOK_HANDLE)
!
DGO%LFRAC = OFRAC
DGO%LDIAG_GRID = ODIAG_GRID
DGO%N2M = K2M
DGO%LSURF_BUDGET = OSURF_BUDGET
DGO%LRAD_BUDGET = ORAD_BUDGET
DGO%LCOEF = OCOEF
DGO%LSURF_VARS = OSURF_VARS
!
SV%NBEQ = KBEQ
!
DGO%LSURF_BUDGETC = .FALSE.
IF (.NOT.DGO%LRESET_BUDGETC) DGO%LSURF_BUDGETC = .TRUE.
!
IF (U%CSEA   =='SEAFLX') CALL FLAG_SEA_UPDATE(KBEQ, ODIAG_OCEAN, ODIAG_MISC_SEAICE, &
                                              DGO%LSURF_BUDGETC, DGO%LRAD_BUDGET, K2M)
IF (U%CWATER =='FLAKE ') CALL FLAG_FLAKE_UPDATE(KBEQ, OWATER_PROFILE, DGO%LSURF_BUDGETC, DGO%LRAD_BUDGET, K2M)
IF (U%CWATER =='WATFLX') CALL FLAG_WATER_UPDATE(KBEQ, DGO%LSURF_BUDGETC, DGO%LRAD_BUDGET, K2M)
IF (U%CNATURE=='ISBA  ') CALL FLAG_ISBA_UPDATE(KBEQ, KDSTEQ, OSURF_EVAP_BUDGET, OFLOOD, &
                                    OPGD_ISBA, OCH_NO_FLUX_ISBA, OSURF_MISC_BUDGET_ISBA,&
                                    DGO%LSURF_BUDGETC, DGO%LRAD_BUDGET, K2M)
IF (U%CTOWN  =='TEB   ') CALL FLAG_TEB_UPDATE(KBEQ, OPGD_TEB, OSURF_MISC_BUDGET_TEB, DGO%LRAD_BUDGET, K2M)
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE',1,ZHOOK_HANDLE)
!-------------------------------------------------------------------------------
CONTAINS
!
SUBROUTINE FLAG_SEA_UPDATE(KBEQ, ODIAG_OCEAN, ODIAG_MISC_SEAICE, OSURF_BUDGETC, ORAD_BUDGET, K2M)
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KBEQ
LOGICAL, INTENT(IN) :: ODIAG_OCEAN
LOGICAL, INTENT(IN) :: ODIAG_MISC_SEAICE
LOGICAL, INTENT(IN) :: OSURF_BUDGETC
LOGICAL, INTENT(IN) :: ORAD_BUDGET
INTEGER, INTENT(IN) :: K2M
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_SEA_UPDATE',0,ZHOOK_HANDLE)
SM%CHS%SVS%NBEQ = KBEQ
SM%SD%GO%LDIAG_OCEAN = ODIAG_OCEAN
SM%SD%DMI%LDIAG_MISC_SEAICE = ODIAG_MISC_SEAICE
SM%SD%O%LSURF_BUDGETC = OSURF_BUDGETC
SM%SD%O%LRAD_BUDGET = ORAD_BUDGET
SM%SD%O%N2M = K2M
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_SEA_UPDATE',1,ZHOOK_HANDLE)
!
END SUBROUTINE FLAG_SEA_UPDATE
!
SUBROUTINE FLAG_WATER_UPDATE(KBEQ, OSURF_BUDGETC, ORAD_BUDGET, K2M)
!
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KBEQ
LOGICAL, INTENT(IN) :: OSURF_BUDGETC
LOGICAL, INTENT(IN) :: ORAD_BUDGET
INTEGER, INTENT(IN) :: K2M
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_WATER_UPDATE',0,ZHOOK_HANDLE)
WM%CHW%SVW%NBEQ = KBEQ
WM%DWO%LSURF_BUDGETC = OSURF_BUDGETC
WM%DWO%LRAD_BUDGET = ORAD_BUDGET
WM%DWO%N2M = K2M
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_WATER_UPDATE',1,ZHOOK_HANDLE)
!
END SUBROUTINE FLAG_WATER_UPDATE
!
SUBROUTINE FLAG_FLAKE_UPDATE(KBEQ, OWATER_PROFILE, OSURF_BUDGETC, ORAD_BUDGET, K2M)
!
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KBEQ
LOGICAL, INTENT(IN) :: OWATER_PROFILE
LOGICAL, INTENT(IN) :: OSURF_BUDGETC
LOGICAL, INTENT(IN) :: ORAD_BUDGET
INTEGER, INTENT(IN) :: K2M
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_FLAKE_UPDATE',0,ZHOOK_HANDLE)
FM%CHF%SVF%NBEQ = KBEQ
FM%DMF%LWATER_PROFILE = OWATER_PROFILE
FM%DFO%LSURF_BUDGETC = OSURF_BUDGETC
FM%DFO%LRAD_BUDGET = ORAD_BUDGET
FM%DFO%N2M = K2M
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_FLAKE_UPDATE',1,ZHOOK_HANDLE)
!
END SUBROUTINE FLAG_FLAKE_UPDATE
!
!
SUBROUTINE FLAG_ISBA_UPDATE(KBEQ, KDSTEQ, OSURF_EVAP_BUDGET, OFLOOD, &
                            OPGD, OCH_NO_FLUX, OSURF_MISC_BUDGET, &
                            OSURF_BUDGETC, ORAD_BUDGET, K2M)
!
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KBEQ
INTEGER, INTENT(IN) :: KDSTEQ
LOGICAL, INTENT(IN) :: OSURF_EVAP_BUDGET
LOGICAL, INTENT(IN) :: OFLOOD
LOGICAL, INTENT(IN) :: OPGD
LOGICAL, INTENT(IN) :: OCH_NO_FLUX
LOGICAL, INTENT(IN) :: OSURF_MISC_BUDGET
LOGICAL, INTENT(IN) :: OSURF_BUDGETC
LOGICAL, INTENT(IN) :: ORAD_BUDGET
INTEGER, INTENT(IN) :: K2M
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_ISBA_UPDATE',0,ZHOOK_HANDLE)
IM%CHI%SVI%NBEQ = KBEQ
IM%CHI%SVI%NDSTEQ = KDSTEQ
IM%ID%DE%LSURF_EVAP_BUDGET = OSURF_EVAP_BUDGET
IM%O%LFLOOD = OFLOOD
IM%ID%O%LPGD = OPGD
IM%CHI%LCH_NO_FLUX = OCH_NO_FLUX
IM%ID%DM%LSURF_MISC_BUDGET = OSURF_MISC_BUDGET
IM%ID%O%LSURF_BUDGETC = OSURF_BUDGETC
IM%ID%O%LPATCH_BUDGET = OSURF_BUDGETC
IM%ID%O%LRAD_BUDGET = ORAD_BUDGET
IM%ID%O%N2M = K2M
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_ISBA_UPDATE',1,ZHOOK_HANDLE)
!
END SUBROUTINE FLAG_ISBA_UPDATE
!
SUBROUTINE FLAG_TEB_UPDATE(KBEQ, OPGD, OSURF_MISC_BUDGET, ORAD_BUDGET, K2M)
!
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KBEQ
LOGICAL, INTENT(IN) :: OPGD
LOGICAL, INTENT(IN) :: OSURF_MISC_BUDGET
LOGICAL, INTENT(IN) :: ORAD_BUDGET
INTEGER, INTENT(IN) :: K2M
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_TEB_UPDATE',0,ZHOOK_HANDLE)
TM%CHT%SVT%NBEQ = KBEQ
TM%TD%O%LPGD = OPGD
TM%TD%MTO%LSURF_MISC_BUDGET = OSURF_MISC_BUDGET
TM%TD%O%LRAD_BUDGET = ORAD_BUDGET
TM%TD%O%N2M = K2M
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_TEB_UPDATE',1,ZHOOK_HANDLE)
!
END SUBROUTINE FLAG_TEB_UPDATE
!
END SUBROUTINE FLAG_DIAG_UPDATE

