!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     ######spl
      SUBROUTINE DIAG_MISC_TEB_INIT_n (DMTC, DMT, DMTO, TOP, KLU, KSW)
!     #####################
!
!!****  *DIAG_MISC_TEB_INIT_n* - routine to initialize TEB diagnostic variables
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004 
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DIAG_MISC_TEB_n, ONLY : DIAG_MISC_TEB_t
USE MODD_DIAG_MISC_TEB_OPTIONS_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODD_SURF_PAR,   ONLY : XUNDEF
USE MODD_TYPE_DATE_SURF
!


!
USE MODI_READ_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DMTC
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DMT
TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DMTO
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
INTEGER, INTENT(IN) :: KLU   ! size of arrays
INTEGER, INTENT(IN) :: KSW   ! spectral bands
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YREC           ! Name of the article to be read
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!* surface energy budget
!
IF (LHOOK) CALL DR_HOOK('DIAG_MISC_TEB_INIT_N',0,ZHOOK_HANDLE)
!
!* miscellaneous fields
!
!IF (DMTO%LSURF_MISC_BUDGET) THEN
  ALLOCATE(DMT%XQF_BLD           (KLU))
  ALLOCATE(DMT%XFLX_BLD          (KLU))
  ALLOCATE(DMT%XQF_TOWN          (KLU))
  ALLOCATE(DMT%XDQS_TOWN         (KLU))
  ALLOCATE(DMT%XRN_ROAD          (KLU))
  ALLOCATE(DMT%XH_ROAD           (KLU))
  ALLOCATE(DMT%XLE_ROAD          (KLU))
  ALLOCATE(DMT%XGFLUX_ROAD       (KLU))
  ALLOCATE(DMT%XRN_WALL_A        (KLU))
  ALLOCATE(DMT%XH_WALL_A         (KLU))
  ALLOCATE(DMT%XGFLUX_WALL_A     (KLU))
  ALLOCATE(DMT%XRN_WALL_B        (KLU))
  ALLOCATE(DMT%XH_WALL_B         (KLU))
  ALLOCATE(DMT%XGFLUX_WALL_B     (KLU))
  ALLOCATE(DMT%XRN_ROOF          (KLU))
  ALLOCATE(DMT%XH_ROOF           (KLU))
  ALLOCATE(DMT%XLE_ROOF          (KLU))
  ALLOCATE(DMT%XGFLUX_ROOF       (KLU))
  ALLOCATE(DMT%XRN_BLT           (KLU))
  ALLOCATE(DMT%XH_BLT            (KLU))
  ALLOCATE(DMT%XLE_BLT           (KLU))
  ALLOCATE(DMT%XGFLUX_BLT        (KLU))
  ALLOCATE(DMT%XRN_STRLROOF      (KLU))
  ALLOCATE(DMT%XH_STRLROOF       (KLU))
  ALLOCATE(DMT%XLE_STRLROOF      (KLU))
  ALLOCATE(DMT%XGFLUX_STRLROOF   (KLU))
  ALLOCATE(DMT%XG_GREENROOF_ROOF (KLU))
  ALLOCATE(DMT%XRUNOFF_TOWN      (KLU))
  ALLOCATE(DMT%XRUNOFF_ROAD      (KLU))
  ALLOCATE(DMT%XRUNOFF_STRLROOF  (KLU))
  ALLOCATE(DMT%XRUNOFF_ROOF      (KLU))
  ALLOCATE(DMT%XIRRIG_GREENROOF  (KLU))
  ALLOCATE(DMT%XIRRIG_GARDEN     (KLU))
  ALLOCATE(DMT%XIRRIG_ROAD       (KLU))
  !
  ALLOCATE(DMT%XABS_SW_ROOF      (KLU))
  ALLOCATE(DMT%XABS_SW_SNOW_ROOF (KLU))
  ALLOCATE(DMT%XABS_LW_ROOF      (KLU))
  ALLOCATE(DMT%XABS_LW_SNOW_ROOF (KLU))
  ALLOCATE(DMT%XABS_SW_ROAD      (KLU))
  ALLOCATE(DMT%XABS_SW_SNOW_ROAD (KLU))
  ALLOCATE(DMT%XABS_LW_ROAD      (KLU))
  ALLOCATE(DMT%XABS_LW_SNOW_ROAD (KLU))
  ALLOCATE(DMT%XABS_SW_WALL_A    (KLU))
  ALLOCATE(DMT%XABS_SW_WALL_B    (KLU))
  ALLOCATE(DMT%XABS_LW_WALL_A    (KLU))
  ALLOCATE(DMT%XABS_LW_WALL_B    (KLU))
  ALLOCATE(DMT%XABS_SW_GARDEN    (KLU))
  ALLOCATE(DMT%XABS_LW_GARDEN    (KLU))
  ALLOCATE(DMT%XABS_SW_GREENROOF (KLU))
  ALLOCATE(DMT%XABS_LW_GREENROOF (KLU))
  !
  ALLOCATE(DMT%XREF_SW_FAC       (KLU))  
  ALLOCATE(DMT%XREF_SW_GRND      (KLU))
  !
  ALLOCATE(DMT%XEMIT_LW_FAC      (KLU))
  ALLOCATE(DMT%XEMIT_LW_GRND     (KLU))
  !
  ALLOCATE(DMT%XTCOOL_TARGET (KLU))
  ALLOCATE(DMT%XTHEAT_TARGET (KLU))
  ALLOCATE(DMT%XQIN          (KLU))
  !
  IF (TOP%CBEM=='BEM') THEN
    ALLOCATE(DMT%XH_BLD_COOL    (KLU))
    ALLOCATE(DMT%XT_BLD_COOL    (KLU))
    ALLOCATE(DMT%XH_BLD_HEAT    (KLU))
    ALLOCATE(DMT%XLE_BLD_COOL   (KLU))
    ALLOCATE(DMT%XLE_BLD_HEAT   (KLU))
    ALLOCATE(DMT%XH_WASTE       (KLU))
    ALLOCATE(DMT%XLE_WASTE      (KLU))
    ALLOCATE(DMT%XHVAC_COOL     (KLU))
    ALLOCATE(DMT%XHVAC_HEAT     (KLU))
    ALLOCATE(DMT%XCAP_SYS       (KLU))
    ALLOCATE(DMT%XM_SYS         (KLU))
    ALLOCATE(DMT%XCOP           (KLU))
    ALLOCATE(DMT%XQ_SYS         (KLU))
    ALLOCATE(DMT%XT_SYS         (KLU))
    ALLOCATE(DMT%XTR_SW_WIN     (KLU))
    ALLOCATE(DMT%XFAN_POWER     (KLU))
    ALLOCATE(DMT%XT_RAD_IND     (KLU))
    ALLOCATE(DMT%XHU_BLD        (KLU))
    ALLOCATE(DMT%XABS_SW_WIN    (KLU)) 
    ALLOCATE(DMT%XABS_LW_WIN    (KLU))    
  ENDIF
  !
  IF (TOP%LSOLAR_PANEL) THEN
    ALLOCATE(DMT%XABS_SW_PANEL   (KLU))
    ALLOCATE(DMT%XABS_LW_PANEL   (KLU))
    ALLOCATE(DMT%XRN_PANEL       (KLU))
    ALLOCATE(DMT%XH_PANEL        (KLU))
    ALLOCATE(DMT%XTHER_PROD_PANEL(KLU))
    ALLOCATE(DMT%XPHOT_PROD_PANEL(KLU))
    ALLOCATE(DMT%XPROD_PANEL     (KLU))
    ALLOCATE(DMT%XTHER_PROD_BLD  (KLU))
    ALLOCATE(DMT%XPHOT_PROD_BLD  (KLU))
  END IF
  !
    ALLOCATE(DMTC%XRUNOFF_TOWN      (KLU))
    ALLOCATE(DMTC%XIRRIG_GARDEN     (KLU))
    ALLOCATE(DMTC%XRUNOFF_ROAD      (KLU))
    ALLOCATE(DMTC%XIRRIG_ROAD       (KLU))
    ALLOCATE(DMTC%XRUNOFF_STRLROOF  (KLU))
    ALLOCATE(DMTC%XRUNOFF_ROOF      (KLU))
    ALLOCATE(DMTC%XIRRIG_GREENROOF  (KLU))
    IF (TOP%CBEM=='BEM') THEN
      ALLOCATE(DMTC%XHVAC_COOL       (KLU))
      ALLOCATE(DMTC%XHVAC_HEAT       (KLU))
    END IF
  IF (TOP%LSOLAR_PANEL) THEN
    ALLOCATE(DMTC%XTHER_PROD_BLD(KLU))
    ALLOCATE(DMTC%XPHOT_PROD_BLD(KLU))
  END IF
  DMT%XQF_BLD            = XUNDEF
  DMT%XFLX_BLD           = XUNDEF
  DMT%XQF_TOWN           = XUNDEF
  DMT%XDQS_TOWN          = XUNDEF
  DMT%XRN_ROAD           = XUNDEF
  DMT%XH_ROAD            = XUNDEF
  DMT%XLE_ROAD           = XUNDEF
  DMT%XGFLUX_ROAD        = XUNDEF
  DMT%XRN_WALL_A         = XUNDEF
  DMT%XH_WALL_A          = XUNDEF
  DMT%XGFLUX_WALL_A      = XUNDEF
  DMT%XRN_WALL_B         = XUNDEF
  DMT%XH_WALL_B          = XUNDEF
  DMT%XGFLUX_WALL_B      = XUNDEF
  DMT%XRN_ROOF           = XUNDEF
  DMT%XH_ROOF            = XUNDEF
  DMT%XLE_ROOF           = XUNDEF
  DMT%XGFLUX_ROOF        = XUNDEF 
  DMT%XRN_BLT            = XUNDEF
  DMT%XH_BLT             = XUNDEF
  DMT%XLE_BLT            = XUNDEF
  DMT%XGFLUX_BLT         = XUNDEF  
  DMT%XRN_STRLROOF       = XUNDEF
  DMT%XH_STRLROOF        = XUNDEF
  DMT%XLE_STRLROOF       = XUNDEF
  DMT%XGFLUX_STRLROOF    = XUNDEF  
  DMT%XG_GREENROOF_ROOF  = XUNDEF  
  DMT%XRUNOFF_TOWN       = XUNDEF  
  DMT%XRUNOFF_ROAD       = XUNDEF  
  DMT%XRUNOFF_ROOF       = XUNDEF  
  DMT%XRUNOFF_STRLROOF   = XUNDEF
  DMT%XIRRIG_GREENROOF   = XUNDEF  
  DMT%XIRRIG_GARDEN      = XUNDEF  
  DMT%XIRRIG_ROAD        = XUNDEF  
!
  DMT%XABS_SW_ROOF       = XUNDEF  
  DMT%XABS_SW_SNOW_ROOF  = XUNDEF  
  DMT%XABS_LW_ROOF       = XUNDEF  
  DMT%XABS_LW_SNOW_ROOF  = XUNDEF  
  DMT%XABS_SW_ROAD       = XUNDEF  
  DMT%XABS_SW_SNOW_ROAD  = XUNDEF  
  DMT%XABS_LW_ROAD       = XUNDEF  
  DMT%XABS_LW_SNOW_ROAD  = XUNDEF  
  DMT%XABS_SW_WALL_A     = XUNDEF  
  DMT%XABS_SW_WALL_B     = XUNDEF  
  DMT%XABS_LW_WALL_A     = XUNDEF  
  DMT%XABS_LW_WALL_B     = XUNDEF  
  DMT%XABS_SW_GARDEN     = XUNDEF  
  DMT%XABS_LW_GARDEN     = XUNDEF 
  DMT%XABS_SW_GREENROOF  = XUNDEF  
  DMT%XABS_LW_GREENROOF  = XUNDEF 
  !
  DMT%XREF_SW_FAC        = XUNDEF
  DMT%XREF_SW_GRND       = XUNDEF
  !
  DMT%XEMIT_LW_FAC       = XUNDEF
  DMT%XEMIT_LW_GRND      = XUNDEF
  !
  DMT%XTCOOL_TARGET  = XUNDEF
  DMT%XTHEAT_TARGET  = XUNDEF
  DMT%XQIN           = XUNDEF
  !
  IF (TOP%CBEM=='BEM') THEN
    DMT%XH_BLD_COOL     = XUNDEF
    DMT%XT_BLD_COOL     = XUNDEF
    DMT%XH_BLD_HEAT     = XUNDEF
    DMT%XLE_BLD_COOL    = XUNDEF
    DMT%XLE_BLD_HEAT    = XUNDEF
    DMT%XH_WASTE        = XUNDEF
    DMT%XLE_WASTE       = XUNDEF
    DMT%XHVAC_COOL      = XUNDEF
    DMT%XHVAC_HEAT      = XUNDEF
    DMT%XCAP_SYS        = XUNDEF
    DMT%XM_SYS          = XUNDEF
    DMT%XCOP            = XUNDEF
    DMT%XQ_SYS          = XUNDEF
    DMT%XT_SYS          = XUNDEF
    DMT%XTR_SW_WIN      = XUNDEF
    DMT%XFAN_POWER      = XUNDEF
    DMT%XT_RAD_IND      = XUNDEF
    DMT%XHU_BLD         = XUNDEF
    DMT%XABS_SW_WIN     = XUNDEF 
    DMT%XABS_LW_WIN     = XUNDEF    
  ENDIF

  IF (TOP%LSOLAR_PANEL) THEN
    DMT%XABS_SW_PANEL   = XUNDEF
    DMT%XABS_LW_PANEL   = XUNDEF
    DMT%XRN_PANEL       = XUNDEF
    DMT%XH_PANEL        = XUNDEF
    DMT%XTHER_PROD_PANEL= XUNDEF
    DMT%XPHOT_PROD_PANEL= XUNDEF
    DMT%XPROD_PANEL     = XUNDEF
    DMT%XTHER_PROD_BLD  = XUNDEF
    DMT%XPHOT_PROD_BLD  = XUNDEF
  END IF
!  
    DMTC%XRUNOFF_TOWN       = 0.0  
    DMTC%XRUNOFF_ROAD       = 0.0  
    DMTC%XRUNOFF_ROOF       = 0.0  
    DMTC%XRUNOFF_STRLROOF   = 0.0  
    DMTC%XIRRIG_GREENROOF   = 0.0  
    DMTC%XIRRIG_GARDEN      = 0.0  
    DMTC%XIRRIG_ROAD        = 0.0  
    IF (TOP%CBEM=='BEM') THEN
      DMTC%XHVAC_COOL       = 0.0
      DMTC%XHVAC_HEAT       = 0.0
    END IF
  IF (TOP%LSOLAR_PANEL) THEN
    DMTC%XTHER_PROD_BLD = 0.
    DMTC%XPHOT_PROD_BLD = 0.
  END IF
!ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_MISC_TEB_INIT_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_MISC_TEB_INIT_n
