!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE DIAG_ISBA_INIT_n (CHI, DE, DEC, NDE, NDEC, DGO, D, DC, ND, NDC, DM, NDM, &
                                   OREAD_BUDGETC, NGB, GB, IO, NP, HSNOW_SCHEME, KSNOW_NLAYER, &
                                   KABC, HPROGRAM,KLU,KSW)
!     #####################
!
!!****  *DIAG_ISBA_INIT_n* - routine to initialize ISBA-AGS diagnostic variables
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2003 
!!      modified    11/2003 by P. LeMoigne: surface cumulated energy budget
!!      modified    10/2004 by P. LeMoigne: surface miscellaneous fields
!!      B. Decharme    2008    New diag for water budget and allow to reset
!                               cumulatives variables at the beginning of a run
!!      B. Decharme 06/2009    add patch budget switch 
!!      B. Decharme 08/2009    add cummulative diag
!!      A.L. Gibelin 04/2009 : Add respiration diagnostics
!!      A.L. Gibelin 05/2009 : Add carbon spinup
!!      A.L. Gibelin 07/2009 : Suppress RDK and transform GPP as a diagnostic
!!      B. Decharme  05/12   : Carbon fluxes in diag_evap
!!      B. Decharme  10/12     Isba water budget diag
!!      B. Decharme  10/12     New diag for DIF:
!!                             F2 stress
!!                             Root zone swi, wg and wgi
!!                             swi, wg and wgi comparable to ISBA-FR-DG2 and DG3 layers
!!                             active layer thickness over permafrost
!!                             frozen layer thickness over non-permafrost
!!      B. Vincendon 02/2014 : condition added for RAD_BUDGET variables (needed for
!!                             restart mode)
!       B. decharme 04/2013 : Add new diag for coupling
!                             Delete XTSRAD (because same than XTSRAD_NAT)
!!      P. Samuelsson 10/2014: MEB
!-------------------------------------------------------------------------------
!
!*       0.0    DECLARATIONS
!              ------------
!
USE MODE_DIAG
!
USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t, DIAG_EVAP_ISBA_NP_t
USE MODD_DIAG_n, ONLY : DIAG_t, DIAG_NP_t, DIAG_OPTIONS_t
USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_t, DIAG_MISC_ISBA_NP_t
USE MODD_GR_BIOG_n, ONLY : GR_BIOG_NP_t, GR_BIOG_t
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
USE MODD_ISBA_n, ONLY : ISBA_NP_t, ISBA_P_t
!
#ifdef SFX_OL
USE MODN_IO_OFFLINE,     ONLY : LRESTART
#endif
USE MODD_SURF_PAR,       ONLY : XUNDEF
USE MODD_TYPE_DATE_SURF
USE MODD_AGRI,           ONLY : LAGRIP
!
USE MODI_PACK_SAME_RANK
USE MODI_MAKE_CHOICE_ARRAY
USE MODI_READ_SURF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.01   Declarations of arguments
!              -------------------------
!
TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DE
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DEC
TYPE(DIAG_EVAP_ISBA_NP_t), INTENT(INOUT) :: NDE
TYPE(DIAG_EVAP_ISBA_NP_t), INTENT(INOUT) :: NDEC
TYPE(DIAG_OPTIONS_t), INTENT(IN) :: DGO
TYPE(DIAG_t), INTENT(INOUT) :: D
TYPE(DIAG_t), INTENT(INOUT) :: DC
TYPE(DIAG_NP_t), INTENT(INOUT) :: ND
TYPE(DIAG_NP_t), INTENT(INOUT) :: NDC
TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DM
TYPE(DIAG_MISC_ISBA_NP_t), INTENT(INOUT) :: NDM
LOGICAL, INTENT(IN) :: OREAD_BUDGETC
TYPE(GR_BIOG_NP_t), INTENT(INOUT) :: NGB
TYPE(GR_BIOG_t), INTENT(INOUT) :: GB
TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
TYPE(ISBA_NP_t), INTENT(INOUT) :: NP
 CHARACTER(LEN=*), INTENT(IN) :: HSNOW_SCHEME
INTEGER, INTENT(IN) :: KSNOW_NLAYER
!
INTEGER, INTENT(IN) :: KABC
!
INTEGER, INTENT(IN)         :: KLU       ! size of arrays
INTEGER, INTENT(IN)         :: KSW       ! spectral bands
 CHARACTER(LEN=6), INTENT(IN):: HPROGRAM  ! program calling
!
!*       0.02   Declarations of local variables
!              -------------------------------
!
TYPE(DIAG_OPTIONS_t) :: YDO
TYPE(DIAG_EVAP_ISBA_t) :: YDE
TYPE(DIAG_MISC_ISBA_t) :: YDM
TYPE(ISBA_P_t), POINTER :: PK
REAL, DIMENSION(:,:), ALLOCATABLE :: ZWORK
LOGICAL :: GCUMUL, GDIM, GDIM2
INTEGER :: JP
INTEGER           :: IVERSION, IBUG
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
INTEGER           :: ISIZE_LMEB_PATCH   ! Number of patches where multi-energy balance should be applied
 CHARACTER(LEN=12) :: YREC           ! Name of the article to be read
 CHARACTER(LEN=6) :: YREC2
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!////////////////NOT CUMULATED DIAGNOSTICS//////////////////////////////
!
!* surface energy budget
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N',0,ZHOOK_HANDLE)
!
ISIZE_LMEB_PATCH=COUNT(IO%LMEB_PATCH(:))
!
YDO%LSURF_BUDGET = .TRUE.
YDO%N2M = 1
YDO%LCOEF = .TRUE.
YDO%LSURF_VARS = .TRUE.
!
YDE%LSURF_EVAP_BUDGET = .TRUE.
!
YDM%LSURF_MISC_BUDGET = .TRUE.
!
 CALL ALLOC_BUD(YDO,D,KLU,KSW)
!
DO JP = 1,IO%NPATCH
  CALL ALLOC_BUD(YDO,ND%AL(JP),NP%AL(JP)%NSIZE_P,KSW)
  !
  ALLOCATE(ND%AL(JP)%XCDN(NP%AL(JP)%NSIZE_P))
  ALLOCATE(ND%AL(JP)%XHUG(NP%AL(JP)%NSIZE_P))
  ALLOCATE(ND%AL(JP)%XHU (NP%AL(JP)%NSIZE_P))
  !
  ND%AL(JP)%XCDN = XUNDEF
  ND%AL(JP)%XHUG = XUNDEF
  ND%AL(JP)%XHU  = XUNDEF
  !
ENDDO
!
IF (YDO%LSURF_BUDGET) THEN
  !
  ALLOCATE(D%XEVAP(KLU))
  ALLOCATE(D%XSUBL(KLU))
  D%XEVAP    = XUNDEF
  D%XSUBL    = XUNDEF
  !  
  DO JP = 1,IO%NPATCH
    ALLOCATE(ND%AL(JP)%XEVAP(NP%AL(JP)%NSIZE_P))
    ALLOCATE(ND%AL(JP)%XSUBL(NP%AL(JP)%NSIZE_P))  
    ND%AL(JP)%XEVAP = XUNDEF
    ND%AL(JP)%XSUBL = XUNDEF
  ENDDO
  !
ELSE
  !
  ALLOCATE(D%XEVAP(0))
  ALLOCATE(D%XSUBL(0))
  !  
  DO JP = 1,IO%NPATCH
    ALLOCATE(ND%AL(JP)%XEVAP(0))
    ALLOCATE(ND%AL(JP)%XSUBL(0))     
  ENDDO
  !
END IF
!
IF (YDO%N2M>=1) THEN
  !
  ALLOCATE(D%XSFCO2(KLU))
  D%XSFCO2 = XUNDEF
  DO JP = 1,IO%NPATCH
    ALLOCATE(ND%AL(JP)%XSFCO2(NP%AL(JP)%NSIZE_P))
    ND%AL(JP)%XSFCO2 = XUNDEF
  ENDDO
  !
ELSE
  !
  ALLOCATE(D%XSFCO2(0))
  DO JP=1,IO%NPATCH
    ALLOCATE(ND%AL(JP)%XSFCO2(0))
  ENDDO
  !
END IF
!
!* transfer coefficients
!
DO JP=1,IO%NPATCH
  ALLOCATE(ND%AL(JP)%XZ0EFF(NP%AL(JP)%NSIZE_P))
  ND%AL(JP)%XZ0EFF = XUNDEF
ENDDO
!
IF (YDO%LCOEF) THEN
  !
  ALLOCATE(D%XZ0EFF(KLU))
  D%XZ0EFF = XUNDEF  
  !
ELSE
  !
  ALLOCATE(D%XZ0EFF(0))
  !
END IF
!
!
!* surface temperature and parameters at 2m
!
ALLOCATE(D%XALBT(KLU))
D%XALBT = XUNDEF
DO JP=1,IO%NPATCH
  ALLOCATE(ND%AL(JP)%XTS    (NP%AL(JP)%NSIZE_P))
  ALLOCATE(ND%AL(JP)%XALBT  (NP%AL(JP)%NSIZE_P))
  ALLOCATE(ND%AL(JP)%XTSRAD (NP%AL(JP)%NSIZE_P))
  ND%AL(JP)%XTS    = XUNDEF
  ND%AL(JP)%XTSRAD = XUNDEF
  ND%AL(JP)%XALBT  = XUNDEF
ENDDO
!
!* detailed surface energy budget
!
IF (YDE%LSURF_EVAP_BUDGET) THEN
  ! 
  CALL ALLOC_EVAP_BUD(DE,KLU,0)
  DO JP = 1,IO%NPATCH
    CALL ALLOC_EVAP_BUD(NDE%AL(JP),NP%AL(JP)%NSIZE_P,NP%AL(JP)%NSIZE_P)
  ENDDO
  !
  IF (ISIZE_LMEB_PATCH>0) THEN
    !
    CALL ALLOC_MEB_BUD(DE,KLU)
    DO JP = 1,IO%NPATCH
      CALL ALLOC_MEB_BUD(NDE%AL(JP),NP%AL(JP)%NSIZE_P)
    ENDDO
    !
  ENDIF
  !
  IF(IO%LGLACIER)THEN
    ALLOCATE(DE%XICEFLUX(KLU))
    DE%XICEFLUX(:) = XUNDEF
    DO JP=1,IO%NPATCH
      ALLOCATE(NDE%AL(JP)%XICEFLUX(NP%AL(JP)%NSIZE_P))
      NDE%AL(JP)%XICEFLUX(:) = XUNDEF
    ENDDO
  ENDIF
  !  
  IF(DE%LWATER_BUDGET)THEN
    !      
    ALLOCATE(DE%XRAINFALL  (KLU))
    ALLOCATE(DE%XSNOWFALL  (KLU))
    DE%XRAINFALL   = XUNDEF
    DE%XSNOWFALL   = XUNDEF    
    !
    CALL ALLOC_WATER_BUD(DE,KLU)
    DO JP=1,IO%NPATCH
      CALL ALLOC_WATER_BUD(NDE%AL(JP),NP%AL(JP)%NSIZE_P)
    ENDDO
    ! 
  ENDIF
  !
ELSE
  !
  CALL ALLOC_EVAP_BUD(DE,0,0)
  DO JP=1,IO%NPATCH
    CALL ALLOC_EVAP_BUD(NDE%AL(JP),0,0)
  ENDDO
  !
ENDIF
!
IF (.NOT. YDE%LSURF_EVAP_BUDGET .OR. .NOT.DE%LWATER_BUDGET) THEN
  !
  ALLOCATE(DE%XRAINFALL  (0))
  ALLOCATE(DE%XSNOWFALL  (0))
  !
  CALL ALLOC_WATER_BUD(DE,0)
  DO JP=1,IO%NPATCH
    CALL ALLOC_WATER_BUD(NDE%AL(JP),0)
  ENDDO
  !
ENDIF
!
IF (.NOT.YDE%LSURF_EVAP_BUDGET .OR. ISIZE_LMEB_PATCH<=0) THEN
  !
  CALL ALLOC_MEB_BUD(DE,0)
  DO JP=1,IO%NPATCH
    CALL ALLOC_MEB_BUD(NDE%AL(JP),0)
  ENDDO
  ! 
END IF
!
IF(.NOT.YDE%LSURF_EVAP_BUDGET .OR. .NOT.IO%LGLACIER)THEN
  ALLOCATE(DE%XICEFLUX(0))
  DO JP=1,IO%NPATCH
    ALLOCATE(NDE%AL(JP)%XICEFLUX(0))
  ENDDO
ENDIF
!
!////////////////CUMULATED DIAGNOSTICS//////////////////////////////
!
!* surface cumulated energy budget
!
#ifdef SFX_OL
GCUMUL = (DGO%LSURF_BUDGETC .OR. (LRESTART .AND. .NOT.DGO%LRESET_BUDGETC))
#else
GCUMUL = (DGO%LSURF_BUDGETC .OR. .NOT.DGO%LRESET_BUDGETC)
#endif
!
IF ( GCUMUL ) THEN
  !
  !///////////////////////ALLOCATIONS//////////////////////
  !
  CALL ALLOC_EVAP_BUD(DEC,KLU,0)
  DO JP=1,IO%NPATCH
    CALL ALLOC_EVAP_BUD(NDEC%AL(JP),NP%AL(JP)%NSIZE_P,0)
  ENDDO
    !
  IF (ISIZE_LMEB_PATCH>0) THEN
    !
    CALL ALLOC_MEB_BUD(DEC,KLU)
    DO JP=1,IO%NPATCH
      CALL ALLOC_MEB_BUD(NDEC%AL(JP),NP%AL(JP)%NSIZE_P)
    ENDDO
    !
  ENDIF
  !
  CALL ALLOC_SURF_BUD(DC,0,KLU,0)
  ALLOCATE(DC%XEVAP(KLU))
  ALLOCATE(DC%XSUBL(KLU))
  DC%XEVAP    = XUNDEF
  DC%XSUBL    = XUNDEF  
  DO JP=1,IO%NPATCH
    CALL ALLOC_SURF_BUD(NDC%AL(JP),0,NP%AL(JP)%NSIZE_P,0)
    ALLOCATE(NDC%AL(JP)%XEVAP(NP%AL(JP)%NSIZE_P))
    ALLOCATE(NDC%AL(JP)%XSUBL(NP%AL(JP)%NSIZE_P))  
    NDC%AL(JP)%XEVAP = XUNDEF
    NDC%AL(JP)%XSUBL = XUNDEF 
  ENDDO
  !
  IF(IO%LGLACIER)THEN
    ALLOCATE(DEC%XICEFLUX(KLU))
    DO JP=1,IO%NPATCH
      ALLOCATE(NDEC%AL(JP)%XICEFLUX(NP%AL(JP)%NSIZE_P))
    ENDDO
  ENDIF
  !
#ifdef SFX_OL
  IF(DE%LWATER_BUDGET .OR. (LRESTART .AND. .NOT.DGO%LRESET_BUDGETC))THEN
#else
  IF(DE%LWATER_BUDGET .OR. .NOT.DGO%LRESET_BUDGETC)THEN
#endif          
    !      
    ALLOCATE(DEC%XRAINFALL  (KLU))
    ALLOCATE(DEC%XSNOWFALL  (KLU))
    !
    CALL ALLOC_WATER_BUD(DEC,KLU)
    DO JP=1,IO%NPATCH
      CALL ALLOC_WATER_BUD(NDEC%AL(JP),NP%AL(JP)%NSIZE_P)
    ENDDO
    !     
  ENDIF
  !
  !/////////////////INITIALISATIONS//////////////////////////
  !
  CALL INIT_EVAP_BUD(DEC)
  !
  IF (ISIZE_LMEB_PATCH>0) THEN
    !
    CALL INIT_MEB_BUD(DEC)
    !
  ENDIF
  !
  CALL INIT_SURF_BUD(DC,0.)
  DC%XEVAP = 0.
  DC%XSUBL = 0.
  !
  IF(IO%LGLACIER) DEC%XICEFLUX = 0.0
  !
  IF (.NOT.OREAD_BUDGETC .OR. (OREAD_BUDGETC.AND.DGO%LRESET_BUDGETC)) THEN
    !
    DO JP=1,IO%NPATCH
      CALL INIT_EVAP_BUD(NDEC%AL(JP))
    ENDDO
    !
    IF (ISIZE_LMEB_PATCH>0) THEN
      !
      DO JP=1,IO%NPATCH
        CALL INIT_MEB_BUD(NDEC%AL(JP))
      ENDDO
      !
    ENDIF
    !
    DO JP=1,IO%NPATCH
      CALL INIT_SURF_BUD(NDC%AL(JP),0.)
      NDC%AL(JP)%XEVAP = 0.
      NDC%AL(JP)%XSUBL = 0.        
    ENDDO
    !
    IF(IO%LGLACIER)THEN
       DO JP=1,IO%NPATCH
         NDEC%AL(JP)%XICEFLUX     = 0.0
       ENDDO
    ENDIF
    !
#ifdef SFX_OL
    IF(DE%LWATER_BUDGET .OR. (LRESTART .AND. .NOT.DGO%LRESET_BUDGETC))THEN
#else
    IF(DE%LWATER_BUDGET .OR. .NOT.DGO%LRESET_BUDGETC)THEN
#endif      
      !
      CALL INIT_WATER_BUD(DEC)
      DO JP=1,IO%NPATCH
        CALL INIT_WATER_BUD(NDEC%AL(JP))
      ENDDO
      !
      DEC%XRAINFALL   = 0.0
      DEC%XSNOWFALL   = 0.0
      !
    ENDIF
    !     
  ELSE
    !
    CALL READ_SURF(HPROGRAM,'VERSION',IVERSION,IRESP)
    CALL READ_SURF(HPROGRAM,'BUG ',IBUG,IRESP)
    !
    GDIM2 = (IVERSION>8 .OR. IVERSION==8 .AND. IBUG>0)
    GDIM = GDIM2
    IF (GDIM2) CALL READ_SURF(HPROGRAM,'SPLIT_PATCH',GDIM,IRESP)    
    !
#ifdef SFX_OL
    IF(DE%LWATER_BUDGET .OR. (LRESTART .AND. .NOT.DGO%LRESET_BUDGETC))THEN
#else
    IF(DE%LWATER_BUDGET .OR. .NOT.DGO%LRESET_BUDGETC)THEN
#endif     
      IF(IVERSION>7 .OR. IVERSION==7 .AND. IBUG>=3)THEN 
        YREC='RAINFC_ISBA'
        CALL READ_SURF(HPROGRAM,YREC,DEC%XRAINFALL,IRESP)
        YREC='SNOWFC_ISBA'
        CALL READ_SURF(HPROGRAM,YREC,DEC%XSNOWFALL,IRESP)
      ELSE
        DEC%XRAINFALL = 0.0
        DEC%XSNOWFALL = 0.0
      ENDIF
    ENDIF
    !
    IF(DGO%LPATCH_BUDGET .AND. IO%NPATCH>1)THEN
      !
      !
      IF (GDIM) THEN
        YREC2=''
      ELSEIF (IVERSION<7 .OR. IVERSION==7 .AND. IBUG<3) THEN
        YREC2='PATCH'
      ELSE
        YREC2='P'
      ENDIF
      !
      ALLOCATE(ZWORK(KLU,IO%NPATCH))
      !
      !/////////////EVAP PATCH/////////////////////////////
      !
      YREC='LEGC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLEG(:))
      ENDDO
      !
      YREC='LEGIC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLEGI(:))
      ENDDO    
      !
      YREC='LEVC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLEV(:))
      ENDDO
  
      !
      YREC='LESC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLES(:))
      ENDDO
      !
      IF(HSNOW_SCHEME=='3-L' .OR. HSNOW_SCHEME=='CRO')THEN
         IF(IVERSION>7 .OR. IVERSION==7 .AND. IBUG>=3)THEN
           !
           YREC='LESLC_'//YREC2
           CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
           DO JP = 1,IO%NPATCH
             CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLESL(:))
           ENDDO
           !
         ELSE
           !
           DO JP=1,IO%NPATCH
             NDEC%AL(JP)%XLESL(:) = 0.0
           ENDDO
           !
         ENDIF
         !
         IF(IVERSION>=8)THEN
           !
           YREC='SNDRIFC_'//YREC2
           CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
           DO JP = 1,IO%NPATCH
             CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XSNDRIFT(:))
           ENDDO
           !        
         ELSE
           !
           DO JP=1,IO%NPATCH
             NDEC%AL(JP)%XSNDRIFT(:) = 0.0
           ENDDO
           !         
         ENDIF  
         !    
      ELSE
        !
        DO JP=1,IO%NPATCH
          NDEC%AL(JP)%XLESL(:) = 0.0
          NDEC%AL(JP)%XSNDRIFT(:) = 0.0
        ENDDO
        !      
      ENDIF
      !
      YREC='LERC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLER(:))
      ENDDO
      !    
      YREC='LETRC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLETR(:))
      ENDDO 
      !    
      YREC='EVAPC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XEVAP(:))
      ENDDO
      !    
      IF (IVERSION<8)THEN
        DO JP=1,IO%NPATCH
          NDC%AL(JP)%XSUBL(:) = 0.0
        ENDDO           
      ELSE
        YREC='SUBLC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XSUBL(:))
        ENDDO      
      ENDIF   
      ! 
      YREC='DRAINC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XDRAIN(:))
      ENDDO   
      !      
      YREC='RUNOFFC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XRUNOFF(:))
      ENDDO   
      !      
      YREC='DRIVEGC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XDRIP(:))
      ENDDO
      !      
      YREC='RRVEGC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XRRVEG(:))
      ENDDO  
      !      
      YREC='SNOMLTC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XMELT(:))
      ENDDO          
      !
      IF (LAGRIP) THEN
        YREC='IRRIGC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XIRRIG_FLUX(:))
        ENDDO          
      ELSE
        DO JP=1,IO%NPATCH
          NDEC%AL(JP)%XIRRIG_FLUX(:) = 0.0
        ENDDO                 
      ENDIF
      !
      IF(IO%CPHOTO/='NON' .AND. (IVERSION>7 .OR. IVERSION==7 .AND. IBUG>=3))THEN
        YREC='GPPC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XGPP(:))
        ENDDO 
        !        
        YREC='RC_AUTO_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XRESP_AUTO(:))
        ENDDO
        !        
        YREC='RC_ECO_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XRESP_ECO(:))
        ENDDO         
      ELSE
        DO JP=1,IO%NPATCH
          NDEC%AL(JP)%XGPP(:) = 0.0
          NDEC%AL(JP)%XRESP_AUTO(:) = 0.0
          NDEC%AL(JP)%XRESP_ECO(:) = 0.0
        ENDDO                
      ENDIF      
      !
      IF((IO%CRUNOFF=='SGH'.AND.IO%CISBA=='DIF').AND.IVERSION>=8)THEN
        YREC='QSBC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XQSB(:))
        ENDDO
      ELSE
        DE%XQSB = 0.0
      ENDIF
      !
      IF(IO%CHORT=='SGH'.OR.IO%CISBA=='DIF')THEN
        YREC='HORTONC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XHORT(:))
        ENDDO          
      ELSE
        DO JP=1,IO%NPATCH
          NDEC%AL(JP)%XHORT(:) = 0.0
        ENDDO               
      ENDIF
      !
      IF(IO%LFLOOD)THEN
        YREC='IFLOODC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XIFLOOD(:))
        ENDDO 
        !        
        YREC='PFLOODC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XPFLOOD(:))
        ENDDO      
        !        
        YREC='LEFC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLE_FLOOD(:))
        ENDDO  
        !        
        YREC='LEIFC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLEI_FLOOD(:))
        ENDDO         
      ELSE
        DO JP=1,IO%NPATCH
          NDEC%AL(JP)%XIFLOOD(:) = 0.0
          NDEC%AL(JP)%XPFLOOD(:) = 0.0
          NDEC%AL(JP)%XLE_FLOOD(:) = 0.0
          NDEC%AL(JP)%XLEI_FLOOD(:) = 0.0
        ENDDO                
      ENDIF      
      ! 
      !       
      IF (ISIZE_LMEB_PATCH>0) THEN
        !
        YREC='LEV_CVC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLEV_CV(:))
        ENDDO
        !        
        YREC='LES_CVC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLES_CV(:))
        ENDDO   
        !       
        YREC='LETR_CVC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLETR_CV(:))
        ENDDO   
        !       
        YREC='LER_CVC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLER_CV(:))
        ENDDO
        !       
        YREC='LE_CVC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLE_CV(:))
        ENDDO
        !       
        YREC='H_CVC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XH_CV(:))
        ENDDO  
        !       
        YREC='MELT_CVC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XMELT_CV(:))
        ENDDO
        !        
        YREC='FRZ_CVC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XFRZ_CV(:))
        ENDDO        
        !     
        YREC='LE_GVC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLE_GV(:))
        ENDDO 
        !
        YREC='H_GVC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XH_GV(:))
        ENDDO  
        !      
        YREC='LE_GNC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLE_GN(:))
        ENDDO          
        !
        YREC='H_GNC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XH_GN(:))
        ENDDO  
        !       
        YREC='SR_GNC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XSR_GN(:))
        ENDDO  
        !        
        YREC='SWDN_GNC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XSWDOWN_GN(:))
        ENDDO  
        !        
        YREC='LWDN_GNC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLWDOWN_GN(:))
        ENDDO  
        !
        YREC='LE_CAC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLE_CA(:))
        ENDDO   
        !   
        YREC='H_CAC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XH_CA(:))
        ENDDO
        !          
        YREC='SWNT_VC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XSWNET_V(:))
        ENDDO  
        !        
        YREC='SWNT_GC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XSWNET_G(:))
        ENDDO
        !        
        YREC='SWNT_NC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XSWNET_N(:))
        ENDDO
        !        
        YREC='SWNT_NSC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XSWNET_NS(:))
        ENDDO 
        !        
        YREC='LWNT_VC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLWNET_V(:))
        ENDDO 
        !        
        YREC='LWNT_GC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLWNET_G(:))
        ENDDO
        !        
        YREC='LWNT_NC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XLWNET_N(:))
        ENDDO 
        !             
      ENDIF
      !
      YREC='RNC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XRN(:))
      ENDDO
      !
      YREC='HC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XH(:))
      ENDDO  
      !      
      YREC='LEC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XLE(:))
      ENDDO   
      !       
      YREC='LEIC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XLEI(:))
      ENDDO 
      !       
      YREC='GFLUXC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XGFLUX(:))
      ENDDO         
      !      
      IF (DGO%LRAD_BUDGET) THEN
        !
        YREC='SWDC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XSWD(:))
        ENDDO
        !
        YREC='SWUC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XSWU(:))
        ENDDO 
        !        
        YREC='LWDC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XLWD(:))
        ENDDO 
        !        
        YREC='LWUC_'//YREC2
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XLWU(:))
        ENDDO
        !        
      ENDIF
      !
      YREC='FMUC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XFMU(:))
      ENDDO
      !      
      YREC='FMVC_'//YREC2
      CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
      DO JP = 1,IO%NPATCH
        CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDC%AL(JP)%XFMV(:))
      ENDDO   
      !
      IF(IO%LGLACIER)THEN
        YREC='ICE_FC_'//YREC2 
        CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
        DO JP = 1,IO%NPATCH
          CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XICEFLUX(:))
        ENDDO   
      ENDIF
      !
      ! 
#ifdef SFX_OL
      IF(DE%LWATER_BUDGET .OR. (LRESTART .AND. .NOT.DGO%LRESET_BUDGETC))THEN
#else
      IF(DE%LWATER_BUDGET .OR. .NOT.DGO%LRESET_BUDGETC)THEN
#endif       
        IF(IVERSION>7 .OR. IVERSION==7 .AND. IBUG>=3)THEN 
          !
          YREC='DWGC_'//YREC2
          CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
          DO JP = 1,IO%NPATCH
              CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XDWG(:))
          ENDDO
          !        
          YREC='DWGIC_'//YREC2
          CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
          DO JP = 1,IO%NPATCH
              CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XDWGI(:))
          ENDDO
          !        
          YREC='DWRC_'//YREC2
          CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
          DO JP = 1,IO%NPATCH
              CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XDWR(:))
          ENDDO
          !        
          YREC='DSWEC_'//YREC2
          CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
          DO JP = 1,IO%NPATCH
              CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XDSWE(:))
          ENDDO  
          !        
          YREC='WATBUDC_'//YREC2
          CALL MAKE_CHOICE_ARRAY(HPROGRAM, IO%NPATCH, GDIM, YREC, ZWORK)
          DO JP = 1,IO%NPATCH
              CALL PACK_SAME_RANK(NP%AL(JP)%NR_P,ZWORK(:,JP),NDEC%AL(JP)%XWATBUD(:))
          ENDDO
          !        
         ELSE
          !
          DO JP=1,IO%NPATCH
              CALL INIT_WATER_BUD(NDEC%AL(JP))
          ENDDO        
          !       
        ENDIF
        !
        DEALLOCATE(ZWORK)
        !
      ELSE
        !
        DO JP=1,IO%NPATCH
          !
          CALL INIT_EVAP_BUD(NDEC%AL(JP))
          !
          IF (ISIZE_LMEB_PATCH>0) THEN
            CALL INIT_MEB_BUD(NDEC%AL(JP))
          ENDIF
          !
          CALL INIT_SURF_BUD(DC,0.)
          DC%XEVAP = 0.
          DC%XSUBL = 0.
          !
        ENDDO
        !
        IF(IO%LGLACIER)THEN
          DO JP=1,IO%NPATCH
            NDEC%AL(JP)%XICEFLUX=0.0
          ENDDO      
        ENDIF
        !  
#ifdef SFX_OL
        IF(DE%LWATER_BUDGET .OR. (LRESTART .AND. .NOT.DGO%LRESET_BUDGETC))THEN
#else
        IF(DE%LWATER_BUDGET .OR. .NOT.DGO%LRESET_BUDGETC)THEN
#endif        
          !
          DO JP=1,IO%NPATCH
            CALL INIT_WATER_BUD(NDEC%AL(JP))
          ENDDO
          !
        ENDIF
        !
      ENDIF
      !
    ENDIF
    !
  ENDIF
  !
ELSE
  !
  CALL ALLOC_SURF_BUD(DC,0,0,0)
  ALLOCATE(DC%XEVAP(0))
  ALLOCATE(DC%XSUBL(0))  
  !
  CALL ALLOC_EVAP_BUD(DEC,0,0)
  !
  DO JP=1,IO%NPATCH
    !
    CALL ALLOC_SURF_BUD(NDC%AL(JP),0,0,0)
    ALLOCATE(NDC%AL(JP)%XEVAP(0))
    ALLOCATE(NDC%AL(JP)%XSUBL(0))     
    !
    CALL ALLOC_EVAP_BUD(NDEC%AL(JP),0,0)
    !
  ENDDO
  !
ENDIF
!
#ifdef SFX_OL
IF(.NOT.GCUMUL .AND. (.NOT.DE%LWATER_BUDGET .OR. .NOT.LRESTART .OR. DGO%LRESET_BUDGETC))THEN
#else
IF(.NOT.GCUMUL .AND. (.NOT.DE%LWATER_BUDGET .OR. DGO%LRESET_BUDGETC))THEN
#endif
  !
  ALLOCATE(DEC%XRAINFALL  (0))
  ALLOCATE(DEC%XSNOWFALL  (0))
  ! 
  CALL ALLOC_WATER_BUD(DEC,0)
  DO JP=1,IO%NPATCH
    CALL ALLOC_WATER_BUD(NDEC%AL(JP),0)
  ENDDO
  !
ENDIF
!
IF (.NOT.GCUMUL .OR. ISIZE_LMEB_PATCH<=0) THEN
  !
  CALL ALLOC_MEB_BUD(DEC,0)  
  DO JP=1,IO%NPATCH
    CALL ALLOC_MEB_BUD(NDEC%AL(JP),0)
  ENDDO  
  !
ENDIF
!
IF(.NOT.IO%LGLACIER)THEN
  ALLOCATE(DEC%XICEFLUX(0))
  DO JP=1,IO%NPATCH
    ALLOCATE(NDEC%AL(JP)%XICEFLUX(0))
  ENDDO
ENDIF
!
!* miscellaneous surface fields
!
IF (YDM%LSURF_MISC_BUDGET) THEN
  !
  CALL ALLOC_MISC_BUD(DM,KLU,0,IO%NGROUND_LAYER,0,DM%LPROSNOW)
  DO JP=1,IO%NPATCH
    CALL ALLOC_MISC_BUD(NDM%AL(JP),NP%AL(JP)%NSIZE_P,NP%AL(JP)%NSIZE_P,&
                        IO%NGROUND_LAYER,KSNOW_NLAYER,DM%LPROSNOW)
  ENDDO
  !
ELSE
  !
  CALL ALLOC_MISC_BUD(DM,0,0,0,0,DM%LPROSNOW)
  DO JP=1,IO%NPATCH
    CALL ALLOC_MISC_BUD(NDM%AL(JP),0,0,0,0,DM%LPROSNOW)
  ENDDO  
  !
END IF
!
!* Chemical fluxes
IF (CHI%SVI%NBEQ>0 .AND. CHI%LCH_BIO_FLUX) THEN
  ALLOCATE(GB%XFISO(KLU))
  ALLOCATE(GB%XFMONO(KLU))
  !
  GB%XFISO         = XUNDEF
  GB%XFMONO        = XUNDEF
ELSE
  ALLOCATE(GB%XFISO(0))
  ALLOCATE(GB%XFMONO(0))
ENDIF
!
IF (IO%CPHOTO/='NON') THEN
  DO JP = 1,IO%NPATCH
    ALLOCATE(NGB%AL(JP)%XIACAN(NP%AL(JP)%NSIZE_P,KABC))
    !
    NGB%AL(JP)%XIACAN        = XUNDEF
  ENDDO
  !
ELSE
  DO JP = 1,IO%NPATCH
    ALLOCATE(NGB%AL(JP)%XIACAN(0,0))
  ENDDO
ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N',1,ZHOOK_HANDLE)
!
CONTAINS
!
!
SUBROUTINE ALLOC_MISC_BUD(DMA,KLUA,KLUAP,KNLAYER,KSNLAYER,OPROSNOW)
!
TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DMA
INTEGER, INTENT(IN) :: KLUA
INTEGER, INTENT(IN) :: KLUAP
INTEGER, INTENT(IN) :: KNLAYER
INTEGER, INTENT(IN) :: KSNLAYER
LOGICAL, INTENT(IN) :: OPROSNOW
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N:ALLOC_MISC_BUD',0,ZHOOK_HANDLE)
!
!////////////DIAG DEFINED BY PATCH AND AVERAGED//////////
!
ALLOCATE(DMA%XHV           (KLUA))
!
ALLOCATE(DMA%XSWI          (KLUA,KNLAYER))
ALLOCATE(DMA%XTSWI         (KLUA,KNLAYER))
!
ALLOCATE(DMA%XTWSNOW       (KLUA))
ALLOCATE(DMA%XTDSNOW       (KLUA))
ALLOCATE(DMA%XTTSNOW       (KLUA))
!
IF ( OPROSNOW .AND. HSNOW_SCHEME=="CRO" ) THEN
  !
  ALLOCATE(DMA%XSNOWDEND     (KLUAP,KSNLAYER))
  ALLOCATE(DMA%XSNOWSPHER    (KLUAP,KSNLAYER))
  ALLOCATE(DMA%XSNOWSIZE     (KLUAP,KSNLAYER))    
  ALLOCATE(DMA%XSNOWSSA      (KLUAP,KSNLAYER))
  ALLOCATE(DMA%XSNOWTYPEMEPRA(KLUAP,KSNLAYER))
  ALLOCATE(DMA%XSNOWRAM      (KLUAP,KSNLAYER))  
  ALLOCATE(DMA%XSNOWSHEAR    (KLUAP,KSNLAYER))
  !
  ALLOCATE(DMA%XSNDPT_1DY(KLUA))
  ALLOCATE(DMA%XSNDPT_3DY(KLUA))
  ALLOCATE(DMA%XSNDPT_5DY(KLUA))
  ALLOCATE(DMA%XSNDPT_7DY(KLUA))  
  ALLOCATE(DMA%XSNSWE_1DY(KLUA))
  ALLOCATE(DMA%XSNSWE_3DY(KLUA))
  ALLOCATE(DMA%XSNSWE_5DY(KLUA))
  ALLOCATE(DMA%XSNSWE_7DY(KLUA)) 
  ALLOCATE(DMA%XSNRAM_SONDE(KLUA)) 
  ALLOCATE(DMA%XSN_WETTHCKN(KLUA)) 
  ALLOCATE(DMA%XSN_REFRZNTHCKN(KLUA))
  !
ELSE
  !
  ALLOCATE(DMA%XSNOWDEND     (0,0))
  ALLOCATE(DMA%XSNOWSPHER    (0,0))
  ALLOCATE(DMA%XSNOWSIZE     (0,0))    
  ALLOCATE(DMA%XSNOWSSA      (0,0))
  ALLOCATE(DMA%XSNOWTYPEMEPRA(0,0))
  ALLOCATE(DMA%XSNOWRAM      (0,0))  
  ALLOCATE(DMA%XSNOWSHEAR    (0,0))
  !
  ALLOCATE(DMA%XSNDPT_1DY(0))
  ALLOCATE(DMA%XSNDPT_3DY(0))
  ALLOCATE(DMA%XSNDPT_5DY(0))
  ALLOCATE(DMA%XSNDPT_7DY(0))  
  ALLOCATE(DMA%XSNSWE_1DY(0))
  ALLOCATE(DMA%XSNSWE_3DY(0))
  ALLOCATE(DMA%XSNSWE_5DY(0))
  ALLOCATE(DMA%XSNSWE_7DY(0)) 
  ALLOCATE(DMA%XSNRAM_SONDE(0)) 
  ALLOCATE(DMA%XSN_WETTHCKN(0)) 
  ALLOCATE(DMA%XSN_REFRZNTHCKN(0))  
  !
ENDIF
!
ALLOCATE(DMA%XPSNG        (KLUA))
ALLOCATE(DMA%XPSNV        (KLUA))
ALLOCATE(DMA%XPSN         (KLUA))
!
ALLOCATE(DMA%XFSAT        (KLUA)) 
!
ALLOCATE(DMA%XFFG         (KLUA))
ALLOCATE(DMA%XFFV         (KLUA))
ALLOCATE(DMA%XFF          (KLUA))
!
IF (KLUA>0) THEN
  DMA%XHV      = XUNDEF  
  DMA%XSWI     = XUNDEF
  DMA%XTSWI    = XUNDEF
  DMA%XTWSNOW  = XUNDEF
  DMA%XTDSNOW  = XUNDEF
  DMA%XTTSNOW  = XUNDEF  
  DMA%XPSNG    = XUNDEF
  DMA%XPSNV    = XUNDEF
  DMA%XPSN     = XUNDEF
  DMA%XFSAT    = XUNDEF  
  DMA%XFFG     = XUNDEF
  DMA%XFFV     = XUNDEF
  DMA%XFF      = XUNDEF
ENDIF
!
IF ( OPROSNOW  .AND. HSNOW_SCHEME=="CRO" ) THEN
  !
  IF (KLUAP>0) THEN
    DMA%XSNOWDEND  = XUNDEF
    DMA%XSNOWSPHER = XUNDEF
    DMA%XSNOWSIZE  = XUNDEF
    DMA%XSNOWSSA   = XUNDEF
    DMA%XSNOWTYPEMEPRA = XUNDEF
    DMA%XSNOWRAM = XUNDEF
    DMA%XSNOWSHEAR = XUNDEF
  ENDIF
  !
  IF (KLUA>0) THEN
    DMA%XSNDPT_1DY = XUNDEF
    DMA%XSNDPT_3DY = XUNDEF  
    DMA%XSNDPT_5DY = XUNDEF
    DMA%XSNDPT_7DY = XUNDEF
    DMA%XSNSWE_1DY = XUNDEF
    DMA%XSNSWE_3DY = XUNDEF
    DMA%XSNSWE_5DY = XUNDEF
    DMA%XSNSWE_7DY = XUNDEF
    DMA%XSNRAM_SONDE = XUNDEF
    DMA%XSN_WETTHCKN = XUNDEF
    DMA%XSN_REFRZNTHCKN = XUNDEF
  ENDIF
  !
ENDIF
!
IF(IO%CISBA=='DIF')THEN
  ALLOCATE(DMA%XALT(KLUA))
  ALLOCATE(DMA%XFLT(KLUA))
  IF (KLUA>0) THEN
    DMA%XALT     = XUNDEF
    DMA%XFLT     = XUNDEF        
  ENDIF
ELSE
  ALLOCATE(DMA%XALT(0))
  ALLOCATE(DMA%XFLT(0))
ENDIF
!
!//////////////DIAG DEFINED ONLY BY PATCH//////////////
!
ALLOCATE(DMA%XSNOWLIQ  (KLUAP,KSNLAYER))
ALLOCATE(DMA%XSNOWTEMP (KLUAP,KSNLAYER))
ALLOCATE(DMA%XSNOWDZ   (KLUAP,KSNLAYER))
!
IF (KLUAP>0) THEN
  DMA%XSNOWLIQ = XUNDEF
  DMA%XSNOWTEMP= XUNDEF
  DMA%XSNOWDZ  = XUNDEF  
ENDIF
!
IF (LAGRIP) THEN
  ALLOCATE(DMA%XSEUIL         (KLUAP))
  !
  IF (KLUAP>0) THEN
    DMA%XSEUIL         = XUNDEF
  ENDIF
ELSE
  ALLOCATE(DMA%XSEUIL(0))
ENDIF
!
IF (IO%LTR_ML) THEN
  ALLOCATE (DMA%XFAPAR      (KLUAP))
  ALLOCATE (DMA%XFAPIR      (KLUAP))
  ALLOCATE (DMA%XFAPAR_BS   (KLUAP))
  ALLOCATE (DMA%XFAPIR_BS   (KLUAP))
  ALLOCATE (DMA%XDFAPARC    (KLUAP))
  ALLOCATE (DMA%XDFAPIRC    (KLUAP))
  ALLOCATE (DMA%XDLAI_EFFC  (KLUAP))
  !
  IF (KLUAP>0) THEN
    DMA%XFAPAR      = XUNDEF
    DMA%XFAPIR      = XUNDEF
    DMA%XFAPAR_BS   = XUNDEF
    DMA%XFAPIR_BS   = XUNDEF
    DMA%XDFAPARC    = 0.
    DMA%XDFAPIRC    = 0.
    DMA%XDLAI_EFFC  = 0.
  ENDIF
ELSE
  ALLOCATE (DMA%XFAPAR      (0))
  ALLOCATE (DMA%XFAPIR      (0))
  ALLOCATE (DMA%XFAPAR_BS   (0))
  ALLOCATE (DMA%XFAPIR_BS   (0))
  ALLOCATE (DMA%XDFAPARC    (0))
  ALLOCATE (DMA%XDFAPIRC    (0))
  ALLOCATE (DMA%XDLAI_EFFC  (0))
ENDIF
!
!
ALLOCATE(DMA%XC1       (KLUAP))
ALLOCATE(DMA%XC2       (KLUAP))
ALLOCATE(DMA%XWGEQ     (KLUAP))
ALLOCATE(DMA%XCG       (KLUAP))
ALLOCATE(DMA%XCT       (KLUAP))
ALLOCATE(DMA%XRS       (KLUAP))
ALLOCATE(DMA%XGRNDFLUX (KLUAP))
ALLOCATE(DMA%XSNOWHMASS(KLUAP))
ALLOCATE(DMA%XSRSFC    (KLUAP))
ALLOCATE(DMA%XRRSFC    (KLUAP))
ALLOCATE(DMA%XRNSNOW   (KLUAP))
ALLOCATE(DMA%XHSNOW    (KLUAP))
ALLOCATE(DMA%XGFLUXSNOW(KLUAP))
ALLOCATE(DMA%XHPSNOW   (KLUAP))
ALLOCATE(DMA%XUSTARSNOW(KLUAP))
ALLOCATE(DMA%XCDSNOW   (KLUAP))
ALLOCATE(DMA%XCHSNOW   (KLUAP))
!
IF (KLUAP>0) THEN
  DMA%XC1        = XUNDEF
  DMA%XC2        = XUNDEF
  DMA%XWGEQ      = XUNDEF
  DMA%XCG        = XUNDEF
  DMA%XCT        = XUNDEF
  DMA%XRS        = XUNDEF
  DMA%XGRNDFLUX  = XUNDEF
  DMA%XSNOWHMASS = XUNDEF
  DMA%XSRSFC     = XUNDEF
  DMA%XRRSFC     = XUNDEF
  DMA%XRNSNOW    = XUNDEF
  DMA%XHSNOW     = XUNDEF
  DMA%XGFLUXSNOW = XUNDEF
  DMA%XHPSNOW    = XUNDEF
  DMA%XUSTARSNOW = XUNDEF
  DMA%XCDSNOW    = XUNDEF
  DMA%XCHSNOW    = XUNDEF
ENDIF
!
!////////////DIAG DEFINED ONLY AVERAGED//////////////
!
ALLOCATE(DMA%XLAI          (KLUA))
!
ALLOCATE(DMA%XSOIL_SWI         (KLUA))
ALLOCATE(DMA%XSOIL_TSWI        (KLUA))
ALLOCATE(DMA%XSOIL_TWG         (KLUA))
ALLOCATE(DMA%XSOIL_TWGI        (KLUA))
ALLOCATE(DMA%XSOIL_WG          (KLUA))
ALLOCATE(DMA%XSOIL_WGI         (KLUA))
!
IF (KLUA>0) THEN
  DMA%XLAI     = XUNDEF        
  DMA%XSOIL_TSWI   = XUNDEF
  DMA%XSOIL_SWI    = XUNDEF
  DMA%XSOIL_TWG    = XUNDEF
  DMA%XSOIL_TWGI   = XUNDEF
  DMA%XSOIL_WG     = XUNDEF
  DMA%XSOIL_WGI    = XUNDEF   
ENDIF
!
IF(IO%CISBA=='DIF'.AND.DM%LSURF_MISC_DIF)THEN
  ALLOCATE(DMA%XFRD2_TSWI(KLUA))
  ALLOCATE(DMA%XFRD2_TWG (KLUA))
  ALLOCATE(DMA%XFRD2_TWGI(KLUA))
  ALLOCATE(DMA%XFRD3_TSWI(KLUA))
  ALLOCATE(DMA%XFRD3_TWG (KLUA))
  ALLOCATE(DMA%XFRD3_TWGI(KLUA))
  !
  IF (KLUA>0) THEN  
    DMA%XFRD2_TSWI = XUNDEF
    DMA%XFRD2_TWG  = XUNDEF
    DMA%XFRD2_TWGI = XUNDEF
    DMA%XFRD3_TSWI = XUNDEF
    DMA%XFRD3_TWG  = XUNDEF
    DMA%XFRD3_TWGI = XUNDEF 
  ENDIF 
  !
ELSE
  ALLOCATE(DMA%XFRD2_TSWI(0))
  ALLOCATE(DMA%XFRD2_TWG (0))
  ALLOCATE(DMA%XFRD2_TWGI(0))
  ALLOCATE(DMA%XFRD3_TSWI(0))
  ALLOCATE(DMA%XFRD3_TWG (0))
  ALLOCATE(DMA%XFRD3_TWGI(0))          
ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N:ALLOC_MISC_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE ALLOC_MISC_BUD
!
SUBROUTINE ALLOC_EVAP_BUD(DEA,KLUA,KLUAP)
!
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DEA
INTEGER, INTENT(IN) :: KLUA
INTEGER, INTENT(IN) :: KLUAP
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N:ALLOC_EVAP_BUD',0,ZHOOK_HANDLE)
!
ALLOCATE(DEA%XLEG       (KLUA))
ALLOCATE(DEA%XLEGI      (KLUA))
ALLOCATE(DEA%XLEV       (KLUA))
ALLOCATE(DEA%XLES       (KLUA))
!
ALLOCATE(DEA%XLESL      (KLUA))
ALLOCATE(DEA%XSNDRIFT   (KLUA))
!
ALLOCATE(DEA%XLER       (KLUA))
ALLOCATE(DEA%XLETR      (KLUA))
!
ALLOCATE(DEA%XDRAIN     (KLUA))
ALLOCATE(DEA%XRUNOFF    (KLUA))
ALLOCATE(DEA%XDRIP      (KLUA))
ALLOCATE(DEA%XRRVEG     (KLUA))
ALLOCATE(DEA%XMELT      (KLUA))
!
ALLOCATE(DEA%XIRRIG_FLUX(KLUA))
!
ALLOCATE(DEA%XGPP       (KLUA))
ALLOCATE(DEA%XRESP_AUTO (KLUA))
ALLOCATE(DEA%XRESP_ECO  (KLUA)) 
!
ALLOCATE(DEA%XQSB       (KLUA))
ALLOCATE(DEA%XHORT      (KLUA)) 
!
ALLOCATE(DEA%XIFLOOD   (KLUA))
ALLOCATE(DEA%XPFLOOD   (KLUA))
ALLOCATE(DEA%XLE_FLOOD (KLUA))
ALLOCATE(DEA%XLEI_FLOOD(KLUA))
!
ALLOCATE(DEA%XRN_SN_FR   (KLUAP))
ALLOCATE(DEA%XH_SN_FR    (KLUAP))
ALLOCATE(DEA%XLEI_SN_FR  (KLUAP))
ALLOCATE(DEA%XLE_SN_FR   (KLUAP))
ALLOCATE(DEA%XGFLUX_SN_FR(KLUAP))
ALLOCATE(DEA%XLEG_SN_FR  (KLUAP))
ALLOCATE(DEA%XLEGI_SN_FR (KLUAP))
ALLOCATE(DEA%XLEV_SN_FR  (KLUAP))
ALLOCATE(DEA%XLETR_SN_FR (KLUAP))
ALLOCATE(DEA%XUSTAR_SN_FR(KLUAP))
ALLOCATE(DEA%XLER_SN_FR  (KLUAP))
!
ALLOCATE(DEA%XMELTADV    (KLUAP))
ALLOCATE(DEA%XRESTORE    (KLUAP))
!
IF (KLUA>0) THEN
  DEA%XLEG        = XUNDEF
  DEA%XLEGI       = XUNDEF
  DEA%XLEV        = XUNDEF
  DEA%XLES        = XUNDEF
  !
  DEA%XLESL       = XUNDEF
  DEA%XSNDRIFT    = XUNDEF
  !  
  DEA%XLER        = XUNDEF
  DEA%XLETR       = XUNDEF
  !
  DEA%XDRAIN      = XUNDEF
  DEA%XRUNOFF     = XUNDEF
  DEA%XDRIP       = XUNDEF
  DEA%XRRVEG      = XUNDEF
  DEA%XMELT       = XUNDEF
  !  
  DEA%XIRRIG_FLUX = XUNDEF
  !
  DEA%XGPP        = XUNDEF
  DEA%XRESP_AUTO  = XUNDEF
  DEA%XRESP_ECO   = XUNDEF  
  !
  DEA%XQSB        = XUNDEF
  DEA%XHORT       = XUNDEF
  !  
  DEA%XIFLOOD    = XUNDEF
  DEA%XPFLOOD    = XUNDEF
  DEA%XLE_FLOOD  = XUNDEF
  DEA%XLEI_FLOOD = XUNDEF
  !
ENDIF
!
IF (KLUAP>0) THEN
  DEA%XRN_SN_FR    = XUNDEF
  DEA%XH_SN_FR     = XUNDEF
  DEA%XLEI_SN_FR   = XUNDEF
  DEA%XLE_SN_FR    = XUNDEF
  DEA%XGFLUX_SN_FR = XUNDEF
  DEA%XLEG_SN_FR   = XUNDEF
  DEA%XLEGI_SN_FR  = XUNDEF
  DEA%XLEV_SN_FR   = XUNDEF
  DEA%XLETR_SN_FR  = XUNDEF
  DEA%XUSTAR_SN_FR = XUNDEF
  DEA%XLER_SN_FR   = XUNDEF
  !
  DEA%XMELTADV     = XUNDEF  
  DEA%XRESTORE     = XUNDEF
ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N:ALLOC_EVAP_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE ALLOC_EVAP_BUD
!
SUBROUTINE ALLOC_MEB_BUD(DEA,KLUA)
!
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DEA
INTEGER, INTENT(IN) :: KLUA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N:ALLOC_MEB_BUD',0,ZHOOK_HANDLE)
!
ALLOCATE(DEA%XLELITTER (KLUA))
ALLOCATE(DEA%XLELITTERI(KLUA))
ALLOCATE(DEA%XDRIPLIT  (KLUA))
ALLOCATE(DEA%XRRLIT  (KLUA))
!
ALLOCATE(DEA%XLEV_CV (KLUA))
ALLOCATE(DEA%XLES_CV (KLUA))
ALLOCATE(DEA%XLETR_CV(KLUA))
ALLOCATE(DEA%XLER_CV (KLUA))
ALLOCATE(DEA%XLE_CV  (KLUA))
ALLOCATE(DEA%XH_CV   (KLUA))
ALLOCATE(DEA%XMELT_CV(KLUA))
ALLOCATE(DEA%XFRZ_CV (KLUA))

ALLOCATE(DEA%XLETR_GV(KLUA))
ALLOCATE(DEA%XLER_GV (KLUA))
ALLOCATE(DEA%XLE_GV  (KLUA))
ALLOCATE(DEA%XH_GV   (KLUA))

ALLOCATE(DEA%XLE_GN  (KLUA))
ALLOCATE(DEA%XEVAP_GN(KLUA))
ALLOCATE(DEA%XH_GN   (KLUA))
ALLOCATE(DEA%XSR_GN  (KLUA))
ALLOCATE(DEA%XSWDOWN_GN(KLUA))
ALLOCATE(DEA%XLWDOWN_GN(KLUA))

ALLOCATE(DEA%XEVAP_G (KLUA))
ALLOCATE(DEA%XLE_CA  (KLUA))
ALLOCATE(DEA%XH_CA   (KLUA))
!
ALLOCATE(DEA%XSWUP(KLUA))
ALLOCATE(DEA%XLWUP(KLUA))
!
ALLOCATE(DEA%XSWNET_V    (KLUA))
ALLOCATE(DEA%XSWNET_G    (KLUA))
ALLOCATE(DEA%XSWNET_N    (KLUA))
ALLOCATE(DEA%XSWNET_NS   (KLUA))
ALLOCATE(DEA%XLWNET_V    (KLUA))
ALLOCATE(DEA%XLWNET_G    (KLUA))
ALLOCATE(DEA%XLWNET_N    (KLUA))
!
IF (KLUA>0) THEN
  DEA%XLELITTER      = XUNDEF
  DEA%XLELITTERI     = XUNDEF
  DEA%XDRIPLIT       = XUNDEF
  DEA%XRRLIT         = XUNDEF
        
  DEA%XLEV_CV      = XUNDEF
  DEA%XLES_CV      = XUNDEF
  DEA%XLETR_CV     = XUNDEF
  DEA%XLER_CV      = XUNDEF
  DEA%XLE_CV       = XUNDEF  
  DEA%XH_CV        = XUNDEF  
  DEA%XMELT_CV     = XUNDEF
  DEA%XFRZ_CV      = XUNDEF  

  DEA%XLETR_GV     = XUNDEF
  DEA%XLER_GV      = XUNDEF
  DEA%XLE_GV       = XUNDEF
  DEA%XH_GV        = XUNDEF

  DEA%XLE_GN       = XUNDEF
  DEA%XEVAP_GN     = XUNDEF
  DEA%XH_GN        = XUNDEF  
  DEA%XSR_GN       = XUNDEF
  DEA%XSWDOWN_GN   = XUNDEF
  DEA%XLWDOWN_GN   = XUNDEF
  
  DEA%XEVAP_G      = XUNDEF
  DEA%XLE_CA       = XUNDEF
  DEA%XH_CA        = XUNDEF
  !
  DEA%XSWUP = XUNDEF
  DEA%XLWUP = XUNDEF
  !
  DEA%XSWNET_V       = XUNDEF
  DEA%XSWNET_G       = XUNDEF
  DEA%XSWNET_N       = XUNDEF
  DEA%XSWNET_NS      = XUNDEF
  DEA%XLWNET_V       = XUNDEF
  DEA%XLWNET_G       = XUNDEF
  DEA%XLWNET_N       = XUNDEF
ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N:ALLOC_MEB_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE ALLOC_MEB_BUD
!
SUBROUTINE ALLOC_WATER_BUD(DEA,KLUA)
!
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DEA
INTEGER, INTENT(IN) :: KLUA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N:ALLOC_WATER_BUD',0,ZHOOK_HANDLE)
!
ALLOCATE(DEA%XDWG   (KLUA))
ALLOCATE(DEA%XDWGI  (KLUA))
ALLOCATE(DEA%XDWR   (KLUA))
ALLOCATE(DEA%XDSWE  (KLUA))
ALLOCATE(DEA%XWATBUD(KLUA))
!
IF (KLUA>0) THEN
  DEA%XDWG    = XUNDEF
  DEA%XDWGI   = XUNDEF
  DEA%XDWR    = XUNDEF
  DEA%XDSWE   = XUNDEF
  DEA%XWATBUD = XUNDEF
ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N:ALLOC_WATER_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE ALLOC_WATER_BUD
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_ISBA_INIT_n
