!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!######################################################################
!######################################################################
!
! THIS ROUTINE COMPUTE THE INCOMPLETE AND THE COMPLEMENTARY
! INCOMPLETE GAMMA FUNCTION REAL*8 IN BRIEF, THIS
! FUNCTION HELP TO COMPUTE THE DIFFERENT FRACTION PRESENT IN THE
! TOPMODEL FRAMEWORK.
! MORE EXPLANATION ON THE SUBROUTINE USE ARE GIVEN IN THE NEXT
! COMMENTARY
!
! THIS ROUTINE WAS FOUND ON http://www.netlib.org WEB SITE.
!
! REFERENCE - W. GAUTSCHI, :: A COMPUTATIONAL PROCEDURE FOR INCOMPLETE
! GAMMA FUNCTIONS, ACM TRANS. MATH. SOFTWARE., (1979) 482-489
!
!######################################################################
!######################################################################
!
!     LET  GAMMA(A)  DENOTE THE GAMMA FUNCTION AND  GAM(A,X)  THE
! (COMPLEMENTARY) INCOMPLETE GAMMA FUNCTION,
!
!    GAM(A,X)=INTEGRAL FROM T=X TO T=INFINITY OF EXP(-T)*T**(A-1).
!
! LET  GAMSTAR(A,X)  DENOTE TRICOMI:S FORM OF THE INCOMPLETE GAMMA
! FUNCTION, WHICH FOR A.GT.0. IS DEFINED BY
!
!  GAMSTAR(A,X)=(X**(-A)/GAMMA(A))*INTEGRAL FROM T=0 TO T=X OF
!    EXP(-T)*T**(A-1),
!
! AND FOR A.LE.0. BY ANALYTIC CONTINUATION. FOR THE PURPOSE OF
! THIS SUBROUTINE, THESE FUNCTIONS ARE NORMALIZED AS FOLLOWS&
!
! GAM(A,X)/GAMMA(A),  IF A.GT.0.,
!     G(A,X)=
! EXP(X)*X**(-A)*GAM(A,X),  IF A.LE.0.,
!
!     GSTAR(A,X)=(X**A)*GAMSTAR(A,X)
!   =(1/GAMMA(A))*INTEGRAL FROM T=0 TO T=X OF EXP(-T)*T**(A-1)
!
! THE PROGRAM BELOW ATTEMPTS TO EVALUATE  G(A,X)  AND  GSTAR(A,X),
! BOTH TO AN ACCURACY OF ACC SIGNIFICANT DECIMAL DIGITS, FOR ARBI-
! TRARY REAL VALUES OF  A  AND NONNEGATIVE VALUES OF  X. THE SUB-
! ROUTINE AUTOMATICALLY CHECKS FOR UNDERFLOW AND OVERFLOW CONDI-
! TIONS AND RETURNS APPROPRIATE WARNINGS THROUGH THE OUTPUT PARA-
! METERS  IFLG, IFLGST. A RESULT THAT UNDERFLOWS IS RETURNED WITH
! THE VALUE 0., ONE THAT OVERFLOWS WITH THE VALUE OF THE LARGEST
! MACHINE-REPRESENTABLE NUMBER.
!
!     NEAR LINES IN THE (A,X)-PLANE, A.LT.0., ALONG WHICH  GSTAR
! VANISHES, THE ACCURACY SPECIFIED WILL BE ATTAINED ONLY IN TERMS
! OF ABSOLUTE ERROR, NOT RELATIVE ERROR. THERE ARE OTHER (RARE)
! INSTANCES IN WHICH THE ACCURACY ATTAINED IS SOMEWHAT LESS THAN
! THE ACCURACY SPECIFIED. THE DISCREPANCY, HOWEVER, SHOULD NEVER
! EXCEED ONE OR TWO (DECIMAL) ORDERS OF ACCURACY# NO INDICATION
! OF THIS IS GIVEN THROUGH ERROR FLAGS.
!
!     PARAMETER LIST&
!
!  A - - THE FIRST ARGUMENT OF G AND GSTAR. TYPE REAL.
!  X - - THE SECOND ARGUMENT OF G AND GSTAR. TYPE REAL.
!ACC - - THE NUMBER OF CORRECT SIGNIFICANT DECIMAL DIGITS
!  DESIRED IN THE RESULTS. TYPE REAL.
!  G - - AN OUTPUT VARIABLE RETURNING THE VALUE OF G(A,X).
!  TYPE REAL.
!    GSTAR - - AN OUTPUT VARIABLE RETURNING THE VALUE OF
!  GSTAR(A,X). TYPE REAL.
!     IFLG - - AN ERROR FLAG INDICATING A NUMBER OF ERROR CONDI-
!  TIONS IN G UPON EXECUTION. TYPE INTEGER.
!   IFLGST - - AN ERROR FLAG INDICATING A NUMBER OF ERROR CONDI-
!  TIONS IN GSTAR UPON EXECUTION. TYPE INTEGER.
!  THE VALUES OF IFLG AND IFLGST HAVE THE FOLLOWING
!  MEANINGS&
!  0 - NO ERROR CONDITION.
!  1 - ILLEGAL NEGATIVE ARGUMENT X. THE ROUTINE EXITS
!WITH THE VALUES ZERO FOR G AND GSTAR.
!  2 - INFINITELY LARGE RESULT AT X=0. THE ROUTINE
!RETURNS THE LARGEST MACHINE-REPRESENTABLE NUMBER.
!  3 - (ONLY FOR IFLGST) GSTAR IS INDETERMINATE AT
!A=0. AND X=0. THE ROUTINE RETURNS THE VALUE 1.,
!WHICH IS THE LIMIT VALUE AS X TENDS TO ZERO FOR
!FIXED A=0.
!  4 - THE RESULT UNDERFLOWS. IT IS SET EQUAL TO 0.
!  5 - THE RESULT OVERFLOWS. IT IS SET EQUAL TO THE
!LARGEST MACHINE-REPRESENTABLE NUMBER, WITH
!PROPER SIGN.
!  6 - CONVERGENCE FAILS WITHIN 600 ITERATIONS, EITHER
!IN TAYLOR:S SERIES OR IN LEGENDRE:S CONTINUED
!FRACTION. REASON UNKNOWN. THE COMPUTATION IS
!ABORTED AND THE ROUTINE RETURNS WITH ZERO
!VALUES FOR G AND GSTAR.
!
!     ALL MACHINE-DEPENDENT PARAMETERS ARE COLLECTED IN THE FIRST
! DATA DECLARATION. THEY ARE AS FOLLOWS&
!
! IN THE PROGRAM BELOW THESE PARAMETERS ARE SET TO CORRESPOND TO
! THE MACHINE CHARACTERISTICS OF THE CDC 6500 COMPUTER.
!
!     THE SECOND DATA DECLARATION CONTAINS THE SINGLE PRECISION
! VALUE OF ALOG(10.). THE NEXT DATA DECLARATION CONTAINS THE SUCCES-
! SIVE COEFFICIENTS IN THE MACLAURIN EXPANSION OF (1/GAMMA(A+1))-1.
! THEY ARE GIVEN TO AS MANY DECIMAL PLACES AS IS NECESSARY TO ACHIEVE
! MACHINE PRECISION (ON THE CDC 6500 COMPUTER) IN THE RANGE
! ABS(A).LE..5. MORE ACCURATE VALUES OF THESE COEFFICIENTS (TO
! 31 DECIMAL PLACES) CAN BE FOUND IN TABLE 5 OF J.W.WRENCH,JR.,
! CONCERNING TWO SERIES FOR THE GAMMA FUNCTION, MATH. COMPUT.
! 22, 1968, 617-626.
!
!     THE SUBROUTINE CALLS ON A FUNCTION SUBROUTINE, NAMED  ALGA,
! WHICH IS TO PROVIDE SINGLE PRECISION VALUES OF THE LOGARITHM OF
! THE GAMMA FUNCTION FOR ARGUMENTS LARGER THAN OR EQUAL TO .5.
! A POSSIBLE VERSION OF SUCH A FUNCTION SUBROUTINE IS APPENDED
! TO THE PRESENT SUBROUTINE. IT IS TAYLORED TO THE ACCURACY RE-
! QUIREMENTS OF THE CDC 6500 COMPUTER, AND USES RATIONAL APPROXI-
! MATIONS DUE TO CODY AND HILLSTROM (MATH. COMPUT. 21, 1967, 198-
! 203).
!
!     REFERENCE - W. GAUTSCHI, ::A COMPUTATIONAL PROCEDURE FOR
! INCOMPLETE GAMMA FUNCTIONS, ACM TRANS. MATH. SOFTWARE.
!
!----------------------------------------------------
!!    MODIFICATIONS
!!    -------------
!!J.Escobar10/06/2013: replace DOUBLE PRECISION by REAL to handle problem for promotion of real on IBM SP
!----------------------------------------------------
!################################################################
!
SUBROUTINE DGAM(PA, PX, PACC, PG, PGSTAR, KFLG, KFLGST)
!
!################################################################

USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB

IMPLICIT NONE

REAL, INTENT(IN) :: PA, PX, PACC
REAL, INTENT(OUT) :: PG, PGSTAR
INTEGER, INTENT(OUT) :: KFLG, KFLGST
!
REAL, PARAMETER :: XALPREC=DIGITS(1.)*LOG(2.), &
        XTOP=LOG10(HUGE(1.)), XBOT=LOG10(TINY(1.))
!
REAL :: ZALX, ZALPHA
REAL :: ZAINF, ZEPS, ZEPS1, ZES, ZSGA
REAL :: ZAE, ZAA, ZAP1, ZAM1, ZAEP1
REAL :: ZAEM1, ZFMA, ZAEPS, ZSGAE, ZAAEPS, ZALGP1
REAL :: ZSGGA, ZALGEP1, ZSGGS, ZALGS
REAL :: ZALG, ZSUMM, ZGA, ZY, ZTERM, ZU, ZP, ZQ, ZR, ZV, ZT, ZH
REAL :: ZSGT, ZA1X, ZRHO, ZXPA
REAL :: ZXMA, ZS, ZTEMP
!
INTEGER :: JI, JK, JK1, JMA
LOGICAL :: GRET
!
!RJ REAL,SAVE::AL10=2.3025850929940456840179914547
REAL,DIMENSION(29),PARAMETER :: XC=(/ &
        0.57721566490153286060651209008, &
       -.65587807152025388107701951515, &
      -4.200263503409523552900393488e-2,  &
        0.1665386113822914895017007951,  &
      -4.21977345555443367482083013e-2,   &
      -9.6219715278769735621149217e-3,    &
       7.2189432466630995423950103e-3,    &
      -1.165167591859065112113971e-3,     &
      -2.15241674114950972815730e-4,&
       1.2805028238811618615320e-4, &
      -2.013485478078823865569e-5,  &
      -1.2504934821426706573e-6,    &
       1.1330272319816958824e-6,    &
      -2.056338416977607103e-7,     &
       6.1160951044814158e-9, &
       5.0020076444692229e-9, &
      -1.181274570487020e-9,  &
       1.04342671169110e-10,  &
       7.782263439905e-12,    &
      -3.696805618642e-12,    &
       5.1003702875e-13,&
      -2.058326054e-14, &
      -5.34812254e-15,  &
       1.2267786e-15,   &
      -1.181259e-16,    &
       1.187e-18, &
       1.412e-18, &
      -2.30e-19,  &
       1.7e-20/)

REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!
IF (LHOOK) CALL DR_HOOK('DGAM',0,ZHOOK_HANDLE)
!
PG     = 0.0
PGSTAR = 0.0
!
KFLG   = 0
KFLGST = 0
!
IF ( PX<0. ) THEN
  ! 290 deb
  KFLG = 1
  KFLGST = 1
  IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
  RETURN
  ! 290 end
ENDIF
!
! INITIALIZATION
!
ZAINF   = HUGE(1.)
ZAA = ABS(PA)
!
IF ( PX==0. ) THEN
  !
  ! EVALUATION OF GSTAR(A,0.) AND G(A,0.)
  !
  IF (PA<0.) THEN
    KFLGST = 2
    PGSTAR = ZAINF
    PG     = 1./ZAA
  ELSEIF (PA==0.) THEN
    KFLGST = 3
    KFLG   = 2    
    PGSTAR = 1.
    PG     = ZAINF
  ELSEIF (PA>0.) THEN
    PG = 1.
  ENDIF
  !
  IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
  RETURN
  !
ENDIF
!
! PX > 0.
!
! INITIALIZATION
!
JI = 0
!
ZEPS = 0.5*10.**(-PACC)
ZEPS1 = ZEPS/100.
!
ZALX = LOG(PX)
!
ZALPHA = PX + 0.25
IF ( PX<0.25 ) ZALPHA = LOG(0.5)/ZALX
!
ZSGA = 1.
IF ( PA<0. ) ZSGA = -ZSGA
!
ZAE   = PA
ZAP1  = PA + 1.
ZAEP1 = ZAP1
!
JMA    = INT(0.5-PA)
ZFMA   = FLOAT(JMA)
ZAEPS  = PA + ZFMA
ZAAEPS = ABS(ZAEPS)
!
ZSGAE = 1.
IF (ZAEPS<0.) ZSGAE = -ZSGAE
!
! EVALUATION OF THE LOGARITHM OF THE ABSOLUTE VALUE OF
! GAMMA(A+1.) AND DETERMINATION OF THE SIGN OF GAMMA(A+1.)
!
ZALGP1 = 0.
ZSGGA  = 1.
!
IF (JMA>0 .AND. ZAEPS/=0.) THEN

  ZSGGA = ZSGAE
  IF ( JMA==2*(JMA/2) ) ZSGGA = -ZSGGA
  ZALGP1 = DLGA(ZAEPS+1.) - LOG(ZAAEPS)

  IF (JMA/=1) THEN
    ZALGP1 = ZALGP1 + DLGA(1.-ZAEPS) - DLGA(ZFMA-ZAEPS)
  ENDIF
 
ELSEIF ( JMA<=0 ) THEN
  !10 deb
  ZALGP1 = DLGA(ZAP1)
  ! 10 end
ENDIF
!
! 20 deb
ZALGEP1 = ZALGP1
!
!Map: 
! PA<=ZALPHA
!   !
!   PX>1.5 
!     PA <0., ==0., >0. 
!     RETURN
!     !
!   PA<-0.5
!     PX<0.25 .AND. ZAE>ZALPHA
!   ELSE
!   !
!   PA <0.5
!   ELSE
!   !
!   CODE120
!   PA <0., ==0., >0.
!   RETURN
!   !
! PA>ZALPHA
!
! 60 deb
IF ( PA<=ZALPHA ) THEN
  !
  IF ( PX>1.5 ) THEN 
    !
    ! EVALUATION OF G(A,X) FOR X.GT.1.5 AND A.LE.ALPHA(X) BY
    ! MEANS OF THE LEGENDRE CONTINUED FRACTION      
    !
    !240 deb
    PGSTAR = 1.
    ZXPA = PX + 1. - PA
    ZXMA = PX - 1. - PA
    ZP = 0.
    ZQ = ZXPA*ZXMA
    ZR = 4.*ZXPA
    ZS = -PA + 1.
    ZTERM = 1.
    ZSUMM = 1.
    ZRHO = 0.
    !
    DO JK = 1,600
      !
      ZP = ZP + ZS
      ZQ = ZQ + ZR
      ZR = ZR + 8.
      ZS = ZS + 2.
      ZT = ZP*(1.+ZRHO)
      ZRHO = ZT/(ZQ-ZT)
      ZTERM = ZRHO*ZTERM
      ZSUMM = ZSUMM + ZTERM
      !
      IF ( ABS(ZTERM)<=ZEPS*ZSUMM ) EXIT
      !
      IF ( JK==600 ) THEN
        ! 330 deb
        KFLG = 6
        IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
        RETURN
        ! 330 end
      ENDIF
      !
    ENDDO
    !
    IF ( PA<0. ) THEN
      !
      ! 260 deb
      PG = ZSUMM/ZXPA
      ZALG = LOG (PG)
      ! 260 end
      !
      ! EVALUATION OF GSTAR(A,X) IN TERMS OF G(A,X)
      !  200 deb (200 est la fin de 180)
      CALL CODE200(JMA, PX, PA, ZAEPS, ZSGA, ZSGGA, ZAA, ZALX, &
                   ZALG, ZALGP1, ZAINF, PGSTAR, KFLGST, GRET)
      !  
      IF ( GRET ) THEN
        IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
        RETURN
      ENDIF
      !      
    ELSEIF ( PA==0. ) THEN
      !
      ! 270 deb
      PG = ZSUMM/ZXPA
      ! 270 end
      !
    ELSEIF ( PA>0. ) THEN
      !
      ! 280 deb
      ZALG = PA*ZALX - PX + LOG(PA*ZSUMM/ZXPA) - ZALGP1
      !
      IF ( ZALG<=XBOT ) THEN
        ! 300 deb
        KFLG = 4
        IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
        RETURN
        ! 300 end
      ENDIF
      !
      PG = EXP(ZALG)
      PGSTAR = 1. - PG
      ! 280 end
      ! 
    ENDIF 
    !
    IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
    RETURN    
    !
  ENDIF ! end  PX>1.5 
  !
  !
  IF ( PA<-0.5 ) THEN
    !
    ! RECURSIVE EVALUATION OF G(A,X) FOR X.LE.1.5 AND A.LT.-.5
    !
    ! 170 deb
    JI = 1
    ZAE = ZAEPS
    ZAEP1 = ZAEPS + 1.
    ! 170 end
    !
    IF ( PX<0.25 .AND. ZAE>ZALPHA ) THEN
      !
      ! 210 deb
      JI = 2
      ZALGEP1 = DLGA(ZAEP1)
      !
      ! EVALUATION OF GSTAR(A,X) FOR A.GT.ALPHA(X) BY TAYLOR
      ! EXPANSION
      !
      CALL CODE220(PX,ZAE,ZALX,ZALGEP1,ZEPS,PG,PGSTAR,KFLGST,GRET)
      !
      IF ( GRET ) THEN
        IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
        RETURN
      ENDIF
      !
      PG = PG*EXP(ZALGEP1)/ZAE
      ! 210 end (220 230)
      !
      ! 180 deb
      CALL CODE180(JMA, PX, PA, ZAE, ZAEPS, ZSGA, ZSGGA, ZAA, ZALX, &
                   ZALGP1, ZAINF, PG, PGSTAR, KFLGST, GRET)
      !
      IF ( GRET ) THEN
        IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
        RETURN
      ENDIF
      !
    ENDIF ! PX<0.25 .AND. ZAE>ZALPHA
    !
  ELSE ! end PA < -0.5
    !
    ! DIRECT EVALUATION OF G(A,X) AND GSTAR(A,X) FOR X.LE.1.5
    ! AND -.5.LE.A.LE.ALPHA(X)
    !
    PGSTAR = 1.
    !
  ENDIF
  !
  IF ( PA<0.5 ) THEN 
    !
    ! 70 deb
    ZSUMM = XC(29)
    !
    DO JK = 1,28
      JK1 = 29 - JK
      ZSUMM = ZAE*ZSUMM + XC(JK1)
    ENDDO
    !
    ZGA = -ZSUMM / (1.+ZAE*ZSUMM)
    ZY  = ZAE*ZALX
    !
    IF ( ABS(ZY)<1. ) THEN
      !
      ZSUMM = 1.
      ZTERM = 1.
      !
      DO JK = 1,600
        !
        ZTERM = ZY * ZTERM / JK
        ZSUMM = ZSUMM + ZTERM
        !
        IF ( ABS(ZTERM)<=ZEPS1*ZSUMM ) EXIT
        !
        IF ( JK==600) THEN
          KFLG = 6
          IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
          RETURN
        ENDIF
        !
      ENDDO
      !
      ZU = ZGA - ZSUMM*ZALX
      ! 70 end
      !
    ELSE
      !
      ! 100 deb
      ZU = ZGA - (EXP(ZY)-1.)/ZAE
      ! 100 end
      !
    ENDIF
    !
  ELSE
    !
    ! 110 deb
    ZTEMP = DLGA(PA*1.)
    ZU = DEXP(ZTEMP) - (PX**PA)/PA
    ! 110 end
    !
  ENDIF
  !
  ! 120 deb
  ZP = ZAE*PX
  ZQ = ZAEP1
  ZR = ZAE + 3.
  ZTERM = 1.
  ZSUMM = 1.
  !
  DO JK = 1,600
    !
    ZP = ZP + PX
    ZQ = ZQ + ZR
    ZR = ZR + 2.
    ZTERM = -ZP * ZTERM / ZQ
    ZSUMM = ZSUMM + ZTERM
    !
    IF ( ABS(ZTERM)<=ZEPS1*ZSUMM ) EXIT
    !
    IF ( JK==600) THEN
      KFLG = 6
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
      !
    ENDIF
    !
  ENDDO
  !
  ZV = (PX**ZAEP1) * ZSUMM / ZAEP1
  PG = ZU + ZV
  !
  IF (JI==1) THEN
    !
    ! 180 deb
    CALL CODE180(JMA, PX, PA, ZAE, ZAEPS, ZSGA, ZSGGA, ZAA, ZALX, &
                 ZALGP1, ZAINF, PG, PGSTAR, KFLGST, GRET)
    !
    IF ( GRET ) THEN
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
    ENDIF
    !
  ENDIF
  !
  IF (PA<0.) THEN
    !
    ZT = EXP(PX) * PX**(-PA)
    PG = ZT * PG
    PGSTAR = 1. - PA * PG * DEXP(-ZALGP1) / ZT
    !
  ELSEIF (PA==0.) THEN
    !
    PG = EXP(PX)*PG
    !
  ELSEIF (PA>0.) THEN
    !
    PG = PA*PG*EXP(-ZALGP1)
    PGSTAR = 1. - PG
    !
  ENDIF
  !
  IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
  RETURN  
  ! 120 end
  !
ENDIF
!
! EVALUATION OF GSTAR(A,X) FOR A.GT.ALPHA(X) BY TAYLOR
! EXPANSION
!
! PA > ZALPHA : 220 deb
  CALL CODE220(PX,ZAE,ZALX,ZALGEP1,ZEPS,PG,PGSTAR,KFLGST,GRET)
!
IF ( GRET .OR. JI/=2) THEN
  IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
  RETURN
ENDIF
!
PG = PG*EXP(ZALGEP1)/ZAE
! 220 230 end
!
! 180 deb
! 180 deb
 CALL CODE180(JMA, PX, PA, ZAE, ZAEPS, ZSGA, ZSGGA, ZAA, ZALX, &
              ZALGP1, ZAINF, PG, PGSTAR, KFLGST, GRET)
!
CONTAINS
!
!
SUBROUTINE CODE220(PX,PAE,PALX,PALGEP1,PEPS,PG,PGSTAR,KFLGST,ORET)
!
IMPLICIT NONE
!
REAL, INTENT(IN) :: PX
REAL, INTENT(IN) :: PAE
REAL, INTENT(IN) :: PALX
REAL, INTENT(IN) :: PALGEP1
REAL, INTENT(IN) :: PEPS
REAL, INTENT(OUT) :: PG
REAL, INTENT(INOUT) :: PGSTAR
INTEGER, INTENT(INOUT) :: KFLGST
LOGICAL, INTENT(OUT) :: ORET
!
REAL :: ZTERM, ZSUMM, ZALGS
INTEGER :: JK
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('DGAM:CODE220',0,ZHOOK_HANDLE)
!
! 220 deb
PG = 1.
ZTERM = 1.
ZSUMM = 1.
!
DO JK = 1,600
  !
  ZTERM = PX*ZTERM/(PAE+JK)
  ZSUMM = ZSUMM + ZTERM
  IF (ABS(ZTERM)<=PEPS*ZSUMM) EXIT
  !
  IF ( JK==600 ) THEN
    KFLGST = 6
    IF (LHOOK) CALL DR_HOOK('DGAM:CODE220',1,ZHOOK_HANDLE)
    RETURN
  ENDIF
  !
ENDDO
!
ZALGS = PAE*PALX - PX + LOG(ZSUMM) - PALGEP1
!
IF ( ZALGS<=XBOT ) THEN
  KFLGST = 4
  IF (LHOOK) CALL DR_HOOK('DGAM:CODE220',1,ZHOOK_HANDLE)
  RETURN
ENDIF
!
PGSTAR = EXP(ZALGS)
PG = 1. - PGSTAR
!
IF (LHOOK) CALL DR_HOOK('DGAM:CODE220',1,ZHOOK_HANDLE)
!
END SUBROUTINE CODE220
!
!
SUBROUTINE CODE200(KMA, PX, PA, PAEPS, PSGA, PSGGA, PAA, PALX, &
                   PALG, PALGP1, PAINF, PGSTAR, KFLGST, ORET)
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KMA
REAL, INTENT(IN) :: PX
REAL, INTENT(IN) :: PA
REAL, INTENT(IN) :: PAEPS
REAL, INTENT(IN) :: PSGA
REAL, INTENT(IN) :: PSGGA
REAL, INTENT(IN) :: PAA
REAL, INTENT(IN) :: PALX
REAL, INTENT(IN) :: PALG
REAL, INTENT(IN) :: PALGP1
REAL, INTENT(IN) :: PAINF
REAL, INTENT(OUT) :: PGSTAR
INTEGER, INTENT(INOUT) :: KFLGST
LOGICAL, INTENT(OUT) :: ORET
!
REAL :: ZSGT, ZT
INTEGER :: JK
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('DGAM:CODE200',0,ZHOOK_HANDLE)
!
ORET = .FALSE.
!
! EVALUATION OF GSTAR(A,X) IN TERMS OF G(A,X)
!
PGSTAR = 1.
!
IF ( KMA>=0 .AND. PAEPS==0. ) THEN
  ORET = .TRUE.        
  IF ( LHOOK ) CALL DR_HOOK('DGAM:CODE200',1,ZHOOK_HANDLE)
  RETURN
ENDIF
!
ZSGT = PSGA*PSGGA
ZT = LOG(PAA) - PX + PA*PALX + PALG - PALGP1
!
IF ( ZT<-XALPREC .OR. ZT>=XTOP ) THEN
  !
  IF ( ZT>=XTOP ) THEN
    KFLGST = 5
    PGSTAR = -ZSGT*PAINF
  ENDIF
  !
  ORET = .TRUE.        
  IF ( LHOOK ) CALL DR_HOOK('DGAM:CODE200',1,ZHOOK_HANDLE)
  RETURN
  !
ENDIF
!
PGSTAR = 1. - ZSGT*EXP(ZT)
!
IF (LHOOK) CALL DR_HOOK('DGAM:CODE200',1,ZHOOK_HANDLE)
!
END SUBROUTINE CODE200
!
!
SUBROUTINE CODE180(KMA, PX, PA, PAE, PAEPS, PSGA, PSGGA, PAA, PALX, &
                   PALGP1, PAINF, PG, PGSTAR, KFLGST, ORET)
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KMA
REAL, INTENT(IN) :: PX
REAL, INTENT(IN) :: PA
REAL, INTENT(IN) :: PAE
REAL, INTENT(IN) :: PAEPS
REAL, INTENT(IN) :: PSGA
REAL, INTENT(IN) :: PSGGA
REAL, INTENT(IN) :: PAA
REAL, INTENT(IN) :: PALX
REAL, INTENT(IN) :: PALGP1
REAL, INTENT(IN) :: PAINF
REAL, INTENT(INOUT) :: PG
REAL, INTENT(OUT) :: PGSTAR
INTEGER, INTENT(INOUT) :: KFLGST
LOGICAL, INTENT(OUT) :: ORET
!
REAL :: ZALG
INTEGER :: JK
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('DGAM:CODE180',0,ZHOOK_HANDLE)
!
PG = PG*EXP(PX)*PX**(-PAE)
!
DO JK = 1,KMA
  PG = (1.-PX*PG)/(JK-PAE)
ENDDO
!
ZALG = LOG(PG)
!
! EVALUATION OF GSTAR(A,X) IN TERMS OF G(A,X)
!
 CALL CODE200(KMA, PX, PA, PAEPS, PSGA, PSGGA, PAA, PALX, &
              ZALG, PALGP1, PAINF, &
              PGSTAR, KFLGST, ORET)
!
IF (LHOOK) CALL DR_HOOK('DGAM:CODE180',1,ZHOOK_HANDLE)
!
END SUBROUTINE CODE180
!
!
FUNCTION DLGA(PDX) RESULT(PDLGAR)

USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB

IMPLICIT NONE

REAL :: PDLGAR
!
REAL, INTENT(IN) :: PDX
!
REAL :: ZDC, ZDP, ZDY, ZDT, ZDS
!
REAL,DIMENSION(8),PARAMETER :: &
        XDBNUM=(/-3617., 1., -691., 1., -1., 1., -1., 1./)
REAL,DIMENSION(8),PARAMETER :: &
        XDBDEN=(/122400., 156., 360360., 1188., 1680., 1260., 360. , 12./)
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('DGAMM:DLGA',0,ZHOOK_HANDLE)

ZDC = 0.5*LOG(8.*ATAN(1.))
ZDP = 1.
ZDY = PDX
ZY  = ZDY
!
! THE CONDITIONAL CLAUSE IN THE NEXT STATEMENT EXPRESSES THE
! INEQUALITY Y.GT.EXP(.121189*DPREC+.053905), WHERE DPREC IS THE
! NUMBER OF DECIMAL DIGITS CARRIED IN REAL*8 FLOATING-POINT
! ARITHMETIC.
!
!RJ-remark this magic number is for 53 significant bit prec only +/-!!!!
DO WHILE ( ZY<=35.027 )
  ZDP = ZDY*ZDP
  ZDY = ZDY + 1.
  ZY  = ZDY
ENDDO
!
ZDT = 1./(ZDY*ZDY)
ZDS = 43867./244188.
!
DO JI=1,8
  ZDS = ZDT*ZDS + XDBNUM(JI)/XDBDEN(JI)
ENDDO
!
PDLGAR = (ZDY-0.5)*LOG(ZDY) - ZDY + ZDC + ZDS/ZDY - LOG(ZDP)
!
IF (LHOOK) CALL DR_HOOK('DGAMM:DLGA',1,ZHOOK_HANDLE)
!
END FUNCTION DLGA

END SUBROUTINE DGAM
