!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
SUBROUTINE OL_DEFINE_DIM (UG, KSIZE_FULL, HPROGRAM, KLUOUT, KNI, &
                          KDIM1, HUNIT1, HUNIT2, PX, PY, KDIMS,  &
                          KDDIM, HNAME_DIM, KNPATCH, KNSNLAYER, PLAT, PLON)
!     #######################################################
!!****  *OL_DEFINE_DIM* - 
!!
!!    PURPOSE
!!    -------
!!
      !!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      S. Faroux   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    06/2010 
!!      07/2011     add specific computation for IGN grid (B. Decharme)
!!      09/2015     M. Lafaysse : snow layer dimension
!-------------------------------------------------------------------------------                         
!
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
!
USE MODD_IO_SURF_OL, ONLY: NMASK_IGN
!
USE MODN_IO_OFFLINE, ONLY : LWRITE_COORD
!
USE MODI_GET_GRID_DIM
USE MODI_GET_GRID_COORD
USE MODI_GET_IGN_MASKALL
!
USE MODE_GRIDTYPE_IGN
USE MODE_GRIDTYPE_CONF_PROJ
USE MODE_GRIDTYPE_LONLAT_ROT
USE MODE_GRIDTYPE_LONLAT_REG
USE MODE_GRIDTYPE_GAUSS
USE MODE_GRIDTYPE_CARTESIAN
USE MODE_GRIDTYPE_LONLATVAL
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE NETCDF
!
IMPLICIT NONE
!
!
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
!
INTEGER, INTENT(IN) :: KSIZE_FULL
!
 CHARACTER(LEN=6),  INTENT(IN)    :: HPROGRAM
INTEGER, INTENT(IN)              :: KLUOUT
INTEGER, INTENT(IN)              :: KNI
INTEGER, INTENT(OUT)             :: KDIM1
 CHARACTER(LEN=13) , DIMENSION(:), INTENT(OUT) :: HUNIT1, HUNIT2
!
REAL,DIMENSION(:), POINTER                 :: PX, PY
INTEGER, DIMENSION(:), POINTER             :: KDIMS, KDDIM
 CHARACTER(LEN=100), DIMENSION(:), POINTER :: HNAME_DIM
INTEGER, OPTIONAL, INTENT(IN)              :: KNPATCH
INTEGER, OPTIONAL, INTENT(IN)              :: KNSNLAYER
REAL, DIMENSION(:), OPTIONAL, POINTER      :: PLAT, PLON
!
REAL, DIMENSION(:), ALLOCATABLE  :: ZXFULL, ZYFULL, ZDXFULL, ZDYFULL, ZLAT_XY, ZLON_XY
REAL, DIMENSION(KNI)             :: ZXX, ZYY
REAL                             :: ZLAT0,ZLON0,ZRPK,ZBETA,ZLATOR,ZLONOR,ZCODIL,&
                                    ZLAPO,ZLOPO
 CHARACTER(LEN=3)                :: YTYPE
INTEGER, DIMENSION(:), ALLOCATABLE :: INLOPA
INTEGER                          :: JJ, ILAMBERT, IFULL, IDIM1, IL, IIMAX, IJMAX
INTEGER                          :: INDIMS, INDIMSMAX, IDIM2, INLATI
INTEGER                          :: INSNLAYER, INPATCH, ID
LOGICAL                          :: GRECT     ! T if rectangular grid
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('OL_DEFINE_DIM',0,ZHOOK_HANDLE)
!
NULLIFY(PX)
NULLIFY(PY)
!
INSNLAYER = 0
IF (PRESENT(KNSNLAYER)) INSNLAYER = KNSNLAYER
!
INPATCH = 0
IF (PRESENT(KNPATCH)) INPATCH = KNPATCH
!
KDIM1 = 0
IDIM2 = 0
!
YTYPE='XY '
IF (UG%G%CGRID.EQ.'LONLAT REG'.OR.UG%G%CGRID.EQ.'LONLATVAL '.OR.UG%G%CGRID.EQ.'LONLAT ROT') YTYPE='LON'
!
IF (.NOT.LWRITE_COORD) THEN
  !
  IF ( UG%G%CGRID.EQ.'CONF PROJ ' .OR. UG%G%CGRID.EQ.'CARTESIAN '&
  .OR. UG%G%CGRID.EQ.'LONLAT REG' .OR. UG%G%CGRID.EQ.'IGN' ) THEN
    IF (ASSOCIATED(UG%XGRID_FULL_PAR)) THEN
      CALL GET_GRID_DIM(UG%G%CGRID,UG%NGRID_FULL_PAR,UG%XGRID_FULL_PAR,GRECT,KDIM1,IDIM2)
    ELSEIF (ASSOCIATED(UG%G%XGRID_PAR)) THEN
      CALL GET_GRID_DIM(UG%G%CGRID,UG%G%NGRID_PAR,UG%G%XGRID_PAR,GRECT,KDIM1,IDIM2)
    ENDIF
  ENDIF
  !
ENDIF
!
IF ( UG%G%CGRID.EQ.'IGN' ) CALL GET_GRIDTYPE_IGN(UG%XGRID_FULL_PAR,KL=IL,KDIMX=IIMAX,KDIMY=IJMAX)
!
INDIMS = 0
IF ( INPATCH/=0 .AND. INSNLAYER/=0 ) THEN
  INDIMS = 2
ELSEIF ( INPATCH/=0 .OR. INSNLAYER/=0 ) THEN
  INDIMS = 1
ENDIF
!
!
! case LWRITE_COORD = F and regular grid
IF ( KDIM1.NE.0 ) THEN
  INDIMS = INDIMS + 3
ELSEIF ( UG%G%CGRID=="GAUSS     " ) THEN
  INDIMS = INDIMS + 4
ELSEIF (UG%G%CGRID/="LONLATVAL ".AND.(UG%G%CGRID/="IGN       ".OR.IIMAX*IJMAX==IL) ) THEN
  INDIMS = INDIMS + 4
ELSE   
  INDIMS = INDIMS + 2
ENDIF
!
ALLOCATE(KDIMS    (INDIMS))
ALLOCATE(KDDIM    (INDIMS))
ALLOCATE(HNAME_DIM(INDIMS))
!
! case LWRITE_COORD = F and regular grid
IF ( KDIM1.NE.0 ) THEN

  KDIMS(1) = KDIM1
  KDIMS(2) = IDIM2
  IF (YTYPE.EQ.'LON') THEN
    HNAME_DIM(1) = 'lon'
    HNAME_DIM(2) = 'lat'
    HUNIT1(1)    = 'degrees_east'
    HUNIT2(1)    = 'degrees_north'
  ELSE
    HNAME_DIM(1) = 'xx'
    HNAME_DIM(2) = 'yy'
    HUNIT1(1)    = 'meters'
    HUNIT2(1)    = 'meters'
  ENDIF
  ALLOCATE(PX(KDIM1))
  ALLOCATE(PY(IDIM2))
  IDIM1 = KDIM1
  IFULL = KDIM1*IDIM2

! case LWRITE_COORD = T
ELSE

  KDIMS(1) = KNI
  HNAME_DIM(1) = 'Number_of_points' 

  IF (UG%G%CGRID=="GAUSS     ") THEN
   
    HNAME_DIM(2) = "latitude"
    HNAME_DIM(3) = "longitude"
    HUNIT1(1)    = 'degrees_east'
    HUNIT2(1)    = 'degrees_north'     
    CALL GET_GRIDTYPE_GAUSS(UG%XGRID_FULL_PAR,KNLATI=INLATI)
    ALLOCATE(INLOPA(INLATI))
    CALL GET_GRIDTYPE_GAUSS(UG%XGRID_FULL_PAR,KNLOPA=INLOPA)
    KDIMS(2) = INLATI
    KDIMS(3) = MAXVAL(INLOPA)
    DEALLOCATE(INLOPA)

  ELSEIF (UG%G%CGRID/="LONLATVAL ".AND.(UG%G%CGRID/="IGN       ".OR.IIMAX*IJMAX==IL)) THEN
    
    IF (YTYPE.EQ.'LON') THEN
      HNAME_DIM(2) = 'lon'
      HNAME_DIM(3) = 'lat'
      HUNIT1(1)    = 'degrees_east'
      HUNIT2(1)    = 'degrees_north'      
    ELSE
      HNAME_DIM(2) = 'xx'
      HNAME_DIM(3) = 'yy'
      HUNIT1(1)    = 'meters'
      HUNIT2(1)    = 'meters'

    ENDIF
          
    IF (UG%G%CGRID=="CONF PROJ ") THEN
      CALL GET_GRIDTYPE_CONF_PROJ(UG%XGRID_FULL_PAR,KIMAX=IIMAX,KJMAX=IJMAX)
    ELSEIF(UG%G%CGRID=="CARTESIAN ") THEN
      CALL GET_GRIDTYPE_CARTESIAN(UG%XGRID_FULL_PAR,KIMAX=IIMAX,KJMAX=IJMAX)            
    ELSEIF(UG%G%CGRID=="LONLAT REG") THEN
      CALL GET_GRIDTYPE_LONLAT_REG(UG%XGRID_FULL_PAR,KLON=IIMAX,KLAT=IJMAX)
    ELSEIF(UG%G%CGRID=="LONLATROT ") THEN  
      CALL GET_GRIDTYPE_LONLAT_ROT(UG%XGRID_FULL_PAR,KLON=IIMAX,KLAT=IJMAX)            
    ENDIF

    KDIMS(2) = IIMAX
    KDIMS(3) = IJMAX

  ENDIF

  IF (LWRITE_COORD) THEN
    ALLOCATE(PX(KNI))
    ALLOCATE(PY(KNI))
  ENDIF
  IDIM1 = KNI
  IDIM2 = KNI
  IFULL = KNI

ENDIF
!
!
IF (LWRITE_COORD) THEN
  !
  IF (ASSOCIATED(UG%XGRID_FULL_PAR)) THEN
    CALL GET_GRID_COORD(UG%G%CGRID, UG%G%NGRID_PAR, UG%G%XGRID_PAR, KSIZE_FULL, &
                        KLUOUT,PX=PX,PY=PY,KL=KNI,HGRID=UG%G%CGRID,PGRID_PAR=UG%XGRID_FULL_PAR)
  ELSEIF (ASSOCIATED(UG%G%XGRID_PAR)) THEN
    CALL GET_GRID_COORD(UG%G%CGRID, UG%G%NGRID_PAR, UG%G%XGRID_PAR, KSIZE_FULL, &
                        KLUOUT,PX=PX,PY=PY,KL=KNI,HGRID=UG%G%CGRID,PGRID_PAR=UG%G%XGRID_PAR)
  ENDIF
  !
ELSEIF ( UG%G%CGRID.EQ.'CONF PROJ '.OR. UG%G%CGRID.EQ.'CARTESIAN '.OR. &
         UG%G%CGRID.EQ.'LONLAT REG' ) THEN
  !
  IF (ASSOCIATED(UG%XGRID_FULL_PAR)) THEN
    CALL GET_GRID_COORD(UG%G%CGRID, UG%G%NGRID_PAR, UG%G%XGRID_PAR, KSIZE_FULL, &
                        KLUOUT,PX=ZXX,PY=ZYY,KL=KNI,HGRID=UG%G%CGRID,PGRID_PAR=UG%XGRID_FULL_PAR)
  ELSEIF (ASSOCIATED(UG%G%XGRID_PAR)) THEN
    CALL GET_GRID_COORD(UG%G%CGRID, UG%G%NGRID_PAR, UG%G%XGRID_PAR, KSIZE_FULL, &
                        KLUOUT,PX=ZXX,PY=ZYY,KL=KNI,HGRID=UG%G%CGRID,PGRID_PAR=UG%G%XGRID_PAR)
  ENDIF
  !
  IF (ASSOCIATED(PX)) THEN
    DO JJ=1,SIZE(PX)
      PX(JJ)=ZXX(JJ)
    ENDDO
  ENDIF
  IF (ASSOCIATED(PY)) THEN
    DO JJ=1,SIZE(PY)
      PY(JJ)=ZYY((JJ-1)*(KNI/SIZE(PY))+1)
    ENDDO
  ENDIF
!
ELSEIF(UG%G%CGRID.EQ.'IGN       ')THEN
  !
  CALL GET_IGN_MASKALL(UG, KNI, PX, PY)
  !
ENDIF
!
IF (PRESENT(PLAT) .AND. PRESENT(PLON)) THEN
  !
  IF (UG%G%CGRID=="IGN       ".AND.IIMAX*IJMAX/=IL.AND.LWRITE_COORD) THEN
    !
    ALLOCATE(ZXFULL (IFULL),ZYFULL (IFULL))
    ALLOCATE(PLAT   (IFULL),PLON   (IFULL))
    !
    CALL GET_GRIDTYPE_IGN(UG%XGRID_FULL_PAR,KLAMBERT=ILAMBERT,PX=ZXFULL,PY=ZYFULL)
    CALL LATLON_IGN(ILAMBERT,ZXFULL,ZYFULL,PLAT,PLON)

    DEALLOCATE(ZXFULL, ZYFULL)
    !
  ELSEIF (UG%G%CGRID=="LONLATVAL ") THEN
    !
    ALLOCATE(PLAT   (IFULL),PLON   (IFULL))
    CALL GET_GRIDTYPE_LONLATVAL(UG%XGRID_FULL_PAR,PX=PLON,PY=PLAT)
    !
  ELSEIF (UG%G%CGRID=="GAUSS     ") THEN
    !
    ALLOCATE(PLAT   (IFULL),PLON   (IFULL))
    CALL GET_GRIDTYPE_GAUSS(UG%XGRID_FULL_PAR,PLAT=PLAT,PLON=PLON) 
    !
  ELSE
    !
    ALLOCATE(PLAT(0),PLON(0))
    !
  ENDIF
  !
ENDIF
!
!
IF ( INPATCH/=0 ) THEN
  KDIMS     (INDIMS-1) = KNPATCH
  HNAME_DIM (INDIMS-1) = 'Number_of_Patches'
ENDIF
!
IF ( INSNLAYER/=0 ) THEN
  ID = 1
  IF (INPATCH/=0) ID = 2
  KDIMS     (INDIMS-ID) = INSNLAYER
  HNAME_DIM (INDIMS-ID) = 'snow_layer'
ENDIF
!
!
IF (HPROGRAM/='NOTIME ') THEN
  KDIMS     (INDIMS) = NF90_UNLIMITED
  HNAME_DIM (INDIMS) = 'time'
ELSE
  KDIMS     (INDIMS) = 40
  HNAME_DIM (INDIMS) = 'char_len'
ENDIF
!
IF (LHOOK) CALL DR_HOOK('OL_DEFINE_DIM',1,ZHOOK_HANDLE)
!
END SUBROUTINE OL_DEFINE_DIM
