!   #########
    SUBROUTINE TEB_HYDRO(O, T, TH, THP,                                   &
                         PTSTEP, PPS, PRR,                                &
                         PRUNOFF_SEWER, PRUNOFFSOIL_ROAD,PRUNOFFSOIL_BLD, &
                         PDRAIN_ROAD, PDRAIN_BLD                          )
!   ##########################################################################
!
!!****  *TEB_HYDRO*  
!!
!!    PURPOSE
!!    -------
!
!     
!!**  METHOD
!     ------
!
!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!      
!!    REFERENCE
!!    ---------
!!
!!      
!!    AUTHOR
!!    ------
!!
!!	A. Lemonsu          * Meteo-France *
!!
!!    MODIFICATIONS
!!    -------------
!!    Original    02/2013
!-------------------------------------------------------------------------------
!
!*       0.     DECLARATIONS
!               ------------
!
USE MODD_SURF_PAR, ONLY : XUNDEF
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
USE MODD_TEB_n,  ONLY : TEB_t
USE MODD_TEB_HYDRO_n,  ONLY : TEB_HYDRO_t
USE MODD_TEB_HYDRO_PGD_n,  ONLY : TEB_HYDRO_PGD_t
!
USE MODI_URBAN_HYDRO_COND
USE MODI_URBAN_HYDRO_ROAD
USE MODI_URBAN_HYDRO_SOIL
USE MODI_SOILDIF
USE MODI_SEWER
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    Declarations of arguments
!
TYPE(ISBA_OPTIONS_t),    INTENT(INOUT) :: O 
TYPE(TEB_t),       INTENT(INOUT) :: T
TYPE(TEB_HYDRO_t), INTENT(INOUT) :: TH
TYPE(TEB_HYDRO_PGD_t), INTENT(INOUT) :: THP
REAL                ,    INTENT(IN)    :: PTSTEP            ! Time step
REAL, DIMENSION(:)  ,    INTENT(IN)    :: PPS               ! Surface pressure
REAL, DIMENSION(:)  ,    INTENT(IN)    :: PRR               ! Rain rate
REAL, DIMENSION(:),      INTENT(OUT)   :: PRUNOFF_SEWER     ! Groundwater runoff into all sewers
REAL, DIMENSION(:),      INTENT(OUT)   :: PRUNOFFSOIL_ROAD  ! lateral runoff from road soil column
REAL, DIMENSION(:),      INTENT(OUT)   :: PRUNOFFSOIL_BLD   ! lateral runoff from road soil column
REAL, DIMENSION(:),      INTENT(OUT)   :: PDRAIN_ROAD       ! Drainage from road soil column
REAL, DIMENSION(:),      INTENT(OUT)   :: PDRAIN_BLD        ! Drainage from bld  soil column
!
!*      0.2    Declarations of local variables
!
INTEGER                                                             :: JLAYER             ! Loop counter
INTEGER, DIMENSION(SIZE(T%XD_BLD,1))                         :: JWG_LAYER          ! 
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZWSOIL             ! water quantity that infiltrates through the roads (kg/m2)
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZVEG               ! 
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZCV,ZCG,ZCT        ! 
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZFFG,ZFFV          ! 
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZFROZEN1           ! 
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZRUNOFF_INF        ! 
REAL   , DIMENSION(SIZE(T%XD_BLD,1),SIZE(T%XD_BLD,2)) :: ZDZ_ROAD           ! Soil layer thicknesses [m] under roads
REAL   , DIMENSION(SIZE(T%XD_BLD,1),SIZE(T%XD_BLD,2)) :: ZDZ_BLD            ! Soil layer thicknesses [m] under buildings
!
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZFWTD              ! grid-cell fraction of water table to rise
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZWTD               ! water table depth
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZWR                ! canopy intercepted water
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZPIFLOOD           !
REAL   , DIMENSION(SIZE(T%XD_BLD,1),SIZE(T%XD_BLD,2)) :: ZTOPQS             ! Topmodel subsurface flow by layer (m/s)
REAL   , DIMENSION(SIZE(T%XD_BLD,1))                         :: ZQSB               ! Lateral subsurface flow [kg/m²/s]
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*      1.     Initializations
!              ---------------
!
IF (LHOOK) CALL DR_HOOK('TEB_HYDRO',0,ZHOOK_HANDLE)
!
!*      1.a    New soil properties according to hydrological state
!
! Default values
ZVEG(:) = 0.
ZCV (:) = 2.E-5
ZFFG(:) = 0.
ZFFV(:) = 0.
!
JWG_LAYER(:) = SIZE(T%XD_BLD,2)
!
!
ZDZ_BLD(:,1) = T%XD_BLD(:,1)
DO JLAYER=2,SIZE(T%XD_BLD,2)
 ZDZ_BLD(:,JLAYER) = T%XD_BLD(:,JLAYER)-T%XD_BLD(:,JLAYER-1)
ENDDO
!
ZDZ_ROAD(:,1) = T%XD_ROAD(:,1)
DO JLAYER=2,SIZE(T%XD_ROAD,2)
 ZDZ_ROAD(:,JLAYER) = T%XD_ROAD(:,JLAYER)-T%XD_ROAD(:,JLAYER-1)
ENDDO
!
!! UPDATE des proprietes thermiques fait à la fin de teb_garden après l'équilibrage
!! des contenus en eau du sol (Aude 11/04/2019)
!! New properties for soil under buildings
!!
!ZFWTD(:) = 0.
!ZWTD (:) = XUNDEF
!ZWR  (:) = 0.
!!
!CALL SOILDIF (O%CSCOND, .FALSE.,                                                   &
!              ZVEG, ZCV, ZFFG, ZFFV,                                                 &
!              ZCG, ZCT, ZFROZEN1,                                                    &
!              T%XD_BLD, ZDZ_BLD,                                              &
!              T%XT_BLD, TH%XWG_BLD, TH%XWGI_BLD, JWG_LAYER,     &
!             T%XHCAPSOIL_BLD, T%XCONDDRY_BLD, T%XCONDSLD_BLD,  &
!              T%XBCOEF_BLD, T%XWSAT_BLD, T%XMPOTSAT_BLD,        &
!              PSOILCONDZ_BLD, PSOILHCAPZ_BLD,                                        &
!              ZFWTD, ZWTD, ZWR                                                       )
!!
!! New properties for soil under roads
!!
!CALL SOILDIF (O%CSCOND, .FALSE.,                                                    &
!              ZVEG, ZCV, ZFFG, ZFFV,                                                  &
!              ZCG, ZCT, ZFROZEN1,                                                     &
!              T%XD_ROAD,  ZDZ_ROAD,                                            &
!              T%XT_ROAD, TH%XWG_ROAD, TH%XWGI_ROAD, JWG_LAYER,   &
!              T%XHCAPSOIL_ROAD, T%XCONDDRY_ROAD, T%XCONDSLD_ROAD,&
!              T%XBCOEF_ROAD, T%XWSAT_ROAD, T%XMPOTSAT_ROAD,      &
!              PSOILCONDZ_ROAD, PSOILHCAPZ_ROAD,                                       &
!              ZFWTD, ZWTD, ZWR                                                        )
!
!-------------------------------------------------------------------------------
!
!*      2.     Hydrology for buildings subsoil
!              -------------------------------
!
! No water infiltration for buildings
ZWSOIL(:) = 0.
!
CALL URBAN_HYDRO_SOIL(O,THP%XURBDRAIN,                              &
                      PTSTEP, PPS, ZWSOIL, T%XT_BLD, T%XD_BLD,      &
                      T%XWSAT_BLD, T%XWFC_BLD, T%XWWILT_BLD,        &
                      T%XCONDSAT_BLD, T%XMPOTSAT_BLD, T%XBCOEF_BLD, &
                      TH%XWG_BLD, TH%XWGI_BLD,                      &
                      PRUNOFFSOIL_BLD,  PDRAIN_BLD,                 &
                      ZFWTD, ZWTD, ZTOPQS, ZQSB                     )
!
!-------------------------------------------------------------------------------
!
!*      3.     Hydrology for roads subsoil
!              ---------------------------
!
!*      3.a    Surface hydrology including water infiltration
!
CALL URBAN_HYDRO_ROAD(THP%XWS_ROAD_MAX, THP%XINFIL_ROAD,            &
                      T%XWS_ROAD, PRR, PTSTEP,                      & 
                      ZWSOIL                                        )
!
!*      3.b    Subsoil hydrology based on ISDA-DF
!
CALL URBAN_HYDRO_SOIL(O, THP%XURBDRAIN,                                &
                      PTSTEP, PPS, ZWSOIL/PTSTEP,                      &
                      T%XT_ROAD, T%XD_ROAD,                            &
                      T%XWSAT_ROAD, T%XWFC_ROAD, T%XWWILT_ROAD,        &
                      T%XCONDSAT_ROAD, T%XMPOTSAT_ROAD, T%XBCOEF_ROAD, &
                      TH%XWG_ROAD, TH%XWGI_ROAD,                       &
                      PRUNOFFSOIL_ROAD, PDRAIN_ROAD,                   &                    
                      ZFWTD, ZWTD, ZTOPQS, ZQSB                        )
!
!*      3.c    Calculation of hydraulic conductivity
!
! - for soil column under buildings
!
CALL URBAN_HYDRO_COND(T%XBCOEF_BLD, T%XWSAT_BLD ,             &
                      T%XCONDSAT_BLD, T%XMPOTSAT_BLD ,        &
                      TH%XWG_BLD, TH%XWGI_BLD, JWG_LAYER,     &
                      TH%XCOND_BLD                            )
!
! - for soil column under roads
!
CALL URBAN_HYDRO_COND(T%XBCOEF_ROAD, T%XWSAT_ROAD,              &
                      T%XCONDSAT_ROAD, T%XMPOTSAT_ROAD,         &
                      TH%XWG_ROAD, TH%XWGI_ROAD, JWG_LAYER,     &
                      TH%XCOND_ROAD                             )
!
!*      3.d    Infiltration through sewer
!
CALL SEWER(PTSTEP,                                                             &
           TH%XWG_ROAD, T%XD_ROAD,                                             &
           T%XWSAT_ROAD, T%XWWILT_ROAD, T%XCONDSAT_ROAD,                       &
           THP%XDENSITY_SEWER, THP%NLAYER_SEWER, THP%XIP_SEWER, TH%XCOND_ROAD, &
           PRUNOFF_SEWER                                                       )
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('TEB_HYDRO',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE TEB_HYDRO
