!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE READ_PGD_TEB_GARDEN_PAR_n (DTV, IO, T, TOP, KDIM, HPROGRAM)
!     ################################################
!
!!****  *READ_PGD_TEB_GARDEN_PAR_n* - reads ISBA physiographic fields
!!                        
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003 
!!      P. Le Moigne 12/2004 : add type of photosynthesis
!!      R. Alkama    05/2012 : Add 7 new vegtypes (19 rather than 12)
!!      B. Decharme    05/13 : new param for equatorial forest
!!      E.Redon/A.Lemonsu 12/2015 : New fields for urban trees (if CURBTREE = 'TREE' or 'GRWL')
!!      K.Chancibault/A.Lemonsu 01/2016 : New fields for urban hydrology (if LURBHYDRO=TRUE)
!!      M. Goret                03/2017 : Replace if statemenents by select case
!!      M. Goret                08/2017 add RE25 in NAM_DATA_TEB_GARDEN namelist
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
!
!
USE MODD_TEB_n,          ONLY : TEB_t
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
USE MODD_TEB_OPTION_n,        ONLY : TEB_OPTIONS_t
!
USE MODD_CSTS,              ONLY : XDAY
USE MODD_SURF_PAR,          ONLY : XUNDEF
USE MODD_ISBA_PAR,          ONLY : XOPTIMGRID, NOPTIMLAYER
USE MODD_DATA_COVER_PAR,    ONLY : NVT_NO, NVT_ROCK, NVT_SNOW, NVT_TEBD,     & 
                                     NVT_BONE, NVT_TRBE, NVT_C3, NVT_C4,     &
                                     NVT_IRR, NVT_GRAS, NVT_TROG,NVT_PARK,   &
                                     NVT_TRBD, NVT_TEBE, NVT_TENE, NVT_BOBD, &
                                     NVT_BOND, NVT_BOGR, NVT_SHRB, NVT_C3W,  &
                                     NVT_C3S, NVT_FLTR, NVT_FLGR, NVEGTYPE
!
USE MODI_READ_SURF
USE MODI_VEG_FROM_LAI
USE MODI_Z0V_FROM_LAI
USE MODI_EMIS_FROM_VEG
USE MODI_ABOR1_SFX
USE MODI_GET_LUOUT
!
USE MODD_REPROD_OPER,    ONLY : XEVERG_RSMIN
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
!
!
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTV
TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
TYPE(TEB_OPTIONS_t),  INTENT(INOUT) :: TOP
TYPE(TEB_t),     INTENT(INOUT) :: T
INTEGER, INTENT(IN) :: KDIM
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER                               :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=12)                     :: YRECFM         ! Name of the article to be read
CHARACTER(LEN=100)                    :: YCOMMENT       ! Comment string
INTEGER                               :: JI, JLAYER     ! loop index
INTEGER                               :: JTIME          ! loop index
!
REAL, DIMENSION(KDIM,3)               :: ZDATA_RSMIN
REAL, DIMENSION(KDIM,3)               :: ZDATA_GAMMA
REAL, DIMENSION(KDIM,3)               :: ZDATA_WRMAX_CF
REAL, DIMENSION(KDIM,3)               :: ZDATA_RGL
REAL, DIMENSION(KDIM,3)               :: ZDATA_CV
REAL, DIMENSION(KDIM,IO%NGROUND_LAYER,3) :: ZDATA_DG
REAL, DIMENSION(KDIM,3)               :: ZDATA_ALBNIR_VEG
REAL, DIMENSION(KDIM,3)               :: ZDATA_ALBVIS_VEG
REAL, DIMENSION(KDIM,3)               :: ZDATA_ALBUV_VEG
REAL, DIMENSION(KDIM,3)               :: ZDATA_GMES
REAL, DIMENSION(KDIM,3)               :: ZDATA_RE25
REAL, DIMENSION(KDIM,3)               :: ZDATA_BSLAI
REAL, DIMENSION(KDIM,3)               :: ZDATA_LAIMIN
REAL, DIMENSION(KDIM,3)               :: ZDATA_SEFOLD
REAL, DIMENSION(KDIM,3)               :: ZDATA_GC
REAL, DIMENSION(KDIM,3)               :: ZDATA_DMAX
REAL, DIMENSION(KDIM,3)               :: ZDATA_CE_NITRO
REAL, DIMENSION(KDIM,3)               :: ZDATA_CF_NITRO
REAL, DIMENSION(KDIM,3)               :: ZDATA_CNA_NITRO
!
REAL, DIMENSION(KDIM)                 :: ZPROP_HVEG
REAL, DIMENSION(KDIM)                 :: ZPROP_LVEG
REAL, DIMENSION(KDIM)                 :: ZPROP_NVEG
!
LOGICAL :: GAGRI_TO_GRASS
!
INTEGER :: JJ      ! Loop index
INTEGER :: ILUOUT  ! Logical unit of output file
!
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*       1.    Reading of PGD file
!              --------------------
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_GARDEN_PAR_N',0,ZHOOK_HANDLE)
DTV%NTIME= 12
CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
GAGRI_TO_GRASS=.FALSE.
!
YRECFM='GD_NTIME'
CALL READ_SURF(HPROGRAM,YRECFM,DTV%NTIME,IRESP,HCOMMENT=YCOMMENT)
!
DTV%LIMP_VEG=.FALSE.
DTV%LIMP_Z0=.FALSE.
DTV%LIMP_EMIS=.FALSE.
!
!
!-------------------------------------------------------------------------------
!
!*       2.    Definition of ISBA parameters (LAI of low and high vegetation, types of bare soil, low and high vegetation)
!              -----------------------------
!
! Read type of low vegetation
YRECFM='D_TYPE_LVEG'
 CALL READ_SURF(HPROGRAM,YRECFM,IO%CTYPE_LVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Read type of bare soil (no vegetation)
YRECFM='D_TYPE_NVEG'
 CALL READ_SURF(HPROGRAM,YRECFM,IO%CTYPE_NVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Read type of high vegetation
YRECFM='D_TYPE_HVEG'
 CALL READ_SURF(HPROGRAM,YRECFM,IO%CTYPE_HVEG,IRESP,HCOMMENT=YCOMMENT)
!
ALLOCATE(DTV%XPAR_LAI_HVEG  (KDIM,DTV%NTIME))
ALLOCATE(DTV%XPAR_LAI_LVEG  (KDIM,DTV%NTIME))
!
IF (TOP%CURBTREE == 'TREE' .OR. TOP%CURBTREE == 'GRWL') THEN
  !
  ALLOCATE(DTV%XPAR_H_VEG       (KDIM,1,1))
  ALLOCATE(DTV%XPAR_HTRUNK_HVEG (KDIM))!cecile : dim correcte ?
  ALLOCATE(DTV%XPAR_WCROWN_HVEG (KDIM))!cecile : dim correcte ?
  !
  ! Read height of trees(for high vegetation)
  YRECFM='D_GD_H_VEG'
  CALL READ_SURF(HPROGRAM,YRECFM,DTV%XPAR_H_VEG(:,1,1),IRESP,HCOMMENT=YCOMMENT)
  ! Read height of tree trunks(for high vegetation)                              !cecile
  YRECFM='D_HTRUN_HVEG'                                                          !cecile
  CALL READ_SURF(HPROGRAM,YRECFM,DTV%XPAR_HTRUNK_HVEG(:),IRESP,HCOMMENT=YCOMMENT)!cecile
  ! Read width of tree trunks(for high vegetation)                               !cecile
  YRECFM='D_WCROW_HVEG'                                                          !cecile
  CALL READ_SURF(HPROGRAM,YRECFM,DTV%XPAR_WCROWN_HVEG(:),IRESP,HCOMMENT=YCOMMENT)!cecile
  !
ENDIF
!
! Read LAI of high vegetation
DO JTIME=1,DTV%NTIME
  WRITE(YRECFM,FMT='(A10,I2.2)') 'D_LAI_HVEG',JTIME
  CALL READ_SURF(HPROGRAM,YRECFM,DTV%XPAR_LAI_HVEG(:,JTIME),IRESP,HCOMMENT=YCOMMENT)
  WRITE(YRECFM,FMT='(A10,I2.2)') 'D_LAI_LVEG',JTIME
  CALL READ_SURF(HPROGRAM,YRECFM,DTV%XPAR_LAI_LVEG(:,JTIME),IRESP,HCOMMENT=YCOMMENT)
END DO
!
!-------------------------------------------------------------------------------
!
!*       3.    Deduction of other ISBA parameters (vegtype, LAI, and secondary parameters)
!              ----------------------------------
!
!
ALLOCATE(DTV%XPAR_LAI        (KDIM,DTV%NTIME,1))
ALLOCATE(DTV%XPAR_VEG        (KDIM,DTV%NTIME,1))
ALLOCATE(DTV%XPAR_RSMIN      (KDIM,1))
ALLOCATE(DTV%XPAR_GAMMA      (KDIM,1))
ALLOCATE(DTV%XPAR_WRMAX_CF   (KDIM,1))
ALLOCATE(DTV%XPAR_RGL        (KDIM,1))
ALLOCATE(DTV%XPAR_CV         (KDIM,1))
ALLOCATE(DTV%XPAR_DG         (KDIM,IO%NGROUND_LAYER,1))
ALLOCATE(DTV%XPAR_ROOTFRAC   (KDIM,IO%NGROUND_LAYER,1))
ALLOCATE(DTV%XPAR_DICE       (KDIM,1))
ALLOCATE(DTV%XPAR_Z0         (KDIM,DTV%NTIME,1))
ALLOCATE(DTV%XPAR_Z0_O_Z0H   (KDIM,1))
ALLOCATE(DTV%XPAR_ALBNIR_VEG (KDIM,1,1))
ALLOCATE(DTV%XPAR_ALBVIS_VEG (KDIM,1,1))
ALLOCATE(DTV%XPAR_ALBUV_VEG  (KDIM,1,1))
ALLOCATE(DTV%XPAR_ALBNIR_SOIL(KDIM,1,1))
ALLOCATE(DTV%XPAR_ALBVIS_SOIL(KDIM,1,1))
ALLOCATE(DTV%XPAR_ALBUV_SOIL (KDIM,1,1))
ALLOCATE(DTV%XPAR_EMIS       (KDIM,DTV%NTIME,1))
ALLOCATE(DTV%XPAR_VEGTYPE    (KDIM,NVEGTYPE))
ALLOCATE(DTV%XPAR_GMES       (KDIM,1))
ALLOCATE(DTV%XPAR_RE25       (KDIM,1))
ALLOCATE(DTV%XPAR_BSLAI      (KDIM,1))
ALLOCATE(DTV%XPAR_LAIMIN     (KDIM,1))
ALLOCATE(DTV%XPAR_SEFOLD     (KDIM,1))
ALLOCATE(DTV%XPAR_GC         (KDIM,1))
ALLOCATE(DTV%XPAR_DMAX       (KDIM,1))
ALLOCATE(DTV%XPAR_F2I        (KDIM,1))
ALLOCATE(DTV%LPAR_STRESS     (KDIM,1))
ALLOCATE(DTV%XPAR_H_TREE     (KDIM,1))
ALLOCATE(DTV%XPAR_CE_NITRO   (KDIM,1))
ALLOCATE(DTV%XPAR_CF_NITRO   (KDIM,1))
ALLOCATE(DTV%XPAR_CNA_NITRO  (KDIM,1))
!
DTV%XPAR_LAI        (:,:,:) = XUNDEF
DTV%XPAR_VEG        (:,:,:) = XUNDEF
DTV%XPAR_RSMIN        (:,:) = XUNDEF
DTV%XPAR_GAMMA        (:,:) = XUNDEF
DTV%XPAR_WRMAX_CF     (:,:) = XUNDEF
DTV%XPAR_RGL          (:,:) = XUNDEF
DTV%XPAR_CV           (:,:) = XUNDEF
DTV%XPAR_DG         (:,:,:) = XUNDEF
DTV%XPAR_DICE       (:,:)   = XUNDEF
DTV%XPAR_ROOTFRAC   (:,:,:) = XUNDEF
DTV%XPAR_Z0         (:,:,:) = XUNDEF
DTV%XPAR_Z0_O_Z0H     (:,:) = XUNDEF
DTV%XPAR_ALBNIR_VEG   (:,:,:) = XUNDEF
DTV%XPAR_ALBVIS_VEG   (:,:,:) = XUNDEF
DTV%XPAR_ALBUV_VEG    (:,:,:) = XUNDEF
DTV%XPAR_ALBNIR_SOIL  (:,:,:) = XUNDEF
DTV%XPAR_ALBVIS_SOIL  (:,:,:) = XUNDEF
DTV%XPAR_ALBUV_SOIL   (:,:,:) = XUNDEF
DTV%XPAR_EMIS       (:,:,:) = XUNDEF
DTV%XPAR_VEGTYPE    (:,:) = XUNDEF
DTV%XPAR_GMES         (:,:) = XUNDEF
DTV%XPAR_RE25         (:,:) = XUNDEF
DTV%XPAR_BSLAI        (:,:) = XUNDEF
DTV%XPAR_LAIMIN       (:,:) = XUNDEF
DTV%XPAR_SEFOLD       (:,:) = XUNDEF
DTV%XPAR_GC           (:,:) = XUNDEF
DTV%XPAR_DMAX         (:,:) = XUNDEF
DTV%XPAR_F2I          (:,:) = XUNDEF
DTV%LPAR_STRESS       (:,:) = .FALSE.
DTV%XPAR_H_TREE       (:,:) = XUNDEF
DTV%XPAR_CE_NITRO     (:,:) = XUNDEF
DTV%XPAR_CF_NITRO     (:,:) = XUNDEF
DTV%XPAR_CNA_NITRO    (:,:) = XUNDEF
!
! proportion of each low, high or no vegtype present relative to total of vegetation
!
! This is used to compute aggregated vegetation secondary parameters and vegtypes
!
ZPROP_HVEG = 0.
ZPROP_LVEG = 0.
ZPROP_NVEG = 0.
!
WHERE ( T%XFRAC_HVEG + T%XFRAC_LVEG + T%XFRAC_NVEG >0.)
  ZPROP_HVEG = T%XFRAC_HVEG / ( T%XFRAC_HVEG + T%XFRAC_LVEG + T%XFRAC_NVEG )
  ZPROP_LVEG = T%XFRAC_LVEG / ( T%XFRAC_HVEG + T%XFRAC_LVEG + T%XFRAC_NVEG )
  ZPROP_NVEG = T%XFRAC_NVEG / ( T%XFRAC_HVEG + T%XFRAC_LVEG + T%XFRAC_NVEG )
END WHERE

! Vegtypes

DTV%XPAR_VEGTYPE(:,:) = 0.
IF (IO%CTYPE_NVEG == 'NO  ') DTV%XPAR_VEGTYPE(:, NVT_NO  ) = ZPROP_NVEG(:)
IF (IO%CTYPE_NVEG == 'ROCK') DTV%XPAR_VEGTYPE(:, NVT_ROCK) = ZPROP_NVEG(:)
IF (IO%CTYPE_NVEG == 'SNOW') DTV%XPAR_VEGTYPE(:, NVT_SNOW) = ZPROP_NVEG(:)
IF (IO%CTYPE_HVEG == 'TEBD') DTV%XPAR_VEGTYPE(:, NVT_TEBD) = ZPROP_HVEG(:)
IF (IO%CTYPE_HVEG == 'TRBD') DTV%XPAR_VEGTYPE(:, NVT_TRBD) = ZPROP_HVEG(:)
IF (IO%CTYPE_HVEG == 'TEBE') DTV%XPAR_VEGTYPE(:, NVT_TEBE) = ZPROP_HVEG(:)
IF (IO%CTYPE_HVEG == 'BOBD') DTV%XPAR_VEGTYPE(:, NVT_BOBD) = ZPROP_HVEG(:)
IF (IO%CTYPE_HVEG == 'SHRB') DTV%XPAR_VEGTYPE(:, NVT_SHRB) = ZPROP_HVEG(:)
IF (IO%CTYPE_HVEG == 'BONE') DTV%XPAR_VEGTYPE(:, NVT_BONE) = ZPROP_HVEG(:)
IF (IO%CTYPE_HVEG == 'TENE') DTV%XPAR_VEGTYPE(:, NVT_TENE) = ZPROP_HVEG(:)
IF (IO%CTYPE_HVEG == 'BOND') DTV%XPAR_VEGTYPE(:, NVT_BOND) = ZPROP_HVEG(:)
IF (IO%CTYPE_HVEG == 'TRBE') DTV%XPAR_VEGTYPE(:, NVT_TRBE) = ZPROP_HVEG(:)
!
IF (IO%CTYPE_LVEG == 'C3  ') THEN
  IF (NVT_C3>0) THEN
    DTV%XPAR_VEGTYPE(:, NVT_C3  ) = ZPROP_LVEG(:)
  ELSEIF (NVT_C3W>0) THEN
    DTV%XPAR_VEGTYPE(:, NVT_C3W ) = ZPROP_LVEG(:)
  ENDIF
ENDIF
!
IF (IO%CTYPE_LVEG == 'C3W ') THEN
  IF (NVT_C3W>0) THEN
    DTV%XPAR_VEGTYPE(:, NVT_C3W ) = ZPROP_LVEG(:)
  ELSE
    CALL ABOR1_SFX("READ_PGD_TEB_GARDEN_PAR: NO VEGTYPE C3W WITHOUT ECOSG")
  ENDIF
ENDIF
!
IF (IO%CTYPE_LVEG == 'C3S ') THEN
  IF (NVT_C3S>0) THEN
    DTV%XPAR_VEGTYPE(:, NVT_C3S ) = ZPROP_LVEG(:)
  ELSE
    CALL ABOR1_SFX("READ_PGD_TEB_GARDEN_PAR: NO VEGTYPE C3S WITHOUT ECOSG")
  ENDIF
ENDIF
!
IF (IO%CTYPE_LVEG == 'C4  ') DTV%XPAR_VEGTYPE(:, NVT_C4  ) = ZPROP_LVEG(:)
!
IF (IO%CTYPE_LVEG == 'IRR ') THEN
  IF (NVT_IRR>0) THEN
    DTV%XPAR_VEGTYPE(:, NVT_IRR ) = ZPROP_LVEG(:)
  ELSE
    CALL ABOR1_SFX("READ_PGD_TEB_GARDEN_PAR: NO VEGTYPE IRR WITH ECOSG")
  ENDIF
ENDIF
!
IF (IO%CTYPE_LVEG == 'GRAS') DTV%XPAR_VEGTYPE(:, NVT_GRAS) = ZPROP_LVEG(:)
IF (IO%CTYPE_LVEG == 'BOGR') DTV%XPAR_VEGTYPE(:, NVT_BOGR) = ZPROP_LVEG(:)
IF (IO%CTYPE_LVEG == 'TROG') DTV%XPAR_VEGTYPE(:, NVT_TROG) = ZPROP_LVEG(:)
!
IF (IO%CTYPE_LVEG == 'PARK') THEN
  IF (NVT_PARK>0) THEN
    DTV%XPAR_VEGTYPE(:, NVT_PARK) = ZPROP_LVEG(:)
  ELSEIF (NVT_FLGR>0) THEN
    DTV%XPAR_VEGTYPE(:, NVT_FLGR) = ZPROP_LVEG(:)
  ENDIF
ENDIF
!
IF (IO%CTYPE_LVEG == 'FLGR') THEN
  IF (NVT_FLGR>0) THEN
    DTV%XPAR_VEGTYPE(:, NVT_FLGR) = ZPROP_LVEG(:)
  ELSE
    CALL ABOR1_SFX("READ_PGD_TEB_GARDEN_PAR: NO VEGTYPE FLGR WITHOUT ECOSG")
  ENDIF
ENDIF
IF (IO%CTYPE_LVEG == 'FLTR') THEN
  IF (NVT_FLTR>0) THEN
    DTV%XPAR_VEGTYPE(:, NVT_FLTR) = ZPROP_HVEG(:)
  ELSE
    CALL ABOR1_SFX("READ_PGD_TEB_GARDEN_PAR: NO VEGTYPE FLTR WITHOUT ECOSG")
  ENDIF
ENDIF

IF (ANY(ABS(SUM(DTV%XPAR_VEGTYPE(:,:),DIM=2)-1.)>1.E-6)) THEN
  WRITE(ILUOUT,*) 'Error in namelist NAM_DATA_TEB_GARDEN'
  WRITE(ILUOUT,*) 'Please check the type of vegetation in CTYP_GARDEN_HVEG, CTYP_GARDEN_LVEG and CTYP_GARDEN_NVEG'
  WRITE(ILUOUT,*) 'Currently, wrong types lead to incoherent vegetation type fractions (total not equal to 1).'
  CALL ABOR1_SFX("READ_PGD_TEB_GARDEN_PAR: sum of VEGTYPE fractions not equal to 1")
END IF

! end of vegtypes
!
! FIXME: H_TREE seems to be used even for not TREE
!
! Height of trees
IF (TOP%CURBTREE == 'TREE' .OR. TOP%CURBTREE == 'GRWL') THEN
   DTV%XPAR_H_TREE  (:,1) = DTV%XPAR_H_VEG(:,1,1)
ELSE
   DTV%XPAR_H_TREE  (:,1) = 0.0
ENDIF
!
! Critical normilized soil water content for stress parameterisation
DTV%XPAR_F2I     (:,1) = 0.3
!
! Ratio between roughness length for momentum and heat
DTV%XPAR_Z0_O_Z0H(:,1) = 10.
!
! Defensive/offensive strategy (1/0)
DTV%LPAR_STRESS  (:,1) = .FALSE. 
!
DO JI=1,KDIM
!
! Near-IR, visible, and UV albedo (vegetation only)

 ZDATA_ALBNIR_VEG(JI,:)= 0.30!-------------------------------------------------------------------------------
!
!*       2.    Definition of ISBA parameters (type, LAI, and secondary parameters)
!              -----------------------------
!
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.15
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.15
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.15
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.21
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_ALBNIR_VEG(JI,1) = 0.25
 ENDIF

 ZDATA_ALBVIS_VEG(JI,:)= 0.10
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_ALBVIS_VEG(JI,1) = 0.05
 ENDIF

 ZDATA_ALBUV_VEG (JI,:)= 0.06
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0525
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0525
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0525
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0525
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0525
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0425
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0425
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0425
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0380 
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_ALBUV_VEG(JI,1) = 0.0525
 ENDIF 
 IF(DTV%XPAR_VEGTYPE(JI,NVT_GRAS)>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.0800
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOGR)>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.0800 
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TROG)>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.1250
 IF (NVT_IRR>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_IRR )>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.0450
 ENDIF
 IF (NVT_PARK>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_PARK)>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.0450
 ELSEIF (NVT_FLGR>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_FLGR)>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.0450
 ENDIF

 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.) THEN
  DTV%XPAR_ALBNIR_VEG(JI,1,1) =  ( ZDATA_ALBNIR_VEG(JI,1)*ZPROP_HVEG(JI)   &
                            + ZDATA_ALBNIR_VEG(JI,2)*ZPROP_LVEG(JI) ) &
                          / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI)    )  
!
  DTV%XPAR_ALBVIS_VEG(JI,1,1) =  ( ZDATA_ALBVIS_VEG(JI,1)*ZPROP_HVEG(JI)   &
                            + ZDATA_ALBVIS_VEG(JI,2)*ZPROP_LVEG(JI) ) &
                          / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI)    )  
! 
  DTV%XPAR_ALBUV_VEG (JI,1,1) =  ( ZDATA_ALBUV_VEG (JI,1)*ZPROP_HVEG(JI)   &
                            + ZDATA_ALBUV_VEG (JI,2)*ZPROP_LVEG(JI) ) &
                          / ( ZPROP_HVEG (JI)+ZPROP_LVEG(JI)   )  
 ENDIF 
!
! Min stomatal resistance
 ZDATA_RSMIN(JI,:)= 40.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_RSMIN(JI,1) = 150.
 ENDIF 
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_RSMIN(JI,1)= XEVERG_RSMIN
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TROG)>0. )  ZDATA_RSMIN(JI,2)= 120.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_RSMIN(JI,2)= 120.
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)              &
    DTV%XPAR_RSMIN(JI,1) =  ( ZDATA_RSMIN(JI,1)*ZPROP_HVEG(JI)     &
                       + ZDATA_RSMIN(JI,2)*ZPROP_LVEG(JI)   ) &
                     / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI) )  
!
! Gamma parameter
 ZDATA_GAMMA(JI,:)= 0.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_GAMMA(JI,1) = 0.04
 ENDIF 
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)              &
    DTV%XPAR_GAMMA(JI,1) =  ( ZDATA_GAMMA(JI,1)*ZPROP_HVEG(JI)     &
                       + ZDATA_GAMMA(JI,2)*ZPROP_LVEG(JI)   ) &
                     / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI) )  
!
! Wrmax_cf
 ZDATA_WRMAX_CF(JI,:)= 0.2
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_WRMAX_CF(JI,1) = 0.1
 ENDIF 
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)                    &
    DTV%XPAR_WRMAX_CF(JI,1) =  ( ZDATA_WRMAX_CF(JI,1)*ZPROP_HVEG(JI)     &
                          + ZDATA_WRMAX_CF(JI,2)*ZPROP_LVEG(JI)   ) &
                        / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI)    )  
!
! Rgl
 ZDATA_RGL(JI,:)= 100.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_RGL(JI,1)= 30.
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_RGL(JI,1) = 30.
 ENDIF 
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)            &
    DTV%XPAR_RGL(JI,1) =  ( ZDATA_RGL(JI,1)*ZPROP_HVEG(JI)       &
                     + ZDATA_RGL(JI,2)*ZPROP_LVEG(JI)     ) &
                   / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI) )  
!
! Cv
 ZDATA_CV(JI,:)= 2.E-5
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_CV(JI,1) = 1.E-5
 ENDIF 
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)           &
    DTV%XPAR_CV(JI,1) =  ( ZDATA_CV(JI,1)*ZPROP_HVEG(JI)        &
                    + ZDATA_CV(JI,2)*ZPROP_LVEG(JI)      ) &
                  / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI) )  
!
! Mesophyll conductance (m s-1)
 ZDATA_GMES(JI,:)=0.020
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_GMES(JI,1) = 0.001
 ENDIF 
 IF (NVT_C3>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3  )>0. )  ZDATA_GMES(JI,2)= 0.003
 ENDIF
 IF (NVT_C3W>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3W )>0. )  ZDATA_GMES(JI,2)= 0.003
 ENDIF
 IF (NVT_C3S>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3S )>0. )  ZDATA_GMES(JI,2)= 0.003
 ENDIF
 IF(DTV%XPAR_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_GMES(JI,2)= 0.003
 IF (NVT_IRR>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_IRR )>0. )  ZDATA_GMES(JI,2)= 0.003
 ENDIF
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)             &
    DTV%XPAR_GMES(JI,1) =  ( ZDATA_GMES(JI,1)*ZPROP_HVEG(JI)      &
                      + ZDATA_GMES(JI,2)*ZPROP_LVEG(JI)    ) &
                    / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI) )  
!
! Ecosystem Respiration (kg.m-2.s-1), in case it is not specified
 ZDATA_RE25(JI,:)= 3.0E-7 
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_RE25(JI,1)= 1.5E-7
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_RE25(JI,1)= 1.5E-7
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_RE25(JI,1)= 1.5E-7
 IF(DTV%XPAR_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_RE25(JI,2)= 2.5E-7
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)             &
    DTV%XPAR_RE25(JI,1) =  ( ZDATA_RE25(JI,1)*ZPROP_HVEG(JI)      &
                      + ZDATA_RE25(JI,2)*ZPROP_LVEG(JI)    ) &
                    / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI) )  
!
! Cuticular conductance (m s-1)
 ZDATA_GC(JI,:)=0.00025
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_GC(JI,1)= 0.00015
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_GC(JI,1)= 0.00015
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_GC(JI,1)= 0.00015
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_GC(JI,1)= 0.00015
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_GC(JI,1)= 0.00015
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_GC(JI,1)= 0.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_GC(JI,1)= 0.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_GC(JI,1)= 0.
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_GC(JI,1)= 0.00015  
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_GC(JI,1) = 0.00015
 ENDIF 
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)           &
    DTV%XPAR_GC(JI,1) =  ( ZDATA_GC(JI,1)*ZPROP_HVEG(JI)        &
                    + ZDATA_GC(JI,2)*ZPROP_LVEG(JI)      ) &
                  / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI) )  
!
! Ratio d(biomass)/d(lai) (kg/m2)
 ZDATA_BSLAI(JI,:)=0.36 
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_BSLAI(JI,1) = 0.25
 ENDIF 
 IF (NVT_C3>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3  )>0. )  ZDATA_BSLAI(JI,2)= 0.06
 ENDIF
 IF (NVT_C3W>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3W )>0. )  ZDATA_BSLAI(JI,2)= 0.06
 ENDIF
 IF (NVT_C3S>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3S )>0. )  ZDATA_BSLAI(JI,2)= 0.06
 ENDIF
 IF(DTV%XPAR_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_BSLAI(JI,2)= 0.06
 IF (NVT_IRR>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_IRR )>0. )  ZDATA_BSLAI(JI,2)= 0.06
 ENDIF
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)              &
    DTV%XPAR_BSLAI(JI,1) =  ( ZDATA_BSLAI(JI,1)*ZPROP_HVEG(JI)     &
                       + ZDATA_BSLAI(JI,2)*ZPROP_LVEG(JI)   ) &
                     / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI) )  
!
! Maximum air saturation deficit tolerate by vegetation (kg/kg)
 ZDATA_DMAX(JI,:) = 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_DMAX(JI,1) = 0.1
 ENDIF 
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)             &
    DTV%XPAR_DMAX(JI,1) =  ( ZDATA_DMAX(JI,1)*ZPROP_HVEG(JI)      &
                      + ZDATA_DMAX(JI,2)*ZPROP_LVEG(JI)    ) &
                    / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI) )  
!
! e-folding time for senescence (days)
 ZDATA_SEFOLD(JI,:)=90. * XDAY
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_SEFOLD(JI,1) = 365.*XDAY
 ENDIF 
 IF (NVT_C3>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3  )>0. )  ZDATA_SEFOLD(JI,2)=  60.* XDAY
 ENDIF
 IF (NVT_C3W>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3W )>0. )  ZDATA_SEFOLD(JI,2)=  60.* XDAY
 ENDIF 
 IF (NVT_C3S>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3S )>0. )  ZDATA_SEFOLD(JI,2)=  60.* XDAY
 ENDIF
 IF(DTV%XPAR_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_SEFOLD(JI,2)=  60.* XDAY
 IF (NVT_IRR>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_IRR )>0. )  ZDATA_SEFOLD(JI,2)=  60.* XDAY
 ENDIF
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)                &
    DTV%XPAR_SEFOLD(JI,1) =  ( ZDATA_SEFOLD(JI,1)*ZPROP_HVEG(JI)     &
                        + ZDATA_SEFOLD(JI,2)*ZPROP_LVEG(JI)   ) &
                      / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI)  )  
!
! Minimum LAI (m2/m2)
 ZDATA_LAIMIN (JI,:) = 0.3
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_LAIMIN(JI,1)= 1.0
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_LAIMIN(JI,1)= 1.0
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_LAIMIN(JI,1)= 1.0
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_LAIMIN(JI,1)= 1.0
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)                &
    DTV%XPAR_LAIMIN(JI,1) =  ( ZDATA_LAIMIN(JI,1)*ZPROP_HVEG(JI)     &
                        + ZDATA_LAIMIN(JI,2)*ZPROP_LVEG(JI)   ) &
                      / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI)  )  
!
! Leaf aera ratio sensitivity to nitrogen concentration
 ZDATA_CE_NITRO(JI,:)=7.68
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_CE_NITRO(JI,1)= 4.85
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_CE_NITRO(JI,1)= 4.85
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_CE_NITRO(JI,1)= 4.85
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_CE_NITRO(JI,1) = 4.83
 ENDIF 
 IF (NVT_C3>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3  )>0. )  ZDATA_CE_NITRO(JI,2)= 3.79
 ENDIF
 IF (NVT_C3W>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3W )>0. )  ZDATA_CE_NITRO(JI,2)= 3.79
 ENDIF 
 IF (NVT_C3S>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3S )>0. )  ZDATA_CE_NITRO(JI,2)= 3.79
 ENDIF
 IF(DTV%XPAR_VEGTYPE(JI,NVT_GRAS)>0. )  ZDATA_CE_NITRO(JI,2)= 5.56
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOGR)>0. )  ZDATA_CE_NITRO(JI,2)= 5.56
 IF (NVT_PARK>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_PARK)>0. )  ZDATA_CE_NITRO(JI,2)= 5.56
 ELSEIF (NVT_FLGR>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_FLGR)>0. )  ZDATA_CE_NITRO(JI,2)= 5.56
 ENDIF
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)                    &
    DTV%XPAR_CE_NITRO(JI,1) =  ( ZDATA_CE_NITRO(JI,1)*ZPROP_HVEG(JI)     &
                          + ZDATA_CE_NITRO(JI,2)*ZPROP_LVEG(JI)   ) &
                        / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI)    )  
!
! Lethal minimum value of leaf area ratio
 ZDATA_CF_NITRO(JI,:)=-4.33
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_CF_NITRO(JI,1)= 2.53
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_CF_NITRO(JI,1)= 2.53
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_CF_NITRO(JI,1)= 2.53
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_CF_NITRO(JI,1)= 2.53
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_CF_NITRO(JI,1)= 2.53
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_CF_NITRO(JI,1)= -0.24
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_CF_NITRO(JI,1)= -0.24
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_CF_NITRO(JI,1)= -0.24
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_CF_NITRO(JI,1)= 0.12
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_CF_NITRO(JI,1) = 2.53
 ENDIF 
 IF (NVT_C3>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3  )>0. )  ZDATA_CF_NITRO(JI,2)=  9.84
 ENDIF
 IF (NVT_C3W>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3W )>0. )  ZDATA_CF_NITRO(JI,2)=  9.84
 ENDIF
 IF (NVT_C3S>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_C3S )>0. )  ZDATA_CF_NITRO(JI,2)=  9.84
 ENDIF
 IF(DTV%XPAR_VEGTYPE(JI,NVT_GRAS)>0. )  ZDATA_CF_NITRO(JI,2)=  6.73
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOGR)>0. )  ZDATA_CF_NITRO(JI,2)=  6.73
 IF (NVT_PARK>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_PARK)>0. )  ZDATA_CF_NITRO(JI,2)=  6.73
 ELSEIF (NVT_FLGR>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_FLGR)>0. )  ZDATA_CF_NITRO(JI,2)=  6.73
 ENDIF
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)                    &
    DTV%XPAR_CF_NITRO(JI,1) =  ( ZDATA_CF_NITRO(JI,1)*ZPROP_HVEG(JI)     &
                          + ZDATA_CF_NITRO(JI,2)*ZPROP_LVEG(JI)   ) &
                        / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI)    )  
!
! Nitrogen concentration of active biomass
 ZDATA_CNA_NITRO(JI,:)=1.3
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.0
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.0
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.0
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.0
 IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.0
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.8
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.8
 IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.8
 IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_CNA_NITRO(JI,1)= 1.7
 IF (NVT_FLTR>0) THEN
   IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_CNA_NITRO(JI,1) = 2.0
 ENDIF 
 IF(DTV%XPAR_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_CNA_NITRO(JI,2)= 1.9
 IF (NVT_IRR>0) THEN
   IF(DTV%XPAR_VEGTYPE(JI,NVT_IRR )>0. )  ZDATA_CNA_NITRO(JI,2)= 1.9
 ENDIF
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)                      &
    DTV%XPAR_CNA_NITRO(JI,1) =  ( ZDATA_CNA_NITRO(JI,1)*ZPROP_HVEG(JI)     &
                           + ZDATA_CNA_NITRO(JI,2)*ZPROP_LVEG(JI)   ) &
                         / ( ZPROP_HVEG(JI)+ZPROP_LVEG(JI)     )  
!
! Ground layers
 IF (IO%NGROUND_LAYER<=3) THEN
   ZDATA_DG(JI,1,:) = 0.01
   ZDATA_DG(JI,2,:) = 1.50
   IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF (NVT_FLTR>0) THEN
     IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_DG(JI,2,1) = 2.0
   ENDIF 
   !
   IF(DTV%XPAR_VEGTYPE(JI,NVT_NO  )>0. )  ZDATA_DG(JI,2,3)= 0.5
   IF(DTV%XPAR_VEGTYPE(JI,NVT_ROCK)>0. )  ZDATA_DG(JI,2,3)= 0.5
   IF(DTV%XPAR_VEGTYPE(JI,NVT_SNOW)>0. )  ZDATA_DG(JI,2,3)= 0.5
   !
   IF (IO%NGROUND_LAYER==3) THEN
      ZDATA_DG(JI,3,:) = 2.00
      IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTV%XPAR_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTV%XPAR_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTV%XPAR_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTV%XPAR_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTV%XPAR_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTV%XPAR_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTV%XPAR_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF (NVT_FLTR>0) THEN
        IF (DTV%XPAR_VEGTYPE(JI,NVT_FLTR)>0.) ZDATA_DG(JI,3,1) = 3.0
      ENDIF 
      !
      IF(DTV%XPAR_VEGTYPE(JI,NVT_NO  )>0. )  ZDATA_DG(JI,3,3)= 1.0
      IF(DTV%XPAR_VEGTYPE(JI,NVT_ROCK)>0. )  ZDATA_DG(JI,3,3)= 1.0
      IF(DTV%XPAR_VEGTYPE(JI,NVT_SNOW)>0. )  ZDATA_DG(JI,3,3)= 1.0
   ENDIF
   DTV%XPAR_DG(JI,:,1) =    ZDATA_DG(JI,:,1)*ZPROP_HVEG(JI)   &
                       + ZDATA_DG(JI,:,2)*ZPROP_LVEG(JI) &
                       + ZDATA_DG(JI,:,3)*ZPROP_NVEG(JI)  
 ELSEIF (IO%NGROUND_LAYER<=NOPTIMLAYER) THEN
! FIXME : A vérifier avec Aude
   DTV%XPAR_DG(JI,:,1) = XOPTIMGRID(:IO%NGROUND_LAYER)
 ELSE
   CALL ABOR1_SFX("READ_PGD_TEB_GARDEN_PAR: WITH MORE THAN 14 SOIL LAYERS, "//&
     "WITHOUT ECOCLIMAP, GARDEN CANNOT RUN")
 ENDIF 
!
! Root fractions
 DTV%XPAR_ROOTFRAC(JI,IO%NGROUND_LAYER,1) = 1.
 DTV%XPAR_ROOTFRAC(JI,1,1) = 0.20
 IF (IO%NGROUND_LAYER>2) THEN
   DO JLAYER = IO%NGROUND_LAYER-1,2,-1
     DTV%XPAR_ROOTFRAC(JI,JLAYER,1) = DTV%XPAR_ROOTFRAC(JI,JLAYER+1,1)-0.8/(IO%NGROUND_LAYER-1)
   ENDDO
 ENDIF
!
 DTV%XPAR_DICE(JI,1) = DTV%XPAR_DG(JI,2,1)
!
 DO JTIME=1,DTV%NTIME
! Leaf Area Index
 IF (ZPROP_HVEG(JI)+ZPROP_LVEG(JI) .GT. 0.)                           &
     DTV%XPAR_LAI     (JI,JTIME,1) = ( DTV%XPAR_LAI_HVEG(JI,JTIME)*ZPROP_HVEG(JI)  &
                                + DTV%XPAR_LAI_LVEG(JI,JTIME)*ZPROP_LVEG(JI)) &
                               /( ZPROP_HVEG(JI)+ZPROP_LVEG(JI))  
! Fraction of vegetation
  DTV%XPAR_VEG     (JI,JTIME,1) = VEG_FROM_LAI  (DTV%XPAR_LAI    (JI,JTIME,1),       &
                                            DTV%XPAR_VEGTYPE(JI,:),GAGRI_TO_GRASS)  
! Roughness length for momentum
  DTV%XPAR_Z0      (JI,JTIME,1) = Z0V_FROM_LAI  (DTV%XPAR_LAI    (JI,JTIME,1),       &
                                            DTV%XPAR_H_TREE (JI,1),           &
                                            DTV%XPAR_VEGTYPE(JI,:),GAGRI_TO_GRASS)  
! Emissivity
  DTV%XPAR_EMIS    (JI,JTIME,1) = EMIS_FROM_VEG (DTV%XPAR_VEG    (JI,JTIME,1),       &
                                            DTV%XPAR_VEGTYPE(JI,:))
 END DO
!
ENDDO
!
! ****************************************************
! Cas SDE-BOQER
DTV%XPAR_DG         (:,1,1) = 0.10
DTV%XPAR_DG         (:,2,1) = 0.50
DTV%XPAR_DG         (:,3,1) = 1.00
DTV%XPAR_ROOTFRAC   (:,1,1) = 0.20
DTV%XPAR_ROOTFRAC   (:,2,1) = 0.70
DTV%XPAR_ROOTFRAC   (:,3,1) = 1.00
DTV%XPAR_ALBNIR_SOIL(:,1,1) = 0.25
DTV%XPAR_ALBVIS_SOIL(:,1,1) = 0.35
DTV%XPAR_ALBUV_SOIL (:,1,1) = 0.10
DTV%XPAR_ALBNIR_VEG (:,1,1) = 0.30
DTV%XPAR_ALBVIS_VEG (:,1,1) = 0.20
DTV%XPAR_ALBUV_VEG  (:,1,1) = 0.125
DTV%XPAR_EMIS       (:,:,1) = 0.90*DTV%XPAR_VEGTYPE(1,1)+0.90*DTV%XPAR_VEGTYPE(1,13)+0.95*DTV%XPAR_VEGTYPE(1,11)
DTV%XPAR_VEG        (:,:,1) = 0.00*DTV%XPAR_VEGTYPE(1,1)+1.00*DTV%XPAR_VEGTYPE(1,13)+1.00*DTV%XPAR_VEGTYPE(1,11)
IF(DTV%XPAR_VEGTYPE(1,13)+DTV%XPAR_VEGTYPE(1,11).GT.0.) THEN
DTV%XPAR_RSMIN        (:,1) = (120.*DTV%XPAR_VEGTYPE(1,13)+150.*DTV%XPAR_VEGTYPE(1,11))&
                              /(DTV%XPAR_VEGTYPE(1,13)+DTV%XPAR_VEGTYPE(1,11))
DTV%XPAR_GAMMA        (:,1) = 0.
DTV%XPAR_WRMAX_CF     (:,1) = (0.2*DTV%XPAR_VEGTYPE(1,13)+0.1*DTV%XPAR_VEGTYPE(1,11))&
                              /(DTV%XPAR_VEGTYPE(1,13)+DTV%XPAR_VEGTYPE(1,11))
DTV%XPAR_RGL          (:,1) = (100.*DTV%XPAR_VEGTYPE(1,13)+30.*DTV%XPAR_VEGTYPE(1,11))&
                              /(DTV%XPAR_VEGTYPE(1,13)+DTV%XPAR_VEGTYPE(1,11))
DTV%XPAR_CV           (:,1) = (0.00002*DTV%XPAR_VEGTYPE(1,13)+0.00001*DTV%XPAR_VEGTYPE(1,11))&
                              /(DTV%XPAR_VEGTYPE(1,13)+DTV%XPAR_VEGTYPE(1,11))
ENDIF
DTV%XPAR_Z0         (:,:,1) = 0.3
! ****************************************************
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_GARDEN_PAR_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE READ_PGD_TEB_GARDEN_PAR_n
