!     #########################
SUBROUTINE READ_BLD_DESCRIPTION_n(BDD,HPROGRAM)
  !     #########################
  !
  !!
  !!    PURPOSE
  !!    -------
  !!
  !!    METHOD
  !!    ------
  !!
  !!
  !!    EXTERNAL
  !!    --------
  !!
  !!    IMPLICIT ARGUMENTS
  !!    ------------------
  !!
  !!    REFERENCE
  !!    ---------
  !!
  !!    AUTHOR
  !!    ------
  !!
  !!    V. Masson        Meteo-France
  !!
  !!    MODIFICATION
  !!    ------------
  !!
  !!    Original    05/2012 
  !
  !----------------------------------------------------------------------------
  !
  !*    0.     DECLARATION
  !            -----------
  !
  USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
  USE MODD_SURF_PAR, ONLY : XUNDEF
  !
  USE MODI_READ_SURF
  USE MODI_ABOR1_SFX
  !
  USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
  USE PARKIND1  ,ONLY : JPRB
  !
  IMPLICIT NONE
  !
  !*    0.1    Declaration of arguments
  !            ------------------------
  !
  TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
  CHARACTER(LEN=6),  INTENT(IN) :: HPROGRAM
  !
  !
  !*    0.2    Declaration of local variables
  !      ------------------------------
  !
  REAL(KIND=JPRB) :: ZHOOK_HANDLE
  !
  REAL, DIMENSION(:), ALLOCATABLE :: ZWORK
  INTEGER                         :: IRESP
  INTEGER                         :: I1, I2
  INTEGER                         :: JL
  INTEGER                         :: ITOT
  INTEGER                         :: IVERSION   ! surface version
  INTEGER                         :: IBUGFIX    ! surface bugfix version
  CHARACTER(LEN=4)                :: YRECFM
  CHARACTER(LEN=11)               :: YSTRNAME  
  !-------------------------------------------------------------------------------
  !-------------------------------------------------------------------------------
  !
  IF (LHOOK) CALL DR_HOOK('READ_BLD_DESCRIPTION_n',0,ZHOOK_HANDLE)
  !
  !-------------------------------------------------------------------------------
  !
  !*    1.   Read file version
  !          -----------------
  !
  CALL READ_SURF(HPROGRAM,'VERSION',IVERSION,IRESP)
  CALL READ_SURF(HPROGRAM,'BUG',IBUGFIX,IRESP)
  !-------------------------------------------------------------------------------
  !
  !*    1.   Read configuration variables of the descriptive data
  !          ----------------------------------------------------
  !
  ALLOCATE(ZWORK(14))
  ZWORK(:)=XUNDEF
  !
  CALL READ_SURF(HPROGRAM,'BLD_DESC_CNF',ZWORK,IRESP,HDIR='-')
  !
  I1=1
  BDD%NDESC_BLD         = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_AGE         = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_USE         = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_TER         = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_CODE        = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_NDAY_SCHED  = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_NCRE_SCHED  = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_HOLIDAY     = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_CONDP       = NINT(ZWORK(I1));I1=I1+1  
  BDD%NDESC_WALL_LAYER  = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_ROOF_LAYER  = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_ROAD_LAYER  = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_FLOOR_LAYER = NINT(ZWORK(I1));I1=I1+1
  BDD%NDESC_MASS_LAYER  = NINT(ZWORK(I1))
  !
  IF (SIZE(ZWORK).NE.I1) CALL ABOR1_SFX("Error in read of building description")
  !
  DEALLOCATE(ZWORK)
  !
  !-------------------------------------------------------------------------------
  !
  ! 2.  Read positions of building type, use, construction period and material territory
  !     -----------------------------------------------------------------------
  !
  ALLOCATE(ZWORK(BDD%NDESC_BLD+BDD%NDESC_USE+BDD%NDESC_AGE+5))
  ZWORK(:)=XUNDEF
  !
  CALL READ_SURF(HPROGRAM,'BLD_DESC_POS',ZWORK,IRESP,HDIR='-')
  !
  I1=1
  BDD%NDESC_POS_TYP_PD  = ZWORK(I1);I1=I1+1   
  BDD%NDESC_POS_TYP_PSC = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_TYP_PCIO= ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_TYP_PCIF= ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_TYP_ID  = ZWORK(I1);I1=I1+1 
  BDD%NDESC_POS_TYP_ICIO= ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_TYP_ICIF= ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_TYP_BGH = ZWORK(I1);I1=I1+1 
  BDD%NDESC_POS_TYP_BA  = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_TYP_LOCA= ZWORK(I1);I1=I1+1     
  BDD%NDESC_POS_USE_AGR = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_CHA = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_COM = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_HAC = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_HAI = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_IND = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_LNC = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_REL = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_SAN = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_ENS = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_SER = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_SPO = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_USE_TER = ZWORK(I1);I1=I1+1    
  BDD%NDESC_POS_AGE_P1  = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_AGE_P2  = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_AGE_P3  = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_AGE_P4  = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_AGE_P5  = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_AGE_P6  = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_AGE_P7  = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_PX_DEFAULT = ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_HAI_FORTCRE= ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_HAI_FAIBCRE= ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_HAC_FORTCRE= ZWORK(I1);I1=I1+1
  BDD%NDESC_POS_HAC_FAIBCRE= ZWORK(I1)
  !
  IF (SIZE(ZWORK).NE.(I1)) CALL ABOR1_SFX("Error in read of building description")
  DEALLOCATE(ZWORK)
  !
  !-------------------------------------------------------------------------------
  !
  !*    2.   Allocates descriptive data
  !          --------------------------
  !
  ALLOCATE(BDD%NDESC_BLD_LIST(BDD%NDESC_CODE))
  ALLOCATE(BDD%NDESC_USE_LIST(BDD%NDESC_CODE))
  ALLOCATE(BDD%NDESC_AGE_LIST(BDD%NDESC_CODE))
  ALLOCATE(BDD%NDESC_TER_LIST(BDD%NDESC_CODE))
  ALLOCATE(BDD%NDESC_CODE_LIST(BDD%NDESC_CODE))
  !
  ALLOCATE(BDD%XDESC_ALB_ROOF(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_EMIS_ROOF(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_HC_ROOF(BDD%NDESC_CODE,BDD%NDESC_ROOF_LAYER))
  ALLOCATE(BDD%XDESC_TC_ROOF(BDD%NDESC_CODE,BDD%NDESC_ROOF_LAYER))
  ALLOCATE(BDD%XDESC_D_ROOF (BDD%NDESC_CODE,BDD%NDESC_ROOF_LAYER))
  !
  ALLOCATE(BDD%XDESC_ALB_ROAD(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_EMIS_ROAD(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_HC_ROAD(BDD%NDESC_CODE,BDD%NDESC_ROAD_LAYER))
  ALLOCATE(BDD%XDESC_TC_ROAD(BDD%NDESC_CODE,BDD%NDESC_ROAD_LAYER))
  ALLOCATE(BDD%XDESC_D_ROAD (BDD%NDESC_CODE,BDD%NDESC_ROAD_LAYER))
  !
  ALLOCATE(BDD%XDESC_ALB_WALL(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_EMIS_WALL(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_HC_WALL(BDD%NDESC_CODE,BDD%NDESC_WALL_LAYER))
  ALLOCATE(BDD%XDESC_TC_WALL(BDD%NDESC_CODE,BDD%NDESC_WALL_LAYER))
  ALLOCATE(BDD%XDESC_D_WALL (BDD%NDESC_CODE,BDD%NDESC_WALL_LAYER))
  !
  ALLOCATE(BDD%NDESC_ISOROOFPOS(BDD%NDESC_CODE))
  ALLOCATE(BDD%NDESC_ISOWALLPOS(BDD%NDESC_CODE))
  !
  ALLOCATE(BDD%XDESC_HC_FLOOR(BDD%NDESC_CODE,BDD%NDESC_FLOOR_LAYER))
  ALLOCATE(BDD%XDESC_TC_FLOOR(BDD%NDESC_CODE,BDD%NDESC_FLOOR_LAYER))
  ALLOCATE(BDD%XDESC_D_FLOOR (BDD%NDESC_CODE,BDD%NDESC_FLOOR_LAYER))
  !
  ALLOCATE(BDD%XDESC_ISMASS(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_HC_MASS(BDD%NDESC_CODE,BDD%NDESC_MASS_LAYER))
  ALLOCATE(BDD%XDESC_TC_MASS(BDD%NDESC_CODE,BDD%NDESC_MASS_LAYER))
  ALLOCATE(BDD%XDESC_D_MASS (BDD%NDESC_CODE,BDD%NDESC_MASS_LAYER))
  !
  ALLOCATE(BDD%XDESC_N50(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_GR(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_U_WIN(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_SHGC(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_SHGC_SH(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_SHADEARCHI(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_ISMECH  (BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_MECHRATE(BDD%NDESC_CODE))
  !
  ALLOCATE(BDD%XDESC_GREENROOF(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_EMIS_PANEL(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_ALB_PANEL (BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_EFF_PANEL (BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_FRAC_PANEL(BDD%NDESC_CODE))
  !
  ALLOCATE(BDD%XDESC_F_WATER_COND(BDD%NDESC_CODE))
  !
  ALLOCATE(BDD%XDESC_FLDT(BDD%NDESC_CONDP))
  ALLOCATE(BDD%XDESC_FIDT(BDD%NDESC_CONDP))
  ALLOCATE(BDD%XDESC_FHDT(BDD%NDESC_CONDP))
  !
  ALLOCATE(BDD%XDESC_THEAT_OCCD_AVG(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_THEAT_OCCN_AVG(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_THEAT_VCDD_AVG(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_THEAT_VCDN_AVG(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_THEAT_VCLD_AVG(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_FNOHEAT_AVG(BDD%NDESC_USE))
  !
  ALLOCATE(BDD%XDESC_THEAT_OCCD_MOD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_THEAT_OCCN_MOD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_THEAT_VCDD_MOD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_THEAT_VCDN_MOD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_THEAT_VCLD_MOD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_FNOHEAT_MOD(BDD%NDESC_USE))
  !
  ALLOCATE(BDD%XDESC_TCOOL_OCCD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_TCOOL_OCCN(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_TCOOL_VCDD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_TCOOL_VCDN(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_TCOOL_VCLD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_F_WATER_COND(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_F_WASTE_CAN(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_COP_RAT(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_HR_TARGET(BDD%NDESC_USE))
  !
  ALLOCATE(BDD%XDESC_QIN(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_QIN_ADDBEHAV(BDD%NDESC_USE))  
  ALLOCATE(BDD%XDESC_QIN_FRAD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_QIN_FLAT(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_MODQIN_VCD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_MODQIN_VLD(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_MODQIN_NIG(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_HOTWAT(BDD%NDESC_USE))  
  !
  ALLOCATE(BDD%XDESC_NATVENT(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_FVSUM(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_FVNIG(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_TDESV(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_FVVAC(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_FOPEN(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_FSSUM(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_FSNIG(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_FSVAC(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_WIN_SW_MAX(BDD%NDESC_USE))
  !
  ALLOCATE(BDD%XDESC_DAYWBEG_SCHED(BDD%NDESC_USE,BDD%NDESC_NDAY_SCHED))
  ALLOCATE(BDD%XDESC_HOURBEG_SCHED(BDD%NDESC_USE,BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED))
  !
  ALLOCATE(BDD%XDESC_MOD_HOLIDAY(BDD%NDESC_USE))
  ALLOCATE(BDD%XDESC_BEG_HOLIDAY(BDD%NDESC_USE,BDD%NDESC_HOLIDAY))
  ALLOCATE(BDD%XDESC_END_HOLIDAY(BDD%NDESC_USE,BDD%NDESC_HOLIDAY))
  !
  ALLOCATE(BDD%XDESC_PROBOCC(BDD%NDESC_USE,BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED))
  !
  !-------------------------------------------------------------------------------
  !
  !*    3.   Read descriptive data
  !          ---------------------
  !
  ITOT = BDD%NDESC_CODE * ( 27 + 3 * BDD%NDESC_ROOF_LAYER  + 3 * BDD%NDESC_ROAD_LAYER    + &
       3 * BDD%NDESC_WALL_LAYER + 3 * BDD%NDESC_FLOOR_LAYER + 3 * BDD%NDESC_MASS_LAYER ) + &
       3 * BDD%NDESC_CONDP                                                               + &
       39 * BDD%NDESC_USE                                                                + &
       BDD%NDESC_USE * (BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED + BDD%NDESC_NDAY_SCHED ) + &
       BDD%NDESC_USE * (2* BDD%NDESC_HOLIDAY + 1)                                        + &
       BDD%NDESC_USE * (BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED)
  !
  ALLOCATE(ZWORK(ITOT))
  !
  CALL READ_SURF(HPROGRAM,'BLD_DESC_DAT',ZWORK,IRESP,HDIR='-')
  !
  I1=0 ; I2=0
  !
  ! Indices
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_BLD_LIST(:)  = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_AGE_LIST(:)  = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_USE_LIST(:)  = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_TER_LIST(:)  = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_CODE_LIST(:) = NINT(ZWORK(I1:I2))
  !
  ! Building architectural characteristics
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_ROOF(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_ROOF(:) = ZWORK(I1:I2)
  DO JL=1,BDD%NDESC_ROOF_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_ROOF(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_ROOF_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_ROOF(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_ROOF_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_ROOF (:,JL) = ZWORK(I1:I2)
  END DO
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_ROAD(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_ROAD(:) = ZWORK(I1:I2)
  DO JL=1,BDD%NDESC_ROAD_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_ROAD(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_ROAD_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_ROAD(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_ROAD_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_ROAD (:,JL) = ZWORK(I1:I2)
  END DO
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_WALL(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_WALL(:) = ZWORK(I1:I2)
  DO JL=1,BDD%NDESC_WALL_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_WALL(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_WALL_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_WALL(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_WALL_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_WALL (:,JL) = ZWORK(I1:I2)
  END DO
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_ISOROOFPOS(:) = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_ISOWALLPOS(:) = NINT(ZWORK(I1:I2))
  !
  DO JL=1,BDD%NDESC_FLOOR_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_FLOOR(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_FLOOR_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_FLOOR(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_FLOOR_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_FLOOR (:,JL) = ZWORK(I1:I2)
  END DO
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ISMASS(:)       = ZWORK(I1:I2)
  DO JL=1,BDD%NDESC_MASS_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_MASS(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_MASS_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_MASS(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_MASS_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_MASS (:,JL) = ZWORK(I1:I2)
  END DO
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_N50(:)        = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_GR(:)         = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_U_WIN(:)      = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_SHGC(:)       = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_SHGC_SH(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_SHADEARCHI(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ISMECH(:)     = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_MECHRATE(:)   = ZWORK(I1:I2)
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_GREENROOF(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_PANEL(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_PANEL(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EFF_PANEL(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_FRAC_PANEL(:) = ZWORK(I1:I2)
  !
  ! Behavioural characteristics
  !
  CALL UP_DESC_IND(BDD%NDESC_CONDP) ; BDD%XDESC_FLDT(:)       = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CONDP) ; BDD%XDESC_FIDT(:)       = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CONDP) ; BDD%XDESC_FHDT(:)       = ZWORK(I1:I2)
  !
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_OCCD_AVG(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_OCCN_AVG(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_VCDD_AVG(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_VCDN_AVG(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_VCLD_AVG(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_FNOHEAT_AVG   (:) = ZWORK(I1:I2)
  !
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_OCCD_MOD(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_OCCN_MOD(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_VCDD_MOD(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_VCDN_MOD(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_VCLD_MOD(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_FNOHEAT_MOD   (:) = ZWORK(I1:I2)
  !
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_TCOOL_OCCD(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_TCOOL_OCCN(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_TCOOL_VCDD(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_TCOOL_VCDN(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_TCOOL_VCLD(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_F_WATER_COND(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_F_WASTE_CAN(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_COP_RAT(:)      = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_HR_TARGET(:)    = ZWORK(I1:I2)
  !
  CALL UP_DESC_IND(BDD%NDESC_USE)  ; BDD%XDESC_QIN(:)          = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE)  ; BDD%XDESC_QIN_ADDBEHAV(:) = ZWORK(I1:I2)  
  CALL UP_DESC_IND(BDD%NDESC_USE)  ; BDD%XDESC_QIN_FRAD(:)     = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE)  ; BDD%XDESC_QIN_FLAT(:)     = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE)  ; BDD%XDESC_MODQIN_VCD(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE)  ; BDD%XDESC_MODQIN_VLD(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE)  ; BDD%XDESC_MODQIN_NIG(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE)  ; BDD%XDESC_HOTWAT(:)   = ZWORK(I1:I2)  
  !
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_NATVENT(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_FVSUM(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_FVNIG(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_TDESV(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_FVVAC(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_FOPEN(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_FSSUM(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_FSNIG(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_FSVAC(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_WIN_SW_MAX(:) = ZWORK(I1:I2)
  !
  DO JL=1,BDD%NDESC_NDAY_SCHED
     CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_DAYWBEG_SCHED(:,JL) = ZWORK(I1:I2)
  ENDDO
  !
  DO JL=1,(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED)
     CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_HOURBEG_SCHED(:,JL) = ZWORK(I1:I2)
  ENDDO
  !
  CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_MOD_HOLIDAY(:) = ZWORK(I1:I2)
  !
  DO JL=1,BDD%NDESC_HOLIDAY
     CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_BEG_HOLIDAY(:,JL) = ZWORK(I1:I2)
  ENDDO
  DO JL=1,BDD%NDESC_HOLIDAY
     CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_END_HOLIDAY(:,JL) = ZWORK(I1:I2)
  ENDDO
  !
  DO JL=1,(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED)
     CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_PROBOCC(:,JL) = ZWORK(I1:I2)
  ENDDO
  !
  DEALLOCATE(ZWORK)
  !
  IF (LHOOK) CALL DR_HOOK('READ_BLD_DESCRIPTION_n',1,ZHOOK_HANDLE)
  !-------------------------------------------------------------------------------
CONTAINS
  SUBROUTINE UP_DESC_IND(K)
    INTEGER, INTENT(IN) :: K
    I1=I2+1
    I2=I2+K
  END SUBROUTINE UP_DESC_IND
  !-------------------------------------------------------------------------------
  !
END SUBROUTINE READ_BLD_DESCRIPTION_n
