!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE PGD_TEB_HYDRO_PAR (DTCO, UG, U, USS, DTH, KDIM, HPROGRAM)
!     ##############################################################

!!**** *PGD_TEB_HYDRO_PAR* monitor for averaging and interpolations of cover fractions
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    A. Lemonsu       Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    09/2009
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_SSO_n, ONLY : SSO_t
!
USE MODD_DATA_TEB_HYDRO_n, ONLY : DATA_TEB_HYDRO_t
!
USE MODD_DATA_COVER_PAR,    ONLY : NVEGTYPE
USE MODD_SURF_PAR,          ONLY : XUNDEF

USE MODD_PGDWORK,           ONLY : CATYPE
!
USE MODI_GET_LUOUT
USE MODI_OPEN_NAMELIST
USE MODI_CLOSE_NAMELIST
USE MODI_PGD_FIELD
USE MODI_ABOR1_SFX
!
USE MODE_POS_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(SSO_t), INTENT(INOUT) :: USS
INTEGER, INTENT(IN) :: KDIM
TYPE(DATA_TEB_HYDRO_t) :: DTH
!
 CHARACTER(LEN=6),    INTENT(IN)    :: HPROGRAM     ! Type of program
!
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
INTEGER               :: ILUOUT    ! output listing logical unit
INTEGER               :: ILUNAM    ! namelist file  logical unit
LOGICAL               :: GFOUND    ! true if namelist is found
INTEGER               :: JTIME     ! loop counter on time

!
!*    0.3    Declaration of namelists
!            ------------------------
!
!
INTEGER               :: JI        ! loop counter on grid
! uniform value
!
! Additional parameters for urban hydrology (option LURBHYDRO)
REAL                                   :: XUNIF_LSEWER         ! waste water sewer length
REAL                                   :: XUNIF_LSTORM         ! storm water sewer length
REAL                                   :: XUNIF_DSEWER         ! waste water sewer depth
REAL                                   :: XWS_ROOF_MAX         ! Max. capacity of surface roof water storage 
REAL                                   :: XWS_ROAD_MAX         ! Max. capacity of surface road water storage
REAL                                   :: XIP_SEWER            ! Parameter for parasite infiltrations into sewer
REAL                                   :: XCONNEX              ! Impervious surfaces connexion rate to the sewer
REAL                                   :: XINFIL_ROAD          ! Water infiltration through the roads
REAL                                   :: XURBDRAIN            ! Limitation of urban deep drainage (0-1)
!
! name of files containing data
!
CHARACTER(LEN=28)                      :: CFNAM_LSEWER        ! waste water sewer length
CHARACTER(LEN=28)                      :: CFNAM_LSTORM        ! storm water sewer length
CHARACTER(LEN=28)                      :: CFNAM_DSEWER        ! waste water sewer depth
!
! type of files containing data
!
CHARACTER(LEN=6)                      :: CFTYP_LSEWER        ! waste water sewer length
CHARACTER(LEN=6)                      :: CFTYP_LSTORM        ! storm water sewer length
CHARACTER(LEN=6)                      :: CFTYP_DSEWER        ! waste water sewer depth
!
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
NAMELIST/NAM_DATA_TEB_HYDRO/ XUNIF_LSEWER, XUNIF_LSTORM, XUNIF_DSEWER,             &
                                XWS_ROOF_MAX, XWS_ROAD_MAX,                        &
                                XIP_SEWER, XCONNEX, XINFIL_ROAD, XURBDRAIN,        &
                                CFNAM_LSEWER, CFNAM_LSTORM, CFNAM_DSEWER,          &
                                CFTYP_LSEWER, CFTYP_LSTORM, CFTYP_DSEWER
!-------------------------------------------------------------------------------
!
!*    1.      Initializations
!             ---------------
!
IF (LHOOK) CALL DR_HOOK('PGD_TEB_HYDRO_PAR',0,ZHOOK_HANDLE)

XUNIF_LSEWER       = XUNDEF
XUNIF_LSTORM       = XUNDEF
XUNIF_DSEWER       = XUNDEF
XWS_ROOF_MAX       = 1.
XWS_ROAD_MAX       = 1.
XIP_SEWER          = 0.
XCONNEX            = 1.
XINFIL_ROAD        = 0.
XURBDRAIN          = 0.
CFTYP_LSEWER       = '      '
CFTYP_LSTORM       = '      '
CFTYP_DSEWER       = '      '
!
!-------------------------------------------------------------------------------
!
!*    2.      Input file for cover types
!             --------------------------
!
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
 CALL OPEN_NAMELIST(HPROGRAM,ILUNAM)
!
 !CALL POSNAM(ILUNAM,'NAM_DATA_TEB_URBHYDRO',GFOUND,ILUOUT) !cecile/debug
 CALL POSNAM(ILUNAM,'NAM_DATA_TEB_HYDRO',GFOUND,ILUOUT) !cecile/debug
IF (GFOUND) READ(UNIT=ILUNAM,NML=NAM_DATA_TEB_HYDRO)
!
 CALL CLOSE_NAMELIST(HPROGRAM,ILUNAM)
!
!-------------------------------------------------------------------------------
! FOR THE TIME BEING, the hydrology fields are NOT in ecoclimap or ecoclimapSG
!
! Therefore, they MUST be provided by user
!
! No choice !!!!
!-------------------------------------------------------------------------------

DTH%LDATA_TEB_HYDRO = .TRUE.

ALLOCATE(DTH%XPAR_LSEWER        (KDIM               ))
ALLOCATE(DTH%XPAR_LSTORM        (KDIM               ))
ALLOCATE(DTH%XPAR_DSEWER        (KDIM               ))
!-------------------------------------------------------------------------------
! Additional fields for urban hydrology (LURBHYDRO)
!
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'LSEWER: length of waste water sewer','TWN',CFNAM_LSEWER,       &
                 CFTYP_LSEWER,XUNIF_LSEWER,DTH%XPAR_LSEWER(:))  
!
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'LSTORM: length of storm water sewer','TWN',CFNAM_LSTORM,       &
                 CFTYP_LSTORM,XUNIF_LSTORM,DTH%XPAR_LSTORM(:))  
! 
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'DSEWER: depth of waste water sewer','TWN',CFNAM_DSEWER,        &
                 CFTYP_DSEWER,XUNIF_DSEWER,DTH%XPAR_DSEWER(:))  
!
 DTH%XPAR_WS_ROOF_MAX = XWS_ROOF_MAX
 DTH%XPAR_WS_ROAD_MAX = XWS_ROAD_MAX
 DTH%XPAR_IP_SEWER    = XIP_SEWER
 DTH%XPAR_CONNEX      = XCONNEX
 DTH%XPAR_INFIL_ROAD  = XINFIL_ROAD
 DTH%XPAR_URBDRAIN    = XURBDRAIN
!

IF (LHOOK) CALL DR_HOOK('PGD_TEB_HYDRO_PAR',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE PGD_TEB_HYDRO_PAR
