!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
MODULE MODE_DIAG
!   #####################
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODD_SURF_PAR, ONLY : XUNDEF
USE MODD_DIAG_n, ONLY : DIAG_t, DIAG_OPTIONS_t
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
!
IMPLICIT NONE
!
CONTAINS 
!
SUBROUTINE ALLOC_SURF_BUD(DA,KLUA,KLUAC,KSWA)
!
TYPE(DIAG_t), INTENT(INOUT) :: DA
INTEGER, INTENT(IN) :: KLUA
INTEGER, INTENT(IN) :: KLUAC
INTEGER, INTENT(IN) :: KSWA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:ALLOC_SURF_BUD',0,ZHOOK_HANDLE)
!
ALLOCATE(DA%XRN       (KLUAC))
ALLOCATE(DA%XH        (KLUAC))
ALLOCATE(DA%XLE       (KLUAC))
ALLOCATE(DA%XLEI      (KLUAC))
ALLOCATE(DA%XGFLUX    (KLUAC))
ALLOCATE(DA%XQF       (KLUAC))
!
ALLOCATE(DA%XSWD      (KLUAC))
ALLOCATE(DA%XSWU      (KLUAC))
ALLOCATE(DA%XLWD      (KLUAC))
ALLOCATE(DA%XLWU      (KLUAC))
ALLOCATE(DA%XFMU      (KLUAC))
ALLOCATE(DA%XFMV      (KLUAC))
!
IF (KLUAC>0) THEN
  DA%XRN      = XUNDEF
  DA%XH       = XUNDEF
  DA%XLE      = XUNDEF
  DA%XLEI     = XUNDEF
  DA%XGFLUX   = XUNDEF
  DA%XQF      = XUNDEF

  DA%XSWD     = XUNDEF
  DA%XSWU     = XUNDEF
  DA%XLWD     = XUNDEF
  DA%XLWU     = XUNDEF
  DA%XFMU     = XUNDEF
  DA%XFMV     = XUNDEF
ENDIF
!
ALLOCATE(DA%XSWBD     (KLUA,KSWA))
ALLOCATE(DA%XSWBU     (KLUA,KSWA))
!
IF (KLUA>0) THEN
  DA%XSWBD    = XUNDEF
  DA%XSWBU    = XUNDEF
ENDIF
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:ALLOC_SURF_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE ALLOC_SURF_BUD
!
SUBROUTINE ALLOC_N2M_BUD(DA,KLUA)
!
TYPE(DIAG_t), INTENT(INOUT) :: DA
INTEGER, INTENT(IN) :: KLUA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:ALLOC_N2M_BUD',0,ZHOOK_HANDLE)
!
ALLOCATE(DA%XRI           (KLUA))
ALLOCATE(DA%XT2M          (KLUA))
ALLOCATE(DA%XT2M_MIN      (KLUA))
ALLOCATE(DA%XT2M_MEAN     (KLUA))
ALLOCATE(DA%XT2M_MAX      (KLUA))
ALLOCATE(DA%XQ2M          (KLUA))
ALLOCATE(DA%XQ2M_MEAN     (KLUA))
ALLOCATE(DA%XHU2M         (KLUA))
ALLOCATE(DA%XHU2M_MIN     (KLUA))
ALLOCATE(DA%XHU2M_MEAN    (KLUA))
ALLOCATE(DA%XHU2M_MAX     (KLUA))
ALLOCATE(DA%XZON10M       (KLUA))
ALLOCATE(DA%XZON10M_MEAN  (KLUA))
ALLOCATE(DA%XMER10M       (KLUA))
ALLOCATE(DA%XMER10M_MEAN  (KLUA))
ALLOCATE(DA%XWIND10M      (KLUA))
ALLOCATE(DA%XWIND10M_MEAN (KLUA))
ALLOCATE(DA%XWIND10M_MAX  (KLUA))
!
IF (KLUA>0) THEN
  DA%XRI      = XUNDEF
  DA%XT2M     = XUNDEF
  DA%XT2M_MIN = XUNDEF
  DA%XT2M_MEAN= 0.0
  DA%XT2M_MAX = -XUNDEF
  DA%XQ2M     = XUNDEF
  DA%XQ2M_MEAN= 0.0
  DA%XHU2M    = XUNDEF
  DA%XHU2M_MIN= XUNDEF
  DA%XHU2M_MEAN =0.0
  DA%XHU2M_MAX= -XUNDEF
  DA%XZON10M  = XUNDEF
  DA%XMER10M  = XUNDEF
  DA%XWIND10M = XUNDEF
  DA%XMER10M_MEAN = 0.0
  DA%XZON10M_MEAN = 0.0
  DA%XWIND10M_MEAN= 0.0
  DA%XWIND10M_MAX = 0.0
  DA%NCOUNT_STEP  = 0
ENDIF
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:ALLOC_N2M_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE ALLOC_N2M_BUD
!
SUBROUTINE ALLOC_COEF_BUD(DA,KLUA)
!
TYPE(DIAG_t), INTENT(INOUT) :: DA
INTEGER, INTENT(IN) :: KLUA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:ALLOC_COEF_BUD',0,ZHOOK_HANDLE)
!
ALLOCATE(DA%XCD   (KLUA))
ALLOCATE(DA%XCH   (KLUA))
ALLOCATE(DA%XCE   (KLUA))
ALLOCATE(DA%XZ0   (KLUA))
ALLOCATE(DA%XZ0H  (KLUA))
!
IF (KLUA>0) THEN
  DA%XCD      = XUNDEF
  DA%XCH      = XUNDEF
  DA%XCE      = XUNDEF
  DA%XZ0      = XUNDEF
  DA%XZ0H     = XUNDEF
ENDIF

IF (LHOOK) CALL DR_HOOK('MODE_DIAG:ALLOC_COEF_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE ALLOC_COEF_BUD
!
SUBROUTINE ALLOC_BUD(DGO,DA,KLU,KSW)
!
TYPE(DIAG_OPTIONS_t), INTENT(IN) :: DGO
TYPE(DIAG_t), INTENT(INOUT) :: DA
INTEGER, INTENT(IN) :: KLU
INTEGER, INTENT(IN) :: KSW
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:ALLOC_BUD',0,ZHOOK_HANDLE)
!
IF (DGO%LSURF_BUDGET .OR. DGO%LSURF_BUDGETC) THEN
  CALL ALLOC_SURF_BUD(DA,KLU,KLU,KSW)
ELSE
  CALL ALLOC_SURF_BUD(DA,0,0,0)
END IF
!
!* parameters at 2m
!
IF (DGO%N2M>=1) THEN
  CALL ALLOC_N2M_BUD(DA,KLU)
ELSE
  CALL ALLOC_N2M_BUD(DA,0)
END IF
!
!* transfer coefficients
!
IF (DGO%LCOEF) THEN
  CALL ALLOC_COEF_BUD(DA,KLU)
ELSE
  CALL ALLOC_COEF_BUD(DA,0)
END IF
!
!* surface humidity
!
IF (DGO%LSURF_VARS) THEN
  ALLOCATE(DA%XQS     (KLU))
  DA%XQS      = XUNDEF
ELSE
  ALLOCATE(DA%XQS     (0))
END IF
!
ALLOCATE(DA%XTS(KLU))
DA%XTS = XUNDEF
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:ALLOC_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE ALLOC_BUD
!
SUBROUTINE INIT_BUD(DGO,DA,DAC,PVAL)
!
TYPE(DIAG_OPTIONS_t), INTENT(IN) :: DGO
TYPE(DIAG_t), INTENT(INOUT) :: DA
TYPE(DIAG_t), INTENT(INOUT) :: DAC
REAL, INTENT(IN) :: PVAL
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_BUD',0,ZHOOK_HANDLE)
!
IF (DGO%LSURF_BUDGET) THEN
  CALL INIT_SURF_BUD(DA,PVAL)
  DA%XEVAP = PVAL
  DA%XSUBL = PVAL
ENDIF
IF (DGO%LSURF_BUDGETC) THEN
  CALL INIT_SURF_BUD(DAC,PVAL)
  DAC%XEVAP = PVAL
  DAC%XSUBL = PVAL  
ENDIF
IF (DGO%N2M>=1) CALL INIT_N2M_BUD(DA,PVAL)
IF (DGO%LCOEF) CALL INIT_COEF_BUD(DA,PVAL)
DA%XTS = PVAL
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_BUD
!
SUBROUTINE INIT_SURF_BUD(DA,PVAL)
!
TYPE(DIAG_t), INTENT(INOUT) :: DA
REAL, INTENT(IN) :: PVAL
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_SURF_BUD',0,ZHOOK_HANDLE)
!
DA%XRN      = PVAL
DA%XH       = PVAL
DA%XLE      = PVAL
DA%XLEI     = PVAL
DA%XGFLUX   = PVAL
DA%XQF      = PVAL
!
DA%XSWD     = PVAL
DA%XSWU     = PVAL
DA%XLWD     = PVAL
DA%XLWU     = PVAL
DA%XFMU     = PVAL
DA%XFMV     = PVAL
!
IF (SIZE(DA%XSWBD)>0) THEN
  DA%XSWBD    = PVAL
  DA%XSWBU    = PVAL
ENDIF
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_SURF_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_SURF_BUD
!
SUBROUTINE INIT_N2M_BUD(DA,PVAL)
!
TYPE(DIAG_t), INTENT(INOUT) :: DA
REAL, INTENT(IN) :: PVAL
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_N2M_BUD',0,ZHOOK_HANDLE)
!
DA%XRI      = PVAL
DA%XT2M     = PVAL
DA%XT2M_MIN = PVAL
DA%XT2M_MAX = PVAL
DA%XQ2M     = PVAL
DA%XHU2M    = PVAL
DA%XHU2M_MIN= PVAL
DA%XHU2M_MAX= PVAL
DA%XZON10M  = PVAL
DA%XMER10M  = PVAL
DA%XWIND10M = PVAL
DA%XWIND10M_MAX = PVAL
DA%XSFCO2       = PVAL
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_N2M_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_N2M_BUD
!
SUBROUTINE INIT_COEF_BUD(DA,PVAL)
!
TYPE(DIAG_t), INTENT(INOUT) :: DA
REAL, INTENT(IN) :: PVAL
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_COEF_BUD',0,ZHOOK_HANDLE)
!
DA%XCD      = PVAL
DA%XCH      = PVAL
DA%XCE      = PVAL
DA%XZ0      = PVAL
DA%XZ0H     = PVAL
DA%XZ0EFF   = PVAL
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_COEF_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_COEF_BUD
!
SUBROUTINE DIAG_EVAP(DGO, DA, DAC, HPROGRAM, DAUP, DAUPC, KMASK )
!
IMPLICIT NONE
!
TYPE(DIAG_OPTIONS_t), INTENT(IN) :: DGO
TYPE(DIAG_t), INTENT(INOUT) :: DA
TYPE(DIAG_t), INTENT(INOUT) :: DAC
 CHARACTER(LEN=6),   INTENT(IN)  :: HPROGRAM ! program calling surf. schemes
TYPE(DIAG_t), INTENT(INOUT) :: DAUP
TYPE(DIAG_t), INTENT(INOUT) :: DAUPC
INTEGER, DIMENSION(:), INTENT(IN) :: KMASK
!
INTEGER :: JJ, ISIZE
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:DIAG_EVAP',0,ZHOOK_HANDLE)
!
ISIZE = SIZE(KMASK)
!
 CALL DIAG_CUMUL(DGO, DA, DAC, HPROGRAM, DAUP, DAUPC, KMASK)
!
IF (DGO%LSURF_BUDGET) THEN
  DO JJ=1,ISIZE
    DAUP%XEVAP    (KMASK(JJ))  = DA%XEVAP     (JJ)
    DAUP%XSUBL    (KMASK(JJ))  = DA%XSUBL     (JJ)
  ENDDO
END IF
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:DIAG_EVAP',1,ZHOOK_HANDLE)
!
END SUBROUTINE DIAG_EVAP
!
SUBROUTINE DIAG_CUMUL(DGO, DA, DAC, HPROGRAM, DAUP, DAUPC, KMASK )
!
IMPLICIT NONE
!
TYPE(DIAG_OPTIONS_t), INTENT(IN) :: DGO
TYPE(DIAG_t), INTENT(INOUT) :: DA
TYPE(DIAG_t), INTENT(INOUT) :: DAC
 CHARACTER(LEN=6),   INTENT(IN)  :: HPROGRAM ! program calling surf. schemes
TYPE(DIAG_t), INTENT(INOUT) :: DAUP
TYPE(DIAG_t), INTENT(INOUT) :: DAUPC
INTEGER, DIMENSION(:), INTENT(IN) :: KMASK
!
INTEGER :: JJ, ISIZE
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:DIAG_CUMUL',0,ZHOOK_HANDLE)
!
ISIZE = SIZE(KMASK)
!
 CALL DIAG(DGO, DA, HPROGRAM, DAUP, KMASK)
!
IF (DGO%LSURF_BUDGETC) THEN
  DO JJ=1,ISIZE
    DAUPC%XRN      (KMASK(JJ))  = DAC%XRN       (JJ)
    DAUPC%XH       (KMASK(JJ))  = DAC%XH        (JJ)
    DAUPC%XLE      (KMASK(JJ))  = DAC%XLE       (JJ)
    DAUPC%XLEI     (KMASK(JJ))  = DAC%XLEI      (JJ)
    DAUPC%XGFLUX   (KMASK(JJ))  = DAC%XGFLUX    (JJ)
    DAUPC%XQF      (KMASK(JJ))  = DAC%XQF       (JJ)
    DAUPC%XEVAP    (KMASK(JJ))  = DAC%XEVAP     (JJ)
    DAUPC%XSUBL    (KMASK(JJ))  = DAC%XSUBL     (JJ)
    DAUPC%XSWD     (KMASK(JJ))  = DAC%XSWD      (JJ)
    DAUPC%XSWU     (KMASK(JJ))  = DAC%XSWU      (JJ)
    DAUPC%XLWD     (KMASK(JJ))  = DAC%XLWD      (JJ)
    DAUPC%XLWU     (KMASK(JJ))  = DAC%XLWU      (JJ)
    DAUPC%XFMU     (KMASK(JJ))  = DAC%XFMU      (JJ)
    DAUPC%XFMV     (KMASK(JJ))  = DAC%XFMV      (JJ)
  ENDDO        
END IF
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:DIAG_CUMUL',1,ZHOOK_HANDLE)
!
END SUBROUTINE DIAG_CUMUL
!
SUBROUTINE DIAG(DGO, DA, HPROGRAM, DAUP, KMASK )
!
IMPLICIT NONE
!
TYPE(DIAG_OPTIONS_t), INTENT(IN) :: DGO
TYPE(DIAG_t), INTENT(INOUT) :: DA
 CHARACTER(LEN=6),   INTENT(IN)  :: HPROGRAM ! program calling surf. schemes
TYPE(DIAG_t), INTENT(INOUT) :: DAUP
INTEGER, DIMENSION(:), INTENT(IN) :: KMASK
!
INTEGER :: JJ, ISIZE
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:DIAG',0,ZHOOK_HANDLE)
!
ISIZE = SIZE(KMASK)
!
IF (DGO%LSURF_BUDGET) THEN
  DO JJ=1,ISIZE
    DAUP%XRN      (KMASK(JJ))  = DA%XRN       (JJ)
    DAUP%XH       (KMASK(JJ))  = DA%XH        (JJ)
    DAUP%XLE      (KMASK(JJ))  = DA%XLE       (JJ)
    DAUP%XLEI     (KMASK(JJ))  = DA%XLEI      (JJ)
    DAUP%XGFLUX   (KMASK(JJ))  = DA%XGFLUX    (JJ)
    DAUP%XQF      (KMASK(JJ))  = DA%XQF       (JJ)
    DAUP%XSWD     (KMASK(JJ))  = DA%XSWD      (JJ)
    DAUP%XSWU     (KMASK(JJ))  = DA%XSWU      (JJ)
    DAUP%XLWD     (KMASK(JJ))  = DA%XLWD      (JJ)
    DAUP%XLWU     (KMASK(JJ))  = DA%XLWU      (JJ)
    DAUP%XFMU     (KMASK(JJ))  = DA%XFMU      (JJ)
    DAUP%XFMV     (KMASK(JJ))  = DA%XFMV      (JJ)
    DAUP%XSWBD    (KMASK(JJ),:) = DA%XSWBD     (JJ,:)
    DAUP%XSWBU    (KMASK(JJ),:) = DA%XSWBU     (JJ,:)
  ENDDO
END IF
!
IF (DGO%N2M>=1 .OR. DGO%LSURF_BUDGET) THEN
  DO JJ=1,ISIZE
    DAUP%XTS       (KMASK(JJ))  = DA%XTS      (JJ)
  ENDDO        
ENDIF
!
IF (DGO%N2M>=1) THEN
  DO JJ=1,ISIZE
    DAUP%XRI      (KMASK(JJ))  = DA%XRI       (JJ)
    DAUP%XT2M     (KMASK(JJ))  = DA%XT2M      (JJ)
    DAUP%XT2M_MIN (KMASK(JJ))  = DA%XT2M_MIN  (JJ)
    DAUP%XT2M_MEAN(KMASK(JJ))  = DA%XT2M_MEAN (JJ)
    DAUP%XT2M_MAX (KMASK(JJ))  = DA%XT2M_MAX  (JJ)
    DAUP%XQ2M     (KMASK(JJ))  = DA%XQ2M      (JJ)
    DAUP%XQ2M_MEAN(KMASK(JJ))  = DA%XQ2M_MEAN (JJ)
    DAUP%XHU2M    (KMASK(JJ))  = DA%XHU2M     (JJ)
    DAUP%XHU2M_MIN(KMASK(JJ))  = DA%XHU2M_MIN (JJ)
    DAUP%XHU2M_MEAN(KMASK(JJ)) = DA%XHU2M_MEAN(JJ)
    DAUP%XHU2M_MAX(KMASK(JJ))  = DA%XHU2M_MAX (JJ)
    DAUP%XZON10M  (KMASK(JJ))  = DA%XZON10M   (JJ)
    DAUP%XMER10M  (KMASK(JJ))  = DA%XMER10M   (JJ)
    DAUP%XWIND10M (KMASK(JJ))  = DA%XWIND10M   (JJ)
    DAUP%XWIND10M_MAX (KMASK(JJ))  = DA%XWIND10M_MAX   (JJ)
    DAUP%XMER10M_MEAN (KMASK(JJ))  = DA%XMER10M_MEAN   (JJ)
    DAUP%XZON10M_MEAN (KMASK(JJ))  = DA%XZON10M_MEAN   (JJ)
    DAUP%XWIND10M_MEAN(KMASK(JJ))  = DA%XWIND10M_MEAN  (JJ)
  ENDDO        
END IF 
!
IF (DGO%LCOEF) THEN
  DO JJ=1,ISIZE
    DAUP%XCD      (KMASK(JJ))  = DA%XCD       (JJ)
    DAUP%XCH      (KMASK(JJ))  = DA%XCH       (JJ)
    DAUP%XCE      (KMASK(JJ))  = DA%XCE       (JJ)
    DAUP%XZ0      (KMASK(JJ))  = DA%XZ0       (JJ)
    DAUP%XZ0H     (KMASK(JJ))  = DA%XZ0H      (JJ)
  ENDDO        
END IF
!
IF (DGO%LSURF_VARS) THEN
  DO JJ=1,ISIZE
    DAUP%XQS      (KMASK(JJ))  = DA%XQS       (JJ)
  ENDDO          
ENDIF
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:DIAG',1,ZHOOK_HANDLE)
!
END SUBROUTINE DIAG
!
SUBROUTINE INIT_EVAP_BUD(DEA)
!
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DEA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_EVAP_BUD',0,ZHOOK_HANDLE)
!
DEA%XLEG        = 0.0
DEA%XLEGI       = 0.0
DEA%XLEV        = 0.0
DEA%XLES        = 0.0
!
DEA%XLESL       = 0.0
DEA%XSNDRIFT    = 0.0
!
DEA%XLER        = 0.0
DEA%XLETR       = 0.0
!
DEA%XDRAIN      = 0.0
DEA%XRUNOFF     = 0.0
DEA%XDRIP       = 0.0
DEA%XRRVEG      = 0.0
DEA%XMELT       = 0.0
!
DEA%XIRRIG_FLUX = 0.0
!
DEA%XGPP        = 0.0
DEA%XRESP_AUTO  = 0.0
DEA%XRESP_ECO   = 0.0  
!
DEA%XQSB        = 0.0
DEA%XHORT       = 0.0
!
DEA%XIFLOOD    = 0.0
DEA%XPFLOOD    = 0.0
DEA%XLE_FLOOD  = 0.0
DEA%XLEI_FLOOD = 0.0
!
DEA%XRN_SN_FR    = 0.0
DEA%XH_SN_FR     = 0.0
DEA%XLEI_SN_FR   = 0.0
DEA%XLE_SN_FR    = 0.0
DEA%XGFLUX_SN_FR = 0.0
DEA%XLEG_SN_FR   = 0.0
DEA%XLEGI_SN_FR  = 0.0
DEA%XLEV_SN_FR   = 0.0
DEA%XLETR_SN_FR  = 0.0
DEA%XUSTAR_SN_FR = 0.0
DEA%XLER_SN_FR   = 0.0
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_EVAP_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_EVAP_BUD
!
SUBROUTINE INIT_MEB_BUD(DEA)
!
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DEA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_MEB_BUD',0,ZHOOK_HANDLE)
!
DEA%XLELITTER      = 0.0
DEA%XLELITTERI     = 0.0
DEA%XDRIPLIT       = 0.0
DEA%XRRLIT         = 0.0
!
DEA%XLEV_CV        = 0.0
DEA%XLES_CV        = 0.0
DEA%XLETR_CV       = 0.0
DEA%XLE_CV         = 0.0
DEA%XH_CV          = 0.0
DEA%XMELT_CV       = 0.0
DEA%XFRZ_CV        = 0.0
!
DEA%XLETR_GV       = 0.0
DEA%XLER_GV        = 0.0
DEA%XLE_GV         = 0.0
DEA%XH_GV          = 0.0
!
DEA%XLE_GN         = 0.0
DEA%XEVAP_GN       = 0.0
DEA%XH_GN          = 0.0
DEA%XSR_GN         = 0.0
DEA%XSWDOWN_GN     = 0.0
DEA%XLWDOWN_GN     = 0.0
!
DEA%XEVAP_G        = 0.0
DEA%XLE_CA         = 0.0
DEA%XH_CA          = 0.0
!
DEA%XSWUP          = 0.0
DEA%XLWUP          = 0.0
!
DEA%XSWNET_V       = 0.0
DEA%XSWNET_G       = 0.0
DEA%XSWNET_N       = 0.0
DEA%XSWNET_NS      = 0.0
DEA%XLWNET_V       = 0.0
DEA%XLWNET_G       = 0.0
DEA%XLWNET_N       = 0.0
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_MEB_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_MEB_BUD
!
SUBROUTINE INIT_WATER_BUD(DEA)
!
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DEA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_WATER_BUD',0,ZHOOK_HANDLE)
!
DEA%XDWG    = 0.0
DEA%XDWGI   = 0.0
DEA%XDWR    = 0.0
DEA%XDSWE   = 0.0
DEA%XWATBUD = 0.0
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:INIT_WATER_BUD',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_WATER_BUD
!
SUBROUTINE AVG_DIAG_TSTEP_EVAP(PTSTEP, DEAC, DEA)
!
REAL, INTENT(IN) :: PTSTEP
TYPE(DIAG_EVAP_ISBA_t), INTENT(IN) :: DEAC
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DEA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:AVG_DIAG_TSTEP_EVAP',0,ZHOOK_HANDLE)
!
DEA%XLEG    (:) = DEAC%XLEG    (:)/PTSTEP
DEA%XLEGI   (:) = DEAC%XLEGI   (:)/PTSTEP
DEA%XLEV    (:) = DEAC%XLEV    (:)/PTSTEP
DEA%XLES    (:) = DEAC%XLES    (:)/PTSTEP
!
DEA%XLESL   (:) = DEAC%XLESL   (:)/PTSTEP
DEA%XSNDRIFT(:) = DEAC%XSNDRIFT(:)/PTSTEP
!
DEA%XLER    (:) = DEAC%XLER    (:)/PTSTEP
DEA%XLETR   (:) = DEAC%XLETR   (:)/PTSTEP
DEA%XDRAIN  (:) = DEAC%XDRAIN  (:)/PTSTEP
DEA%XQSB    (:) = DEAC%XQSB    (:)/PTSTEP
DEA%XRUNOFF (:) = DEAC%XRUNOFF (:)/PTSTEP
DEA%XHORT   (:) = DEAC%XHORT   (:)/PTSTEP
DEA%XDRIP   (:) = DEAC%XDRIP   (:)/PTSTEP
DEA%XRRVEG  (:) = DEAC%XRRVEG  (:)/PTSTEP
DEA%XMELT   (:) = DEAC%XMELT   (:)/PTSTEP
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:AVG_DIAG_TSTEP_EVAP',1,ZHOOK_HANDLE)
!
END SUBROUTINE AVG_DIAG_TSTEP_EVAP
!
SUBROUTINE AVG_DIAG_TSTEP_WATER(PTSTEP, DEAC, DEA)
!
REAL, INTENT(IN) :: PTSTEP
TYPE(DIAG_EVAP_ISBA_t), INTENT(IN) :: DEAC
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DEA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:AVG_DIAG_TSTEP_WATER',0,ZHOOK_HANDLE)
!
DEA%XDWG   (:) = DEAC%XDWG   (:)/PTSTEP
DEA%XDWGI  (:) = DEAC%XDWGI  (:)/PTSTEP
DEA%XDWR   (:) = DEAC%XDWR   (:)/PTSTEP
DEA%XDSWE  (:) = DEAC%XDSWE  (:)/PTSTEP
DEA%XWATBUD(:) = DEAC%XWATBUD(:)/PTSTEP
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:AVG_DIAG_TSTEP_WATER',1,ZHOOK_HANDLE)
!
END SUBROUTINE AVG_DIAG_TSTEP_WATER
!
SUBROUTINE AVG_DIAG_TSTEP_SURF(PTSTEP, DAC, DA)
!
REAL, INTENT(IN) :: PTSTEP
TYPE(DIAG_t), INTENT(IN) :: DAC
TYPE(DIAG_t), INTENT(INOUT) :: DA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:AVG_DIAG_TSTEP_SURF',0,ZHOOK_HANDLE)
!
DA%XRN   (:) = DAC%XRN   (:)/PTSTEP
DA%XH    (:) = DAC%XH    (:)/PTSTEP
DA%XLE   (:) = DAC%XLE   (:)/PTSTEP
DA%XLEI  (:) = DAC%XLEI  (:)/PTSTEP
DA%XGFLUX(:) = DAC%XGFLUX(:)/PTSTEP
DA%XQF   (:) = DAC%XQF   (:)/PTSTEP
!
DA%XEVAP (:) = DAC%XEVAP (:)/PTSTEP
DA%XSUBL (:) = DAC%XSUBL (:)/PTSTEP
!
DA%XSWD(:) = DAC%XSWD(:)/PTSTEP
DA%XSWU(:) = DAC%XSWU(:)/PTSTEP
DA%XLWD(:) = DAC%XLWD(:)/PTSTEP
DA%XLWU(:) = DAC%XLWU(:)/PTSTEP
!
IF (LHOOK) CALL DR_HOOK('MODE_DIAG:AVG_DIAG_TSTEP_SURF',1,ZHOOK_HANDLE)
!
END SUBROUTINE AVG_DIAG_TSTEP_SURF
!
!-------------------------------------------------------------------------------
!
END MODULE MODE_DIAG
