!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     ######spl
        MODULE MODE_COUPLING_CANOPY
!     ####################
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
CONTAINS
!
!     ###############################################################################
SUBROUTINE INIT_FORC( PFORC_U, PDFORC_UDU, PFORC_E, PDFORC_EDE, &
                      PFORC_T, PDFORC_TDT, PFORC_Q, PDFORC_QDQ )
!
IMPLICIT NONE
!
REAL, DIMENSION(:,:), INTENT(OUT) :: PFORC_U
REAL, DIMENSION(:,:), INTENT(OUT) :: PDFORC_UDU
REAL, DIMENSION(:,:), INTENT(OUT) :: PFORC_E
REAL, DIMENSION(:,:), INTENT(OUT) :: PDFORC_EDE
REAL, DIMENSION(:,:), INTENT(OUT) :: PFORC_T
REAL, DIMENSION(:,:), INTENT(OUT) :: PDFORC_TDT
REAL, DIMENSION(:,:), INTENT(OUT) :: PFORC_Q
REAL, DIMENSION(:,:), INTENT(OUT) :: PDFORC_QDQ
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_FORC',0,ZHOOK_HANDLE)
!
PFORC_U    = 0.
PDFORC_UDU = 0.
!
PFORC_E(:,:) = 0.
PDFORC_EDE(:,:) = 0.
!
PFORC_T(:,:) = 0.
PDFORC_TDT(:,:) = 0.
!
PFORC_Q(:,:) = 0.
PDFORC_QDQ(:,:) = 0.
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_FORC',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_FORC
!     ###############################################################################
!
!     ###############################################################################
SUBROUTINE INIT_COUPLING_CANOPY( SB, PPA, PU, PV, &
                                 PRHOA, PALFAU, PBETAU, PALFATH,   &
                                 PBETATH, PALFAQ, PBETAQ,          &
                                 PPPA, PTTA, PQQA, PUU, PVV,       &
                                 PUUREF, PZZREF,  PEXNA,           &
                                 PPEW_AA_COEF, PPEW_BB_COEF,       &
                                 PPET_AA_COEF, PPET_BB_COEF,       &
                                 PPEQ_AA_COEF, PPEQ_BB_COEF        )
!
USE MODD_CANOPY_n, ONLY : CANOPY_t
!
USE MODD_SURF_PAR,         ONLY : XUNDEF
USE MODD_CSTS,             ONLY : XCPD, XRD, XP00
USE MODD_SURF_ATM,         ONLY : XWINDMIN
!
IMPLICIT NONE
!
TYPE(CANOPY_t), INTENT(INOUT) :: SB
!
REAL, DIMENSION(:), INTENT(IN) :: PPA
REAL, DIMENSION(:), INTENT(IN) :: PU
REAL, DIMENSION(:), INTENT(IN) :: PV
REAL, DIMENSION(:), INTENT(IN) :: PRHOA
REAL, DIMENSION(:), INTENT(IN) :: PALFAU
REAL, DIMENSION(:), INTENT(IN) :: PBETAU
REAL, DIMENSION(:), INTENT(IN) :: PALFATH
REAL, DIMENSION(:), INTENT(IN) :: PBETATH
REAL, DIMENSION(:), INTENT(IN) :: PALFAQ
REAL, DIMENSION(:), INTENT(IN) :: PBETAQ
REAL, DIMENSION(:), INTENT(OUT) :: PPPA
REAL, DIMENSION(:), INTENT(OUT) :: PTTA
REAL, DIMENSION(:), INTENT(OUT) :: PQQA
REAL, DIMENSION(:), INTENT(OUT) :: PUU
REAL, DIMENSION(:), INTENT(OUT) :: PVV
REAL, DIMENSION(:), INTENT(OUT) :: PUUREF
REAL, DIMENSION(:), INTENT(OUT) :: PZZREF
REAL, DIMENSION(:), INTENT(OUT) :: PEXNA
REAL, DIMENSION(:), INTENT(OUT) :: PPEW_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEW_BB_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPET_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPET_BB_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEQ_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEQ_BB_COEF
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_COUPLING_CANOPY',0,ZHOOK_HANDLE)
!
PPPA = SB%XP(:,1)
PTTA = SB%XT(:,1)
PQQA = SB%XQ(:,1)
PUU  = PU / MAX(SQRT(PU**2+PV**2),XWINDMIN) * SB%XU(:,1)
PVV  = PV / MAX(SQRT(PU**2+PV**2),XWINDMIN) * SB%XU(:,1)
PUUREF = SB%XZ(:,1)
PZZREF = SB%XZ(:,1)
!
PEXNA(:)   = (SB%XP(:,1)/XP00)**(XRD/XCPD)
WHERE (SB%XP(:,1)==XUNDEF) !* security at first time-step
  PEXNA = (PPA/XP00)**(XRD/XCPD)
  PPPA  = PPA
END WHERE
!
!* ALMA conventions for implicit coefficients:
! U+  = - rho A u'w'  + B
! Th+ = - rho A w'th' + B
! q+  = - rho A w'q'  + B
!
PPEW_AA_COEF = - PALFAU / PRHOA
PPEW_BB_COEF = PBETAU
PPET_AA_COEF = - PALFATH / PRHOA
PPET_BB_COEF = PBETATH
PPEQ_AA_COEF = - PALFAQ / PRHOA
PPEQ_BB_COEF = PBETAQ
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_COUPLING_CANOPY',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_COUPLING_CANOPY
!     ###############################################################################
!
!     ###############################################################################
SUBROUTINE INIT_COUPLING( HCOUPLING,                  &
                          PPS, PPA, PTA, PQA, PU, PV, &
                          PUREF, PZREF,               &
                          PPEW_A_COEF, PPEW_B_COEF,   &
                          PPET_A_COEF, PPET_B_COEF,   &
                          PPEQ_A_COEF, PPEQ_B_COEF,   &
                          PPPA, PTTA, PQQA, PUU, PVV, &
                          PUUREF, PZZREF,             &
                          PPEW_AA_COEF, PPEW_BB_COEF, &
                          PPET_AA_COEF, PPET_BB_COEF, &
                          PPEQ_AA_COEF, PPEQ_BB_COEF  ) 
!
USE MODD_CSTS,             ONLY : XCPD, XRD, XP00
!
IMPLICIT NONE
!
 CHARACTER(LEN=1),   INTENT(IN) :: HCOUPLING
REAL, DIMENSION(:), INTENT(IN) :: PPS
REAL, DIMENSION(:), INTENT(IN) :: PPA
REAL, DIMENSION(:), INTENT(IN) :: PTA
REAL, DIMENSION(:), INTENT(IN) :: PQA
REAL, DIMENSION(:), INTENT(IN) :: PU
REAL, DIMENSION(:), INTENT(IN) :: PV
REAL, DIMENSION(:), INTENT(IN) :: PUREF
REAL, DIMENSION(:), INTENT(IN) :: PZREF
REAL, DIMENSION(:), INTENT(IN) :: PPEW_A_COEF
REAL, DIMENSION(:), INTENT(IN) :: PPEW_B_COEF
REAL, DIMENSION(:), INTENT(IN) :: PPET_A_COEF
REAL, DIMENSION(:), INTENT(IN) :: PPET_B_COEF
REAL, DIMENSION(:), INTENT(IN) :: PPEQ_A_COEF
REAL, DIMENSION(:), INTENT(IN) :: PPEQ_B_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPPA
REAL, DIMENSION(:), INTENT(OUT) :: PTTA
REAL, DIMENSION(:), INTENT(OUT) :: PQQA
REAL, DIMENSION(:), INTENT(OUT) :: PUU
REAL, DIMENSION(:), INTENT(OUT) :: PVV
REAL, DIMENSION(:), INTENT(OUT) :: PUUREF
REAL, DIMENSION(:), INTENT(OUT) :: PZZREF
REAL, DIMENSION(:), INTENT(OUT) :: PPEW_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEW_BB_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPET_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPET_BB_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEQ_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEQ_BB_COEF
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_COUPLING',0,ZHOOK_HANDLE)
!
PPPA = PPA
PTTA = PTA
PQQA = PQA
PUU  = PU 
PVV  = PV 
PUUREF = PUREF
PZZREF = PZREF
!
PPEW_AA_COEF = PPEW_A_COEF
PPEW_BB_COEF = PPEW_B_COEF
!
IF (HCOUPLING=='I') THEN
  PPET_AA_COEF = PPET_A_COEF
  PPEQ_AA_COEF = PPEQ_A_COEF
  PPET_BB_COEF = PPET_B_COEF
  PPEQ_BB_COEF = PPEQ_B_COEF
ELSE
  PPET_AA_COEF =  0.
  PPET_BB_COEF =  PTA / (PPA/XP00)**(XRD/XCPD)
  PPEQ_AA_COEF =  0.
  PPEQ_BB_COEF =  PQA
ENDIF
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_COUPLING',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_COUPLING
!     ###############################################################################
!
!     ###############################################################################
SUBROUTINE INIT_2M_10M( SB, D, PU, PV, PWIND, PRHOA )
!
USE MODD_CANOPY_n, ONLY : CANOPY_t
USE MODD_DIAG_n, ONLY : DIAG_t
!
USE MODD_SURF_PAR, ONLY : XUNDEF
!
USE MODE_THERMOS,  ONLY : QSAT
!
USE MODI_INTERPOL_SBL
!
IMPLICIT NONE
!
TYPE(CANOPY_t), INTENT(INOUT) :: SB
TYPE(DIAG_t), INTENT(INOUT) :: D
!
REAL, DIMENSION(:), INTENT(IN) :: PU
REAL, DIMENSION(:), INTENT(IN) :: PV
REAL, DIMENSION(:), INTENT(IN) :: PWIND
REAL, DIMENSION(:), INTENT(IN) :: PRHOA
!
REAL, DIMENSION(SIZE(SB%XT,1))   :: ZU10
INTEGER                     :: JJ
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_2M_10M',0,ZHOOK_HANDLE)
!
D%XT2M(:) = SB%XT(:,2)
D%XT2M_MIN(:) = MIN(D%XT2M(:),D%XT2M_MIN(:))
D%XT2M_MAX(:) = MAX(D%XT2M(:),D%XT2M_MAX(:))
D%XQ2M(:) = SB%XQ(:,2) / PRHOA(:)
D%XHU2M(:)= MIN( D%XQ2M(:) / QSAT(D%XT2M(:),SB%XP(:,2)) , 1.)
D%XHU2M_MIN(:) = MIN(D%XHU2M(:),D%XHU2M_MIN(:))
D%XHU2M_MAX(:) = MAX(D%XHU2M(:),D%XHU2M_MAX(:))
!
 CALL INTERPOL_SBL(SB%XZ(:,:),SB%XU(:,:),10.,ZU10(:))
DO JJ=1,SIZE(SB%XT(:,2))
  IF (ZU10(JJ)/=XUNDEF) THEN
    IF (PWIND(JJ)>0.) THEN
      D%XZON10M(JJ) = ZU10(JJ) * PU(JJ)/PWIND(JJ)
      D%XMER10M(JJ) = ZU10(JJ) * PV(JJ)/PWIND(JJ)
    ELSE
      D%XZON10M(JJ) = 0.
      D%XMER10M(JJ) = 0.
    END IF
     D%XWIND10M(JJ) = SQRT(D%XZON10M(JJ)**2+D%XMER10M(JJ)**2)
     D%XWIND10M_MAX(JJ) = MAX(D%XWIND10M(JJ),D%XWIND10M_MAX(JJ))
  ELSE
    D%XZON10M(JJ) = XUNDEF
    D%XMER10M(JJ) = XUNDEF
    D%XWIND10M(JJ) = XUNDEF
    D%XWIND10M_MAX(JJ) = XUNDEF
  END IF
END DO
!
D%XT2M_MEAN    (:) = D%XT2M_MEAN    (:) + D%XT2M(:)
D%XQ2M_MEAN    (:) = D%XQ2M_MEAN    (:) + D%XQ2M(:)
D%XHU2M_MEAN   (:) = D%XHU2M_MEAN   (:) + D%XHU2M(:)
D%XZON10M_MEAN (:) = D%XZON10M_MEAN (:) + D%XZON10M(:)
D%XMER10M_MEAN (:) = D%XMER10M_MEAN (:) + D%XMER10M(:)
!
D%NCOUNT_STEP = D%NCOUNT_STEP + 1
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_2M_10M',1,ZHOOK_HANDLE)
!
END SUBROUTINE
!
END MODULE MODE_COUPLING_CANOPY
