!##################
MODULE MODD_TEB_HYDRO_PGD_n
!##################
!
!!****  *MODD_TEB_HYDRO_PGD - declaration of ISBA scheme packed surface parameters for urban hydrology
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!	A. Lemonsu *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       02/2013
!!
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
USE MODD_TYPE_SNOW
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE

TYPE TEB_HYDRO_PGD_t
!-------------------------------------------------------------------------------
!
! Sewer characteristics
!
  REAL, POINTER, DIMENSION(:)    :: XDSEWER          ! Sewer depth    (m)
  REAL, POINTER, DIMENSION(:)    :: XLSEWER          ! Sewer length   (m)
  REAL, POINTER, DIMENSION(:)    :: XLSTORM          ! Sewer length   (m)
  REAL                           :: XWS_ROOF_MAX     ! Max. capacity of surface roof water storage (mm)
  REAL                           :: XWS_ROAD_MAX     ! Max. capacity of surface road water storage (mm)
  REAL                           :: XIP_SEWER        ! Parameter for parasite infiltrations into sewer (-)
  REAL                           :: XCONNEX          ! Impervious surfaces connexion rate to the sewer (-)
  REAL, POINTER, DIMENSION(:)    :: XDENSITY_SEWER   ! Total sewer length density (-)
  INTEGER, POINTER, DIMENSION(:) :: NLAYER_SEWER     ! Ground layer where the sewer is located (-)
  INTEGER                        :: NSTEP_OUT        ! number of run time step in output time step
  INTEGER                        :: NSTEP_FORC       ! forcing run time step loop
  INTEGER                        :: NSTEP_SURF       ! isba run time step loop
!
! Water infiltration through pavement
!
  REAL                           :: XINFIL_ROAD      ! Water infiltration through roads (kg/m2/s)
!
! Limitation of drainage
!
  REAL                           :: XURBDRAIN        ! 
!-------------------------------------------------------------------------------
!
END TYPE TEB_HYDRO_PGD_t

CONTAINS

SUBROUTINE TEB_HYDRO_PGD_INIT(YTEB_HYDRO_PGD)
TYPE(TEB_HYDRO_PGD_t), INTENT(INOUT) :: YTEB_HYDRO_PGD
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_TEB_HYDRO_N:TEB_HYDRO_PGD_INIT",0,ZHOOK_HANDLE)
!
NULLIFY(YTEB_HYDRO_PGD%XDSEWER)
NULLIFY(YTEB_HYDRO_PGD%XLSEWER)
NULLIFY(YTEB_HYDRO_PGD%XLSTORM)
NULLIFY(YTEB_HYDRO_PGD%XDENSITY_SEWER)
NULLIFY(YTEB_HYDRO_PGD%NLAYER_SEWER)
YTEB_HYDRO_PGD%XINFIL_ROAD  = 0.
YTEB_HYDRO_PGD%NSTEP_OUT    = 0.
YTEB_HYDRO_PGD%NSTEP_SURF   = 0.
YTEB_HYDRO_PGD%XWS_ROOF_MAX = 0.
YTEB_HYDRO_PGD%XWS_ROAD_MAX = 0.
YTEB_HYDRO_PGD%XIP_SEWER    = 0.
YTEB_HYDRO_PGD%XCONNEX      = 0.
YTEB_HYDRO_PGD%XINFIL_ROAD  = 0.
YTEB_HYDRO_PGD%XURBDRAIN    = 0.
IF (LHOOK) CALL DR_HOOK("MODD_TEB_HYDRO_N:TEB_HYDRO_PGD_INIT",1,ZHOOK_HANDLE)
END SUBROUTINE TEB_HYDRO_PGD_INIT


END MODULE MODD_TEB_HYDRO_PGD_n
