!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE INIT_OUTPUT_NC_n (BDD, CHE, CHN, CHU, DTS, DTT, DTZ, IM, UG, U, HSELECT)
!     ######################
!
!!****  *INIT_OUTPUT_NC* Keep in memory the netcdf ID of the output files
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      F. Habets   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      modified 05/04 by P. LeMoigne *Meteo France*
!!      modified 06/10 by S. Faroux *Meteo France*
!!=================================================================
!
!*       0.   DECLARATIONS
!             ------------
!
USE MODD_DIAG_n, ONLY : DIAG_t
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_CH_EMIS_FIELD_n, ONLY : CH_EMIS_FIELD_t
USE MODD_CH_SNAP_n, ONLY : CH_EMIS_SNAP_t
USE MODD_CH_SURF_n, ONLY : CH_SURF_t
USE MODD_DATA_SEAFLUX_n, ONLY : DATA_SEAFLUX_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_DATA_TSZ0_n, ONLY : DATA_TSZ0_t
USE MODD_SURFEX_n, ONLY : ISBA_MODEL_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_WRITE_SURF_ATM, ONLY : LSPLIT_PATCH
!
USE MODD_SURF_CONF,      ONLY : CSOFTWARE
!
USE MODD_SURFEX_MPI, ONLY : NPIO, NRANK
!
USE MODD_DATA_COVER, ONLY : LDATA_IRRIG
USE MODD_DATA_COVER_PAR, ONLY : NVEGTYPE, JPCOVER
!
USE MODD_IO_SURF_NC, ONLY : CFILEOUT_NC, NID_NC, LCREATED, CFILEOUT_NC_SAVE, LDEF
!
USE MODN_IO_OFFLINE, ONLY : LRESTART, LWRITE_COORD
!
USE MODE_GRIDTYPE_GAUSS
!
USE MODI_GET_BLD_CONF_n
USE MODI_GET_DATA_SEAFLUX_CONF_n
USE MODI_GET_ISBA_CONF_n
USE MODI_OL_DEFINE_DIM
USE MODI_CREATE_FILE
!
USE MODI_GET_DIM_FULL_n
USE MODI_DEF_VAR_NETCDF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE NETCDF
!
IMPLICIT NONE
!
!
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
TYPE(CH_EMIS_FIELD_t), INTENT(INOUT) :: CHE
TYPE(CH_EMIS_SNAP_t), INTENT(INOUT) :: CHN
TYPE(CH_SURF_t), INTENT(INOUT) :: CHU
TYPE(DATA_SEAFLUX_t), INTENT(INOUT) :: DTS
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(DATA_TSZ0_t), INTENT(INOUT) :: DTZ
TYPE(ISBA_MODEL_t), INTENT(INOUT) :: IM
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!
 CHARACTER(LEN=*), DIMENSION(:), INTENT(IN) :: HSELECT
!
 CHARACTER(LEN=100), DIMENSION(:), POINTER :: YNAME_DIM
 CHARACTER(LEN=100), DIMENSION(1) :: YATT_TITLE, YATT
 CHARACTER(LEN=13),DIMENSION(1)  :: YUNIT1, YUNIT2
 CHARACTER(LEN=3)                 :: YISBA 
!
REAL,DIMENSION(:), POINTER       :: ZX, ZY
!
INTEGER, DIMENSION(:), POINTER   :: IDIMS, IDDIM
INTEGER           :: IDIM1, INDIMS
INTEGER          :: INI, INPATCH, INLVLD, INLVLS, INBIOMASS, &
                    INLITTER, INLITTLEVS, INSOILCARB
INTEGER          :: IDESC_ROOF_LAYER, IDESC_ROAD_LAYER, IDESC_WALL_LAYER, &
                    IDESC_FLOOR_LAYER, IDESC_CODE, IDESC_USE, IDESC_AGE, IDESC_BLD
INTEGER          :: IRET, IL, IFULL, ISNAP, INLATI, ISNOW_LAYER
INTEGER          :: ILUOUT, IDIMID, ITIME, ITOT
INTEGER          :: ID0
!
LOGICAL          :: GEXIST, GOPENED, GSST_DATA
LOGICAL          :: GDATA_BLDTYPE, GDATA_IND_BLD_AGE, GDATA_COL_BLD_AGE, GDATA_USETYPE
!
REAL(KIND=JPRB)  :: ZHOOK_HANDLE
!------------------------------------------------------------------------------ 
IF (LHOOK) CALL DR_HOOK('INIT_OUTPUT_NC_N',0,ZHOOK_HANDLE)
!
CALL GET_DIM_FULL_n(U%NDIM_FULL, IFULL)

IF (NRANK==NPIO) THEN
  INQUIRE(FILE=CFILEOUT_NC,EXIST=GEXIST)
  INQUIRE(FILE=CFILEOUT_NC,OPENED=GOPENED)
  IF (.NOT.GOPENED) THEN
    IRET = NF90_OPEN(CFILEOUT_NC,NF90_WRITE,NID_NC)
  ENDIF
  IF (.NOT.GEXIST .OR. .NOT.LCREATED .OR. CFILEOUT_NC/=CFILEOUT_NC_SAVE) THEN
    IF (CSOFTWARE=='PREP' .OR. CSOFTWARE=='OFFLINE' .OR. CSOFTWARE=='SODA') THEN
      CALL GET_ISBA_CONF_n(IM%O, IM%NPE%AL(1)%TSNOW%NLAYER, &
                           YISBA, INPATCH, INLVLD, INLVLS, INBIOMASS, &
                           INLITTER, INLITTLEVS, INSOILCARB)
    ENDIF
    IF (UG%G%CGRID=='IGN') LWRITE_COORD = .TRUE.
    IF (CSOFTWARE=='PGD') THEN
      IF (LSPLIT_PATCH) THEN
        CALL OL_DEFINE_DIM(UG, U%NSIZE_FULL, 'NOTIME ', ILUOUT, IFULL, IDIM1, YUNIT1, YUNIT2, &
                           ZX, ZY, IDIMS, IDDIM, YNAME_DIM)       
      ELSE 
        CALL OL_DEFINE_DIM(UG, U%NSIZE_FULL, 'NOTIME ', ILUOUT, IFULL, IDIM1, YUNIT1, YUNIT2, &
                           ZX, ZY, IDIMS, IDDIM, YNAME_DIM, INPATCH) 
      ENDIF        
    ELSE
      IF (LSPLIT_PATCH) THEN
        CALL OL_DEFINE_DIM(UG, U%NSIZE_FULL, 'NOTIME ', ILUOUT, IFULL, IDIM1, YUNIT1, YUNIT2, &
                           ZX, ZY, IDIMS, IDDIM, YNAME_DIM)
      ELSE
        CALL OL_DEFINE_DIM(UG, U%NSIZE_FULL, 'NOTIME ', ILUOUT, IFULL, IDIM1, YUNIT1, YUNIT2, &
                           ZX, ZY, IDIMS, IDDIM, YNAME_DIM, INPATCH)
      ENDIF
    ENDIF
    CALL CREATE_FILE(CFILEOUT_NC,IDIMS,YNAME_DIM,NID_NC,IDDIM) 
    !IF (UG%G%CGRID=='IGN') THEN
      !YATT_TITLE(1) = "comment"
      !YATT(1) = "longitude"
      !CALL DEF_VAR_NETCDF(HSELECT,NID_NC,'XLON','XLON',IDDIM(1:1),YATT_TITLE,YATT,ID0,NF90_DOUBLE)
      !YATT(1) = "latitude"
      !CALL DEF_VAR_NETCDF(HSELECT,NID_NC,'XLAT','XLAT',IDDIM(1:1),YATT_TITLE,YATT,ID0,NF90_DOUBLE)
    !ENDIF      
    CFILEOUT_NC_SAVE = CFILEOUT_NC
    LCREATED = .TRUE.
    IF (CSOFTWARE=='PGD') IRET = NF90_DEF_DIM(NID_NC,"Nb_of_input_data",NVEGTYPE*IM%DTV%NTIME,IDIMID)
    IF (CSOFTWARE=='PGD' .OR. ( CSOFTWARE=='OFFLINE' .AND. LRESTART ) ) THEN
      IRET = NF90_DEF_DIM(NID_NC,"Number_of_covers",JPCOVER,IDIMID)
      IF (LDATA_IRRIG) IRET = NF90_DEF_DIM(NID_NC,"Irrig_parameters",6,IDIMID)
      IF (CSOFTWARE=='PGD') THEN
        ISNOW_LAYER = 0
      ELSE
        ISNOW_LAYER = IM%NPE%AL(1)%TSNOW%NLAYER
      ENDIF
      CALL GET_ISBA_CONF_n(IM%O, ISNOW_LAYER, &
                           YISBA, INPATCH, INLVLD, INLVLS, INBIOMASS, &
                           INLITTER, INLITTLEVS, INSOILCARB)
      IF (YISBA=='DIF') IRET = NF90_DEF_DIM(NID_NC,"Nground_layers",INLVLD,IDIMID)
      CALL GET_DATA_SEAFLUX_CONF_n(DTS, GSST_DATA,ITIME)
      IF (GSST_DATA) IRET = NF90_DEF_DIM(NID_NC,"Number_of_dates",ITIME,IDIMID)
      CALL GET_BLD_CONF_n(BDD, DTT, GDATA_BLDTYPE, GDATA_IND_BLD_AGE,GDATA_COL_BLD_AGE, GDATA_USETYPE, &
                 IDESC_ROOF_LAYER, IDESC_ROAD_LAYER, IDESC_WALL_LAYER, &
                 IDESC_FLOOR_LAYER, IDESC_CODE, IDESC_USE, IDESC_AGE, IDESC_BLD)
      IF (GDATA_BLDTYPE .OR. GDATA_IND_BLD_AGE .OR. GDATA_COL_BLD_AGE .OR. GDATA_USETYPE) THEN
        ITOT = (21+3*IDESC_ROOF_LAYER+3*IDESC_ROAD_LAYER+3*IDESC_WALL_LAYER+3*IDESC_FLOOR_LAYER)&
                *IDESC_CODE + 9*IDESC_USE+2*IDESC_AGE+IDESC_BLD
        IRET = NF90_DEF_DIM(NID_NC,"Bld_dimensions  ",7,IDIMID)
        IRET = NF90_DEF_DIM(NID_NC,"Bld_parameters  ",ITOT,IDIMID)
      ENDIF
      IF (CHU%LCH_EMIS) THEN
        IF (CHU%CCH_EMIS=='AGGR') THEN
          IF (CHE%NEMIS_NBR/=0) IRET = NF90_DEF_DIM(NID_NC,"Temporal_emiss  ",CHE%NTIME_MAX,IDIMID)
        ELSE IF (CHU%CCH_EMIS=='SNAP') THEN
          ISNAP = MAX(CHN%NSNAP_M,CHN%NSNAP_D,CHN%NSNAP_H)
          IF (ISNAP/=0 .AND. CHN%NEMIS_SNAP/=0) THEN
            IRET = NF90_DEF_DIM(NID_NC,"Nemis_snap",CHN%NEMIS_SNAP,IDIMID)
            IRET = NF90_DEF_DIM(NID_NC,"Nsnap_temp",ISNAP,IDIMID)
          ENDIF
        ENDIF
      ENDIF
      IF (ASSOCIATED(DTZ%XDATA_DTS)) THEN
        ITIME = SIZE(DTZ%XDATA_DTS) 
        IF (ITIME/=0) IRET = NF90_DEF_DIM(NID_NC,"Nforc_tsz0",ITIME,IDIMID)
      ENDIF
    ENDIF
    IF (UG%G%CGRID=='GAUSS') THEN
      CALL GET_GRIDTYPE_GAUSS(UG%G%XGRID_PAR,INLATI)
      IRET = NF90_DEF_DIM(NID_NC,"Nlati",INLATI,IDIMID)
    ENDIF
  ELSE
    IF (LDEF) IRET = NF90_REDEF(NID_NC)
  ENDIF
  IF (LDEF) IRET = NF90_ENDDEF(NID_NC)
  IRET = NF90_CLOSE(NID_NC)
ELSE
  IF (UG%G%CGRID=='IGN') LWRITE_COORD = .TRUE.
ENDIF
!
!------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('INIT_OUTPUT_NC_N',1,ZHOOK_HANDLE)
!------------------------------------------------------------------------------
!
END SUBROUTINE INIT_OUTPUT_NC_n
