!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     ######spl
      SUBROUTINE DIAG_MISC_TEB_INIT_n (DMTC, DMT, DMTO, TOP, BOP, HM, KLU, KSW, KTEB_SOIL)
!     #####################
!
!!****  *DIAG_MISC_TEB_INIT_n* - routine to initialize TEB diagnostic variables
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004 
!!      E.Redon/A.Lemonsu 01/2016 New diagnostics for high vegetation
!!      M. Goret          07/2017 New diagnostics for CO2 fluxes
!!      M. Goret          09/2017 add diagnostic of heat storage link to snow
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DIAG_MISC_TEB_n, ONLY : DIAG_MISC_TEB_t
USE MODD_DIAG_MISC_TEB_OPTIONS_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
USE MODD_BEM_OPTION_n, ONLY : BEM_OPTIONS_t
!
USE MODD_SURFEX_n,     ONLY : TEB_HYDRO_MODEL_t
!
USE MODD_SURF_PAR,   ONLY : XUNDEF
USE MODD_TYPE_DATE_SURF
!


!
USE MODI_READ_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DMTC
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DMT
TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DMTO
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
TYPE(BEM_OPTIONS_t),           INTENT(INOUT) :: BOP
TYPE(TEB_HYDRO_MODEL_t), INTENT(INOUT) :: HM
!
INTEGER, INTENT(IN) :: KLU   ! size of arrays
INTEGER, INTENT(IN) :: KSW   ! spectral bands
INTEGER, INTENT(IN) :: KTEB_SOIL  ! total soil layers
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YREC           ! Name of the article to be read
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!* surface energy budget
!
IF (LHOOK) CALL DR_HOOK('DIAG_MISC_TEB_INIT_N',0,ZHOOK_HANDLE)
!
!* miscellaneous fields
!
!IF (DMTO%LSURF_MISC_BUDGET) THEN
  ALLOCATE(DMT%XQF_BLD           (KLU))
  ALLOCATE(DMT%XFLX_BLD          (KLU))
  ALLOCATE(DMT%XQF_TOWN          (KLU))
  ALLOCATE(DMT%XDQS_TOWN         (KLU))
  ALLOCATE(DMT%XRN_ROAD          (KLU))
  ALLOCATE(DMT%XH_ROAD           (KLU))
  ALLOCATE(DMT%XLE_ROAD          (KLU))
  ALLOCATE(DMT%XGFLUX_ROAD       (KLU))
  ALLOCATE(DMT%XRN_WALL_A        (KLU))
  ALLOCATE(DMT%XH_WALL_A         (KLU))
  ALLOCATE(DMT%XLE_WALL_A        (KLU))
  ALLOCATE(DMT%XGFLUX_WALL_A     (KLU))
  ALLOCATE(DMT%XRN_WALL_B        (KLU))
  ALLOCATE(DMT%XH_WALL_B         (KLU))
  ALLOCATE(DMT%XLE_WALL_B        (KLU))
  ALLOCATE(DMT%XGFLUX_WALL_B     (KLU))
  ALLOCATE(DMT%XRN_ROOF          (KLU))
  ALLOCATE(DMT%XH_ROOF           (KLU))
  ALLOCATE(DMT%XLE_ROOF          (KLU))
  ALLOCATE(DMT%XGFLUX_ROOF       (KLU))
  ALLOCATE(DMT%XH_HVEG           (KLU))
  ALLOCATE(DMT%XLE_HVEG          (KLU))
  ALLOCATE(DMT%XRN_BLT           (KLU))
  ALLOCATE(DMT%XH_BLT            (KLU))
  ALLOCATE(DMT%XLE_BLT           (KLU))
  ALLOCATE(DMT%XGFLUX_BLT        (KLU))
  ALLOCATE(DMT%XRN_STRLROOF      (KLU))
  ALLOCATE(DMT%XH_STRLROOF       (KLU))
  ALLOCATE(DMT%XLE_STRLROOF      (KLU))
  ALLOCATE(DMT%XGFLUX_STRLROOF   (KLU))
  ALLOCATE(DMT%XG_GREENROOF_ROOF (KLU))
  ALLOCATE(DMT%XRUNOFF_TOWN      (KLU))
  ALLOCATE(DMT%XRUNOFF_ROAD      (KLU))
  ALLOCATE(DMT%XRUNOFF_STRLROOF  (KLU))
  ALLOCATE(DMT%XRUNOFF_ROOF      (KLU))
  ALLOCATE(DMT%XIRRIG_GREENROOF  (KLU))
  ALLOCATE(DMT%XIRRIG_GARDEN     (KLU))
  ALLOCATE(DMT%XIRRIG_ROAD       (KLU))
  ALLOCATE(DMT%XH_TRAFFIC_OUT    (KLU))
  ALLOCATE(DMT%XLE_TRAFFIC_OUT   (KLU))
  ALLOCATE(DMT%XH_INDUSTRY_OUT   (KLU))
  ALLOCATE(DMT%XLE_INDUSTRY_OUT  (KLU))
  ALLOCATE(DMT%XQF_WALL_A        (KLU))
  ALLOCATE(DMT%XQF_WALL_B        (KLU))
  ALLOCATE(DMT%XQF_ROAD          (KLU))
  ALLOCATE(DMT%XQF_ROOF          (KLU))
  ALLOCATE(DMT%XQF_BLT           (KLU))
  ALLOCATE(DMT%XSNOW_HEAT_ROAD   (KLU))
  ALLOCATE(DMT%XSNOW_HEAT_ROOF   (KLU))
  !
  ALLOCATE(DMT%XDN_ROOF(KLU))
  ALLOCATE(DMT%XDN_ROAD(KLU))
  ALLOCATE(DMT%XDW_ROOF(KLU))
  ALLOCATE(DMT%XDW_ROAD(KLU))
  !
  ALLOCATE(DMT%XRUNOFF_SEWER     (KLU))
  ALLOCATE(DMT%XNOC_ROOF         (KLU))
  ALLOCATE(DMT%XNOC_ROAD         (KLU))
  ALLOCATE(DMT%XDRAIN_ROAD       (KLU))
  ALLOCATE(DMT%XDRAIN_BLD        (KLU))
  ALLOCATE(DMT%XRUNOFFSOIL_ROAD  (KLU))
  ALLOCATE(DMT%XRUNOFFSOIL_BLD   (KLU))
  !
  IF (TOP%LURBHYDRO) THEN  
    ALLOCATE(DMT%XWG_ROAD_INI      (KLU,KTEB_SOIL))
    ALLOCATE(DMT%XWG_BLD_INI       (KLU,KTEB_SOIL))
    ALLOCATE(DMT%XWG_GARDEN_INI    (KLU,KTEB_SOIL))
  ENDIF
  !
  ALLOCATE(DMT%XH_WASTE_ROOF     (KLU))
  ALLOCATE(DMT%XLE_WASTE_ROOF    (KLU))
  ALLOCATE(DMT%XABS_SW_SKY       (KLU))
  ALLOCATE(DMT%XABS_LW_SKY       (KLU))
  ALLOCATE(DMT%XABS_SW_WIN       (KLU)) 
  ALLOCATE(DMT%XABS_LW_WIN       (KLU))  
  ALLOCATE(DMT%XABS_SW_ROOF      (KLU))
  ALLOCATE(DMT%XABS_SW_SNOW_ROOF (KLU))
  ALLOCATE(DMT%XABS_LW_ROOF      (KLU))
  ALLOCATE(DMT%XABS_LW_SNOW_ROOF (KLU))
  ALLOCATE(DMT%XDIR_SW_ROAD      (KLU))
  ALLOCATE(DMT%XSCA_SW_ROAD      (KLU))
  ALLOCATE(DMT%XABS_SW_ROAD      (KLU))
  ALLOCATE(DMT%XABS_SW_SNOW_ROAD (KLU))
  ALLOCATE(DMT%XABS_LW_ROAD      (KLU))
  ALLOCATE(DMT%XABS_LW_SNOW_ROAD (KLU))
  ALLOCATE(DMT%XDIR_SW_WALL      (KLU))
  ALLOCATE(DMT%XDIR_SW_WALL_A    (KLU))
  ALLOCATE(DMT%XDIR_SW_WALL_B    (KLU))
  ALLOCATE(DMT%XSCA_SW_WALL      (KLU))
  ALLOCATE(DMT%XABS_SW_WALL_A    (KLU))
  ALLOCATE(DMT%XABS_SW_WALL_B    (KLU))
  ALLOCATE(DMT%XABS_LW_WALL_A    (KLU))
  ALLOCATE(DMT%XABS_LW_WALL_B    (KLU))
  ALLOCATE(DMT%XDIR_SW_GARDEN    (KLU))
  ALLOCATE(DMT%XSCA_SW_GARDEN    (KLU))
  ALLOCATE(DMT%XREC_SW_GARDEN    (KLU))
  ALLOCATE(DMT%XREC_LW_GARDEN    (KLU))
  ALLOCATE(DMT%XABS_SW_GARDEN    (KLU))
  ALLOCATE(DMT%XABS_LW_GARDEN    (KLU))
  ALLOCATE(DMT%XDIR_SW_HVEG      (KLU))
  ALLOCATE(DMT%XNTR_DIR_SW_HVEG  (KLU))
  ALLOCATE(DMT%XSCA_SW_HVEG      (KLU))
  ALLOCATE(DMT%XREC_SW_HVEG      (KLU))
  ALLOCATE(DMT%XREC_LW_HVEG      (KLU))
  ALLOCATE(DMT%XABS_SW_HVEG      (KLU))
  ALLOCATE(DMT%XABS_LW_HVEG      (KLU))
  ALLOCATE(DMT%XNET_LW_HVEG      (KLU))
  ALLOCATE(DMT%XTS_HVEG          (KLU))
  ALLOCATE(DMT%XREC_SW_VEG       (KLU))
  ALLOCATE(DMT%XREC_LW_VEG       (KLU))
  ALLOCATE(DMT%XABS_SW_GREENROOF (KLU))
  ALLOCATE(DMT%XABS_LW_GREENROOF (KLU))
  ALLOCATE(DMT%XSW_UP_ROOF       (KLU))
  ALLOCATE(DMT%XSW_UP_CAN        (KLU))
  ALLOCATE(DMT%XLW_UP_ROOF       (KLU))
  ALLOCATE(DMT%XLW_UP_CAN        (KLU))
  !
  ALLOCATE(DMT%XREF_SW_FAC     (KLU))  
  ALLOCATE(DMT%XREF_SW_GRND    (KLU))
  !
  ALLOCATE(DMT%XEMIT_LW_FAC    (KLU))
  ALLOCATE(DMT%XEMIT_LW_GRND   (KLU))
  !
  ALLOCATE(DMT%XSENFABSTOR     (KLU))
  ALLOCATE(DMT%XLATFABSTOR     (KLU))
  ALLOCATE(DMT%XROOFTK         (KLU))
  ALLOCATE(DMT%XWALLTK         (KLU))
  ALLOCATE(DMT%XU_LOWCAN       (KLU))
  ALLOCATE(DMT%XROAD_SHADE     (KLU))
  !
  ALLOCATE(DMT%XABS_SW_PANEL   (KLU))
  ALLOCATE(DMT%XABS_LW_PANEL   (KLU))
  ALLOCATE(DMT%XRN_PANEL       (KLU))
  ALLOCATE(DMT%XH_PANEL        (KLU))
  ALLOCATE(DMT%XTHER_PROD_PANEL(KLU))
  ALLOCATE(DMT%XPHOT_PROD_PANEL(KLU))
  ALLOCATE(DMT%XPROD_PANEL     (KLU))
  ALLOCATE(DMT%XTHER_PROD_BLD  (KLU))
  ALLOCATE(DMT%XPHOT_PROD_BLD  (KLU))
  !
  ALLOCATE(DMTC%XRUNOFF_TOWN     (KLU))
  ALLOCATE(DMTC%XIRRIG_GARDEN    (KLU))
  ALLOCATE(DMTC%XRUNOFF_ROAD     (KLU))
  ALLOCATE(DMTC%XIRRIG_ROAD      (KLU))
  ALLOCATE(DMTC%XRUNOFF_STRLROOF (KLU))
  ALLOCATE(DMTC%XRUNOFF_ROOF     (KLU))
  ALLOCATE(DMTC%XIRRIG_GREENROOF (KLU))
  !
  IF (TOP%CBEM=='BEM') THEN
    ALLOCATE(DMTC%XHVAC_COOL (KLU))
    ALLOCATE(DMTC%XHVAC_HEAT (KLU))
  ENDIF
  !
  ALLOCATE(DMT%XSFCO2_BLD (KLU))
  ALLOCATE(DMT%XSFCO2_RD  (KLU))
  ALLOCATE(DMT%XSFCO2_POP (KLU))
  !
  IF (TOP%LSOLAR_PANEL) THEN
    ALLOCATE(DMTC%XTHER_PROD_BLD(KLU))
    ALLOCATE(DMTC%XPHOT_PROD_BLD(KLU))
  END IF
  !
  ALLOCATE(DMT%XSFCO2     (KLU))
  ALLOCATE(DMT%XSFCO2_VEG (KLU))
  !
  DMT%XQF_BLD            = XUNDEF
  DMT%XFLX_BLD           = XUNDEF
  DMT%XQF_TOWN           = XUNDEF
  DMT%XDQS_TOWN          = XUNDEF
  DMT%XRN_ROAD           = XUNDEF
  DMT%XH_ROAD            = XUNDEF
  DMT%XLE_ROAD           = XUNDEF
  DMT%XGFLUX_ROAD        = XUNDEF
  DMT%XRN_WALL_A         = XUNDEF
  DMT%XH_WALL_A          = XUNDEF
  DMT%XLE_WALL_A         = XUNDEF
  DMT%XGFLUX_WALL_A      = XUNDEF
  DMT%XRN_WALL_B         = XUNDEF
  DMT%XH_WALL_B          = XUNDEF
  DMT%XLE_WALL_B         = XUNDEF
  DMT%XGFLUX_WALL_B      = XUNDEF
  DMT%XRN_ROOF           = XUNDEF
  DMT%XH_ROOF            = XUNDEF
  DMT%XLE_ROOF           = XUNDEF
  DMT%XGFLUX_ROOF        = XUNDEF 
  DMT%XH_HVEG            = XUNDEF
  DMT%XLE_HVEG           = XUNDEF
  DMT%XRN_BLT            = XUNDEF
  DMT%XH_BLT             = XUNDEF
  DMT%XLE_BLT            = XUNDEF
  DMT%XGFLUX_BLT         = XUNDEF  
  DMT%XRN_STRLROOF       = XUNDEF
  DMT%XH_STRLROOF        = XUNDEF
  DMT%XLE_STRLROOF       = XUNDEF
  DMT%XGFLUX_STRLROOF    = XUNDEF  
  DMT%XG_GREENROOF_ROOF  = XUNDEF  
  DMT%XRUNOFF_TOWN       = XUNDEF  
  DMT%XRUNOFF_ROAD       = XUNDEF  
  DMT%XRUNOFF_ROOF       = XUNDEF  
  DMT%XRUNOFF_STRLROOF   = XUNDEF
  DMT%XIRRIG_GREENROOF   = XUNDEF  
  DMT%XIRRIG_GARDEN      = XUNDEF  
  DMT%XIRRIG_ROAD        = XUNDEF  
  DMT%XH_TRAFFIC_OUT     = XUNDEF
  DMT%XLE_TRAFFIC_OUT    = XUNDEF
  DMT%XH_INDUSTRY_OUT    = XUNDEF
  DMT%XLE_INDUSTRY_OUT   = XUNDEF
  DMT%XDN_ROOF           = XUNDEF
  DMT%XDN_ROAD           = XUNDEF
  DMT%XDW_ROOF           = XUNDEF
  DMT%XDW_ROAD           = XUNDEF
  DMT%XH_WASTE_ROOF      = XUNDEF
  DMT%XLE_WASTE_ROOF     = XUNDEF
  DMT%XABS_SW_WIN        = XUNDEF 
  DMT%XABS_LW_WIN        = XUNDEF  
  DMT%XABS_SW_SKY        = XUNDEF
  DMT%XABS_LW_SKY        = XUNDEF
  DMT%XABS_SW_ROOF       = XUNDEF  
  DMT%XABS_SW_SNOW_ROOF  = XUNDEF  
  DMT%XABS_LW_ROOF       = XUNDEF  
  DMT%XABS_LW_SNOW_ROOF  = XUNDEF  
  DMT%XDIR_SW_ROAD       = XUNDEF 
  DMT%XSCA_SW_ROAD       = XUNDEF 
  DMT%XABS_SW_ROAD       = XUNDEF  
  DMT%XABS_SW_SNOW_ROAD  = XUNDEF  
  DMT%XABS_LW_ROAD       = XUNDEF  
  DMT%XABS_LW_SNOW_ROAD  = XUNDEF  
  DMT%XDIR_SW_WALL       = XUNDEF
  DMT%XDIR_SW_WALL_A     = XUNDEF
  DMT%XDIR_SW_WALL_B     = XUNDEF
  DMT%XSCA_SW_WALL       = XUNDEF
  DMT%XABS_SW_WALL_A     = XUNDEF  
  DMT%XABS_SW_WALL_B     = XUNDEF  
  DMT%XABS_LW_WALL_A     = XUNDEF  
  DMT%XABS_LW_WALL_B     = XUNDEF  
  DMT%XREC_SW_GARDEN     = XUNDEF  
  DMT%XREC_LW_GARDEN     = XUNDEF 
  DMT%XABS_SW_GARDEN     = XUNDEF  
  DMT%XABS_LW_GARDEN     = XUNDEF 
  DMT%XDIR_SW_HVEG       = XUNDEF
  DMT%XNTR_DIR_SW_HVEG   = XUNDEF
  DMT%XSCA_SW_HVEG       = XUNDEF
  DMT%XREC_SW_HVEG       = XUNDEF  
  DMT%XREC_LW_HVEG       = XUNDEF 
  DMT%XABS_SW_HVEG       = XUNDEF  
  DMT%XABS_LW_HVEG       = XUNDEF
  DMT%XNET_LW_HVEG       = XUNDEF
  DMT%XTS_HVEG           = XUNDEF
  DMT%XREC_SW_VEG        = XUNDEF  
  DMT%XREC_LW_VEG        = XUNDEF 
  DMT%XABS_SW_GREENROOF  = XUNDEF  
  DMT%XABS_LW_GREENROOF  = XUNDEF 
  DMT%XSW_UP_ROOF        = XUNDEF  
  DMT%XSW_UP_CAN         = XUNDEF 
  DMT%XLW_UP_ROOF        = XUNDEF  
  DMT%XLW_UP_CAN         = XUNDEF 
  !
  DMT%XREF_SW_FAC        = XUNDEF
  DMT%XREF_SW_GRND       = XUNDEF
  !
  DMT%XEMIT_LW_FAC       = XUNDEF
  DMT%XEMIT_LW_GRND      = XUNDEF
  !
  DMT%XSENFABSTOR        = XUNDEF
  DMT%XLATFABSTOR        = XUNDEF
  DMT%XROOFTK            = XUNDEF
  DMT%XWALLTK            = XUNDEF
  DMT%XU_LOWCAN          = XUNDEF
  DMT%XROAD_SHADE        = XUNDEF
  !
  DMT%XABS_SW_PANEL    = XUNDEF
  DMT%XABS_LW_PANEL    = XUNDEF
  DMT%XRN_PANEL        = XUNDEF
  DMT%XH_PANEL         = XUNDEF
  DMT%XTHER_PROD_PANEL = XUNDEF
  DMT%XPHOT_PROD_PANEL = XUNDEF
  DMT%XPROD_PANEL      = XUNDEF
  DMT%XTHER_PROD_BLD   = XUNDEF
  DMT%XPHOT_PROD_BLD   = XUNDEF
  !  
  DMTC%XRUNOFF_TOWN       = 0.0  
  DMTC%XRUNOFF_ROAD       = 0.0  
  DMTC%XRUNOFF_ROOF       = 0.0  
  DMTC%XRUNOFF_STRLROOF   = 0.0  
  DMTC%XIRRIG_GREENROOF   = 0.0  
  DMTC%XIRRIG_GARDEN      = 0.0  
  DMTC%XIRRIG_ROAD        = 0.0
  !
  IF (TOP%CBEM=='BEM') THEN
     DMTC%XHVAC_COOL       = 0.0
     DMTC%XHVAC_HEAT       = 0.0

  ENDIF
  !
  DMT%XSFCO2_BLD = XUNDEF
  DMT%XSFCO2_RD  = XUNDEF
  DMT%XSFCO2_POP = XUNDEF
  DMT%XSFCO2     = XUNDEF
  DMT%XSFCO2_VEG = XUNDEF
  !
  IF (TOP%LSOLAR_PANEL) THEN
     DMTC%XTHER_PROD_BLD = 0.
     DMTC%XPHOT_PROD_BLD = 0.
  END IF
  !
  DMT%XRUNOFF_SEWER    = 0.0
  DMT%XNOC_ROOF        = 0.0
  DMT%XNOC_ROAD        = 0.0
  DMT%XDRAIN_ROAD      = 0.0
  DMT%XDRAIN_BLD       = 0.0
  DMT%XRUNOFFSOIL_ROAD = 0.0
  DMT%XRUNOFFSOIL_BLD  = 0.0
  !
  ALLOCATE(DMT%XT_RAD_IND(KLU,BOP%NBEMCOMP))
  DMT%XT_RAD_IND = XUNDEF
  !
  IF (TOP%CBEM=='BEM') THEN
    ALLOCATE(DMT%XH_BLD_COOL     (KLU))
    ALLOCATE(DMT%XLE_BLD_COOL    (KLU))
    ALLOCATE(DMT%XH_WASTE_CANY   (KLU))
    ALLOCATE(DMT%XLE_WASTE_CANY  (KLU))
    ALLOCATE(DMT%XHVAC_COOL      (KLU))
    ALLOCATE(DMT%XHVAC_HEAT      (KLU))
    ALLOCATE(DMT%XQINOUT         (KLU))
    ALLOCATE(DMT%XHVAC_HEAT_ELEC (KLU))
    ALLOCATE(DMT%XHVAC_HEAT_GAS  (KLU))
    ALLOCATE(DMT%XHVAC_HEAT_FUEL (KLU))
    ALLOCATE(DMT%XHVAC_HEAT_OTHER(KLU))
    ALLOCATE(DMT%XCOMP_HVAC_COOL (KLU,BOP%NBEMCOMP))
    ALLOCATE(DMT%XCOMP_HVAC_HEAT (KLU,BOP%NBEMCOMP))
    ALLOCATE(DMT%XCOMP_QINOUT    (KLU,BOP%NBEMCOMP))
    ALLOCATE(DMT%XMASSTK         (KLU))
    ALLOCATE(DMT%XINFCALC        (KLU))
    ALLOCATE(DMT%XDIAGSHAD       (KLU,BOP%NBEMCOMP))
    ALLOCATE(DMT%XDIAGVENT       (KLU,BOP%NBEMCOMP))
    ALLOCATE(DMT%XDIAGVEFL       (KLU,BOP%NBEMCOMP))
    ALLOCATE(DMT%XBLDOCC         (KLU,BOP%NBEMCOMP))
    ALLOCATE(DMT%XQIN_KWH        (KLU))
    ALLOCATE(DMT%XHVAC_HT_KWH    (KLU))
    ALLOCATE(DMT%XHVAC_CL_KWH    (KLU))
    ALLOCATE(DMT%XCAP_SYS        (KLU))
    ALLOCATE(DMT%XM_SYS          (KLU,BOP%NBEMCOMP))
    ALLOCATE(DMT%XCOP            (KLU))
    ALLOCATE(DMT%XQ_SYS          (KLU,BOP%NBEMCOMP))
    ALLOCATE(DMT%XT_SYS          (KLU,BOP%NBEMCOMP))
    ALLOCATE(DMT%XTR_SW_WIN      (KLU,BOP%NBEMCOMP))
    !
    ALLOCATE(DMT%XHOTWATOUT      (KLU))    
    ALLOCATE(DMT%XHOTWAT_GAS     (KLU))
    ALLOCATE(DMT%XHOTWAT_ELEC    (KLU))
    ALLOCATE(DMT%XCOMP_HOTWAT    (KLU,BOP%NBEMCOMP))
    !DMTC 
    ALLOCATE(DMTC%XHVAC_COOL       (KLU))
    ALLOCATE(DMTC%XHVAC_HEAT       (KLU))
    ALLOCATE(DMTC%XQINOUT          (KLU))
    ALLOCATE(DMTC%XHVAC_HEAT_ELEC  (KLU))
    ALLOCATE(DMTC%XHVAC_HEAT_GAS   (KLU))
    ALLOCATE(DMTC%XHVAC_HEAT_FUEL  (KLU))
    ALLOCATE(DMTC%XHVAC_HEAT_OTHER (KLU)) 
    ALLOCATE(DMTC%XHOTWATOUT       (KLU))
    ALLOCATE(DMTC%XHOTWAT_GAS      (KLU))
    ALLOCATE(DMTC%XHOTWAT_ELEC     (KLU))
    !DMT
    DMT%XH_BLD_COOL     = XUNDEF
    DMT%XLE_BLD_COOL    = XUNDEF
    DMT%XH_WASTE_CANY   = XUNDEF
    DMT%XLE_WASTE_CANY  = XUNDEF
    DMT%XHVAC_COOL      = XUNDEF
    DMT%XHVAC_HEAT      = XUNDEF
    DMT%XQINOUT         = XUNDEF
    DMT%XHVAC_HEAT_ELEC = XUNDEF
    DMT%XHVAC_HEAT_GAS  = XUNDEF
    DMT%XHVAC_HEAT_FUEL = XUNDEF
    DMT%XHVAC_HEAT_OTHER= XUNDEF
    DMT%XCOMP_HVAC_COOL = XUNDEF
    DMT%XCOMP_HVAC_HEAT = XUNDEF
    DMT%XCOMP_QINOUT    = XUNDEF
    DMT%XMASSTK         = XUNDEF
    DMT%XQIN_KWH        = XUNDEF
    DMT%XHVAC_HT_KWH    = XUNDEF
    DMT%XHVAC_CL_KWH    = XUNDEF
    DMT%XINFCALC        = XUNDEF
    DMT%XDIAGSHAD       = XUNDEF
    DMT%XDIAGVENT       = XUNDEF
    DMT%XDIAGVEFL       = XUNDEF
    DMT%XBLDOCC         = XUNDEF
    DMT%XCAP_SYS        = XUNDEF
    DMT%XM_SYS          = XUNDEF
    DMT%XCOP            = XUNDEF
    DMT%XQ_SYS          = XUNDEF
    DMT%XT_SYS          = XUNDEF
    DMT%XTR_SW_WIN      = XUNDEF
    !
    DMT%XHOTWATOUT      = XUNDEF    
    DMT%XHOTWAT_GAS     = XUNDEF
    DMT%XHOTWAT_ELEC    = XUNDEF  
    DMT%XCOMP_HOTWAT    = XUNDEF  
    !DMTC
    DMTC%XHVAC_COOL       = 0.0
    DMTC%XHVAC_HEAT       = 0.0
    DMTC%XQINOUT          = 0.0
    DMTC%XHVAC_HEAT_ELEC  = 0.0
    DMTC%XHVAC_HEAT_GAS   = 0.0
    DMTC%XHVAC_HEAT_FUEL  = 0.0
    DMTC%XHVAC_HEAT_OTHER = 0.0  
    DMTC%XHOTWATOUT       = 0.0 
    DMTC%XHOTWAT_GAS      = 0.0 
    DMTC%XHOTWAT_ELEC     = 0.0 
  ENDIF

!
IF (LHOOK) CALL DR_HOOK('DIAG_MISC_TEB_INIT_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_MISC_TEB_INIT_n
