!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #################################################################################
SUBROUTINE DEALLOC_TEB_n (TM, GDM, GRM, HM)
!     #################################################################################
!
!!****  *DEALLOC_TEB_n * - Deallocate all arrays
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      G. Pigeon   09/2012: deallocate ROUGH_WALL/ROUGH_ROOF
!!      G. Pigeon   10/2012: deallocate BEM variables
!!------------------------------------------------------------------
!
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_INIT
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_INIT
USE MODD_ISBA_n, ONLY : ISBA_S_INIT, ISBA_K_INIT, ISBA_P_INIT, ISBA_NPE_INIT
!
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_NP_INIT
USE MODD_DIAG_n, ONLY : DIAG_INIT, DIAG_NP_INIT, DIAG_OPTIONS_INIT
USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_NP_INIT
!
USE MODD_CH_TEB_n, ONLY : CH_TEB_INIT
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_INIT
USE MODD_DIAG_MISC_TEB_OPTIONS_n, ONLY : DIAG_MISC_TEB_OPTIONS_INIT
USE MODD_DIAG_UTCI_n, ONLY : DIAG_UTCI_INIT
USE MODD_TEB_IRRIG_n, ONLY : TEB_IRRIG_INIT
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_INIT
USE MODD_TEB_PANEL_n, ONLY : TEB_PANEL_INIT
USE MODD_DIAG_MISC_TEB_n, ONLY : DIAG_MISC_TEB_NP_INIT
USE MODD_TEB_n, ONLY : TEB_NP_INIT
!
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_INIT
USE MODD_BEM_OPTION_n, ONLY : BEM_OPTIONS_INIT
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_INIT
USE MODD_BEM_n, ONLY : BEM_NP_INIT
!
USE MODD_DATA_TEB_HYDRO_n, ONLY : DATA_TEB_HYDRO_INIT
USE MODD_TEB_HYDRO_n, ONLY : TEB_HYDRO_NP_INIT
USE MODD_TEB_HYDRO_PGD_n, ONLY : TEB_HYDRO_PGD_INIT
USE MODD_TEB_HYDRO_OPTION_n, ONLY : TEB_HYDRO_OPTIONS_INIT
!
USE MODD_SFX_GRID_n, ONLY : GRID_INIT
USE MODD_CANOPY_n, ONLY : CANOPY_INIT
USE MODD_GR_BIOG_n, ONLY : GR_BIOG_INIT
!
USE MODD_SURFEX_n, ONLY : TEB_MODEL_t, TEB_GARDEN_MODEL_t, TEB_GREENROOF_MODEL_t, TEB_HYDRO_MODEL_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
!*      0.2    declarations of local variables
!
!-------------------------------------------------------------------------------------
!
TYPE(TEB_MODEL_t), INTENT(INOUT) :: TM
TYPE(TEB_GARDEN_MODEL_t), INTENT(INOUT) :: GDM
TYPE(TEB_GREENROOF_MODEL_t), INTENT(INOUT) :: GRM
TYPE(TEB_HYDRO_MODEL_t), INTENT(INOUT) :: HM
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('DEALLOC_TEB_N',0,ZHOOK_HANDLE)
!
CALL DIAG_NP_INIT(GDM%VD%ND,0)  
CALL DIAG_EVAP_ISBA_NP_INIT(GDM%VD%NDE,0)
CALL DIAG_EVAP_ISBA_NP_INIT(GDM%VD%NDEC,0)
CALL DIAG_MISC_ISBA_NP_INIT(GDM%VD%NDM,0)  
  !  
CALL DATA_ISBA_INIT(GDM%DTV)
CALL ISBA_OPTIONS_INIT(GDM%O)
CALL ISBA_S_INIT(GDM%S)  
CALL GR_BIOG_INIT(GDM%GB)
CALL ISBA_K_INIT(GDM%K)
CALL ISBA_P_INIT(GDM%P)
!
CALL ISBA_NPE_INIT(GDM%NPE,0)  
!
CALL DIAG_NP_INIT(GRM%VD%ND,0)
CALL DIAG_EVAP_ISBA_NP_INIT(GRM%VD%NDE,0)
CALL DIAG_EVAP_ISBA_NP_INIT(GRM%VD%NDEC,0)
CALL DIAG_MISC_ISBA_NP_INIT(GRM%VD%NDM,0)
  !
CALL DATA_ISBA_INIT(GRM%DTV)
CALL ISBA_OPTIONS_INIT(GRM%O)
CALL ISBA_S_INIT(GRM%S)  
CALL GR_BIOG_INIT(GRM%GB)
CALL ISBA_K_INIT(GRM%K)
CALL ISBA_P_INIT(GRM%P)
!
CALL ISBA_NPE_INIT(GRM%NPE,0)
!
!
CALL DIAG_OPTIONS_INIT(TM%TD%O)
CALL DIAG_INIT(TM%TD%D)
CALL DIAG_MISC_TEB_OPTIONS_INIT(TM%TD%MTO)
CALL DIAG_UTCI_INIT(TM%TD%DU)
!
CALL DIAG_MISC_TEB_NP_INIT(TM%TD%NDMT,0)   
CALL DIAG_MISC_TEB_NP_INIT(TM%TD%NDMTC,0)
! 
CALL DATA_TEB_INIT(TM%DTT)
CALL TEB_OPTIONS_INIT(TM%TOP)
CALL CANOPY_INIT(TM%SB)
CALL GRID_INIT(TM%G)  
CALL CH_TEB_INIT(TM%CHT)
CALL TEB_PANEL_INIT(TM%TPN)
CALL TEB_IRRIG_INIT(TM%TIR)    
!
CALL TEB_NP_INIT(TM%NT,0)  
!
CALL DATA_BEM_INIT(TM%DTB)    
CALL BEM_OPTIONS_INIT(TM%BOP)  
CALL BLD_DESC_INIT(TM%BDD)
!
CALL BEM_NP_INIT(TM%NB,0)  
!
CALL DATA_TEB_HYDRO_INIT(HM%DTH)
CALL TEB_HYDRO_PGD_INIT(HM%THP)
CALL TEB_HYDRO_NP_INIT(HM%NTH,0)
CALL TEB_HYDRO_OPTIONS_INIT(HM%THO)
!
IF (LHOOK) CALL DR_HOOK('DEALLOC_TEB_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DEALLOC_TEB_n


