list.nourbtree = c("TEB_CAN_T02.TXT","TEB_CAN_Q02.TXT","TEB_CAN_U02.TXT",
                   "TWALLA1.TXT","TWALLB1.TXT","GD_TG1.TXT",
                   "SWR_GD.TXT","SWU.TXT","SWD.TXT",
                   "H_GD.TXT","LE_GD.TXT","GFLUX_GD.TXT","RN_GD.TXT",
                   "GD_WG1.TXT","GD_WG2.TXT",
                   "TROAD1.TXT",
		   "UTCI_OUTSUN.TXT","UTCI_OUTSHAD.TXT",
		   "RN.TXT","H.TXT","LE.TXT","GFLUX.TXT",
		   "RHOA.TXT",
		   "UTCI_OUTAGG.TXT")

list.urbtree   = c("TEB_CAN_T02.TXT","TEB_CAN_Q02.TXT","TEB_CAN_U02.TXT",
                   "TWALLA1.TXT","TWALLB1.TXT","GD_TG1.TXT",
                   "SWR_GD.TXT","SWU.TXT","SWD.TXT",
                   "H_GD.TXT","LE_GD.TXT","GFLUX_GD.TXT","RN_GD.TXT",
                   "GD_WG1.TXT","GD_WG2.TXT",
                   "TROAD1.TXT","SWR_HV.TXT","SWR_VEG.TXT","TS_HV.TXT",
                   "H_HV.TXT","LE_HV.TXT",
		   "UTCI_OUTSUN.TXT","UTCI_OUTSHAD.TXT",
		   "RN.TXT","H.TXT","LE.TXT","GFLUX.TXT",
		   "RHOA.TXT",
		   "UTCI_OUTAGG.TXT")


# Diagnoses for no urbtree model experience
for (i in list.nourbtree) {
  tmp = read.table(paste(dir.mod,"Outputs_nourbtree/",i,sep=""))
  if (which(i==list.nourbtree)==1) {
    nourbtree.tree = as.numeric(gsub("D","E",tmp$V1))
  } else {
    nourbtree.tree = cbind(nourbtree.tree,as.numeric(gsub("D","E",tmp$V1)))
  }
}
# Conversion des températures en °C
ind.conv = which(list.nourbtree=="TEB_CAN_T02.TXT"|list.nourbtree=="TWALLA1.TXT"|list.nourbtree=="TWALLB1.TXT"|list.nourbtree=="GD_TG1.TXT"|list.nourbtree=="TROAD1.TXT")
nourbtree.tree[,ind.conv] = nourbtree.tree[,ind.conv]-273.15
# Conversion de l'humidité spécifique dans le canyon
nourbtree.tree[,which(list.nourbtree=="TEB_CAN_Q02.TXT")] = 
	nourbtree.tree[,which(list.nourbtree=="TEB_CAN_Q02.TXT")]/
	nourbtree.tree[,which(list.nourbtree=="RHOA.TXT")]
# Extraction des 144 pas de temps suivants
nourbtree.tree = nourbtree.tree[146:289,]



# Diagnoses for urbtree model experience
for (i in list.urbtree) {
  tmp = read.table(paste(dir.mod,"Outputs_urbtree/",i,sep=""))
  if (which(i==list.urbtree)==1) {
    urbtree.tree = as.numeric(gsub("D","E",tmp$V1))
  } else {
    urbtree.tree = cbind(urbtree.tree,as.numeric(gsub("D","E",tmp$V1)))
  }
}
# Conversion des températures en °C
ind.conv = which(list.urbtree=="TEB_CAN_T02.TXT"|list.urbtree=="TWALLA1.TXT"|list.urbtree=="TWALLB1.TXT"|list.urbtree=="GD_TG1.TXT"|list.urbtree=="TROAD1.TXT"|list.urbtree=="TS_HV.TXT")
urbtree.tree[,ind.conv] = urbtree.tree[,ind.conv]-273.15
# Conversion de l'humidité spécifique dans le canyon
urbtree.tree[,which(list.urbtree=="TEB_CAN_Q02.TXT")] = 
	urbtree.tree[,which(list.urbtree=="TEB_CAN_Q02.TXT")]/
	urbtree.tree[,which(list.urbtree=="RHOA.TXT")]
# Extraction des 144 pas de temps suivants
urbtree.tree = urbtree.tree[146:289,]


