list.nourbtree = c("TEB_CAN_T02.TXT","TEB_CAN_Q02.TXT","TEB_CAN_U02.TXT",
                   "TWALLA1.TXT","TWALLB1.TXT","GD_TG1.TXT",
                   "SWR_GD.TXT","SWU.TXT","SWD.TXT",
                   "H_GD.TXT","LE_GD.TXT","GFLUX_GD.TXT","RN_GD.TXT",
                   "GD_WG1.TXT","GD_WG2.TXT",
                   "TROAD1.TXT",
		   "UTCI_OUTSUN.TXT","UTCI_OUTSHAD.TXT",
		   "RN.TXT","H.TXT","LE.TXT","GFLUX.TXT",
		   "RHOA.TXT",
		   "UTCI_OUTAGG.TXT")

list.urbtree   = c("TEB_CAN_T02.TXT","TEB_CAN_Q02.TXT","TEB_CAN_U02.TXT",
                   "TWALLA1.TXT","TWALLB1.TXT","GD_TG1.TXT",
                   "SWR_GD.TXT","SWU.TXT","SWD.TXT",
                   "H_GD.TXT","LE_GD.TXT","GFLUX_GD.TXT","RN_GD.TXT",
                   "GD_WG1.TXT","GD_WG2.TXT",
                   "TROAD1.TXT","SWR_HV.TXT","SWR_VEG.TXT","TS_HV.TXT",
                   "H_HV.TXT","LE_HV.TXT",
		   "UTCI_OUTSUN.TXT","UTCI_OUTSHAD.TXT",
		   "RN.TXT","H.TXT","LE.TXT","GFLUX.TXT",
		   "RHOA.TXT",
		   "UTCI_OUTAGG.TXT")


# Diagnoses for no urbtree model experience
for (i in list.nourbtree) {
  tmp = read.table(paste(dir.mod,"Outputs_nourbtree/",i,sep=""))
  if (which(i==list.nourbtree)==1) {
    nourbtree.trgr = as.numeric(gsub("D","E",tmp$V1))
  } else {
    nourbtree.trgr = cbind(nourbtree.trgr,as.numeric(gsub("D","E",tmp$V1)))
  }
}
# Conversion des températures en °C
ind.conv = which(list.nourbtree=="TEB_CAN_T02.TXT"|list.nourbtree=="TWALLA1.TXT"|list.nourbtree=="TWALLB1.TXT"|list.nourbtree=="GD_TG1.TXT"|list.nourbtree=="TROAD1.TXT")
nourbtree.trgr[,ind.conv] = nourbtree.trgr[,ind.conv]-273.15
# Conversion de l'humidité spécifique dans le canyon
nourbtree.trgr[,which(list.nourbtree=="TEB_CAN_Q02.TXT")] = 
	nourbtree.trgr[,which(list.nourbtree=="TEB_CAN_Q02.TXT")]/
	nourbtree.trgr[,which(list.nourbtree=="RHOA.TXT")]
# Extraction des 144 pas de temps suivants
nourbtree.trgr = nourbtree.trgr[146:289,]


# Diagnoses for urbtree model experience
for (i in list.urbtree) {
  tmp = read.table(paste(dir.mod,"Outputs_urbtree/",i,sep=""))
  if (which(i==list.urbtree)==1) {
    urbtree.trgr = as.numeric(gsub("D","E",tmp$V1))
  } else {
    urbtree.trgr = cbind(urbtree.trgr,as.numeric(gsub("D","E",tmp$V1)))
  }
}
# Conversion des températures en °C
ind.conv = which(list.urbtree=="TEB_CAN_T02.TXT"|list.urbtree=="TWALLA1.TXT"|list.urbtree=="TWALLB1.TXT"|list.urbtree=="GD_TG1.TXT"|list.urbtree=="TROAD1.TXT"|list.urbtree=="TS_HV.TXT")
urbtree.trgr[,ind.conv] = urbtree.trgr[,ind.conv]-273.15
# Conversion de l'humidité spécifique dans le canyon
urbtree.trgr[,which(list.urbtree=="TEB_CAN_Q02.TXT")] = 
	urbtree.trgr[,which(list.urbtree=="TEB_CAN_Q02.TXT")]/
	urbtree.trgr[,which(list.urbtree=="RHOA.TXT")]
# Extraction des 144 pas de temps suivants
urbtree.trgr = urbtree.trgr[146:289,]


