


library(zoo)
library(caTools)
library(hydroGOF)


# Colonnes d'intérêt urbtree
ind.urb.TEM = which(list.urbtree=="TEB_CAN_T02.TXT") 
ind.urb.HUS = which(list.urbtree=="TEB_CAN_Q02.TXT") 
ind.urb.WIN = which(list.urbtree=="TEB_CAN_U02.TXT") 
ind.urb.TWE = which(list.urbtree=="TWALLA1.TXT") 
ind.urb.TWW = which(list.urbtree=="TWALLB1.TXT") 
ind.urb.TTR = which(list.urbtree=="TS_HV.TXT") 
ind.urb.TPA = which(list.urbtree=="TROAD1.TXT") 
ind.urb.TSO = which(list.urbtree=="GD_TG1.TXT") 
ind.urb.SUN = which(list.urbtree=="UTCI_OUTSUN.TXT") 
ind.urb.SHD = which(list.urbtree=="UTCI_OUTSHAD.TXT") 
ind.urb.AGG = which(list.urbtree=="UTCI_OUTAGG.TXT") 
ind.urb.ETR1= which(list.urbtree=="LE_HV.TXT") 
ind.urb.ETR2= which(list.urbtree=="LE_GD.TXT") 
ind.urb.SEB1= which(list.urbtree=="RN.TXT") 
ind.urb.SEB2= which(list.urbtree=="H.TXT") 
ind.urb.SEB3= which(list.urbtree=="LE.TXT") 
ind.urb.SEB4= which(list.urbtree=="GFLUX.TXT") 

# Colonnes d'intérêt nourbtree
ind.nourb.TEM = which(list.nourbtree=="TEB_CAN_T02.TXT") 
ind.nourb.HUS = which(list.nourbtree=="TEB_CAN_Q02.TXT") 
ind.nourb.WIN = which(list.nourbtree=="TEB_CAN_U02.TXT") 
ind.nourb.TWE = which(list.nourbtree=="TWALLA1.TXT") 
ind.nourb.TWW = which(list.nourbtree=="TWALLB1.TXT") 
ind.nourb.TTR = which(list.nourbtree=="GD_TG1.TXT") 
ind.nourb.TPA = which(list.nourbtree=="TROAD1.TXT") 
ind.nourb.TSO = which(list.nourbtree=="GD_TG1.TXT") 
ind.nourb.SUN = which(list.nourbtree=="UTCI_OUTSUN.TXT") 
ind.nourb.SHD = which(list.nourbtree=="UTCI_OUTSHAD.TXT") 
ind.nourb.AGG = which(list.nourbtree=="UTCI_OUTAGG.TXT") 
ind.nourb.ETR = which(list.nourbtree=="LE_GD.TXT") 
ind.nourb.SEB1= which(list.nourbtree=="RN.TXT") 
ind.nourb.SEB2= which(list.nourbtree=="H.TXT") 
ind.nourb.SEB3= which(list.nourbtree=="LE.TXT") 
ind.nourb.SEB4= which(list.nourbtree=="GFLUX.TXT") 

abscissa = seq(1:144)/6



# For access to observations, please contact directly Prof Evyatar Erall

obs.trgr = as.data.frame(array(NA,dim=c(144,8)) )
names(obs.trgr) = c("TEM","HUS","WIN","TWE","TWW","TPA","TTR","ETRtot")



#########################################################################
png(paste(dir.mod,'sb07_tree_canyon_ComparisonSMOOTH.png',sep=""), width = 1440, height = 960, units = "px")
par(mfrow=c(2,3),cex=1.2)

plot(abscissa,runmean(obs.trgr$TEM,k=3),type="l",col="grey10",lwd=4,las=1,main="",cex.main=1.5,
     xlim=c(0,24),xaxp=c(0,24,8),xlab="Time (hr)",ylim=c(15,40),ylab="T (°C)",xaxt="n")
lines(abscissa,runmean(nourbtree.trgr[,ind.nourb.TEM],k=3),col="red"  ,lwd=4)
lines(abscissa,  runmean(urbtree.trgr[,ind.urb.TEM]  ,k=3),col="limegreen",lwd=4)
title("(a) Air temperature",adj=0,line=1.,cex.main=1.5)
legend("topleft",c("Frc","Obs","TEB-Ref","TEB-Tree"),col=c("grey10","grey10","red","limegreen"),
       lwd=c(1,4,4,4),lty=c(1,1,1,1),pch=c(21,NA,NA,NA),pt.bg=c("white",NA,NA,NA),bty="n",cex=1.3)
axis(1,seq(0,24,3),c("0","3","6","9","12","15","18","21","0"))

plot(abscissa,runmean(obs.trgr$HUS*1000.,k=3),type="l",col="grey10",lwd=4,las=1,main="",cex.main=1.5,
     xlim=c(0,24),xaxp=c(0,24,8),xlab="Time (hr)",ylim=c(7.,19.),ylab="HUS (g kg-1)",xaxt="n")
lines(abscissa,runmean(nourbtree.trgr[,ind.nourb.HUS]*1000.,k=3),col="red"  ,lwd=4)
lines(abscissa,  runmean(urbtree.trgr[,ind.urb.HUS]*1000.  ,k=3),col="limegreen",lwd=4)
title("(b) Air specific humidity",adj=0,line=1.,cex.main=1.5)
legend("topleft",c("Frc","Obs","TEB-Ref","TEB-Tree"),col=c("grey10","grey10","red","limegreen"),
       lwd=c(1,4,4,4),lty=c(1,1,1,1),pch=c(21,NA,NA,NA),pt.bg=c("white",NA,NA,NA),bty="n",cex=1.3)
axis(1,seq(0,24,3),c("0","3","6","9","12","15","18","21","0"))

plot(abscissa,runmean(obs.trgr$WIN,k=3),type="l",col="grey10",lwd=4,las=1,main="",cex.main=1.5,
     xlim=c(0,24),xaxp=c(0,24,8),xlab="Time (hr)",ylim=c(0,6),ylab="U (m s-1)",xaxt="n")
lines(abscissa,runmean(nourbtree.trgr[,ind.nourb.WIN],k=3),col="red"  ,lwd=4,xaxt="n")
lines(abscissa,  runmean(urbtree.trgr[,ind.urb.WIN]  ,k=3),col="limegreen",lwd=4)
title("(c) Wind speed",adj=0,line=1.,cex.main=1.5)
legend("topleft",c("Frc","Obs","TEB-Ref","TEB-Tree"),col=c("grey10","grey10","red","limegreen"),
       lwd=c(1,4,4,4),lty=c(1,1,1,1),pch=c(21,NA,NA,NA),pt.bg=c("white",NA,NA,NA),bty="n",cex=1.3)
axis(1,seq(0,24,3),c("0","3","6","9","12","15","18","21","0"))

plot(abscissa,runmean(obs.trgr$TWE,k=3),type="l",col="grey10",lwd=4,las=1,main="",cex.main=1.5,
     xlim=c(0,24),xaxp=c(0,24,8),xlab="Time (hr)",ylim=c(15,45),ylab="T (°C)",xaxt="n")
lines(abscissa,runmean(nourbtree.trgr[,ind.nourb.TWE],k=3),col="red"      ,lwd=4)
lines(abscissa,  runmean(urbtree.trgr[,ind.urb.TWE]  ,k=3),col="limegreen",lwd=4)
title("(d) Eastern wall temperatures",adj=0,line=1.,cex.main=1.5)
legend("topleft",c("Obs","TEB-Ref","TEB-Tree"),col=c("grey10","red","limegreen"),
       lwd=c(4,4,4),lty=c(1,1,1),pch=c(NA,NA,NA),bty="n",cex=1.3)
axis(1,seq(0,24,3),c("0","3","6","9","12","15","18","21","0"))

plot(abscissa,runmean(obs.trgr$TWW,k=3),type="l",col="grey10",lwd=4,las=1,main="",cex.main=1.5,
     xlim=c(0,24),xaxp=c(0,24,8),xlab="Time (hr)",ylim=c(15,45),ylab="T (°C)",xaxt="n")
lines(abscissa,runmean(nourbtree.trgr[,ind.nourb.TWW],k=3),col="red"  ,lwd=4)
lines(abscissa,  runmean(urbtree.trgr[,ind.urb.TWW]  ,k=3),col="limegreen",lwd=4)
title("(e) Western wall temperature",adj=0,line=1.,cex.main=1.5)
legend("topleft",c("Obs","TEB-Ref","TEB-Tree"),col=c("grey10","red","limegreen"),
       lwd=c(4,4,4),lty=c(1,1,1),pch=c(NA,NA,NA),bty="n",cex=1.3)
axis(1,seq(0,24,3),c("0","3","6","9","12","15","18","21","0"))

plot(abscissa,runmean(obs.trgr$TTR,k=3),type="l",col="grey10",lwd=4,las=1,main="",cex.main=1.5,
     xlim=c(0,24),xaxp=c(0,24,8),xlab="Time (hr)",ylim=c(15,45),ylab="T (°C)",xaxt="n")
lines(abscissa,runmean(obs.trgr$TEM,k=3),col="grey60",lwd=4)
lines(abscissa,runmean(nourbtree.trgr[,ind.nourb.TTR],k=3),col="red",lwd=4)
lines(abscissa,  runmean(urbtree.trgr[,ind.urb.TTR]  ,k=3),col="limegreen",lwd=4)
lines(abscissa,  runmean(urbtree.trgr[,ind.urb.TSO]  ,k=3),col="limegreen",lwd=4,lty=4)
title("(f) Tree canopy temperature",adj=0,line=1.,cex.main=1.5)
legend("topleft" ,c("Obs (Tt)","Obs (Tair)"),col=c("grey10","grey60"),lwd=4,lty=c(1,1),pch=c(NA,NA),bty="n",cex=1.3)
legend("topright",c("TEB-Ref (Tnat)","TEB-Tree (Tt)","TEB-Tree (Tnat)"),col=c("red","limegreen","limegreen"),lwd=4,lty=c(1,1,4),bty="n",cex=1.3)
axis(1,seq(0,24,3),c("0","3","6","9","12","15","18","21","0"))

dev.off()
#########################################################################




#########################################################################
png(paste(dir.mod,'sb07_tree_canyon_UTCIwgt_SMOOTH.png',sep=""), width = 500, height = 480, units = "px")
par(mfrow=c(1,1),cex=1.2,mgp = c(3,1,0))

plot(abscissa,runmean(obs.trgr$TEM,k=3),type="l",col="black",lwd=4,las=1,main="",
     xlim=c(0,24),xaxp=c(0,24,8),xlab="Time (hr)",ylim=c(10,42),ylab="UTCI (°C)",xaxt="n")
lines(abscissa,runmean(nourbtree.trgr[,ind.nourb.AGG],k=3),col="red"       ,lwd=4)
lines(abscissa,runmean(  urbtree.trgr[,  ind.urb.AGG],k=3),col="limegreen" ,lwd=4)
abline(v=abscissa[c(30,114)],lty=2)
legend("topleft",c("Tair Obs","UTCI TEB-Ref","UTCI TEB-Tree"),lty=c(1,1,1),lwd=4,,col=c("black","red","limegreen"),bty="n",cex=1.1)
axis(1,seq(0,24,3),c("0","3","6","9","12","15","18","21","0"))

dev.off()
#########################################################################





#########################################################################
png(paste(dir.mod,'sb07_tree_canyon_TREE_SMOOTH.png',sep=""), width = 960, height = 450, units = "px")
par(mfrow=c(1,2),cex=1.2)

plot(abscissa,runmean(obs.trgr$TTR,k=3),type="l",col="grey10",lwd=4,las=1,main="",cex.main=1.5,
     xlim=c(0,24),xaxp=c(0,24,8),xlab="Time (hr)",ylim=c(15,45),ylab="T (°C)",xaxt="n")
lines(abscissa,runmean(obs.trgr$TEM,k=3),col="grey60",lwd=4)
lines(abscissa,runmean(nourbtree.trgr[,ind.nourb.TTR],k=3),col="red",lwd=4)
lines(abscissa,  runmean(urbtree.trgr[,ind.urb.TTR]  ,k=3),col="limegreen",lwd=4)
lines(abscissa,  runmean(urbtree.trgr[,ind.urb.TSO]  ,k=3),col="limegreen",lwd=4,lty=4)
title("(a) Tree canopy temperature",adj=0,line=1.,cex.main=1.5)
legend("topleft" ,c("Obs (Ttree)","Obs (Tair)"),col=c("grey10","grey60"),lwd=4,lty=1,pch=c(NA,NA),bty="n",cex=1.3)
legend("topright",c("TEB-Ref (Tveg)","TEB-Tree (Ttree)","TEB-Tree (Tveg)"),col=c("red","limegreen","limegreen"),lwd=4,lty=c(1,1,4),bty="n",cex=1.3)
axis(1,seq(0,24,3),c("0","3","6","9","12","15","18","21","0"))

plot(abscissa,runmean(obs.trgr$ETRtot,k=3),type="l",col="grey10",lwd=4,las=1,main="",cex.main=1.5,
     xlim=c(0,24),xaxp=c(0,24,8),xlab="Time (hr)",ylim=c(-50,700),ylab="LE (W m-2)",xaxt="n")
lines(abscissa,runmean(nourbtree.trgr[,ind.nourb.ETR],k=3),col="red",lwd=4)
lines(abscissa,runmean(0.875*urbtree.trgr[,ind.urb.ETR1]+urbtree.trgr[,ind.urb.ETR2],k=3),col="limegreen",lwd=4)
title("(b) Tree transpiration",adj=0,line=1.,cex.main=1.5)
legend("topleft",c("Obs","TEB-Ref","TEB-Tree"),col=c("grey10","red","limegreen"),
       lwd=c(4,4,4),lty=c(1,1,1),pch=c(NA,NA,NA),bty="n",cex=1.3)
axis(1,seq(0,24,3),c("0","3","6","9","12","15","18","21","0"))

dev.off()
#########################################################################

