#! /bin/csh -f

# Set batch system options for SGI

#-------------------------------------------------------
# [1] Set necessary environment variables
#-------------------------------------------------------

# your HAVE TO change it with your directory root
setenv ROOTDIR /d21/clmeng

# 1) set clm include directory root
setenv CLM_INCDIR $ROOTDIR/ium/include

# 2) set clm raw land data directory root
setenv CLM_RAWDIR $ROOTDIR/ium/rawdata

# 3) set clm surface data rectory root
setenv CLM_SRFDIR $ROOTDIR/ium/mksrfdata

# 4) set clm input data directory root
setenv CLM_DATADIR $ROOTDIR/ium/data

# 5) set clm initial directory root
setenv CLM_INIDIR $ROOTDIR/ium/mkinidata

# 6) set clm source directory root
setenv CLM_SRCDIR $ROOTDIR/ium/main

# 7) set executable directory
setenv CLM_EXEDIR $ROOTDIR/ium/run

# 8) creat the output directory
setenv CLM_OUTDIR $ROOTDIR/ium/output
rm -rf $CLM_OUTDIR
mkdir -p $CLM_OUTDIR >/dev/null

# set debugging flag to TRUE or FALSE
setenv DEBUG  FALSE     

# set NTASKS to number of MPI tasks (if 1 than SPMD is off)   
# set NTHRDS to number of OPENMP threads

setenv ARCH `uname -s`

if ($ARCH == 'IRIX64') then
  # the following are default values that the script provides
  setenv NTASKS  1       
  setenv NTHRDS  28
endif

#------------------------------------------------------
# build define.h in ./include directory
#------------------------------------------------------

\cat >! .tmp << EOF; cmp -s .tmp $CLM_INCDIR/define.h || \
                     mv -f .tmp $CLM_INCDIR/define.h
#undef coup_atmosmodel
#undef RDGRID
#define SOILINI
#define offline
#define USGS24
#undef EcoDynamics
#define LANDONLY
#define WR_HOURLY
EOF


#-------------------------------------------------------
# [3] compling and executing clm initialization
#-------------------------------------------------------

# Compile
cd $CLM_INIDIR
make clean
make >>& $CLM_EXEDIR/clm.log.compile || exit 5

# Create an input parameter namelist file
cat >! $CLM_EXEDIR/inidat.stdin << EOF
&clminiexp
site           = 'daqisuo'
greenwich      = .true.
start_yr       =  2014
start_jday     =  365
start_sec      =  57600
fsurdat        = ''
flaidat        = '$CLM_DATADIR/lai_daqisuo.dat'
fsoildat       = '$CLM_DATADIR/soil_daqisuo.dat'
fmetdat        = '$CLM_DATADIR/met_daqisuo.dat'
fhistTimeConst = '$CLM_OUTDIR/daqisuo-rstTimeConst'
fhistTimeVar   = '$CLM_OUTDIR/daqisuo-rstTimeVar'
foutdat        = '$CLM_OUTDIR/daqisuo'
finfolist      = '$CLM_EXEDIR/clmini.infolist'
lon_points     =  1
lat_points     =  1
deltim         =  1800
mstep          =  11760
/
EOF

# Executing clm initialization'
$CLM_INIDIR/initial.x < $CLM_EXEDIR/inidat.stdin >& $CLM_EXEDIR/clm.log.initial

echo 'CLM Initialization Completed'


#-------------------------------------------------------
# [4] compiling and executing clm model
#-------------------------------------------------------

# Compile
cd $CLM_SRCDIR
make clean
make >>& $CLM_EXEDIR/clm.log.compile || exit 5

# Create an input parameter namelist file
cat >! $CLM_EXEDIR/timeloop.stdin << EOF; \
        cmp -s $CLM_EXEDIR/timeloop.stdin $CLM_EXEDIR/clmini.infolist || \
        mv -f $CLM_EXEDIR/clmini.infolist $CLM_EXEDIR/timeloop.stdin
/
EOF

# Executing clm'
$CLM_SRCDIR/clm.x < $CLM_EXEDIR/timeloop.stdin >& $CLM_EXEDIR/clm.log.timeloop


echo '-----------------------------------------------------------------'
echo ' End of nqs shell script                                         '
# qsub -l ncpus=1 -l cput=00:10:00 jobclm.csh
echo '-----------------------------------------------------------------'
