 module phycon_module
!=======================================================================
! physical constants
!=======================================================================
  use precision
  implicit none
  public
  real, parameter :: denice = 917.      ! density of ice [kg/m3]
  real, parameter :: denh2o = 1000.     ! density of liquid water [kg/m3]
  real, parameter :: cpliq  = 4188.     ! Specific heat of water [J/kg-K]
  real, parameter :: cpice  = 2117.27   ! Specific heat of ice [J/kg-K]
  real, parameter :: cpair  = 1004.64   ! specific heat of dry air [J/kg/K]
  real, parameter :: hfus   = 0.3336e6  ! latent heat of fusion for ice [J/kg]
  real, parameter :: hvap   = 2.5104e6  ! latent heat of evap for water [J/kg]
  real, parameter :: hsub   = 2.8440e6  ! latent heat of sublimation [J/kg]
  real, parameter :: tkair  = 0.023     ! thermal conductivity of air [W/m/k]
  real, parameter :: tkice  = 2.290     ! thermal conductivity of ice [W/m/k]
  real, parameter :: tkwat  = 0.6       ! thermal conductivity of water [W/m/k]
  real, parameter :: tfrz   = 273.16    ! freezing temperature [K]
  real, parameter :: rgas   = 287.04    ! gas constant for dry air [J/kg/K]
  real, parameter :: roverg = 4.71047e4 ! rw/g = (8.3144/0.018)/(9.80616)*1000. mm/K
  real, parameter :: rwat   = 461.296   ! gas constant for water vapor [J/(kg K)]
  real, parameter :: grav   = 9.80616   ! gravity constant [m/s2]
  real, parameter :: vonkar = 0.4       ! von Karman constant [-]
  real, parameter :: stefnc = 5.67e-8   ! Stefan-Boltzmann constant  [W/m2/K4]
 end module phycon_module
