 subroutine leafinterception (dtime,dewmx,chil, &
                              prc,prl,tm,scv,sigf,lai,sai,ldew,pg)
!=======================================================================
!
! calculation of  interception and drainage of precipitation
! the treatment are based on Sellers et al. (1996)
!
! modified by Yongjiu Dai, 08/31/2002
!----------------------------------------------------------------------
  use precision
  use phycon_module, only : tfrz
  implicit none
!-----------------------Arguments---------------------------------------
  real, INTENT(in) :: dtime   ! time step [second]
  real, INTENT(in) :: dewmx   ! maximum dew [mm]
  real, INTENT(in) :: chil    ! leaf angle distribution factor
  real, INTENT(in) :: prc     ! convective precipitation rate [mm/s]
  real, INTENT(in) :: prl     ! large-scale precipitation rate [mm/s]
  real, INTENT(in) :: tm      ! air temperature at reference height [K]
  real, INTENT(in) :: scv     ! snow mass (mm)
  real, INTENT(in) :: sigf    ! fraction of veg cover, excluding snow-covered veg [-]
  real, INTENT(in) :: lai     ! leaf area index [-]
  real, INTENT(in) :: sai     ! stem area index [-]
  real, INTENT(inout) :: ldew ! depth of water on foliage [mm]
  real, INTENT(out) :: pg     ! water onto ground including canopy runoff [kg/(m2 s)]
!-----------------------Local Variables---------------------------------
  real :: satcap   ! maximum allowed water on canopy [mm]
  real :: lsai     ! sum of leaf area index and stem area index [-]
  real :: chiv     ! leaf angle distribution factor
  real :: ppc      ! convective precipitation in time-step [mm]
  real :: ppl      ! large-scale precipitation in time-step [mm]
  real :: p0       ! precipitation in time-step [mm]
  real :: fpi      ! coefficient of interception
  real :: pinf     ! interception of precipitation in time step [mm]
  real :: tti      ! direct throughfall in time step [mm]
  real :: tex      ! canopy drainage in time step [mm]
  real :: vegt     ! sigf*lsai
  real :: xs       ! proportion of the grid area where the intercepted rainfall
! plus the preexisting canopy water storage
  real :: ap, cp, bp, aa, bb, exrain, arg, thru, xsc, w
  real pcoefs (2,2)
!-----------------------End Variable List-------------------------------
 if(sigf>=0.001)then
    pcoefs(1,1) = 20.
    pcoefs(1,2) = 0.206e-8
    pcoefs(2,1) = 0.0001 
    pcoefs(2,2) = 0.9999 
    bp = 20. 
    lsai = lai + sai
    vegt = sigf*lsai
    satcap = dewmx*vegt
    p0 = (prc + prl)*dtime
    ppc = prc*dtime
    ppl = prl*dtime
    w = ldew+p0
    if(scv>0. .or. tm<tfrz) ppc = 0.
    ppl = p0 - ppc
    xsc = max(0., ldew-satcap)
    ldew = ldew - xsc
    ap = pcoefs(2,1)
    cp = pcoefs(2,2)
    if(p0>1.e-8)then
       ap = ppc/p0 * pcoefs(1,1) + ppl/p0 * pcoefs(2,1)
       cp = ppc/p0 * pcoefs(1,2) + ppl/p0 * pcoefs(2,2)
!----------------------------------------------------------------------
!      proportional saturated area (xs) and leaf drainage(tex)
!-----------------------------------------------------------------------
       chiv = chil
       if ( abs(chiv) .le. 0.01 ) chiv = 0.01
       aa = 0.5 - 0.633 * chiv - 0.33 * chiv * chiv
       bb = 0.877 * ( 1. - 2. * aa )
       exrain = aa + bb
       fpi = ( 1.-exp(-exrain*lsai) ) * sigf
       tti = p0 * ( 1.-fpi )
       xs = 1.
       if(p0*fpi>1.e-9)then
          arg = (satcap-ldew)/(p0*fpi*ap) - cp/ap
          if(arg>1.e-9)then
             xs = -1./bp * log( arg )
             xs = min( xs, 1. )
             xs = max( xs, 0. )
          endif
       endif
       tex = p0 * fpi * ( ap/bp*(1.-exp(-bp*xs)) + cp*xs ) - ( satcap - ldew ) * xs
       tex = max( tex, 0. )
!       if(tex+tti > p0) then
!         write(6,*) tex, tti, p0,fpi,(ap/bp*(1.-exp(-bp*xs))+cp*xs), (satcap-ldew)*xs, xs, ldew
!         stop 'tex + tti > p0 in interception code : '
!       endif
    else
       tti = 0.
       tex = 0.
    endif
!----------------------------------------------------------------------
!   total throughfall (thru) and store augmentation
!----------------------------------------------------------------------
    thru = tti + tex
    pinf = p0 - thru
    ldew = ldew + pinf
    pg = (xsc + thru) / dtime
    w = w - ldew - pg*dtime
    if(abs(w)>1.e-6)then
    write(6,*) w, ldew, pg*dtime, satcap
!    stop 'something wrong in interception code : '
    endif
 else
    ldew=0.
    pg = prc + prl
 endif
 end subroutine leafinterception
