
 subroutine eroot (nl_soil,trsmx0,porsl,bsw,phi0,rootfr,&
                   dz,tss,wliq,rootr,etrc,rstfac)
	           
!=======================================================================
! effective root fraction and maximum possible transpiration rate
! Original author : Yongjiu Dai, 08/30/2002
!=======================================================================

  use precision
  use phycon_module, only : tfrz
  implicit none
    
!-----------------------Argument-----------------------------------------

  integer, INTENT(in) :: nl_soil            ! upper bound of array

  real, INTENT(in) :: trsmx0            ! max transpiration for moist soil+100% veg.[mm/s]
  real, INTENT(in) :: porsl(1:nl_soil)  ! soil porosity [-]
  real, INTENT(in) :: bsw(1:nl_soil)    ! Clapp-Hornberger "B"
  real, INTENT(in) :: phi0(1:nl_soil)   ! saturated soil suction (mm)
  real, INTENT(in) :: rootfr(1:nl_soil) ! fraction of roots in a layer, 
  real, INTENT(in) :: dz(1:nl_soil)     ! layer thickness (m)
  real, INTENT(in) :: tss(1:nl_soil)    ! soil/snow skin temperature (K)
  real, INTENT(in) :: wliq(1:nl_soil)   ! liquid water (kg/m2)

  real, INTENT(out) :: rootr(1:nl_soil) ! root resistance of a layer, all layers add to 1
  real, INTENT(out) :: etrc             ! maximum possible transpiration rate (mm h2o/s)
  real, INTENT(out) :: rstfac           ! factor of soil water stress for photosynthesis
                   
!-----------------------Local Variables------------------------------
                   
  real roota             ! accumulates root resistance factors
  real rresis(1:nl_soil) ! soil water contribution to root resistance
  real s_node            ! vol_liq/porosity
  real smpmax            ! wilting point potential in mm
  real smp_node          ! matrix potential

  integer i                  ! loop counter

!-----------------------End Variables list---------------------------

      ! transpiration potential(etrc) and root resistance factors (rstfac)

      roota = 1.e-10         ! must be non-zero to begin
      do i = 1, nl_soil

        if(tss(i)>tfrz .and. porsl(i)>=1.e-6)then
           smpmax = -1.5e5
       	   s_node = max(wliq(i)/(1000.*dz(i)*porsl(i)),0.001)
           s_node = min(1., s_node)
           smp_node = max(smpmax, -phi0(i)*s_node**(-bsw(i))) 
           rresis(i) =(1.-smp_node/smpmax)/(1.+phi0(i)/smpmax) 
           rootr(i) = rootfr(i)*rresis(i)
           roota = roota + rootr(i)
        else
           rootr(i) = 0.
        endif

      end do

      ! normalize root resistances to get layer contribution to ET
      rootr(:) = rootr(:)/roota
	
      ! determine maximum possible transpiration rate 
      etrc = trsmx0*roota
      rstfac = roota

 end subroutine eroot
