 subroutine GETMET (lumet,lon_points,lat_points,nforc,forcxy) 
! ======================================================================
!
! Access meteorological data
!
! Original author : Yongjiu Dai
! ======================================================================
   use precision
   implicit none
   integer, INTENT(in) :: lumet      ! logical unit number of atmospheric forcing data
   integer, INTENT(in) :: lon_points ! number of longitude points on model grid
   integer, INTENT(in) :: lat_points ! number of latitude points on model grid
   integer, INTENT(in) :: nforc      ! number of atmospheric forcing variables
   real, INTENT(out) :: forcxy(lon_points,lat_points,nforc)
! local
   real solar(lon_points,lat_points)                    ! incident solar radiation [W/m2]
   real frl(lon_points,lat_points)           ! atmospheric infrared (longwave) radiation [W/m2]
   real prcp(lon_points,lat_points)                     ! precipitation [mm/s]
   real tm(lon_points,lat_points)                 ! temperature at reference height [kelvin]
   real us(lon_points,lat_points)                  ! wind component in eastward direction [m/s]
   real vs(lon_points,lat_points)                 ! wind component in northward direction [m/s]
   real pres(lon_points,lat_points)                   ! atmospheric pressure [pa]
   real qm(lon_points,lat_points)              ! specific humidity at reference height [kg/kg]
   integer i, j                      ! looping index
! ------------------ note ------------------
! the model required the same longitudinal resolution for
! all latitude strip. For the variable longitudinal resolution
! cases, please assign the meteorological values to
! -999 to the land grids which are not included in the calcultion.
! ----------------------------------------------------------------------
![1] PILPS's Valdai (obs height: wind 10 m, tem & hum 2 m)
   do j = 1, lat_points
      do i = 1, lon_points 
        read (lumet,*) solar(i,j), frl(i,j), prcp(i,j), tm(i,j), &
                       us(i,j), vs(i,j), pres(i,j), qm(i,j)
      enddo
   enddo
!10 format (2f7.1, e14.3, 3f10.3, f10.1, e12.3)
!-----------------------------------------
   do j = 1, lat_points
      do i = 1, lon_points
         forcxy(i,j,1) = pres(i,j)*355.e-06   ! pco2m = CO2 concentration in surface atmos. (35 pa)
         forcxy(i,j,2) = pres(i,j)*0.209    ! po2m  = O2 concentration in surface atmos. (20900 pa)
         forcxy(i,j,3) = us(i,j)              ! us    = wind in eastward direction (m/s)
         forcxy(i,j,4) = vs(i,j)              ! vs    = wind in northward direction (m/s)
         forcxy(i,j,5) = tm(i,j)              ! tm    = temperature at reference height (kelvin)
         forcxy(i,j,6) = qm(i,j)            ! qm    = specific humidity at reference height (kg/kg)
         forcxy(i,j,7) = 0.              ! prc   = convective precipitation (mm/s)
         forcxy(i,j,8) = prcp(i,j)            ! prl   = large scale precipitation (mm/s)
         forcxy(i,j,9) = pres(i,j)            ! psrf  = atmospheric pressure at the surface (pa)
         forcxy(i,j,10) = pres(i,j)  ! pbot  = atm bottom level pressure (or reference height) (pa)
         forcxy(i,j,11) = solar(i,j)* 0./100.! sols  = atm vis direct beam solar rad(W/m2)
         forcxy(i,j,12) = solar(i,j)* 0./100. ! soll  = atm nir direct beam solar rad(W/m2)
         forcxy(i,j,13) = solar(i,j)*50./100. ! solsd = atm vis diffuse solar rad (W/m2)
         forcxy(i,j,14) = solar(i,j)*50./100. ! solld = atm nir diffuse solar rad  (W/m2)
         forcxy(i,j,15) = frl(i,j)       ! frl   = atmospheric infrared (longwave) radiation (W/m2)
         forcxy(i,j,16) = 50.            ! hu    = observational height of wind (m)
         forcxy(i,j,17) = 50.            ! ht    = observational height of temperature (m)
         forcxy(i,j,18) = 50.             ! hq    = observational height of humidity (m)
      enddo 
   enddo 
 end subroutine GETMET
