# -*- coding: utf-8 -*-
from netCDF4 import Dataset
import numpy as np
import sdii
# calculate sdii (annual period) based on daily precip from isimip2b
# leapyear included in data
fname=' ' #Enter here your work directory
rows=360
kols=720
years= range(1851,2006)
years1 = range(1851,1861,10)
years2 = range(1861,2001,10)
years3=range(2001,2006,5)

#calculate leap years
leapyears=[]
for i in years:
  if (i % 100 != 0 and i % 4 == 0):
    leapyears.append(i)
  elif (i % 100 == 0 and i % 4 == 0 and i % 400 == 0):
    leapyears.append(i)
leapyears=np.asarray(leapyears)

##############################
#PART1: calculate average SDII for period 1850-1860
#############################
Pd_tot= []
w_tot=[]
for y in years1:
  data = Dataset('%s/NEW/pr_day_IPSL-CM5A-LR_piControl_r1i1p1_EWEMBI_18510101-18601231.nc4' % (fname),'r')
  p = data.variables['pr'][:] #shape(3653,rows,kols) kg/m2/s
  # calculate daily totals
  Pd = p*3600.*24 # from mm/s to mm/day
  Pd[Pd<1.] = 0.
  t=3653
  Pd_in = Pd.reshape(t,rows*kols)    
  w_out=sdii.sdii.main(Pd_in,rows,kols,t) #shape(time,kols,rows)
  w = []
  for i in range(t):
    w.append(np.ravel(w_out[i],order='F'))
  w=np.asarray(w)
  w=w.reshape(t,rows,kols)

  i=0
  for j in range(10):
    if (y+j) in leapyears:
      Pd_tot.append(np.sum(Pd[i:i+366,:,:],axis=0))
      w_tot.append(np.sum(w[i:i+366,:,:],axis=0))
      i=i+366
    else:
      Pd_tot.append(np.sum(Pd[i:i+365,:,:],axis=0))
      w_tot.append(np.sum(w[i:i+365,:,:],axis=0))
      i=i+365
 
  Pd_tot=np.asarray(Pd_tot)
  w_tot=np.asarray(w_tot)
  w_tot[w_tot==0]=-9999
  sdii_out = Pd_tot/w_tot # yearly timestep
  sdii_out=sdii_out.reshape(10,rows,kols)
  
  #output SDII
  output = Dataset('%s/R_factor/ISIMIP2b_1851-1860_SDII.nc' % (fname),'w')
  output.create_dimension('lat',rows)
  output.create_dimension('lon',kols)
  output.create_dimension('time',10)
  output.create_variable('SDII','d',('time','lat','lon',))
  output.variables['SDII'][:]=sdii_out[:]
  output.close()
  #output yearly precipitation
  output = Dataset('%s/R_factor/ISIMIP2b_1851-1860_P.nc' % (fname),'w')
  output.create_dimension('lat',rows)
  output.create_dimension('lon',kols)
  output.create_dimension('time',10)
  output.create_variable('p','d',('time','lat','lon',))
  output.variables['p'][:]=Pd_tot[:]
  output.close()
data.close() 

##############################
#PART2 calculate average SDII for 1861-2001
#############################
for y in years2:
  Pd_tot= []
  w_tot=[]
  data = Dataset('%s/NEW/historical/pr_day_IPSL-CM5A-LR_historical_r1i1p1_EWEMBI_%04i0101-%04i1231.nc4' % (fname,y,y+9),'r')
  p = data.variables['pr'][:]
  data.close()
  # calculate daily totals
  Pd = p*3600.*24 # from mm/s to mm/day
  Pd[Pd<1.] = 0.
  t=len(np.ravel(Pd))/(rows*kols)
  Pd_in = Pd.reshape(t,rows*kols)    
  w_out=sdii.sdii.main(Pd_in,rows,kols,t) #shape(time,kols,rows)
  w = []
  for i in range(t):
    w.append(np.ravel(w_out[i],order='F'))
  w=np.asarray(w)
  w=w.reshape(t,rows,kols)

  i=0
  for j in range(10):
    if (y+j) in leapyears:
      Pd_tot.append(np.sum(Pd[i:i+366,:,:],axis=0))
      w_tot.append(np.sum(w[i:i+366,:,:],axis=0))
      i=i+366
    else:
      Pd_tot.append(np.sum(Pd[i:i+365,:,:],axis=0))
      w_tot.append(np.sum(w[i:i+365,:,:],axis=0))
      i=i+365
 
  Pd_tot=np.asarray(Pd_tot)
  w_tot=np.asarray(w_tot)
  w_tot[w_tot==0]=-9999
  sdii_out = Pd_tot/w_tot # yearly timestep
  sdii_out=sdii_out.reshape(10,rows,kols)
  
  #output SDII
  output = Dataset('%s/R_factor/ISIMIP2b_%04i-%04i_SDII.nc' % (fname,y,y+9),'w')
  output.create_dimension('lat',rows)
  output.create_dimension('lon',kols)
  output.create_dimension('time',10)
  output.create_variable('SDII','d',('time','lat','lon',))
  output.variables['SDII'][:]=sdii_out[:]
  output.close()
  #output yearly precipitation
  output = Dataset('%s/R_factor/ISIMIP2b_%04i-%04i_P.nc' % (fname,y,y+9),'w')
  output.create_dimension('lat',rows)
  output.create_dimension('lon',kols)
  output.create_dimension('time',10)
  output.create_variable('p','d',('time','lat','lon',))
  output.variables['p'][:]=Pd_tot[:]
  output.close()
   
##############################
#PART3 calculate average SDII for 2001-2006
#############################
for y in years3:
  Pd_tot= []
  w_tot=[]
  data = Dataset('%s/NEW/historical/pr_day_IPSL-CM5A-LR_historical_r1i1p1_EWEMBI_%04i0101-%04i1231.nc4' % (fname,y,y+4),'r')
  p = data.variables['pr'][:]
  data.close()
  # calculate daily totals
  Pd = p*3600.*24 # from mm/s to mm/day
  Pd[Pd<1.] = 0.
  t=len(np.ravel(Pd))/(rows*kols)
  Pd_in = Pd.reshape(t,rows*kols)    
  w_out=sdii.sdii.main(Pd_in,rows,kols,t) #shape(time,kols,rows)
  w = []
  for i in range(t):
    w.append(np.ravel(w_out[i],order='F'))
  w=np.asarray(w)
  w=w.reshape(t,rows,kols)

  i=0
  for j in range(5):
    if (y+j) in leapyears:
      Pd_tot.append(np.sum(Pd[i:i+366,:,:],axis=0))
      w_tot.append(np.sum(w[i:i+366,:,:],axis=0))
      i=i+366
    else:
      Pd_tot.append(np.sum(Pd[i:i+365,:,:],axis=0))
      w_tot.append(np.sum(w[i:i+365,:,:],axis=0))
      i=i+365
 
  Pd_tot=np.asarray(Pd_tot)
  w_tot=np.asarray(w_tot)
  w_tot[w_tot==0]=-9999
  sdii_out = Pd_tot/w_tot # yearly timestep
  sdii_out=sdii_out.reshape(5,rows,kols)
  
  #output SDII
  output = Dataset('%s/R_factor/ISIMIP2b_%04i-%04i_SDII.nc' % (fname,y,y+4),'w')
  output.create_dimension('lat',rows)
  output.create_dimension('lon',kols)
  output.create_dimension('time',5)
  output.create_variable('SDII','d',('time','lat','lon',))
  output.variables['SDII'][:]=sdii_out[:]
  output.close()

  #output yearly precipitation
  output = nio.open_file('%s/R_factor/ISIMIP2b_%04i-%04i_P.nc' % (fname,y,y+4),'w')
  output.create_dimension('lat',rows)
  output.create_dimension('lon',kols)
  output.create_dimension('time',5)
  output.create_variable('p','d',('time','lat','lon',))
  output.variables['p'][:]=Pd_tot[:]
  output.close()
