#!/bin/ksh
#data processing needed to calculate RUSLE factors R and C

work_dir=... #Enter here your work directory
gridfile1=.. #Enter here the path to the txt file specifying the gridtype at 0.5 resolution
gridfile2=.. #Enter here the path to the txt file specifying the gridtype at 5arcminute resolution
input_dir2=...#Enter here the path to the LAI data of ORCHIDEE
landvars="treeFrac grassFrac cropFrac baresoilFrac"

############################
# Process SDII and Precipitation (P) and erosivity (R) files
############################
#split per year and rename, SDII and P files
a=1851 
for f in $work_dir/climate/R_factor/*;do
    if (( $a < 2001 ));then
	file_P=$(printf "$work_dir/climate/R_factor/ISIMIP2b_%04d-%04d_P.nc" "$a" "$a+9")
	file_SDII=$(printf "$work_dir/climate/R_factor/ISIMIP2b_%04d-%04d_SDII.nc" "$a" "$a+9")
	for y in {1..10};do
            file_P2=$(printf "$work_dir/climate/R_factor/ISIMIP2b_%04d_P.nc" "$a+y-1")
	    file_SDII2=$(printf "$work_dir/climate/R_factor/ISIMIP2b_%04d_SDII.nc" "$a+y-1")
            cdo seltimestep,${y} ${file_P} ${file_P2}
	    cdo seltimestep,${y} ${file_SDII} ${file_SDII2}
	done
	let a=a+10
    else
    	file_P=$(printf "$work_dir/climate/R_factor/ISIMIP2b_%04d-%04d_P.nc" "$a" "$a+4")
    	file_SDII=$(printf "$work_dir/climate/R_factor/ISIMIP2b_%04d-%04d_SDII.nc" "$a" "$a+4")
    	for y in {1..5};do
            file_P2=$(printf "$work_dir/climate/R_factor/ISIMIP2b_%04d_P.nc" "$a+y-1")
    	    file_SDII2=$(printf "$work_dir/climate/R_factor/ISIMIP2b_%04d_SDII.nc" "$a+y-1")
            cdo seltimestep,${y} ${file_P} ${file_P2}
   	    cdo seltimestep,${y} ${file_SDII} ${file_SDII2}
    	done
    	let a=a+4
    fi
done

#setgrid, remap P to 5 arcmin
a=1851
for f in $work_dir/climate/R_factor/P/*;do
    file_P=$(printf "$work_dir/climate/R_factor/P/ISIMIP2b_%04d_P.nc" "$a")    
    cdo setgrid,$gridfile1 ${file_P} ${file_P%%.*}_grid.nc
    cdo remapbil,$gridfile2 ${file_P%%.*}_grid.nc ${file_P%%.*}_5m.nc
    let a=a+1
done

#setgrid, remap SDII to 5 arcmin
a=1851
for f in $work_dir/climate/R_factor/SDII/*;do
    file_SDII=$(printf "$work_dir/climate/R_factor/SDII/ISIMIP2b_%04d_SDII.nc" "$a")
    cdo setgrid,$gridfile1 ${file_SDII} ${file_SDII%%.*}_grid.nc
    cdo remapbil,$gridfile2 ${file_SDII%%.*}_grid.nc ${file_SDII%%.*}_5m.nc   
    let a=a+1
done

############################
# Process LAI from ORCHIDEE
############################
# extract LAI per landcover type
a=1901
for f in $work_dir/landcover/*;do
  new=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_LAI.nc" "$a")
  for lc in $landvars;do
     if [[ ${lc} == treeFrac ]]; then
         new_out=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_LAI_${lc}.nc" "$a")
         cdo -vertmean -sellevel,2/9 ${new} ${new_out} 
     elif [[ ${lc} == grassFrac ]]; then
         new_out=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_LAI_${lc}.nc" "$a")
         cdo -vertmean -sellevel,10/11 ${new} ${new_out}
     elif [[ ${lc} == cropFrac ]]; then
         new_out=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_LAI_${lc}.nc" "$a")
         cdo -vertmean -sellevel,12/13 ${new} ${new_out}
     else
        new_out=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_LAI_${lc}.nc" "$a")
        cdo -sellevel,1 ${new} ${new_out} 
      fi
  done
  let a=a+1
done

# calculate average LAI per gridcell
a=1901
for f in $input_dir2/*;do
  new1=$(printf "$input_dir2/stomate.%04d.lmdz.nc" "$a")
  new2=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_LAI.nc" "$a")
  new_out=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_LAI_mean.nc" "$a")
  cdo -vertsum -mul -selname,VEGET_MAX ${new1} ${new2} ${new_out}
  let a=a+1
done

# calculate yearly mean LAI
a=1901
for f in $work_dir/landcover/*;do
  new1=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_LAI_mean.nc" "$a")
  new_out1=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_LAI_yrmean.nc" "$a")
  cdo timmean ${new1} ${new_out1} 
  for lc in $landvars;do
     new2=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_${lc}.nc" "$a")
     new_out2=$(printf "$work_dir/landcover/stomate_LMDZ_%04d_${lc}_yrmean.nc" "$a")
     cdo timmean ${new2} ${new_out2}
  done
  let a=a+1
done

