# -*- coding: utf-8 -*-
import numpy as np
from netCDF4 import Dataset
import os.path
import C_factor
########################################################
#This script calculates the C factor based on land cover types from Peng et al. (2017) and leaf area index (LAI) from ORCHIDEE LSM
########################################################
#settings
fname_lai=' ' #Enter here the path to the LAI
fname_lc=' ' #Enter hete the path tot the PFT fractions
rows=720
kols=1440
years3=range(1851,2006)
years2=range(1861,2006)
years1=range(1851,1861)
landcover=("tree","crop","gras","bare",)
simulation="CC+LUC" #select simulation type from: equilibrium,CC+LUC,CC,LUC

data = Dataset('%s/PFTmap_LUHv2_BM3_HoughtonCountryForestarea_withoutNoBio_1851.nc' % (fname_lc) ,'r')
frac0=data.variables['maxvegetfrac'][0] 
frac0=frac0.reshape(13,rows,kols)
data.close()

if simulation =='equilibrium':
  #########################################################
  # Equilibrium: land coverfractions set to 1851, while LAI averaged over period 1861-1870
  ########################################################
  data2 = Dataset('%s/processed_yearly/orchidee_ipsl-cm5a-lr_historical_histsoc_co2_lai_allPFTs_global_annual_1861_1870_mean_025deg.nc4' \
                  % (fname_lai2),'r') #LAI average over gridcell
  lai = data2.variables['lai'][:]
  lai[lai>100.]=np.nan
  lai[lai==0.]=np.nan
  lai=lai.reshape(15,rows,kols)  
  C_lc=[]
  for lc in landcover:
    if lc=="tree":
      #treefrac
      frac = frac0[1:9,:,:]
      lai_lcfrac=np.nanmean(lai[1:9,:,:],axis=0)
    elif lc=="gras":
      #grassFrac 
      frac = frac0[9:11,:,:]
      lai_lcfrac=np.nanmean(lai[9:11,:,:],axis=0)
    elif lc=="crop":
      #cropFrac
      frac = frac0[11:13,:,:]
      lai_lcfrac=np.nanmean(lai[11:15,:,:],axis=0)
    else:
      #baresoilFrac
      frac = frac0[0,:,:]
      lai_lcfrac=lai[0]

    lai_lcfrac=np.ravel(lai_lcfrac)
    frac[frac<0]=0
    frac[frac>1]=0
    lai=lai.reshape(15,rows*kols)
    if lc=="bare":
      lcfrac=np.ravel(frac)
    else:
      lcfrac=np.sum(frac,axis=0)
      lcfrac=np.ravel(lcfrac)
      for i in range(len(lcfrac)):
        if (lcfrac[i]>0.) and (np.isnan(lai_lcfrac[i])==True):
          lai_lcfrac[i]=np.nanmean(lai[:,i],axis=0) #if lai of lc is nan but frac lc >0 then take average lai of gridcell (all pfts)
        else:
          lai_lcfrac[i]=lai_lcfrac[i]
    lai=lai.reshape(15,rows,kols)
    # Beers law, you cannot use LAI directly for cover fraction (% of ground is covered by a certain vegetation type)=> LAI=1 => cf = 0.39
    cf=1-(np.exp(-lai_lcfrac/2.))
    cf[np.isnan(cf)==True]=-9999.
    
    #C_factor calculation
    C=C_factor.cfactor.main(cf,lcfrac,lc,rows,kols) 
    C=C.reshape(rows,kols)
    C_lc.append(C)
  C_lc=np.asarray(C_lc)
  C_lc[C_lc < 0.]=np.nan
  C_avg=np.nansum(C_lc,axis=0)

  #output
  fname_out='/home/orchidee04/vnaipal/C_factor/lowres/new_method/new/'
  output = Dataset('%s/C_eq_025deg.nc' % (fname_out),'w')
  output.createDimension('lat',rows)
  output.createDimension('lon',kols)
  output.createDimension('veget',4)
  output.createVariable('c_lc','d',('veget','lat','lon',))
  output.variables['c_lc'][:] = C_lc
  output.createVariable('c_avg','d',('lat','lon',))
  output.variables['c_avg'][:] = C_avg
  output.close()
  data2.close()

if simulation =='CC+LUC':
  #########################################################
  # CC+LUC: LAI & landcover fractions are changing
  ########################################################
  data2 = Dataset('%s/processed_yearly/orchidee_ipsl-cm5a-lr_historical_histsoc_co2_lai_allPFTs_global_annual_1861_1870_mean_025deg.nc4' % (fname_lai2),'r') #average over gridcell
  lai = data2.variables['lai'][:]
  lai[lai>100.]=np.nan
  lai[lai==0.]=np.nan
  lai=lai.reshape(15,rows,kols)  
  for t in range(len(years1)):
    data = Dataset('%s/PFTmap_LUHv2_BM3_HoughtonCountryForestarea_withoutNoBio_%04i.nc' % (fname_lc,years1[t]) ,'r') 
    frac0=data.variables['maxvegetfrac'][0]  #(time,pft,lat,lon)
    frac0=frac0.reshape(13,rows,kols)
    C_lc=[]
    for lc in landcover:
      if lc=="tree":
        #treefrac
        frac = frac0[1:9,:,:]
        lai_lcfrac=np.nanmean(lai[1:9,:,:],axis=0)
      elif lc=="gras":
        #grassFrac 
        frac = frac0[9:11,:,:]
        lai_lcfrac=np.nanmean(lai[9:11,:,:],axis=0)
      elif lc=="crop":
        #cropFrac
        frac = frac0[11:13,:,:]
        lai_lcfrac=np.nanmean(lai[11:15,:,:],axis=0)
      else:
        #baresoilFrac
        frac = frac0[0,:,:]
        lai_lcfrac=lai[0]

      lai_lcfrac=np.ravel(lai_lcfrac)
      frac[frac<0]=0
      frac[frac>1]=0
      lai=lai.reshape(15,rows*kols)
      if lc=="bare":
        lcfrac=np.ravel(frac)
      else:
        lcfrac=np.sum(frac,axis=0)
        lcfrac=np.ravel(lcfrac)
        for i in range(len(lcfrac)):
          if (lcfrac[i]>0.) and (np.isnan(lai_lcfrac[i])==True):
            lai_lcfrac[i]=np.nanmean(lai[:,i],axis=0) #if lai of lc is nan but frac lc >0 then take average lai of gridcell (all pfts)
          else:
            lai_lcfrac[i]=lai_lcfrac[i]
      lai=lai.reshape(15,rows,kols)
      # Beers law, you cannot use LAI directly for cover fraction (% of ground is covered by a certain vegetation type)=> LAI=1 => cf = 0.39
      cf=1-(np.exp(-lai_lcfrac/2.))
      cf[np.isnan(cf)==True]=-9999.
      
      #C_factor calculation
      C=C_factor.cfactor.main(cf,lcfrac,lc,rows,kols) 
      C=C.reshape(rows,kols)
      C_lc.append(C)
    C_lc=np.asarray(C_lc)
    C_lc[C_lc < 0.]=np.nan
    C_avg=np.nansum(C_lc,axis=0)
   
    #output
    fname_out=' ' #specify output directory
    output = Dataset('%s/C_%04i_025deg.nc' % (fname_out,years1[t]),'w')
    output.createDimension('lat',rows)
    output.createDimension('lon',kols)
    output.createDimension('veget',4)
    output.createVariable('c_lc','d',('veget','lat','lon',))
    output.variables['c_lc'][:] = C_lc
    output.createVariable('c_avg','d',('lat','lon',))
    output.variables['c_avg'][:] = C_avg
    output.close()
  data2.close()

  for t in range(len(years2)):
   data2 = Dataset('%s/processed_yearly/orchidee_ipsl-cm5a-lr_historical_histsoc_co2_lai_allPFTs_global_%04i_025deg.nc4' \
                   % (fname_lai2,years2[t]),'r') #LAI average over gridcell
   lai = data2.variables['lai'][:]
   lai[lai>100.]=np.nan
   lai[lai==0.]=np.nan
   lai=lai.reshape(15,rows,kols)
   data = Dataset('%s/PFTmap_LUHv2_BM3_HoughtonCountryForestarea_withoutNoBio_%04i.nc' % (fname_lc,years2[t]) ,'r')
   frac0=data.variables['maxvegetfrac'][0]  #(time,pft,lat,lon)
   frac0=frac0.reshape(13,rows,kols)
   C_lc=[]
   for lc in landcover:
     if lc=="tree":
       #treefrac
       frac = frac0[1:9,:,:]
       lai_lcfrac=np.nanmean(lai[1:9,:,:],axis=0)
     elif lc=="gras":
       #grassFrac 
       frac = frac0[9:11,:,:]
       lai_lcfrac=np.nanmean(lai[9:11,:,:],axis=0)
     elif lc=="crop":
       #cropFrac
       frac = frac0[11:13,:,:]
       lai_lcfrac=np.nanmean(lai[11:15,:,:],axis=0)
     else:
       #baresoilFrac
       frac = frac0[0,:,:]
       lai_lcfrac=lai[0]

     lai_lcfrac=np.ravel(lai_lcfrac)
     frac[frac<0]=0
     frac[frac>1]=0
     lai=lai.reshape(15,rows*kols)
     if lc=="bare":
       lcfrac=np.ravel(frac)
     else:
       lcfrac=np.sum(frac,axis=0)
       lcfrac=np.ravel(lcfrac)
       for i in range(len(lcfrac)):
         if (lcfrac[i]>0.) and (np.isnan(lai_lcfrac[i])==True):
           lai_lcfrac[i]=np.nanmean(lai[:,i],axis=0) #if lai of lc is nan but frac lc >0 then take average lai of gridcell (all pfts)
         else:
           lai_lcfrac[i]=lai_lcfrac[i]
     lai=lai.reshape(15,rows,kols)
     # Beers law, you cannot use LAI directly for cover fraction (% of ground is covered by a certain vegetation type)=> LAI=1 => cf = 0.39
     cf=1-(np.exp(-lai_lcfrac/2.))
     cf[np.isnan(cf)==True]=-9999.
     
     #C_factor calculation
     C=C_factor_new.cfactor.main(cf,lcfrac,lc,rows,kols) 
     C=C.reshape(rows,kols)
     C_lc.append(C)
   C_lc=np.asarray(C_lc)
   C_lc[C_lc < 0.]=np.nan
   C_avg=np.nansum(C_lc,axis=0)
   
   #output
   fname_out=' ' #specify output directory
   output = Dataset('%s/C_%04i_025deg.nc' % (fname_out,years2[t]),'w')
   output.createDimension('lat',rows)
   output.createDimension('lon',kols)
   output.createDimension('veget',4)
   output.createVariable('c_lc','d',('veget','lat','lon',))
   output.variables['c_lc'][:] = C_lc
   output.createVariable('c_avg','d',('lat','lon',))
   output.variables['c_avg'][:] = C_avg
   output.close()
   data2.close()

if simulation =='CC':
  #########################################################
  # CC: LAI only is changing; land cover fractions set to year 1851
  ########################################################
  data = Dataset('%s/PFTmap_LUHv2_BM3_HoughtonCountryForestarea_withoutNoBio_1851.nc' % (fname_lc) ,'r')
  frac0=data.variables['maxvegetfrac'][0]  #(time,pft,lat,lon)
  frac0=frac0.reshape(13,rows,kols)
  data.close()
  data2 = Dataset('%s/processed_yearly/orchidee_ipsl-cm5a-lr_historical_histsoc_co2_lai_allPFTs_global_annual_1861_1870_mean_025deg.nc4' \
                  % (fname_lai2),'r') #average LAI over gridcell
  lai = data2.variables['lai'][:]
  lai[lai>100.]=np.nan
  lai[lai==0.]=np.nan
  lai=lai.reshape(15,rows,kols)  
  for t in range(len(years1)):
    C_lc=[]
    for lc in landcover:
      if lc=="tree":
        #treefrac
        frac = frac0[1:9,:,:]
        lai_lcfrac=np.nanmean(lai[1:9,:,:],axis=0)
      elif lc=="gras":
        #grassFrac 
        frac = frac0[9:11,:,:]
        lai_lcfrac=np.nanmean(lai[9:11,:,:],axis=0)
      elif lc=="crop":
        #cropFrac
        frac = frac0[11:13,:,:] 
        lai_lcfrac=np.nanmean(lai[11:15,:,:],axis=0)
      else:
        #baresoilFrac
        frac = frac0[0,:,:]
        lai_lcfrac=lai[0]

      lai_lcfrac=np.ravel(lai_lcfrac)
      frac[frac<0]=0
      frac[frac>1]=0
      lai=lai.reshape(15,rows*kols)
      if lc=="bare":
        lcfrac=np.ravel(frac)
      else:
        lcfrac=np.sum(frac,axis=0)
        lcfrac=np.ravel(lcfrac)
        for i in range(len(lcfrac)):
          if (lcfrac[i]>0.) and (np.isnan(lai_lcfrac[i])==True):
            lai_lcfrac[i]=np.nanmean(lai[:,i],axis=0) #if lai of lc is nan but frac lc >0 then take average lai of gridcell (all pfts)
          else:
            lai_lcfrac[i]=lai_lcfrac[i]
      lai=lai.reshape(15,rows,kols)
      # Beers law, you cannot use LAI directly for cover fraction (% of ground is covered by a certain vegetation type)=> LAI=1 => cf = 0.39
      cf=1-(np.exp(-lai_lcfrac/2.))
      cf[np.isnan(cf)==True]=-9999.
      
      #C_factor calculation
      C=C_factor.cfactor.main(cf,lcfrac,lc,rows,kols) 
      C=C.reshape(rows,kols)
      C_lc.append(C)
    C_lc=np.asarray(C_lc)
    C_lc[C_lc < 0.]=np.nan
    C_avg=np.nansum(C_lc,axis=0)
   
    #output
    fname_out=' ' #specify output directory
    output = Dataset('%s/C_%04i_025deg.nc' % (fname_out,years1[t]),'w')
    output.createDimension('lat',rows)
    output.createDimension('lon',kols)
    output.createDimension('veget',4)
    output.createVariable('c_lc','d',('veget','lat','lon',))
    output.variables['c_lc'][:] = C_lc
    output.createVariable('c_avg','d',('lat','lon',))
    output.variables['c_avg'][:] = C_avg
    output.close()
  data2.close()

  for t in range(len(years2)):
   data2 = Dataset('%s/processed_yearly/orchidee_ipsl-cm5a-lr_historical_histsoc_co2_lai_allPFTs_global_%04i_025deg.nc4' \
                   % (fname_lai2,years2[t]),'r') #average LAI over gridcell
   lai = data2.variables['lai'][:]
   lai[lai>100.]=np.nan
   lai[lai==0.]=np.nan
   lai=lai.reshape(15,rows,kols)
   C_lc=[]
   for lc in landcover:
     if lc=="tree":
       #treefrac
       frac = frac0[1:9,:,:]
       lai_lcfrac=np.nanmean(lai[1:9,:,:],axis=0)
     elif lc=="gras":
       #grassFrac 
       frac = frac0[9:11,:,:]
       lai_lcfrac=np.nanmean(lai[9:11,:,:],axis=0)
     elif lc=="crop":
       #cropFrac
       frac = frac0[11:13,:,:]
       lai_lcfrac=np.nanmean(lai[11:15,:,:],axis=0)
     else:
       #baresoilFrac
       frac = frac0[0,:,:]
       lai_lcfrac=lai[0]

     lai_lcfrac=np.ravel(lai_lcfrac)
     frac[frac<0]=0
     frac[frac>1]=0
     lai=lai.reshape(15,rows*kols)
     if lc=="bare":
       lcfrac=np.ravel(frac)
     else:
       lcfrac=np.sum(frac,axis=0)
       lcfrac=np.ravel(lcfrac)
       for i in range(len(lcfrac)):
         if (lcfrac[i]>0.) and (np.isnan(lai_lcfrac[i])==True):
           lai_lcfrac[i]=np.nanmean(lai[:,i],axis=0) #if lai of lc is nan but frac lc >0 then take average lai of gridcell (all pfts)
         else:
           lai_lcfrac[i]=lai_lcfrac[i]
     lai=lai.reshape(15,rows,kols)
     # Beers law, you cannot use LAI directly for cover fraction (% of ground is covered by a certain vegetation type)=> LAI=1 => cf = 0.39
     cf=1-(np.exp(-lai_lcfrac/2.))
     cf[np.isnan(cf)==True]=-9999.
     
     #C_factor calculation
     C=C_factor.cfactor.main(cf,lcfrac,lc,rows,kols) 
     C=C.reshape(rows,kols)
     C_lc.append(C)
   C_lc=np.asarray(C_lc)
   C_lc[C_lc < 0.]=np.nan
   C_avg=np.nansum(C_lc,axis=0)
   
   #output
   fname_out=' ' #specify output directory
   output = Dataset('%s/C_%04i_025deg.nc' % (fname_out,years2[t]),'w')
   output.createDimension('lat',rows)
   output.createDimension('lon',kols)
   output.createDimension('veget',4)
   output.createVariable('c_lc','d',('veget','lat','lon',))
   output.variables['c_lc'][:] = C_lc
   output.createVariable('c_avg','d',('lat','lon',))
   output.variables['c_avg'][:] = C_avg
   output.close()
   data2.close()

if simulation =='LUC':
  #########################################################
  # LUC: land coverfractions only are changing; LAI is averaged over equilibrium period
  ########################################################
  data2 = Dataset('%s/processed_yearly/orchidee_ipsl-cm5a-lr_historical_histsoc_co2_lai_allPFTs_global_annual_1861_1870_mean_025deg.nc4' \
                  % (fname_lai2),'r') #average LAI over gridcell
  lai = data2.variables['lai'][:]
  lai[lai>100.]=np.nan
  lai[lai==0.]=np.nan
  lai=lai.reshape(15,rows,kols)  
  for t in range(len(years3)):
    data = Dataset('%s/PFTmap_LUHv2_BM3_HoughtonCountryForestarea_withoutNoBio_%04i.nc' % (fname_lc,years3[t]) ,'r')
    frac0=data.variables['maxvegetfrac'][0]  #(time,pft,lat,lon)
    frac0=frac0.reshape(13,rows,kols)
    C_lc=[]
    for lc in landcover:
      if lc=="tree":
        #treefrac
        frac = frac0[1:9,:,:]
        lai_lcfrac=np.nanmean(lai[1:9,:,:],axis=0)
      elif lc=="gras":
        #grassFrac 
        frac = frac0[9:11,:,:]
        lai_lcfrac=np.nanmean(lai[9:11,:,:],axis=0)
      elif lc=="crop":
        #cropFrac
        frac = frac0[11:13,:,:] 
        lai_lcfrac=np.nanmean(lai[11:15,:,:],axis=0)
      else:
        #baresoilFrac
        frac = frac0[0,:,:]
        lai_lcfrac=lai[0]

      lai_lcfrac=np.ravel(lai_lcfrac)
      frac[frac<0]=0
      frac[frac>1]=0
      lai=lai.reshape(15,rows*kols)
      if lc=="bare":
        lcfrac=np.ravel(frac)
      else:
        lcfrac=np.sum(frac,axis=0)
        lcfrac=np.ravel(lcfrac)
        for i in range(len(lcfrac)):
          if (lcfrac[i]>0.) and (np.isnan(lai_lcfrac[i])==True):
            lai_lcfrac[i]=np.nanmean(lai[:,i],axis=0) #if lai of lc is nan but frac lc >0 then take average lai of gridcell (all pfts)
          else:
            lai_lcfrac[i]=lai_lcfrac[i]
      lai=lai.reshape(15,rows,kols)
      # Beers law, you cannot use LAI directly for cover fraction (% of ground is covered by a certain vegetation type)=> LAI=1 => cf = 0.39
      cf=1-(np.exp(-lai_lcfrac/2.))
      cf[np.isnan(cf)==True]=-9999.
      
      #C_factor calculation
      C=C_factor.cfactor.main(cf,lcfrac,lc,rows,kols) 
      C=C.reshape(rows,kols)
      C_lc.append(C)
    C_lc=np.asarray(C_lc)
    C_lc[C_lc < 0.]=np.nan
    C_avg=np.nansum(C_lc,axis=0)
   
    #output
    fname_out=' ' #specify output directory
    output = dataset('%s/C_%04i_025deg.nc' % (fname_out,years3[t]),'w')
    output.create_dimension('lat',rows)
    output.create_dimension('lon',kols)
    output.create_dimension('veget',4)
    output.create_variable('c_lc','d',('veget','lat','lon',))
    output.variables['c_lc'][:] = C_lc
    output.create_variable('c_avg','d',('lat','lon',))
    output.variables['c_avg'][:] = C_avg
    output.close()
  data2.close()


