#!/usr/bin/env python
import sys
#sys.path.insert(0,' ') #Enter path to modules if neccessary 
import numpy as np
import os
import inspect
from PythonTools import *
import csv
from rootprofile import r_pft
from netCDF4 import Dataset
#######################################################################
# This script calculates the equilibrium biomass and litter for whole Rhine
# Calculate layer dependent litter input to soil and related k's
# the output from this script is input for func2 --> soil
#######################################################################
def eq(OptPath,):
  ######################################################################
  #settings
  ######################################################################
  fname=' ' #Enter here your workdir
  OrcPath=' ' #Enter here the path to the turnover files of ORCHIDEE
  OrcPath2='%s/' % (fname) #Enter here the path to vegetation fractions at the coarse resolution of ORCHIDEE
  logfile=open('%s/BL_eq_logfile.txt' %(OptPath),'w',1) # output logfile
  maskfile_c='%s/Rhine_mask_LMDZ.nc' % (fname) #Enter here the path to the mask file of ORCHIDEE
  maskfile_h='%s/Rhine_mask_5m_new.nc' % (fname) #Enter here the path to the 5 arcmin mask file
  #soil layer parameters
  dz0=0.1
  zmax0=2
  soil_layers=np.arange(zmax0/dz0) #20 soil layers of each 0.1m thickness
  soil_layers=soil_layers.astype(int)
  dz_all=np.empty(len(soil_layers))
  dz_all.fill(dz0)
  zmin=np.arange(0.,zmax0,dz0) 
  zmax=np.arange(0.+dz0,zmax0+dz0,dz0)
  Lab_top=0.1
  # fraction of plants turned to metabolic/structural litter
  LC=np.array([0.22,0.35,0.35,0.35,0.35,0.22,0.22,0.22])
  litfrac_m=0.85-0.018*LC*40.  # metabolic_ref_frac - metabolic_LN_ratio * LC(k) * CN(k)
  litfrac_s=1.-litfrac_m
  # fraction of woody parts turned to products when LUC happens (1 bare land + 8 forest PFTs); bare land have no carbon, 0 for convenience
  LUCfrac001=np.array([0.,0.897,0.897,0.597,0.597,0.597,0.597,0.597,0.597]).reshape(9,1,1)
  LUCfrac010=np.array([0.,0.103,0.103,0.299,0.299,0.299,0.299,0.299,0.299]).reshape(9,1,1)
  LUCfrac100=1.-LUCfrac001-LUCfrac010
   x=np.array([1.]*15)
  xNPP=x[0]
  xmort=x[1:-4]
  xl,xa,xs,xp=x[-4:]  
  ######################################################################
  # read domain & high-resoluition (5arcmin) & coarse-resolution indices
  ######################################################################
  data_c=Dataset(maskfile_c,'r')
  lat_c=data_c.variables['lat'][:] 
  lon_c=data_c.variables['lon'][:] 
  data_c.close()
  
  data_h=Dataset(maskfile_h,'r')
  lat_h=data_h.variables['lat'][:]
  lon_h=data_h.variables['lon'][:]
  data_h.close()
  
  nc=Dataset('%s/K_ORCHIDEE.1851_1860_mean.TRENDY.newVCmax.Rhine.nc' %(OrcPath),'r')
  lats=nc.variables['latitude'][:]
  lons=nc.variables['longitude'][:]
  rows_c=[]
  for i in range(len(lats)):
    if lats[i]>=lat_c[-1] and lats[i]<=lat_c[0]:
      rows_c.append(i)
  kols_c=[]
  for j in range(len(lons)):
    if lons[j]+1.875>=lon_c[0] and lons[j]+1.875<=lon_c[-1]:
      kols_c.append(j)
  rows_c=np.asarray(rows_c)
  kols_c=np.asarray(kols_c)

  ######################################################################
  # define relating coarse-resolution gridcells to high-resolution gridcells
  ######################################################################
  row_sel=[]
  for i in range(len(lat_h)):
    dlat_min=1000.
    row_min=0
    for j in range(len(lat_c)):
      dlat=abs(lat_h[i]-lat_c[j])
      if dlat<dlat_min:
        dlat_min=1*dlat
        row_min=j      
    row_sel.append(row_min)
  kol_sel=[]
  for i in range(len(lon_h)):
    dlon_min=1000.
    kol_min=0
    for j in range(len(lon_c)):
      dlon=abs(lon_h[i]-lon_c[j])
      if dlon<dlon_min:
        dlon_min=1*dlon
        kol_min=j      
    kol_sel.append(kol_min)
  row_sel=np.asarray(row_sel) 
  kol_sel=np.asarray(kol_sel)

  ######################################################################
  #Read the harvest index and NPP modifier index for C3 crops (PFT=11)
  ######################################################################
  DataOut=[]
  hvfile='%snew_harvest_index_1851-2005.csv' % (fname)
  with open(hvfile) as data:
    next(data)
    reader=csv.reader(data,delimiter=',')
    for row in reader:
      DataOut.append(row)
  DataOut=np.asarray(DataOut)
  harv_new_id=[float(x) for x in DataOut[:,1]]
  harv_new_id=np.asarray(harv_new_id)
  DataOut=[]
  yield_file='%s/observed_yield.txt' % (fname)
  with open(yield_file) as data:
    next(data)
    reader=csv.reader(data,delimiter=',')
    for row in reader:
      DataOut.append(row)
  DataOut=np.asarray(DataOut)
  obs_yield=[float(x) for x in DataOut[:,0]]
  obs_yield=np.asarray(obs_yield)*100. #t/ha to g/m2/y

  ######################################################################
  #Other neccessary input data 
  ######################################################################
  Rnc=Dataset('%s/re_1851_1860_mean.Rhine.nc' %(fname),'r') #re (SOC profile modifier)
  re=Rnc.variables['re'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  Rnc.close() 
  Anc=opennc('%s/stomate.1851_1901.lmdz_monthly.TRENDY.newVCmax.Rhine.nc' %(OrcPath),'r') #coarse -resolution area
  area=Anc.variables['Areas'][rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] #m2
  contfrac=Anc.variables['CONTFRAC'][rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  AREA=area*contfrac
  AREA=np.where(abs(AREA)>1.e36,0.,AREA)
  land=contfrac<=1.
  sea=True-land
  Anc.close()
  vegetnc=opennc('%s/VEGET_TRENDY_withoutNoBio.Rhine.nc' %(OrcPath2),'r') #coarse-resolution vegetation fractions
  veget=vegetnc.variables['VEGET_MAX'][0,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  vegetnc.close()

  ######################################################################
  #Read ORCHIDEE files and calculate equilibrium pools
  ######################################################################
  # equilibrium initial condiction using 1851-1860 results
  kc=Dataset('%s/calibrated_params/K0_RESP_1851_1860_mean.Rhine.nc' %(OrcPath),'r')
  kresp_soila0=kc.variables['krespa0'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]*365.
  kresp_soils0=kc.variables['kresps0'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]*365.
  kresp_soilp0=kc.variables['krespp0'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]*365.
  kresp_soila0[kresp_soila0<1E-10]=0.
  kresp_soils0[kresp_soils0<1E-10]=0.
  kresp_soilp0[kresp_soilp0<1E-10]=0.  
  NPP_leaf  =nc.variables['NPP_leaf'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  NPP_sapab =nc.variables['NPP_sapab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  NPP_sapbe =nc.variables['NPP_sapbe' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  NPP_root  =nc.variables['NPP_root'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  NPP_fruit =nc.variables['NPP_fruit' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  NPP_reserv=nc.variables['NPP_reserv'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmb_res=nc.variables['kmb_res'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_leaf  =nc.variables['kmort_leaf'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_sapab =nc.variables['kmort_sapab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_sapbe =nc.variables['kmort_sapbe' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_hrtab =nc.variables['kmort_hrtab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_hrtbe =nc.variables['kmort_hrtbe' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_root  =nc.variables['kmort_root'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_fruit =nc.variables['kmort_fruit' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_reserv=nc.variables['kmort_reserv'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kturn_leaf  =nc.variables['kturn_leaf'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kturn_sapab =nc.variables['kturn_sapab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kturn_root  =nc.variables['kturn_root'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kturn_fruit =nc.variables['kturn_fruit' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  #kconv_sapab =(1./730.)*np.ones((veget.shape))
  #kconv_sapbe =(1./730.)*np.ones((veget.shape))
  kconv_sapab =0.5*np.ones((veget.shape))
  kconv_sapbe =0.5*np.ones((veget.shape))
  kharv_leaf  =nc.variables['kharv_leaf'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kharv_sapab =nc.variables['kharv_sapab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kharv_root  =nc.variables['kharv_root'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kharv_fruit =nc.variables['kharv_fruit' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kharv_leaf_new=1.*kharv_leaf
  kharv_sapab_new=1.*kharv_sapab
  kharv_fruit_new=1.*kharv_fruit
  kharv_root_new=1.*kharv_root
  kfire_leaf  =nc.variables['kfire_leaf'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kfire_sapab =nc.variables['kfire_sapab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kfire_hrtab =nc.variables['kfire_hrtab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kfire_fruit =nc.variables['kfire_fruit' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kfire_reserv=nc.variables['kfire_reserv'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  klitma_soila=nc.variables['klitma_soila'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  klitmb_soila=nc.variables['klitmb_soila'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  klitsa_soila=nc.variables['klitsa_soila'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  klitsa_soils=nc.variables['klitsa_soils'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  klitsb_soila=nc.variables['klitsb_soila'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  klitsb_soils=nc.variables['klitsb_soils'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_litma=nc.variables['kresp_litma'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_litmb=nc.variables['kresp_litmb'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_litsa=nc.variables['kresp_litsa'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_litsb=nc.variables['kresp_litsb'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kfire_litma=nc.variables['kfire_litma'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kfire_litsa=nc.variables['kfire_litsa'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  #krespa=nc.variables['kresp_soila'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  #kresps=nc.variables['kresp_soils'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  #krespp=nc.variables['kresp_soilp'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  ksoila_s=nc.variables['ksoila_s'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  ksoila_p=nc.variables['ksoila_p'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  ksoils_a=nc.variables['ksoils_a'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  ksoils_p=nc.variables['ksoils_p'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  ksoilp_a=nc.variables['ksoilp_a'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]

  kresp_soila=np.zeros((20,13,len(rows_c),len(kols_c)))
  kresp_soils=np.zeros((20,13,len(rows_c),len(kols_c)))
  kresp_soilp=np.zeros((20,13,len(rows_c),len(kols_c)))
  ktop_soila=np.zeros((13,2,2))
  ktop_soils=np.zeros((13,2,2))
  ktop_soilp=np.zeros((13,2,2))
  soil_layers_top=np.arange(Lab_top/0.01)
  soil_layers_top=soil_layers_top.astype(int)
  for z in soil_layers_top:
    ktop_soila=ktop_soila+(kresp_soila0*np.exp(-re*zmin[z]))
    ktop_soils=ktop_soils+(kresp_soils0*np.exp(-re*zmin[z]))
    ktop_soilp=ktop_soilp+(kresp_soilp0*np.exp(-re*zmin[z]))
  for z in soil_layers:
    if zmax[z]<=Lab_top:
      kresp_soila[z]=ktop_soila*0.1
      kresp_soils[z]=ktop_soils*0.1
      kresp_soilp[z]=ktop_soilp*0.1
    else: 
      kresp_soila[z]=kresp_soila0*np.exp(-re*zmin[z])
      kresp_soils[z]=kresp_soils0*np.exp(-re*zmin[z])
      kresp_soilp[z]=kresp_soilp0*np.exp(-re*zmin[z])

  # 1. biomass
  kharv_leaf_new[11]     =kharv_leaf[11]*(harv_new_id[0]/0.45)
  kharv_fruit_new[11]    =kharv_fruit[11]*(harv_new_id[0]/0.45)
  kharv_sapab_new[11]    =kharv_sapab[11]*(harv_new_id[0]/0.45)
  kharv_root_new[11]     =kharv_root[11]*(harv_new_id[0]/0.45)    
  # kloss
  kloss_leaf     =kmort_leaf*xmort[0]+kturn_leaf+kharv_leaf_new+kfire_leaf
  kloss_sapab    =kmort_sapab*xmort[0]+kturn_sapab+kharv_sapab_new+kfire_sapab+kconv_sapab
  kloss_sapbe    =kmort_sapbe*xmort[0]+kconv_sapbe
  kloss_hrtab    =kmort_hrtab*xmort[0]+kfire_hrtab
  kloss_hrtbe    =kmort_hrtbe*xmort[0]
  kloss_root     =kmort_root*xmort[0]+kturn_root+kharv_root_new
  kloss_fruit    =kmort_fruit*xmort[0]+kturn_fruit+kharv_fruit_new+kfire_fruit
  kloss_reserv   =kmort_reserv*xmort[0]+kfire_reserv+kmb_res
  # equilibrium of biomass without NPP changes
  leaf_old     =NPP_leaf*xNPP/kloss_leaf
  leaf_old     =np.where((leaf_old!=leaf_old),0.,leaf_old)
  sapab_old    =NPP_sapab*xNPP/kloss_sapab
  sapab_old    =np.where((sapab_old!=sapab_old),0.,sapab_old)
  root_old    =NPP_root*xNPP/kloss_root
  root_old    =np.where((root_old!=root_old),0.,root_old)
  fruit_old    =NPP_fruit*xNPP/kloss_fruit
  fruit_old    =np.where((fruit_old!=fruit_old),0.,fruit_old)
  #scale NPP PFT 11
  NPP_leaf_new=1.*NPP_leaf;NPP_sapab_new=1.*NPP_sapab
  NPP_root_new=1.*NPP_root;NPP_fruit_new=1.*NPP_fruit
  mod_yield=((kharv_leaf_new[11]*leaf_old[11])+(kharv_fruit_new[11]*fruit_old[11])\
             +(kharv_sapab_new[11]*sapab_old[11])+(kharv_root_new[11]*root_old[11]))\
             *veget[11]
  scale_factor=obs_yield[0]/mod_yield
  scale_factor[mod_yield<=0.]=1.
  NPP_leaf_new[11]=scale_factor*NPP_leaf[11]
  NPP_sapab_new[11]=scale_factor*NPP_sapab[11]
  NPP_root_new[11]=scale_factor*NPP_root[11]
  NPP_fruit_new[11]=scale_factor*NPP_fruit[11]
  # equilibrium of biomass with NPP change
  leaf     =NPP_leaf_new*xNPP/kloss_leaf
  leaf     =np.where(land*(leaf!=leaf),0.,leaf)
  sapab    =NPP_sapab_new*xNPP/kloss_sapab
  sapab    =np.where(land*(sapab!=sapab),0.,sapab)
  sapbe    =NPP_sapbe*xNPP/kloss_sapbe
  sapbe    =np.where(land*(sapbe!=sapbe),0.,sapbe)
  hrtab    =sapab*kconv_sapab/kloss_hrtab
  hrtab    =np.where(land*(hrtab!=hrtab),0.,hrtab)
  hrtab[np.isfinite(hrtab)==False]=0.
  hrtbe    =sapbe*kconv_sapbe/kloss_hrtbe
  hrtbe    =np.where(land*(hrtbe!=hrtbe),0.,hrtbe)
  root     =NPP_root_new*xNPP/kloss_root
  root     =np.where(land*(root!=root),0.,root)
  fruit    =NPP_fruit_new*xNPP/kloss_fruit
  fruit    =np.where(land*(fruit!=fruit),0.,fruit)
  reserv   =NPP_reserv*xNPP/kloss_reserv
  reserv   =np.where(land*(reserv!=reserv),0.,reserv)
  # 2. litter
  mort_ma=(kmort_leaf  *leaf  *litfrac_m[0]+kmort_sapab *sapab *litfrac_m[1]+kmort_hrtab *hrtab *litfrac_m[3]\
          +kmort_fruit *fruit *litfrac_m[6]+kmort_reserv*reserv*litfrac_m[7])*xmort[0]
  mort_sa=(kmort_leaf  *leaf  *litfrac_s[0]+kmort_sapab *sapab *litfrac_s[1]+kmort_hrtab *hrtab *litfrac_s[3]\
          +kmort_fruit *fruit *litfrac_s[6]+kmort_reserv*reserv*litfrac_s[7])*xmort[0]
  mort_mb=(kmort_sapbe *sapbe *litfrac_m[2]+kmort_hrtbe *hrtbe *litfrac_m[4]\
          +kmort_root  *root  *litfrac_m[5])*xmort[0]
  mort_sb=(kmort_sapbe *sapbe *litfrac_s[2]+kmort_hrtbe *hrtbe *litfrac_s[4]\
          +kmort_root  *root  *litfrac_s[5])*xmort[0]
  turn_ma= kturn_leaf  *leaf  *litfrac_m[0]+kturn_sapab *sapab *litfrac_m[1]+kturn_fruit *fruit *litfrac_m[6]
  turn_sa= kturn_leaf  *leaf  *litfrac_s[0]+kturn_sapab *sapab *litfrac_s[1]+kturn_fruit *fruit *litfrac_s[6]
  turn_mb= kturn_root* root* litfrac_m[5]
  turn_sb= kturn_root* root* litfrac_s[5]
  kloss_ma=(klitma_soila             +kresp_litma)*xl+kfire_litma
  kloss_mb=(klitmb_soila             +kresp_litmb)*xl
  kloss_sa=(klitsa_soila+klitsa_soils+kresp_litsa)*xl+kfire_litsa
  kloss_sb=(klitsb_soila+klitsb_soils+kresp_litsb)*xl
  # equilibrium of litter 
  lit_ma=(mort_ma+turn_ma)/kloss_ma
  lit_mb=(mort_mb+turn_mb)/kloss_mb
  lit_sa=(mort_sa+turn_sa)/kloss_sa
  lit_sb=(mort_sb+turn_sb)/kloss_sb
  lit_ma=np.where(land*(lit_ma!=lit_ma),0.,lit_ma)
  lit_mb=np.where(land*(lit_mb!=lit_mb),0.,lit_mb)
  lit_sa=np.where(land*(lit_sa!=lit_sa),0.,lit_sa)
  lit_sb=np.where(land*(lit_sb!=lit_sb),0.,lit_sb)
  # 3. soil carbon
  # input from litter
  lit_soila=(klitma_soila*lit_ma+klitmb_soila*lit_mb+klitsa_soila*lit_sa+klitsb_soila*lit_sb)*xl
  lit_soils=(klitsa_soils*lit_sa+klitsb_soils*lit_sb)*xl
  # below versus aboveground litter
  littera_ab=(klitma_soila*lit_ma+klitsa_soila*lit_sa)*xl
  littera_bl=(klitmb_soila*lit_mb+klitsb_soila*lit_sb)*xl
  litters_ab=(klitsa_soils*lit_sa)*xl
  litters_bl=(klitsb_soils*lit_sb)*xl
  #litter distribution over depth
  soil_layers_top=np.arange(Lab_top/0.1)
  soil_layers_top=soil_layers_top.astype(int)
  r_out=r_pft(veget,len(rows_c),len(kols_c))
  littera_bl0=(-littera_bl*r_out)/(np.exp(-r_out*zmin[19])-1)*dz0
  litters_bl0=(-litters_bl*r_out)/(np.exp(-r_out*zmin[19])-1)*dz0
  littera_bl_top=np.zeros((13,len(rows_c),len(kols_c)),)
  litters_bl_top=np.zeros((13,len(rows_c),len(kols_c)),)
  littera_zh=np.zeros((20,13,len(rows_c),len(kols_c)))
  litters_zh=np.zeros((20,13,len(rows_c),len(kols_c)))
  for z in soil_layers_top:
    littera_bl_top=littera_bl_top+(littera_bl0*np.exp(-r_out*zmin[z]))
    litters_bl_top=litters_bl_top+(litters_bl0*np.exp(-r_out*zmin[z]))
  for z in soil_layers:
    if zmax[z]<=Lab_top:
      littera_ab_z=littera_ab*(dz_all[z]/Lab_top)
      litters_ab_z=litters_ab*(dz_all[z]/Lab_top)
      littera_bl_z=littera_bl_top*(dz_all[z]/Lab_top)
      litters_bl_z=litters_bl_top*(dz_all[z]/Lab_top)
      littera_zh[z]=littera_ab_z+littera_bl_z
      litters_zh[z]=litters_ab_z+litters_bl_z
    else:
      littera_ab_z=np.zeros((13,len(rows_c),len(kols_c)),)
      litters_ab_z=np.zeros((13,len(rows_c),len(kols_c)),)
      littera_bl_z=littera_bl0*np.exp(-r_out*(zmin[z]-Lab_top))
      litters_bl_z=litters_bl0*np.exp(-r_out*(zmin[z]-Lab_top))
      littera_zh[z]=littera_ab_z+littera_bl_z
      litters_zh[z]=litters_ab_z+litters_bl_z 
  leaf [:,sea]=np.nan;sapab[:,sea]=np.nan;sapbe[:,sea]=np.nan;hrtab [:,sea]=np.nan
  hrtbe[:,sea]=np.nan;root [:,sea]=np.nan;fruit[:,sea]=np.nan;reserv[:,sea]=np.nan
  lit_ma[:,sea]=np.nan;lit_mb[:,sea]=np.nan;lit_sa[:,sea]=np.nan;lit_sb[:,sea]=np.nan

  #output
  biomass=(leaf+sapab+sapbe+hrtab+hrtbe+root+fruit+reserv)
  litter=(lit_ma+lit_mb+lit_sa+lit_sb)
  resp_veg_fire=(kfire_leaf*leaf  + kfire_sapab*sapab +  kfire_hrtab*hrtab \
                 + kfire_fruit*fruit + kfire_reserv*reserv)
  resp_lit=((kresp_litma+kfire_litma)*lit_ma+(kresp_litmb)*lit_mb \
           +(kresp_litsa+kfire_litsa)*lit_sa+(kresp_litsb)*lit_sb)
  harv_tot=(kharv_leaf_new*leaf + kharv_sapab_new*sapab + kharv_fruit_new*fruit + \
            kharv_root_new*root)
  npp=(NPP_leaf_new+NPP_sapab_new+NPP_sapbe+NPP_root_new+NPP_fruit_new+NPP_reserv)*xNPP
  bC=[np.nansum(biomass*veget*AREA)/1.e15]
  lC=[np.nansum(litter*veget*AREA)/1.e15]
  tnpp=np.nansum(npp*veget*AREA)/1.e15
  tresp_veg=np.nansum(resp_veg_fire*veget*AREA)/1.e15
  tresp_lit=np.nansum(resp_lit*veget*AREA)/1.e15
  harv_c3crop=np.nansum(harv_tot[11]*veget[11]*AREA)/1.e15

  print tnpp,bC,lC,tresp_veg,tresp_lit,harv_c3crop

  check.display('year,'+'npp,'+'bC,'+'lC,'+'resp_veg,'+'resp_lit,'+'harv_crop,'+'\neq,'+\
                str(tnpp)+','+str(bC[0])+','+str(lC[0])+','+str(tresp_veg)+','+\
                str(tresp_lit)+','+str(harv_c3crop),logfile)

  resultfile=Dataset('%s/BL_cc_eq.nc' %(OptPath),'w')
  resultfile.createDimension('latitude',len(rows_c))
  resultfile.createDimension('longitude',len(kols_c))
  resultfile.createDimension('PFT',13)
  var_biomass=resultfile.createVariable('biomass','f',('PFT','latitude','longitude',))
  var_litter=resultfile.createVariable('litter','f',('PFT','latitude','longitude',))
  var_npp=resultfile.createVariable('npp','f',('PFT','latitude','longitude',))
  var_resp_veg=resultfile.createVariable('resp_veg','f',('PFT','latitude','longitude',))
  var_resp_lit=resultfile.createVariable('resp_lit','f',('PFT','latitude','longitude',))
  var_harv_tot=resultfile.createVariable('harv_tot','f',('PFT','latitude','longitude',))
  var_biomass[:,:,:]=biomass[:,:,:]
  var_litter[:,:,:]=litter[:,:,:]
  var_npp[:,:,:]=npp[:,:,:]
  var_resp_veg[:,:,:]=resp_veg_fire[:,:,:]
  var_resp_lit[:,:,:]=resp_lit[:,:,:]
  var_harv_tot[:,:,:]=harv_tot[:,:,:]
  resultfile.close()
  nc.close()
  kc.close()

  return littera_zh,litters_zh,kresp_soila,kresp_soils,kresp_soilp,\
         ksoila_s,ksoila_p,ksoils_a,ksoils_p,ksoilp_a,mmod_old
