#pragma once
namespace libcloudphxx
{
  namespace lgrngn
  {
    namespace detail
    {
      template<class real_t>
      real_t vohl_davis_no_waals_r_max()
      {
        return 1100.;
      }

      template<class real_t>
      void vohl_davis_no_waals_efficiencies(std::vector<real_t> &vec)
      {
        //NVCC doesn't support extended initializer list. First make an array, then copy it to a vector.
        const real_t arr[] = {
0, 0, 0, 0, 0, 0.0218, 0, 0, 0.014736, 0.024245, 0, 0, 0.009316, 0.019473, 0.025568, 0, 0, 0.010091, 0.015382, 0.023103, 
      
0.026963, 0, 0, 0.01122, 0.015029, 0.020001, 0.024974, 0.026963, 0, 0, 0.011883, 0.015712, 0.019293, 0.022628, 0.025963, 0.026963, 0, 0, 0.012151, 0.016412, 
      
0.020672, 0.022638, 0.024604, 0.02657, 0.026963, 0, 0, 0, 0.016672, 0.020884, 0.023542, 0.024645, 0.025749, 0.026853, 0.026963, 0, 0, 0, 0.017416, 0.022189, 
      
0.026963, 0.026963, 0.026963, 0.026963, 0.026963, 0.026963, 0, 0, 0, 0.017134, 0.022275, 0.027416, 0.02981, 0.029457, 0.029105, 0.028752, 0.028435, 0.028435, 0, 0, 
      
0, 0.016714, 0.022259, 0.027804, 0.033349, 0.032325, 0.031301, 0.030277, 0.029254, 0.028435, 0.028435, 0, 0, 0, 0, 0.021674, 0.027072, 0.03247, 0.034521, 0.033226, 
      
0.031931, 0.030636, 0.029341, 0.028435, 0.028435, 0, 0, 0, 0, 0.021231, 0.026516, 0.031802, 0.037088, 0.035543, 0.033997, 0.032452, 0.030907, 0.029362, 0.028435, 0.028435, 
      
0, 0, 0, 0, 0.020903, 0.026105, 0.031308, 0.036511, 0.038222, 0.036442, 0.034663, 0.032883, 0.031104, 0.029324, 0.028435, 0.028435, 0, 0, 0, 0, 
      
0.020672, 0.025816, 0.030959, 0.036103, 0.041246, 0.039244, 0.037243, 0.035241, 0.033239, 0.031237, 0.029235, 0.028435, 0.028435, 0, 0, 0, 0, 0, 0.025629, 0.030734, 
      
0.035839, 0.040945, 0.04239, 0.040175, 0.037959, 0.035744, 0.033529, 0.031314, 0.029099, 0.028435, 0.028435, 0, 0, 0, 0, 0, 0.025532, 0.030617, 0.035702, 0.040786, 
      
0.045871, 0.043665, 0.041459, 0.039252, 0.037046, 0.03484, 0.032634, 0.030428, 0.029986, 0.029986, 0, 0, 0, 0, 0, 0.026907, 0.032264, 0.037621, 0.042979, 0.048336, 
      
0.049739, 0.047187, 0.044636, 0.042084, 0.039532, 0.036981, 0.034429, 0.031878, 0.031623, 0.031623, 0, 0, 0, 0, 0, 0.028435, 0.034095, 0.039754, 0.045414, 0.051074, 
      
0.056734, 0.053811, 0.050888, 0.047965, 0.045041, 0.042118, 0.039195, 0.036272, 0.033349, 0.033349, 0.033349, 0, 0, 0, 0, 0, 0, 0.036611, 0.043262, 0.049912, 
      
0.056563, 0.063214, 0.064786, 0.06128, 0.057774, 0.054268, 0.050762, 0.047255, 0.043749, 0.040243, 0.037088, 0.037088, 0.037088, 0, 0, 0, 0, 0, 0, 0.041198, 
      
0.049418, 0.057637, 0.065857, 0.074077, 0.082297, 0.07739, 0.072482, 0.067575, 0.062667, 0.05776, 0.052853, 0.047945, 0.043038, 0.039112, 0.039112, 0.039112, 0, 0, 0, 0, 
      
0, 0, 0.043649, 0.053262, 0.062875, 0.072488, 0.0821, 0.091713, 0.093638, 0.087875, 0.082111, 0.076348, 0.070585, 0.064821, 0.059058, 0.053295, 0.047532, 0.043497, 0.043497, 0.043497, 
      
0, 0, 0, 0, 0, 0, 0.048374, 0.061294, 0.074214, 0.087133, 0.100053, 0.112973, 0.125893, 0.117818, 0.109743, 0.101668, 0.093593, 0.085518, 0.077444, 0.069369, 
      
0.061294, 0.053219, 0.048374, 0.048374, 0.048374, 0, 0, 0, 0, 0, 0, 0, 0.06506, 0.080077, 0.095093, 0.110109, 0.125125, 0.140141, 0.142957, 0.133572, 
      
0.124186, 0.114801, 0.105416, 0.096031, 0.086646, 0.077261, 0.067876, 0.058491, 0.053798, 0.053798, 0.053798, 0, 0, 0, 0, 0, 0, 0, 0.073865, 0.095403, 
      
0.11694, 0.138478, 0.160016, 0.181554, 0.203092, 0.189631, 0.176169, 0.162708, 0.149247, 0.135786, 0.122325, 0.108864, 0.095403, 0.081941, 0.06848, 0.063096, 0.063096, 0.063096, 0, 0, 
      
0, 0, 0, 0, 0, 0.080562, 0.106813, 0.133063, 0.159313, 0.185563, 0.211813, 0.238064, 0.242808, 0.226047, 0.209286, 0.192525, 0.175764, 0.159003, 0.142243, 0.125482, 
      
0.108721, 0.09196, 0.075199, 0.07017, 0.07017, 0.07017, 0, 0, 0, 0, 0, 0, 0, 0.082297, 0.117345, 0.152392, 0.18744, 0.222488, 0.257535, 0.292583, 
      
0.327631, 0.305346, 0.283061, 0.260776, 0.238491, 0.216206, 0.19392, 0.171635, 0.14935, 0.127065, 0.10478, 0.082495, 0.078038, 0.078038, 0.078038, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0.121807, 0.162183, 0.202559, 0.242935, 0.283311, 0.323687, 0.364063, 0.371236, 0.345206, 0.319175, 0.293145, 0.267114, 0.241083, 0.215053, 0.189022, 0.162992, 0.136961, 
      
0.110931, 0.0849, 0.082297, 0.082297, 0.082297, 0, 0, 0, 0, 0, 0, 0, 0, 0.135697, 0.180691, 0.225686, 0.27068, 0.315674, 0.360668, 0.405663, 
      
0.450657, 0.420334, 0.390012, 0.35969, 0.329367, 0.299045, 0.268723, 0.2384, 0.208078, 0.177755, 0.147433, 0.117111, 0.086788, 0.086788, 0.086788, 0.086788, 0, 0, 0, 0.001679, 
      
0.024274, 0.062281, 0.128671, 0.208645, 0.274129, 0.332516, 0.383226, 0.422613, 0.460032, 0.490484, 0.515226, 0.539387, 0.556806, 0.56, 0.56, 0.56, 0.56, 0.559129, 0.554484, 0.54171, 
      
0.52429, 0.503935, 0.488677, 0.475129, 0.467613, 0.475903, 0.520806, 0.626, 0, 0, 0, 0.00217, 0.026, 0.0689, 0.1366, 0.2175, 0.286, 0.346, 0.395, 0.4365, 
      
0.472, 0.505, 0.529, 0.5515, 0.572, 0.58, 0.58, 0.58, 0.58, 0.58, 0.576, 0.578, 0.556, 0.544, 0.529, 0.5155, 0.508, 0.507, 0.526, 0.5825, 
      
0.712, 0, 0, 0, 0.002489, 0.027288, 0.0731, 0.143855, 0.225455, 0.297939, 0.359455, 0.408485, 0.451, 0.485727, 0.518455, 0.544394, 0.565091, 0.584515, 0.597242, 0.6, 
      
0.6, 0.6, 0.6, 0.6, 0.593848, 0.598091, 0.576879, 0.564788, 0.555091, 0.543667, 0.542303, 0.548, 0.576879, 0.645, 0.798, 0, 0, 0, 0.002652, 0.027471, 
      
0.077235, 0.150494, 0.232941, 0.310235, 0.371412, 0.422588, 0.465882, 0.501059, 0.531647, 0.559412, 0.580353, 0.599176, 0.614, 0.62, 0.62, 0.62, 0.62, 0.62, 0.619647, 0.615412, 
      
0.612588, 0.598471, 0.586824, 0.582118, 0.574235, 0.577765, 0.590471, 0.628471, 0.708235, 0.884, 0, 0, 0, 0.002671, 0.026643, 0.080357, 0.156786, 0.24, 0.322857, 0.384286, 
      
0.437143, 0.48, 0.516429, 0.546429, 0.575, 0.597143, 0.614286, 0.629286, 0.637857, 0.64, 0.64, 0.64, 0.64, 0.64, 0.637857, 0.637857, 0.629286, 0.620714, 0.61, 0.609286, 
      
0.606429, 0.614286, 0.634286, 0.680714, 0.772143, 0.97, 0, 0, 0, 0.00256, 0.024889, 0.081556, 0.1612, 0.247022, 0.333333, 0.398, 0.452444, 0.495556, 0.532, 0.562667, 
      
0.589333, 0.613333, 0.630889, 0.646444, 0.656, 0.66, 0.66, 0.66, 0.66, 0.66, 0.66, 0.656889, 0.659556, 0.648, 0.643111, 0.636444, 0.637333, 0.639556, 0.651778, 0.679333, 
      
0.733555, 0.836666, 1.056, 0, 0, 0, 0.002328, 0.022284, 0.080986, 0.163576, 0.253492, 0.340541, 0.410595, 0.466541, 0.511676, 0.548108, 0.580243, 0.605108, 0.629324, 0.648865, 
      
0.662919, 0.673757, 0.678622, 0.68, 0.68, 0.68, 0.68, 0.68, 0.679919, 0.677324, 0.678297, 0.670189, 0.665892, 0.66373, 0.666514, 0.673541, 0.690162, 0.725513, 0.786946, 0.901757, 
      
1.142, 0, 0, 0, 0.001985, 0.018895, 0.078789, 0.164074, 0.259453, 0.347368, 0.423474, 0.480316, 0.527158, 0.564211, 0.596526, 0.622211, 0.645368, 0.666842, 0.680737, 0.693368, 
      
0.698, 0.7, 0.7, 0.7, 0.7, 0.7, 0.7, 0.699263, 0.698842, 0.697158, 0.692947, 0.689684, 0.69179, 0.696737, 0.708316, 0.729368, 0.772737, 0.840842, 0.967368, 1.228, 
      
0, 0, 0, 0.00154, 0.014782, 0.07509, 0.162838, 0.264944, 0.353846, 0.436615, 0.494821, 0.543282, 0.581538, 0.613, 0.640538, 0.662077, 0.683205, 0.699795, 0.711077, 0.717974, 
      
0.719513, 0.72, 0.72, 0.72, 0.72, 0.72, 0.72, 0.719308, 0.719718, 0.717769, 0.716231, 0.71441, 0.720564, 0.727923, 0.74382, 0.769333, 0.820923, 0.895205, 1.03346, 1.314, 
      
0, 0, 0.0001, 0.001, 0.01, 0.07, 0.16, 0.27, 0.36, 0.45, 0.51, 0.56, 0.6, 0.63, 0.66, 0.68, 0.7, 0.72, 0.73, 0.74, 
      
0.74, 0.74, 0.74, 0.74, 0.74, 0.74, 0.74, 0.74, 0.74, 0.74, 0.74, 0.74, 0.74, 0.75, 0.76, 0.78, 0.81, 0.87, 0.95, 1.1, 
      
1.4, 0, 0, 0, 0.003643, 0.026551, 0.083439, 0.169537, 0.27339, 0.364439, 0.450683, 0.51461, 0.563024, 0.602024, 0.631781, 0.65861, 0.679732, 0.69778, 0.716122, 0.72961, 
      
0.739366, 0.744512, 0.745488, 0.746463, 0.747439, 0.748415, 0.74939, 0.750366, 0.751341, 0.752317, 0.753293, 0.754268, 0.755244, 0.75622, 0.758756, 0.767707, 0.77922, 0.801902, 0.836146, 0.899732, 
      
0.994024, 1.1778, 1.49, 0, 0, 0, 0.005926, 0.040152, 0.096762, 0.179143, 0.278, 0.369714, 0.453143, 0.520381, 0.568476, 0.606, 0.635524, 0.659333, 0.680857, 0.697048, 
      
0.713429, 0.729429, 0.738952, 0.748095, 0.75, 0.751905, 0.75381, 0.755714, 0.757619, 0.759524, 0.761429, 0.763333, 0.765238, 0.767143, 0.769048, 0.770952, 0.772857, 0.777048, 0.785333, 0.798857, 
      
0.824095, 0.862571, 0.930857, 1.04095, 1.25619, 1.58, 0, 0, 0, 0.007873, 0.051009, 0.109977, 0.188814, 0.283744, 0.375767, 0.457256, 0.527233, 0.576186, 0.611791, 0.641093, 
      
0.662023, 0.682953, 0.697698, 0.712116, 0.727651, 0.738744, 0.748047, 0.753605, 0.756395, 0.759186, 0.761977, 0.764767, 0.767558, 0.770349, 0.77314, 0.77593, 0.778721, 0.781512, 0.784302, 0.787093, 
      
0.789884, 0.794907, 0.802884, 0.818884, 0.846558, 0.889256, 0.963279, 1.09058, 1.33512, 1.67, 0, 0, 0, 0.009507, 0.059309, 0.123091, 0.198545, 0.290545, 0.382545, 0.462909, 
      
0.535091, 0.586, 0.618727, 0.646545, 0.666545, 0.684727, 0.699636, 0.712364, 0.725818, 0.738727, 0.747818, 0.756364, 0.76, 0.763636, 0.767273, 0.770909, 0.774545, 0.778182, 0.781818, 0.785455, 
      
0.789091, 0.792727, 0.796364, 0.8, 0.803636, 0.807273, 0.812364, 0.820364, 0.839273, 0.869273, 0.916182, 0.996909, 1.14273, 1.41455, 1.76, 0, 0, 0, 0.01085, 0.065222, 
      
0.136111, 0.208333, 0.298333, 0.39, 0.47, 0.541111, 0.592778, 0.626667, 0.652778, 0.672778, 0.688333, 0.702778, 0.713889, 0.725, 0.738333, 0.747778, 0.756667, 0.762778, 0.767222, 0.771667, 
      
0.776111, 0.780556, 0.785, 0.789444, 0.793889, 0.798333, 0.802778, 0.807222, 0.811667, 0.816111, 0.820556, 0.825, 0.829444, 0.837778, 0.86, 0.892222, 0.943333, 1.03167, 1.19722, 1.49444, 
      
1.85, 0, 0, 0, 0.01192, 0.068904, 0.149043, 0.218174, 0.307043, 0.397478, 0.476348, 0.546261, 0.600522, 0.636609, 0.660609, 0.680609, 0.693652, 0.706696, 0.716609, 0.726174, 
      
0.737304, 0.747913, 0.756609, 0.764783, 0.77, 0.775217, 0.780435, 0.785652, 0.79087, 0.796087, 0.801304, 0.806522, 0.811739, 0.816957, 0.822174, 0.827391, 0.832609, 0.837826, 0.842696, 0.846435, 
      
0.85513, 0.881043, 0.915391, 0.970696, 1.06748, 1.25391, 1.57478, 1.94, 0, 0, 0, 0.012735, 0.070498, 0.161894, 0.228064, 0.316574, 0.404277, 0.483362, 0.552808, 0.60917, 
      
0.648426, 0.669936, 0.689085, 0.700575, 0.711213, 0.720447, 0.728532, 0.737213, 0.748213, 0.756723, 0.765234, 0.772021, 0.777979, 0.783936, 0.789894, 0.795851, 0.801808, 0.807766, 0.813723, 0.819681, 
      
0.825638, 0.831596, 0.837553, 0.843511, 0.849468, 0.855426, 0.860021, 0.863915, 0.873447, 0.902383, 0.938766, 0.998255, 1.10428, 1.31266, 1.65553, 2.03, 0, 0, 0, 0.01331, 
      
0.070133, 0.174667, 0.238, 0.326333, 0.412, 0.491, 0.560667, 0.618667, 0.662, 0.680333, 0.697333, 0.709, 0.717333, 0.725333, 0.732, 0.738667, 0.748, 0.757, 0.765333, 0.773333, 
      
0.78, 0.786667, 0.793333, 0.8, 0.806667, 0.813333, 0.82, 0.826667, 0.833333, 0.84, 0.846667, 0.853333, 0.86, 0.866667, 0.873333, 0.877, 0.881333, 0.894, 0.924, 0.962333, 
      
1.026, 1.142, 1.37333, 1.73667, 2.12, 0, 0, 0, 0.013661, 0.067931, 0.187367, 0.251041, 0.336143, 0.420592, 0.499224, 0.569755, 0.628531, 0.670592, 0.692326, 0.707, 
      
0.718837, 0.724959, 0.731082, 0.73651, 0.741816, 0.748592, 0.757429, 0.765592, 0.773755, 0.781327, 0.788674, 0.79602, 0.803367, 0.810714, 0.818061, 0.825408, 0.832755, 0.840102, 0.847449, 0.854796, 
      
0.862143, 0.86949, 0.876837, 0.884184, 0.891531, 0.893653, 0.898694, 0.914857, 0.946898, 0.986082, 1.05392, 1.18059, 1.43582, 1.81816, 2.21, 0, 0, 0.00188, 0.0138, 0.064, 
      
0.2, 0.264, 0.346, 0.43, 0.508, 0.58, 0.636, 0.68, 0.706, 0.718, 0.73, 0.734, 0.738, 0.742, 0.746, 0.75, 0.758, 0.766, 0.774, 0.782, 
      
0.79, 0.798, 0.806, 0.814, 0.822, 0.83, 0.838, 0.846, 0.854, 0.862, 0.87, 0.878, 0.886, 0.894, 0.902, 0.91, 0.91, 0.916, 0.936, 0.97, 
      
1.01, 1.082, 1.22, 1.5, 1.9, 2.3, 0, 0, 0.002892, 0.02008, 0.07119, 0.204524, 0.277353, 0.355714, 0.437899, 0.512899, 0.580126, 0.6357, 0.680714, 0.712437, 
      
0.725042, 0.737101, 0.743656, 0.747857, 0.752059, 0.756261, 0.760462, 0.766513, 0.773796, 0.781106, 0.78895, 0.796359, 0.803641, 0.810924, 0.818207, 0.82549, 0.832773, 0.840056, 0.847339, 0.854622, 
      
0.861905, 0.869188, 0.876471, 0.883753, 0.891036, 0.89874, 0.906583, 0.913081, 0.914202, 0.922577, 0.945196, 0.977899, 1.0195, 1.10017, 1.25294, 1.54734, 1.94664, 2.35, 0, 0, 
      
0.003791, 0.024967, 0.078791, 0.20956, 0.29022, 0.366044, 0.447143, 0.518571, 0.582088, 0.636813, 0.682308, 0.718571, 0.731758, 0.744176, 0.753187, 0.757582, 0.761978, 0.766374, 0.770769, 0.775604, 
      
0.782198, 0.788791, 0.796044, 0.803407, 0.81, 0.816593, 0.823187, 0.82978, 0.836374, 0.842967, 0.84956, 0.856154, 0.862747, 0.869341, 0.875934, 0.882527, 0.889121, 0.895714, 0.903407, 0.911099, 
      
0.916593, 0.91956, 0.929451, 0.953846, 0.985165, 1.03066, 1.11967, 1.28681, 1.59451, 1.99341, 2.4, 0, 0, 0.004584, 0.02854, 0.086779, 0.215081, 0.302628, 0.376954, 0.457655, 
      
0.52504, 0.585782, 0.639259, 0.68473, 0.719232, 0.738167, 0.751226, 0.762601, 0.767183, 0.771766, 0.776348, 0.78093, 0.785512, 0.791173, 0.797102, 0.803275, 0.810822, 0.817035, 0.822965, 0.828895, 
      
0.834825, 0.840755, 0.846685, 0.852615, 0.858544, 0.864474, 0.870404, 0.876334, 0.882264, 0.888194, 0.894124, 0.900458, 0.908005, 0.915553, 0.920512, 0.925822, 0.936604, 0.961981, 0.991833, 1.0434, 
      
1.14043, 1.32156, 1.64151, 2.0403, 2.45, 0, 0, 0.005277, 0.030873, 0.098069, 0.221058, 0.314603, 0.388413, 0.467778, 0.532857, 0.591111, 0.642963, 0.686349, 0.720741, 0.744286, 
      
0.758254, 0.770423, 0.776667, 0.781429, 0.78619, 0.790952, 0.795714, 0.800688, 0.805979, 0.81127, 0.818042, 0.824709, 0.83, 0.835291, 0.840582, 0.845873, 0.851164, 0.856455, 0.861746, 0.867037, 
      
0.872328, 0.877619, 0.88291, 0.888201, 0.893492, 0.898783, 0.905132, 0.91254, 0.919947, 0.924815, 0.932381, 0.945291, 0.96963, 0.997937, 1.05762, 1.16667, 1.35714, 1.68836, 2.0873, 2.5, 
      
0, 0, 0.005875, 0.032032, 0.109591, 0.227468, 0.326169, 0.40039, 0.477792, 0.541948, 0.597987, 0.647857, 0.688377, 0.723052, 0.75013, 0.764935, 0.777467, 0.786039, 0.790974, 0.795909, 
      
0.800844, 0.805779, 0.810714, 0.81539, 0.820065, 0.82539, 0.832662, 0.837662, 0.842338, 0.847013, 0.851688, 0.856364, 0.861039, 0.865714, 0.87039, 0.875065, 0.87974, 0.884416, 0.889091, 0.893766, 
      
0.898442, 0.903117, 0.90974, 0.917013, 0.924286, 0.929481, 0.939221, 0.954221, 0.976818, 1.00351, 1.07325, 1.1961, 1.39351, 1.73506, 2.13442, 2.55, 0, 0, 0.006384, 0.032082, 
      
0.119633, 0.234286, 0.337347, 0.412857, 0.488367, 0.552245, 0.606327, 0.652245, 0.691633, 0.726122, 0.755714, 0.77102, 0.78449, 0.795306, 0.800408, 0.80551, 0.810612, 0.815714, 0.820816, 0.825306, 
      
0.829388, 0.833469, 0.84, 0.845918, 0.85, 0.854082, 0.858163, 0.862245, 0.866327, 0.870408, 0.87449, 0.878571, 0.882653, 0.886735, 0.890816, 0.894898, 0.89898, 0.903061, 0.907143, 0.914286, 
      
0.921429, 0.928367, 0.93449, 0.946327, 0.962653, 0.983571, 1.00857, 1.0902, 1.22653, 1.43061, 1.78163, 2.18163, 2.6, 0, 0, 0.006807, 0.031079, 0.128272, 0.241491, 0.348158, 
      
0.425351, 0.499474, 0.563684, 0.616053, 0.658158, 0.696053, 0.729912, 0.757982, 0.776842, 0.791491, 0.803772, 0.809737, 0.815, 0.820263, 0.825526, 0.83079, 0.835702, 0.839211, 0.842719, 0.847456, 
      
0.854474, 0.858246, 0.861754, 0.865263, 0.868772, 0.872281, 0.875789, 0.879298, 0.882807, 0.886316, 0.889825, 0.893333, 0.896842, 0.900351, 0.90386, 0.907368, 0.911754, 0.918772, 0.925789, 0.932807, 
      
0.939825, 0.953684, 0.970614, 0.990351, 1.01316, 1.10842, 1.25789, 1.46842, 1.82807, 2.22895, 2.65, 0, 0, 0.00715, 0.029079, 0.135581, 0.249064, 0.358621, 0.437438, 0.511084, 
      
0.576207, 0.625468, 0.665517, 0.701576, 0.734089, 0.760985, 0.782414, 0.798473, 0.810788, 0.818966, 0.824384, 0.829803, 0.835222, 0.84064, 0.846059, 0.849507, 0.852463, 0.855419, 0.861921, 0.867044, 
      
0.87, 0.872956, 0.875911, 0.878867, 0.881823, 0.884778, 0.887734, 0.89069, 0.893645, 0.896601, 0.899557, 0.902512, 0.905468, 0.908424, 0.911379, 0.916305, 0.923202, 0.930099, 0.937586, 0.946503, 
      
0.961281, 0.978128, 0.996601, 1.01729, 1.12783, 1.29015, 1.5069, 1.87438, 2.27635, 2.7, 0, 0, 0.007416, 0.026132, 0.141628, 0.256985, 0.368753, 0.44914, 0.523172, 0.589758, 
      
0.635763, 0.674249, 0.708148, 0.738172, 0.764685, 0.787748, 0.804455, 0.817785, 0.828099, 0.833668, 0.839237, 0.844806, 0.850375, 0.855944, 0.860254, 0.862676, 0.865097, 0.869479, 0.876259, 0.878789, 
      
0.881211, 0.883632, 0.886053, 0.888475, 0.890896, 0.893317, 0.895738, 0.89816, 0.900581, 0.903002, 0.905424, 0.907845, 0.910266, 0.912688, 0.915109, 0.920799, 0.927579, 0.934358, 0.942688, 0.953608, 
      
0.969104, 0.985218, 1.00235, 1.02099, 1.14838, 1.32324, 1.54601, 1.92058, 2.32385, 2.75, 0, 0, 0.00761, 0.022286, 0.146476, 0.265238, 0.378571, 0.460476, 0.535714, 0.604286, 
      
0.647143, 0.684286, 0.715714, 0.743333, 0.769048, 0.792857, 0.81, 0.824762, 0.837143, 0.842857, 0.848571, 0.854286, 0.86, 0.865714, 0.871429, 0.873333, 0.875238, 0.877143, 0.88381, 0.888095, 
      
0.89, 0.891905, 0.893809, 0.895714, 0.897619, 0.899524, 0.901429, 0.903333, 0.905238, 0.907143, 0.909048, 0.910952, 0.912857, 0.914762, 0.916667, 0.918571, 0.925238, 0.931905, 0.938571, 0.948095, 
      
0.960952, 0.977143, 0.991905, 1.00762, 1.02429, 1.17, 1.35714, 1.58571, 1.96667, 2.37143, 2.8, 0, 0, 0.007734, 0.02343, 0.150184, 0.273806, 0.385281, 0.471464, 0.548688, 
      
0.615667, 0.659555, 0.695562, 0.723665, 0.74952, 0.77404, 0.796522, 0.815316, 0.831721, 0.844133, 0.851955, 0.85781, 0.863665, 0.86952, 0.875375, 0.88123, 0.884415, 0.88582, 0.887225, 0.891464, 
      
0.897892, 0.899297, 0.900703, 0.902108, 0.903513, 0.904918, 0.906323, 0.907728, 0.909133, 0.910539, 0.911944, 0.913349, 0.914754, 0.916159, 0.917564, 0.91897, 0.920375, 0.923068, 0.929625, 0.936183, 
      
0.943489, 0.953794, 0.968525, 0.984859, 0.998208, 1.01244, 1.04089, 1.19265, 1.3918, 1.63326, 2.01265, 2.41909, 2.85, 0, 0, 0.007793, 0.024475, 0.152806, 0.282673, 0.39235, 
      
0.48212, 0.562074, 0.627512, 0.672949, 0.708018, 0.732903, 0.756682, 0.779631, 0.800829, 0.820415, 0.838387, 0.851106, 0.860968, 0.866958, 0.872949, 0.87894, 0.884931, 0.890922, 0.895899, 0.89682, 
      
0.897742, 0.899217, 0.905668, 0.909078, 0.91, 0.910922, 0.911843, 0.912765, 0.913687, 0.914608, 0.91553, 0.916452, 0.917373, 0.918295, 0.919217, 0.920138, 0.92106, 0.921982, 0.922903, 0.923825, 
      
0.927512, 0.933963, 0.940415, 0.94871, 0.95977, 0.976313, 0.992166, 1.00415, 1.01682, 1.05866, 1.21627, 1.42719, 1.68065, 2.05853, 2.46682, 2.9, 0, 0, 0.007789, 0.025426, 
      
0.154396, 0.291825, 0.399762, 0.49246, 0.57585, 0.639796, 0.687279, 0.721293, 0.743367, 0.764773, 0.785635, 0.805748, 0.825306, 0.843673, 0.858061, 0.869898, 0.87602, 0.882143, 0.888265, 0.894388, 
      
0.90051, 0.906633, 0.90822, 0.908673, 0.909127, 0.913413, 0.91932, 0.919773, 0.920227, 0.92068, 0.921134, 0.921587, 0.922041, 0.922494, 0.922948, 0.923401, 0.923855, 0.924308, 0.924762, 0.925215, 
      
0.925669, 0.926122, 0.926576, 0.927029, 0.931905, 0.938254, 0.944603, 0.954218, 0.966168, 0.984308, 0.999082, 1.00974, 1.02079, 1.07755, 1.24082, 1.46326, 1.72789, 2.10431, 2.51463, 2.95, 
      
0, 0, 0.007725, 0.026287, 0.155, 0.30125, 0.4075, 0.5025, 0.59, 0.6525, 0.7025, 0.73375, 0.755, 0.77375, 0.7925, 0.81125, 0.83, 0.84875, 0.865, 0.8775, 
      
0.885, 0.89125, 0.8975, 0.90375, 0.91, 0.91625, 0.92, 0.92, 0.92, 0.92125, 0.9275, 0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 
      
0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 0.93625, 0.9425, 0.94875, 0.96, 0.97375, 0.9925, 1.00563, 1.015, 1.02437, 1.0975, 1.26625, 
      
1.5, 1.775, 2.15, 2.5625, 3, 0, 0, 0.010318, 0.03673, 0.160564, 0.310256, 0.413641, 0.507179, 0.590872, 0.654103, 0.70682, 0.736769, 0.759538, 0.778, 0.796051, 
      
0.813949, 0.83159, 0.849231, 0.866154, 0.878051, 0.886974, 0.892923, 0.898872, 0.904872, 0.911026, 0.91718, 0.923333, 0.923333, 0.923333, 0.923333, 0.927641, 0.932667, 0.932667, 0.932667, 0.932667, 
      
0.932667, 0.932667, 0.932667, 0.932667, 0.932667, 0.932872, 0.933077, 0.933282, 0.933333, 0.933333, 0.933333, 0.933436, 0.933641, 0.933846, 0.935436, 0.94118, 0.947179, 0.953333, 0.965231, 0.979282, 
      
0.996923, 1.0081, 1.01713, 1.02615, 1.11764, 1.29159, 1.54308, 1.83333, 2.20667, 2.62359, 3.06667, 0, 0, 0.012435, 0.046459, 0.166121, 0.319697, 0.420303, 0.512667, 0.592667, 
      
0.656303, 0.711535, 0.740222, 0.764182, 0.782364, 0.799899, 0.817152, 0.833717, 0.850283, 0.866848, 0.87895, 0.889131, 0.894788, 0.900444, 0.906101, 0.912121, 0.918182, 0.924242, 0.926667, 0.926667, 
      
0.926667, 0.928242, 0.933495, 0.935333, 0.935333, 0.935333, 0.935333, 0.935333, 0.935333, 0.935333, 0.935333, 0.935495, 0.935899, 0.936303, 0.936667, 0.936667, 0.936667, 0.936667, 0.93699, 0.937394, 
      
0.937798, 0.940626, 0.945879, 0.951818, 0.958929, 0.970242, 0.984444, 1.00101, 1.01049, 1.01917, 1.02786, 1.13873, 1.31772, 1.58768, 1.89152, 2.26323, 2.68485, 3.13333, 0, 0, 
      
0.014098, 0.055507, 0.171672, 0.32809, 0.427463, 0.518925, 0.595343, 0.659075, 0.715194, 0.74409, 0.768925, 0.786836, 0.80403, 0.820746, 0.836358, 0.851881, 0.867403, 0.880179, 0.890925, 0.896836, 
      
0.902209, 0.907582, 0.913284, 0.919254, 0.925224, 0.93, 0.93, 0.93, 0.93, 0.93406, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938478, 
      
0.939075, 0.939672, 0.94, 0.94, 0.94, 0.94006, 0.940657, 0.941254, 0.941851, 0.945582, 0.950448, 0.956418, 0.964298, 0.975045, 0.989254, 1.00442, 1.01278, 1.02113, 1.02949, 1.16072, 
      
1.34716, 1.63373, 1.94955, 2.3197, 2.74627, 3.2, 0, 0, 0.015326, 0.063903, 0.177216, 0.333686, 0.435098, 0.525922, 0.598863, 0.662392, 0.71651, 0.748353, 0.773765, 0.791412, 
      
0.808431, 0.82451, 0.83949, 0.854, 0.86851, 0.881725, 0.891922, 0.899059, 0.904157, 0.909255, 0.91451, 0.920392, 0.926275, 0.932157, 0.933333, 0.933333, 0.933333, 0.935059, 0.939373, 0.940667, 
      
0.940667, 0.940667, 0.940667, 0.940667, 0.940667, 0.940667, 0.940667, 0.940824, 0.941608, 0.942392, 0.943176, 0.943333, 0.943333, 0.943333, 0.943647, 0.944431, 0.945216, 0.946, 0.950314, 0.955098, 
      
0.96098, 0.969451, 0.979647, 0.993725, 1.00694, 1.01498, 1.02302, 1.03106, 1.18357, 1.38314, 1.68118, 2.00745, 2.37608, 2.80784, 3.26667, 0, 0, 0.016139, 0.071675, 0.182754, 
      
0.339275, 0.443188, 0.533623, 0.603188, 0.666232, 0.718406, 0.752995, 0.778116, 0.796087, 0.813092, 0.828551, 0.843092, 0.856618, 0.870145, 0.883575, 0.893237, 0.901449, 0.90628, 0.911111, 0.915942, 
      
0.921594, 0.927391, 0.933188, 0.936667, 0.936667, 0.936667, 0.936667, 0.940338, 0.943333, 0.943333, 0.943333, 0.943333, 0.943333, 0.943333, 0.943333, 0.943333, 0.943333, 0.943913, 0.944879, 0.945845, 
      
0.946667, 0.946667, 0.946667, 0.946667, 0.947343, 0.948309, 0.949275, 0.950966, 0.954831, 0.95971, 0.965507, 0.974396, 0.984348, 0.997874, 1.00937, 1.0171, 1.02483, 1.03256, 1.20725, 1.42077, 
      
1.72995, 2.06522, 2.43237, 2.86957, 3.33333, 0, 0, 0.016554, 0.078851, 0.188286, 0.344857, 0.451714, 0.542, 0.608286, 0.670571, 0.720857, 0.758, 0.782, 0.800857, 0.818, 
      
0.832857, 0.847143, 0.859714, 0.872286, 0.884857, 0.894857, 0.904, 0.908571, 0.913143, 0.917714, 0.922857, 0.928571, 0.934286, 0.94, 0.94, 0.94, 0.94, 0.941714, 0.945143, 0.946, 
      
0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 0.947143, 0.948286, 0.949429, 0.95, 0.95, 0.95, 0.95, 0.951143, 0.952286, 0.953429, 0.955714, 0.959143, 
      
0.964286, 0.97, 0.979143, 0.989143, 1.00171, 1.01171, 1.01914, 1.02657, 1.034, 1.23171, 1.46, 1.78, 2.12286, 2.48857, 2.93143, 3.4, 0, 0, 0.016589, 0.085456, 
      
0.193812, 0.350432, 0.460657, 0.548545, 0.614122, 0.67539, 0.72384, 0.763352, 0.786263, 0.805718, 0.82262, 0.837418, 0.851624, 0.863268, 0.874911, 0.886554, 0.89677, 0.905408, 0.911023, 0.915343, 
      
0.919662, 0.924178, 0.929812, 0.935446, 0.94108, 0.943333, 0.943333, 0.943333, 0.943484, 0.946488, 0.948667, 0.948667, 0.948667, 0.948667, 0.948667, 0.948667, 0.948667, 0.948667, 0.948667, 0.949193, 
      
0.950507, 0.951822, 0.953136, 0.953333, 0.953333, 0.953333, 0.953728, 0.955042, 0.956357, 0.957671, 0.960254, 0.963258, 0.968826, 0.975061, 0.9837, 0.993615, 1.00526, 1.01397, 1.02111, 1.02824, 
      
1.05487, 1.25694, 1.50075, 1.83127, 2.18038, 2.54469, 2.99343, 3.46667, 0, 0, 0.016258, 0.091513, 0.199333, 0.356, 0.47, 0.555556, 0.620667, 0.680667, 0.727333, 0.769037, 
      
0.790889, 0.810667, 0.827333, 0.842222, 0.855926, 0.867259, 0.878, 0.888741, 0.898963, 0.907111, 0.91363, 0.917704, 0.921778, 0.925852, 0.931111, 0.936667, 0.942222, 0.946667, 0.946667, 0.946667, 
      
0.946667, 0.948222, 0.950815, 0.951333, 0.951333, 0.951333, 0.951333, 0.951333, 0.951333, 0.951333, 0.951333, 0.951333, 0.952519, 0.954, 0.955482, 0.956667, 0.956667, 0.956667, 0.956667, 0.957556, 
      
0.959037, 0.960519, 0.962, 0.964593, 0.967778, 0.973333, 0.979926, 0.988074, 0.997778, 1.00852, 1.01615, 1.023, 1.02985, 1.07659, 1.28289, 1.54296, 1.8837, 2.23778, 2.60074, 3.05555, 
      
3.53333, 0, 0, 0.015577, 0.097045, 0.204849, 0.361562, 0.479726, 0.563014, 0.62789, 0.684877, 0.731315, 0.775041, 0.795863, 0.815699, 0.832137, 0.84726, 0.860411, 0.871671, 0.881534, 
      
0.891397, 0.90126, 0.909096, 0.916384, 0.920219, 0.924055, 0.92789, 0.932466, 0.937945, 0.943425, 0.948904, 0.95, 0.95, 0.95, 0.950329, 0.952521, 0.954, 0.954, 0.954, 0.954, 
      
0.954, 0.954, 0.954, 0.954, 0.954, 0.954329, 0.955973, 0.957616, 0.95926, 0.96, 0.96, 0.96, 0.96, 0.961479, 0.963123, 0.964767, 0.966548, 0.96874, 0.972329, 0.977808, 
      
0.984603, 0.992274, 1.00164, 1.01151, 1.01825, 1.02482, 1.0314, 1.09912, 1.30953, 1.58658, 1.93726, 2.29507, 2.65671, 3.11781, 3.6, 0, 0, 0.01456, 0.102074, 0.21036, 
      
0.367117, 0.48982, 0.570901, 0.635766, 0.68982, 0.735766, 0.779009, 0.801171, 0.820811, 0.837027, 0.852522, 0.865135, 0.876486, 0.885495, 0.894504, 0.903514, 0.911351, 0.918559, 0.922883, 0.926486, 
      
0.93009, 0.933874, 0.939279, 0.944685, 0.95009, 0.953333, 0.953333, 0.953333, 0.953333, 0.954595, 0.956396, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 
      
0.957748, 0.95955, 0.961351, 0.963153, 0.963333, 0.963333, 0.963333, 0.963694, 0.965496, 0.967297, 0.969099, 0.970901, 0.972703, 0.976847, 0.982252, 0.989099, 0.996306, 1.00522, 1.01396, 1.02027, 
      
1.02658, 1.03288, 1.12243, 1.33685, 1.63153, 1.99189, 2.35225, 2.71261, 3.18018, 3.66667, 0, 0, 0.013221, 0.106619, 0.215867, 0.372667, 0.500267, 0.5792, 0.644267, 0.695467, 
      
0.740667, 0.782267, 0.8068, 0.825644, 0.842, 0.858, 0.870089, 0.881689, 0.889867, 0.898044, 0.906222, 0.913867, 0.920622, 0.925689, 0.929067, 0.932444, 0.935822, 0.940667, 0.946, 0.951333, 
      
0.956667, 0.956667, 0.956667, 0.956667, 0.957022, 0.958444, 0.959333, 0.959333, 0.959333, 0.959333, 0.959333, 0.959333, 0.959333, 0.959333, 0.959333, 0.959333, 0.961289, 0.963244, 0.9652, 0.966667, 
      
0.966667, 0.966667, 0.966667, 0.967644, 0.9696, 0.971556, 0.973511, 0.975067, 0.976489, 0.981333, 0.986667, 0.993422, 1.00036, 1.00853, 1.01618, 1.02222, 1.02827, 1.03431, 1.14649, 1.3648, 
      
1.67778, 2.04755, 2.40933, 2.76844, 3.24267, 3.73333, 0, 0, 0.011573, 0.110699, 0.221368, 0.378211, 0.511053, 0.587895, 0.653368, 0.701789, 0.746, 0.786, 0.812737, 0.830632, 
      
0.847053, 0.862842, 0.875263, 0.886842, 0.894632, 0.902, 0.909368, 0.916632, 0.922947, 0.928632, 0.931789, 0.934947, 0.938105, 0.942105, 0.947368, 0.952632, 0.957895, 0.96, 0.96, 0.96, 
      
0.96, 0.960842, 0.961895, 0.962, 0.962, 0.962, 0.962, 0.962, 0.962, 0.962, 0.962, 0.962, 0.962842, 0.964947, 0.967053, 0.969158, 0.97, 0.97, 0.97, 0.97, 
      
0.971684, 0.97379, 0.975895, 0.978, 0.979053, 0.980526, 0.985789, 0.991263, 0.997579, 1.00421, 1.01158, 1.01832, 1.0241, 1.02989, 1.03568, 1.17126, 1.39337, 1.72526, 2.10421, 2.46632, 
      
2.82421, 3.30526, 3.8, 0, 0, 0.009626, 0.114333, 0.226866, 0.383749, 0.522165, 0.59697, 0.663048, 0.708762, 0.751749, 0.79019, 0.81897, 0.835939, 0.852182, 0.867766, 0.880649, 
      
0.891732, 0.899775, 0.906355, 0.912935, 0.919515, 0.925524, 0.931411, 0.934649, 0.937593, 0.940537, 0.943593, 0.948788, 0.953983, 0.959177, 0.963333, 0.963333, 0.963333, 0.963333, 0.963576, 0.964268, 
      
0.964667, 0.964667, 0.964667, 0.964667, 0.964667, 0.964667, 0.964667, 0.964667, 0.964667, 0.964667, 0.966468, 0.968719, 0.97097, 0.973221, 0.973333, 0.973333, 0.973333, 0.973558, 0.97581, 0.978061, 
      
0.980312, 0.982173, 0.982866, 0.985022, 0.990216, 0.995688, 1.00158, 1.00779, 1.01437, 1.02038, 1.02592, 1.03146, 1.037, 1.19673, 1.42253, 1.77394, 2.16182, 2.5232, 2.87991, 3.36796, 
      
3.86667, 0, 0, 0.007394, 0.117537, 0.232359, 0.389282, 0.53359, 0.60641, 0.673282, 0.716359, 0.757897, 0.79482, 0.825487, 0.841556, 0.857385, 0.872769, 0.886239, 0.896838, 0.905282, 
      
0.911094, 0.916906, 0.922718, 0.928342, 0.933812, 0.937641, 0.940376, 0.943111, 0.945846, 0.950256, 0.955385, 0.960513, 0.965641, 0.966667, 0.966667, 0.966667, 0.966667, 0.966974, 0.967316, 0.967333, 
      
0.967333, 0.967333, 0.967333, 0.967333, 0.967333, 0.967333, 0.967333, 0.967333, 0.967812, 0.970205, 0.972598, 0.974992, 0.976667, 0.976667, 0.976667, 0.976667, 0.977624, 0.980017, 0.98241, 0.984803, 
      
0.986171, 0.986513, 0.989487, 0.994615, 0.999949, 1.00542, 1.01111, 1.01692, 1.02238, 1.02768, 1.03297, 1.03827, 1.22285, 1.45226, 1.82376, 2.22034, 2.58, 2.93555, 3.43077, 3.93333, 
      
0, 0, 0.004886, 0.120329, 0.237848, 0.39481, 0.545316, 0.616203, 0.684051, 0.724557, 0.76443, 0.799873, 0.832278, 0.847468, 0.862658, 0.877848, 0.892025, 0.902152, 0.911139, 0.916203, 
      
0.921266, 0.926329, 0.931392, 0.936456, 0.940759, 0.943291, 0.945823, 0.948354, 0.951772, 0.956835, 0.961899, 0.966962, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 
      
0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.971519, 0.974051, 0.976582, 0.979114, 0.98, 0.98, 0.98, 0.98, 0.981772, 0.984304, 0.986835, 0.989367, 
      
0.99, 0.99, 0.993924, 0.998987, 1.00405, 1.00911, 1.01418, 1.01924, 1.0243, 1.02937, 1.03443, 1.03949, 1.24962, 1.48253, 1.87468, 2.27975, 2.63671, 2.99114, 3.49367, 4, 
      
0, 0, 0.00381, 0.122857, 0.241905, 0.395238, 0.548571, 0.617381, 0.68619, 0.725714, 0.765238, 0.799524, 0.833809, 0.848571, 0.863333, 0.877857, 0.892381, 0.902143, 0.911905, 0.916905, 
      
0.921905, 0.926786, 0.931667, 0.936548, 0.941429, 0.944048, 0.946667, 0.949286, 0.951905, 0.956905, 0.961905, 0.966667, 0.971429, 0.971429, 0.971429, 0.971429, 0.971429, 0.971429, 0.971429, 0.971429, 
      
0.971429, 0.971429, 0.971429, 0.971429, 0.971429, 0.971429, 0.971429, 0.971429, 0.971429, 0.97381, 0.976191, 0.978571, 0.980952, 0.980952, 0.980952, 0.980952, 0.980952, 0.983333, 0.985714, 0.988095, 
      
0.990476, 0.990476, 0.990476, 0.995238, 1, 1.00476, 1.00952, 1.01429, 1.01905, 1.02381, 1.02857, 1.03333, 1.03809, 1.25714, 1.47619, 1.85714, 2.2381, 2.57143, 2.90476, 3.38095, 
      
3.85714, 0, 0, 0, 0.125118, 0.247681, 0.396114, 0.545908, 0.618918, 0.685703, 0.72709, 0.765655, 0.799488, 0.832645, 0.849812, 0.864156, 0.878113, 0.891987, 0.902287, 0.911693, 
      
0.917637, 0.922575, 0.927337, 0.93204, 0.936743, 0.941446, 0.94475, 0.947454, 0.950159, 0.952863, 0.957019, 0.961958, 0.966602, 0.97107, 0.972857, 0.972857, 0.972857, 0.972857, 0.972857, 0.972857, 
      
0.972857, 0.972857, 0.972857, 0.972857, 0.972857, 0.972857, 0.972857, 0.972857, 0.972857, 0.972857, 0.973751, 0.975985, 0.978219, 0.980453, 0.981905, 0.981905, 0.981905, 0.981905, 0.982575, 0.984809, 
      
0.987043, 0.989277, 0.990952, 0.990952, 0.991958, 0.996426, 1.00089, 1.00536, 1.00983, 1.0143, 1.01876, 1.02323, 1.0277, 1.03217, 1.05674, 1.26227, 1.47919, 1.83663, 2.19183, 2.50459, 
      
2.82069, 3.26749, 3.71429, 0, 0, 0, 0.127122, 0.253115, 0.397422, 0.543763, 0.620801, 0.68561, 0.728676, 0.766307, 0.799756, 0.831812, 0.851185, 0.865122, 0.878606, 0.891847, 
      
0.902578, 0.911638, 0.918397, 0.923275, 0.927979, 0.932509, 0.937038, 0.941568, 0.945401, 0.948188, 0.950976, 0.953763, 0.957178, 0.962056, 0.96676, 0.970941, 0.974286, 0.974286, 0.974286, 0.974286, 
      
0.974286, 0.974286, 0.974286, 0.974286, 0.974286, 0.974286, 0.974286, 0.974286, 0.974286, 0.974286, 0.974286, 0.974286, 0.974286, 0.975958, 0.978049, 0.980139, 0.98223, 0.982857, 0.982857, 0.982857, 
      
0.982857, 0.984112, 0.986202, 0.988293, 0.990383, 0.991429, 0.991429, 0.99331, 0.997491, 1.00167, 1.00585, 1.01004, 1.01422, 1.0184, 1.02258, 1.02676, 1.03094, 1.07275, 1.26509, 1.47875, 
      
1.81324, 2.14355, 2.43624, 2.73519, 3.15331, 3.57143, 0, 0, 0, 0.128878, 0.258218, 0.399145, 0.542117, 0.623018, 0.685898, 0.730465, 0.767183, 0.800316, 0.831297, 0.852685, 
      
0.866225, 0.879329, 0.891951, 0.903012, 0.911733, 0.919185, 0.924005, 0.928709, 0.933069, 0.93743, 0.94179, 0.946001, 0.94887, 0.951738, 0.954607, 0.957476, 0.962197, 0.967017, 0.971033, 0.974934, 
      
0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.975714, 0.976104, 0.978055, 0.980006, 0.981956, 
      
0.98381, 0.98381, 0.98381, 0.98381, 0.98381, 0.985565, 0.987516, 0.989466, 0.991417, 0.991905, 0.991905, 0.994538, 0.998439, 1.00234, 1.00624, 1.01014, 1.01405, 1.01795, 1.02185, 1.02575, 
      
1.02965, 1.08622, 1.26568, 1.47499, 1.78709, 2.09334, 2.36644, 2.64831, 3.03844, 3.42857, 0, 0, 0, 0.130395, 0.263002, 0.40127, 0.540952, 0.625556, 0.686553, 0.732449, 
      
0.768277, 0.801156, 0.831088, 0.854308, 0.86746, 0.880272, 0.89229, 0.903583, 0.911973, 0.92, 0.924762, 0.929524, 0.933719, 0.937914, 0.942109, 0.946304, 0.949501, 0.952449, 0.955397, 0.958345, 
      
0.962381, 0.967143, 0.971338, 0.974966, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 0.977143, 
      
0.977143, 0.978231, 0.980045, 0.981859, 0.983673, 0.984762, 0.984762, 0.984762, 0.984762, 0.985125, 0.986939, 0.988753, 0.990567, 0.992381, 0.992381, 0.992381, 0.995646, 0.999274, 1.0029, 1.00653, 
      
1.01016, 1.01379, 1.01742, 1.02104, 1.02467, 1.0283, 1.09723, 1.26413, 1.46803, 1.75828, 2.04127, 2.29524, 2.56009, 2.9229, 3.28571, 0, 0, 0, 0.131681, 0.267479, 
      
0.403781, 0.540252, 0.628403, 0.687563, 0.734622, 0.76958, 0.802269, 0.831176, 0.85605, 0.868824, 0.881429, 0.892857, 0.904286, 0.912353, 0.92042, 0.925546, 0.930252, 0.934454, 0.938487, 0.942521, 
      
0.946555, 0.950084, 0.953109, 0.956134, 0.95916, 0.962605, 0.967311, 0.971849, 0.97521, 0.978571, 0.978571, 0.978571, 0.978571, 0.978571, 0.978571, 0.978571, 0.978571, 0.978571, 0.978571, 0.978571, 
      
0.978571, 0.978571, 0.978571, 0.978571, 0.978571, 0.978571, 0.978571, 0.980252, 0.981933, 0.983613, 0.985294, 0.985714, 0.985714, 0.985714, 0.985714, 0.986555, 0.988235, 0.989916, 0.991597, 0.992857, 
      
0.992857, 0.993277, 0.996639, 1, 1.00336, 1.00672, 1.01008, 1.01345, 1.01681, 1.02017, 1.02353, 1.02689, 1.10588, 1.2605, 1.45798, 1.72689, 1.9874, 2.22269, 2.47059, 2.80672, 
      
3.14286, 0, 0, 0, 0.132744, 0.271659, 0.406667, 0.54, 0.63155, 0.688915, 0.736977, 0.771085, 0.803643, 0.83155, 0.857907, 0.87031, 0.882713, 0.893643, 0.904496, 0.912868, 
      
0.92062, 0.926357, 0.931008, 0.935271, 0.939147, 0.943023, 0.946899, 0.95062, 0.953721, 0.956822, 0.959922, 0.963023, 0.967519, 0.972171, 0.975659, 0.97876, 0.98, 0.98, 0.98, 0.98, 
      
0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98062, 0.982171, 0.983721, 0.985271, 0.986667, 0.986667, 0.986667, 
      
0.986667, 0.986667, 0.987907, 0.989457, 0.991008, 0.992558, 0.993333, 0.993333, 0.994419, 0.997519, 1.00062, 1.00372, 1.00682, 1.00992, 1.01302, 1.01612, 1.01923, 1.02233, 1.02543, 1.11225, 
      
1.25488, 1.44496, 1.69302, 1.93178, 2.14884, 2.37984, 2.68992, 3, 0, 0, 0, 0.133593, 0.275552, 0.409912, 0.540181, 0.634986, 0.690597, 0.739507, 0.772786, 0.805271, 
      
0.8322, 0.85913, 0.871916, 0.883957, 0.894641, 0.904932, 0.913514, 0.920958, 0.927192, 0.93179, 0.936169, 0.939891, 0.943612, 0.947334, 0.951056, 0.954286, 0.95746, 0.960635, 0.96381, 0.967767, 
      
0.972365, 0.976305, 0.979152, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 0.981429, 
      
0.981429, 0.982567, 0.98399, 0.985413, 0.986836, 0.987619, 0.987619, 0.987619, 0.987619, 0.987761, 0.989184, 0.990608, 0.992031, 0.993454, 0.99381, 0.99381, 0.995446, 0.998292, 1.00114, 1.00399, 
      
1.00683, 1.00968, 1.01252, 1.01537, 1.01822, 1.02106, 1.02391, 1.11641, 1.24733, 1.42906, 1.65676, 1.87449, 2.07373, 2.2879, 2.57252, 2.85714, 0, 0, 0, 0.134234, 
      
0.279169, 0.413506, 0.540779, 0.638701, 0.692597, 0.742208, 0.774675, 0.807143, 0.833117, 0.859091, 0.873636, 0.885325, 0.895844, 0.905584, 0.914286, 0.921429, 0.928052, 0.932597, 0.937143, 0.940714, 
      
0.944286, 0.947857, 0.951429, 0.954805, 0.958052, 0.961299, 0.964545, 0.968052, 0.972597, 0.977143, 0.97974, 0.982338, 0.982857, 0.982857, 0.982857, 0.982857, 0.982857, 0.982857, 0.982857, 0.982857, 
      
0.982857, 0.982857, 0.982857, 0.982857, 0.982857, 0.982857, 0.982857, 0.982857, 0.982857, 0.983117, 0.984416, 0.985714, 0.987013, 0.988312, 0.988571, 0.988571, 0.988571, 0.988571, 0.989091, 0.99039, 
      
0.991688, 0.992987, 0.994286, 0.994286, 0.994286, 0.996364, 0.998961, 1.00156, 1.00416, 1.00675, 1.00935, 1.01195, 1.01454, 1.01714, 1.01974, 1.02234, 1.11844, 1.23792, 1.41039, 1.61818, 
      
1.81559, 1.9974, 2.1948, 2.45455, 2.71429, 0, 0, 0, 0.134674, 0.282518, 0.417437, 0.541782, 0.642686, 0.694906, 0.745072, 0.776747, 0.808422, 0.834291, 0.859331, 0.875468, 
      
0.886811, 0.897245, 0.906447, 0.915179, 0.922028, 0.928876, 0.93343, 0.937924, 0.941616, 0.94504, 0.948464, 0.951889, 0.955281, 0.958598, 0.961915, 0.965233, 0.96855, 0.972868, 0.977362, 0.980519, 
      
0.982873, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984286, 0.984992, 
      
0.986169, 0.987346, 0.988523, 0.989524, 0.989524, 0.989524, 0.989524, 0.989524, 0.990348, 0.991525, 0.992702, 0.993879, 0.994762, 0.994762, 0.994821, 0.997175, 0.999529, 1.00188, 1.00424, 1.00659, 
      
1.00895, 1.0113, 1.01365, 1.01601, 1.01836, 1.02072, 1.11842, 1.22671, 1.38903, 1.57737, 1.75511, 1.9199, 2.10059, 2.33601, 2.57143, 0, 0, 0, 0.134921, 0.285608, 
      
0.421693, 0.543175, 0.646931, 0.697513, 0.748095, 0.778995, 0.809894, 0.835714, 0.859841, 0.877407, 0.888413, 0.898836, 0.907513, 0.91619, 0.922751, 0.929312, 0.934286, 0.93873, 0.942593, 0.945873, 
      
0.949153, 0.952434, 0.955714, 0.959101, 0.962487, 0.965873, 0.969259, 0.973175, 0.977619, 0.981481, 0.983598, 0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 
      
0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 0.985714, 0.986772, 0.987831, 0.988889, 0.989947, 0.990476, 0.990476, 0.990476, 0.990476, 0.990476, 0.991534, 
      
0.992593, 0.993651, 0.994709, 0.995238, 0.995238, 0.995767, 0.997884, 1, 1.00212, 1.00423, 1.00635, 1.00847, 1.01058, 1.0127, 1.01481, 1.01693, 1.01905, 1.1164, 1.21376, 1.36508, 
      
1.53439, 1.69312, 1.84127, 2.00529, 2.21693, 2.42857, 0, 0, 0, 0.13498, 0.288449, 0.426264, 0.544945, 0.651429, 0.700408, 0.749388, 0.781413, 0.811554, 0.837378, 0.860612, 
      
0.879451, 0.890126, 0.900612, 0.908776, 0.916939, 0.923595, 0.929874, 0.935165, 0.93956, 0.943642, 0.946782, 0.949921, 0.953061, 0.956201, 0.95956, 0.963014, 0.966468, 0.969922, 0.973516, 0.977912, 
      
0.982308, 0.984505, 0.986389, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 0.987143, 
      
0.987143, 0.98752, 0.988462, 0.989403, 0.990345, 0.991287, 0.991429, 0.991429, 0.991429, 0.991429, 0.991711, 0.992653, 0.993595, 0.994537, 0.995479, 0.995714, 0.995714, 0.996609, 0.998493, 1.00038, 
      
1.00226, 1.00414, 1.00603, 1.00791, 1.0098, 1.01168, 1.01356, 1.01545, 1.02581, 1.11247, 1.19912, 1.33862, 1.48933, 1.62967, 1.76154, 1.90895, 2.09733, 2.28571, 0, 0, 
      
0, 0.134857, 0.291048, 0.431139, 0.547081, 0.65617, 0.703582, 0.750994, 0.783996, 0.813395, 0.839275, 0.861636, 0.881594, 0.891946, 0.902298, 0.910228, 0.917888, 0.924555, 0.930559, 0.936066, 
      
0.940414, 0.944762, 0.947764, 0.950766, 0.953768, 0.95677, 0.959979, 0.963499, 0.967019, 0.970538, 0.974058, 0.97824, 0.982588, 0.98559, 0.987246, 0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 
      
0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 0.988571, 0.989234, 0.990062, 0.99089, 0.991718, 0.992381, 0.992381, 
      
0.992381, 0.992381, 0.992381, 0.992878, 0.993706, 0.994534, 0.995362, 0.99619, 0.99619, 0.99619, 0.99735, 0.999006, 1.00066, 1.00232, 1.00398, 1.00563, 1.00729, 1.00894, 1.0106, 1.01226, 
      
1.01391, 1.03048, 1.10667, 1.18286, 1.30973, 1.44224, 1.5648, 1.68075, 1.81159, 1.97722, 2.14286, 0, 0, 0, 0.134559, 0.293412, 0.436308, 0.54957, 0.661147, 0.707025, 
      
0.752903, 0.786738, 0.815412, 0.841398, 0.862903, 0.883835, 0.893871, 0.903907, 0.911864, 0.919032, 0.925627, 0.931362, 0.936989, 0.94129, 0.945591, 0.948817, 0.951685, 0.954552, 0.957419, 0.960358, 
      
0.963943, 0.967527, 0.971111, 0.974695, 0.978602, 0.982903, 0.986846, 0.98828, 0.989713, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 
      
0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.990143, 0.99086, 0.991577, 0.992294, 0.993011, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993979, 0.994695, 0.995412, 
      
0.996129, 0.996667, 0.996667, 0.996667, 0.997993, 0.999427, 1.00086, 1.00229, 1.00373, 1.00516, 1.0066, 1.00803, 1.00946, 1.0109, 1.01233, 1.03312, 1.09907, 1.16502, 1.27849, 1.39319, 
      
1.49857, 1.59892, 1.71326, 1.85663, 2, 0, 0, 0, 0.134091, 0.29555, 0.441763, 0.552401, 0.66304, 0.710729, 0.755106, 0.789635, 0.817599, 0.843739, 0.864407, 0.885076, 
      
0.895897, 0.905623, 0.913678, 0.920365, 0.926808, 0.93228, 0.937751, 0.942189, 0.946444, 0.949939, 0.952675, 0.95541, 0.958146, 0.960881, 0.964347, 0.967994, 0.971641, 0.975289, 0.978997, 0.983252, 
      
0.987508, 0.989483, 0.990699, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 0.991429, 
      
0.991429, 0.991429, 0.991793, 0.992401, 0.993009, 0.993617, 0.994225, 0.994286, 0.994286, 0.994286, 0.994286, 0.994407, 0.995015, 0.995623, 0.996231, 0.996839, 0.997143, 0.997143, 0.997325, 0.998541, 
      
0.999757, 1.00097, 1.00219, 1.0034, 1.00462, 1.00584, 1.00705, 1.00827, 1.00948, 1.0107, 1.0338, 1.08973, 1.14772, 1.24498, 1.34225, 1.431, 1.51611, 1.61398, 1.73556, 1.85714, 
      
0, 0, 0, 0.133459, 0.297469, 0.447494, 0.555564, 0.663634, 0.714687, 0.757594, 0.792682, 0.81995, 0.846291, 0.86614, 0.88599, 0.89802, 0.907444, 0.915664, 0.92188, 0.928095, 
      
0.933308, 0.938521, 0.943108, 0.947318, 0.951128, 0.953734, 0.956341, 0.958947, 0.961554, 0.964712, 0.968421, 0.97213, 0.97584, 0.979549, 0.983634, 0.987845, 0.990852, 0.991855, 0.992857, 0.992857, 
      
0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.992857, 0.993358, 0.99386, 
      
0.994361, 0.994862, 0.995238, 0.995238, 0.995238, 0.995238, 0.995238, 0.995489, 0.99599, 0.996491, 0.996992, 0.997494, 0.997619, 0.997619, 0.997995, 0.998998, 1, 1.001, 1.002, 1.00301, 
      
1.00401, 1.00501, 1.00601, 1.00702, 1.00802, 1.00902, 1.03258, 1.0787, 1.12907, 1.20927, 1.28947, 1.36215, 1.43233, 1.51378, 1.61404, 1.71429, 0, 0, 0, 0.132667, 
      
0.299175, 0.453492, 0.559048, 0.664603, 0.718889, 0.760357, 0.795873, 0.82246, 0.849048, 0.868095, 0.887143, 0.900238, 0.909365, 0.917817, 0.923571, 0.929325, 0.934444, 0.939405, 0.944048, 0.948214, 
      
0.952381, 0.954861, 0.957341, 0.959821, 0.962302, 0.96504, 0.96881, 0.972579, 0.976349, 0.980119, 0.984048, 0.988214, 0.992381, 0.993175, 0.993968, 0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 
      
0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 0.994286, 0.994444, 0.994841, 0.995238, 0.995635, 0.996032, 0.99619, 
      
0.99619, 0.99619, 0.99619, 0.99619, 0.996508, 0.996905, 0.997302, 0.997698, 0.998095, 0.998095, 0.998095, 0.998571, 0.999365, 1.00016, 1.00095, 1.00175, 1.00254, 1.00333, 1.00413, 1.00492, 
      
1.00571, 1.00651, 1.0073, 1.02952, 1.06603, 1.10794, 1.17143, 1.23492, 1.29206, 1.34762, 1.4127, 1.49206, 1.57143, 0, 0, 0, 0.13172, 0.300675, 0.45975, 0.562842, 
      
0.665935, 0.723328, 0.763387, 0.799205, 0.825125, 0.851046, 0.870265, 0.888527, 0.902548, 0.911384, 0.920133, 0.925434, 0.930736, 0.935685, 0.940398, 0.945007, 0.949131, 0.953255, 0.956053, 0.958409, 
      
0.960766, 0.963122, 0.965479, 0.969161, 0.97299, 0.976819, 0.980648, 0.984492, 0.988616, 0.992739, 0.994654, 0.995243, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 
      
0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.995714, 0.99595, 0.996244, 0.996539, 0.996834, 0.997128, 0.997143, 0.997143, 0.997143, 
      
0.997143, 0.997172, 0.997467, 0.997761, 0.998056, 0.998351, 0.998571, 0.998571, 0.998571, 0.999057, 0.999647, 1.00024, 1.00083, 1.00141, 1.002, 1.00259, 1.00318, 1.00377, 1.00436, 1.00495, 
      
1.00554, 1.02468, 1.05178, 1.08439, 1.13152, 1.17865, 1.22077, 1.262, 1.31075, 1.36966, 1.42857, 0, 0, 0, 0.130624, 0.301975, 0.466258, 0.566939, 0.667619, 0.727998, 
      
0.766676, 0.802673, 0.82794, 0.853207, 0.872643, 0.890136, 0.904947, 0.913499, 0.922051, 0.927464, 0.932323, 0.937026, 0.941497, 0.945967, 0.950068, 0.95415, 0.957308, 0.959543, 0.961778, 0.964014, 
      
0.966249, 0.969475, 0.973363, 0.97725, 0.981137, 0.985024, 0.989048, 0.993129, 0.996288, 0.996676, 0.997065, 0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 
      
0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 0.997143, 0.997182, 0.997376, 0.99757, 0.997765, 0.997959, 0.998095, 0.998095, 0.998095, 0.998095, 0.998095, 
      
0.998173, 0.998367, 0.998562, 0.998756, 0.99895, 0.999048, 0.999048, 0.999067, 0.999456, 0.999844, 1.00023, 1.00062, 1.00101, 1.0014, 1.00179, 1.00218, 1.00257, 1.00295, 1.00334, 1.00373, 
      
1.01812, 1.036, 1.0585, 1.0896, 1.1207, 1.1483, 1.17551, 1.20797, 1.24684, 1.28571, 0, 0, 0, 0.129382, 0.303081, 0.473011, 0.571328, 0.669644, 0.732891, 0.770216, 
      
0.806272, 0.830899, 0.855527, 0.875224, 0.891962, 0.907431, 0.915705, 0.923978, 0.929654, 0.934079, 0.938466, 0.942698, 0.946931, 0.951024, 0.955065, 0.958624, 0.960741, 0.962857, 0.964974, 0.96709, 
      
0.969755, 0.973699, 0.977643, 0.981587, 0.985532, 0.989509, 0.99355, 0.99759, 0.998264, 0.998456, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 
      
0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998571, 0.998629, 0.998725, 0.998822, 0.998918, 0.999014, 0.999048, 0.999048, 0.999048, 0.999048, 0.999048, 
      
0.999115, 0.999211, 0.999307, 0.999404, 0.9995, 0.999524, 0.999524, 0.999577, 0.999769, 0.999961, 1.00015, 1.00035, 1.00054, 1.00073, 1.00092, 1.00112, 1.00131, 1.0015, 1.00169, 1.00189, 
      
1.00987, 1.01872, 1.03035, 1.04574, 1.06114, 1.0747, 1.08817, 1.10438, 1.12362, 1.14286, 0, 0.001, 0.027, 0.128, 0.304, 0.48, 0.576, 0.672, 0.738, 0.774, 
      
0.81, 0.834, 0.858, 0.878, 0.894, 0.91, 0.918, 0.926, 0.932, 0.936, 0.94, 0.944, 0.948, 0.952, 0.956, 0.96, 0.962, 0.964, 0.966, 0.968, 
      
0.97, 0.974, 0.978, 0.982, 0.986, 0.99, 0.994, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0.000843, 0.058009, 0.144263, 0.299248, 0.454232, 0.571285, 0.650408, 0.72953, 
      
0.771505, 0.801097, 0.83069, 0.85, 0.86931, 0.886959, 0.899624, 0.912288, 0.92163, 0.927649, 0.933668, 0.9379, 0.941536, 0.945172, 0.948809, 0.952445, 0.956238, 0.960502, 0.964765, 0.967649, 
      
0.969154, 0.970658, 0.972163, 0.973668, 0.975172, 0.978182, 0.981191, 0.984201, 0.98721, 0.990219, 0.993229, 0.996238, 0.999248, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0.000723, 0.076571, 0.171034, 0.308506, 0.445977, 0.583448, 
      
0.648506, 0.713563, 0.778621, 0.802874, 0.827126, 0.851379, 0.866782, 0.882184, 0.897586, 0.907471, 0.917356, 0.927241, 0.931609, 0.935977, 0.940345, 0.943678, 0.947012, 0.950345, 0.953678, 0.957012, 
      
0.960345, 0.964828, 0.96931, 0.973793, 0.974885, 0.975977, 0.977069, 0.978161, 0.979253, 0.980345, 0.982529, 0.984713, 0.986897, 0.98908, 0.991264, 0.993448, 0.995632, 0.997816, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0.000632, 0.085557, 0.206353, 
      
0.328541, 0.451194, 0.573846, 0.661751, 0.714907, 0.768064, 0.812865, 0.832599, 0.852334, 0.872069, 0.884164, 0.89626, 0.908355, 0.917029, 0.924562, 0.932095, 0.937347, 0.940318, 0.943289, 0.946286, 
      
0.949363, 0.95244, 0.955517, 0.958594, 0.961671, 0.964748, 0.969019, 0.973687, 0.978355, 0.981061, 0.981804, 0.982546, 0.983289, 0.984032, 0.984775, 0.985517, 0.987003, 0.988488, 0.989973, 0.991459, 
      
0.992944, 0.99443, 0.995915, 0.997401, 0.998886, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0.000565, 0.08702, 0.230386, 0.357044, 0.466995, 0.576946, 0.686897, 0.729852, 0.772808, 0.815764, 0.845172, 0.861035, 0.876897, 0.892759, 0.90202, 0.911281, 0.920542, 0.927931, 0.933448, 
      
0.938965, 0.944483, 0.946256, 0.94803, 0.949803, 0.952118, 0.954975, 0.957833, 0.96069, 0.963547, 0.966404, 0.969261, 0.973103, 0.977931, 0.982759, 0.987586, 0.98803, 0.988473, 0.988916, 0.98936, 
      
0.989803, 0.990246, 0.99069, 0.991576, 0.992463, 0.99335, 0.994236, 0.995123, 0.99601, 0.996897, 0.997783, 0.99867, 0.999557, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0.000515, 0.082464, 0.245391, 0.392322, 0.491264, 0.590207, 0.689149, 0.755678, 0.789793, 0.823908, 0.858023, 0.875931, 0.888437, 0.900943, 
      
0.913448, 0.920253, 0.927057, 0.933862, 0.939908, 0.943678, 0.947448, 0.951218, 0.953471, 0.954207, 0.954943, 0.955678, 0.957862, 0.960529, 0.963195, 0.965862, 0.968529, 0.971195, 0.973862, 0.977103, 
      
0.982069, 0.987034, 0.992, 0.994575, 0.994759, 0.994942, 0.995126, 0.99531, 0.995494, 0.995678, 0.995862, 0.99623, 0.996598, 0.996966, 0.997333, 0.997701, 0.998069, 0.998437, 0.998805, 0.999172, 
      
0.99954, 0.999908, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0.000964, 0.073889, 0.251468, 0.429048, 0.517857, 0.606667, 0.695476, 0.784286, 
      
0.81119, 0.838095, 0.865, 0.891905, 0.901667, 0.911429, 0.921191, 0.930952, 0.935833, 0.940714, 0.945595, 0.950476, 0.952976, 0.955476, 0.957976, 0.960476, 0.960595, 0.960714, 0.960833, 0.960952, 
      
0.963452, 0.965952, 0.968452, 0.970952, 0.973452, 0.975952, 0.978452, 0.980952, 0.985714, 0.990476, 0.995238, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0.002555, 
      
0.066513, 0.247745, 0.428978, 0.532773, 0.610756, 0.688739, 0.766723, 0.816975, 0.839496, 0.862017, 0.884538, 0.903445, 0.911513, 0.91958, 0.927647, 0.935714, 0.939748, 0.943781, 0.947815, 0.951849, 
      
0.954622, 0.956975, 0.959328, 0.961681, 0.963193, 0.963866, 0.964538, 0.96521, 0.966303, 0.968655, 0.971008, 0.973361, 0.975714, 0.978067, 0.98042, 0.982773, 0.985126, 0.988235, 0.991597, 0.994958, 
      
0.998319, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0.002974, 0.058325, 0.242804, 0.427284, 0.553704, 0.622063, 0.690423, 0.758783, 0.827143, 0.845767, 0.864392, 0.883016, 0.90164, 
      
0.914233, 0.920794, 0.927355, 0.933915, 0.940476, 0.943757, 0.947037, 0.950317, 0.953598, 0.956349, 0.958571, 0.960794, 0.963016, 0.965238, 0.966402, 0.967566, 0.96873, 0.969894, 0.971587, 0.97381, 
      
0.976032, 0.978254, 0.980476, 0.982698, 0.984921, 0.987143, 0.989365, 0.991534, 0.993651, 0.995767, 0.997884, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0.002406, 0.049453, 0.236838, 0.424223, 
      
0.579699, 0.639449, 0.699198, 0.758947, 0.818697, 0.85614, 0.871278, 0.886416, 0.901554, 0.916692, 0.924386, 0.929599, 0.934812, 0.940025, 0.945238, 0.947845, 0.950451, 0.953058, 0.955664, 0.958145, 
      
0.960251, 0.962356, 0.964461, 0.966566, 0.968421, 0.970025, 0.971629, 0.973233, 0.974837, 0.976817, 0.978922, 0.981028, 0.983133, 0.985238, 0.987343, 0.989449, 0.991554, 0.993659, 0.995489, 0.996491, 
      
0.997494, 0.998496, 0.999499, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0.001, 0.04, 0.23, 0.42, 0.61, 0.662, 0.714, 0.766, 0.818, 0.87, 0.882, 0.894, 0.906, 0.918, 
      
0.93, 0.934, 0.938, 0.942, 0.946, 0.95, 0.952, 0.954, 0.956, 0.958, 0.96, 0.962, 0.964, 0.966, 0.968, 0.97, 0.972, 0.974, 0.976, 0.978, 
      
0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0.051179, 0.219729, 
      
0.401229, 0.582729, 0.663522, 0.710747, 0.757972, 0.805197, 0.852422, 0.88142, 0.892192, 0.902964, 0.913736, 0.924507, 0.933539, 0.937348, 0.941158, 0.944967, 0.948777, 0.952586, 0.954655, 0.956724, 
      
0.958793, 0.960862, 0.962931, 0.964754, 0.966494, 0.968235, 0.969975, 0.971716, 0.973457, 0.975197, 0.976938, 0.978678, 0.980419, 0.982159, 0.9839, 0.98564, 0.987381, 0.989121, 0.990862, 0.992603, 
      
0.994343, 0.996084, 0.997824, 0.999565, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0.059994, 0.211776, 0.385549, 0.559321, 0.667649, 0.710533, 0.753417, 0.796301, 0.839185, 0.882069, 
      
0.891724, 0.901379, 0.911035, 0.92069, 0.930345, 0.936991, 0.940627, 0.944263, 0.9479, 0.951536, 0.955172, 0.957304, 0.959436, 0.961567, 0.963699, 0.965831, 0.967649, 0.969154, 0.970658, 0.972163, 
      
0.973668, 0.975172, 0.976677, 0.978182, 0.979687, 0.981191, 0.982696, 0.984201, 0.985705, 0.98721, 0.988715, 0.990219, 0.991724, 0.993229, 0.994734, 0.996238, 0.997743, 0.999248, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0.066753, 0.20584, 0.372556, 0.539273, 0.67404, 0.712961, 0.751882, 0.790802, 0.829723, 0.868643, 0.892421, 0.901057, 0.909693, 0.918328, 0.926964, 0.9356, 0.940367, 
      
0.943846, 0.947324, 0.950802, 0.95428, 0.957759, 0.959948, 0.962136, 0.964325, 0.966514, 0.968703, 0.970667, 0.971956, 0.973246, 0.974535, 0.975825, 0.977114, 0.978403, 0.979693, 0.980982, 0.982271, 
      
0.983561, 0.98485, 0.986139, 0.987429, 0.988718, 0.990008, 0.991297, 0.992586, 0.993876, 0.995165, 0.996454, 0.997744, 0.999033, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0.071713, 0.201667, 0.361916, 
      
0.522165, 0.682414, 0.717701, 0.752989, 0.788276, 0.823563, 0.858851, 0.894138, 0.901839, 0.90954, 0.917241, 0.924942, 0.932644, 0.940345, 0.943678, 0.947011, 0.950345, 0.953678, 0.957012, 0.960345, 
      
0.962586, 0.964828, 0.967069, 0.96931, 0.971552, 0.973793, 0.974885, 0.975977, 0.977069, 0.978161, 0.979253, 0.980345, 0.981437, 0.982529, 0.983621, 0.984713, 0.985805, 0.986897, 0.987989, 0.98908, 
      
0.990172, 0.991264, 0.992356, 0.993448, 0.99454, 0.995632, 0.996724, 0.997816, 0.998908, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0.07509, 0.199046, 0.353345, 0.507644, 0.661943, 0.724476, 0.756421, 0.788365, 
      
0.82031, 0.852255, 0.8842, 0.903593, 0.910434, 0.917276, 0.924117, 0.930959, 0.9378, 0.943731, 0.946931, 0.950131, 0.953331, 0.956531, 0.959731, 0.962931, 0.965221, 0.96751, 0.9698, 0.97209, 
      
0.974379, 0.976669, 0.977924, 0.978835, 0.979745, 0.980655, 0.981566, 0.982476, 0.983386, 0.984297, 0.985207, 0.986117, 0.987028, 0.987938, 0.988848, 0.989759, 0.990669, 0.991579, 0.99249, 0.9934, 
      
0.99431, 0.995221, 0.996131, 0.997041, 0.997952, 0.998862, 0.999772, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0.077066, 0.197798, 0.346605, 0.495411, 0.644217, 0.73305, 0.76191, 0.790769, 0.819629, 0.848488, 0.877347, 0.906207, 
      
0.912255, 0.918302, 0.92435, 0.930398, 0.936446, 0.942493, 0.947056, 0.950133, 0.95321, 0.956286, 0.959363, 0.96244, 0.965517, 0.967851, 0.970186, 0.97252, 0.974854, 0.977188, 0.979523, 0.981061, 
      
0.981804, 0.982546, 0.983289, 0.984032, 0.984775, 0.985517, 0.98626, 0.987003, 0.987745, 0.988488, 0.989231, 0.989973, 0.990716, 0.991459, 0.992202, 0.992944, 0.993687, 0.99443, 0.995172, 0.995915, 
      
0.996658, 0.997401, 0.998143, 0.998886, 0.999629, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 0, 0, 0.077798, 0.197771, 0.341492, 0.485213, 0.628934, 0.743225, 0.769227, 0.79523, 0.821232, 0.847235, 0.873238, 0.89924, 0.914898, 0.920211, 0.925524, 
      
0.930836, 0.936149, 0.941462, 0.946775, 0.950326, 0.953289, 0.956252, 0.959215, 0.962178, 0.965141, 0.968103, 0.970479, 0.972854, 0.97523, 0.977605, 0.979981, 0.982356, 0.984285, 0.984872, 0.98546, 
      
0.986047, 0.986635, 0.987222, 0.98781, 0.988397, 0.988985, 0.989572, 0.99016, 0.990747, 0.991335, 0.991922, 0.99251, 0.993097, 0.993685, 0.994272, 0.99486, 0.995447, 0.996035, 0.996622, 0.997209, 
      
0.997797, 0.998384, 0.998972, 0.999559, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0.077419, 0.198834, 0.337833, 0.476831, 0.615829, 0.754828, 0.778177, 0.801527, 0.824877, 0.848227, 0.871576, 0.894926, 0.918276, 0.922906, 0.927537, 0.932167, 0.936798, 
      
0.941429, 0.946059, 0.95069, 0.953547, 0.956404, 0.959261, 0.962118, 0.964975, 0.967833, 0.97069, 0.973103, 0.975517, 0.977931, 0.980345, 0.982759, 0.985172, 0.987586, 0.98803, 0.988473, 0.988916, 
      
0.98936, 0.989803, 0.990246, 0.99069, 0.991133, 0.991576, 0.99202, 0.992463, 0.992906, 0.99335, 0.993793, 0.994236, 0.99468, 0.995123, 0.995567, 0.99601, 0.996453, 0.996897, 0.99734, 0.997783, 
      
0.998227, 0.99867, 0.999113, 0.999557, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0.076043, 0.200874, 0.335476, 0.470077, 0.604679, 0.739281, 0.788591, 0.809471, 0.830351, 0.851231, 0.872111, 0.89299, 0.91387, 0.926308, 0.930303, 0.934298, 0.938294, 0.942289, 
      
0.946284, 0.950279, 0.953966, 0.956724, 0.959483, 0.962241, 0.965, 0.967759, 0.970517, 0.973276, 0.975725, 0.978175, 0.980624, 0.983074, 0.985523, 0.987973, 0.990422, 0.991266, 0.991576, 0.991885, 
      
0.992194, 0.992503, 0.992812, 0.993121, 0.99343, 0.99374, 0.994049, 0.994358, 0.994667, 0.994976, 0.995285, 0.995595, 0.995904, 0.996213, 0.996522, 0.996831, 0.99714, 0.997449, 0.997759, 0.998068, 
      
0.998377, 0.998686, 0.998995, 0.999304, 0.999614, 0.999923, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0.07377, 0.203793, 0.334291, 0.464789, 0.595287, 0.725785, 0.800322, 0.818897, 0.837471, 0.856046, 0.874621, 0.893195, 0.91177, 0.930345, 0.933747, 0.937149, 0.940552, 0.943954, 
      
0.947356, 0.950759, 0.954161, 0.957195, 0.959862, 0.962529, 0.965195, 0.967862, 0.970529, 0.973195, 0.975862, 0.978345, 0.980828, 0.98331, 0.985793, 0.988276, 0.990759, 0.993241, 0.994575, 0.994759, 
      
0.994943, 0.995126, 0.99531, 0.995494, 0.995678, 0.995862, 0.996046, 0.99623, 0.996414, 0.996598, 0.996782, 0.996966, 0.997149, 0.997333, 0.997517, 0.997701, 0.997885, 0.998069, 0.998253, 0.998437, 
      
0.998621, 0.998805, 0.998989, 0.999172, 0.999356, 0.99954, 0.999724, 0.999908, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0.070687, 0.206583, 0.334166, 0.460825, 0.587484, 0.714144, 0.813242, 0.829661, 0.846079, 0.862497, 0.878915, 0.895334, 0.911752, 0.92817, 0.937803, 0.940651, 0.943498, 
      
0.946346, 0.949194, 0.952041, 0.954889, 0.957736, 0.960384, 0.962964, 0.965545, 0.968126, 0.970706, 0.973287, 0.975868, 0.978448, 0.980962, 0.983476, 0.98599, 0.988504, 0.991018, 0.993532, 0.996046, 
      
0.997948, 0.998014, 0.998081, 0.998148, 0.998215, 0.998281, 0.998348, 0.998415, 0.998482, 0.998548, 0.998615, 0.998682, 0.998749, 0.998815, 0.998882, 0.998949, 0.999016, 0.999082, 0.999149, 0.999216, 
      
0.999283, 0.999349, 0.999416, 0.999483, 0.99955, 0.999616, 0.999683, 0.99975, 0.999816, 0.999883, 0.99995, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 0, 0, 0.071707, 0.215, 0.340203, 0.460884, 0.581565, 0.702246, 0.822927, 0.837622, 0.852317, 0.867012, 0.881707, 0.896402, 0.911098, 0.925793, 0.940488, 
      
0.942988, 0.945488, 0.947988, 0.950488, 0.952988, 0.955488, 0.957988, 0.960488, 0.963049, 0.96561, 0.968171, 0.970732, 0.973293, 0.975854, 0.978415, 0.980976, 0.983354, 0.985732, 0.98811, 0.990488, 
      
0.992866, 0.995244, 0.997622, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0.078914, 0.231907, 0.355928, 0.467531, 0.579135, 0.690739, 0.802343, 0.840377, 0.853888, 0.867398, 0.880909, 0.89442, 
      
0.90793, 0.921441, 0.934952, 0.942919, 0.945344, 0.947768, 0.950192, 0.952616, 0.955041, 0.957465, 0.959889, 0.962365, 0.964996, 0.967627, 0.970259, 0.97289, 0.975521, 0.978152, 0.980783, 0.983415, 
      
0.985425, 0.987435, 0.989446, 0.991456, 0.993466, 0.995477, 0.997487, 0.999497, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0.084978, 0.247102, 0.373788, 0.476848, 0.579909, 0.68297, 0.786031, 0.843759, 
      
0.856155, 0.868551, 0.880947, 0.893343, 0.905739, 0.918135, 0.930531, 0.942927, 0.94528, 0.947633, 0.949986, 0.952339, 0.954692, 0.957044, 0.959397, 0.96175, 0.964275, 0.966973, 0.96967, 0.972367, 
      
0.975065, 0.977762, 0.980459, 0.983156, 0.985854, 0.987518, 0.989182, 0.990847, 0.992511, 0.994175, 0.995839, 0.997504, 0.999168, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0.09, 0.260732, 0.3936, 
      
0.488606, 0.583612, 0.678618, 0.773624, 0.847714, 0.859059, 0.870404, 0.881749, 0.893094, 0.904439, 0.915784, 0.927129, 0.938474, 0.945289, 0.947575, 0.949861, 0.952146, 0.954432, 0.956718, 0.959003, 
      
0.961289, 0.963575, 0.966216, 0.968976, 0.971735, 0.974495, 0.977254, 0.980014, 0.982774, 0.985533, 0.988293, 0.989631, 0.990969, 0.992307, 0.993645, 0.994983, 0.996321, 0.997659, 0.998996, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0.094065, 0.272927, 0.415203, 0.502602, 0.59, 0.677398, 0.764797, 0.852195, 0.862547, 0.8729, 0.883252, 0.893604, 0.903957, 0.914309, 0.924661, 0.935014, 0.945366, 
      
0.947588, 0.94981, 0.952033, 0.954255, 0.956477, 0.958699, 0.960921, 0.963144, 0.965366, 0.968184, 0.971003, 0.973821, 0.97664, 0.979458, 0.982276, 0.985095, 0.987913, 0.990732, 0.991762, 0.992791, 
      
0.993821, 0.994851, 0.995881, 0.996911, 0.99794, 0.99897, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0.097251, 0.283804, 0.438451, 0.518653, 0.598855, 0.679057, 0.75926, 0.839462, 0.866572, 0.875986, 
      
0.885399, 0.894812, 0.904225, 0.913639, 0.923052, 0.932465, 0.941879, 0.947666, 0.949829, 0.951991, 0.954153, 0.956315, 0.958477, 0.960639, 0.962802, 0.964964, 0.967304, 0.970178, 0.973052, 0.975926, 
      
0.9788, 0.981674, 0.984548, 0.987423, 0.990297, 0.993171, 0.993909, 0.994647, 0.995386, 0.996124, 0.996862, 0.997601, 0.998339, 0.999077, 0.999815, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0.099628, 0.293466, 
      
0.463214, 0.536598, 0.609983, 0.683368, 0.756752, 0.830137, 0.871091, 0.879615, 0.888139, 0.896662, 0.905186, 0.91371, 0.922234, 0.930757, 0.939281, 0.947805, 0.94991, 0.952015, 0.954121, 0.956226, 
      
0.958331, 0.960436, 0.962542, 0.964647, 0.966752, 0.969268, 0.972195, 0.975122, 0.978049, 0.980976, 0.983902, 0.986829, 0.989756, 0.992683, 0.99561, 0.996072, 0.996534, 0.996996, 0.997458, 0.99792, 
      
0.998383, 0.998845, 0.999307, 0.999769, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0.101257, 0.302007, 0.489375, 0.556291, 0.623208, 0.690125, 0.757042, 0.823959, 0.876066, 0.883746, 0.891426, 0.899106, 0.906785, 
      
0.914465, 0.922145, 0.929825, 0.937505, 0.945184, 0.95005, 0.952101, 0.954153, 0.956204, 0.958255, 0.960306, 0.962358, 0.964409, 0.96646, 0.968512, 0.971257, 0.974234, 0.977211, 0.980188, 0.983164, 
      
0.986141, 0.989118, 0.992095, 0.995072, 0.998049, 0.998249, 0.998449, 0.998649, 0.998849, 0.999049, 0.99925, 0.99945, 0.99965, 0.99985, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0.102718, 0.307816, 0.512913, 
      
0.574191, 0.635469, 0.696748, 0.758026, 0.819304, 0.880583, 0.887563, 0.894544, 0.901524, 0.908505, 0.915485, 0.922466, 0.929447, 0.936427, 0.943408, 0.950388, 0.952408, 0.954427, 0.956447, 0.958466, 
      
0.960485, 0.962505, 0.964524, 0.966544, 0.968563, 0.970583, 0.973524, 0.976466, 0.979408, 0.98235, 0.985291, 0.988233, 0.991175, 0.994116, 0.997058, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0.306851, 0.507419, 0.579576, 0.637465, 0.695355, 0.753244, 0.811134, 0.869023, 0.888532, 0.895247, 0.901963, 
      
0.908679, 0.915394, 0.92211, 0.928825, 0.935541, 0.942257, 0.948972, 0.953363, 0.955427, 0.957492, 0.959557, 0.961622, 0.963687, 0.965752, 0.967817, 0.969882, 0.971947, 0.974142, 0.976727, 0.979313, 
      
0.981899, 0.984485, 0.987071, 0.989657, 0.992243, 0.994828, 0.997414, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      
0, 0.306533, 0.502788, 0.585768, 0.64043, 0.695092, 0.749753, 0.804415, 0.859077, 0.889639, 0.896103, 0.902566, 0.909029, 0.915492, 0.921956, 0.928419, 0.934882, 0.941345, 0.947809, 0.954272, 
      
0.95638, 0.958488, 0.960596, 0.962705, 0.964813, 0.966921, 0.969029, 0.971137, 0.973246, 0.975354, 0.977531, 0.979778, 0.982025, 0.984272, 0.986519, 0.988766, 0.991012, 0.993259, 0.995506, 0.997753, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.306816, 0.498959, 0.592711, 0.644295, 0.695879, 0.747464, 
      
0.799048, 0.850632, 0.890876, 0.897099, 0.903321, 0.909544, 0.915767, 0.921989, 0.928212, 0.934434, 0.940657, 0.94688, 0.953102, 0.957288, 0.959438, 0.961587, 0.963737, 0.965886, 0.968036, 0.970185, 
      
0.972335, 0.974484, 0.976634, 0.978783, 0.980763, 0.982687, 0.984611, 0.986534, 0.988458, 0.990382, 0.992305, 0.994229, 0.996153, 0.998076, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0.307661, 0.495878, 0.600353, 0.649, 0.697646, 0.746293, 0.79494, 0.843586, 0.892233, 0.898226, 0.904219, 0.910212, 
      
0.916205, 0.922198, 0.928191, 0.934184, 0.940177, 0.946169, 0.952162, 0.958155, 0.960344, 0.962533, 0.964722, 0.966911, 0.9691, 0.971289, 0.973478, 0.975666, 0.977855, 0.980044, 0.982233, 0.983848, 
      
0.985463, 0.987079, 0.988694, 0.990309, 0.991924, 0.993539, 0.995154, 0.99677, 0.998385, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0.309029, 0.493495, 0.608648, 0.654488, 0.700327, 0.746167, 0.792006, 0.837846, 0.883686, 0.899476, 0.905249, 0.911023, 0.916796, 0.92257, 0.928343, 0.934116, 0.93989, 
      
0.945663, 0.951437, 0.95721, 0.96121, 0.963437, 0.965663, 0.96789, 0.970116, 0.972343, 0.97457, 0.976796, 0.979023, 0.981249, 0.983476, 0.985476, 0.986796, 0.988117, 0.989437, 0.990757, 0.992078, 
      
0.993398, 0.994718, 0.996039, 0.997359, 0.99868, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.310886, 
      
0.491764, 0.617553, 0.660708, 0.703862, 0.747017, 0.790172, 0.833326, 0.876481, 0.90084, 0.906404, 0.911967, 0.917531, 0.923094, 0.928658, 0.934221, 0.939785, 0.945348, 0.950912, 0.956475, 0.962039, 
      
0.964301, 0.966564, 0.968827, 0.971089, 0.973352, 0.975614, 0.977877, 0.980139, 0.982402, 0.984664, 0.986927, 0.988577, 0.989616, 0.990654, 0.991693, 0.992731, 0.99377, 0.994808, 0.995846, 0.996885, 
      
0.997923, 0.998962, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.313202, 0.490645, 0.62703, 0.667613, 
      
0.708197, 0.748781, 0.789365, 0.829949, 0.870533, 0.902312, 0.907674, 0.913037, 0.918399, 0.923762, 0.929124, 0.934487, 0.939849, 0.945212, 0.950574, 0.955937, 0.961299, 0.965129, 0.967426, 0.969723, 
      
0.97202, 0.974317, 0.976614, 0.978911, 0.981208, 0.983505, 0.985803, 0.9881, 0.990397, 0.991547, 0.992316, 0.993084, 0.993853, 0.994621, 0.995389, 0.996158, 0.996926, 0.997695, 0.998463, 0.999232, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.315947, 0.490097, 0.637042, 0.675162, 0.713282, 0.751402, 
      
0.789523, 0.827643, 0.865763, 0.903884, 0.909053, 0.914223, 0.919393, 0.924563, 0.929733, 0.934903, 0.940073, 0.945243, 0.950413, 0.955583, 0.960752, 0.965922, 0.968252, 0.970583, 0.972913, 0.975243, 
      
0.977573, 0.979903, 0.982233, 0.984563, 0.986893, 0.989223, 0.991553, 0.993883, 0.994393, 0.994903, 0.995413, 0.995922, 0.996432, 0.996942, 0.997451, 0.997961, 0.998471, 0.998981, 0.99949, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.319095, 0.490087, 0.647556, 0.683314, 0.719071, 0.754828, 0.790585, 
      
0.826342, 0.8621, 0.897857, 0.910535, 0.91552, 0.920505, 0.92549, 0.930476, 0.935461, 0.940446, 0.945431, 0.950416, 0.955401, 0.960386, 0.965372, 0.969045, 0.971407, 0.973769, 0.97613, 0.978492, 
      
0.980854, 0.983216, 0.985578, 0.987939, 0.990301, 0.992663, 0.995025, 0.996862, 0.997123, 0.997385, 0.997646, 0.997908, 0.998169, 0.998431, 0.998692, 0.998954, 0.999215, 0.999477, 0.999738, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.322621, 0.490583, 0.658544, 0.692032, 0.725521, 0.75901, 0.792498, 
      
0.825987, 0.859476, 0.892964, 0.912113, 0.91692, 0.921728, 0.926536, 0.931344, 0.936151, 0.940959, 0.945767, 0.950575, 0.955383, 0.96019, 0.964998, 0.969806, 0.972198, 0.97459, 0.976983, 0.979375, 
      
0.981767, 0.984159, 0.986551, 0.988944, 0.991336, 0.993728, 0.99612, 0.998513, 0.99972, 0.999744, 0.999767, 0.99979, 0.999814, 0.999837, 0.99986, 0.999883, 0.999907, 0.99993, 0.999953, 0.999977, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.344118, 0.502763, 0.661408, 0.705401, 0.736655, 0.767909, 
      
0.799162, 0.830416, 0.86167, 0.892923, 0.917469, 0.921889, 0.92631, 0.930731, 0.935152, 0.939572, 0.943993, 0.948414, 0.952834, 0.957255, 0.961676, 0.966096, 0.970517, 0.973797, 0.975936, 0.978075, 
      
0.980214, 0.982353, 0.984492, 0.986631, 0.98877, 0.990909, 0.993048, 0.995187, 0.997326, 0.999465, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.368687, 0.517677, 0.666667, 0.719744, 
      
0.748842, 0.777941, 0.80704, 0.836138, 0.865237, 0.894336, 0.923434, 0.927459, 0.931484, 0.935509, 0.939534, 0.943559, 0.947584, 0.951608, 0.955633, 0.959658, 0.963683, 0.967708, 0.971733, 0.975758, 
      
0.977622, 0.979487, 0.981352, 0.983217, 0.985082, 0.986946, 0.988811, 0.990676, 0.992541, 0.994406, 0.99627, 0.998135, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.394349, 
      
0.534048, 0.673747, 0.734574, 0.761599, 0.788624, 0.815649, 0.842674, 0.869699, 0.896724, 0.923749, 0.933238, 0.936882, 0.940526, 0.94417, 0.947814, 0.951458, 0.955102, 0.958746, 0.96239, 0.966034, 
      
0.969678, 0.973322, 0.976966, 0.979588, 0.981189, 0.98279, 0.984391, 0.985992, 0.987593, 0.989194, 0.990795, 0.992396, 0.993997, 0.995597, 0.997198, 0.998799, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0.421044, 0.551796, 0.682548, 0.749865, 0.774893, 0.799921, 0.82495, 0.849978, 0.875006, 0.900034, 0.925062, 0.939214, 0.942492, 0.945769, 0.949046, 0.952323, 0.9556, 
      
0.958878, 0.962155, 0.965432, 0.968709, 0.971987, 0.975264, 0.978541, 0.981818, 0.983165, 0.984512, 0.985859, 0.987205, 0.988552, 0.989899, 0.991246, 0.992593, 0.993939, 0.995286, 0.996633, 0.99798, 
      
0.999327, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0.448714, 0.570845, 0.692975, 0.765592, 0.788696, 0.8118, 0.834904, 0.858007, 0.881111, 0.904215, 0.927319, 0.945377, 
      
0.948301, 0.951225, 0.954149, 0.957073, 0.959996, 0.96292, 0.965844, 0.968768, 0.971691, 0.974615, 0.977539, 0.980463, 0.983387, 0.985399, 0.986501, 0.987603, 0.988705, 0.989807, 0.990909, 0.992011, 
      
0.993113, 0.994215, 0.995317, 0.996419, 0.997521, 0.998623, 0.999725, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.477309, 0.591126, 0.704942, 0.781732, 0.80298, 0.824228, 
      
0.845476, 0.866724, 0.887973, 0.909221, 0.930469, 0.951717, 0.9543, 0.956883, 0.959466, 0.962049, 0.964632, 0.967215, 0.969798, 0.972381, 0.974964, 0.977547, 0.98013, 0.982713, 0.985296, 0.987879, 
      
0.988745, 0.98961, 0.990476, 0.991342, 0.992208, 0.993074, 0.993939, 0.994805, 0.995671, 0.996537, 0.997403, 0.998268, 0.999134, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      
0, 0.506778, 0.612573, 0.718368, 0.798262, 0.817719, 0.837177, 0.856635, 0.876093, 0.89555, 0.915008, 0.934466, 0.953923, 0.960478, 0.962733, 0.964987, 0.967241, 0.969495, 0.971749, 0.974003, 
      
0.976257, 0.978511, 0.980766, 0.98302, 0.985274, 0.987528, 0.989782, 0.991228, 0.991866, 0.992504, 0.993142, 0.99378, 0.994418, 0.995056, 0.995694, 0.996332, 0.99697, 0.997608, 0.998246, 0.998884, 
      
0.999522, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0.537078, 0.635127, 0.733177, 0.815162, 0.832891, 0.85062, 0.868349, 0.886078, 0.903807, 0.921536, 0.939265, 
      
0.956994, 0.966827, 0.968763, 0.9707, 0.972637, 0.974573, 0.97651, 0.978447, 0.980383, 0.98232, 0.984256, 0.986193, 0.98813, 0.990066, 0.992003, 0.993939, 0.994357, 0.994775, 0.995193, 0.995611, 
      
0.996029, 0.996447, 0.996865, 0.997283, 0.997701, 0.998119, 0.998537, 0.998955, 0.999373, 0.999791, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.568165, 0.658731, 
      
0.749298, 0.832414, 0.848473, 0.864532, 0.880591, 0.89665, 0.912708, 0.928767, 0.944826, 0.960885, 0.973337, 0.974967, 0.976596, 0.978226, 0.979856, 0.981486, 0.983116, 0.984746, 0.986376, 0.988005, 
      
0.989635, 0.991265, 0.992895, 0.994525, 0.996155, 0.997072, 0.997278, 0.997483, 0.997689, 0.997894, 0.9981, 0.998305, 0.998511, 0.998716, 0.998921, 0.999127, 0.999332, 0.999538, 0.999743, 0.999949, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 
      
0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 
      
0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 
      
0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 
      
0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 
      
0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 
      
0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 
      
0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 
      
0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 
      
0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 
      
0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 
      
0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 
      
0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 
      
0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 
      
0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 
      
0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 
      
0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 
      
0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 
      
0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 
      
0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 
      
0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 
      
0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 
      
0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 
      
0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 
      
0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 
      
0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 
      
0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 
      
0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      
0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 
      
0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 
      
0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 
      
0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 
      
0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 
      
0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 
      
0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 
      
0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 
      
0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 
      
0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 
      
0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 
      
0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 
      
0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 
      
0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 
      
0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 
      
0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 
      
0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 
      
0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 
      
0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 
      
0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 
      
0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 
      
0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 
      
0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 
      
0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      
0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 
      
0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 
      
0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 
      
0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 
      
0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 
      
0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 
      
0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 
      
0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 
      
0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 
      
0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 
      
0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 
      
0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 
      
0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 
      
0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 
      
0.982667, 0.984, 0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 
      
0.985333, 0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 
      
0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0.6, 0.683333, 0.766667, 0.85, 0.864444, 0.878889, 0.893333, 0.907778, 0.922222, 0.936667, 0.951111, 0.965556, 0.98, 0.981333, 0.982667, 0.984, 0.985333, 
      
0.986667, 0.988, 0.989333, 0.990667, 0.992, 0.993333, 0.994667, 0.996, 0.997333, 0.998667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1          };
      vec = std::vector<real_t>(arr, arr + sizeof(arr) / sizeof(arr[0]) );
      }
    }
  }
}
