#pragma once
namespace libcloudphxx
{
  namespace lgrngn
  {
    namespace detail
    {
      template<class real_t>
      real_t hall_davis_no_waals_r_max()
      {
        return 1100.;
      }

      template<class real_t>
      void hall_davis_no_waals_efficiencies(std::vector<real_t> &vec)
      {
        //NVCC doesn't support extended initializer list. First make an array, then copy it to a vector.
        const real_t arr[] = {
0, 0, 0, 0, 0, 0.0218, 0, 0, 0.014736, 0.024245, 0, 0, 0.009316, 0.019473, 0.025568, 0, 0, 0.010091, 0.015382, 0.023103, 
      
0.026963, 0, 0, 0.01122, 0.015029, 0.020001, 0.024974, 0.026963, 0, 0, 0.011883, 0.015712, 0.019293, 0.022628, 0.025963, 0.026963, 0, 0, 0.012151, 0.016412, 
      
0.020672, 0.022638, 0.024604, 0.02657, 0.026963, 0, 0, 0, 0.016672, 0.020884, 0.023542, 0.024645, 0.025749, 0.026853, 0.026963, 0, 0, 0, 0.017416, 0.022189, 
      
0.026963, 0.026963, 0.026963, 0.026963, 0.026963, 0.026963, 0, 0, 0, 0.017134, 0.022275, 0.027416, 0.02981, 0.029457, 0.029105, 0.028752, 0.028435, 0.028435, 0, 0, 
      
0, 0.016714, 0.022259, 0.027804, 0.033349, 0.032325, 0.031301, 0.030277, 0.029254, 0.028435, 0.028435, 0, 0, 0, 0, 0.021674, 0.027072, 0.03247, 0.034521, 0.033226, 
      
0.031931, 0.030636, 0.029341, 0.028435, 0.028435, 0, 0, 0, 0, 0.021231, 0.026516, 0.031802, 0.037088, 0.035543, 0.033997, 0.032452, 0.030907, 0.029362, 0.028435, 0.028435, 
      
0, 0, 0, 0, 0.020903, 0.026105, 0.031308, 0.036511, 0.038222, 0.036442, 0.034663, 0.032883, 0.031104, 0.029324, 0.028435, 0.028435, 0, 0, 0, 0, 
      
0.020672, 0.025816, 0.030959, 0.036103, 0.041246, 0.039244, 0.037243, 0.035241, 0.033239, 0.031237, 0.029235, 0.028435, 0.028435, 0, 0, 0, 0, 0, 0.025629, 0.030734, 
      
0.035839, 0.040945, 0.04239, 0.040175, 0.037959, 0.035744, 0.033529, 0.031314, 0.029099, 0.028435, 0.028435, 0, 0, 0, 0, 0, 0.025532, 0.030617, 0.035702, 0.040786, 
      
0.045871, 0.043665, 0.041459, 0.039252, 0.037046, 0.03484, 0.032634, 0.030428, 0.029986, 0.029986, 0, 0, 0, 0, 0, 0.026907, 0.032264, 0.037621, 0.042979, 0.048336, 
      
0.049739, 0.047187, 0.044636, 0.042084, 0.039532, 0.036981, 0.034429, 0.031878, 0.031623, 0.031623, 0, 0, 0, 0, 0, 0.028435, 0.034095, 0.039754, 0.045414, 0.051074, 
      
0.056734, 0.053811, 0.050888, 0.047965, 0.045041, 0.042118, 0.039195, 0.036272, 0.033349, 0.033349, 0.033349, 0, 0, 0, 0, 0, 0, 0.036611, 0.043262, 0.049912, 
      
0.056563, 0.063214, 0.064786, 0.06128, 0.057774, 0.054268, 0.050762, 0.047255, 0.043749, 0.040243, 0.037088, 0.037088, 0.037088, 0, 0, 0, 0, 0, 0, 0.041198, 
      
0.049418, 0.057637, 0.065857, 0.074077, 0.082297, 0.07739, 0.072482, 0.067575, 0.062667, 0.05776, 0.052853, 0.047945, 0.043038, 0.039112, 0.039112, 0.039112, 0, 0, 0, 0, 
      
0, 0, 0.043649, 0.053262, 0.062875, 0.072488, 0.0821, 0.091713, 0.093638, 0.087875, 0.082111, 0.076348, 0.070585, 0.064821, 0.059058, 0.053295, 0.047532, 0.043497, 0.043497, 0.043497, 
      
0, 0, 0, 0, 0, 0, 0.048374, 0.061294, 0.074214, 0.087133, 0.100053, 0.112973, 0.125893, 0.117818, 0.109743, 0.101668, 0.093593, 0.085518, 0.077444, 0.069369, 
      
0.061294, 0.053219, 0.048374, 0.048374, 0.048374, 0, 0, 0, 0, 0, 0, 0, 0.06506, 0.080077, 0.095093, 0.110109, 0.125125, 0.140141, 0.142957, 0.133572, 
      
0.124186, 0.114801, 0.105416, 0.096031, 0.086646, 0.077261, 0.067876, 0.058491, 0.053798, 0.053798, 0.053798, 0, 0, 0, 0, 0, 0, 0, 0.073865, 0.095403, 
      
0.11694, 0.138478, 0.160016, 0.181554, 0.203092, 0.189631, 0.176169, 0.162708, 0.149247, 0.135786, 0.122325, 0.108864, 0.095403, 0.081941, 0.06848, 0.063096, 0.063096, 0.063096, 0, 0, 
      
0, 0, 0, 0, 0, 0.080562, 0.106813, 0.133063, 0.159313, 0.185563, 0.211813, 0.238064, 0.242808, 0.226047, 0.209286, 0.192525, 0.175764, 0.159003, 0.142243, 0.125482, 
      
0.108721, 0.09196, 0.075199, 0.07017, 0.07017, 0.07017, 0, 0, 0, 0, 0, 0, 0, 0.082297, 0.117345, 0.152392, 0.18744, 0.222488, 0.257535, 0.292583, 
      
0.327631, 0.305346, 0.283061, 0.260776, 0.238491, 0.216206, 0.19392, 0.171635, 0.14935, 0.127065, 0.10478, 0.082495, 0.078038, 0.078038, 0.078038, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0.121807, 0.162183, 0.202559, 0.242935, 0.283311, 0.323687, 0.364063, 0.371236, 0.345206, 0.319175, 0.293145, 0.267114, 0.241083, 0.215053, 0.189022, 0.162992, 0.136961, 
      
0.110931, 0.0849, 0.082297, 0.082297, 0.082297, 0, 0, 0, 0, 0, 0, 0, 0, 0.135697, 0.180691, 0.225686, 0.27068, 0.315674, 0.360668, 0.405663, 
      
0.450657, 0.420334, 0.390012, 0.35969, 0.329367, 0.299045, 0.268723, 0.2384, 0.208078, 0.177755, 0.147433, 0.117111, 0.086788, 0.086788, 0.086788, 0.086788, 0, 0, 0.00269, 0.008245, 
      
0.0304, 0.055032, 0.080839, 0.113097, 0.151806, 0.205032, 0.264355, 0.32871, 0.406774, 0.473613, 0.531452, 0.560484, 0.58371, 0.601129, 0.60629, 0.606419, 0.599968, 0.57871, 0.556968, 0.540194, 
      
0.52729, 0.515806, 0.504839, 0.493871, 0.486194, 0.508129, 0.549936, 0.608, 0, 0, 0.00411, 0.013685, 0.0438, 0.0795, 0.117, 0.1545, 0.192, 0.242, 0.295, 0.3525, 
      
0.42, 0.4865, 0.539, 0.575, 0.6, 0.615, 0.625, 0.6275, 0.623, 0.61375, 0.5925, 0.57575, 0.562, 0.552, 0.5425, 0.53375, 0.525, 0.524, 0.554, 0.61475, 
      
0.696, 0, 0, 0.005043, 0.018395, 0.054473, 0.100424, 0.148909, 0.194364, 0.235273, 0.280727, 0.328333, 0.381667, 0.439091, 0.501515, 0.550849, 0.593182, 0.614394, 0.631364, 0.644091, 
      
0.646515, 0.645788, 0.639727, 0.626667, 0.607879, 0.596182, 0.585879, 0.577394, 0.57, 0.563333, 0.556667, 0.563273, 0.600848, 0.68097, 0.784, 0, 0, 0.005532, 0.022438, 0.062659, 
      
0.118424, 0.176941, 0.232824, 0.276941, 0.321059, 0.365176, 0.413529, 0.463529, 0.518824, 0.568, 0.608, 0.632353, 0.65, 0.660588, 0.667647, 0.666471, 0.662471, 0.656588, 0.641176, 0.626353, 
      
0.618118, 0.610471, 0.603412, 0.598235, 0.593529, 0.588824, 0.603882, 0.648588, 0.748471, 0.872, 0, 0, 0.005614, 0.025871, 0.068571, 0.133714, 0.201429, 0.27, 0.317143, 0.362857, 
      
0.404286, 0.447857, 0.493571, 0.541429, 0.59, 0.624286, 0.653571, 0.667857, 0.679286, 0.687857, 0.687857, 0.685, 0.679286, 0.671429, 0.657143, 0.647143, 0.641429, 0.635714, 0.63, 0.627143, 
      
0.624286, 0.621429, 0.645714, 0.697143, 0.817143, 0.96, 0, 0, 0.005324, 0.028747, 0.0724, 0.1464, 0.222667, 0.300444, 0.356, 0.406, 0.444889, 0.484444, 0.526667, 0.568889, 
      
0.611111, 0.645333, 0.674222, 0.688889, 0.7, 0.706667, 0.711111, 0.706667, 0.701778, 0.696222, 0.686667, 0.674444, 0.669333, 0.666, 0.661556, 0.657778, 0.656667, 0.655556, 0.654444, 0.688667, 
      
0.746444, 0.886889, 1.048, 0, 0, 0.004692, 0.031109, 0.074314, 0.156692, 0.240919, 0.327405, 0.393622, 0.446324, 0.486865, 0.523351, 0.562027, 0.600811, 0.637027, 0.670757, 0.694541, 
      
0.712838, 0.720946, 0.727432, 0.732297, 0.730135, 0.724189, 0.718676, 0.71327, 0.703243, 0.693892, 0.692811, 0.691189, 0.687946, 0.686216, 0.686757, 0.687297, 0.687838, 0.732649, 0.796433, 0.957622, 
      
1.136, 0, 0, 0.003745, 0.032998, 0.074463, 0.164779, 0.256421, 0.351158, 0.430105, 0.485368, 0.530105, 0.564316, 0.599474, 0.635263, 0.667368, 0.697895, 0.719158, 0.738105, 0.744737, 
      
0.75, 0.753158, 0.755263, 0.747895, 0.740947, 0.735684, 0.729474, 0.721053, 0.716421, 0.717474, 0.716947, 0.714842, 0.715263, 0.717368, 0.719474, 0.721579, 0.777579, 0.847053, 1.02926, 1.224, 
      
0, 0, 0.002507, 0.034451, 0.072985, 0.170831, 0.269385, 0.371949, 0.465538, 0.523231, 0.574513, 0.606564, 0.638846, 0.671667, 0.701795, 0.726923, 0.747744, 0.762103, 0.771154, 0.773718, 
      
0.775769, 0.777308, 0.773205, 0.764487, 0.757923, 0.752795, 0.746667, 0.74, 0.740154, 0.743231, 0.743231, 0.742205, 0.744872, 0.748461, 0.752051, 0.755641, 0.823385, 0.898256, 1.10174, 1.312, 
      
0, 0, 0.001, 0.0355, 0.07, 0.175, 0.28, 0.39, 0.5, 0.56, 0.62, 0.65, 0.68, 0.71, 0.74, 0.76, 0.78, 0.79, 0.8, 0.8, 
      
0.8, 0.8, 0.8, 0.79, 0.78, 0.775, 0.77, 0.765, 0.76, 0.765, 0.77, 0.77, 0.77, 0.775, 0.78, 0.785, 0.79, 0.87, 0.95, 1.175, 
      
1.4, 0, 0, 0, 0.048483, 0.098044, 0.194756, 0.296707, 0.398244, 0.499707, 0.565268, 0.621854, 0.657585, 0.686366, 0.714463, 0.742268, 0.764049, 0.782585, 0.795854, 0.80561, 
      
0.81, 0.81, 0.81, 0.81, 0.806049, 0.797268, 0.790049, 0.785171, 0.780293, 0.775415, 0.773317, 0.777707, 0.781122, 0.78161, 0.783171, 0.789024, 0.795317, 0.804098, 0.820439, 0.904829, 
      
0.997317, 1.24366, 1.49, 0, 0, 0, 0.059314, 0.123219, 0.215238, 0.314286, 0.409333, 0.502667, 0.572, 0.625333, 0.66581, 0.693429, 0.720286, 0.746, 0.769143, 0.786286, 
      
0.801905, 0.811429, 0.82, 0.82, 0.82, 0.82, 0.82, 0.813143, 0.805524, 0.80019, 0.795429, 0.790667, 0.785905, 0.786286, 0.790095, 0.792476, 0.793429, 0.796667, 0.803333, 0.811714, 
      
0.824095, 0.851714, 0.940286, 1.04667, 1.31333, 1.58, 0, 0, 0, 0.068144, 0.145726, 0.236395, 0.332674, 0.42307, 0.508651, 0.580093, 0.630326, 0.674628, 0.70114, 0.727372, 
      
0.751093, 0.774814, 0.791023, 0.806837, 0.817442, 0.826744, 0.83, 0.83, 0.83, 0.83, 0.827721, 0.821209, 0.81507, 0.810419, 0.805767, 0.801116, 0.796465, 0.79893, 0.802186, 0.804047, 
      
0.805442, 0.810465, 0.817907, 0.829116, 0.84493, 0.883767, 0.976326, 1.09791, 1.38395, 1.67, 0, 0, 0, 0.075109, 0.165745, 0.258182, 0.351818, 0.439273, 0.517455, 0.589455, 
      
0.636727, 0.684, 0.709455, 0.734909, 0.757455, 0.779273, 0.796727, 0.811273, 0.823636, 0.832727, 0.84, 0.84, 0.84, 0.84, 0.84, 0.835636, 0.830182, 0.825273, 0.820727, 0.816182, 
      
0.811636, 0.808545, 0.811273, 0.814, 0.815818, 0.817636, 0.824545, 0.832727, 0.847454, 0.866545, 0.916546, 1.01291, 1.15091, 1.45545, 1.76, 0, 0, 0, 0.080333, 0.183444, 
      
0.280556, 0.371667, 0.457778, 0.528889, 0.6, 0.644444, 0.688889, 0.718333, 0.742778, 0.765, 0.785, 0.803333, 0.816667, 0.83, 0.838889, 0.847778, 0.85, 0.85, 0.85, 0.85, 
      
0.848889, 0.844444, 0.84, 0.835556, 0.831111, 0.826667, 0.822222, 0.821111, 0.823333, 0.825556, 0.827778, 0.83, 0.838889, 0.847778, 0.866667, 0.888889, 0.95, 1.05, 1.20556, 1.52778, 
      
1.85, 0, 0, 0, 0.08393, 0.198974, 0.303478, 0.392174, 0.478435, 0.542783, 0.60713, 0.653391, 0.69513, 0.727739, 0.751217, 0.773652, 0.791913, 0.810174, 0.822957, 0.83513, 
      
0.845217, 0.853913, 0.86, 0.86, 0.86, 0.86, 0.86, 0.857565, 0.854087, 0.850261, 0.845913, 0.841565, 0.837217, 0.83287, 0.833391, 0.83513, 0.837304, 0.839913, 0.843913, 0.853478, 
      
0.863043, 0.886696, 0.911913, 0.984087, 1.08756, 1.26174, 1.60087, 1.94, 0, 0, 0, 0.086004, 0.212472, 0.326915, 0.413298, 0.499681, 0.558979, 0.616851, 0.663489, 0.702638, 
      
0.737638, 0.760191, 0.782745, 0.799936, 0.816532, 0.830085, 0.841149, 0.851702, 0.860213, 0.868723, 0.87, 0.87, 0.87, 0.87, 0.869617, 0.867064, 0.864511, 0.860596, 0.85634, 0.852085, 
      
0.84783, 0.844128, 0.845404, 0.846681, 0.849234, 0.852213, 0.858085, 0.868298, 0.879404, 0.907489, 0.935574, 1.01877, 1.12557, 1.31936, 1.67468, 2.03, 0, 0, 0, 0.08665, 
      
0.224067, 0.350833, 0.435, 0.519167, 0.577333, 0.629, 0.674667, 0.711333, 0.748, 0.769667, 0.791333, 0.809, 0.824, 0.838, 0.848, 0.858, 0.866667, 0.875, 0.88, 0.88, 
      
0.88, 0.88, 0.88, 0.879, 0.877333, 0.875167, 0.871, 0.866833, 0.862667, 0.8585, 0.856333, 0.857167, 0.858, 0.861333, 0.864667, 0.8725, 0.883333, 0.898167, 0.929, 0.959833, 
      
1.054, 1.164, 1.37833, 1.74917, 2.12, 0, 0, 0, 0.085955, 0.233873, 0.375204, 0.457245, 0.539286, 0.597714, 0.643429, 0.686857, 0.721143, 0.755428, 0.779612, 0.800429, 
      
0.819041, 0.83251, 0.84598, 0.855633, 0.864612, 0.873265, 0.881429, 0.889592, 0.89, 0.89, 0.89, 0.89, 0.889959, 0.889143, 0.888326, 0.885551, 0.881469, 0.877388, 0.873306, 0.869224, 
      
0.868286, 0.868694, 0.869918, 0.873592, 0.877265, 0.887143, 0.898571, 0.917714, 0.951184, 0.984653, 1.08976, 1.20282, 1.43857, 1.82429, 2.21, 0, 0, 0, 0.084, 0.242, 
      
0.4, 0.48, 0.56, 0.62, 0.66, 0.7, 0.732, 0.764, 0.79, 0.81, 0.83, 0.842, 0.854, 0.864, 0.872, 0.88, 0.888, 0.896, 0.9, 0.9, 
      
0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.896, 0.892, 0.888, 0.884, 0.88, 0.88, 0.88, 0.882, 0.886, 0.89, 0.902, 0.914, 0.938, 0.974, 
      
1.01, 1.126, 1.242, 1.5, 1.9, 2.3, 0, 0, 0, 0.078941, 0.233255, 0.387569, 0.473941, 0.552765, 0.618137, 0.658529, 0.698922, 0.731784, 0.762765, 0.790706, 
      
0.809529, 0.828353, 0.841961, 0.853333, 0.864118, 0.871569, 0.87902, 0.886471, 0.893922, 0.901, 0.901, 0.901, 0.901, 0.901, 0.901, 0.901, 0.901, 0.899588, 0.896059, 0.892529, 
      
0.889333, 0.886196, 0.884118, 0.88451, 0.884902, 0.888235, 0.892549, 0.89851, 0.911059, 0.923608, 0.949412, 0.982353, 1.02486, 1.15349, 1.28212, 1.56216, 1.96608, 2.37, 0, 0, 
      
0, 0.074308, 0.225077, 0.375846, 0.468154, 0.545846, 0.616154, 0.656923, 0.697692, 0.732, 0.762, 0.792, 0.809692, 0.827385, 0.842308, 0.853077, 0.863846, 0.871538, 0.878462, 0.885385, 
      
0.892308, 0.899231, 0.902, 0.902, 0.902, 0.902, 0.902, 0.902, 0.902, 0.902, 0.899538, 0.896462, 0.893538, 0.891231, 0.888923, 0.888462, 0.889231, 0.89, 0.894615, 0.899231, 
      
0.907231, 0.920308, 0.933385, 0.96, 0.99, 1.04215, 1.18292, 1.32369, 1.62462, 2.03231, 2.44, 0, 0, 0, 0.070075, 0.217434, 0.364792, 0.462623, 0.539226, 0.614057, 
      
0.655189, 0.696321, 0.732623, 0.761679, 0.790736, 0.810453, 0.827057, 0.843019, 0.853208, 0.863396, 0.871887, 0.878302, 0.884717, 0.891132, 0.897547, 0.903, 0.903, 0.903, 0.903, 0.903, 
      
0.903, 0.903, 0.903, 0.902472, 0.89983, 0.897189, 0.89517, 0.89366, 0.892151, 0.893019, 0.894151, 0.896226, 0.901132, 0.906038, 0.916151, 0.929736, 0.943321, 0.969811, 0.996981, 1.06174, 
      
1.21419, 1.36664, 1.68736, 2.09868, 2.51, 0, 0, 0, 0.066222, 0.210296, 0.35437, 0.457333, 0.532889, 0.608444, 0.653333, 0.694815, 0.73363, 0.761778, 0.789926, 0.811778, 
      
0.827333, 0.842889, 0.853704, 0.863333, 0.872593, 0.878519, 0.884444, 0.89037, 0.896296, 0.902222, 0.904, 0.904, 0.904, 0.904, 0.904, 0.904, 0.904, 0.904, 0.902667, 0.900444, 
      
0.898222, 0.897333, 0.896593, 0.896296, 0.897778, 0.899259, 0.902593, 0.907778, 0.912963, 0.925259, 0.939333, 0.954444, 0.978889, 1.00333, 1.08348, 1.24718, 1.41089, 1.75037, 2.16518, 2.58, 
      
0, 0, 0, 0.062727, 0.203636, 0.344545, 0.452273, 0.526818, 0.601364, 0.651364, 0.693182, 0.735, 0.762273, 0.789545, 0.813636, 0.828182, 0.842727, 0.854545, 0.863636, 0.872727, 
      
0.879091, 0.884545, 0.89, 0.895455, 0.900909, 0.905, 0.905, 0.905, 0.905, 0.905, 0.905, 0.905, 0.905, 0.905, 0.903182, 0.901364, 0.9, 0.9, 0.9, 0.900909, 
      
0.902727, 0.904545, 0.909091, 0.914545, 0.92, 0.934545, 0.949091, 0.965455, 0.987273, 1.00909, 1.10727, 1.28182, 1.45636, 1.81364, 2.23182, 2.65, 0, 0, 0, 0.059571, 
      
0.197429, 0.335286, 0.447429, 0.521, 0.594571, 0.649286, 0.691429, 0.733571, 0.763143, 0.789571, 0.816, 0.829571, 0.843143, 0.855714, 0.864286, 0.872857, 0.88, 0.885, 0.89, 0.895, 
      
0.9, 0.905, 0.906, 0.906, 0.906, 0.906, 0.906, 0.906, 0.906, 0.906, 0.905429, 0.904, 0.902571, 0.902429, 0.903143, 0.903857, 0.905714, 0.907857, 0.91, 0.915714, 
      
0.921429, 0.929, 0.944, 0.959, 0.975714, 0.995, 1.01429, 1.133, 1.318, 1.503, 1.87714, 2.29857, 2.72, 0, 0, 0, 0.056737, 0.191649, 0.326561, 0.442789, 
      
0.515421, 0.588053, 0.647105, 0.689561, 0.732018, 0.764368, 0.789982, 0.815596, 0.831474, 0.844105, 0.856737, 0.865263, 0.873333, 0.881228, 0.885789, 0.890351, 0.894912, 0.899474, 0.904035, 0.907, 
      
0.907, 0.907, 0.907, 0.907, 0.907, 0.907, 0.907, 0.907, 0.906158, 0.905105, 0.904053, 0.905333, 0.906737, 0.908246, 0.910702, 0.913158, 0.916491, 0.922456, 0.928421, 0.938175, 
      
0.953614, 0.969053, 0.985263, 1.0021, 1.01895, 1.16056, 1.35565, 1.55074, 1.94088, 2.36544, 2.79, 0, 0, 0, 0.054207, 0.186276, 0.318345, 0.438345, 0.510069, 0.581793, 
      
0.644828, 0.687586, 0.730345, 0.765931, 0.790759, 0.815586, 0.833862, 0.845586, 0.85731, 0.866552, 0.874138, 0.881724, 0.886897, 0.891034, 0.895172, 0.89931, 0.903448, 0.907586, 0.908, 0.908, 
      
0.908, 0.908, 0.908, 0.908, 0.908, 0.908, 0.907862, 0.907172, 0.906483, 0.906621, 0.90869, 0.910759, 0.913103, 0.915862, 0.918621, 0.923103, 0.92931, 0.935517, 0.947517, 0.963379, 
      
0.979241, 0.994138, 1.00862, 1.0231, 1.18986, 1.39469, 1.59952, 2.00483, 2.43241, 2.86, 0, 0, 0, 0.051966, 0.181288, 0.31061, 0.434085, 0.504932, 0.57578, 0.642458, 
      
0.685508, 0.728559, 0.767814, 0.791881, 0.815949, 0.836712, 0.847559, 0.858407, 0.868136, 0.875254, 0.882373, 0.888305, 0.892034, 0.895763, 0.899492, 0.90322, 0.906949, 0.909, 0.909, 0.909, 
      
0.909, 0.909, 0.909, 0.909, 0.909, 0.909, 0.908797, 0.908458, 0.908119, 0.909763, 0.912475, 0.915186, 0.918136, 0.921186, 0.924237, 0.92983, 0.936271, 0.942712, 0.957017, 0.973288, 
      
0.989559, 1.00237, 1.01458, 1.02678, 1.22081, 1.43505, 1.64929, 2.06898, 2.49949, 2.93, 0, 0, 0, 0.05, 0.176667, 0.303333, 0.43, 0.5, 0.57, 0.64, 
      
0.683333, 0.726667, 0.77, 0.793333, 0.816667, 0.84, 0.85, 0.86, 0.87, 0.876667, 0.883333, 0.89, 0.893333, 0.896667, 0.9, 0.903333, 0.906667, 0.91, 0.91, 0.91, 
      
0.91, 0.91, 0.91, 0.91, 0.91, 0.91, 0.91, 0.91, 0.91, 0.91, 0.913333, 0.916667, 0.92, 0.923333, 0.926667, 0.93, 0.936667, 0.943333, 0.95, 0.966667, 
      
0.983333, 1, 1.01, 1.02, 1.03, 1.25333, 1.47667, 1.7, 2.13333, 2.56667, 3, 0, 0, 0, 0, 0.183361, 0.307951, 0.432541, 0.505787, 0.573328, 
      
0.640869, 0.686115, 0.727426, 0.768738, 0.794574, 0.816541, 0.838508, 0.851131, 0.860639, 0.870148, 0.87759, 0.884148, 0.890705, 0.895344, 0.898951, 0.902557, 0.905967, 0.909246, 0.912525, 0.914, 
      
0.914, 0.914, 0.914, 0.914, 0.914, 0.914, 0.914, 0.914, 0.914, 0.914, 0.914, 0.915033, 0.917984, 0.920934, 0.924082, 0.927689, 0.931295, 0.935721, 0.942607, 0.949492, 
      
0.958082, 0.973492, 0.988902, 1.00343, 1.01293, 1.02244, 1.0549, 1.29392, 1.53293, 1.78197, 2.22131, 2.66066, 3.1, 0, 0, 0, 0, 0.190323, 0.312903, 0.435484, 
      
0.512129, 0.57729, 0.642452, 0.689548, 0.728903, 0.768258, 0.796387, 0.817032, 0.837677, 0.852516, 0.861548, 0.870581, 0.878581, 0.885032, 0.891484, 0.897161, 0.901032, 0.904903, 0.908645, 0.911871, 
      
0.915097, 0.918, 0.918, 0.918, 0.918, 0.918, 0.918, 0.918, 0.918, 0.918, 0.918, 0.918, 0.918, 0.918, 0.919806, 0.922387, 0.924968, 0.928323, 0.932194, 0.936065, 
      
0.941548, 0.948645, 0.955742, 0.965677, 0.979871, 0.994064, 1.00671, 1.01574, 1.02477, 1.08284, 1.33703, 1.59123, 1.86452, 2.30968, 2.75484, 3.2, 0, 0, 0, 0, 
      
0.19754, 0.318175, 0.438809, 0.519, 0.581857, 0.644714, 0.693603, 0.731063, 0.768524, 0.798746, 0.818111, 0.837476, 0.854143, 0.862714, 0.871286, 0.879635, 0.885984, 0.892333, 0.898683, 0.902921, 
      
0.907048, 0.911175, 0.91454, 0.917714, 0.920889, 0.922, 0.922, 0.922, 0.922, 0.922, 0.922, 0.922, 0.922, 0.922, 0.922, 0.922, 0.922, 0.922111, 0.924333, 0.926556, 
      
0.928778, 0.932714, 0.936841, 0.940968, 0.947476, 0.954778, 0.962079, 0.972809, 0.985825, 0.998841, 1.00986, 1.01843, 1.027, 1.11367, 1.38256, 1.65145, 1.94762, 2.39841, 2.84921, 3.3, 
      
0, 0, 0, 0, 0.205, 0.32375, 0.4425, 0.526375, 0.587, 0.647625, 0.69825, 0.733875, 0.7695, 0.801625, 0.81975, 0.837875, 0.856, 0.864125, 0.87225, 0.880375, 
      
0.887, 0.89325, 0.8995, 0.904625, 0.909, 0.913375, 0.91725, 0.920375, 0.9235, 0.926, 0.926, 0.926, 0.926, 0.926, 0.926, 0.926, 0.926, 0.926, 0.926, 0.926, 
      
0.926, 0.926, 0.92675, 0.928625, 0.9305, 0.932875, 0.93725, 0.941625, 0.946, 0.9535, 0.961, 0.9685, 0.9795, 0.991375, 1.00325, 1.01287, 1.021, 1.02912, 1.14725, 1.43037, 
      
1.7135, 2.03125, 2.4875, 2.94375, 3.4, 0, 0, 0, 0, 0.212692, 0.329615, 0.446538, 0.534231, 0.592692, 0.651154, 0.703462, 0.737308, 0.771154, 0.805, 0.821923, 
      
0.838846, 0.855769, 0.865769, 0.873462, 0.881154, 0.888077, 0.894231, 0.900385, 0.906154, 0.910769, 0.915385, 0.92, 0.923077, 0.926154, 0.929231, 0.93, 0.93, 0.93, 0.93, 0.93, 
      
0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 0.93, 0.931154, 0.932692, 0.934231, 0.937308, 0.941923, 0.946539, 0.951923, 0.959615, 0.967308, 0.975, 0.985769, 0.996538, 
      
1.00731, 1.01577, 1.02346, 1.03115, 1.18346, 1.48038, 1.77731, 2.11539, 2.57692, 3.03846, 3.5, 0, 0, 0, 0, 0.220606, 0.335758, 0.450909, 0.542545, 0.598909, 
      
0.655273, 0.709212, 0.741333, 0.773455, 0.805576, 0.824606, 0.840364, 0.856121, 0.867636, 0.874909, 0.882182, 0.889212, 0.895273, 0.901333, 0.907394, 0.912364, 0.917212, 0.922061, 0.925818, 0.928849, 
      
0.931879, 0.934, 0.934, 0.934, 0.934, 0.934, 0.934, 0.934, 0.934, 0.934, 0.934, 0.934, 0.934, 0.934, 0.934121, 0.935333, 0.936545, 0.937758, 0.941879, 0.946727, 
      
0.951576, 0.957939, 0.965818, 0.973697, 0.981939, 0.991636, 1.00133, 1.01103, 1.01855, 1.02582, 1.03309, 1.22218, 1.53249, 1.84279, 2.2, 2.66667, 3.13333, 3.6, 0, 0, 
      
0, 0, 0.228731, 0.342164, 0.455597, 0.551298, 0.605627, 0.659955, 0.714284, 0.745925, 0.776373, 0.806821, 0.827776, 0.842403, 0.85703, 0.869716, 0.876582, 0.883448, 0.890313, 0.896373, 
      
0.902343, 0.908313, 0.913791, 0.918866, 0.92394, 0.928597, 0.931582, 0.934567, 0.937552, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938, 0.938, 
      
0.938, 0.938, 0.938403, 0.939299, 0.940194, 0.941507, 0.946582, 0.951657, 0.956731, 0.964045, 0.972104, 0.980164, 0.988463, 0.997119, 1.00578, 1.01434, 1.02121, 1.02807, 1.03494, 1.2633, 
      
1.58658, 1.90987, 2.28507, 2.75672, 3.22836, 3.7, 0, 0, 0, 0, 0.237059, 0.348824, 0.460588, 0.560471, 0.612823, 0.665176, 0.717529, 0.751059, 0.779882, 0.808706, 
      
0.831412, 0.844941, 0.858471, 0.872, 0.878471, 0.884941, 0.891412, 0.897529, 0.903412, 0.909294, 0.915059, 0.920353, 0.925647, 0.930941, 0.934353, 0.937294, 0.940235, 0.942, 0.942, 0.942, 
      
0.942, 0.942, 0.942, 0.942, 0.942, 0.942, 0.942, 0.942, 0.942, 0.942, 0.942, 0.942471, 0.943059, 0.943647, 0.946118, 0.951412, 0.956706, 0.962, 0.970235, 0.978471, 
      
0.986706, 0.994588, 1.00224, 1.00988, 1.01729, 1.02376, 1.03024, 1.03671, 1.30671, 1.64259, 1.97847, 2.37059, 2.84706, 3.32353, 3.8, 0, 0, 0, 0, 0.24558, 
      
0.355725, 0.46587, 0.570043, 0.620478, 0.670913, 0.721348, 0.75671, 0.783956, 0.811203, 0.835493, 0.847956, 0.86042, 0.872884, 0.880565, 0.886652, 0.892739, 0.898739, 0.904536, 0.910333, 0.91613, 
      
0.921681, 0.927188, 0.932696, 0.937159, 0.940058, 0.942957, 0.945855, 0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 0.946, 
      
0.946043, 0.946333, 0.946623, 0.946913, 0.950855, 0.956362, 0.96187, 0.968101, 0.976507, 0.984913, 0.993319, 1.00033, 1.007, 1.01367, 1.02013, 1.02622, 1.0323, 1.03839, 1.35231, 1.70042, 
      
2.04854, 2.45652, 2.93768, 3.41884, 3.9, 0, 0, 0, 0, 0.254286, 0.362857, 0.471429, 0.58, 0.628571, 0.677143, 0.725714, 0.762857, 0.788571, 0.814286, 0.84, 
      
0.851429, 0.862857, 0.874286, 0.882857, 0.888571, 0.894286, 0.9, 0.905714, 0.911429, 0.917143, 0.922857, 0.928571, 0.934286, 0.94, 0.942857, 0.945714, 0.948571, 0.95, 0.95, 0.95, 
      
0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.955714, 0.961429, 0.967143, 0.974286, 0.982857, 
      
0.991429, 1, 1.00571, 1.01143, 1.01714, 1.02286, 1.02857, 1.03429, 1.04, 1.4, 1.76, 2.12, 2.54286, 3.02857, 3.51429, 4, 0, 0, 0, 0, 
      
0.257789, 0.363986, 0.470183, 0.57638, 0.629676, 0.677094, 0.724512, 0.764042, 0.788925, 0.813807, 0.83869, 0.85238, 0.863272, 0.874164, 0.883812, 0.889728, 0.895643, 0.901559, 0.907146, 0.912592, 
      
0.918038, 0.923484, 0.92893, 0.934376, 0.939822, 0.943634, 0.946357, 0.94908, 0.951667, 0.951667, 0.951667, 0.951667, 0.951667, 0.951667, 0.951667, 0.951667, 0.951667, 0.951667, 0.951667, 0.951667, 
      
0.951667, 0.951667, 0.951667, 0.951667, 0.951667, 0.951667, 0.9533, 0.958746, 0.964193, 0.969639, 0.977127, 0.985296, 0.993465, 1.00109, 1.00654, 1.01198, 1.01743, 1.02287, 1.02832, 1.03376, 
      
1.07298, 1.41608, 1.75917, 2.10227, 2.51127, 2.97418, 3.43709, 3.9, 0, 0, 0, 0, 0.261556, 0.365444, 0.469333, 0.573222, 0.631037, 0.677333, 0.72363, 0.765481, 
      
0.789556, 0.81363, 0.837704, 0.853556, 0.863926, 0.874296, 0.884667, 0.890778, 0.896889, 0.903, 0.908741, 0.913926, 0.919111, 0.924296, 0.929482, 0.934667, 0.939852, 0.944519, 0.947111, 0.949704, 
      
0.952296, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.953333, 0.956444, 
      
0.96163, 0.966815, 0.972, 0.979778, 0.987556, 0.995333, 1.00207, 1.00726, 1.01244, 1.01763, 1.02281, 1.028, 1.03319, 1.10267, 1.42933, 1.756, 2.08267, 2.47778, 2.91852, 3.35926, 
      
3.8, 0, 0, 0, 0, 0.265575, 0.367219, 0.468863, 0.570507, 0.632644, 0.677849, 0.723055, 0.767164, 0.790452, 0.81374, 0.837027, 0.854945, 0.864808, 0.874671, 0.884534, 
      
0.891726, 0.898027, 0.904329, 0.910493, 0.915425, 0.920356, 0.925288, 0.930219, 0.935151, 0.940082, 0.945014, 0.947973, 0.950438, 0.952904, 0.955, 0.955, 0.955, 0.955, 0.955, 0.955, 
      
0.955, 0.955, 0.955, 0.955, 0.955, 0.955, 0.955, 0.955, 0.955, 0.955, 0.955, 0.955, 0.955, 0.959438, 0.96437, 0.969301, 0.974849, 0.982247, 0.989644, 0.997041, 
      
1.00296, 1.00789, 1.01282, 1.01775, 1.02269, 1.02762, 1.03255, 1.12921, 1.43989, 1.75058, 2.06126, 2.44247, 2.86164, 3.28082, 3.7, 0, 0, 0, 0, 0.269838, 
      
0.369297, 0.468757, 0.568216, 0.634486, 0.678631, 0.722775, 0.766919, 0.791604, 0.814126, 0.836649, 0.856541, 0.86591, 0.875279, 0.884649, 0.892577, 0.899063, 0.90555, 0.912036, 0.917081, 0.921766, 
      
0.92645, 0.931135, 0.93582, 0.940504, 0.945189, 0.948937, 0.951279, 0.953622, 0.955964, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 
      
0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.956667, 0.957604, 0.962288, 0.966973, 0.971658, 0.977514, 0.984541, 0.991568, 0.998595, 1.00375, 1.00843, 1.01312, 1.0178, 1.02249, 
      
1.02717, 1.03186, 1.15272, 1.44786, 1.74299, 2.03813, 2.40541, 2.80361, 3.2018, 3.6, 0, 0, 0, 0, 0.274333, 0.371667, 0.469, 0.566333, 0.636556, 0.679667, 
      
0.722778, 0.765889, 0.793, 0.814778, 0.836556, 0.858333, 0.867222, 0.876111, 0.885, 0.893333, 0.9, 0.906667, 0.913333, 0.918889, 0.923333, 0.927778, 0.932222, 0.936667, 0.941111, 0.945556, 
      
0.95, 0.952222, 0.954444, 0.956667, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 0.958333, 
      
0.958333, 0.958333, 0.958333, 0.960556, 0.965, 0.969444, 0.973889, 0.98, 0.986667, 0.993333, 1, 1.00444, 1.00889, 1.01333, 1.01778, 1.02222, 1.02667, 1.03111, 1.17333, 1.45333, 
      
1.73333, 2.01333, 2.36667, 2.74444, 3.12222, 3.5, 0, 0, 0, 0, 0.279053, 0.374316, 0.469579, 0.564842, 0.638842, 0.680947, 0.723053, 0.765158, 0.794632, 0.815684, 
      
0.836737, 0.857789, 0.868737, 0.877158, 0.885579, 0.894, 0.900842, 0.907684, 0.914526, 0.920842, 0.925053, 0.929263, 0.933474, 0.937684, 0.941895, 0.946105, 0.950316, 0.953263, 0.955368, 0.957474, 
      
0.959579, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 
      
0.963368, 0.967579, 0.971789, 0.976, 0.982316, 0.988632, 0.994947, 1.00084, 1.00505, 1.00926, 1.01347, 1.01768, 1.0219, 1.02611, 1.03032, 1.19116, 1.45642, 1.72169, 1.98695, 2.32632, 
      
2.68421, 3.04211, 3.4, 0, 0, 0, 0, 0.283987, 0.377234, 0.470481, 0.563727, 0.641338, 0.682463, 0.723589, 0.764714, 0.796489, 0.816836, 0.837182, 0.857528, 0.870446, 
      
0.878411, 0.886377, 0.894342, 0.901593, 0.908606, 0.915619, 0.922632, 0.926918, 0.9309, 0.934883, 0.938866, 0.942849, 0.946831, 0.950814, 0.954398, 0.95639, 0.958381, 0.960372, 0.961667, 0.961667, 
      
0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.961667, 0.962065, 0.966048, 0.97003, 
      
0.974013, 0.978494, 0.984468, 0.990442, 0.996416, 1.00159, 1.00558, 1.00956, 1.01354, 1.01752, 1.02151, 1.02549, 1.02947, 1.2063, 1.45721, 1.70812, 1.95903, 2.28442, 2.62294, 2.96147, 
      
3.3, 0, 0, 0, 0, 0.289128, 0.38041, 0.471692, 0.562974, 0.644034, 0.684205, 0.724376, 0.764547, 0.798564, 0.818222, 0.83788, 0.857538, 0.872342, 0.879863, 0.887385, 
      
0.894906, 0.902256, 0.909436, 0.916615, 0.923795, 0.928923, 0.932684, 0.936444, 0.940205, 0.943966, 0.947726, 0.951487, 0.955248, 0.957504, 0.959385, 0.961265, 0.963145, 0.963333, 0.963333, 0.963333, 
      
0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.963333, 0.964838, 0.968598, 0.972359, 0.97612, 
      
0.980821, 0.986462, 0.992103, 0.997744, 1.00226, 1.00602, 1.00978, 1.01354, 1.0173, 1.02106, 1.02482, 1.02858, 1.21887, 1.4558, 1.69272, 1.92964, 2.24103, 2.56068, 2.88034, 3.2, 
      
0, 0, 0, 0, 0.294468, 0.383835, 0.473203, 0.56257, 0.646924, 0.686165, 0.725405, 0.764646, 0.800848, 0.819835, 0.838823, 0.85781, 0.874418, 0.881506, 0.888595, 0.895684, 
      
0.902835, 0.910177, 0.917519, 0.924861, 0.931063, 0.934608, 0.938152, 0.941696, 0.94524, 0.948785, 0.952329, 0.955873, 0.958709, 0.960481, 0.962253, 0.964025, 0.965, 0.965, 0.965, 0.965, 
      
0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.967481, 0.971025, 0.97457, 0.978114, 
      
0.982987, 0.988304, 0.99362, 0.998937, 1.00284, 1.00638, 1.00992, 1.01347, 1.01701, 1.02056, 1.0241, 1.02765, 1.22896, 1.45225, 1.67554, 1.89884, 2.1962, 2.49747, 2.79873, 3.1, 
      
0, 0, 0, 0, 0.3, 0.3875, 0.475, 0.5625, 0.65, 0.688333, 0.726667, 0.765, 0.803333, 0.821667, 0.84, 0.858333, 0.876667, 0.883333, 0.89, 0.896667, 
      
0.903333, 0.910833, 0.918333, 0.925833, 0.933333, 0.936667, 0.94, 0.943333, 0.946667, 0.95, 0.953333, 0.956667, 0.96, 0.961667, 0.963333, 0.965, 0.966667, 0.966667, 0.966667, 0.966667, 
      
0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.966667, 0.97, 0.973333, 0.976667, 
      
0.98, 0.985, 0.99, 0.995, 1, 1.00333, 1.00667, 1.01, 1.01333, 1.01667, 1.02, 1.02333, 1.02667, 1.23667, 1.44667, 1.65667, 1.86667, 2.15, 2.43333, 2.71667, 
      
3, 0, 0, 0, 0, 0, 0.391395, 0.477074, 0.562753, 0.648432, 0.690704, 0.728152, 0.765601, 0.803049, 0.823708, 0.841403, 0.859099, 0.876794, 0.885337, 0.891593, 
      
0.897848, 0.904103, 0.911407, 0.919062, 0.926716, 0.93437, 0.938856, 0.941984, 0.945111, 0.948239, 0.951366, 0.954494, 0.957621, 0.960749, 0.962938, 0.964502, 0.966066, 0.96763, 0.968333, 0.968333, 
      
0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.968333, 0.969272, 0.972399, 
      
0.975527, 0.978654, 0.982173, 0.986864, 0.991556, 0.996247, 1.00063, 1.00375, 1.00688, 1.01001, 1.01314, 1.01626, 1.01939, 1.02252, 1.04504, 1.24207, 1.43911, 1.63615, 1.83663, 2.10247, 
      
2.36831, 2.63416, 2.9, 0, 0, 0, 0, 0, 0.395512, 0.479415, 0.563317, 0.64722, 0.693268, 0.729854, 0.766439, 0.803024, 0.825951, 0.843024, 0.860098, 0.877171, 
      
0.887512, 0.893366, 0.89922, 0.905073, 0.911902, 0.919707, 0.927512, 0.935317, 0.941171, 0.944098, 0.947024, 0.949951, 0.952878, 0.955805, 0.958732, 0.961659, 0.964293, 0.965756, 0.967219, 0.968683, 
      
0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 0.97, 
      
0.97, 0.971756, 0.974683, 0.97761, 0.980537, 0.984195, 0.988585, 0.992976, 0.997366, 1.00117, 1.0041, 1.00702, 1.00995, 1.01288, 1.01581, 1.01873, 1.02166, 1.06088, 1.24527, 1.42966, 
      
1.61405, 1.80488, 2.05366, 2.30244, 2.55122, 2.8, 0, 0, 0, 0, 0, 0.399843, 0.482012, 0.564181, 0.646349, 0.69602, 0.731763, 0.767506, 0.803249, 0.82839, 
      
0.844855, 0.861321, 0.877787, 0.889851, 0.895313, 0.900775, 0.906237, 0.912321, 0.920273, 0.928225, 0.936177, 0.943606, 0.946337, 0.949068, 0.951799, 0.95453, 0.957261, 0.959992, 0.962723, 0.965454, 
      
0.967092, 0.968458, 0.969823, 0.971189, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 
      
0.971667, 0.971667, 0.971667, 0.971667, 0.971667, 0.974124, 0.976855, 0.979586, 0.982317, 0.986072, 0.990169, 0.994265, 0.998361, 1.00164, 1.00437, 1.0071, 1.00983, 1.01256, 1.01529, 1.01802, 
      
1.02076, 1.07428, 1.24633, 1.41838, 1.59043, 1.77149, 2.00361, 2.23574, 2.46787, 2.7, 0, 0, 0, 0, 0, 0.404381, 0.484857, 0.565333, 0.645809, 0.698952, 
      
0.733873, 0.768794, 0.803714, 0.831016, 0.846889, 0.862762, 0.878635, 0.892349, 0.897429, 0.902508, 0.907587, 0.912667, 0.920762, 0.928857, 0.936952, 0.945048, 0.948698, 0.951238, 0.953778, 0.956317, 
      
0.958857, 0.961397, 0.963937, 0.966476, 0.968508, 0.969778, 0.971048, 0.972317, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 
      
0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973333, 0.973841, 0.976381, 0.978921, 0.98146, 0.984, 0.98781, 0.991619, 0.995429, 0.999238, 1.00203, 1.00457, 
      
1.00711, 1.00965, 1.01219, 1.01473, 1.01727, 1.01981, 1.08533, 1.24533, 1.40533, 1.56533, 1.73651, 1.95238, 2.16825, 2.38413, 2.6, 0, 0, 0, 0, 0, 
      
0.409118, 0.487941, 0.566765, 0.645588, 0.702059, 0.736176, 0.770294, 0.804412, 0.833824, 0.849118, 0.864412, 0.879706, 0.895, 0.899706, 0.904412, 0.909118, 0.913823, 0.921176, 0.929412, 0.937647, 
      
0.945882, 0.951176, 0.953529, 0.955882, 0.958235, 0.960588, 0.962941, 0.965294, 0.967647, 0.97, 0.971177, 0.972353, 0.973529, 0.974706, 0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 
      
0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 0.975, 0.976177, 0.978529, 0.980882, 0.983235, 0.985882, 
      
0.989412, 0.992941, 0.996471, 1, 1.00235, 1.00471, 1.00706, 1.00941, 1.01177, 1.01412, 1.01647, 1.01882, 1.09412, 1.24235, 1.39059, 1.53882, 1.7, 1.9, 2.1, 2.3, 
      
2.5, 0, 0, 0, 0, 0, 0.414047, 0.491256, 0.568465, 0.645674, 0.705333, 0.738667, 0.772, 0.805333, 0.836806, 0.851535, 0.866264, 0.880992, 0.895721, 0.902139, 
      
0.906481, 0.910822, 0.915163, 0.921519, 0.929891, 0.938264, 0.946636, 0.953767, 0.955938, 0.958109, 0.960279, 0.96245, 0.96462, 0.966791, 0.968961, 0.971132, 0.972651, 0.973736, 0.974822, 0.975907, 
      
0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 0.976667, 
      
0.976667, 0.976667, 0.978403, 0.980574, 0.982744, 0.984915, 0.987628, 0.990884, 0.99414, 0.997395, 1.00043, 1.0026, 1.00478, 1.00695, 1.00912, 1.01129, 1.01346, 1.01563, 1.0178, 1.10071, 
      
1.23746, 1.3742, 1.51095, 1.66202, 1.84651, 2.03101, 2.2155, 2.4, 0, 0, 0, 0, 0, 0.419161, 0.494793, 0.570425, 0.646057, 0.70877, 0.741337, 0.773904, 
      
0.806471, 0.839038, 0.854134, 0.86831, 0.882487, 0.896663, 0.904724, 0.908709, 0.912694, 0.916678, 0.921793, 0.930299, 0.938805, 0.94731, 0.955816, 0.95846, 0.960452, 0.962444, 0.964437, 0.966429, 
      
0.968421, 0.970414, 0.972406, 0.974199, 0.975195, 0.976192, 0.977188, 0.978184, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 
      
0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978333, 0.978533, 0.980525, 0.982517, 0.98451, 0.986502, 0.989241, 0.99223, 0.995218, 0.998207, 1.0008, 1.00279, 
      
1.00478, 1.00677, 1.00877, 1.01076, 1.01275, 1.01474, 1.01674, 1.1052, 1.23071, 1.35623, 1.48175, 1.6226, 1.79195, 1.9613, 2.13065, 2.3, 0, 0, 0, 0, 
      
0, 0.424455, 0.498545, 0.572636, 0.646727, 0.712364, 0.744182, 0.776, 0.807818, 0.839636, 0.856909, 0.870545, 0.884182, 0.897818, 0.907455, 0.911091, 0.914727, 0.918364, 0.922, 0.930636, 
      
0.939273, 0.947909, 0.956545, 0.961091, 0.962909, 0.964727, 0.966545, 0.968364, 0.970182, 0.972, 0.973818, 0.975636, 0.976727, 0.977636, 0.978545, 0.979455, 0.98, 0.98, 0.98, 0.98, 
      
0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.98, 0.980727, 0.982545, 
      
0.984364, 0.986182, 0.988, 0.990727, 0.993455, 0.996182, 0.998909, 1.00109, 1.00291, 1.00473, 1.00654, 1.00836, 1.01018, 1.012, 1.01382, 1.01564, 1.10764, 1.22218, 1.33673, 1.45127, 
      
1.58182, 1.73636, 1.89091, 2.04545, 2.2, 0, 0, 0, 0, 0, 0.429921, 0.502506, 0.57509, 0.647674, 0.716109, 0.747195, 0.778281, 0.809367, 0.840453, 0.859854, 
      
0.872963, 0.886071, 0.89918, 0.910326, 0.913622, 0.916918, 0.920213, 0.923509, 0.930906, 0.93967, 0.948434, 0.957199, 0.963828, 0.965476, 0.967124, 0.968772, 0.970419, 0.972067, 0.973715, 0.975363, 
      
0.977011, 0.97833, 0.979154, 0.979978, 0.980802, 0.981625, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 
      
0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.981667, 0.98282, 0.984468, 0.986116, 0.987764, 0.989618, 0.99209, 0.994562, 0.997034, 0.999506, 1.00132, 1.00297, 1.00461, 
      
1.00626, 1.00791, 1.00956, 1.01121, 1.01285, 1.0145, 1.1081, 1.21193, 1.31575, 1.41957, 1.5397, 1.67978, 1.81985, 1.95993, 2.1, 0, 0, 0, 0, 0, 
      
0.435556, 0.506667, 0.577778, 0.648889, 0.72, 0.75037, 0.780741, 0.811111, 0.841481, 0.862963, 0.875556, 0.888148, 0.900741, 0.913333, 0.916296, 0.919259, 0.922222, 0.925185, 0.931111, 0.94, 
      
0.948889, 0.957778, 0.966667, 0.968148, 0.96963, 0.971111, 0.972593, 0.974074, 0.975556, 0.977037, 0.978519, 0.98, 0.980741, 0.981481, 0.982222, 0.982963, 0.983333, 0.983333, 0.983333, 0.983333, 
      
0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.983333, 0.984815, 
      
0.986296, 0.987778, 0.989259, 0.991111, 0.993333, 0.995556, 0.997778, 1, 1.00148, 1.00296, 1.00444, 1.00593, 1.00741, 1.00889, 1.01037, 1.01185, 1.01333, 1.10667, 1.2, 1.29333, 
      
1.38667, 1.4963, 1.62222, 1.74815, 1.87407, 2, 0, 0, 0, 0, 0, 0.441352, 0.511022, 0.580692, 0.650363, 0.720033, 0.753703, 0.783374, 0.813044, 0.842714, 
      
0.866231, 0.878319, 0.890407, 0.902494, 0.914582, 0.91911, 0.921747, 0.924385, 0.927022, 0.931253, 0.940264, 0.949275, 0.958286, 0.967297, 0.970923, 0.972242, 0.97356, 0.974879, 0.976198, 0.977516, 
      
0.978835, 0.980154, 0.981472, 0.982396, 0.983055, 0.983714, 0.984374, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 
      
0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985396, 0.986714, 0.988033, 0.989352, 0.99067, 0.992483, 0.994462, 0.99644, 0.998418, 1.00026, 
      
1.00158, 1.0029, 1.00422, 1.00554, 1.00686, 1.00818, 1.0095, 1.01081, 1.02031, 1.10338, 1.18646, 1.26954, 1.35262, 1.45165, 1.56374, 1.67582, 1.78791, 1.9, 0, 0, 
      
0, 0, 0, 0.447304, 0.515565, 0.583826, 0.652087, 0.720348, 0.757188, 0.786174, 0.815159, 0.844145, 0.869652, 0.881246, 0.892841, 0.904435, 0.916029, 0.922058, 0.924377, 0.926696, 
      
0.929014, 0.931333, 0.940464, 0.949594, 0.958725, 0.967855, 0.973797, 0.974957, 0.976116, 0.977275, 0.978435, 0.979594, 0.980754, 0.981913, 0.983072, 0.984116, 0.984696, 0.985275, 0.985855, 0.986435, 
      
0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 0.986667, 
      
0.986667, 0.986667, 0.986667, 0.987362, 0.988522, 0.989681, 0.990841, 0.992, 0.993739, 0.995478, 0.997217, 0.998957, 1.00046, 1.00162, 1.00278, 1.00394, 1.0051, 1.00626, 1.00742, 1.00858, 
      
1.00974, 1.02528, 1.09832, 1.17136, 1.24441, 1.31745, 1.4058, 1.50435, 1.6029, 1.70145, 1.8, 0, 0, 0, 0, 0, 0.453409, 0.52029, 0.587172, 0.654054, 
      
0.720935, 0.760821, 0.789136, 0.817452, 0.845767, 0.873222, 0.884333, 0.895444, 0.906556, 0.917667, 0.925136, 0.927143, 0.929151, 0.931158, 0.933165, 0.940602, 0.949849, 0.959097, 0.968344, 0.976767, 
      
0.977771, 0.978774, 0.979778, 0.980781, 0.981785, 0.982789, 0.983792, 0.984796, 0.985799, 0.986401, 0.986903, 0.987405, 0.987907, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 
      
0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.988333, 0.989237, 0.99024, 0.991244, 
      
0.992247, 0.993376, 0.994882, 0.996387, 0.997892, 0.999398, 1.0006, 1.00161, 1.00261, 1.00361, 1.00462, 1.00562, 1.00662, 1.00763, 1.00863, 1.0283, 1.09153, 1.15475, 1.21798, 1.2812, 
      
1.35878, 1.44409, 1.52939, 1.61469, 1.7, 0, 0, 0, 0, 0, 0.45966, 0.525191, 0.590723, 0.656255, 0.721787, 0.764596, 0.792255, 0.819915, 0.847574, 0.875234, 
      
0.887574, 0.898213, 0.908851, 0.919489, 0.92834, 0.930043, 0.931745, 0.933447, 0.935149, 0.940681, 0.950043, 0.959404, 0.968766, 0.978128, 0.980681, 0.981532, 0.982383, 0.983234, 0.984085, 0.984936, 
      
0.985787, 0.986638, 0.987489, 0.98817, 0.988596, 0.989021, 0.989447, 0.989872, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 
      
0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99, 0.99017, 0.991021, 0.991872, 0.992723, 0.993575, 0.994638, 0.995915, 0.997191, 0.998468, 
      
0.999745, 1.00068, 1.00153, 1.00238, 1.00323, 1.00408, 1.00494, 1.00579, 1.00664, 1.00749, 1.02945, 1.08306, 1.13668, 1.1903, 1.24391, 1.31064, 1.38298, 1.45532, 1.52766, 1.6, 
      
0, 0, 0, 0, 0, 0.466053, 0.530263, 0.594474, 0.658684, 0.722895, 0.768509, 0.795526, 0.822544, 0.849561, 0.876579, 0.890965, 0.90114, 0.911316, 0.921491, 0.931667, 
      
0.93307, 0.934474, 0.935877, 0.937281, 0.940702, 0.950175, 0.959649, 0.969123, 0.978597, 0.983684, 0.984386, 0.985088, 0.985789, 0.986491, 0.987193, 0.987895, 0.988596, 0.989298, 0.99, 0.990351, 
      
0.990702, 0.991053, 0.991404, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 
      
0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.991667, 0.992018, 0.992719, 0.993421, 0.994123, 0.994825, 0.995789, 0.996842, 0.997895, 0.998947, 1, 1.0007, 1.0014, 1.0021, 
      
1.00281, 1.00351, 1.00421, 1.00491, 1.00561, 1.00632, 1.02877, 1.07298, 1.11719, 1.1614, 1.20561, 1.2614, 1.32105, 1.3807, 1.44035, 1.5, 0, 0, 0, 0, 
      
0, 0.472583, 0.5355, 0.598417, 0.661333, 0.72425, 0.772556, 0.798944, 0.825333, 0.851722, 0.878111, 0.8945, 0.904222, 0.913944, 0.923667, 0.933389, 0.936222, 0.937333, 0.938444, 0.939556, 
      
0.940667, 0.95025, 0.959833, 0.969417, 0.979, 0.986778, 0.987333, 0.987889, 0.988444, 0.989, 0.989556, 0.990111, 0.990667, 0.991222, 0.991778, 0.992167, 0.992444, 0.992722, 0.993, 0.993278, 
      
0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 0.993333, 
      
0.993333, 0.993333, 0.993333, 0.993333, 0.993778, 0.994333, 0.994889, 0.995444, 0.996, 0.996833, 0.997667, 0.9985, 0.999333, 1.00011, 1.00067, 1.00122, 1.00178, 1.00233, 1.00289, 1.00344, 
      
1.004, 1.00456, 1.00511, 1.02633, 1.06133, 1.09633, 1.13133, 1.16633, 1.21111, 1.25833, 1.30556, 1.35278, 1.4, 0, 0, 0, 0, 0, 0.479247, 0.540897, 
      
0.602546, 0.664196, 0.725845, 0.776732, 0.802505, 0.828278, 0.854052, 0.879825, 0.898175, 0.907454, 0.916732, 0.92601, 0.935289, 0.939495, 0.94032, 0.941144, 0.941969, 0.942794, 0.950268, 0.959959, 
      
0.969649, 0.97934, 0.989031, 0.990371, 0.990784, 0.991196, 0.991608, 0.992021, 0.992433, 0.992845, 0.993258, 0.99367, 0.994041, 0.994247, 0.994454, 0.99466, 0.994866, 0.995, 0.995, 0.995, 
      
0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 0.995, 
      
0.995, 0.995041, 0.995454, 0.995866, 0.996278, 0.996691, 0.997155, 0.997773, 0.998392, 0.99901, 0.999629, 1.00016, 1.00058, 1.00099, 1.0014, 1.00181, 1.00223, 1.00264, 1.00305, 1.00346, 
      
1.00388, 1.02219, 1.04816, 1.07414, 1.10012, 1.1261, 1.15979, 1.19484, 1.2299, 1.26495, 1.3, 0, 0, 0, 0, 0, 0.486041, 0.546449, 0.606857, 0.667265, 
      
0.727673, 0.781034, 0.806204, 0.831374, 0.856544, 0.881714, 0.901986, 0.91083, 0.919673, 0.928517, 0.937361, 0.942884, 0.943429, 0.943973, 0.944517, 0.945061, 0.950231, 0.960027, 0.969823, 0.979619, 
      
0.989415, 0.993497, 0.993769, 0.994041, 0.994313, 0.994585, 0.994857, 0.995129, 0.995401, 0.995673, 0.995946, 0.996109, 0.996245, 0.996381, 0.996517, 0.996653, 0.996667, 0.996667, 0.996667, 0.996667, 
      
0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 0.996667, 
      
0.996776, 0.997048, 0.99732, 0.997592, 0.997864, 0.998204, 0.998612, 0.99902, 0.999429, 0.999837, 1.00016, 1.00043, 1.00071, 1.00098, 1.00125, 1.00152, 1.0018, 1.00207, 1.00234, 1.00261, 
      
1.01638, 1.03352, 1.05067, 1.06781, 1.08495, 1.10748, 1.13061, 1.15374, 1.17687, 1.2, 0, 0, 0, 0, 0, 0.49296, 0.552152, 0.611343, 0.670535, 0.729727, 
      
0.785458, 0.810037, 0.834616, 0.859195, 0.883774, 0.905929, 0.914347, 0.922764, 0.931182, 0.939599, 0.946387, 0.946657, 0.946926, 0.947195, 0.947465, 0.950141, 0.96004, 0.969939, 0.979838, 0.989737, 
      
0.996707, 0.996842, 0.996976, 0.997111, 0.997246, 0.99738, 0.997515, 0.99765, 0.997785, 0.997919, 0.998027, 0.998094, 0.998162, 0.998229, 0.998296, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 
      
0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 0.998333, 
      
0.998428, 0.998562, 0.998697, 0.998832, 0.998966, 0.999152, 0.999354, 0.999556, 0.999758, 0.99996, 1.00011, 1.00024, 1.00038, 1.00051, 1.00065, 1.00078, 1.00092, 1.00105, 1.00119, 1.00132, 
      
1.00897, 1.01745, 1.02594, 1.03442, 1.04291, 1.05421, 1.06566, 1.07711, 1.08855, 1.1, 0, 0, 0, 0, 0, 0.5, 0.558, 0.616, 0.674, 0.732, 
      
0.79, 0.814, 0.838, 0.862, 0.886, 0.91, 0.918, 0.926, 0.934, 0.942, 0.95, 0.95, 0.95, 0.95, 0.95, 0.95, 0.96, 0.97, 0.98, 0.99, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0.578, 0.626, 0.674, 
      
0.722, 0.77, 0.818, 0.836909, 0.855818, 0.874727, 0.893636, 0.912546, 0.924546, 0.929636, 0.934727, 0.939818, 0.944909, 0.95, 0.951818, 0.953636, 0.955455, 0.957273, 0.959091, 0.963636, 
      
0.970909, 0.978182, 0.985455, 0.992727, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0.608, 
      
0.647667, 0.687333, 0.727, 0.766667, 0.806333, 0.846, 0.860667, 0.875333, 0.89, 0.904667, 0.919333, 0.934, 0.936667, 0.939333, 0.942, 0.944667, 0.947333, 0.95, 0.953333, 0.956667, 
      
0.96, 0.963333, 0.966667, 0.97, 0.975, 0.98, 0.985, 0.99, 0.995, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      
0, 0, 0, 0.678308, 0.710923, 0.743538, 0.776154, 0.808769, 0.841385, 0.874, 0.885077, 0.896154, 0.907231, 0.918308, 0.929385, 0.940462, 0.946308, 0.946923, 0.947538, 0.948154, 
      
0.948769, 0.949385, 0.95, 0.954615, 0.959231, 0.963846, 0.968462, 0.973077, 0.977692, 0.981538, 0.984615, 0.987692, 0.990769, 0.993846, 0.996923, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0.716, 0.742571, 0.769143, 0.795714, 0.822286, 0.848857, 0.875429, 0.902, 0.91, 0.918, 0.926, 0.934, 0.942, 
      
0.95, 0.958, 0.956857, 0.955714, 0.954571, 0.953429, 0.952286, 0.951143, 0.95, 0.955714, 0.961429, 0.967143, 0.972857, 0.978571, 0.984286, 0.99, 0.991429, 0.992857, 0.994286, 0.995714, 
      
0.997143, 0.998571, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0.780667, 0.802, 0.823333, 0.844667, 0.866, 0.887333, 0.908667, 
      
0.93, 0.935333, 0.940667, 0.946, 0.951333, 0.956667, 0.962, 0.967333, 0.968667, 0.966, 0.963333, 0.960667, 0.958, 0.955333, 0.952667, 0.95, 0.956667, 0.963333, 0.97, 0.976667, 
      
0.983333, 0.99, 0.996667, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0.79, 
      
0.80825, 0.8265, 0.84475, 0.863, 0.88125, 0.8995, 0.91775, 0.936, 0.9405, 0.945, 0.9495, 0.954, 0.9585, 0.963, 0.9675, 0.972, 0.9705, 0.969, 0.9675, 0.966, 
      
0.9645, 0.963, 0.9615, 0.96, 0.965, 0.97, 0.975, 0.98, 0.985, 0.99, 0.995, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0.817765, 0.833294, 0.848824, 0.864353, 0.879882, 0.895412, 0.910941, 0.926471, 0.942, 0.945765, 0.949529, 0.953294, 0.957059, 
      
0.960824, 0.964588, 0.968353, 0.972118, 0.973765, 0.973294, 0.972824, 0.972353, 0.971882, 0.971412, 0.970941, 0.970471, 0.97, 0.973529, 0.977059, 0.980588, 0.984118, 0.987647, 0.991176, 0.994706, 
      
0.998235, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.83, 0.843111, 0.856222, 0.869333, 0.882444, 
      
0.895556, 0.908667, 0.921778, 0.934889, 0.948, 0.951111, 0.954222, 0.957333, 0.960444, 0.963556, 0.966667, 0.969778, 0.972889, 0.976, 0.976444, 0.976889, 0.977333, 0.977778, 0.978222, 0.978667, 
      
0.979111, 0.979556, 0.98, 0.982222, 0.984444, 0.986667, 0.988889, 0.991111, 0.993333, 0.995556, 0.997778, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0.855474, 0.866421, 0.877368, 0.888316, 0.899263, 0.910211, 0.921158, 0.932105, 0.943053, 0.954, 0.956526, 0.959053, 0.961579, 0.964105, 0.966632, 
      
0.969158, 0.971684, 0.974211, 0.976737, 0.978632, 0.979895, 0.981158, 0.982421, 0.983684, 0.984947, 0.986211, 0.987474, 0.988737, 0.99, 0.991053, 0.992105, 0.993158, 0.994211, 0.995263, 0.996316, 
      
0.997368, 0.998421, 0.999474, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.87, 0.879, 0.888, 0.897, 0.906, 
      
0.915, 0.924, 0.933, 0.942, 0.951, 0.96, 0.962, 0.964, 0.966, 0.968, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 
      
0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0.884, 0.892, 0.9, 0.908, 0.916, 0.924, 0.932, 0.94, 0.948, 0.956, 0.964, 0.965714, 0.967429, 
      
0.969143, 0.970857, 0.972571, 0.974286, 0.976, 0.977714, 0.979429, 0.981143, 0.982857, 0.984571, 0.986286, 0.988, 0.989714, 0.991429, 0.993143, 0.994857, 0.996571, 0.998286, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.89, 
      
0.897091, 0.904182, 0.911273, 0.918364, 0.925455, 0.932545, 0.939636, 0.946727, 0.953818, 0.960909, 0.968, 0.969455, 0.970909, 0.972364, 0.973818, 0.975273, 0.976727, 0.978182, 0.979636, 0.981091, 
      
0.982545, 0.984, 0.985455, 0.986909, 0.988364, 0.989818, 0.991273, 0.992727, 0.994182, 0.995636, 0.997091, 0.998545, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.90313, 0.909391, 0.915652, 0.921913, 0.928174, 0.934435, 0.940696, 
      
0.946957, 0.953217, 0.959478, 0.965739, 0.972, 0.973217, 0.974435, 0.975652, 0.97687, 0.978087, 0.979304, 0.980522, 0.981739, 0.982957, 0.984174, 0.985391, 0.986609, 0.987826, 0.989043, 0.990261, 
      
0.991478, 0.992696, 0.993913, 0.99513, 0.996348, 0.997565, 0.998783, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0.91, 0.9155, 0.921, 0.9265, 0.932, 0.9375, 0.943, 0.9485, 0.954, 0.9595, 0.965, 0.9705, 0.976, 
      
0.977, 0.978, 0.979, 0.98, 0.981, 0.982, 0.983, 0.984, 0.985, 0.986, 0.987, 0.988, 0.989, 0.99, 0.991, 0.992, 0.993, 0.994, 0.995, 0.996, 
      
0.997, 0.998, 0.999, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0.9224, 0.9272, 0.932, 0.9368, 0.9416, 0.9464, 0.9512, 0.956, 0.9608, 0.9656, 0.9704, 0.9752, 0.98, 0.9808, 0.9816, 0.9824, 0.9832, 
      
0.984, 0.9848, 0.9856, 0.9864, 0.9872, 0.988, 0.9888, 0.9896, 0.9904, 0.9912, 0.992, 0.9928, 0.9936, 0.9944, 0.9952, 0.996, 0.9968, 0.9976, 0.9984, 0.9992, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.93, 
      
0.934154, 0.938308, 0.942462, 0.946615, 0.950769, 0.954923, 0.959077, 0.963231, 0.967385, 0.971538, 0.975692, 0.979846, 0.984, 0.984615, 0.985231, 0.985846, 0.986462, 0.987077, 0.987692, 0.988308, 
      
0.988923, 0.989538, 0.990154, 0.990769, 0.991385, 0.992, 0.992615, 0.993231, 0.993846, 0.994462, 0.995077, 0.995692, 0.996308, 0.996923, 0.997538, 0.998154, 0.998769, 0.999385, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.941778, 0.945333, 0.948889, 
      
0.952444, 0.956, 0.959556, 0.963111, 0.966667, 0.970222, 0.973778, 0.977333, 0.980889, 0.984444, 0.988, 0.988444, 0.988889, 0.989333, 0.989778, 0.990222, 0.990667, 0.991111, 0.991556, 0.992, 
      
0.992444, 0.992889, 0.993333, 0.993778, 0.994222, 0.994667, 0.995111, 0.995556, 0.996, 0.996444, 0.996889, 0.997333, 0.997778, 0.998222, 0.998667, 0.999111, 0.999556, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.95, 0.953, 0.956, 0.959, 0.962, 
      
0.965, 0.968, 0.971, 0.974, 0.977, 0.98, 0.983, 0.986, 0.989, 0.992, 0.992286, 0.992571, 0.992857, 0.993143, 0.993429, 0.993714, 0.994, 0.994286, 0.994571, 0.994857, 
      
0.995143, 0.995429, 0.995714, 0.996, 0.996286, 0.996571, 0.996857, 0.997143, 0.997429, 0.997714, 0.998, 0.998286, 0.998571, 0.998857, 0.999143, 0.999429, 0.999714, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.961241, 0.963724, 0.966207, 0.96869, 0.971172, 
      
0.973655, 0.976138, 0.978621, 0.981103, 0.983586, 0.986069, 0.988552, 0.991035, 0.993517, 0.996, 0.996138, 0.996276, 0.996414, 0.996552, 0.99669, 0.996828, 0.996966, 0.997103, 0.997241, 0.997379, 
      
0.997517, 0.997655, 0.997793, 0.997931, 0.998069, 0.998207, 0.998345, 0.998483, 0.998621, 0.998759, 0.998897, 0.999035, 0.999172, 0.99931, 0.999448, 0.999586, 0.999724, 0.999862, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 
      
0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 
      
0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 
      
0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 
      
0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 
      
0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 
      
0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 
      
0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 
      
0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 
      
0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 
      
0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 
      
0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 
      
0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 
      
0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 
      
0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 
      
0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 
      
0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 
      
0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 
      
0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 
      
0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 
      
0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 
      
0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 
      
0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 
      
0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 
      
0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 
      
0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 
      
0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 
      
0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 
      
0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 
      
0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 
      
0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 
      
0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 
      
0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 
      
0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 
      
0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 
      
0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 
      
0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 
      
0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 
      
0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 
      
0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 
      
0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 
      
0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 
      
0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 
      
0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 
      
0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 
      
0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 
      
0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 
      
0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 
      
0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 
      
0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      
0, 0.97, 0.972, 0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 
      
0.974, 0.976, 0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 
      
0.978, 0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 
      
0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97, 0.972, 0.974, 0.976, 0.978, 
      
0.98, 0.982, 0.984, 0.986, 0.988, 0.99, 0.992, 0.994, 0.996, 0.998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      
1          };
      vec = std::vector<real_t>(arr, arr + sizeof(arr) / sizeof(arr[0]) );
      }
    }
  }
}
