function offline_data = offline_phase(fault,sc_sp,sc_mu,sc_th,sc_eth,settings)
    height_max_sp = 1000;
    height_max_mu = 1000;
    height_max_th = 2000;
    height_max_eth = 2000;
    height_min = min(height_max_sp,min(fault.parameters.H_sc-fault.samples.h))-2;
    depths_sp_max = 2000;
    depths_mu_max = 5000;
    depths_th_max = 2000;
    depths_eth_max = 2000;
    L_th_min = 10;
    L_th_max = 50;
    L_eth_min=1;
    L_eth_max = 30;
    Lambda_sp_min = 180;
    Lambda_sp_max = 220;
    Lambda_mu_min = 1300;
    Lambda_mu_max = 1700;
    rho_min = 1.2;
    rho_max = 1.8;
    N_depths = 8000;
    N_heights = 10;
    N_rhos = 50;
    N_lambdas = 20;
    resl = [N_depths,N_heights,N_rhos,N_lambdas];
    N = 4;
    tensor_bounds_sp = [0,depths_sp_max;height_min,height_max_sp;rho_min,rho_max;Lambda_sp_min,Lambda_sp_max];
    tensor_bounds_mu = [0,depths_mu_max;height_min,height_max_mu;rho_min,rho_max;Lambda_mu_min,Lambda_mu_max];
    tensor_bounds_th = [0,depths_th_max;height_min,height_max_th;rho_min,rho_max;L_th_min,L_th_max];
    tensor_bounds_eth = [0,depths_eth_max;height_min,height_max_eth;rho_min,rho_max;L_eth_min,L_eth_max];  
    w = [1 2 2 2];
    if N_heights == 1
        w(2) = 1e6;
    end
    L = settings.L;
    sc_mu_sg = sgconstruct(N,w,L,sc_mu,tensor_bounds_mu');
    sc_sp_sg = sgconstruct(N,w,L,sc_sp,tensor_bounds_sp'); 
    sc_th_sg = sgconstruct(N,w,L,sc_th,tensor_bounds_th');
    sc_eth_sg = sgconstruct(N,w,L,sc_eth,tensor_bounds_eth');
    sc_sp_tensor = sgtensor(sc_sp_sg,resl);
    sc_mu_tensor = sgtensor(sc_mu_sg,resl);
    sc_th_tensor = sgtensor(sc_th_sg,resl);
    sc_eth_tensor = sgtensor(sc_eth_sg,resl);
    tensors = max(0,reshape(ndinterp({sc_sp_tensor,sc_mu_tensor,sc_th_tensor,sc_eth_tensor}),N_depths,N_heights,N_rhos,N_lambdas,4));
    tensors(end,:,:,:,:) = 0;
    sc_sp_tensor = tensors(:,:,:,:,1);
    sc_mu_tensor = tensors(:,:,:,:,2);
    sc_th_tensor = tensors(:,:,:,:,3);
    sc_eth_tensor = tensors(:,:,:,:,4);
    tensor_bounds_sp = [tensor_bounds_sp,[N_depths;N_heights;N_rhos;N_lambdas]];
    tensor_bounds_mu = [tensor_bounds_mu,[N_depths;N_heights;N_rhos;N_lambdas]];
    tensor_bounds_th = [tensor_bounds_th,[N_depths;N_heights;N_rhos;N_lambdas]];
    tensor_bounds_eth = [tensor_bounds_eth,[N_depths;N_heights;N_rhos;N_lambdas]];
    offline_data.sc_sp = {sc_sp_tensor,tensor_bounds_sp};
    offline_data.sc_mu = {sc_mu_tensor,tensor_bounds_mu};
    offline_data.sc_th = {sc_th_tensor,tensor_bounds_th};
    offline_data.sc_eth = {sc_eth_tensor,tensor_bounds_eth};
end
