#!/usr/bin/env python
import numpy as np

def tree(X,X_tl,B):
  # mean
  gpp,gam1,gam2,gam3,etac=X[:5]
  tau1,tau2,tau3,tau4,tau5=X[5:10]
  f1,f2,f3,f4,f5=X[10:15]
  s1,s2,s3,s5=X[15:19]
  eps1,eps2,eps3=X[19:22]
  Nd,Nfix=X[22:24]
  leachingratio=X[24]
  gfrac=X[25]
  l1,l2,l3,l5=X[26:30]
  tht1,tht2,tht3=X[30:33]
  Pw,Pd=X[33:35]
  dissfrac=X[35]
  fsorb=X[36]
  npp=X[37]
  fashP=X[38]
  # tangent linear
  gpp_tl,gam1_tl,gam2_tl,gam3_tl,etac_tl=X_tl[:5]
  tau1_tl,tau2_tl,tau3_tl,tau4_tl,tau5_tl=X_tl[5:10]
  f1_tl,f2_tl,f3_tl,f4_tl,f5_tl=X_tl[10:15]
  s1_tl,s2_tl,s3_tl,s5_tl=X_tl[15:19]
  eps1_tl,eps2_tl,eps3_tl=X_tl[19:22]
  Nd_tl,Nfix_tl=X_tl[22:24]
  leachingratio_tl=X_tl[24]
  gfrac_tl=X_tl[25]
  l1_tl,l2_tl,l3_tl,l5_tl=X_tl[26:30]
  tht1_tl,tht2_tl,tht3_tl=X_tl[30:33]
  Pw_tl,Pd_tl=X_tl[33:35]
  dissfrac_tl=X_tl[35]
  fsorb_tl=X_tl[36]
  npp_tl=X_tl[37] 
  fashP_tl=X_tl[38]

  C1=gpp*gam1*tau1
  C1_tl=gpp_tl*gam1*tau1+gpp*gam1_tl*tau1+gpp*gam1*tau1_tl
  C2=gpp*gam2*tau2
  C2_tl=gpp_tl*gam2*tau2+gpp*gam2_tl*tau2+gpp*gam2*tau2_tl
  C3=gpp*gam3*tau3
  C3_tl=gpp_tl*gam3*tau1+gpp*gam3_tl*tau3+gpp*gam3*tau3_tl
  C4=gpp*(gam1*(1.-f1)+gam2*(1.-f2))*tau4
  C4_tl=gpp_tl*(gam1*(1.-f1)+gam2*(1.-f2))*tau4+gpp*(gam1_tl*(1.-f1)-gam1*f1_tl+gam2_tl*(1.-f2)-gam2*f2_tl)*tau4+gpp*(gam1+gam2)*tau4_tl
  C5=(gpp*gam3*(1.-f3)+etac*C4/tau4)*tau5
  C5_tl=(gpp_tl*gam3*(1.-f3)+gpp*gam3_tl*(1.-f3)-gpp*gam3*f3_tl+(etac_tl*C4+etac*C4_tl)/tau4-etac*C4/tau4**2*tau4_tl)*tau5+(gpp*gam3+etac*C4/tau4)*tau5_tl
  Fc=npp
  Fc_tl=npp_tl
  mort1=gpp*gam1*(1.-f1)
  mort1_tl=(gpp_tl*gam1+gpp*gam1_tl)*(1.-f1)-gpp*gam1*f1_tl
  mort2=gpp*gam2*(1.-f2)
  mort2_tl=(gpp_tl*gam2+gpp*gam2_tl)*(1.-f2)-gpp*gam2*f2_tl
  mort3=gpp*gam3*(1.-f3)
  mort3_tl=(gpp_tl*gam3+gpp*gam3_tl)*(1.-f3)-gpp*gam3*f3_tl
  fire1=gpp*gam1*f1
  fire1_tl=gpp_tl*gam1*f1+gpp*gam1_tl*f1+gpp*gam1*f1_tl
  fire2=gpp*gam2*f2
  fire2_tl=gpp_tl*gam2*f2+gpp*gam2_tl*f2+gpp*gam2*f2_tl
  fire3=gpp*gam3*f3
  fire3_tl=gpp_tl*gam3*f3+gpp*gam3_tl*f3+gpp*gam3*f3_tl
  fire4=C4/tau4*f4
  fire4_tl=C4_tl/tau4*f4-fire4/tau4*tau4_tl+C4/tau4*f4_tl
  fire5=C5/tau5*f5
  fire5_tl=C5_tl/tau5*f5-fire5/tau5*tau5_tl+C5/tau5*f4_tl
  FireC=fire1+fire2+fire3+fire4+fire5
  FireC_tl=fire1_tl+fire2_tl+fire3_tl+fire4_tl+fire5_tl
  # Nitrogen
  s4=(s1*(1.-eps1)*mort1+s2*(1.-eps2)*mort2)/(mort1+mort2)
  s4_tl=((s1_tl*(1.-eps1)-s1*eps1_tl)*mort1+s1*(1.-eps1)*mort1_tl\
        +(s2_tl*(1.-eps2)-s2*eps2_tl)*mort2+s2*(1.-eps2)*mort2_tl)/(mort1+mort2)\
        -s4/(mort1+mort2)*(mort1_tl+mort2_tl)
  Fn1=s1*(mort1*(1.-eps1)+fire1)
  Fn1_tl=s1_tl*(mort1*(1.-eps1)+fire1)+s1*(mort1_tl*(1.-eps1)-mort1*eps1_tl+fire1_tl)
  Fn2=s2*(mort2*(1.-eps2)+fire2)
  Fn2_tl=s2_tl*(mort2*(1.-eps2)+fire2)+s2*(mort2_tl*(1.-eps2)-mort2*eps2_tl+fire2_tl)
  Fn3=s3*(mort3*(1.-eps3)+fire3)
  Fn3_tl=s3_tl*(mort3*(1.-eps3)+fire3)+s3*(mort3_tl*(1.-eps3)-mort3*eps3_tl+fire3_tl)
  Fn=Fn1+Fn2+Fn3
  Fn_tl=Fn1_tl+Fn2_tl+Fn3_tl
  bet1=Fn1/Fn
  bet1_tl=Fn1_tl/Fn-bet1/Fn*Fn_tl
  bet2=Fn2/Fn
  bet2_tl=Fn2_tl/Fn-bet2/Fn*Fn_tl
  bet3=1.-bet1-bet2
  bet3_tl=-bet1_tl-bet2_tl
  FireN=s1*fire1+s2*fire2+s3*fire3+s4*fire4+s5*fire5
  FireN_tl=s1_tl*fire1+s1*fire1_tl+s2_tl*fire2+s2*fire2_tl+s3_tl*fire3+s3*fire3_tl+s4_tl*fire4+s4*fire4_tl+s5_tl*fire5+s5*fire5_tl
  taun4=tau4
  taun4_tl=tau4_tl
  Fl=(1.-gfrac)*(Nd+Nfix-FireN)
  Fl_tl=-gfrac_tl*(Nd+Nfix-FireN)+(1.-gfrac)*(Nd_tl+Nfix_tl-FireN_tl)
  Fg=Nd+Nfix-FireN-Fl
  Fg_tl=Nd_tl+Nfix_tl-FireN_tl-Fl_tl
  n6=Fl/leachingratio
  n6_tl=Fl_tl/leachingratio-n6/leachingratio*leachingratio_tl
  Nim=(s5-s4)*etac*C4/taun4+(s5-s3)*mort3*(1.-eps3)
  Nim_tl=(s5_tl-s4_tl)*etac*C4/taun4+(s5-s4)*(etac_tl*C4+etac*C4_tl)/taun4-Nim/taun4*taun4_tl\
        +(s5_tl-s3_tl)*mort3*(1.-eps3)+(s5-s3)*mort3_tl*(1.-eps3)-(s5-s3)*mort3*eps3_tl
  Nmin1=(1.-f4-etac)*s4*C4/taun4
  Nmin1_tl=(-f4_tl-etac_tl)*s4*C4/taun4+(1.-f4-etac)*(s4_tl*C4+s4*C4_tl)/taun4-Nmin1/taun4*taun4_tl
  Nmin2=(1.-f5)*s5*C5/tau5
  Nmin2_tl=(-f5_tl)*s5*C5/tau5+(1.-f5)*(s5_tl*C5+s5*C5_tl)/tau5-Nmin2/tau5*tau5_tl
  # Phosphorus
  l4=(l1*(1.-tht1)*mort1+l2*(1.-tht2)*mort2)/(mort1+mort2)
  l4_tl=((l1_tl*(1.-tht1)-l1*tht1_tl)*mort1+l1*(1.-tht1)*mort1_tl\
        +(l2_tl*(1.-tht2)-l2*tht2_tl)*mort2+l2*(1.-tht2)*mort2_tl)/(mort1+mort2)\
        -l4/(mort1+mort2)*(mort1_tl+mort2_tl)
  Fp1=l1*(mort1*(1.-tht1)+fire1)
  Fp1_tl=l1_tl*(mort1*(1.-tht1)+fire1)+l1*(mort1_tl*(1.-tht1)-mort1*tht1_tl+fire1_tl)
  Fp2=l2*(mort2*(1.-tht2)+fire2)
  Fp2_tl=l2_tl*(mort2*(1.-tht2)+fire2)+l2*(mort2_tl*(1.-tht2)-mort2*tht2_tl+fire2_tl)
  Fp3=l3*(mort3*(1.-tht3)+fire3)
  Fp3_tl=l3_tl*(mort3*(1.-tht3)+fire3)+l3*(mort3_tl*(1.-tht3)-mort3*tht3_tl+fire3_tl)
  Fp=Fp1+Fp2+Fp3
  Fp_tl=Fp1_tl+Fp2_tl+Fp3_tl
  phi1=Fp1/Fp
  phi1_tl=Fp1_tl/Fp-phi1/Fp*Fp_tl
  phi2=Fp2/Fp
  phi2_tl=Fp2_tl/Fp-phi2/Fp*Fp_tl
  phi3=1.-phi1-phi2
  phi3_tl=-phi1_tl-phi2_tl
  FireP=l1*fire1+l2*fire2+l3*fire3+l4*fire4+l5*fire5
  FireP_tl=l1_tl*fire1+l1*fire1_tl+l2_tl*fire2+l2*fire2_tl+l3_tl*fire3+l3*fire3_tl+l4_tl*fire4+l4*fire4_tl+l5_tl*fire5+l5*fire5_tl
  taup4=tau4
  taup4_tl=tau4_tl
  lossp6=leachingratio*dissfrac+fsorb
  lossp6_tl=leachingratio_tl*dissfrac+leachingratio*dissfrac_tl+fsorb_tl
  p6=(Pw+Pd-FireP*(1.-fashP))/lossp6
  p6_tl=(Pw_tl+Pd_tl-FireP_tl*(1.-fashP)+FireP*fashP_tl)/lossp6-p6/lossp6*lossp6_tl
  Pim=(l5-l4)*etac*C4/taup4+(l5-l3)*mort3*(1.-tht3)
  Pim_tl=(l5_tl-l4_tl)*etac*C4/taup4+(l5-l4)*(etac_tl*C4+etac*C4_tl)/taup4-Pim/taup4*taup4_tl\
        +(l5_tl-l3_tl)*mort3*(1.-tht3)+(l5-l3)*mort3_tl*(1.-tht3)-(l5-l3)*mort3*tht3_tl
  Pmin1=(1.-f4-etac)*l4*C4/taup4
  Pmin1_tl=(-f4_tl-etac_tl)*l4*C4/taup4+(1.-f4-etac)*(l4_tl*C4+l4*C4_tl)/taup4-Pmin1/taup4*taup4_tl
  Pmin2=(1.-f5)*l5*C5/tau5
  Pmin2_tl=(-f5_tl)*l5*C5/tau5+(1.-f5)*(l5_tl*C5+l5*C5_tl)/tau5-Pmin2/tau5*tau5_tl

  NP1=s1/l1
  NP1_tl=s1_tl/l1-NP1/l1*l1_tl
  NP2=s2/l2
  NP2_tl=s2_tl/l2-NP2/l2*l2_tl
  NP3=s3/l3
  NP3_tl=s3_tl/l3-NP3/l3*l3_tl
  NP4=s4/l4
  NP4_tl=s4_tl/l4-NP4/l4*l4_tl
  NP5=s5/l5
  NP5_tl=s5_tl/l5-NP5/l5*l5_tl
  taun1=s1*C1/Fn1
  taun1_tl=(s1_tl*C1+s1*C1_tl)/Fn1-taun1/Fn1*Fn1_tl
  taunbio=(s1*C1+s2*C2+s3*C3)/Fn
  taunbio_tl=(s1_tl*C1+s1*C1_tl+s2_tl*C2+s2*C2_tl+s3_tl*C3+s3*C3_tl)/Fn-taunbio/Fn*Fn_tl
  taun6=n6/(Nd+Nfix+Nmin1+Nmin2)
  taun6_tl=n6_tl/(Nd+Nfix+Nmin1+Nmin2)-taun6/(Nd+Nfix+Nmin1+Nmin2)*(Nd_tl+Nfix_tl+Nmin1_tl+Nmin2_tl)
  NUE=gpp/Fn
  NUE_tl=gpp_tl/Fn-NUE/Fn*Fn_tl
  taup1=l1*C1/Fp1
  taup1_tl=(l1_tl*C1+l1*C1_tl)/Fp1-taup1/Fp1*Fn1_tl
  taupbio=(l1*C1+l2*C2+l3*C3)/Fp
  taupbio_tl=(l1_tl*C1+l1*C1_tl+l2_tl*C2+l2*C2_tl+l3_tl*C3+l3*C3_tl)/Fp-taupbio/Fp*Fp_tl
  taup6=p6/(Pd+Pw+Pmin1+Pmin2+FireP*fashP)
  taup6_tl=p6_tl/(Pd+Pw+Pmin1+Pmin2+FireP*fashP)-taup6/(Pd+Pw+Pmin1+Pmin2+FireP*fashP)*(Pd_tl+Pw_tl+Pmin1_tl+Pmin2_tl+FireP_tl*fashP+FireP*fashP_tl)
  PUE=gpp/Fp
  PUE_tl=gpp_tl/Fp-PUE/Fp*Fp_tl
  OpenN=(Nd+Nfix)/(gpp*gam1*s1+gpp*gam2*s2+gpp*gam3*s3)
  OpenN_tl=(Nd_tl+Nfix_tl)/(gpp*gam1*s1+gpp*gam2*s2+gpp*gam3*s3)\
          -OpenN/(gpp*gam1*s1+gpp*gam2*s2+gpp*gam3*s3)*(gpp_tl*(gam1*s1+gam2*s2+gam3*s3)+gpp*(gam1_tl*s1+gam1*s1_tl+gam2_tl*s2+gam2*s2_tl+gam3_tl*s3+gam3*s3_tl))
  OpenP=(Pd+Pw)/(gpp*gam1*l1+gpp*gam2*l2+gpp*gam3*l3)
  OpenP_tl=(Pd_tl+Pw_tl)/(gpp*gam1*l1+gpp*gam2*l2+gpp*gam3*l3)\
          -OpenP/(gpp*gam1*l1+gpp*gam2*l2+gpp*gam3*l3)*(gpp_tl*(gam1*l1+gam2*l2+gam3*l3)+gpp*(gam1_tl*l1+gam1*l1_tl+gam2_tl*l2+gam2*l2_tl+gam3_tl*l3+gam3*l3_tl))
  RTN=(s1*C1+s2*C2+s3*C3+s4*C4+s5*C5)/(Nd+Nfix)
  RTN_tl=(s1_tl*C1+s1*C1_tl+s2_tl*C2+s2*C2_tl+s3_tl*C3+s3*C3_tl+s4_tl*C4+s4*C4_tl+s5_tl*C5+s5*C5_tl)/(Nd+Nfix)-RTN/(Nd+Nfix)*(Nd_tl+Nfix_tl)
  RTP=(l1*C1+l2*C2+l3*C3+l4*C4+l5*C5)/(Pd+Pw)
  RTP_tl=(l1_tl*C1+l1*C1_tl+l2_tl*C2+l2*C2_tl+l3_tl*C3+l3*C3_tl+l4_tl*C4+l4*C4_tl+l5_tl*C5+l5*C5_tl)/(Pd+Pw)-RTP/(Pd+Pw)*(Pd_tl+Pw_tl)

  H=np.array([C1_tl,C2_tl,C3_tl,C4_tl,C5_tl,Fn_tl,s4_tl,taun4_tl,bet1_tl,bet2_tl,bet3_tl,n6_tl,Nim_tl,Nmin1_tl,Nmin2_tl,\
              Fp_tl,l4_tl,taup4_tl,phi1_tl,phi2_tl,phi3_tl,p6_tl,Pim_tl,Pmin1_tl,Pmin2_tl,\
              FireC_tl,FireN_tl,FireP_tl,NP1_tl,NP2_tl,NP3_tl,NP4_tl,NP5_tl,\
              taun1_tl,taunbio_tl,taun6_tl,taup1_tl,taupbio_tl,taup6_tl,NUE_tl,PUE_tl,OpenN_tl,OpenP_tl,RTN_tl,RTP_tl])
  sigma=np.dot(np.dot(H,B),H.T)

  return np.array([C1,C2,C3,C4,C5,Fn,s4,taun4,bet1,bet2,bet3,n6,Nim,Nmin1,Nmin2,\
                   Fp,l4,taup4,phi1,phi2,phi3,p6,Pim,Pmin1,Pmin2,\
                   FireC,FireN,FireP,NP1,NP2,NP3,NP4,NP5,\
                   taun1,taunbio,taun6,taup1,taupbio,taup6,NUE,PUE,OpenN,OpenP,RTN,RTP]),H,sigma
         
def grass(X,X_tl,B):
  # mean
  gpp,gam1,gam2,gam3,etac=X[:5]
  tau1,tau2,tau3,tau4,tau5=X[5:10]
  f1,f2,f3,f4,f5=X[10:15]
  s1,s2,s3,s5=X[15:19]
  eps1,eps2,eps3=X[19:22]
  Nd,Nfix=X[22:24]
  leachingratio=X[24]
  gfrac=X[25]
  l1,l2,l3,l5=X[26:30]
  tht1,tht2,tht3=X[30:33]
  Pw,Pd=X[33:35]
  dissfrac=X[35]
  fsorb=X[36]
  npp=X[37]
  fashP=X[38]
  # tangent linear
  gpp_tl,gam1_tl,gam2_tl,gam3_tl,etac_tl=X_tl[:5]
  tau1_tl,tau2_tl,tau3_tl,tau4_tl,tau5_tl=X_tl[5:10]
  f1_tl,f2_tl,f3_tl,f4_tl,f5_tl=X_tl[10:15]
  s1_tl,s2_tl,s3_tl,s5_tl=X_tl[15:19]
  eps1_tl,eps2_tl,eps3_tl=X_tl[19:22]
  Nd_tl,Nfix_tl=X_tl[22:24]
  leachingratio_tl=X_tl[24]
  gfrac_tl=X_tl[25]
  l1_tl,l2_tl,l3_tl,l5_tl=X_tl[26:30]
  tht1_tl,tht2_tl,tht3_tl=X_tl[30:33]
  Pw_tl,Pd_tl=X_tl[33:35]
  dissfrac_tl=X_tl[35]
  fsorb_tl=X_tl[36]
  npp_tl=X_tl[37]
  fashP_tl=X_tl[38]

  C1=gpp*gam1*tau1
  C1_tl=gpp_tl*gam1*tau1+gpp*gam1_tl*tau1+gpp*gam1*tau1_tl
  C2=gpp*gam2*tau2
  C2_tl=gpp_tl*gam2*tau2+gpp*gam2_tl*tau2+gpp*gam2*tau2_tl
  C3=0.
  C3_tl=0.*gpp_tl
  C4=gpp*(gam1*(1.-f1)+gam2*(1.-f2))*tau4
  C4_tl=gpp_tl*(gam1*(1.-f1)+gam2*(1.-f2))*tau4+gpp*(gam1_tl*(1.-f1)-gam1*f1_tl+gam2_tl*(1.-f2)-gam2*f2_tl)*tau4+gpp*(gam1+gam2)*tau4_tl
  C5=etac*C4/tau4*tau5
  C5_tl=((etac_tl*C4+etac*C4_tl)/tau4-etac*C4/tau4**2*tau4_tl)*tau5+etac*C4/tau4*tau5_tl
  Fc=npp
  Fc_tl=npp_tl
  mort1=gpp*gam1*(1.-f1)
  mort1_tl=(gpp_tl*gam1+gpp*gam1_tl)*(1.-f1)-gpp*gam1*f1_tl
  mort2=gpp*gam2*(1.-f2)
  mort2_tl=(gpp_tl*gam2+gpp*gam2_tl)*(1.-f2)-gpp*gam2*f2_tl
  mort3=0.
  mort3_tl=0.*gpp_tl
  fire1=gpp*gam1*f1
  fire1_tl=gpp_tl*gam1*f1+gpp*gam1_tl*f1+gpp*gam1*f1_tl
  fire2=gpp*gam2*f2
  fire2_tl=gpp_tl*gam2*f2+gpp*gam2_tl*f2+gpp*gam2*f2_tl
  fire3=0.
  fire3_tl=0.*gpp_tl
  fire4=C4/tau4*f4
  fire4_tl=C4_tl/tau4*f4-fire4/tau4*tau4_tl+C4/tau4*f4_tl
  fire5=C5/tau5*f5
  fire5_tl=C5_tl/tau5*f5-fire5/tau5*tau5_tl+C5/tau5*f4_tl
  FireC=fire1+fire2+fire4+fire5
  FireC_tl=fire1_tl+fire2_tl+fire4_tl+fire5_tl
  # Nitrogen
  s4=(s1*(1.-eps1)*mort1+s2*(1.-eps2)*mort2)/(mort1+mort2)
  s4_tl=((s1_tl*(1.-eps1)-s1*eps1_tl)*mort1+s1*(1.-eps1)*mort1_tl\
        +(s2_tl*(1.-eps2)-s2*eps2_tl)*mort2+s2*(1.-eps2)*mort2_tl)/(mort1+mort2)\
        -s4/(mort1+mort2)*(mort1_tl+mort2_tl)
  Fn1=s1*(mort1*(1.-eps1)+fire1)
  Fn1_tl=s1_tl*(mort1*(1.-eps1)+fire1)+s1*(mort1_tl*(1.-eps1)-mort1*eps1_tl+fire1_tl)
  Fn2=s2*(mort2*(1.-eps2)+fire2)
  Fn2_tl=s2_tl*(mort2*(1.-eps2)+fire2)+s2*(mort2_tl*(1.-eps2)-mort2*eps2_tl+fire2_tl)
  Fn3=0.
  Fn3_tl=0.*s3_tl
  Fn=Fn1+Fn2
  Fn_tl=Fn1_tl+Fn2_tl
  bet1=Fn1/Fn
  bet1_tl=Fn1_tl/Fn-bet1/Fn*Fn_tl
  bet2=1.-bet1
  bet2_tl=-bet1_tl
  bet3=1.-bet1-bet2
  bet3_tl=-bet1_tl-bet2_tl
  FireN=s1*fire1+s2*fire2+s4*fire4+s5*fire5
  FireN_tl=s1_tl*fire1+s1*fire1_tl+s2_tl*fire2+s2*fire2_tl+s4_tl*fire4+s4*fire4_tl+s5_tl*fire5+s5*fire5_tl
  taun4=tau4
  taun4_tl=tau4_tl
  Fl=(1.-gfrac)*(Nd+Nfix-FireN)
  Fl_tl=-gfrac_tl*(Nd+Nfix-FireN)+(1.-gfrac)*(Nd_tl+Nfix_tl-FireN_tl)
  Fg=Nd+Nfix-FireN-Fl
  Fg_tl=Nd_tl+Nfix_tl-FireN_tl-Fl_tl
  n6=Fl/leachingratio
  n6_tl=Fl_tl/leachingratio-n6/leachingratio*leachingratio_tl
  Nim=(s5-s4)*etac*C4/taun4
  Nim_tl=(s5_tl-s4_tl)*etac*C4/taun4+(s5-s4)*(etac_tl*C4+etac*C4_tl)/taun4-Nim/taun4*taun4_tl
  Nmin1=(1.-f4-etac)*s4*C4/taun4
  Nmin1_tl=(-f4_tl-etac_tl)*s4*C4/taun4+(1.-f4-etac)*(s4_tl*C4+s4*C4_tl)/taun4-Nmin1/taun4*taun4_tl
  Nmin2=(1.-f5)*s5*C5/tau5
  Nmin2_tl=(-f5_tl)*s5*C5/tau5+(1.-f5)*(s5_tl*C5+s5*C5_tl)/tau5-Nmin2/tau5*tau5_tl
  # Phosphorus
  l4=(l1*(1.-tht1)*mort1+l2*(1.-tht2)*mort2)/(mort1+mort2)
  l4_tl=((l1_tl*(1.-tht1)-l1*tht1_tl)*mort1+l1*(1.-tht1)*mort1_tl\
        +(l2_tl*(1.-tht2)-l2*tht2_tl)*mort2+l2*(1.-tht2)*mort2_tl)/(mort1+mort2)\
        -l4/(mort1+mort2)*(mort1_tl+mort2_tl)
  Fp1=l1*(mort1*(1.-tht1)+fire1)
  Fp1_tl=l1_tl*(mort1*(1.-tht1)+fire1)+l1*(mort1_tl*(1.-tht1)-mort1*tht1_tl+fire1_tl)
  Fp2=l2*(mort2*(1.-tht2)+fire2)
  Fp2_tl=l2_tl*(mort2*(1.-tht2)+fire2)+l2*(mort2_tl*(1.-tht2)-mort2*tht2_tl+fire2_tl)
  Fp3=0.
  Fp3_tl=0.*l3_tl
  Fp=Fp1+Fp2
  Fp_tl=Fp1_tl+Fp2_tl
  phi1=Fp1/Fp
  phi1_tl=Fp1_tl/Fp-phi1/Fp*Fp_tl
  phi2=1.-phi1
  phi2_tl=-phi1_tl
  phi3=1.-phi1-phi2
  phi3_tl=-phi1_tl-phi2_tl
  FireP=l1*fire1+l2*fire2+l4*fire4+l5*fire5
  FireP_tl=l1_tl*fire1+l1*fire1_tl+l2_tl*fire2+l2*fire2_tl+l4_tl*fire4+l4*fire4_tl+l5_tl*fire5+l5*fire5_tl
  taup4=tau4
  taup4_tl=tau4_tl
  lossp6=leachingratio*dissfrac+fsorb
  lossp6_tl=leachingratio_tl*dissfrac+leachingratio*dissfrac_tl+fsorb_tl
  p6=(Pw+Pd-FireP*(1.-fashP))/lossp6
  p6_tl=(Pw_tl+Pd_tl-FireP_tl*(1.-fashP)+FireP*fashP_tl)/lossp6-p6/lossp6*lossp6_tl
  Pim=(l5-l4)*etac*C4/taup4
  Pim_tl=(l5_tl-l4_tl)*etac*C4/taup4+(l5-l4)*(etac_tl*C4+etac*C4_tl)/taup4-Pim/taup4*taup4_tl
  Pmin1=(1.-f4-etac)*l4*C4/taup4
  Pmin1_tl=(-f4_tl-etac_tl)*l4*C4/taup4+(1.-f4-etac)*(l4_tl*C4+l4*C4_tl)/taup4-Pmin1/taup4*taup4_tl
  Pmin2=(1.-f5)*l5*C5/tau5
  Pmin2_tl=(-f5_tl)*l5*C5/tau5+(1.-f5)*(l5_tl*C5+l5*C5_tl)/tau5-Pmin2/tau5*tau5_tl

  NP1=s1/l1
  NP1_tl=s1_tl/l1-NP1/l1*l1_tl
  NP2=s2/l2
  NP2_tl=s2_tl/l2-NP2/l2*l2_tl
  NP3=0.
  NP3_tl=0.*s3_tl
  NP4=s4/l4
  NP4_tl=s4_tl/l4-NP4/l4*l4_tl
  NP5=s5/l5
  NP5_tl=s5_tl/l5-NP5/l5*l5_tl
  taun1=s1*C1/Fn1
  taun1_tl=(s1_tl*C1+s1*C1_tl)/Fn1-taun1/Fn1*Fn1_tl
  taunbio=(s1*C1+s2*C2)/Fn
  taunbio_tl=(s1_tl*C1+s1*C1_tl+s2_tl*C2+s2*C2_tl)/Fn-taunbio/Fn*Fn_tl
  taun6=n6/(Nd+Nfix+Nmin1+Nmin2)
  taun6_tl=n6_tl/(Nd+Nfix+Nmin1+Nmin2)-taun6/(Nd+Nfix+Nmin1+Nmin2)*(Nd_tl+Nfix_tl+Nmin1_tl+Nmin2_tl)
  NUE=gpp/Fn
  NUE_tl=gpp_tl/Fn-NUE/Fn*Fn_tl
  taup1=l1*C1/Fp1
  taup1_tl=(l1_tl*C1+l1*C1_tl)/Fp1-taup1/Fp1*Fn1_tl
  taupbio=(l1*C1+l2*C2)/Fp
  taupbio_tl=(l1_tl*C1+l1*C1_tl+l2_tl*C2+l2*C2_tl)/Fp-taupbio/Fp*Fp_tl
  taup6=p6/(Pd+Pw+Pmin1+Pmin2+FireP*fashP)
  taup6_tl=p6_tl/(Pd+Pw+Pmin1+Pmin2+FireP*fashP)-taup6/(Pd+Pw+Pmin1+Pmin2+FireP*fashP)*(Pd_tl+Pw_tl+Pmin1_tl+Pmin2_tl+FireP_tl*fashP+FireP*fashP_tl)
  PUE=gpp/Fp
  PUE_tl=gpp_tl/Fp-PUE/Fp*Fp_tl
  OpenN=(Nd+Nfix)/(gpp*gam1*s1+gpp*gam2*s2)
  OpenN_tl=(Nd_tl+Nfix_tl)/(gpp*gam1*s1+gpp*gam2*s2)\
          -OpenN/(gpp*gam1*s1+gpp*gam2*s2)*(gpp_tl*(gam1*s1+gam2*s2)+gpp*(gam1_tl*s1+gam1*s1_tl+gam2_tl*s2+gam2*s2_tl))
  OpenP=(Pd+Pw)/(gpp*gam1*l1+gpp*gam2*l2)
  OpenP_tl=(Pd_tl+Pw_tl)/(gpp*gam1*l1+gpp*gam2*l2)\
          -OpenP/(gpp*gam1*l1+gpp*gam2*l2)*(gpp_tl*(gam1*l1+gam2*l2)+gpp*(gam1_tl*l1+gam1*l1_tl+gam2_tl*l2+gam2*l2_tl))
  RTN=(s1*C1+s2*C2+s4*C4+s5*C5)/(Nd+Nfix)
  RTN_tl=(s1_tl*C1+s1*C1_tl+s2_tl*C2+s2*C2_tl+s4_tl*C4+s4*C4_tl+s5_tl*C5+s5*C5_tl)/(Nd+Nfix)-RTN/(Nd+Nfix)*(Nd_tl+Nfix_tl)
  RTP=(l1*C1+l2*C2+l4*C4+l5*C5)/(Pd+Pw)
  RTP_tl=(l1_tl*C1+l1*C1_tl+l2_tl*C2+l2*C2_tl+l4_tl*C4+l4*C4_tl+l5_tl*C5+l5*C5_tl)/(Pd+Pw)-RTP/(Pd+Pw)*(Pd_tl+Pw_tl)

  H=np.array([C1_tl,C2_tl,C3_tl,C4_tl,C5_tl,Fn_tl,s4_tl,taun4_tl,bet1_tl,bet2_tl,bet3_tl,n6_tl,Nim_tl,Nmin1_tl,Nmin2_tl,\
              Fp_tl,l4_tl,taup4_tl,phi1_tl,phi2_tl,phi3_tl,p6_tl,Pim_tl,Pmin1_tl,Pmin2_tl,\
              FireC_tl,FireN_tl,FireP_tl,NP1_tl,NP2_tl,NP3_tl,NP4_tl,NP5_tl,\
              taun1_tl,taunbio_tl,taun6_tl,taup1_tl,taupbio_tl,taup6_tl,NUE_tl,PUE_tl,OpenN_tl,OpenP_tl,RTN_tl,RTP_tl])
  sigma=np.dot(np.dot(H,B),H.T)

  return np.array([C1,C2,C3,C4,C5,Fn,s4,taun4,bet1,bet2,bet3,n6,Nim,Nmin1,Nmin2,\
                   Fp,l4,taup4,phi1,phi2,phi3,p6,Pim,Pmin1,Pmin2,\
                   FireC,FireN,FireP,NP1,NP2,NP3,NP4,NP5,\
                   taun1,taunbio,taun6,taup1,taupbio,taup6,NUE,PUE,OpenN,OpenP,RTN,RTP]),H,sigma

